/*
 * Decompiled with CFR 0.152.
 */
package ibase.hibernate.bean;

import ibase.hibernate.utility.HibernateUtil;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONException;
import org.json.JSONObject;

@Indexed
@Entity
@Table(name="TASKS")
@XmlRootElement(name="Tasks")
public class Task
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Field(store=Store.YES, analyze=Analyze.NO)
    @Column(name="TASK_ID")
    private String taskId;
    @Id
    @Field(store=Store.YES, analyze=Analyze.NO)
    @Column(name="REF_SER")
    private String refSer;
    @Id
    @Field(store=Store.YES, analyze=Analyze.NO)
    @Column(name="REF_ID")
    private String refId;
    @Column(name="DESCR")
    private String descr;
    @Column(name="SH_DESCR")
    private String shDescr;
    @Column(name="USER_ID__ASSIGN")
    private String userIdAsg;
    @Column(name="USER_ID__OWN")
    private String userIdOwn;
    @Column(name="DUE_DATE")
    private Date dueDate;
    @Column(name="TASK_TYPE")
    private String taskType;
    @Column(name="TASK_STATUS")
    private String taskStat;
    @Column(name="STATUS_DATE")
    private Date statDate;
    @Column(name="ADD_DATE")
    private Date addDate;
    @Column(name="ADD_USER")
    private String addUser;
    @Column(name="ADD_TERM")
    private String addTerm;
    @Column(name="CHG_USER")
    private String chgUser;
    @Column(name="CHG_TERM")
    private String chgTerm;
    @Column(name="CHG_DATE")
    private Date chgDate;
    @Transient
    private String refSerDescr;

    public String getTaskId() {
        return this.taskId;
    }

    @XmlElement
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getRefSer() {
        return this.refSer;
    }

    @XmlElement
    public void setRefSer(String refSer) {
        this.refSer = refSer;
    }

    public String getRefId() {
        return this.refId;
    }

    @XmlElement
    public void setRefId(String refId) {
        this.refId = refId;
    }

    public String getDescr() {
        return this.descr;
    }

    @XmlElement
    public void setDescr(String descr) {
        this.descr = descr;
    }

    public String getShDescr() {
        return this.shDescr;
    }

    @XmlElement
    public void setShDescr(String shDescr) {
        this.shDescr = shDescr;
    }

    public String getUserIdAsg() {
        return this.userIdAsg;
    }

    @XmlElement
    public void setUserIdAsg(String userIdAsg) {
        this.userIdAsg = userIdAsg;
    }

    public String getUserIdOwn() {
        return this.userIdOwn;
    }

    @XmlElement
    public void setUserIdOwn(String userIdOwn) {
        this.userIdOwn = userIdOwn;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    @XmlElement
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getTaskType() {
        return this.taskType;
    }

    @XmlElement
    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getTaskStat() {
        return this.taskStat;
    }

    @XmlElement
    public void setTaskStat(String taskStat) {
        this.taskStat = taskStat;
    }

    public Date getStatDate() {
        return this.statDate;
    }

    @XmlElement
    public void setStatDate(Date statDate) {
        this.statDate = statDate;
    }

    public Date getAddDate() {
        return this.addDate;
    }

    @XmlElement
    public void setAddDate(Date addDate) {
        this.addDate = addDate;
    }

    public String getAddUser() {
        return this.addUser;
    }

    @XmlElement
    public void setAddUser(String addUser) {
        this.addUser = addUser;
    }

    public String getAddTerm() {
        return this.addTerm;
    }

    @XmlElement
    public void setAddTerm(String addTerm) {
        this.addTerm = addTerm;
    }

    public String getChgUser() {
        return this.chgUser;
    }

    @XmlElement
    public void setChgUser(String chgUser) {
        this.chgUser = chgUser;
    }

    public String getChgTerm() {
        return this.chgTerm;
    }

    @XmlElement
    public void setChgTerm(String chgTerm) {
        this.chgTerm = chgTerm;
    }

    public Date getChgDate() {
        return this.chgDate;
    }

    @XmlElement
    public void setChgDate(Date chgDate) {
        this.chgDate = chgDate;
    }

    public String getRefSerDescr() {
        return this.refSerDescr;
    }

    public void setRefSerDescr(String refSerDescr) {
        this.refSerDescr = refSerDescr;
    }

    public void toTask(JSONObject taskData, String loginCode) throws JSONException {
        this.setDescr(this.getFieldValue(taskData, "descr"));
        this.setShDescr(this.getFieldValue(taskData, "shDescr"));
        this.setUserIdAsg(this.getFieldValue(taskData, "userIdAsg"));
        this.setDueDate(this.getDateFieldValue(taskData, "dueDate"));
        this.setTaskType(this.getFieldValue(taskData, "taskType"));
        this.setTaskStat(this.getFieldValue(taskData, "taskStat"));
        this.setStatDate(this.getDateFieldValue(taskData, "statDate"));
        this.setChgUser(loginCode);
        this.setChgDate(new Date());
    }

    private String getFieldValue(JSONObject taskData, String key) throws JSONException {
        if (taskData.has(key)) {
            return taskData.getString(key);
        }
        return "";
    }

    private Date getDateFieldValue(JSONObject addressData, String key) throws JSONException {
        String dateStr = addressData.getString(key);
        Date date = null;
        if (dateStr != null) {
            dateStr = HibernateUtil.getValidAPPL2DBDate(addressData.getString(key));
            date = HibernateUtil.getDateObject(dateStr, HibernateUtil.DB_DATE_FORMAT);
        }
        return date;
    }
}

