/*
 * Decompiled with CFR 0.152.
 */
package ibase.scheduler.utility;

import ibase.scheduler.utility.ScheduleUtility;
import ibase.utility.ApplicationMetadata;
import ibase.utility.ApplicationParams;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScheduleModel
implements Serializable {
    private String scheduleId;
    private String name;
    private String startDate;
    private String excludeStartDay;
    private String excludeEndDay;
    private String excludeStartTime;
    private String excludeEndTime;
    private String startTime;
    private String interval;
    private String scheduleSeq;
    private String exceptionType;
    private String criteria;
    private String debugMode;
    private String schType;
    private String type;
    private String lookupName;
    private String className;
    private String objectName;
    private String status = "C";
    private String owner;
    private String owner_type;
    private String lastSchFireOn;
    private String nextDueDate;
    private ArrayList activitiesList = new ArrayList();
    private String userInfo = "";
    private String scheduleInfo = "";
    private String runMode = "";
    private String busiEvent = "";
    private ArrayList actParamList = new ArrayList();
    public HashMap<String, String> actParamMap = new HashMap();

    public HashMap<String, String> getactParamMap() {
        return this.actParamMap;
    }

    public ScheduleModel() {
    }

    public ScheduleModel(String scheduleModelStr) throws BaseException {
        this(new E12GenericUtility().parseString(scheduleModelStr));
    }

    public ScheduleModel(Document scheduleModelDom) throws BaseException {
        try {
            BaseLogger.log("3", null, null, "SCHEDULE_MODEL::" + scheduleModelDom.toString());
            E12GenericUtility genericUtility = new E12GenericUtility();
            NodeList rootNodeList = scheduleModelDom.getElementsByTagName("SCHEDULE");
            BaseLogger.log("3", null, null, "RootNodeList::-" + rootNodeList.toString());
            Node rootNode = rootNodeList.item(0);
            if (rootNode.getAttributes() != null && rootNode.getAttributes().getNamedItem("id") != null) {
                this.setScheduleId(rootNode.getAttributes().getNamedItem("id").getNodeValue());
            }
            if (rootNode.getAttributes() != null && rootNode.getAttributes().getNamedItem("schtype") != null) {
                String schType = rootNode.getAttributes().getNamedItem("schtype").getNodeValue();
                this.setSchType(schType);
                if (schType.trim().length() == 0) {
                    this.setSchType("OTHER");
                }
            } else {
                this.setSchType("OTHER");
            }
            NodeList schldNodePropList = rootNodeList.item(0).getChildNodes();
            BaseLogger.log("3", null, null, "ScheduleModel.schldNodePropList-->[" + schldNodePropList + "]");
            int noOfSchldProp = schldNodePropList.getLength();
            int schldCtr = 0;
            while (schldCtr < noOfSchldProp) {
                Node schldPropNode = schldNodePropList.item(schldCtr);
                BaseLogger.log("3", null, null, "nilesh::" + genericUtility.serializeDom(schldPropNode));
                if (schldPropNode != null && schldPropNode.getFirstChild() != null) {
                    String schldPropName = schldPropNode.getNodeName();
                    BaseLogger.log("3", null, null, "schldPropName::" + schldPropName);
                    if ("NAME".equals(schldPropName)) {
                        this.setName(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("SCHEDULEINFO".equals(schldPropName)) {
                        this.setScheduleInfo(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("START_DATE".equals(schldPropName)) {
                        this.setStartDate(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("START_TIME".equals(schldPropName)) {
                        this.setStartTime(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("EXCLUDE_START_DAY".equals(schldPropName)) {
                        this.setExcludeStartDay(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("EXCLUDE_END_DAY".equals(schldPropName)) {
                        this.setExcludeEndDay(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("EXCLUDE_START_TIME".equals(schldPropName)) {
                        this.setExcludeStartTime(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("EXCLUDE_END_TIME".equals(schldPropName)) {
                        this.setExcludeEndTime(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("LAST_SCH_FIRE_ON".equals(schldPropName)) {
                        this.setLastSchFireOn(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("NEXT_DUE_DATE".equals(schldPropName)) {
                        this.setNextDueDate(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("INTERVAL".equals(schldPropName)) {
                        this.setInterval(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("SCHEDULE_SEQ".equals(schldPropName)) {
                        this.setScheduleSeq(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("EXCEPTION_TYPE".equals(schldPropName)) {
                        this.setExceptionType(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("CRITERIA".equals(schldPropName)) {
                        this.setCriteria(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("DEBUG_MODE".equals(schldPropName)) {
                        this.setDebugMode(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("STATUS".equals(schldPropName)) {
                        this.setStatus(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("OWNER".equals(schldPropName)) {
                        this.setOwner(schldPropNode.getFirstChild().getNodeValue());
                        this.setOwner_type(schldPropNode.getAttributes().getNamedItem("TYPE").getNodeValue());
                    } else if ("USERINFOXML".equals(schldPropName)) {
                        String str = new E12GenericUtility().serializeDom(schldPropNode.getChildNodes().item(0));
                        this.setUserInfo(str);
                    } else if ("RUNMODE".equals(schldPropName)) {
                        this.setRunMode(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("BUSI_EVENT".equals(schldPropName)) {
                        this.setBusiEvent(schldPropNode.getFirstChild().getNodeValue());
                    } else if ("SCHEDULE_OBJ".equals(schldPropName)) {
                        NodeList schldNodeActualParam = schldNodePropList.item(schldCtr).getChildNodes().item(0).getChildNodes();
                        int noOfSchldparam = schldNodeActualParam.getLength();
                        BaseLogger.log("9", null, null, "Actual Parameter Length-------[" + noOfSchldparam + "]------");
                        String scheduleObjName = "";
                        if (schldPropNode.getAttributes() != null && schldPropNode.getAttributes().getNamedItem("name") != null) {
                            scheduleObjName = schldPropNode.getAttributes().getNamedItem("name").getNodeValue();
                        }
                        BaseLogger.log("9", null, null, "scheduleObjName [" + scheduleObjName + "]");
                        String nodeName = "";
                        String nodeValue = "";
                        int Ctr = 0;
                        while (Ctr < noOfSchldparam) {
                            Node schldParamNode = schldNodeActualParam.item(Ctr);
                            if (schldParamNode != null && schldParamNode.getFirstChild() != null) {
                                NodeList nodeList = scheduleModelDom.getElementsByTagName("ACTUALPARAMETER");
                                BaseLogger.log("3", null, null, "nodeList::" + nodeList.getLength());
                                if ("Report Schedule".equalsIgnoreCase(scheduleObjName) || "Schedule Visuals".equalsIgnoreCase(scheduleObjName)) {
                                    NodeList argumentsList;
                                    NodeList scheRootNodeList = scheduleModelDom.getElementsByTagName("Root");
                                    if (scheRootNodeList.getLength() > 0 && (argumentsList = scheduleModelDom.getElementsByTagName("Arguments")).getLength() > 0) {
                                        String arguementsXmlData = genericUtility.serializeDom(scheRootNodeList.item(0));
                                        this.actParamMap.put("REPORT_ARG_XML", arguementsXmlData);
                                        this.actParamList.add(arguementsXmlData);
                                        if (scheduleModelDom.getElementsByTagName("trans_db").item(0) != null && scheduleModelDom.getElementsByTagName("trans_db").item(0).getFirstChild() != null) {
                                            String transDb = scheduleModelDom.getElementsByTagName("trans_db").item(0).getFirstChild().getNodeValue();
                                            BaseLogger.log("3", null, null, "Sunny----TRANS_DB:: [ " + transDb + " ]");
                                            this.actParamMap.put("TRANS_DB", transDb);
                                        }
                                    }
                                } else {
                                    int i = 0;
                                    while (i < nodeList.getLength()) {
                                        Node childNode = nodeList.item(i);
                                        BaseLogger.log("3", null, null, "childNode getNodeName:: [" + childNode.getNodeName() + "]");
                                        if (childNode.getNodeType() == 1 && childNode != null) {
                                            if (genericUtility.serializeDom(childNode).contains("name")) {
                                                nodeName = this.getAttributeVal(childNode);
                                            }
                                            BaseLogger.log("3", null, null, "nodeName" + nodeName);
                                            if (childNode.getFirstChild() != null && nodeName != null) {
                                                nodeValue = childNode.getFirstChild().getNodeValue();
                                                BaseLogger.log("3", null, null, "nodeValue" + nodeValue);
                                                this.actParamMap.put(nodeName, nodeValue);
                                            }
                                        }
                                        ++i;
                                    }
                                    BaseLogger.log("3", null, null, "actParamMap:::::" + this.actParamMap);
                                    if (schldParamNode.getNodeName() != null && !schldParamNode.getNodeName().equalsIgnoreCase("#text")) {
                                        this.actParamList.add(schldParamNode.getFirstChild().getNodeValue());
                                        BaseLogger.log("3", null, null, "actParamList in ::" + this.actParamList);
                                        BaseLogger.log("3", null, null, "actParamMap in:::::" + this.actParamMap);
                                    }
                                }
                            } else {
                                this.actParamList.add("null");
                                this.actParamMap.put(null, null);
                            }
                            ++Ctr;
                        }
                    }
                }
                ++schldCtr;
            }
            NodeList schldObjList = scheduleModelDom.getElementsByTagName("SCHEDULE_OBJ");
            int noOfSchldObj = schldObjList.getLength();
            BaseLogger.log("3", null, null, "noOfSchldObj::[ " + noOfSchldObj + " ]");
            int schCtr = 0;
            while (schCtr < noOfSchldObj) {
                Node schldObj = schldObjList.item(schCtr);
                BaseLogger.log("3", null, null, "schldObj::[ " + schldObj.getNodeName() + " ]");
                if (schldObj.getAttributes() != null && schldObj.getAttributes().getNamedItem("name") != null) {
                    ApplicationParams appParam = this.populateApplnParams(schldObj);
                    BaseLogger.log("3", null, null, "appParam [" + schCtr + "] ::[ " + appParam + " ]");
                    this.activitiesList.add(appParam);
                } else if (schldObj.getAttributes() != null && schldObj.getAttributes().getNamedItem("name") == null) {
                    NodeList schldObjChildList = schldObj.getChildNodes();
                    int schldObjLen = schldObjChildList.getLength();
                    int schldObjCtr = 0;
                    while (schldObjCtr < schldObjLen) {
                        Node objNode = schldObjChildList.item(schldObjCtr);
                        if (objNode != null && objNode.getFirstChild() != null) {
                            String schldName = objNode.getNodeName();
                            if ("TYPE".equals(schldName)) {
                                this.setType(objNode.getFirstChild().getNodeValue());
                            } else if ("LOOKUP_NAME".equals(schldName)) {
                                this.setLookupName(objNode.getFirstChild().getNodeValue());
                            } else if ("CLASS_NAME".equals(schldName)) {
                                this.setClassName(objNode.getFirstChild().getNodeValue());
                            }
                        }
                        ++schldObjCtr;
                    }
                    this.activitiesList.add(new E12GenericUtility().serializeDom(schldObj));
                }
                ++schCtr;
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    private void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setOwner(String owner) {
        this.owner = owner;
    }

    private void setOwner_type(String owner_type) {
        this.owner_type = owner_type;
    }

    private void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    private void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setLastSchFireOn(String lastSchFireOn) {
        this.lastSchFireOn = lastSchFireOn;
    }

    private void setExcludeStartDay(String excludeStartDay) {
        this.excludeStartDay = excludeStartDay;
    }

    private void setExcludeEndDay(String excludeEndDay) {
        this.excludeEndDay = excludeEndDay;
    }

    private void setExcludeStartTime(String excludeStartTime) {
        this.excludeStartTime = excludeStartTime;
    }

    private void setExcludeEndTime(String excludeEndTime) {
        this.excludeEndTime = excludeEndTime;
    }

    public void setNextDueDate(String nextDueDate) {
        this.nextDueDate = nextDueDate;
    }

    private void setInterval(String interval) {
        this.interval = interval;
    }

    private void setScheduleSeq(String scheduleSeq) {
        this.scheduleSeq = scheduleSeq;
    }

    private void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    private void setCriteria(String criteria) {
        this.criteria = criteria;
    }

    private void setDebugMode(String debugMode) {
        this.debugMode = debugMode;
    }

    private void setType(String type) {
        this.type = type;
    }

    private void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    private void setClassName(String className) {
        this.className = className;
    }

    public void setStatus(String status) {
        this.status = status != null ? status : "C";
    }

    private void setSchType(String schType) {
        this.schType = schType;
    }

    public void addActivitiesList(ApplicationParams appParams) {
        this.activitiesList.add(appParams);
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public void setScheduleInfo(String scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
    }

    private void setRunMode(String runMode) {
        this.runMode = runMode;
    }

    public void setBusiEvent(String busiEvent) {
        this.busiEvent = busiEvent;
    }

    public String getBusiEvent() {
        return this.busiEvent;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getLastSchFireOn() {
        return this.lastSchFireOn;
    }

    public String getExcludeStartDay() {
        return this.excludeStartDay;
    }

    public String getExcludeEndDay() {
        return this.excludeEndDay;
    }

    public String getExcludeStartTime() {
        return this.excludeStartTime;
    }

    public String getExcludeEndTime() {
        return this.excludeEndTime;
    }

    public String getNextDueDate() {
        return this.nextDueDate;
    }

    public String getInterval() {
        return this.interval;
    }

    public String getScheduleSeq() {
        return this.scheduleSeq;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String getCriteria() {
        return this.criteria;
    }

    public String getDebugMode() {
        return this.debugMode;
    }

    public String getType() {
        return this.type;
    }

    public String getLookupName() {
        return this.lookupName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getType(String activityId) {
        int actsize = this.activitiesList.size();
        String type = "";
        ApplicationParams appParams = null;
        int actCtr = 0;
        while (actCtr < actsize) {
            appParams = (ApplicationParams)this.activitiesList.get(actCtr);
            if (appParams.getApplnId().equals(activityId)) {
                type = appParams.getApplnType();
            }
            ++actCtr;
        }
        return type;
    }

    public String getLookupName(String activityId) {
        return this.getClassName(activityId);
    }

    public String getClassName(String activityId) {
        int actsize = this.activitiesList.size();
        String className = "";
        ApplicationParams appParams = null;
        int actCtr = 0;
        while (actCtr < actsize) {
            appParams = (ApplicationParams)this.activitiesList.get(actCtr);
            if (appParams.getApplnId().equals(activityId)) {
                className = appParams.getCompName();
            }
            ++actCtr;
        }
        return className;
    }

    public String getStatus() {
        return this.status;
    }

    public ArrayList getActivitiesList() {
        return this.activitiesList;
    }

    public String getSchType() {
        return this.schType;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getScheduleInfo(String scheduleInfo) {
        return this.scheduleInfo;
    }

    public String getRunMode() {
        return this.runMode;
    }

    public String getPropValue(String propName) {
        String propValue = "";
        if (propName.equalsIgnoreCase("schedule_Id")) {
            propValue = this.scheduleId;
        } else if (propName.equalsIgnoreCase("name")) {
            propValue = this.name;
        } else if (propName.equalsIgnoreCase("owner")) {
            propValue = this.owner;
        } else if (propName.equalsIgnoreCase("owner_type")) {
            propValue = this.owner_type;
        } else if (propName.equalsIgnoreCase("start_Date")) {
            propValue = this.startDate;
        } else if (propName.equalsIgnoreCase("exclude_start_day")) {
            propValue = this.excludeStartDay;
        } else if (propName.equalsIgnoreCase("exclude_end_day")) {
            propValue = this.excludeEndDay;
        } else if (propName.equalsIgnoreCase("exclude_start_time")) {
            propValue = this.excludeStartTime;
        } else if (propName.equalsIgnoreCase("exclude_end_time")) {
            propValue = this.excludeEndTime;
        } else if (propName.equalsIgnoreCase("start_Time")) {
            propValue = this.startTime;
        } else if (propName.equalsIgnoreCase("last_sch_fire_on")) {
            propValue = this.lastSchFireOn;
        } else if (propName.equalsIgnoreCase("next_due_date")) {
            propValue = this.nextDueDate;
            BaseLogger.log("3", null, null, "ScheduleModel.next_due_date.value --[" + propValue + "]");
        } else if (propName.equalsIgnoreCase("interval")) {
            propValue = this.interval;
        } else if (propName.equalsIgnoreCase("schedule_Seq")) {
            propValue = this.scheduleSeq;
        } else if (propName.equalsIgnoreCase("exception_Type")) {
            propValue = this.exceptionType;
        } else if (propName.equalsIgnoreCase("criteria")) {
            propValue = this.criteria;
        } else if (propName.equalsIgnoreCase("debug_Mode")) {
            propValue = this.debugMode;
        } else if (propName.equalsIgnoreCase("schType")) {
            propValue = this.schType;
        } else if (propName.equalsIgnoreCase("userinfoxml")) {
            propValue = this.userInfo;
        } else if (propName.equalsIgnoreCase("scheduleInfo")) {
            propValue = this.scheduleInfo;
        } else if (propName.equalsIgnoreCase("runmode")) {
            propValue = this.runMode;
        } else if (propName.equalsIgnoreCase("busiEvent")) {
            propValue = this.busiEvent;
        }
        return propValue;
    }

    public String toString() {
        StringBuffer schldMdlStringBuf = new StringBuffer();
        schldMdlStringBuf.append(this.getGeneralString());
        int noOfActivities = this.activitiesList.size();
        ApplicationParams appParams = null;
        int actCtr = 0;
        while (actCtr < noOfActivities) {
            if (this.activitiesList.get(actCtr) instanceof ApplicationParams) {
                appParams = (ApplicationParams)this.activitiesList.get(actCtr);
                schldMdlStringBuf.append("<SCHEDULE_OBJ ");
                schldMdlStringBuf.append(" id= '");
                schldMdlStringBuf.append(appParams.getApplnId());
                schldMdlStringBuf.append("' name= '");
                schldMdlStringBuf.append(appParams.getApplnName());
                schldMdlStringBuf.append("' type= '");
                schldMdlStringBuf.append(appParams.getApplnType());
                schldMdlStringBuf.append("'>");
                schldMdlStringBuf.append("<ACTUALPARAMETERS>");
                BaseLogger.log("3", null, null, "appParams.getApplnName() [" + appParams.getApplnName() + "]");
                if ("Report Schedule".equalsIgnoreCase(appParams.getApplnName()) || "Schedule Visuals".equalsIgnoreCase(appParams.getApplnName())) {
                    schldMdlStringBuf.append("<ACTUALPARAMETER>");
                    if (this.actParamMap != null) {
                        schldMdlStringBuf.append(this.actParamMap.get("REPORT_ARG_XML"));
                    }
                    schldMdlStringBuf.append("</ACTUALPARAMETER>");
                } else {
                    ArrayList actualParamList = appParams.getParamList();
                    HashMap paramMap = null;
                    BaseLogger.log("3", null, null, "actualParamList :: Size ::[" + actualParamList.size() + "], actParamList :: Size ::[" + this.actParamList.size() + "]");
                    int paramCtr = 0;
                    while (paramCtr < actualParamList.size()) {
                        paramMap = (HashMap)actualParamList.get(paramCtr);
                        String dataType = (String)paramMap.get("PARAM_DATA_TYPE");
                        String paramName = (String)paramMap.get("PARAM_NAME");
                        schldMdlStringBuf.append("<ACTUALPARAMETER ");
                        schldMdlStringBuf.append(" type= '");
                        schldMdlStringBuf.append(dataType).append("'");
                        schldMdlStringBuf.append(" name= '");
                        schldMdlStringBuf.append(paramName);
                        schldMdlStringBuf.append("'>");
                        if (!dataType.equalsIgnoreCase("XML")) {
                            schldMdlStringBuf.append("<![CDATA[");
                            BaseLogger.log("3", null, null, " paramCtr :: [" + paramCtr + "]");
                            if (this.actParamList.size() > paramCtr) {
                                schldMdlStringBuf.append(this.actParamList.get(paramCtr));
                            }
                            schldMdlStringBuf.append("]]>");
                        } else {
                            BaseLogger.log("3", null, null, "Else condn paramCtr :: [" + paramCtr + "]");
                            if (this.actParamList.size() > paramCtr) {
                                schldMdlStringBuf.append(this.actParamList.get(paramCtr));
                            }
                        }
                        schldMdlStringBuf.append("</ACTUALPARAMETER>");
                        ++paramCtr;
                    }
                }
                schldMdlStringBuf.append("</ACTUALPARAMETERS>");
                schldMdlStringBuf.append("</SCHEDULE_OBJ>");
            } else {
                schldMdlStringBuf.append((String)this.activitiesList.get(actCtr));
            }
            ++actCtr;
        }
        schldMdlStringBuf.append("</SCHEDULE>");
        BaseLogger.log("3", null, null, "schldMdlStringBuf.toString()::" + schldMdlStringBuf.toString());
        return schldMdlStringBuf.toString();
    }

    public String toString(String stop) throws BaseException {
        StringBuffer schldMdlStringBuf = new StringBuffer();
        try {
            schldMdlStringBuf.append(this.getGeneralString());
            int noOfActivities = this.activitiesList.size();
            ApplicationParams appParams = null;
            int actCtr = 0;
            while (actCtr < noOfActivities) {
                if (this.activitiesList.get(actCtr) instanceof ApplicationParams) {
                    appParams = (ApplicationParams)this.activitiesList.get(actCtr);
                    schldMdlStringBuf.append("<SCHEDULE_OBJ ");
                    schldMdlStringBuf.append(" id= '");
                    schldMdlStringBuf.append(appParams.getApplnId());
                    schldMdlStringBuf.append("' name= '");
                    schldMdlStringBuf.append(appParams.getApplnName());
                    schldMdlStringBuf.append("' type= '");
                    schldMdlStringBuf.append(appParams.getApplnType());
                    schldMdlStringBuf.append("'>");
                    schldMdlStringBuf.append("<ACTUALPARAMETERS>");
                    BaseLogger.log("3", null, null, "For Stop appParams.getApplnName() [" + appParams.getApplnName() + "]");
                    if ("Report Schedule".equalsIgnoreCase(appParams.getApplnName()) || "Schedule Visuals".equalsIgnoreCase(appParams.getApplnName())) {
                        schldMdlStringBuf.append("<ACTUALPARAMETER>");
                        if (this.actParamMap != null) {
                            schldMdlStringBuf.append(this.actParamMap.get("REPORT_ARG_XML"));
                        }
                        schldMdlStringBuf.append("</ACTUALPARAMETER>");
                    } else {
                        ArrayList actualParamList = appParams.getParamList();
                        HashMap paramMap = null;
                        int paramCtr = 0;
                        while (paramCtr < actualParamList.size()) {
                            paramMap = (HashMap)actualParamList.get(paramCtr);
                            String dataType = (String)paramMap.get("PARAM_DATA_TYPE");
                            String paramName = (String)paramMap.get("PARAM_NAME");
                            schldMdlStringBuf.append("<ACTUALPARAMETER ");
                            schldMdlStringBuf.append(" type= '");
                            schldMdlStringBuf.append(dataType).append("'");
                            schldMdlStringBuf.append(" name= '");
                            schldMdlStringBuf.append(paramName);
                            schldMdlStringBuf.append("'>");
                            if (!dataType.equalsIgnoreCase("XML")) {
                                schldMdlStringBuf.append("<![CDATA[");
                                if (this.actParamList.size() > paramCtr) {
                                    schldMdlStringBuf.append(this.actParamList.get(paramCtr));
                                }
                                schldMdlStringBuf.append("]]>");
                            } else if (this.actParamList.size() > paramCtr) {
                                schldMdlStringBuf.append(this.actParamList.get(paramCtr));
                            }
                            schldMdlStringBuf.append("</ACTUALPARAMETER>");
                            ++paramCtr;
                        }
                    }
                    schldMdlStringBuf.append("</ACTUALPARAMETERS>");
                    schldMdlStringBuf.append("</SCHEDULE_OBJ>");
                } else {
                    String scheduleObjStr = (String)this.activitiesList.get(actCtr);
                    schldMdlStringBuf.append(this.getApplicationParamsStr(scheduleObjStr));
                }
                ++actCtr;
            }
            schldMdlStringBuf.append("</SCHEDULE>");
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        BaseLogger.log("3", null, null, "schldMdlStringBuf.toString()::" + schldMdlStringBuf.toString());
        return schldMdlStringBuf.toString();
    }

    private String getGeneralString() {
        StringBuffer schldMdlStringBuf = new StringBuffer();
        try {
            schldMdlStringBuf.append("<SCHEDULE");
            schldMdlStringBuf.append(" id= '");
            schldMdlStringBuf.append(this.scheduleId);
            schldMdlStringBuf.append("' schtype= '");
            schldMdlStringBuf.append(this.schType);
            schldMdlStringBuf.append("'>");
            schldMdlStringBuf.append("<NAME>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.name);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</NAME>");
            schldMdlStringBuf.append("<SCHEDULEINFO>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.scheduleInfo);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</SCHEDULEINFO>");
            schldMdlStringBuf.append("<OWNER ");
            schldMdlStringBuf.append(" TYPE='");
            schldMdlStringBuf.append(this.owner_type);
            schldMdlStringBuf.append("'>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.owner);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</OWNER>");
            schldMdlStringBuf.append("<START_DATE>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.startDate);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</START_DATE>");
            schldMdlStringBuf.append("<START_TIME>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.startTime);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</START_TIME>");
            schldMdlStringBuf.append("<EXCLUDE_START_DAY>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.excludeStartDay);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</EXCLUDE_START_DAY>");
            schldMdlStringBuf.append("<EXCLUDE_END_DAY>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.excludeEndDay);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</EXCLUDE_END_DAY>");
            schldMdlStringBuf.append("<EXCLUDE_START_TIME>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.excludeStartTime);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</EXCLUDE_START_TIME>");
            schldMdlStringBuf.append("<EXCLUDE_END_TIME>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.excludeEndTime);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</EXCLUDE_END_TIME>");
            schldMdlStringBuf.append("<LAST_SCH_FIRE_ON>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.lastSchFireOn);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</LAST_SCH_FIRE_ON>");
            schldMdlStringBuf.append("<NEXT_DUE_DATE>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.nextDueDate);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</NEXT_DUE_DATE>");
            schldMdlStringBuf.append("<INTERVAL>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.interval);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</INTERVAL>");
            schldMdlStringBuf.append("<SCHEDULE_SEQ>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.scheduleSeq);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</SCHEDULE_SEQ>");
            schldMdlStringBuf.append("<EXCEPTION_TYPE>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.exceptionType);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</EXCEPTION_TYPE>");
            schldMdlStringBuf.append("<CRITERIA>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.criteria);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</CRITERIA>");
            schldMdlStringBuf.append("<DEBUG_MODE>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.debugMode);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</DEBUG_MODE>");
            schldMdlStringBuf.append("<STATUS>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.status);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</STATUS>");
            schldMdlStringBuf.append("<USERINFOXML>");
            schldMdlStringBuf.append(this.userInfo);
            schldMdlStringBuf.append("</USERINFOXML>");
            schldMdlStringBuf.append("<RUNMODE>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.runMode);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</RUNMODE>");
            schldMdlStringBuf.append("<BUSI_EVENT>");
            schldMdlStringBuf.append("<![CDATA[");
            schldMdlStringBuf.append(this.busiEvent);
            schldMdlStringBuf.append("]]>");
            schldMdlStringBuf.append("</BUSI_EVENT>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return schldMdlStringBuf.toString();
    }

    public ApplicationParams populateApplnParams(Node schldObj) throws BaseException {
        ApplicationParams appParam = null;
        try {
            String activityName = null;
            String activityId = null;
            if (schldObj.getAttributes() != null && schldObj.getAttributes().getNamedItem("name") != null) {
                if (schldObj.getAttributes().getNamedItem("name").getFirstChild() != null) {
                    if (schldObj.getAttributes().getNamedItem("name").getFirstChild().getNodeValue() != null) {
                        activityName = schldObj.getAttributes().getNamedItem("name").getFirstChild().getNodeValue();
                        BaseLogger.log("3", null, null, "ScheduleModel.populateApplnParams.activityName-->[" + activityName + "]");
                    }
                } else {
                    activityName = schldObj.getAttributes().getNamedItem("name").getNodeValue();
                }
                appParam = new ApplicationMetadata().getAppParamsModel(activityName);
            }
            if (schldObj.getAttributes() != null && schldObj.getAttributes().getNamedItem("id") != null) {
                if (schldObj.getAttributes().getNamedItem("id").getFirstChild() != null) {
                    if (schldObj.getAttributes().getNamedItem("id").getFirstChild().getNodeValue() != null) {
                        activityId = schldObj.getAttributes().getNamedItem("id").getFirstChild().getNodeValue();
                    }
                } else {
                    activityId = schldObj.getAttributes().getNamedItem("id").getNodeValue();
                }
                if (appParam != null) {
                    appParam.setApplnId(activityId);
                }
                BaseLogger.log("3", null, null, "ScheduleModel.appParam-->[" + appParam + "]");
            }
            if (appParam != null) {
                appParam = (ApplicationParams)ScheduleUtility.getInstance().copy(appParam);
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return appParam;
    }

    public String getApplicationParamsStr(String activityStr) throws BaseException {
        StringBuffer schldMdlStringBuf = new StringBuffer();
        try {
            BaseLogger.log("3", null, null, "activityStr-->[" + activityStr + "]");
            Document schlObjDom = new E12GenericUtility().parseString(activityStr);
            String className = schlObjDom.getElementsByTagName("CLASS_NAME").item(0).getFirstChild().getNodeValue();
            ApplicationParams appParams = new ApplicationMetadata().getAppParamsModelFromClass(className);
            if (appParams == null) {
                throw new Exception("Activity is not defined in Application.xml");
            }
            Node paramsNodeList = schlObjDom.getElementsByTagName("PARAMS").item(0);
            NodeList paramsChild = paramsNodeList.getChildNodes();
            schldMdlStringBuf.append("<SCHEDULE_OBJ ");
            schldMdlStringBuf.append(" id= '");
            schldMdlStringBuf.append("oldAct");
            schldMdlStringBuf.append("' name= '");
            schldMdlStringBuf.append(appParams.getApplnName());
            schldMdlStringBuf.append("' type= '");
            schldMdlStringBuf.append(appParams.getApplnType());
            schldMdlStringBuf.append("'>");
            schldMdlStringBuf.append("<ACTUALPARAMETERS>");
            int ctr = 0;
            while (ctr < paramsChild.getLength()) {
                Node paramNode = paramsChild.item(ctr);
                if (paramNode.getFirstChild() != null) {
                    if (paramNode.getNodeType() == 1) {
                        schldMdlStringBuf.append("<ACTUALPARAMETER");
                        schldMdlStringBuf.append(" type= 'String'");
                        schldMdlStringBuf.append(">");
                        schldMdlStringBuf.append(paramNode.getFirstChild().getNodeValue());
                        schldMdlStringBuf.append("</ACTUALPARAMETER>");
                    }
                } else {
                    schldMdlStringBuf.append("<ACTUALPARAMETER></ACTUALPARAMETER>");
                }
                ++ctr;
            }
            schldMdlStringBuf.append("</ACTUALPARAMETERS>");
            schldMdlStringBuf.append("</SCHEDULE_OBJ>");
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return schldMdlStringBuf.toString();
    }

    private String getAttributeVal(Node childNode) throws ITMException {
        String attribFound = "";
        try {
            if (childNode != null && childNode.getAttributes() != null && childNode.getAttributes().getNamedItem("name") != null && childNode.getAttributes().getNamedItem("name").getNodeValue() != null) {
                attribFound = childNode.getAttributes().getNamedItem("name").getNodeValue();
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "attribFound = [" + attribFound + "]");
        return attribFound;
    }
}

