package ibase.webitm.ejb.wsfa.masters;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import javax.ejb.SessionContext;

import org.w3c.dom.Document;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

public class OrgStructurePrc extends ProcessEJB {

	SessionContext cSessionContext;
	protected static String database = CommonConstants.DB_NAME;
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	E12GenericUtility genericUtility = new E12GenericUtility();
	ValidatorEJB validatorEJB = new ValidatorEJB();

	public void setSessionContext(SessionContext mSessionContext) {
		try {
			CommonConstants.setIBASEHOME();
			ProcessEJB.DB_NAME = CommonConstants.DB_NAME;
			this.cSessionContext = mSessionContext;
		} catch (Exception e) {
			System.out.println("Exception :StockWizProcess :setSessionContext :==>" + e);
		}
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		Document dom = null;
		Document dom2 = null;
		String errString = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				dom = genericUtility.parseString(xmlString);
				System.out.println("dom [" + xmlString + "]");
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				dom2 = genericUtility.parseString(xmlString2);
				System.out.println("dom2 [" + xmlString2 + "]");
			}
			errString = process(dom, dom2, windowName, xtraParams);
		} catch (Exception e) {
			errString = genericUtility.createErrorString(e);
		}
		return errString;
	}

	public String process(Document dom, Document dom2, String windowName, String xtraParams)
			throws ITMException, RemoteException {
		System.out.println("In Process Method");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		SimpleDateFormat sdf = null;
		String retString = "", userId = "", employee2 = "", empCode1="";
		ArrayList<String> listOfEmployee2 = null, listOfEmployee3 = null, listOfEmployee4 = null,
				listOfEmployee5 = null;

		GenericUtility genericUtility = GenericUtility.getInstance();
		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();

		String chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
		Calendar currentDate = Calendar.getInstance();

		try {
			userId = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			conn = getConnection();
			InetAddress ownIP = InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String format = sdf.format(currentDate.getTime());
			String todayDate = genericUtility.getValidDateTimeString(format, genericUtility.getApplDateFormat(),
					genericUtility.getDBDateFormat());
			System.out.println("Today Date:- " + todayDate);

			String empCode = genericUtility.getColumnValue("emp_code", dom);
			Map<String, String> selectEmpData = selectEmpData(conn, pstmt, rs, empCode);
			if (!selectEmpData.isEmpty()) {
				empCode1 = saveEmployee(selectEmpData, chgTerm, chgUser, todayDate, conn, pstmt, rs);
			}
			System.out.println("First Employee to insert :- " + empCode1);
			ArrayList<String> listOfEmployee = listOfEmployee(empCode1, conn, pstmt, rs);
			System.out.println("First Array List 1st Employee:- " + listOfEmployee);
			for (String empccode : listOfEmployee) {

				Map<String, String> selectEmpData1 = selectEmpData(conn, pstmt, rs, empccode);
				System.out.println("Map 1st :- " + selectEmpData1);
				if (!selectEmpData1.isEmpty()) {
					employee2 = saveEmployee(selectEmpData1, chgTerm, chgUser, todayDate, conn, pstmt, rs);
					listOfEmployee2 = listOfEmployee(employee2, conn, pstmt, rs);
					for (String empcccode : listOfEmployee2) {
						Map<String, String> selectEmpData2 = selectEmpData(conn, pstmt, rs, empcccode);
						System.out.println("Map 2nd :- " + selectEmpData2);
						if (!selectEmpData2.isEmpty()) {
							String employee3 = saveEmployee(selectEmpData2, chgTerm, chgUser, todayDate, conn, pstmt,
									rs);
							listOfEmployee3 = listOfEmployee(employee3, conn, pstmt, rs);
							System.out.println("Third Array List:- " + listOfEmployee3);

							for (String empccccode : listOfEmployee3) {
								Map<String, String> selectEmpData3 = selectEmpData(conn, pstmt, rs, empccccode);
								System.out.println("Map 3rd :- " + selectEmpData3);
								if (!selectEmpData3.isEmpty()) {
									String employee4 = saveEmployee(selectEmpData3, chgTerm, chgUser, todayDate, conn,
											pstmt, rs);
									listOfEmployee4 = listOfEmployee(employee4, conn, pstmt, rs);
									System.out.println("Four Array List:- " + listOfEmployee4);

									for (String empcccccode : listOfEmployee4) {
										Map<String, String> selectEmpData4 = selectEmpData(conn, pstmt, rs,
												empcccccode);
										if (!selectEmpData4.isEmpty()) {
											System.out.println("Map 4th :- " + selectEmpData4);
											String employee5 = saveEmployee(selectEmpData4, chgTerm, chgUser, todayDate,
													conn, pstmt, rs);
											listOfEmployee5 = listOfEmployee(employee5, conn, pstmt, rs);
											System.out.println("Four Array List:- " + listOfEmployee5);

											for (String empccccccode : listOfEmployee5) {
												Map<String, String> selectEmpData5 = selectEmpData(conn, pstmt, rs,
														empccccccode);
												if (!selectEmpData4.isEmpty()) {
													System.out.println("Map 4th :- " + selectEmpData5);
													saveEmployee(selectEmpData5, chgTerm, chgUser, todayDate, conn,
															pstmt, rs);
												}
											}
										}
									}
								}

							}
						}
					}

				}
			}
		} catch (

		Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null) {

					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
				System.out.println("Excpetion closing" + e);
			}

		}
		retString = itmDBAccess.getErrorString("", "CONFSUCC", "", "", conn);
		return retString;
	}

	public String getSequenceNo(Connection conn, PreparedStatement pstmt, ResultSet rs) throws SQLException {
		int posCode = 0;
		String sqlString = "select ORG_POS_CODE.nextVal as posCode from dual";
		pstmt = conn.prepareStatement(sqlString);
		rs = pstmt.executeQuery();
		while (rs.next()) {
			posCode = rs.getInt("posCode");
		}
		if (rs != null) {
			rs.close();
			rs = null;
		}
		if (pstmt != null) {
			pstmt.close();
			pstmt = null;
		}
		String squence = String.format(String.format("%%0%dd", 10), posCode);
		System.out.println("Sequence Check" + squence);
		return squence;
	}

	public String saveEmployee(Map<String, String> hashMap, String chgTerm, String chgUser, String todayDate,
			Connection conn, PreparedStatement pstmt, ResultSet rs) throws SQLException, RemoteException, ITMException {
		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
		String retString = "";
		int levelNo = 4;
		String empCode = hashMap.get("empCode");
		String reportTo = getReportTo(empCode, conn, pstmt, rs);
		String posCodeRepto2 = getPosCodeRepto(reportTo, conn, pstmt, rs);
		String posCode = getSequenceNo(conn, pstmt, rs);
		String versionId = hashMap.get("versionId");
		String tableNo = hashMap.get("tableNo");
		String posCodeRepto = hashMap.get("posCodeRepto");
		String effDate = hashMap.get("effDate");
		String validUpto = hashMap.get("validUpto");
		String stanCodeHq = hashMap.get("stanCodeHq");
		String deptCode = hashMap.get("deptCode");
		String descr = hashMap.get("descr");
		
		if(!(hashMap.get("levelNo")==null)) {
			levelNo = Integer.parseInt(hashMap.get("levelNo"));
			
		}
		
		String errorString = "";
		String insertQuery = "INSERT INTO org_structure (VERSION_ID,TABLE_NO,POS_CODE,DESCR,SH_DESCR,POS_CODE__REPTO,EMP_CODE,LEVEL_NO,POOL_CODE,CHG_DATE,CHG_USER,CHG_TERM,EFF_DATE,VALID_UPTO,ACTIVE,STAN_CODE__HQ,PROC_GROUP,DEPT_CODE) VALUES "
				+ "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

		pstmt = conn.prepareStatement(insertQuery);
		pstmt.setString(1, versionId);
		pstmt.setString(2, tableNo);
		pstmt.setString(3, posCode);
		pstmt.setString(4, descr);
		pstmt.setString(5, descr);
		pstmt.setString(6, posCodeRepto2);
		pstmt.setString(7, empCode);
		pstmt.setInt(8, levelNo);
		pstmt.setString(9, posCode);

		pstmt.setTimestamp(10, java.sql.Timestamp.valueOf(todayDate));
		pstmt.setString(11, chgUser);
		pstmt.setString(12, chgTerm);
		if (hashMap.isEmpty()) {
			pstmt.setTimestamp(13, null);
			pstmt.setTimestamp(14, null);
		} else {
			pstmt.setTimestamp(13, java.sql.Timestamp.valueOf(effDate));
			pstmt.setTimestamp(14, java.sql.Timestamp.valueOf(validUpto));
		}
		pstmt.setString(15, "Y");
		pstmt.setString(16, stanCodeHq);
		pstmt.setString(17, "");
		pstmt.setString(18, deptCode);

		int rowsAffected = pstmt.executeUpdate();
		if (rs != null) {
			rs.close();
			rs = null;
		}
		if (pstmt != null) {
			pstmt.close();
			pstmt = null;
		}
		return empCode;
	}

	public Map<String, String> selectEmpData(Connection conn, PreparedStatement pstmt, ResultSet rs, String empCode)
			throws SQLException {
		String versionId = "", tableNo = "", posCodeRepto = "", effDate = "", validUpto = "", deptCode = "",
				stanCodeHq = "";
		Map<String, String> hashMap = new HashMap<>();
		String sql = "select version_id,table_no,pos_code__repto,eff_date,valid_upto,dept_code,stan_code__hq,level_no,descr from (select version_id as version_id FROM version WHERE valid_upto > trunc(sysdate)),\n"
				+ "(select item_ser as table_no from sales_pers where sales_pers =?),\n" + "(SELECT \n" + "CASE\n"
				+ "WHEN report_to IS NULL THEN NULL\n" + "ELSE report_to\n" + "END AS pos_code__repto\n"
				+ "FROM Employee where emp_code=?),(select date_join as eff_date,dept_code,stan_code__hq from employee where emp_code=?),\n"
				+ "(SELECT date_join + INTERVAL '10' YEAR AS valid_upto\n" + "FROM employee where emp_code=?),"
				+ "(select level_no from grade where grade_code=(select grade from employee where emp_code=?)),(select descr from station where stan_code=(select stan_code__hq from employee where emp_code=?))";

		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1, empCode);
		pstmt.setString(2, empCode);
		pstmt.setString(3, empCode);
		pstmt.setString(4, empCode);
		pstmt.setString(5, empCode);
		pstmt.setString(6, empCode);
		rs = pstmt.executeQuery();
		while (rs.next()) {
			versionId = rs.getString("version_id");
			tableNo = rs.getString("table_no");
			posCodeRepto = rs.getString("pos_code__repto");
			effDate = rs.getString("eff_date");
			validUpto = rs.getString("valid_upto");
			deptCode = rs.getString("dept_code");
			stanCodeHq = rs.getString("stan_code__hq");
			String levelNo = rs.getString("level_no");
			String descr = rs.getString("descr");
			hashMap.put("versionId", versionId);
			hashMap.put("tableNo", tableNo);
			hashMap.put("posCodeRepto", posCodeRepto);
			hashMap.put("effDate", effDate);
			hashMap.put("validUpto", validUpto);
			hashMap.put("deptCode", deptCode);
			hashMap.put("stanCodeHq", stanCodeHq);
			hashMap.put("empCode", empCode);
			hashMap.put("levelNo", levelNo);
			hashMap.put("descr", descr);

		}
		if (rs != null) {
			rs.close();
			rs = null;
		}
		if (pstmt != null) {
			pstmt.close();
			pstmt = null;
		}
		return hashMap;
	}

	public ArrayList<String> listOfEmployee(String employeeCode, Connection conn, PreparedStatement pstmt, ResultSet rs)
			throws SQLException {
		String sqlString = "select emp_code from employee where report_to=?";
		ArrayList<String> empList = new ArrayList<>();
		pstmt = conn.prepareStatement(sqlString);
		pstmt.setString(1, employeeCode);
		rs = pstmt.executeQuery();
		while (rs.next()) {
			String empCode = rs.getString("emp_code");
			empList.add(empCode);
		}
		System.out.println("Employee List In listOfEmployee Method :- " + empList);
		if (rs != null) {
			rs.close();
			rs = null;
		}
		if (pstmt != null) {
			pstmt.close();
			pstmt = null;
		}
		return empList;
	}

	public static String checkNull(String input) {
		if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
			input = "";
		}
		return input.trim();
	}

	public String getPosCodeRepto(String employeeCode, Connection conn, PreparedStatement pstmt, ResultSet rs)
			throws SQLException {
		String sqlString = "select pos_code from org_structure where emp_code=?";
		String posCodeRepto = "";
		pstmt = conn.prepareStatement(sqlString);
		pstmt.setString(1, employeeCode);
		rs = pstmt.executeQuery();
		while (rs.next()) {
			posCodeRepto = rs.getString("pos_code");
		}
		System.out.println("Employee List In listOfEmployee Method :- " + posCodeRepto);
		if (rs != null) {
			rs.close();
			rs = null;
		}
		if (pstmt != null) {
			pstmt.close();
			pstmt = null;
		}
		return posCodeRepto;
	}

	public String getReportTo(String employeeCode, Connection conn, PreparedStatement pstmt, ResultSet rs)
			throws SQLException {
		String sqlString = "select report_to from employee where emp_code=?";
		String reportTo = "";
		pstmt = conn.prepareStatement(sqlString);
		pstmt.setString(1, employeeCode);
		rs = pstmt.executeQuery();
		while (rs.next()) {
			reportTo = rs.getString("report_to");
		}
		System.out.println("Employee List In listOfEmployee Method :- " + reportTo);
		if (rs != null) {
			rs.close();
			rs = null;
		}
		if (pstmt != null) {
			pstmt.close();
			pstmt = null;
		}
		return reportTo;
	}
}
