/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import ibase.webitm.bean.DashboradComponent;
import ibase.webitm.bean.DashboradPage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParseProfile
extends DefaultHandler {
    private List<DashboradPage> tabdaos = new ArrayList<DashboradPage>();
    private DashboradPage tab = null;
    private DashboradComponent dashboardComp = null;
    private String tempVal;
    private String userId = null;
    private static final int DEAFULT_CELL_WIDTH = 200;
    private static final int DEAFULT_CELL_HEIGHT = 200;

    public ParseProfile(String userId) {
        this.userId = userId;
    }

    public boolean parse(File profileFile) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(profileFile, (DefaultHandler)this);
        return true;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        this.tempVal = "";
        if (name.equalsIgnoreCase("TAB")) {
            this.tab = new DashboradPage();
            this.tab.setUserId(this.userId);
        } else if (name.equalsIgnoreCase("SCREEN")) {
            this.dashboardComp = new DashboradComponent();
            this.dashboardComp.setUserId(this.userId);
            this.dashboardComp.setTabId(this.tab.getTabId());
        } else if (name.equalsIgnoreCase("POSITION")) {
            String x = attrs.getValue("X");
            String y = attrs.getValue("Y");
            if (x != null && !x.equals("")) {
                this.dashboardComp.setColumnNo(this.getColumnPosition(new Integer(x)));
            }
            if (y != null && !y.equals("")) {
                this.dashboardComp.setRowNo(this.getRowPosition(new Integer(y)));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equalsIgnoreCase("TAB")) {
            this.tabdaos.add(this.tab);
        } else if (name.equalsIgnoreCase("SCREEN")) {
            this.tab.addDashboardComp(this.dashboardComp);
        } else if (name.equalsIgnoreCase("TAB_TITLE")) {
            this.tab.setTitle(this.tempVal);
        } else if (name.equalsIgnoreCase("TAB_URI")) {
            this.tab.setUri(this.tempVal);
        } else if (name.equalsIgnoreCase("IMAGE")) {
            this.tab.setImageUri(this.tempVal);
        } else if (name.equalsIgnoreCase("TITLE")) {
            this.dashboardComp.setTitle(this.tempVal);
        } else if (name.equalsIgnoreCase("URI")) {
            this.dashboardComp.setUri(this.tempVal);
        } else if (name.equalsIgnoreCase("WIDTH")) {
            if (!this.tempVal.equals("")) {
                this.dashboardComp.setWidth(new Integer(this.tempVal));
            }
        } else if (name.equalsIgnoreCase("HEIGHT") && !this.tempVal.equals("")) {
            this.dashboardComp.setWidth(new Integer(this.tempVal));
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.tempVal = new String(buf, offset, len);
    }

    public List<DashboradPage> getTabdaos() {
        return this.tabdaos;
    }

    public void setTabdaos(List<DashboradPage> tabdaos) {
        this.tabdaos = tabdaos;
    }

    private int getColumnPosition(int xpos) {
        BaseLogger.log("2", null, null, "Y Pos:" + xpos + ", Col Pos:" + xpos / 200);
        return xpos / 200;
    }

    private int getRowPosition(int ypos) {
        BaseLogger.log("2", null, null, "X Pos:" + ypos + ", Row Pos:" + ypos / 200);
        return ypos / 200;
    }
}

