
package ibase.webitm.utility.wsfa;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

import javax.servlet.SingleThreadModel;

/**	
	Objective	:-	Don't use any Calendar or java.util.Date objects
	Assumption	:-	The date format for all the functions is dd-mon-yyyy.If you are using any 
						other format then you have to set the formatString using setFormatString()
						or set in the interface ConstantsInterface.java before calling any of the below 
						functions.
						
						Dont's: while setting the formatString dont give am/pm or AM/PM .If you want to 
						give the time just give MM/dd/yyyy hh:mm:ss. You can give am/pm while passing 
						the  time.ie u can give 2:30 AM in a function call.But not in the formatString.

		Note		:	All the functions use the same variables.So calling functions consequetively 
						is likely to change them.So it is suggested to retrieve the result before calling
						another function .
						For example 
						calling setCalendar() will set the calendar object 'calObject'.Now if u call
						getDatesBetweenCount() immediately after this,then calObject set previously will
						be lost.
						Or if atall you want to use the above functions consequetively ,use two different 
						objects of this class.

		Resuable Functions in a glance
		------------------------------
		1. void setFormatString(String)		: sets the date format
		2. void setTimeZone(String)			: sets the TimeZone
		3. void setCalendar()				: sets the calendar object
		4. String getDate()					: gives the date set in the setCalendar()
		5.String convertToFormat(
			String date,FormatString1,FormatString2): converts the date of formatString1 to formatString2
		6. int getMonthInt()					: get the month in number format
		7. String getMon()						: get the month in Mon format viz Jan,Feb etc
		8. String getMonth()					: get the month in full viz January
		9. int getYrInt()						: get the yr in yy in number format
	   10. String getYr()						: get the yr in yy format
	   11. int getYearInt()						: get the year in yyyy in number format
   	   12. String getYear()						: get the year in yyyy 
	   13. int getDayInt()						: get the day for a date set in calendar in int format
	   14. String getDay()						: get the day for a date set in calendar in String
	   15. String getCurrentDate()				: returns the Current date according to the FormatString
	   16. int getCurMonthInt()					: returns the Current Month in int.
	   17. String getCurMon						: returns the Current Month in MMM format.
	   18. String getCurMonth()					: returns the Current Month in MONTH format.
	   19. int getLastDayfMonth()				: returns the LastDay of Month of date set in setCalendar
	   20. String getLastDateOfMonth()			: returns the LastDate of Month of date set in setCalendar
	   21. String getTime()						: returns the time of date set in setCalendar
	   22. String getCurrentTime()				: returns the current time
	   23. long getDatesBetweenCount(String date1,date2): gets the count of days between two days
	   24. String[] getDatesBetween(String date1,date2)	: gets the dates between two dates.	
	   25. boolean isAfter(String date1,date2)	: returns true if date1 occurs date2
	   26. String getPreviousDate(String date1,int no) : returns the date before 'no' days of date1
	   27. String getFuturedate(String date,int no)	 : returns the date after 'no' days of date1
	   28. String getTime24H(String time)		: returns the time from hh:mm am/pm to hh24:mm:ss
	   29. Vector getWeekDays(fromDate,toDate,weekday): return the dates of that weekday between 2 dates		
	   30. String convertToDBDate(String date)	: returns the database specific date according to d/b type
	   31. String getDBSpecDateTime(String time): returns the d/b spec date /time with currrent date
	   32. String getDBDate(String date)		: conevrts the date coming from d/b to that of formatString
	   33. String getDBTime(String date )		: returns the time in hh:mm am/pm format
*/

public class DateUtilities implements ConstantsInterface,SingleThreadModel
{
	private static final long ONE_HOUR = 60 * 60 * 1000L;
	private Calendar calObject;
	private Calendar calFirst;	
	private Calendar calSecond;
	private Calendar calTemp;
	private java.util.Date dateObject;
	private String formatString=ConstantsInterface.formatString;
	private String time="",timeString="";
	private String timeEntry="";
	private String dateStr ="",datePart="";
	private TimeZone timeZone=null;
	int[] timeElements;
	String months[] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
	String monthNames[] = {"January","February","March","April","May","June","July","August","September","October","November","December"};

//	variables relating Database Date
	
	public static String databaseType = ConstantsInterface.databaseType;
	
/**									--Private Functions --										**/

/**
	@name	:-	convertFromFormat()
	@author	:-	Kamal
	@desc	:-	this function converts the date(according to the format string) to dd-mon-yyyy.
*/
	private String convertFromFormat(String date)
	{
//		String fStr="";
		if(formatString!="")	// if format string is specified
		{
			//Logger.writeToLog("Entering convertFromFormat", Logger.LOG_LEVEL_DEBUG, "DateUtilities.java", "convertFromFormat()");
			//Logger.writeToLog("formatString:"+formatString, Logger.LOG_LEVEL_DEBUG, "DateUtilities.java", "convertFromFormat()");
			////System.out.println("formatString in covertFromformat() "+formatString);
			////System.out.println("date in converFromFormat() "+date);
			StringTokenizer st1 = new StringTokenizer(formatString," ");
			String[] fArr = new String[st1.countTokens()];
			for(int i=0;i<fArr.length;i++)
				fArr[i] = st1.nextToken();
			
			formatString=fArr[0];
			
			st1 = new StringTokenizer(formatString,"-/");
			String[] formatArray = new String[st1.countTokens()];
		
			for(int i=0;i<formatArray.length;i++)
				formatArray[i] = st1.nextToken();
			
			StringTokenizer st = new StringTokenizer(date," ");
			String[] dArr = new String[st.countTokens()];
			for(int i=0;i<dArr.length;i++)
				dArr[i] = st.nextToken();
		
			date=dArr[0];
			datePart = date;
			st = new StringTokenizer(date,"-/");
			String[] dateArray=new String[st.countTokens()];
			for(int i=0;i<dateArray.length;i++)
				dateArray[i] = st.nextToken();
			

			int tempYr=0;
			int tempMon=0;
			int tempDd=0;
			
			for(int i=0;i<formatArray.length;i++)
			{
				if(formatArray[i].equalsIgnoreCase("yyyy")||formatArray[i].equalsIgnoreCase("yy"))
				{
					tempYr = Integer.parseInt(dateArray[i]);
				}
				else
				if(formatArray[i].equalsIgnoreCase("MM"))
				{
					tempMon = Integer.parseInt(dateArray[i]);
				}
				else
				if(formatArray[i].equalsIgnoreCase("MMM"))
				{
					String temp =  dateArray[i];
					for(int j=0;j<months.length;j++)
					{
						if(temp.equalsIgnoreCase(months[j]))
						{
							tempMon = j+1;
							break;
						}
					}
				}
				else
				if(formatArray[i].equalsIgnoreCase("dd"))
				{
					tempDd = Integer.parseInt(dateArray[i]);
				}
			}

			if(fArr.length==2)
			{
				timeString=fArr[1];
				
				st = new StringTokenizer(timeString,":");
				String[] timeFormatArray=new String[st.countTokens()];
				for(int i=0;i<timeFormatArray.length;i++)
					timeFormatArray[i] = st.nextToken(); // the time format array
				if(dArr.length>1)
					time=dArr[1]+" "+dArr[2];						// the actual time 
				
				timeElements = timeParse(timeFormatArray,time);
			}
			//Changed by Nazia on 02/04/2008 [test]
			//System.out.println(" 111  tempDd ["+tempDd+"] months ["+months+"] tempYr["+tempYr+"]");
			//System.out.println(" 111  months[tempMon-1] ["+months[tempMon-1]+"]");
			dateStr=tempDd+"-"+months[tempMon-1]+"-"+tempYr;
			
			//Logger.writeToLog("Leaving convertFromFormat..", Logger.LOG_LEVEL_DEBUG, "DateUtilities.java", "convertFromFormat()");
//			formatString=fStr;
			return dateStr;

		}
		else
			return date;
	}

private int[] timeParse(String[] timeFormatArray,String time)
	{
		int[] timeArr = new int[3];
		//Logger.writeToLog("Entering timeParse..", Logger.LOG_LEVEL_DEBUG, "DateUtilities.java", "timeParse()");
		if(!time.equals(""))
		{	
			getTime24H(time);
			int hh=0;
			int mm=0;
			int ss=0;
			StringTokenizer st = new StringTokenizer(timeEntry,":");
			String[] timeArray=new String[st.countTokens()];
			for(int i=0;i<timeArray.length;i++)
				timeArray[i] = st.nextToken();

			for(int i=0;i<timeFormatArray.length;i++)
			{
				if(timeFormatArray[i].equalsIgnoreCase("HH"))
				{
					hh = Integer.parseInt(timeArray[i]);
				}
				else
				if(timeFormatArray[i].equalsIgnoreCase("MM"))
				{
					mm = Integer.parseInt(timeArray[i]);
				//	//System.out.println("Time MM:"+mm);
				}
				else
				if(timeFormatArray[i].equalsIgnoreCase("SS"))
				{
					if(timeArray.length>2)
					ss = Integer.parseInt(timeArray[i]);
				//	//System.out.println("Time SS:"+ss);
				}
			}

			timeArr[0]=hh;
			timeArr[1]=mm;
			if(ss!=0) 
				timeArr[2]=ss;
			else 
				timeArr[2]=0;
		}
		else
		{
			if(timeZone==null)
				timeZone = TimeZone.getDefault();
			TimeZone.setDefault(timeZone);
			Calendar cal = Calendar.getInstance(timeZone);
			timeArr[0]=cal.get(Calendar.HOUR);
			timeArr[1]=cal.get(Calendar.MINUTE);
			timeArr[2]=cal.get(Calendar.SECOND);

		}
		//Logger.writeToLog("Leaving timeParse..", Logger.LOG_LEVEL_DEBUG, "DateUtilities.java", "timeParse()");

			return timeArr;
		

	}
	
/**
	@name	:-	convertToFormat(Calendar)
	@author	:-	Kamal
	@desc	:-	this function converts the date of dd-mon-yyyy format to that of formatstring.
*/
	private String convertToFormat(Calendar cal)
	{
		//Logger.writeToLog("Entering convertToFormat..", Logger.LOG_LEVEL_DEBUG, "DateUtilities.java", "convertToFormat()");
		if(!formatString.equals(""))
		{
			SimpleDateFormat sdfFormat = new SimpleDateFormat(formatString);
			String dtStr = sdfFormat.format(cal.getTime()); // pass the date object
			//Logger.writeToLog("Leaving convertToFormat..", Logger.LOG_LEVEL_DEBUG, "DateUtilities.java", "convertToFormat()");
			return dtStr;
		}
		else
		{ 
			 return (cal.get(Calendar.DAY_OF_MONTH) + "-" + months[cal.get(Calendar.MONTH)] + "-" + cal.get(Calendar.YEAR));
		}
		
	}

/**
		@name	:-	dateParse()
		@author	:-	Kamal
		@desc	:-	This function is to convert the date of format dd-Mon-yyyy into an array containing 
					dd,mm and yyyy numbers.
		@throws	:-	NumberFormatException .This exception is thrown when the format of the date passed 
					is not fo format dd-MMM-yyyy.
*/
	private int[] dateParse(String date) throws NumberFormatException
	{
			//Logger.writeToLog("Entering dateParse..", Logger.LOG_LEVEL_DEBUG, "DateUtilities.java", "dateParse()");
			StringTokenizer stringArray = new StringTokenizer(date,"-");
			int[] dateArray = new int[stringArray.countTokens()];

			dateArray[0] = Integer.parseInt(stringArray.nextToken());	
			
			String s = stringArray.nextToken();

			for(int i=0;i<months.length;i++)
			{
				if(s.equalsIgnoreCase(months[i]))
				{
					dateArray[1] = i;
					break;
				}
			}
			dateArray[2] = Integer.parseInt(stringArray.nextToken());
			////System.out.println("The date in dateParse:"+dateArray[0]+dateArray[1]+dateArray[2]);
			//Logger.writeToLog("Leaving dateParse..", Logger.LOG_LEVEL_DEBUG, "DateUtilities.java", "dateParse()");
			
			return dateArray;
	}

/**
		@name	:-	calTime()
		@author	:-	Kamal
		@desc	:-	returns the time set in the calendar object in String .
*/
	private String calTime(Calendar cal)
	{
		String timeWork = "";
		int hour = 0;

		if(cal.get(Calendar.HOUR)==0)
		hour = 12;
		else
		hour = cal.get(Calendar.HOUR);

		String ampm = "" ;
		if (cal.get(Calendar.AM_PM) == 0) 
		ampm = "AM";
		else
		ampm = "PM";

		if(cal.get(Calendar.MINUTE)< 10)
			if(hour<10)
				timeWork = "0" + hour + ":0" + cal.get(Calendar.MINUTE)+ " "+ ampm ;
			else
				timeWork = hour + ":0" + cal.get(Calendar.MINUTE)+ " "+ ampm ;
		else
			if(hour<10)
				timeWork = "0" + hour + ":" + cal.get(Calendar.MINUTE)+" " + ampm ;
			else
				timeWork = hour + ":" + cal.get(Calendar.MINUTE)+" " + ampm ;				
		return timeWork;
	}

	/**
		@name	:-	getFirstWeekDay()
		@author	:-	Kamal
		@desc	:-	returns first week day specified by dayOfweek. This is a private function.
*/
	private Calendar getFirstWeekDay(Calendar cal,String dayOfWeek)
	{
		while (!isWeekDay(cal,dayOfWeek))
				cal.add(Calendar.DATE,1);
		return cal;
	}

/**
		@name	:-	isWeekDay()
		@author	:-	Kamal
		@desc	:-	returns true if the calendar day is of dayOfweek.This is a private function
*/
	private boolean isWeekDay(Calendar cal,String dayOfWeek)
	{
		dayOfWeek= dayOfWeek.toUpperCase();
		int no=0;
		if(dayOfWeek.equals("SUNDAY"))
			no=Calendar.SUNDAY;
		else
			if(dayOfWeek.equals("MONDAY"))
				no=Calendar.MONDAY;
			else
				if(dayOfWeek.equals("TUESDAY"))
					no=Calendar.TUESDAY;
				else
					if(dayOfWeek.equals("WEDNESDAY"))
						no=Calendar.WEDNESDAY;
					else
						if(dayOfWeek.equals("THURSDAY"))
							no=Calendar.THURSDAY;
						else
							if(dayOfWeek.equals("FRIDAY"))
								no=Calendar.FRIDAY;
							else
								if(dayOfWeek.equals("SATURDAY"))
									no=Calendar.SATURDAY;

		if (cal.get(Calendar.DAY_OF_WEEK)==no)
			return true;
		else 
			return false;
	}

/**
		@name	:-	getCalendar()
		@author	:-	Kamal
		@desc	:-	return the calendar object
*/
	private Calendar getCalendar()
	{
		return calObject;
	}



/**							--Private Functions end here--										**/


	public DateUtilities()
	{
		//Logger.writeToLog("Entering Utilities..", Logger.LOG_LEVEL_NOTICE, "DateUtilities.java", "DateUtilities()");

	}

/**
1.	@name	:-	setFormatString()
	@author	:-	Kamal
	@desc	:-	this function sets the formatString 
*/
	public void setFormatString(String format)
	{
		formatString = format;
	}

/**
2.	@name	:-	setTimeZone()
	@author	:-	Kamal
	@desc	:-	this function sets the timeZone 
*/
	public void setTimeZone(String tz)
	{
		timeZone = TimeZone.getTimeZone(tz);
		TimeZone.setDefault(timeZone);
 	}



/**
3.		@name	:-	setCalendar()
		@author	:-	Kamal
		@desc	:-	his function is used to create the calendar object from a date of format .If the
					formatString is not specified then the default format used is dd-MMM-yyyy.
					if formatString is specified then convertFromFormat() is called instead.
*/
	public void setCalendar(String date)
	{
		//Logger.writeToLog("Inside setCalendar..", Logger.LOG_LEVEL_DEBUG, "DateUtilities.java", "setCalendar()");
		////System.out.println("Date1 in setCalendar is :"+date+":");
		date = convertFromFormat(date);
		////System.out.println("Date1 in setCalendar is :"+date+":");
		int[] dateArray=new int[3];
		try
		{
			dateArray = dateParse(date); // for getting the dateArray
		}
		catch(NumberFormatException npe)
		{
			//System.out.println("ERROR..NumberFormatException:The Format of the date passed in dateParse() called from setCalendar() of DateUtilities is wrong.");
			//System.out.println("Either you have to set the FormatString parameter or give in the dd-Mon-yyyy format");
		}
		if(timeZone!=null)
			calObject = Calendar.getInstance(timeZone);
		else
			calObject = Calendar.getInstance();

		/*if(timeElements==null)
				calObject.set(dateArray[2],dateArray[1],dateArray[0]);
			else
				calObject.set(dateArray[2],dateArray[1],dateArray[0],timeElements[0],timeElements[1],timeElements[2]);*/

		if(timeElements==null)
			calObject.set(Integer.parseInt("20"+dateArray[2]),dateArray[1],dateArray[0]);
		else
			calObject.set(Integer.parseInt("20"+dateArray[2]),dateArray[1],dateArray[0],timeElements[0],timeElements[1],timeElements[2]);

		////System.out.println("The day in setCal::"+calObject.get(Calendar.DATE));

		//Logger.writeToLog("Leaving setCalendar..", Logger.LOG_LEVEL_DEBUG, "DateUtilities.java", "setCalendar()");
	}

/**
4.	@name	:-	getDate()
	@author	:-	Kamal
	@desc	:-	this function returns the date set in the Calendar according to the formatString.ie
				separates the 
*/
	public String getDate()
	{
		return datePart;
	}


/**
5.	@name	:-	convertToFormat()
	@author	:-	Kamal
	@desc	:-	this function converts the date of fString1 format to that of fString2.
*/
	public String convertToFormat(String date,String fString1,String fString2)
	{	
		String fstr=formatString;	
		formatString = fString1;
		setCalendar(date);
		formatString=fstr;
		if(!fString2.equals(""))
 		{
			SimpleDateFormat sdfFormat = new SimpleDateFormat(fString2);
			String dtStr = sdfFormat.format(calObject.getTime()); // pass the date object
			return dtStr;
		}
		else
		{
			 return convertToFormat(calObject);
		}
	}

/*							 -- month functions  starting--							*/

/**
6.		@name	:-	getMonthInt()
		@author	:-	Kamal
		@desc	:-	returns the month in number format
*/
	public int getMonthInt()
	{
		return (calObject.get(Calendar.MONTH)+1);
	}

/**
7.		@name	:-	getMon()
		@author	:-	Kamal
		@desc	:-	returns the month in MMM format
*/
	public String getMon()
	{
		return months[calObject.get(Calendar.MONTH)];
	}

/**
8.		@name	:-	getMonth()
		@author	:-	Kamal
		@desc	:-	returns the month in full
*/
	public String getMonth()
	{
		return monthNames[calObject.get(Calendar.MONTH)];
	}
/**
 *  @name   : - getMonth(int)
 *  @author : - Parag
 *	@desc	:-	returns the month in MMM format
*/

	public String getMonth(int no)
	{
	String month = months[no-1];
	return month;
	}



/*								 -- Year functions  starting --								*/
/**
9.		@name	:-	getYrInt()
		@author	:-	Kamal
		@desc	:-	returns the last two digits(yy) of a Year in number format
*/
	public int getYrInt()
	{
		String yr = new Integer(calObject.get(Calendar.YEAR)).toString();
		return Integer.parseInt(yr.substring(2));
	}

/**
10.		@name	:-	getYr()
		@author	:-	Kamal
		@desc	:-	returns the last two digits(yy) of a Year
*/
	public String getYr()
	{
		String yr = new Integer(calObject.get(Calendar.YEAR)).toString();
		return yr.substring(2);
	}

/**
11.		@name	:-	getYearInt()
		@author	:-	Kamal
		@desc	:-	returns Year in number format
*/
	public int getYearInt()
	{
		return calObject.get(Calendar.YEAR);
	}

/**
12.		@name	:-	getYear()
		@author	:-	Kamal
		@desc	:-	returns Year in yyyy
*/
	public String getYear()
	{
		return new Integer(calObject.get(Calendar.YEAR)).toString();
	}

/*									 -- day functions  starting --							*/

/**
13.		@name	:-	getDayInt()
		@author	:-	Kamal
		@desc	:-	returns the day in number format
*/
	public int getDayInt()
	{
		return calObject.get(Calendar.DATE);
	}

/**
14.		@name	:-	getDay()
		@author	:-	Kamal
		@desc	:-	returns the day in String format
*/
	public String getDay()
	{
		return new Integer(calObject.get(Calendar.DATE)).toString();
	}


/**
15.		@name	:-	getCurrentDate()
		@author	:-	Kamal
		@desc	:-	returns the current date according to the format specified in formatString
*/
	public String getCurrentDate()
	{
		String months[] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
		GregorianCalendar gCal = new GregorianCalendar();
		SimpleDateFormat sdfFormat = new SimpleDateFormat(formatString);
		String dtStr = sdfFormat.format(gCal.getTime()); // pass the date object\
		//System.out.println("Current time dtStr["+dtStr+"]");
		return dtStr;
	}

/**
16.		@name	:-	getCurMonthInt()
		@author	:-	Kamal
		@desc	:-	returns the current month in int
*/
	public int getCurMonthInt() 
	{
		Calendar cl = Calendar.getInstance();
		return (cl.get(Calendar.MONTH)+1);
	}

/**
17.		@name	:-	getCurMon()
		@author	:-	Kamal
		@desc	:-	returns the current month in String in format MMM
*/
	public String getCurMon() 
	{
		Calendar cl = Calendar.getInstance();
		return months[cl.get(Calendar.MONTH)-1];
	}
/**
18.		@name	:-	getCurMonth()
		@author	:-	Kamal
		@desc	:-	returns the current month in String in full form
*/
	public String getCurMonth() 
	{
		Calendar cl = Calendar.getInstance();
		return monthNames[cl.get(Calendar.MONTH)-1];
	}

/**
19.		@name	:-	getLastDayOfMonth()
		@author	:-	Kamal
		@desc	:-	returns the last day in int .For this u have to first set the calendar object
*/
	public int getLastDayOfMonth()
	{ 
		GregorianCalendar gcDate = new GregorianCalendar(calObject.get(Calendar.YEAR),calObject.get(Calendar.MONTH),calObject.get(Calendar.DATE));
		gcDate.add(Calendar.MONTH,1); 
		gcDate.set(Calendar.DATE,0); 
		return gcDate.get(Calendar.DATE); 
	}

/**
20.		@name	:-	getLastDateOfMonth()
		@author	:-	Kamal
		@desc	:-	returns the last date in String .
*/
	public String getLastDateOfMonth()
	{
		String dtStr="";
		GregorianCalendar gcDate = new GregorianCalendar(calObject.get(Calendar.YEAR),calObject.get(Calendar.MONTH),calObject.get(Calendar.DATE));
		gcDate.add(Calendar.MONTH,1); 
		gcDate.set(Calendar.DATE,0); 
		if(formatString!="")
		{
			SimpleDateFormat sdfFormat = new SimpleDateFormat(formatString);
			dtStr = sdfFormat.format(gcDate.getTime()); // pass the date object
		}
		else
		{
			dtStr = gcDate.get(Calendar.DATE)+"-"+months[gcDate.get(Calendar.MONTH)]+"-"+gcDate.get(Calendar.YEAR);

		}
		return dtStr;
	}

/**
21.		@name	:-	getTime()
		@author	:-	Kamal
		@desc	:-	returns the time set in the calendar object in String .
*/
	public String getTime()
	{
		return calTime(calObject);
	}

/**
22.		@name	:-	getCurrentTime()
		@author	:-	Kamal
		@desc	:-	returns the current time set in the calendar object in String .
*/
	public String getCurrentTime()
	{
		if(timeZone==null)
			timeZone = TimeZone.getDefault();

		TimeZone.setDefault(timeZone);
		Calendar cal = Calendar.getInstance(timeZone);
		return calTime(cal);
	}



/**
23.		@name	:-	getDatesBetweenCount()
		@author	:-	Kamal
		@desc	:-	returns the count of days between two days.It includes both the dates while counting.
*/
	public long getDatesBetweenCount(String date1,String date2)
	{
			setCalendar(date1);
			calFirst = getCalendar();
			setCalendar(date2);
			calSecond = getCalendar();

     		long duration =  Math.abs(calSecond.getTime().getTime() - calFirst.getTime().getTime());
			////System.out.println("duration:"+duration);

		 // Add one hour in case the duration includes a 23 hour Daylight Savings spring forward day.
			 long  nDays = (duration + ONE_HOUR ) / (24 * ONE_HOUR);
			 
		// it doesn't include the last date.
			 if(nDays>0)
				 nDays=nDays+1;				 
			 else
			 if(nDays==0)
				 nDays=0;
			 else
				nDays=nDays-1;
		
		////System.out.println("this is no of Days:"+nDays);
			 return nDays;
	}

/**
24.		@name	:-	getDatesBetween()
		@author	:-	Kamal
		@desc	:-	returns the days in String array between two days.It includes both the dates.
*/
	public String[] getDatesBetween(String date1,String date2)
	{
		long dateCount = getDatesBetweenCount(date1,date2);	
		int len = new Long(dateCount).intValue();

		String[] datesArray = new String[len];
		Calendar cal = null;	
		if(calSecond.after(calFirst) || calSecond.equals(calFirst))
			cal=calFirst;
		else
			cal=calSecond;

		for(int i=0;i<len;i++)
		{
			//datesArray[i] = cal.get(Calendar.DAY_OF_MONTH) + "-" + months[cal.get(Calendar.MONTH)] + "-" + cal.get(Calendar.YEAR);
			datesArray[i]= convertToFormat(cal);
			cal.add(Calendar.DAY_OF_MONTH,1);
		}

		return datesArray;
	}

/**
25.		@name	:-	isAfter()
		@author	:-	Kamal
		@desc	:-	returns true is date1 occurs after date2 , else false is returned
*/
	public boolean isAfter(String date1,String date2)
	{
		setCalendar(date1);
		calFirst = getCalendar();
		setCalendar(date2);
		calSecond = getCalendar();
		return calFirst.after(calSecond);
	}

/**
26.		@name	:-	getPreviousDate()
		@author	:-	Kamal
		@desc	:-	returns the date in string format ,'no' days BEFORE the date passed as parameter.
					If the formatString is set then the date is returned in that format.
*/
	public String getPreviousDate(String date,int no)
	{
		setCalendar(date);
		no = no*(-1);
		calObject.add(Calendar.DATE,no);
		return convertToFormat(calObject);
	}

/**
27.		@name	:-	getFutureDate()
		@author	:-	Kamal
		@desc	:-	returns the date in string format ,'no' days AFTER the date passed as parameter.
					If the formatString is set then the date is returned in that format.
*/
	public String getFutureDate(String date,int no)
	{
		setCalendar(date);
		calObject.add(Calendar.DATE,no);
		return convertToFormat(calObject);
	}


/**
28.		@name	:-	getTime24H()
		@author	:-	Kamal
		@desc	:-	returns the time in string format.The time set can be of format hh:mm:ss am/pm or 
					hh:mm am/pm.This time is converted into the 24 Hour format,stripping the am/pm . 
**/
	public String getTime24H(String time)
	{	
		StringTokenizer st = new StringTokenizer(time," "); // to separate the PM/AM and time
		String[] timeArr = new String[st.countTokens()];
		for(int i=0;i<timeArr.length;i++)
			timeArr[i]=st.nextToken();
		time = timeArr[0];
		st = new StringTokenizer(time,":.");				// to separate the time fields
		String[] tm = new String[st.countTokens()];
		for(int i=0;i<tm.length;i++)
			tm[i]=st.nextToken();
		int hr = Integer.parseInt(tm[0]);

		if(timeArr.length>1)
		{	
			if(timeArr[1].equalsIgnoreCase("PM"))	
			{
				if(!tm[0].equals("12"))
					tm[0]= (new Integer(hr+12)).toString();
			}
		}

		if(tm.length<3)
			timeEntry=tm[0]+":"+tm[1]+":"+"00";
		else
			timeEntry=tm[0]+":"+tm[1]+":"+tm[2];

		return timeEntry;
	}
/**
29.		@name	:-	getWeekDays()
		@author	:-	Kamal
		@desc	:-	returns the vector containing the weekdays specified by dayOfweek between two dates.
					eg. if the dayOfweek is Sunday then it will give all the sundays between 2 dates
*/
	public Vector getWeekDays(String dateFrom,String dateTo,String dayOfWeek)
	{
		Vector weekDays = new Vector(2,1);
		setCalendar(dateFrom);
		Calendar calDateFrom = getCalendar(); 
		setCalendar(dateTo);
		Calendar calDateTo = getCalendar(); 
		Calendar cal = calDateFrom ;
		cal = getFirstWeekDay(cal,dayOfWeek);
		while(cal.before(calDateTo) || cal.equals(calDateTo))
		{
			weekDays.addElement(convertToFormat(cal));
			cal.add(Calendar.DATE,7);
		}
	
		return weekDays;
	}


/* ---------------------------------------------------------------------------------------------------*/
/*								Database date related functions										  */
/* ---------------------------------------------------------------------------------------------------*/

/**
30.		@name	:-	convertToDBDate()
		@author	:-	Kamal
		@desc	:-	returns the date in the database specific format.The database type is recieved from
					DBOperations.
*/
public String convertToDBDate(String date)
{
	StringTokenizer st1 = new StringTokenizer(date," ");
	String[] dArr = new String[st1.countTokens()];
	for(int i=0;i<dArr.length;i++)
		dArr[i] = st1.nextToken();

	if(databaseType.equalsIgnoreCase("ACCESS"))
	{
		date = convertFromFormat(date);
		if(dArr.length>1)
		return "#"+date+" "+getTime24H(dArr[1]+" "+dArr[2])+"#";	
		else
		return "#"+date+"#";
	}
	else
	if(databaseType.equalsIgnoreCase("MySQL") || databaseType.equalsIgnoreCase("SqlServer"))
	{
		setCalendar(date);
		calTemp = getCalendar();
		String fStr = formatString;
		if(dArr.length<2)				// if the date passed doesnt contain time
			formatString="yyyy-MM-dd";
		else
			formatString="yyyy-MM-dd HH:mm:ss";
		String str = "'"+convertToFormat(calTemp)+"'";
		formatString = fStr;
		return str;

	}
	else
	if(databaseType.equalsIgnoreCase("ORACLE"))
	{	st1 = new StringTokenizer(formatString," ");
		String[] fArr = new String[st1.countTokens()];
		for(int i=0;i<fArr.length;i++)
			fArr[i] = st1.nextToken();
		if(dArr.length<2)				// if the date passed doesnt contain time
		{
			return "TO_DATE('"+date+"','"+fArr[0]+"')";
		}
		else
		{
			getTime24H(dArr[1]+" "+dArr[2]);
			String str = fArr[0]+" HH24:MI:SS";	// BCOZ ORACLE TAKES TIME IN FORMAT HH24:MI:SS
			return "TO_DATE('"+dArr[0]+" "+timeEntry+"','"+str+"')";
		}
	}
	return date;
}

/**
30.		@name	:-	convDBDateTime()
		@author	:-	Kamal
		@desc	:-	returns the date in the database specific format.The database type is recieved from
					DBOperations.
*/
public String convDBDateTime(String dateTime)
{
	StringTokenizer st1 = new StringTokenizer(dateTime," ");
	String[] dArr = new String[st1.countTokens()];
	for(int i=0;i<dArr.length;i++)
		dArr[i] = st1.nextToken();
	if(dArr.length==1 || dArr.length==3)
	{
		return convertToDBDate(dateTime);
	}
	else
	if(dArr.length==2)
	{
		return getDBSpecDateTime(dArr[0]+" "+dArr[1]);
	}

	return "NULL";

}

/**
31.		@name	:-	getDBSpecDateTime()
		@author	:-	Kamal
		@desc	:-	gives the date/time with time passed and current date.
*/

	public String getDBSpecDateTime(String time)
	{	
		getTime24H(time);
		StringTokenizer st = new StringTokenizer(getCurrentDate()," ");
		String[] strArr = new String[2];
		strArr[0] = st.nextToken();
		String str1="";
		if(!databaseType.equalsIgnoreCase("Oracle"))
		{
			str1 = convertToDBDate(strArr[0]);
			str1 = str1.substring(0,str1.length()-1);
			if(databaseType.equalsIgnoreCase("Access"))
				return str1+" "+ timeEntry + "#";
			else
				return str1+" "+ timeEntry+"'";
		}
		else
		{
			StringTokenizer st1 = new StringTokenizer(formatString," ");
			String[] fArr = new String[st1.countTokens()];
			for(int i=0;i<fArr.length;i++)
				fArr[i] = st1.nextToken();
			String str = fArr[0]+" HH24:MI:SS";
			return "TO_DATE('"+strArr[0]+" "+timeEntry+"','"+str+"')";
			
		}
	}

/**
32.		@name	:-	getDBDate()
		@author	:-	Kamal
		@desc	:-	gives the date/time coming from the Database according to the formatString.
*/
	public String getDBDate(String date)
	{
	 //	date = date.substring(0,10);
		return convertToFormat(date,"yyyy-MM-dd hh:mm:ss",formatString);
	}

/**
33.		@name	:-	getDBTime()
		@author	:-	Kamal
		@desc	:-	gives the time coming from the Database 
*/

	public String getDBTime(String date)
	{
		return convertToFormat(date,"yyyy-MM-dd hh:mm:ss","hh:mm aa");
	}
	private static String format(int temp)
	{
		if(temp<=9)
			return "0" + temp;
		else
			return "" + temp;
	}


	public static String getDateTime()
	{
		String months[] = {"JAN","FEB","MAR","APR","MAY","JUN","JUL","AUG","SEP","OCT","NOV","DEC"};
		
	//create calender initialized with current date and time.

		Calendar gCal = Calendar.getInstance();
		int mth = gCal.get(Calendar.MONTH);
		String mon = months[mth];

		String tempDD = "";   //database wants in strictly mm/DD/yyyy format
		int dd = gCal.get(Calendar.DATE);

		if(dd<10)
			tempDD = "0" + dd;
		else
			tempDD = "" + dd;

		
		String dtStr= tempDD + "-" + mon + "-" + gCal.get(Calendar.YEAR);

		int hr = gCal.get(Calendar.HOUR);
		int mm = gCal.get(Calendar.MINUTE);
		int ss  = gCal.get(Calendar.SECOND);
		int ap = gCal.get(Calendar.AM_PM);

		
		String hour = format(hr);
		String min = format(mm);
		String sec = format(ss);
		String ampm ="";
		if(ap==0)
			ampm="AM";
		else
			ampm="PM";

		String timeStr = hour+":"+min+":"+sec + " " + ampm;
		
		return dtStr+ " " + timeStr;
	}


/*
*	Fn which takes a date in format yyyy-mm-dd hh:mm:ss:mmm(format returned 
	by SQLServer)
*	@return String
*	@param	String dt
*/
	public String getDisplayDate(String dt)
	{
		Vector  vect = new Vector();
		if(!dt.equals(""))
		{
			StringTokenizer strToken = new StringTokenizer(dt,":- .",false);
			
			int len = strToken.countTokens();
			for(int i=0;i<len;i++)
			{
				vect.addElement(strToken.nextToken());
			}
//			//System.out.println("vect.elementAt(1):"+vect.elementAt(1));
//			 ;
//			String mon = getMonth( Integer.parseInt(vect.elementAt(1).toString()) );

			String date =  vect.elementAt(2) +"-" +getMonth( Integer.parseInt(vect.elementAt(1).toString()) )+"-" + vect.elementAt(0);

			if(date.equals("01/01/1900"))
				return "";
			else
				return date;
		}
		else
			return dt;
		
	}



	public static void main(String[] args) 
	{
			
			DateUtilities dut = new DateUtilities();
		dut.setFormatString("MM/dd/yyyy HH:MM:SS");
			String date = dut.getDisplayDate("2002-01-25 00:00:00.0");

			
//			dut.getMonth(0);
		//	dut.setCalendar("01/15/2001 09:34:35");
		/*	//System.out.println("The date is :"+dut.getDate());
			//System.out.println(dut.getTime());
			//System.out.println("The date is :"+dut.getDay()+"-"+dut.getMonth()+"-"+dut.getYr());
			//System.out.println("The Time is "+dut.getTime());
			//System.out.println("The last date is :"+dut.getLastDateOfMonth("05/15/2001"));
			//System.out.println("The No of days are "+dut.getDatesBetweenCount("05/17/2001","05/15/2001"));
			String[] strDates = dut.getDatesBetween("05/17/2001","05/15/2001");
			for(int i=0;i<strDates.length;i++)
			{
				//System.out.println("The date["+i+"] is :"+strDates[i]);
			}
			//System.out.println("The Time is "+dut.getTime());
			//System.out.println("Is 05/17/2001  after 05/15/2001 ?Ans :"+ dut.isAfter("05/17/2001","05/15/2001"));
			//System.out.println("The date 3 days before 05/15/2001 is :"+ dut.getPreviousDate("05/15/2001",3));
			//System.out.println("The date 3 days after 05/15/2001 is :"+ dut.getFutureDate("05/15/2001",3));

			Vector vect = dut.getWeekDays("12/01/2001","12/31/2001","Sunday");
			//System.out.println("The weekdays are"+vect);*/
 
// to insert into the d/b			
//			DateUtilities.databaseType="Oracle";
//			//System.out.println("The DBSpecificDate: "+dut.convDBDateTime("05/15/2001 3:30 pm"));
//			//System.out.println("The  date time entered:"+dut.convDBDateTime("2.30 pm")); 
	/*	
			//System.out.println("The date from database: "+dut.getDBDate("2001-05-25 1:30:25"));
			//System.out.println("The Time is "+dut.getTime()); 
		//System.out.println("The date from database: "+dut.getDBTime("2001-05-25 23:30:25"));

*/
		
	}
}
