/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.I18NMetadataObject;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.InfinispanLocal;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.PopUpHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenerateFormLayout
implements Serializable {
    private static final long serialVersionUID = 1L;
    boolean isCssFile = false;
    static final String outputEncoding = CommonConstants.ENCODING;
    Locale currentLocale;
    transient ResourceBundle labels;
    boolean ignoreComments = true;
    boolean resourceFound = false;
    String sub_nodeName = null;
    Document doc = null;
    boolean isUnits = false;
    String language = new String("en");
    String country = new String("US");
    String var = new String("BLOC");
    String labName = "";
    String xslTextToBeAdded = "";
    static String nodeName = null;
    static NodeList nodes = null;
    public String editFlag = "";
    static Node node = null;
    public static String objContext = "1";
    public static String pageContext = "1";
    public static String objName = "";
    boolean controlType = false;
    boolean editMask = false;
    int zero = 0;
    String pkHiddenField = "";
    String keyFlag = null;
    final String COLUMN_SEPARATOR = ":";
    PopUpHandler popUpHandler;
    int tableWidth = 0;
    HashMap<String, Object> primarykeyMap;
    HashMap<String, Object> dataTypeMap;
    HashMap<String, Object> optionMap;
    String serverAddress = null;
    ArrayList<Object> itemChangeList = null;
    ArrayList<Object> globalColNameList = new ArrayList();
    String displayTheme = null;
    static InfinispanLocal infinispanLocalObj = null;
    static Hashtable jndiProperties = null;
    static InitialContext ctx = null;
    private String OBJ_INFO_SEPARATOR = ";";
    private HashMap<String, String> objFormInfoMap = null;
    private ArrayList<Object> objFormList = null;
    TreeMap<Integer, TreeMap<Integer, I18NMetadataObject>> yTextMap = new TreeMap();
    private final int DIFF_YCORD_FACTOR = 10;
    String scanFlag = "";

    static {
        try {
            if (CommonConstants.CACHE_OPT != 0) {
                jndiProperties = new Hashtable();
                jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
                ctx = new InitialContext(jndiProperties);
                infinispanLocalObj = (InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local");
                BaseLogger.log("1", null, null, "GenerateFormLayout infinispanLocalObj created.....");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in GenerateFormLayout static block:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    public GenerateFormLayout() {
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            this.displayTheme = genericUtility.getThemeFormat();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Document setLocaleLabels(String oName, String oContext, String language, String country, String pContext, String eFlag, HashMap<String, String> propEditorInfoMap, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", userInfo, null, "10012023 Setting Locale lables.........");
        DocumentBuilderFactory dbf = null;
        E12GenericUtility genericUtility = null;
        String targetFileName = "";
        String xmlString = "";
        try {
            String metadataFilePath;
            pageContext = pContext;
            objContext = oContext;
            objName = oName;
            genericUtility = new E12GenericUtility();
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(this.ignoreComments);
            this.getObjFormsDetailList(oName, userInfo);
            String profileIdRes = E12GenericUtility.checkNull(propEditorInfoMap.get("PROFILE_ID_RES"));
            String enterpriseIdRes = E12GenericUtility.checkNull(propEditorInfoMap.get("ENTERPRISE_ID_RES"));
            String editor = E12GenericUtility.checkNull(propEditorInfoMap.get("EDITOR"));
            String userId = E12GenericUtility.checkNull(propEditorInfoMap.get("USER_ID"));
            String cacheMetadataFileName = String.valueOf(enterpriseIdRes) + "-" + profileIdRes + "-" + userId + "~~" + oName + pContext + oContext;
            if (CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null) {
                if (infinispanLocalObj.contains(cacheMetadataFileName)) {
                    xmlString = infinispanLocalObj.getFormData(cacheMetadataFileName);
                } else {
                    metadataFilePath = genericUtility.getMetaDataFilePath(oName, oContext, pContext, this.getFormName(oContext), propEditorInfoMap, userInfo.getTransDB());
                    xmlString = this.readFile(metadataFilePath);
                    infinispanLocalObj.putFormData(cacheMetadataFileName, xmlString);
                }
            } else {
                metadataFilePath = genericUtility.getMetaDataFilePath(oName, oContext, pContext, this.getFormName(oContext), propEditorInfoMap, userInfo.getTransDB());
                xmlString = this.readFile(metadataFilePath);
            }
            this.doc = genericUtility.parseString(xmlString);
            NodeList unitList = this.doc.getElementsByTagName("units");
            if (unitList.getLength() > 0 && unitList.item(0).getFirstChild() != null && unitList.item(0).getFirstChild().getNodeValue().equals("0")) {
                this.isUnits = true;
            }
            this.var = String.valueOf(objName) + pageContext + objContext;
            this.country = country;
            this.language = language;
            this.currentLocale = new Locale(this.language, this.country, this.var);
            this.labels = ResourceBundle.getBundle("Labels", this.currentLocale);
            BaseLogger.log("2", userInfo, null, "10012023 Setting Locale lables [" + this.labels + "]");
            return this.doc;
        }
        catch (MissingResourceException re) {
            BaseLogger.log("0", userInfo, null, "Exception :GenerateFormLayout :setLocaleLabels :==>MissingResourceException :" + re);
            return this.doc;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private String readFile(String fileName) throws Exception {
        StringBuffer fileContent = new StringBuffer();
        BufferedReader bfr = null;
        try {
            FileInputStream fMainIn = new FileInputStream(fileName);
            bfr = new BufferedReader(new InputStreamReader((InputStream)fMainIn, CommonConstants.ENCODING));
            String outTempStr = null;
            while ((outTempStr = bfr.readLine()) != null) {
                fileContent.append(outTempStr);
            }
            bfr.close();
            bfr = null;
        }
        finally {
            try {
                if (bfr != null) {
                    bfr.close();
                    bfr = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in releasing file resource :[" + fileName + "]");
                e.printStackTrace();
            }
        }
        return fileContent.toString();
    }

    public String getHeaderXSL(String eFlag, String appContext, ArrayList<String> gbNames, HashMap<String, Object> paramMap, UserInfoBean userInfo, String formTitle) throws ITMException {
        BaseLogger.log("2", userInfo, null, "Creating XSL file for :[" + objName + "][" + pageContext + "][" + objContext + "][" + this.language + "][" + this.country + "][" + eFlag + "]");
        String transDB = "";
        this.editFlag = eFlag;
        try {
            transDB = userInfo.getTransDB();
            boolean isTaxApplicable = (Boolean)paramMap.get("IS_TAX_APPL");
            this.keyFlag = (String)paramMap.get("KEY_FLAG");
            int editTmplt = new Integer(paramMap.get("EDIT_TMPLT").toString());
            BaseLogger.log("3", userInfo, null, "isTaxApplicable :[" + isTaxApplicable + "] keyFlag :[" + this.keyFlag + "] editTmplt :[" + editTmplt + "]");
            this.xslTextToBeAdded = "<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " <xsl:template match=\"*\" mode=\"serialize\">";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " <xsl:text>&lt;</xsl:text>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "  <xsl:value-of select=\"name()\"/>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "  <xsl:apply-templates select=\"@*\" mode=\"serialize\" />";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " <xsl:choose>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "  <xsl:when test=\"node()\">";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " <xsl:text>&gt;</xsl:text>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "  <xsl:apply-templates mode=\"serialize\" />";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "  <xsl:text>&lt;/</xsl:text>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "  <xsl:value-of select=\"name()\"/>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "  <xsl:text>&gt;</xsl:text>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " </xsl:when>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " <xsl:otherwise>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "   <xsl:text> /&gt;</xsl:text>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " </xsl:otherwise>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " </xsl:choose>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " </xsl:template>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " <xsl:template match=\"@*\" mode=\"serialize\">";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "  <xsl:text> </xsl:text>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " <xsl:value-of select=\"name()\"/>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "  <xsl:text>=\"</xsl:text>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "   <xsl:value-of select=\".\"/>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "   <xsl:text>\"</xsl:text>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " </xsl:template>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<xsl:template match=\"/\">\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<html>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<head>\n";
            String file = String.valueOf(appContext) + "webitm" + File.separator + "css" + File.separator + "default.css";
            BaseLogger.log("3", userInfo, null, "GenerateFormLayout :: getHeaderXSL :: this.displayTheme[" + this.displayTheme + "]");
            if (this.displayTheme != null && this.displayTheme.length() > 0) {
                file = String.valueOf(appContext) + "webitm" + File.separator + "css" + File.separator + this.displayTheme + File.separator + "default.css";
                BaseLogger.log("3", userInfo, null, "GenerateFormLayout :: getHeaderXSL :: this.displayTheme ::file[" + file + "]");
            }
            File cssFile = new File(file);
            this.isCssFile = cssFile.exists();
            if (cssFile.exists()) {
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<link type=\"text/css\" rel=\"stylesheet\" href=\"/ibase/webitm/css/" + this.displayTheme + "/default.css\"/>\n";
            }
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "</head>\n";
            this.xslTextToBeAdded = eFlag.equalsIgnoreCase("E") || eFlag.equalsIgnoreCase("A") ? String.valueOf(this.xslTextToBeAdded) + "<body class='headerDetailBody' onload='disableFldSimpleTran();'>\n" : String.valueOf(this.xslTextToBeAdded) + "<body class='headerDetailBody' onload=''>\n";
            if ((eFlag.equalsIgnoreCase("E") || eFlag.equalsIgnoreCase("A")) && transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0) {
                this.itemChangeList = this.getElemItemChangeList(objName, objContext, userInfo);
            }
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<FORM id=\"detail\" METHOD=\"POST\" ACTION=\"MasterSave.jsp\">\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<table id=\"deletedTableRows\" style=\"display:none;\"></table>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<INPUT type='hidden' name='OBJ_NAME' value='" + objName + "'/>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<INPUT type='hidden' name='PAGE_CONTEXT' value='" + pageContext + "'/>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<INPUT type='hidden' name='OBJ_CONTEXT' value='" + objContext + "'/>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<INPUT type='hidden' name='EDIT_FLAG' value='" + this.editFlag + "'/>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<INPUT type='hidden' name='EDIT_TMPLT' value='" + editTmplt + "'/>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<xsl:for-each select=\"/DocumentRoot/group0\">\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<xsl:for-each select=\"./Header0\">\n";
            StringBuffer tabContentHTML = new StringBuffer();
            StringBuffer finalFormXSLBuff = new StringBuffer();
            this.xslTextToBeAdded = !objName.equalsIgnoreCase("TAXTRAN") ? String.valueOf(this.xslTextToBeAdded) + "<xsl:for-each select=\"./Detail" + objContext + "[attribute/@updateFlag!='D']\">\n" : String.valueOf(this.xslTextToBeAdded) + "<xsl:for-each select=\"./Tax[attribute/@updateFlag!='D']\">\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<INPUT type='hidden' name='DOM_ID' value='{@domID}'/>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<INPUT type='hidden' name='DB_ID' value='{@dbID}'/>\n";
            if (objName.equalsIgnoreCase("TAXTRAN")) {
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<SPAN name=\"detailTabName\" id=\"detailTabId\" class=\"detailTabImg\" onclick=\"parent.eventHandler('SHOW_DATA')\"><CENTER>Detail</CENTER>\n";
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "</SPAN>\n";
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<SPAN name=\"taxTabName\" id=\"taxTabId\" class=\"taxTabImg\"><CENTER>Tax</CENTER>\n";
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "</SPAN>\n";
            }
            tabContentHTML.append("\n<xsl:variable name=\"pkNamesHeader\"><xsl:value-of select=\"attribute/@pkNames\" /></xsl:variable>");
            tabContentHTML.append("\n<xsl:variable name=\"dbStatus\"><xsl:value-of select=\"attribute/@status\" /></xsl:variable>");
            tabContentHTML.append("\n<xsl:variable name=\"updateFlag\"><xsl:value-of select=\"attribute/@updateFlag\" /></xsl:variable>");
            tabContentHTML.append("\n<input type=\"hidden\" value=\"{@dbID}\" name=\"Detail" + objContext + ".{normalize-space(@domID)}.dbID\" id=\"Detail" + objContext + ".{normalize-space(@domID)}.dbID\" />");
            tabContentHTML.append("\n<input type=\"hidden\" value=\"" + objName + "\"\tname=\"Detail" + objContext + ".{normalize-space(@domID)}.objName\" id=\"Detail" + objContext + ".{normalize-space(@domID)}.objName\" />");
            tabContentHTML.append("\n<input type=\"hidden\" value=\"{$pkNamesHeader}\" name=\"Detail" + objContext + ".{normalize-space(@domID)}.pkNames\" id=\"Detail" + objContext + ".{normalize-space(@domID)}.pkNames\" />");
            tabContentHTML.append("\n<input type=\"hidden\" value=\"{$dbStatus}\" name=\"Detail" + objContext + ".{normalize-space(@domID)}.dbStatus\" id=\"Detail" + objContext + ".{normalize-space(@domID)}.dbStatus\" />");
            tabContentHTML.append("\n<input type=\"hidden\" value=\"{$updateFlag}\" name=\"Detail" + objContext + ".{normalize-space(@domID)}.updateFlag\" id=\"Detail" + objContext + ".{normalize-space(@domID)}.updateFlag\" />");
            tabContentHTML.append("\n<div class=\"detailHeading detailHeadingTab\">\t<div style=\"float: left;width: 50%;\"> <label style=\"transition: none;\" class=\"datailHeaderLabel\">\t" + formTitle + "</label> </div>\t</div>");
            tabContentHTML.append("<div  id=\"dataDivID2" + objContext + "\" class=\"detailDataDiv\">\n");
            tabContentHTML.append("<SPAN name=\"PopUpIcon\" id=\"PopUpIcon\"  class=\"pophelp-Span\" style=\"z-index:1;visibility:hidden;width:20;height:20;border:none;\" CUR_POPUP_PARAM=\"\">\n");
            tabContentHTML.append("<div title=\"Click to see list of values for this column in a pop up window\" onclick=\"getListOfValues();\" class=\"pophelp-Btn\" border=\"0\" z-index=\"1\"></div>");
            tabContentHTML.append("</SPAN>\n");
            tabContentHTML.append("<SPAN name=\"calender\" id=\"calender\" class=\"calender-Span\" style=\"z-index:1;visibility:hidden;width:30;height:30;border:none;\" CUR_POPUP_PARAM=\"\">");
            tabContentHTML.append("<div title=\"Click to see calender\" onclick=\"setDate();\" class=\"calender-Btn\" border=\"0\" z-index=\"1\"></div>");
            tabContentHTML.append("</SPAN>\n");
            this.setProperties();
            tabContentHTML.append(this.dataFieldFormDisplay(editTmplt, gbNames, userInfo)).append("</div>");
            if (isTaxApplicable) {
                tabContentHTML.append("<div  id=\"taxDataDivID2" + objContext + "\" class=\"taxDataDiv\" style=\"display:none\"></div>");
            }
            if (isTaxApplicable) {
                finalFormXSLBuff.append("<!-- tabs -->");
                finalFormXSLBuff.append("<div class='pcss3t pcss3t-effect-scale pcss3t-theme-1'>");
                finalFormXSLBuff.append(tabContentHTML);
                finalFormXSLBuff.append("</div>");
                finalFormXSLBuff.append("<script type='text/javascript' >");
                finalFormXSLBuff.append("handleBug();");
                finalFormXSLBuff.append("</script>");
                finalFormXSLBuff.append("<!-- tabs -->");
            } else {
                finalFormXSLBuff.append(tabContentHTML);
            }
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + finalFormXSLBuff.toString();
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "</xsl:for-each>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "</xsl:for-each>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "</xsl:for-each>\n";
            if (objName.equalsIgnoreCase("resume")) {
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<input type='button' name='save_button' value='SAVE' id='save_button' onClick='document.forms[0].submit()'/>\n";
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<input type='reset' name='cancel_button' value='CANCEL' id='cancel_button'/>\n";
            }
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<script>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<![CDATA[";
            if (isTaxApplicable) {
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "var isTaxAppl = true;\n";
            }
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "]]>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "</script>";
            return this.xslTextToBeAdded;
        }
        catch (Exception ex) {
            BaseLogger.log("0", userInfo, null, "Exception:[GenerateFormLayout]:getHeaderXSL" + ex);
            throw new ITMException(ex);
        }
    }

    public String getDetailXSL(String eFlag, String appContext, ArrayList<String> gbNames, HashMap<String, Object> paramMap, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", userInfo, null, "Creating Detail XSL String for :[" + objName + "][" + pageContext + "][" + objContext + "][" + this.language + "][" + this.country + "][" + eFlag + "]");
        this.editFlag = eFlag;
        boolean isTaxApplicable = false;
        int editTmplt = 0;
        String transDB = "";
        String file = "";
        try {
            if (paramMap != null) {
                isTaxApplicable = (Boolean)paramMap.get("IS_TAX_APPL");
                this.keyFlag = (String)paramMap.get("KEY_FLAG");
                editTmplt = new Integer(paramMap.get("EDIT_TMPLT").toString());
            }
            transDB = userInfo.getTransDB();
            BaseLogger.log("3", userInfo, null, "isTaxApplicable :[" + isTaxApplicable + "] keyFlag :[" + this.keyFlag + "] editTmplt :[" + editTmplt + "]");
            file = String.valueOf(appContext) + "webitm" + File.separator + "css" + File.separator + "default.css";
            BaseLogger.log("3", userInfo, null, "GenerateFormLayout :: getXSL :: this.displayTheme[" + this.displayTheme + "]");
            if (this.displayTheme != null && this.displayTheme.length() > 0) {
                file = String.valueOf(appContext) + "webitm" + File.separator + "css" + File.separator + this.displayTheme + File.separator + "default.css";
                BaseLogger.log("3", userInfo, null, "GenerateFormLayout :: getXSL :: this.displayTheme ::file[" + file + "]");
            }
            File cssFile = new File(file);
            this.isCssFile = cssFile.exists();
            this.xslTextToBeAdded = "";
            if ((eFlag.equalsIgnoreCase("E") || eFlag.equalsIgnoreCase("A")) && transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0) {
                this.itemChangeList = this.getElemItemChangeList(objName, objContext, userInfo);
            }
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<xsl:for-each select=\"/DocumentRoot/group0\">\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<xsl:variable name=\"col_name\" select=\"../col_name\"/>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<xsl:variable name=\"datatype\" select=\"../datatype\"/>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<xsl:variable name=\"sort_order\" select=\"../order\"/>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<script>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "var sortOrder='<xsl:value-of select=\"$sort_order\"/>';\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "var isAnyRecordSelected = false;\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "</script>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<input type=\"hidden\" value=\"\"\tname=\"currSelectedDom" + objContext + "\" id=\"currSelectedDom" + objContext + "\" />\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<input type=\"hidden\" value=\"\"\tname=\"currRowIndex" + objContext + "\" id=\"currRowIndex" + objContext + "\" />\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<xsl:for-each select=\"./Header0\">\n";
            this.xslTextToBeAdded = this.isCssFile ? (objName.equalsIgnoreCase("taxtran") ? String.valueOf(this.xslTextToBeAdded) + "<div id=\"dataDivID1" + objContext + "\" class=\"browDataDiv\">" : String.valueOf(this.xslTextToBeAdded) + "<div id=\"dataDivID1" + objContext + "\" class=\"DetailsDataDiv\">") : String.valueOf(this.xslTextToBeAdded) + "<div id=\"dataDivID1" + objContext + "\" style=\"left:.5%;top:1%;width:99%;height:97.5%;position:absolute;overflow:auto;\">";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "\n<TABLE name=\"main\" id=\"" + objName + "1" + objContext + "\" ";
            if (this.isCssFile) {
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " class=\"tableClass\" ";
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " style=\"";
            } else {
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " style=\"";
            }
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + " class:header_css;position:relative;top:0;\">";
            this.setProperties();
            String detailTabledata = this.getDetailTableData(gbNames, userInfo, isTaxApplicable);
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + detailTabledata;
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<xsl:value-of select='NoOfRows'/>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "</div>\n";
            if (isTaxApplicable) {
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<div  id=\"taxDataDivID2" + objContext + "\" class=\"taxDataDiv\" style=\"display:none\"></div>";
            }
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<script>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "<![CDATA[";
            if (isTaxApplicable) {
                this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "var isTaxAppl" + objContext + " = true;\n";
            }
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "]]>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "</script>";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "</xsl:for-each>\n";
            this.xslTextToBeAdded = String.valueOf(this.xslTextToBeAdded) + "</xsl:for-each>\n";
            return this.xslTextToBeAdded;
        }
        catch (Exception ex) {
            BaseLogger.log("0", userInfo, null, "Exception:[GenerateFormLayout]:getDetailXSL" + ex);
            throw new ITMException(ex);
        }
    }

    private String dataFieldDisplayAddForFirefoxBug(String tempColName) {
        return "<SCRIPT type='text/javascript'><![CDATA[if (navigator.userAgent.indexOf('Firefox') != -1) {var textAreaField = document.getElementById('" + tempColName + "]]>" + "<xsl:value-of select='@domID' />" + "<![CDATA[');" + "var rows = parseInt(textAreaField.rows);" + "textAreaField.rows = rows - 1;" + "}" + "]]>" + "</SCRIPT>";
    }

    private String callWebservice(String units, String value) {
        String ret = "";
        try {
            if (this.serverAddress == null) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db1 = dbf.newDocumentBuilder();
                Document doc1 = db1.parse(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "TomcatAddress.xml");
                NodeList serApp = doc1.getElementsByTagName("TOMCAT_SERVER");
                this.serverAddress = serApp.item(0).getFirstChild().getNodeValue().trim();
            }
            String endpoint = String.valueOf(this.serverAddress) + "/axis/services/PixelConverterService";
            String methodName = "unitsToPixels";
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(endpoint));
            call.setOperationName(new QName("http://NvoServiceurl.org", methodName));
            call.setUseSOAPAction(true);
            call.setSOAPActionURI("http://NvoServiceurl.org/" + methodName);
            Object[] objArr = new Object[2];
            objArr[0] = units;
            call.addParameter(new QName("http://NvoServiceurl.org", "units"), XMLType.XSD_STRING, ParameterMode.IN);
            objArr[1] = value;
            call.addParameter(new QName("http://NvoServiceurl.org", "value"), XMLType.XSD_STRING, ParameterMode.IN);
            call.setReturnType(XMLType.XSD_STRING);
            ret = (String)call.invoke(objArr);
            if (ret.equals("-1")) {
                ret = null;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, " Exception :GenerateFormLayout :callWebservice :==>" + e);
            e.printStackTrace();
        }
        catch (Error e) {
            BaseLogger.log("0", null, null, "Error :GenerateFormLayout :callWebservice :==> " + e);
            e.printStackTrace();
        }
        return ret;
    }

    private void setProperties() throws ITMException {
        this.primarykeyMap = new HashMap();
        this.dataTypeMap = new HashMap();
        this.optionMap = new HashMap();
        try {
            NodeList table_column = this.doc.getElementsByTagName("table_column");
            int i = 0;
            while (i < table_column.getLength()) {
                Node eachColumn = table_column.item(i);
                NodeList eachColumnDetail = eachColumn.getChildNodes();
                String keyFlag = "false";
                String pkValue = "";
                String columntype = "";
                int j = 0;
                while (j < eachColumnDetail.getLength()) {
                    if (!eachColumnDetail.item(j).getNodeName().equalsIgnoreCase("#text") && eachColumnDetail.item(j).getFirstChild() != null) {
                        if (eachColumnDetail.item(j).getNodeName().equalsIgnoreCase("type")) {
                            columntype = eachColumnDetail.item(j).getFirstChild().getNodeValue();
                            columntype = columntype.equalsIgnoreCase("char") || columntype.equalsIgnoreCase("String") ? "String" : (columntype.equalsIgnoreCase("datetime") ? "datetime" : "number");
                        } else if (eachColumnDetail.item(j).getNodeName().equalsIgnoreCase("key")) {
                            keyFlag = "true";
                        } else if (eachColumnDetail.item(j).getNodeName().equalsIgnoreCase("name")) {
                            pkValue = eachColumnDetail.item(j).getFirstChild().getNodeValue();
                        }
                    }
                    ++j;
                }
                this.primarykeyMap.put(new String(pkValue), new String(keyFlag));
                this.dataTypeMap.put(new String(pkValue), new String(columntype));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, " Error in GenerateFormLayout:setProperties()" + e);
        }
    }

    private void getOptionString(boolean isPrimaryKey, int tabIndex) throws ITMException {
        try {
            NodeList tableColumn = this.doc.getElementsByTagName("table_column");
            int i = 0;
            while (i < tableColumn.getLength()) {
                Node eachColumn = tableColumn.item(i);
                NodeList eachColumnDetail = eachColumn.getChildNodes();
                String pkValue = "";
                String optString = "";
                int j = 0;
                while (j < eachColumnDetail.getLength()) {
                    if (eachColumnDetail.item(j).getNodeName().equalsIgnoreCase("name")) {
                        pkValue = eachColumnDetail.item(j).getFirstChild().getNodeValue();
                    } else if (eachColumnDetail.item(j).getNodeName().equalsIgnoreCase("values")) {
                        Node opt = eachColumnDetail.item(j);
                        NodeList values = opt.getChildNodes();
                        boolean isBlankOptionExist = false;
                        optString = String.valueOf(optString) + "<xsl:variable name=\"" + pkValue + "\" select=\"" + pkValue + "\"/>";
                        optString = String.valueOf(optString) + "\n<xsl:choose>";
                        int ctr1 = 0;
                        while (ctr1 < values.getLength()) {
                            if (values.item(ctr1).getNodeName().equals("item")) {
                                NamedNodeMap nMap1 = values.item(ctr1).getAttributes();
                                String data1 = nMap1.getNamedItem("data").getNodeValue();
                                optString = String.valueOf(optString) + "\n<xsl:when test=\"$" + pkValue + "='" + data1 + "'\">";
                                if (data1.equalsIgnoreCase("")) {
                                    isBlankOptionExist = true;
                                }
                                if (this.editFlag.equalsIgnoreCase("A") || this.editFlag.equalsIgnoreCase("E")) {
                                    int ctr2 = 0;
                                    while (ctr2 < values.getLength()) {
                                        if (values.item(ctr2).getNodeName().equals("item")) {
                                            NamedNodeMap nMap = values.item(ctr2).getAttributes();
                                            String data = nMap.getNamedItem("data").getNodeValue();
                                            optString = ctr1 == ctr2 ? String.valueOf(optString) + "\n<OPTION selected=\"Yes\" value=\"" + data + "\"><![CDATA[" + nMap.getNamedItem("display").getNodeValue() + "]]></OPTION>" : String.valueOf(optString) + "\n<OPTION value=\"" + data + "\"><![CDATA[" + nMap.getNamedItem("display").getNodeValue() + "]]></OPTION>";
                                        }
                                        ++ctr2;
                                    }
                                } else if (pageContext.equalsIgnoreCase("1") || this.editFlag.equalsIgnoreCase("V") || tabIndex == 32766 || isPrimaryKey) {
                                    optString = String.valueOf(optString) + "<OPTION>" + nMap1.getNamedItem("display").getNodeValue() + "</OPTION>";
                                }
                                optString = String.valueOf(optString) + "\n</xsl:when>";
                            }
                            ++ctr1;
                        }
                        if (!pageContext.equalsIgnoreCase("1") && !this.editFlag.equalsIgnoreCase("V") && tabIndex != 32766) {
                            optString = String.valueOf(optString) + "\n<xsl:otherwise>";
                            int ctr3 = 0;
                            while (ctr3 < values.getLength()) {
                                if (values.item(ctr3).getNodeName().equals("item")) {
                                    NamedNodeMap nMap = values.item(ctr3).getAttributes();
                                    String data = nMap.getNamedItem("data").getNodeValue();
                                    optString = String.valueOf(optString) + "\n<OPTION value=\"" + data + "\"><![CDATA[" + nMap.getNamedItem("display").getNodeValue() + "]]></OPTION>";
                                }
                                ++ctr3;
                            }
                            optString = String.valueOf(optString) + "\n</xsl:otherwise>";
                        }
                        optString = String.valueOf(optString) + "\n</xsl:choose>";
                    }
                    ++j;
                }
                this.optionMap.put(new String(pkValue), new String(optString));
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Error In 18NLabel.getOptionString()");
            throw new ITMException(e);
        }
    }

    private ArrayList<Object> getElemItemChangeList(String objName, String formNo, UserInfoBean userInfo) throws ITMException {
        ArrayList itemChangeList = new ArrayList();
        try {
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            DBAccessEJB dbAccess = new DBAccessEJB();
            itemChangeList = dbAccess.getItemChangeElementList(objName, formNo, userInfo);
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Error In 18NLabel.getElemItemChangeList()");
            throw new ITMException(e);
        }
        return itemChangeList;
    }

    private ArrayList<Object> getObjFormsDetailList(String objName, UserInfoBean userInfo) throws ITMException {
        try {
            if (this.objFormList == null) {
                DBAccessEJB dbAccess = new DBAccessEJB();
                this.objFormList = dbAccess.getObjFormsDetailList(objName, userInfo);
                this.setObjFormInfoMap(this.objFormList);
                dbAccess = null;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Error In GenerateFormLayout.getObjFormsDetailList()");
            throw new ITMException(e);
        }
        return this.objFormList;
    }

    private void parseMetadataObjects(UserInfoBean userInfo) {
        this.yTextMap = new TreeMap();
        NodeList grpBoxList = this.doc.getElementsByTagName("GroupBox");
        int i = 0;
        while (i < grpBoxList.getLength()) {
            Node groupBox = grpBoxList.item(i);
            I18NMetadataObject grpBoxObject = this.parseMetaObjectNode(groupBox, userInfo);
            grpBoxObject.setMetaType("Group");
            Integer xCordKey = grpBoxObject.getIntXCord();
            Integer yCordKey = grpBoxObject.getIntYCord();
            yCordKey = this.updateYCord(yCordKey);
            grpBoxObject.setYCord(yCordKey);
            BaseLogger.log("3", userInfo, null, "textObject:name:" + grpBoxObject.getName());
            BaseLogger.log("3", userInfo, null, "textObject:text:" + grpBoxObject.getText());
            BaseLogger.log("3", userInfo, null, "textObject:yCordKey:" + yCordKey);
            TreeMap<Integer, I18NMetadataObject> xGrpObjMap = this.yTextMap.get(yCordKey);
            if (xGrpObjMap == null) {
                xGrpObjMap = new TreeMap();
                xGrpObjMap.put(xCordKey, grpBoxObject);
                this.yTextMap.put(yCordKey, xGrpObjMap);
            } else {
                while (true) {
                    if (!xGrpObjMap.containsKey(xCordKey)) break;
                    xCordKey = xCordKey + 1;
                }
                xGrpObjMap.put(xCordKey, grpBoxObject);
                this.yTextMap.put(yCordKey, xGrpObjMap);
            }
            ++i;
        }
        NodeList txtList = this.doc.getElementsByTagName("TextObject");
        int i2 = 0;
        while (i2 < txtList.getLength()) {
            Node eachText = txtList.item(i2);
            I18NMetadataObject textObject = this.parseMetaObjectNode(eachText, userInfo);
            textObject.setMetaType("Text");
            Integer xCordKey = textObject.getIntXCord();
            Integer yCordKey = textObject.getIntYCord();
            yCordKey = this.updateYCord(yCordKey);
            textObject.setYCord(yCordKey);
            BaseLogger.log("3", userInfo, null, "textObject:name:" + textObject.getName());
            BaseLogger.log("3", userInfo, null, "textObject:text:" + textObject.getText());
            BaseLogger.log("3", userInfo, null, "textObject:yCordKey:" + yCordKey);
            TreeMap<Integer, I18NMetadataObject> xTxtMap = this.yTextMap.get(yCordKey);
            if (xTxtMap == null) {
                xTxtMap = new TreeMap();
                xTxtMap.put(xCordKey, textObject);
                this.yTextMap.put(yCordKey, xTxtMap);
            } else {
                while (true) {
                    if (!xTxtMap.containsKey(xCordKey)) break;
                    xCordKey = xCordKey + 1;
                }
                xTxtMap.put(xCordKey, textObject);
                this.yTextMap.put(yCordKey, xTxtMap);
            }
            ++i2;
        }
        BaseLogger.log("3", userInfo, null, "TextObject parseMetadataObjects yTextMap 10012023 :[" + this.yTextMap + "]");
        NodeList colList = this.doc.getElementsByTagName("ColumnObject");
        int i3 = 0;
        while (i3 < colList.getLength()) {
            Node eachText = colList.item(i3);
            I18NMetadataObject colObject = this.parseMetaObjectNode(eachText, userInfo);
            colObject.setMetaType("Column");
            Integer xCordKey = colObject.getIntXCord();
            Integer yCordKey = colObject.getIntYCord();
            yCordKey = this.updateYCord(yCordKey);
            colObject.setYCord(yCordKey);
            TreeMap<Integer, I18NMetadataObject> xTxtMap = this.yTextMap.get(yCordKey);
            if (xTxtMap == null) {
                xTxtMap = new TreeMap();
                xTxtMap.put(xCordKey, colObject);
                this.yTextMap.put(yCordKey, xTxtMap);
            } else {
                while (true) {
                    if (!xTxtMap.containsKey(xCordKey)) break;
                    xCordKey = xCordKey + 1;
                }
                xTxtMap.put(xCordKey, colObject);
                this.yTextMap.put(yCordKey, xTxtMap);
            }
            ++i3;
        }
        BaseLogger.log("3", userInfo, null, "ColumnObject parseMetadataObjects yTextMap 10012023 :[" + this.yTextMap + "]");
        int firstColElemLeftPos = 0;
        for (Integer yCord : this.yTextMap.keySet()) {
            TreeMap<Integer, I18NMetadataObject> xTextMap = this.yTextMap.get(yCord);
            int xElemSize = xTextMap.size();
            BaseLogger.log("3", userInfo, null, "xElemSize[" + xElemSize);
            if (xTextMap != null && xElemSize > 1) {
                Iterator<Integer> xTextMapIt = xTextMap.keySet().iterator();
                int xCnt = 0;
                I18NMetadataObject prevXCordObj = null;
                while (xTextMapIt.hasNext()) {
                    Integer xCord = xTextMapIt.next();
                    I18NMetadataObject currXCordObj = xTextMap.get(xCord);
                    if (xCnt == 0) {
                        if ("Text".equalsIgnoreCase(currXCordObj.getMetaType())) {
                            currXCordObj.setWidth(currXCordObj.getIntWidth() + 25);
                            int minXCord = currXCordObj.getIntXCord() + currXCordObj.getIntWidth() + 5;
                            if (firstColElemLeftPos == 0 || minXCord < firstColElemLeftPos) {
                                firstColElemLeftPos = minXCord;
                            }
                        } else {
                            currXCordObj.setXCord(firstColElemLeftPos);
                        }
                    } else {
                        int newXPos;
                        int currXPos = currXCordObj.getIntXCord();
                        if (currXPos + 5 > (newXPos = prevXCordObj.getIntXCord())) {
                            newXPos = newXPos + prevXCordObj.getIntWidth() + 5;
                            currXCordObj.setXCord(newXPos);
                        }
                        if ("Text".equalsIgnoreCase(currXCordObj.getMetaType())) {
                            currXCordObj.setWidth(currXCordObj.getIntWidth() + 25);
                        }
                    }
                    xTextMap.put(xCord, currXCordObj);
                    prevXCordObj = currXCordObj;
                    ++xCnt;
                }
            }
            this.yTextMap.put(yCord, xTextMap);
        }
        BaseLogger.log("3", userInfo, null, "exiting parseMetadataObjects yTextMap 10012023 :[" + this.yTextMap + "]");
    }

    private I18NMetadataObject parseMetaObjectNode(Node eachText, UserInfoBean userInfo) {
        I18NMetadataObject metaObj = new I18NMetadataObject();
        NodeList eachTextDetail = eachText.getChildNodes();
        int j = 0;
        while (j < eachTextDetail.getLength()) {
            if (!eachTextDetail.item(j).getNodeName().equalsIgnoreCase("#text") && eachTextDetail.item(j).getFirstChild() != null) {
                Node childNode = eachTextDetail.item(j);
                String sub_nodes_name = childNode.getNodeName();
                if ("name".equalsIgnoreCase(sub_nodes_name)) {
                    String colName = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "";
                    metaObj.setName(colName);
                    if (this.dataTypeMap.containsKey(colName)) {
                        String dataType = (String)this.dataTypeMap.get(colName);
                        metaObj.setDataType(dataType);
                    }
                    PopUpHandler popUpHandler = new PopUpHandler(userInfo);
                    String popUpString = popUpHandler.getPophelpFieldXML(colName, objName, pageContext);
                    metaObj.setPophelpInfo(popUpString);
                } else if ("text".equalsIgnoreCase(sub_nodes_name)) {
                    String text = childNode.getFirstChild().getNodeValue();
                    metaObj.setText(text);
                } else if ("X".equalsIgnoreCase(sub_nodes_name)) {
                    int xPos = Integer.parseInt(this.isUnits ? this.callWebservice(childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "0", "X") : (childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "0"));
                    metaObj.setXCord(xPos);
                } else if ("Y".equalsIgnoreCase(sub_nodes_name)) {
                    int yPos = Integer.parseInt(this.isUnits ? this.callWebservice(childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "0", "Y") : (childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "0"));
                    metaObj.setYCord(yPos);
                } else if ("WIDTH".equalsIgnoreCase(sub_nodes_name)) {
                    int width = Integer.parseInt(this.isUnits ? this.callWebservice(childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "0", "X") : (childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "0"));
                    metaObj.setWidth(width);
                } else if ("ALIGNMENT".equalsIgnoreCase(sub_nodes_name)) {
                    String alignment = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "";
                    metaObj.setAlignment(alignment);
                } else if ("visible".equalsIgnoreCase(sub_nodes_name)) {
                    String visible = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "";
                    metaObj.setVisible(visible);
                } else if ("FONT".equalsIgnoreCase(sub_nodes_name)) {
                    NodeList fontProperties;
                    NodeList nodeList = fontProperties = childNode.getFirstChild() != null ? childNode.getFirstChild().getChildNodes() : null;
                    if (fontProperties != null) {
                        int k = 0;
                        while (k < fontProperties.getLength()) {
                            Node propNode = fontProperties.item(k);
                            if ("face".equalsIgnoreCase(propNode.getNodeName())) {
                                String fontFace = propNode.getNodeValue();
                                metaObj.setFontFace(fontFace);
                            } else if ("height".equalsIgnoreCase(propNode.getNodeName())) {
                                String fontHeight = propNode.getNodeValue();
                                metaObj.setFontHeight(fontHeight);
                            }
                            ++k;
                        }
                    }
                } else if ("BORDER".equalsIgnoreCase(sub_nodes_name)) {
                    String border = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "";
                    metaObj.setBorder(border);
                } else if ("TABSEQUENCE".equalsIgnoreCase(sub_nodes_name)) {
                    String tabIndex = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "";
                    metaObj.setTabIndex(tabIndex);
                } else if ("EDITSTYLE".equalsIgnoreCase(sub_nodes_name)) {
                    Node styleAttrNode = childNode.getAttributes().getNamedItem("style");
                    String editStyle = "text";
                    if (styleAttrNode != null) {
                        editStyle = styleAttrNode.getNodeValue();
                    }
                    metaObj.setEditStyle(editStyle);
                    NodeList editStyleChildNodeList = childNode.getChildNodes();
                    int noOfEditStyleChilds = editStyleChildNodeList.getLength();
                    int k = 0;
                    while (k < noOfEditStyleChilds) {
                        int limit;
                        Node editStyleCurrChild = editStyleChildNodeList.item(k);
                        String editStyleChildNodeName = editStyleCurrChild.getNodeName();
                        if ("MASK".equalsIgnoreCase(editStyleChildNodeName) && editStyle.equalsIgnoreCase("editmask")) {
                            String maskStr;
                            String string = maskStr = editStyleCurrChild.getFirstChild() != null ? editStyleCurrChild.getFirstChild().getNodeValue() : "";
                            if (maskStr != null) {
                                limit = maskStr.length();
                                metaObj.setLimit(limit);
                            }
                            metaObj.setMask(maskStr);
                        }
                        if ("LIMIT".equalsIgnoreCase(editStyleChildNodeName)) {
                            limit = Integer.parseInt(editStyleCurrChild.getFirstChild() != null ? editStyleCurrChild.getFirstChild().getNodeValue() : "0");
                            metaObj.setLimit(limit);
                        }
                        if ("PASSWORD".equalsIgnoreCase(editStyleChildNodeName) && "yes".equalsIgnoreCase(editStyleCurrChild.getFirstChild() != null ? editStyleCurrChild.getFirstChild().getNodeValue() : "")) {
                            editStyle = "password";
                            metaObj.setEditStyle(editStyle);
                        }
                        if ("CASE".equalsIgnoreCase(editStyleChildNodeName)) {
                            String caseString = editStyleCurrChild.getFirstChild() != null ? editStyleCurrChild.getFirstChild().getNodeValue() : "";
                            metaObj.setCase(caseString);
                        }
                        if ("REQUIRED".equalsIgnoreCase(editStyleChildNodeName)) {
                            String required = editStyleCurrChild.getFirstChild() != null ? editStyleCurrChild.getFirstChild().getNodeValue() : "";
                            metaObj.setRequired(required);
                        }
                        if ("AUTOVSCROLL".equalsIgnoreCase(editStyleChildNodeName)) {
                            String autoScroll = editStyleCurrChild.getFirstChild() != null ? editStyleCurrChild.getFirstChild().getNodeValue() : "";
                            metaObj.setAutoScroll(autoScroll);
                        }
                        ++k;
                    }
                } else if ("PROTECT".equalsIgnoreCase(sub_nodes_name)) {
                    if (childNode.getAttributes().getNamedItem("expression") != null) {
                        String protect = childNode.getAttributes().getNamedItem("expression").getNodeValue();
                        metaObj.setProtect(protect);
                    }
                } else if ("HEIGHT".equalsIgnoreCase(sub_nodes_name)) {
                    String currentNodeValue = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "0";
                    int noOfRows = Integer.parseInt(currentNodeValue) / 15;
                    metaObj.setHeight(noOfRows);
                } else if ("FORMAT".equalsIgnoreCase(sub_nodes_name)) {
                    String format = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "0";
                    metaObj.setFormat(format);
                }
            }
            ++j;
        }
        return metaObj;
    }

    private int updateYCord(int yCordKey) {
        for (Integer pre_yCordKey : this.yTextMap.keySet()) {
            Integer diff_yCord = Math.abs(pre_yCordKey - yCordKey);
            if (diff_yCord > 10) continue;
            BaseLogger.log("3", null, null, "@@@DIFF_YCORD_FACTOR[" + pre_yCordKey + " - " + yCordKey + "]diff_yCord[" + diff_yCord + "]");
            return pre_yCordKey;
        }
        return yCordKey;
    }

    private String dataFieldFormDisplay(int editTmplt, ArrayList<String> gbNames, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("3", userInfo, null, "Inside dataFieldFormDisplay");
        StringBuffer freeFormXSLBuff = new StringBuffer();
        StringBuffer dataBar = new StringBuffer();
        HashMap<String, HashMap<String, String>> labelFormDataMap = new HashMap<String, HashMap<String, String>>();
        HashMap<String, HashMap<String, String>> inputFormDataMap = new HashMap<String, HashMap<String, String>>();
        HashMap tmpInputDataMap = new HashMap();
        HashMap tmpLabelDataMap = new HashMap();
        try {
            ArrayList<Object> objFormsDetail = null;
            String transDB = "";
            transDB = userInfo.getTransDB();
            objFormsDetail = this.getObjFormsDetailList(objName, userInfo);
            this.scanFlag = (String)((ArrayList)objFormsDetail.get(Integer.parseInt(objContext) - 1)).get(7);
            BaseLogger.log("3", userInfo, null, "Scan Flag for " + objContext + " is [" + this.scanFlag + "]");
            if ("Y".equalsIgnoreCase(this.scanFlag) && pageContext.equals("2") && !this.editFlag.equalsIgnoreCase("V")) {
                dataBar.append("<SPAN NAME =\"barcode_input_t\" id = \"barcode_input_t\" class = \"headerLabelField\" STYLE = \" text-align:RIGHT;  left: 25;  top: 0;  width: 82; position:ABSOLUTE;\" label=\"Bar Code\">Bar Code:</SPAN>");
                dataBar.append("<INPUT type='text' NAME='barcode_input' id='barcode_input{@domID}' fontCase='any' TABINDEX='10' TABORDER='10' POPUPEXISTS='false' protect='{barcode_input/@protect}' protectExpr='' ISCHANGED='false' onFocus='gotFocus(this)' SRVCALLONCHANGE='true' onBlur='autoPopulateData(this)' REQUIRED='yes' class='headerInputField' style='position:absolute;top:0;left:111;width:200;;TYPE:string;text-align:LEFT' >");
                dataBar.append("<xsl:attribute name='value'>");
                dataBar.append("<xsl:value-of select='barcode_input'/>");
                dataBar.append("</xsl:attribute></INPUT>");
                BaseLogger.log("3", userInfo, null, "dataBar 10012023 :[" + dataBar + "]");
                freeFormXSLBuff.append(dataBar);
            }
            this.parseMetadataObjects(userInfo);
            int colObjCtr = 0;
            int txtObjCtr = 0;
            for (Integer yCord : this.yTextMap.keySet()) {
                TreeMap<Integer, I18NMetadataObject> xTextMap = this.yTextMap.get(yCord);
                if (xTextMap == null) continue;
                for (Integer xCord : xTextMap.keySet()) {
                    I18NMetadataObject xMetadataObj = xTextMap.get(xCord);
                    BaseLogger.log("3", userInfo, null, "xCord..." + xCord + "xMetadataObj[" + xMetadataObj + "]");
                    if ("Text".equalsIgnoreCase(xMetadataObj.getMetaType())) {
                        BaseLogger.log("3", userInfo, null, "Text..." + txtObjCtr);
                        BaseLogger.log("3", userInfo, null, "10012023 Text xMetadataObj.getName() [" + xMetadataObj.getName() + "]");
                        labelFormDataMap.put(xMetadataObj.getName(), this.labelFieldFormMap(++txtObjCtr, xMetadataObj, pageContext, xCord, null));
                        continue;
                    }
                    BaseLogger.log("3", userInfo, null, "Column..." + colObjCtr);
                    BaseLogger.log("3", userInfo, null, "10012023 Column xMetadataObj.getName() [" + xMetadataObj.getName() + "]");
                    ++colObjCtr;
                    inputFormDataMap.put(xMetadataObj.getName(), this.inputFieldFormMap(txtObjCtr, xMetadataObj, pageContext, xCord, null, false));
                }
            }
            BaseLogger.log("3", userInfo, null, "labelFormDataMap:" + labelFormDataMap);
            BaseLogger.log("3", userInfo, null, "inputFormDataMap:" + inputFormDataMap);
            String visblTabData = " <TABLE class=\"browTableClass\"> \n <tr> \n";
            String invisbleTabData = "\n <TABLE style=\"display:none;\"> \n <tr> \n";
            String rowData = "";
            String xPos = "0";
            String yPos = "0";
            String xPosTmp = "0";
            String yPosTmp = "0";
            int xPosInt = 0;
            int yPosInt = 0;
            int xPosTmpInt = 0;
            int yPosTmpInt = 0;
            int pos = 0;
            int width = 0;
            int maxWidth = 0;
            ArrayList rowList = new ArrayList();
            ArrayList<Object> gbPosList = new ArrayList();
            gbPosList = this.getGbPosList(gbNames);
            for (String key : inputFormDataMap.keySet()) {
                HashMap<String, String> rowMap = new HashMap<String, String>();
                HashMap tmpRowMap = new HashMap();
                boolean flag = false;
                boolean lableExist = false;
                rowData = "";
                BaseLogger.log("3", userInfo, null, "------------------------------------------------");
                BaseLogger.log("3", userInfo, null, "key: " + key + " value: " + inputFormDataMap.get(key));
                String fieldName = "";
                if (!inputFormDataMap.containsKey(key)) continue;
                tmpInputDataMap = (HashMap)inputFormDataMap.get(key);
                rowData = String.valueOf(rowData) + (String)tmpInputDataMap.get("DATA");
                fieldName = (String)tmpInputDataMap.get("FIELD_NAME");
                if (labelFormDataMap.containsKey(String.valueOf(key) + "_t")) {
                    tmpLabelDataMap = (HashMap)labelFormDataMap.get(String.valueOf(key) + "_t");
                    rowData = ((String)tmpInputDataMap.get("ELEM_CLASS")).equalsIgnoreCase("DISPLAY") || ((String)tmpInputDataMap.get("DDLB")).equalsIgnoreCase("TRUE") ? (((String)tmpInputDataMap.get("REQUIRED")).equalsIgnoreCase("YES") && !this.editFlag.equalsIgnoreCase("V") ? String.valueOf(rowData) + ((String)tmpLabelDataMap.get("DATA")).replace("class = \"headerLabelField\"", "class = \"headerLabelField fixLabelField mandatoryRedImg\"") : String.valueOf(rowData) + ((String)tmpLabelDataMap.get("DATA")).replace("class = \"headerLabelField\"", "class = \"headerLabelField fixLabelField\"")) : (((String)tmpInputDataMap.get("REQUIRED")).equalsIgnoreCase("YES") && !this.editFlag.equalsIgnoreCase("V") ? String.valueOf(rowData) + ((String)tmpLabelDataMap.get("DATA")).replace("class = \"headerLabelField\"", "class = \"headerLabelField mandatoryRedImg\"") : String.valueOf(rowData) + (String)tmpLabelDataMap.get("DATA"));
                    lableExist = true;
                } else {
                    rowData = String.valueOf(rowData);
                    lableExist = false;
                }
                xPos = (String)tmpInputDataMap.get("XPOS");
                yPos = (String)tmpInputDataMap.get("YPOS");
                width = Integer.parseInt((String)tmpInputDataMap.get("WIDTH"));
                if (width > maxWidth) {
                    maxWidth = width;
                }
                rowMap.put("XPOS", xPos);
                rowMap.put("YPOS", yPos);
                rowMap.put("ROWDATA", rowData);
                rowMap.put("LABLE_EXIST", String.valueOf(lableExist));
                rowMap.put("FIELD_NAME", fieldName);
                pos = rowList.size();
                xPosInt = Integer.parseInt((String)rowMap.get("XPOS"));
                yPosInt = Integer.parseInt((String)rowMap.get("YPOS"));
                int yPosIter = rowList.size();
                while (yPosIter > 0) {
                    int yPosCnt = yPosIter - 1;
                    tmpRowMap = (HashMap)rowList.get(yPosCnt);
                    xPosTmp = (String)tmpRowMap.get("XPOS");
                    yPosTmp = (String)tmpRowMap.get("YPOS");
                    xPosTmpInt = Integer.parseInt(xPosTmp);
                    yPosTmpInt = Integer.parseInt(yPosTmp);
                    if (yPosInt >= yPosTmpInt) break;
                    pos = yPosCnt;
                    --yPosIter;
                }
                int xPosCnt = pos - 1;
                while (xPosCnt >= 0) {
                    tmpRowMap = (HashMap)rowList.get(xPosCnt);
                    xPosTmp = (String)tmpRowMap.get("XPOS");
                    yPosTmp = (String)tmpRowMap.get("YPOS");
                    xPosTmpInt = Integer.parseInt(xPosTmp);
                    yPosTmpInt = Integer.parseInt(yPosTmp);
                    if (xPosInt >= xPosTmpInt || yPosInt != yPosTmpInt) break;
                    pos = xPosCnt--;
                }
                if (flag) continue;
                BaseLogger.log("3", userInfo, null, "Adding At Position:" + pos);
                rowList.add(pos, rowMap);
            }
            BaseLogger.log("3", userInfo, null, " HeaderXSL rowList 10012023 :[" + rowList + "]");
            visblTabData = String.valueOf(visblTabData) + " \n <input type=\"hidden\" id=\"maxWidthSction\" value=\"" + maxWidth + "\" /> ";
            visblTabData = String.valueOf(visblTabData) + " \n <td valign=\"top\" > ";
            visblTabData = String.valueOf(visblTabData) + " \n <div class=\"contents\" id=\"TransContents\"> ";
            visblTabData = String.valueOf(visblTabData) + " \n <div class=\"freeFormContents main-flowpanel-container\"  style=\"width: 100%;\"> ";
            int i = 0;
            while (i < rowList.size()) {
                HashMap finalRowMap = new HashMap();
                finalRowMap = (HashMap)rowList.get(i);
                String fieldName = (String)finalRowMap.get("FIELD_NAME");
                String exactEleName = fieldName.substring(fieldName.lastIndexOf(".") + 1);
                if (gbPosList.size() > 0) {
                    if (this.checkColVisibility(finalRowMap, gbPosList)) {
                        visblTabData = ((String)finalRowMap.get("LABLE_EXIST")).equalsIgnoreCase("true") ? String.valueOf(visblTabData) + " \n <div id=\"" + fieldName + "_displayDiv\" visible=\"{" + exactEleName + "/@visible}\" class=\"e12CustomInputPanel\" style=\"position: relative; overflow: hidden;\"> " : String.valueOf(visblTabData) + " \n <div id=\"" + fieldName + "_displayDiv\" visible=\"{" + exactEleName + "/@visible}\" class=\"e12CustomInputNoLblPanel\" style=\"position: relative; overflow: hidden;\"> ";
                        visblTabData = String.valueOf(visblTabData) + " \n " + (String)finalRowMap.get("ROWDATA");
                        visblTabData = String.valueOf(visblTabData) + " </div>";
                    } else {
                        invisbleTabData = String.valueOf(invisbleTabData) + " \n <td> ";
                        invisbleTabData = String.valueOf(invisbleTabData) + (String)finalRowMap.get("ROWDATA");
                        invisbleTabData = String.valueOf(invisbleTabData) + " \n </td> ";
                    }
                } else {
                    visblTabData = ((String)finalRowMap.get("LABLE_EXIST")).equalsIgnoreCase("true") ? String.valueOf(visblTabData) + " \n <div id=\"" + fieldName + "_displayDiv\" visible=\"{" + exactEleName + "/@visible}\" class=\"e12CustomInputPanel\" style=\"position: relative; overflow: hidden;\"> " : String.valueOf(visblTabData) + " \n <div id=\"" + fieldName + "_displayDiv\" visible=\"{" + exactEleName + "/@visible}\"  class=\"e12CustomInputNoLblPanel\" style=\"position: relative; overflow: hidden;\"> ";
                    visblTabData = String.valueOf(visblTabData) + " \n " + (String)finalRowMap.get("ROWDATA");
                    visblTabData = String.valueOf(visblTabData) + " </div>";
                }
                ++i;
            }
            visblTabData = String.valueOf(visblTabData) + "\n </div> </div> ";
            visblTabData = String.valueOf(visblTabData) + "\n </td> </tr> \n </TABLE> ";
            invisbleTabData = String.valueOf(invisbleTabData) + "\n </tr> \n </TABLE> ";
            freeFormXSLBuff.append(visblTabData);
            freeFormXSLBuff.append(invisbleTabData);
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception:[GenerateFormLayout]:dataFieldDisplay " + e);
            throw new ITMException(e);
        }
        BaseLogger.log("3", userInfo, null, "freeFormXSLBuff.toString() 10012023 :[" + freeFormXSLBuff.toString() + "]");
        return freeFormXSLBuff.toString();
    }

    private boolean checkColVisibility(HashMap<String, String> dataRowMap, ArrayList<HashMap<String, String>> gbPosList) {
        boolean visibility = false;
        int gbX = 0;
        int gbY = 0;
        int gbHeigth = 0;
        int gbWidth = 0;
        int colX = 0;
        int colY = 0;
        colX = Integer.parseInt(dataRowMap.get("XPOS"));
        colY = Integer.parseInt(dataRowMap.get("YPOS"));
        HashMap<Object, Object> gbPosMap = new HashMap();
        BaseLogger.log("2", null, null, "Checking Column Visibility.........");
        BaseLogger.log("2", null, null, "COLXPOS:" + colX);
        BaseLogger.log("2", null, null, "COLYPOS:" + colY);
        BaseLogger.log("2", null, null, "ROWDATA:" + dataRowMap.get("ROWDATA"));
        int i = 0;
        while (i < gbPosList.size()) {
            gbPosMap = gbPosList.get(i);
            gbX = Integer.parseInt((String)gbPosMap.get("GBXPOS"));
            gbY = Integer.parseInt((String)gbPosMap.get("GBYPOS"));
            gbHeigth = Integer.parseInt((String)gbPosMap.get("GBHEIGHT"));
            gbWidth = Integer.parseInt((String)gbPosMap.get("GBWIDTH"));
            BaseLogger.log("3", null, null, "GBXPOS:" + gbX);
            BaseLogger.log("3", null, null, "GBYPOS:" + gbY);
            BaseLogger.log("3", null, null, "GBHeight:" + gbHeigth);
            BaseLogger.log("3", null, null, "GBWidth:" + gbWidth);
            if (colX >= gbX && colX <= gbX + gbWidth && colY >= gbY && colY <= gbY + gbHeigth) {
                visibility = true;
            }
            ++i;
        }
        return visibility;
    }

    private ArrayList<HashMap<String, String>> getGbPosList(ArrayList<String> gbNames) {
        NodeList gbNodeList = this.doc.getElementsByTagName("GroupBox");
        String gbXpos = "0";
        String gbYpos = "0";
        String gbHeight = "0";
        String gbWidth = "0";
        String gbName = "";
        String gbChildNodeName = "";
        NodeList gbChildNodeList = null;
        Node gbNode = null;
        Node gbChildNode = null;
        ArrayList<HashMap<String, String>> gbPosList = new ArrayList<HashMap<String, String>>();
        int gbCtr = 0;
        while (gbCtr < gbNodeList.getLength()) {
            gbNode = gbNodeList.item(gbCtr);
            gbChildNodeList = gbNode.getChildNodes();
            int childCtr = 0;
            while (childCtr < gbChildNodeList.getLength()) {
                gbChildNode = gbChildNodeList.item(childCtr);
                gbChildNodeName = gbChildNode.getNodeName();
                if (gbChildNodeName.equalsIgnoreCase("x") && gbChildNode != null && gbChildNode.getFirstChild() != null) {
                    gbXpos = gbChildNode.getFirstChild().getNodeValue();
                }
                if (gbChildNodeName.equalsIgnoreCase("y") && gbChildNode != null && gbChildNode.getFirstChild() != null) {
                    gbYpos = gbChildNode.getFirstChild().getNodeValue();
                }
                if (gbChildNodeName.equalsIgnoreCase("height") && gbChildNode != null && gbChildNode.getFirstChild() != null) {
                    gbHeight = gbChildNode.getFirstChild().getNodeValue();
                }
                if (gbChildNodeName.equalsIgnoreCase("width") && gbChildNode != null && gbChildNode.getFirstChild() != null) {
                    gbWidth = gbChildNode.getFirstChild().getNodeValue();
                }
                if (gbChildNodeName.equalsIgnoreCase("text") && gbChildNode != null && gbChildNode.getFirstChild() != null) {
                    gbName = gbChildNode.getFirstChild().getNodeValue();
                }
                ++childCtr;
            }
            HashMap<String, String> gbPosMap = new HashMap<String, String>();
            gbPosMap.put("GBName", gbName);
            gbPosMap.put("GBXPOS", gbXpos);
            gbPosMap.put("GBYPOS", gbYpos);
            gbPosMap.put("GBHEIGHT", gbHeight);
            gbPosMap.put("GBWIDTH", gbWidth);
            gbPosList.add(gbPosMap);
            ++gbCtr;
        }
        return gbPosList;
    }

    private String getDetailTableData(ArrayList<String> gbNames, UserInfoBean userInfo, Boolean isTaxApplicable) throws ITMException {
        StringBuffer gridFormXSLBuff = new StringBuffer();
        HashMap<String, HashMap<String, String>> labelFormDataMap = new HashMap<String, HashMap<String, String>>();
        HashMap<String, HashMap<String, String>> inputFormDataMap = new HashMap<String, HashMap<String, String>>();
        HashMap tmpInputDataMap = new HashMap();
        HashMap tmpLabelDataMap = new HashMap();
        ArrayList rowList = new ArrayList();
        try {
            ArrayList<Object> objFormsDetail = null;
            String transDB = "";
            transDB = userInfo.getTransDB();
            objFormsDetail = this.getObjFormsDetailList(objName, userInfo);
            this.scanFlag = (String)((ArrayList)objFormsDetail.get(Integer.parseInt(objContext) - 1)).get(7);
            BaseLogger.log("3", userInfo, null, "Scan Flag for " + objContext + " is [" + this.scanFlag + "]");
            ArrayList<HashMap<String, String>> gbPosList = new ArrayList();
            gbPosList = this.getGbPosList(gbNames);
            this.parseMetadataObjects(userInfo);
            int colObjCtr = 0;
            int txtObjCtr = 0;
            for (Integer yCord : this.yTextMap.keySet()) {
                TreeMap<Integer, I18NMetadataObject> xTextMap = this.yTextMap.get(yCord);
                BaseLogger.log("3", userInfo, null, "yCord..." + yCord + "xTextMap[" + xTextMap + "]");
                if (xTextMap == null) continue;
                for (Integer xCord : xTextMap.keySet()) {
                    I18NMetadataObject xMetadataObj = xTextMap.get(xCord);
                    BaseLogger.log("3", userInfo, null, "xCord..." + xCord + "xMetadataObj[" + xMetadataObj + "]");
                    if ("Text".equalsIgnoreCase(xMetadataObj.getMetaType())) {
                        BaseLogger.log("3", userInfo, null, "Text..." + txtObjCtr);
                        labelFormDataMap.put(xMetadataObj.getName(), this.labelFieldFormMap(++txtObjCtr, xMetadataObj, "1", xCord, gbPosList));
                        continue;
                    }
                    BaseLogger.log("3", userInfo, null, "Column..." + colObjCtr);
                    ++colObjCtr;
                    inputFormDataMap.put(xMetadataObj.getName(), this.inputFieldFormMap(txtObjCtr, xMetadataObj, "1", xCord, gbPosList, isTaxApplicable));
                }
            }
            BaseLogger.log("3", userInfo, null, "labelFormDataMap:" + labelFormDataMap);
            BaseLogger.log("3", userInfo, null, "inputFormDataMap:" + inputFormDataMap);
            String tabHeaderData = " <THEAD class='table-head'> \n";
            String tabBodyData = " <TBODY class='table-body'>\n ";
            tabBodyData = objName.equalsIgnoreCase("taxtran") ? String.valueOf(tabBodyData) + "<xsl:for-each select=\"./Taxes/Tax[attribute/@updateFlag!='D']\">\n" : String.valueOf(tabBodyData) + "<xsl:for-each select=\"./Detail" + objContext + "[attribute/@updateFlag!='D']\">\n";
            tabBodyData = String.valueOf(tabBodyData) + " <xsl:sort select=\"@domID\" data-type=\"number\" />\n";
            tabBodyData = objName.equalsIgnoreCase("taxtran") ? String.valueOf(tabBodyData) + "\n<TR id=\"{@dbID}\" name=\"" + objContext + ".{@domID}\" class=\"trClass \"  onClick=\"setSelectionTax(this)\" onContextMenu=\"showContexMenus(event,'" + objContext + "',this);setSelectionTax(this);return false;\">" : String.valueOf(tabBodyData) + "\n<TR id=\"{@dbID}\" name=\"" + objContext + ".{@domID}\" class=\"trClass \"  onClick=\"setSelection(this)\" onContextMenu=\"showContexMenus(event,'" + objContext + "',this);setSelection(this);return false;\">";
            tabBodyData = String.valueOf(tabBodyData) + "\n<xsl:variable name=\"updateFlag\"><xsl:value-of select=\"attribute/@updateFlag\" /></xsl:variable>";
            tabBodyData = String.valueOf(tabBodyData) + "\n<input type=\"hidden\" value=\"{$updateFlag}\" name=\"Detail" + objContext + ".{normalize-space(@domID)}.updateFlag\" id=\"Detail" + objContext + ".{normalize-space(@domID)}.updateFlag\" />";
            tabBodyData = String.valueOf(tabBodyData) + "\n<input type=\"hidden\" value=\"{@dbID}\" name=\"Detail" + objContext + ".{normalize-space(@domID)}.dbID\" id=\"Detail" + objContext + ".{normalize-space(@domID)}.dbID\" />";
            tabBodyData = String.valueOf(tabBodyData) + "\n<input type=\"hidden\" value=\"{@objName}\" name=\"Detail" + objContext + ".{normalize-space(@domID)}.objName\" id=\"Detail" + objContext + ".{normalize-space(@domID)}.objName\" />";
            tabBodyData = String.valueOf(tabBodyData) + "\n<xsl:variable name=\"pkNames\"><xsl:value-of select=\"attribute/@pkNames\" /></xsl:variable>";
            tabBodyData = String.valueOf(tabBodyData) + "\n<xsl:variable name=\"dbStatus\"><xsl:value-of select=\"attribute/@status\" /></xsl:variable>";
            tabBodyData = String.valueOf(tabBodyData) + "\n<input type=\"hidden\" value=\"{$pkNames}\" name=\"Detail" + objContext + ".{normalize-space(@domID)}.pkNames\" id=\"Detail" + objContext + ".{normalize-space(@domID)}.pkNames\" />";
            tabBodyData = String.valueOf(tabBodyData) + "\n<input type=\"hidden\" value=\"{$dbStatus}\" name=\"Detail" + objContext + ".{normalize-space(@domID)}.dbStatus\" id=\"Detail" + objContext + ".{normalize-space(@domID)}.dbStatus\" />";
            if (isTaxApplicable.booleanValue()) {
                tabBodyData = String.valueOf(tabBodyData) + "\n<input type=\"hidden\" value=\"\" name=\"Detail2.{normalize-space(@domID)}.Taxes\" id=\"Detail2.{normalize-space(@domID)}.Taxes{@domID}\" >";
                tabBodyData = String.valueOf(tabBodyData) + "\n<xsl:attribute name=\"value\">";
                tabBodyData = String.valueOf(tabBodyData) + "\n<xsl:apply-templates select=\"Taxes\" mode=\"serialize\" />";
                tabBodyData = String.valueOf(tabBodyData) + "\n</xsl:attribute>";
                tabBodyData = String.valueOf(tabBodyData) + "\n</input>";
            }
            String xPos = "0";
            String yPos = "0";
            String xPosTmp = "0";
            String yPosTmp = "0";
            String rowData = "";
            String headData = "";
            int xPosInt = 0;
            int yPosInt = 0;
            int xPosTmpInt = 0;
            int yPosTmpInt = 0;
            int pos = 0;
            boolean flag = false;
            boolean isVisible = true;
            for (String key : inputFormDataMap.keySet()) {
                HashMap<String, String> rowMap = new HashMap<String, String>();
                HashMap tmpRowMap = new HashMap();
                BaseLogger.log("3", userInfo, null, "------------------------------------------------");
                flag = false;
                tmpInputDataMap = (HashMap)inputFormDataMap.get(key);
                if (labelFormDataMap.containsKey(String.valueOf(key) + "_t")) {
                    tmpLabelDataMap = (HashMap)labelFormDataMap.get(String.valueOf(key) + "_t");
                    headData = ((String)tmpLabelDataMap.get("DATA")).replaceFirst("STYLE = \" position:relative;", "STYLE = \" position:relative; width:" + (String)tmpInputDataMap.get("WIDTH") + ";text-align:" + (String)tmpInputDataMap.get("HDR_ALIGN") + ";");
                    BaseLogger.log("3", userInfo, null, "detailtmpInputDataMap:" + tmpInputDataMap);
                    if (((String)tmpInputDataMap.get("REQUIRED")).equalsIgnoreCase("YES") && !this.editFlag.equalsIgnoreCase("V")) {
                        headData = headData.replaceFirst("class = \"thClass\"", "class=\"thClass mandatoryRedImg\"");
                    }
                    rowData = (String)tmpInputDataMap.get("DATA");
                } else {
                    isVisible = Boolean.valueOf((String)tmpInputDataMap.get("VISIBLE"));
                    headData = "<TH class=\"thClass\"  style=\"display:none;\" >" + key + "</TH>";
                    rowData = (String)tmpInputDataMap.get("DATA");
                    rowData = rowData.replaceFirst("<TD style=\"", "<TD style=\"display:none;");
                }
                xPos = (String)tmpInputDataMap.get("XPOS");
                yPos = (String)tmpInputDataMap.get("YPOS");
                rowMap.put("XPOS", xPos);
                rowMap.put("YPOS", yPos);
                rowMap.put("ROWDATA", rowData);
                rowMap.put("HEADDATA", headData);
                pos = rowList.size();
                xPosInt = Integer.parseInt((String)rowMap.get("XPOS"));
                yPosInt = Integer.parseInt((String)rowMap.get("YPOS"));
                int yPosIter = rowList.size();
                while (yPosIter > 0) {
                    int yPosCnt = yPosIter - 1;
                    tmpRowMap = (HashMap)rowList.get(yPosCnt);
                    xPosTmp = (String)tmpRowMap.get("XPOS");
                    yPosTmp = (String)tmpRowMap.get("YPOS");
                    xPosTmpInt = Integer.parseInt(xPosTmp);
                    yPosTmpInt = Integer.parseInt(yPosTmp);
                    if (yPosInt >= yPosTmpInt) break;
                    pos = yPosCnt;
                    --yPosIter;
                }
                int xPosCnt = pos - 1;
                while (xPosCnt >= 0) {
                    tmpRowMap = (HashMap)rowList.get(xPosCnt);
                    xPosTmp = (String)tmpRowMap.get("XPOS");
                    yPosTmp = (String)tmpRowMap.get("YPOS");
                    xPosTmpInt = Integer.parseInt(xPosTmp);
                    yPosTmpInt = Integer.parseInt(yPosTmp);
                    if (xPosInt >= xPosTmpInt || yPosInt != yPosTmpInt) break;
                    pos = xPosCnt--;
                }
                if (flag) continue;
                BaseLogger.log("3", userInfo, null, "Adding At Position:" + pos);
                rowList.add(pos, rowMap);
            }
            BaseLogger.log("3", userInfo, null, " rowList 10012023 :[" + rowList + "]");
            int i = 0;
            while (i < rowList.size()) {
                HashMap finalRowMap = new HashMap();
                finalRowMap = (HashMap)rowList.get(i);
                tabBodyData = String.valueOf(tabBodyData) + (String)finalRowMap.get("ROWDATA");
                tabHeaderData = String.valueOf(tabHeaderData) + (String)finalRowMap.get("HEADDATA");
                ++i;
            }
            if (!objName.equalsIgnoreCase("taxtran") && !this.editFlag.equalsIgnoreCase("V")) {
                tabHeaderData = String.valueOf(tabHeaderData) + "<TH class=\"thClass deleteThClass\" fixedWidth=\"true\" >  </TH>";
            }
            tabHeaderData = String.valueOf(tabHeaderData) + "</THEAD>";
            gridFormXSLBuff.append(tabHeaderData);
            if (!objName.equalsIgnoreCase("taxtran") && !this.editFlag.equalsIgnoreCase("V")) {
                tabBodyData = String.valueOf(tabBodyData) + "<TD class=\"tdClass deleteTdClass\" fixedWidth=\"true\" > <span class=\"deleteBtnSpanClass\" >&#160;</span> </TD>";
            }
            gridFormXSLBuff.append(tabBodyData);
            gridFormXSLBuff.append("\n</TR>");
            gridFormXSLBuff.append("</xsl:for-each>\n");
            gridFormXSLBuff.append("</TBODY>\n</TABLE>\n");
            BaseLogger.log("3", userInfo, null, " gridFormXSLBuff 10012023 :[" + gridFormXSLBuff + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception:[GenerateFormLayout]:dataFieldDisplay " + e);
            throw new ITMException(e);
        }
        return gridFormXSLBuff.toString();
    }

    private HashMap<String, String> labelFieldFormMap(int textObjCntr, I18NMetadataObject textObj, String pageContxt, Integer xCord, ArrayList<HashMap<String, String>> gbPosList) throws ITMException {
        HashMap<String, String> labelDataMap = new HashMap<String, String>();
        String xslTextToBeAdded = "";
        int xPos = 0;
        int yPos = 0;
        try {
            String tempWidth;
            HashMap<String, String> dataMap = new HashMap<String, String>();
            String childValue = "";
            String alignTblHdrStr = null;
            String temp = "";
            String currId = "";
            boolean isTextLabelVisible = true;
            String tempStr = "";
            if (pageContxt.equalsIgnoreCase("1")) {
                String oName = textObj.getName();
                if (oName.length() > 2) {
                    oName = oName.substring(0, oName.length() - 2);
                    this.globalColNameList.add(oName);
                }
                String lsDataType = (String)this.dataTypeMap.get(oName);
                String type = "";
                type = lsDataType == null ? "text" : ("String".equalsIgnoreCase(lsDataType) ? "text" : ("datetime".equalsIgnoreCase(lsDataType) ? "date" : "number"));
                if (!objName.equalsIgnoreCase("TAXTRAN")) {
                    tempStr = " onClick=\"ts_resortTable(this," + textObjCntr + ",'" + type + "')\" ";
                }
                xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + "<TH ";
            } else if (pageContxt.equalsIgnoreCase("2")) {
                xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + "<SPAN ";
            }
            xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + "NAME =\"" + textObj.getName() + "\"";
            currId = textObj.getName();
            xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + " id = \"" + currId + "\"";
            xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + tempStr;
            if (this.isCssFile) {
                xslTextToBeAdded = pageContxt.equalsIgnoreCase("2") ? String.valueOf(xslTextToBeAdded) + " class = \"headerLabelField\" STYLE = \"" : String.valueOf(xslTextToBeAdded) + " class = \"thClass\" STYLE = \"";
            }
            if (!this.isCssFile) {
                xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + " style=\"color:#COCOCO;background:#COCOCO;";
            }
            if ((childValue = textObj.getText()) != null) {
                childValue = childValue.replaceAll("&", "&amp;");
            }
            xPos = xCord;
            yPos = Integer.parseInt(this.isUnits ? this.callWebservice(textObj.getYCord(), "Y") : textObj.getYCord());
            dataMap.put("XPOS", String.valueOf(xPos));
            dataMap.put("YPOS", String.valueOf(yPos));
            int width = textObj.getIntWidth();
            String string = tempWidth = this.isUnits ? this.callWebservice(textObj.getXCord(), "X") : String.valueOf(width);
            if (tempWidth != null) {
                if (!pageContxt.equalsIgnoreCase("1")) {
                    temp = String.valueOf(temp) + " width: " + tempWidth + ";";
                }
                this.tableWidth += width;
            }
            temp = String.valueOf(temp) + " position:relative;";
            alignTblHdrStr = textObj.getAlignment();
            if (alignTblHdrStr != null) {
                if (alignTblHdrStr.equals("0")) {
                    alignTblHdrStr = "LEFT";
                } else if (alignTblHdrStr.equals("1")) {
                    alignTblHdrStr = "RIGHT";
                } else if (alignTblHdrStr.equals("2")) {
                    alignTblHdrStr = "CENTER";
                } else if (alignTblHdrStr.equals("3")) {
                    alignTblHdrStr = "JUSTIFY";
                }
            }
            boolean bl = isTextLabelVisible = textObj.getVisible().equals("1");
            if (!isTextLabelVisible) {
                temp = String.valueOf(temp) + " display:none; ";
            }
            if (!this.isCssFile) {
                temp = String.valueOf(temp) + "font-family:" + textObj.getFontFace();
                temp = String.valueOf(temp) + " font-size:" + textObj.getFontHeight();
                temp = String.valueOf(temp) + " border:" + textObj.getBorder() + "; ";
            }
            if (pageContxt.equalsIgnoreCase("1") && gbPosList.size() > 0 && !this.checkColVisibility(dataMap, gbPosList)) {
                temp = String.valueOf(temp) + " display:none; ";
            }
            xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + temp;
            if (!this.isCssFile) {
                xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + "\"";
                xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + " label=\"" + (childValue.lastIndexOf(":") != -1 ? childValue.substring(0, childValue.lastIndexOf(":")) : childValue) + "\"";
                xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + ">";
                if (pageContxt.equalsIgnoreCase("1")) {
                    xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + "<nobr>";
                }
            } else {
                xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + " \" label=\"" + (childValue.lastIndexOf(":") != -1 ? childValue.substring(0, childValue.lastIndexOf(":")) : childValue);
                xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + "\">";
                if (pageContxt.equalsIgnoreCase("1")) {
                    xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + "<nobr>";
                }
            }
            if (pageContxt.equalsIgnoreCase("1")) {
                xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + (childValue.lastIndexOf(":") != -1 ? childValue.substring(0, childValue.lastIndexOf(":")) : childValue).trim() + "<IMAGE id='" + currId + textObjCntr + "' style='visibility:hidden;position:absolute;' src='../images/" + this.displayTheme + "/upsimple.png'/></nobr></TH>\n";
            } else if (pageContxt.equalsIgnoreCase("2")) {
                xslTextToBeAdded = String.valueOf(xslTextToBeAdded) + (childValue.lastIndexOf(":") != -1 ? childValue.substring(0, childValue.lastIndexOf(":")) : childValue) + "\n" + "</SPAN>\n";
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception:[GenerateFormLayout]:labelFieldFormMap" + e);
            throw new ITMException(e);
        }
        labelDataMap.put("DATA", xslTextToBeAdded);
        labelDataMap.put("XPOS", String.valueOf(xPos));
        labelDataMap.put("YPOS", String.valueOf(yPos));
        BaseLogger.log("3", null, null, "10012023 labelDataMap [" + labelDataMap + "]");
        return labelDataMap;
    }

    private HashMap<String, String> inputFieldFormMap(int colObjCtr, I18NMetadataObject colObj, String pageContxt, Integer xCord, ArrayList<HashMap<String, String>> gbPosList, Boolean isTaxApplicable) throws ITMException {
        String xslInputToBeAdded = "";
        HashMap<String, String> inputFieldDataMap = new HashMap<String, String>();
        int xPos = -1;
        int yPos = -1;
        int width = -1;
        boolean isVisible = false;
        String elemType = "text";
        String elemClass = "EDIT";
        String alignStr = "LEFT";
        String headerAlign = "LEFT";
        String requiredString = "";
        String fieldName = "";
        String isDDLb = "false";
        try {
            String textAlign;
            StringBuffer dataFieldDisBuff = null;
            StringBuffer styleStrBuff = null;
            StringBuffer addAttrBuff = null;
            String tooltipAttrib = "  onmouseover=\" showToolTip(this); \"  ";
            String colName = "";
            boolean isEditableCol = false;
            String dataType = "";
            boolean isPrimaryKey = false;
            int tabIndex = -1;
            int limit = -1;
            int noOfRows = -1;
            String autoVScroll = "";
            String caseString = "";
            String protectString = "";
            String optionString = "";
            String maskStr = "";
            String tdAlignStr = "left";
            HashMap<String, String> dataMap = new HashMap<String, String>();
            colName = colObj.getName();
            String tabIndexStr = colObj.getTabIndex();
            String tabRefix = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
            int prefixLen = 0;
            String format = "";
            if (!tabIndexStr.equalsIgnoreCase("32766") && !objContext.equalsIgnoreCase("1")) {
                prefixLen = 2 * Integer.parseInt(objContext) - 2;
            }
            BaseLogger.log("3", null, null, "PrefixLength:" + prefixLen + "objContext:" + objContext);
            tabIndex = "Y".equalsIgnoreCase(this.scanFlag) && Integer.parseInt(tabIndexStr) != 0 && Integer.parseInt(tabIndexStr) != 32766 ? Integer.parseInt(tabIndexStr) + 10 : Integer.parseInt(tabIndexStr);
            xPos = xCord;
            String yCordStr = colObj.getYCord();
            yPos = Integer.parseInt(this.isUnits ? this.callWebservice(yCordStr, "Y") : yCordStr);
            dataMap.put("XPOS", String.valueOf(xPos));
            dataMap.put("YPOS", String.valueOf(yPos));
            String widthStr = colObj.getWidth();
            width = Integer.parseInt(this.isUnits ? this.callWebservice(widthStr, "X") : widthStr);
            elemType = colObj.getEditStyle();
            limit = colObj.getLimit();
            caseString = colObj.getCase();
            requiredString = colObj.getRequired();
            autoVScroll = colObj.getAutoScroll();
            protectString = colObj.getProtect();
            isVisible = colObj.getVisible().equals("1");
            BaseLogger.log("3", null, null, "Setting isVisible[" + isVisible + "] dataFieldDisplay(I)");
            noOfRows = colObj.getHeight() / 15;
            alignStr = colObj.getAlignment();
            maskStr = colObj.getMask();
            format = colObj.getFormat();
            if (alignStr.equals("0")) {
                alignStr = "LEFT";
            } else if (alignStr.equals("1")) {
                alignStr = "RIGHT";
            } else if (alignStr.equals("2")) {
                alignStr = "CENTER";
            } else if (alignStr.equals("3")) {
                alignStr = "JUSTIFY";
            }
            headerAlign = alignStr;
            isPrimaryKey = Boolean.valueOf((String)this.primarykeyMap.get(colName));
            dataType = (String)this.dataTypeMap.get(colName);
            if (elemType.equalsIgnoreCase("ddlb")) {
                this.getOptionString(isPrimaryKey, tabIndex);
                optionString = (String)this.optionMap.get(colName);
                BaseLogger.log("3", null, null, "10012023 Column optionString [" + optionString + "]");
                isDDLb = "true";
            }
            dataFieldDisBuff = new StringBuffer();
            styleStrBuff = new StringBuffer();
            addAttrBuff = new StringBuffer();
            String newColName = colName;
            fieldName = "Detail" + objContext + ".{normalize-space(@domID)}." + colName;
            addAttrBuff.append(" NAME=\"Detail" + objContext + ".{normalize-space(@domID)}.").append(newColName).append("\"");
            String tempColName = newColName;
            addAttrBuff.append(" id=\"Detail" + objContext + ".{normalize-space(@domID)}.").append(tempColName).append("{@domID}\"");
            addAttrBuff.append(" onKeyDown=\"return onKeyDownFun(this,event)\" ");
            addAttrBuff.append(" fontCase=\"" + caseString + "\"");
            if (!this.isCssFile) {
                styleStrBuff.append("color:#COCOCO;background:#FFFFFF;");
            } else if (pageContxt.equals("1")) {
                styleStrBuff.append("position:relative;width:" + width + ";min-width:" + width + ";");
            } else {
                styleStrBuff.append("position:relative;");
            }
            headerAlign = textAlign = "number".equalsIgnoreCase(dataType) ? "RIGHT" : "LEFT";
            if (objContext.equals("1") && isPrimaryKey) {
                if (this.editFlag.equalsIgnoreCase("A") && this.keyFlag.equalsIgnoreCase("M") && !objName.equalsIgnoreCase("taxtran")) {
                    isEditableCol = true;
                }
            } else if (tabIndex != 32766 && (this.editFlag.equalsIgnoreCase("E") || this.editFlag.equalsIgnoreCase("A"))) {
                isEditableCol = true;
            }
            if ("datetime".equalsIgnoreCase(dataType) || "date".equalsIgnoreCase(dataType) || limit == 0) {
                if (!isEditableCol) {
                    addAttrBuff.append(" TABINDEX=\"" + -tabIndex + "\"").append(" TABORDER=\"" + -tabIndex + "\"");
                } else if (prefixLen == 0) {
                    addAttrBuff.append(" TABINDEX=\"{normalize-space(@domID)}" + tabIndex + "\"").append(" TABORDER=\"{normalize-space(@domID)}" + tabIndex + "\"");
                } else {
                    addAttrBuff.append(" TABINDEX=\"{normalize-space(@domID)}1" + tabRefix.substring(0, prefixLen) + tabIndexStr + "\"").append(" TABORDER=\"{normalize-space(@domID)}1" + tabRefix.substring(0, prefixLen) + tabIndexStr + "\"");
                }
                if ("datetime".equalsIgnoreCase(dataType) || "date".equalsIgnoreCase(dataType) || "timestamp".equalsIgnoreCase(dataType)) {
                    dataType = maskStr.toLowerCase().startsWith("hh:mm:ss") ? "time" : (maskStr.toLowerCase().indexOf("hh:mm") != -1 ? "datetime" : "date");
                }
                addAttrBuff.append(" format=\"" + format + "\"");
            } else if (!isEditableCol) {
                addAttrBuff.append(" TABINDEX=\"" + -tabIndex + "\"").append(" TABORDER=\"" + -tabIndex + "\"").append(" MAXLENGTH=\"" + limit + "\"");
            } else if (prefixLen == 0) {
                addAttrBuff.append(" TABINDEX=\"{normalize-space(@domID)}" + tabIndex + "\"").append(" TABORDER=\"{normalize-space(@domID)}" + tabIndex + "\"").append(" MAXLENGTH=\"" + limit + "\"");
            } else {
                addAttrBuff.append(" TABINDEX=\"{normalize-space(@domID)}1" + tabRefix.substring(0, prefixLen) + tabIndexStr + "\"").append(" TABORDER=\"{normalize-space(@domID)}1" + tabRefix.substring(0, prefixLen) + tabIndexStr + "\"").append(" MAXLENGTH=\"" + limit + "\"");
            }
            if (isEditableCol) {
                styleStrBuff.append(";TYPE:" + dataType + ";text-align:" + textAlign);
                String popUpString = colObj.getPophelpInfo();
                HashMap<String, String> pophelpInfoMap = this.createPophelpInfoMap(popUpString);
                if (pophelpInfoMap != null && !pophelpInfoMap.isEmpty()) {
                    String popupParams = pophelpInfoMap.get("POPUPPARAMETERS");
                    if ("null".equalsIgnoreCase(popupParams)) {
                        addAttrBuff.append(" POPUPEXISTS=\"false\"");
                    } else {
                        addAttrBuff.append(" POPUPEXISTS=\"true\"");
                        if ("NOPARAM".equalsIgnoreCase(popupParams)) {
                            addAttrBuff.append(" POPUPPARAMETERS=\"NULL\"");
                        } else {
                            addAttrBuff.append(" POPUPPARAMETERS=\"" + popupParams + "\"");
                        }
                        String helpOption = pophelpInfoMap.get("HELP_OPTION");
                        addAttrBuff.append(" HELPOPTION=\"" + helpOption + "\"");
                        if ("2".equalsIgnoreCase(helpOption)) {
                            addAttrBuff.append(" MINLENGTHAUTO=\"" + pophelpInfoMap.get("AUTO_FILL_LEN") + "\"");
                            addAttrBuff.append(" onkeyup=\"getAutocompleteData(this);\"");
                        }
                    }
                } else {
                    addAttrBuff.append(" POPUPEXISTS=\"false\"");
                }
                addAttrBuff.append(" protect=\"{").append(colName).append("/@protect}\"").append(" protectExpr=\"" + protectString + "\"");
                addAttrBuff.append(" visible=\"{").append(colName).append("/@visible}\"");
                if (elemType.equalsIgnoreCase("ddlb")) {
                    addAttrBuff.append(" ISCHANGED=\"false\"").append(" onChange=\"validateFld(this)\" onFocus=\"gotFocus(this)\"");
                } else {
                    addAttrBuff.append(" ISCHANGED=\"false\"").append(" onBlur=\"validateFld(this)\" onFocus=\"gotFocus(this)\"");
                }
                if (this.itemChangeList.contains(colName)) {
                    addAttrBuff.append(" SRVCALLONCHANGE=\"true\"");
                }
                if (pageContxt.equals("1")) {
                    if (gbPosList.size() > 0) {
                        if (this.checkColVisibility(dataMap, gbPosList)) {
                            if (colName.equalsIgnoreCase("tax_amt") && !objName.equalsIgnoreCase("taxtran") && isTaxApplicable.booleanValue()) {
                                dataFieldDisBuff.append("<TD style=\"width:" + width + "\" class=\"taxAmountColumn\" onClick=\"event.stopPropagation(); claculateTaxAmt('" + objContext + "','{normalize-space(@domID)}');\" title=\"View Tax\" > \n <p class=\"calcImgClass\" ><img src='/ibase/webitm/images/calculator.png'  height=\"15\" width=\"15\"/></p> \n");
                            } else {
                                dataFieldDisBuff.append("<TD style=\"width:" + width + "\">\n");
                            }
                        } else {
                            dataFieldDisBuff.append("<TD style=\"display:none;\">\n");
                        }
                    } else if (colName.equalsIgnoreCase("tax_amt") && !objName.equalsIgnoreCase("taxtran") && isTaxApplicable.booleanValue()) {
                        dataFieldDisBuff.append("<TD style=\"width:" + width + "\" class=\"taxAmountColumn\" onClick=\"event.stopPropagation(); claculateTaxAmt('" + objContext + "','{normalize-space(@domID)}');\" title=\"View Tax\" > \n <p class=\"calcImgClass\" ><img src='/ibase/webitm/images/calculator.png'  height=\"15\" width=\"15\"/></p> \n");
                    } else if (isVisible) {
                        dataFieldDisBuff.append("<TD style=\"width:" + width + ";\">\n");
                    } else {
                        dataFieldDisBuff.append("<TD style=\"width:" + width + ";display:none;\">\n");
                    }
                    addAttrBuff.append(" REQUIRED=\"" + requiredString + "\"");
                    if (!this.isCssFile) {
                        addAttrBuff.append(" class=\"\"");
                    } else if (objName.equalsIgnoreCase("taxtran")) {
                        addAttrBuff.append(" class=\"editInputClass\"");
                    } else {
                        addAttrBuff.append(" class=\"editInputClass tableInputClass\"");
                    }
                } else {
                    addAttrBuff.append(" REQUIRED=\"" + requiredString + "\"");
                    if (!this.isCssFile) {
                        addAttrBuff.append(" class=\"\"");
                    } else if (autoVScroll.equalsIgnoreCase("yes")) {
                        addAttrBuff.append(" class=\"headerInputField verticalScrollClass\"");
                    } else if (elemType.equalsIgnoreCase("ddlb")) {
                        addAttrBuff.append(" class=\"headerInputField chosen\"");
                    } else {
                        addAttrBuff.append(" class=\"headerInputField\"");
                    }
                }
                if (isVisible) {
                    if (autoVScroll.equalsIgnoreCase("yes")) {
                        addAttrBuff.append(" rows=\"" + noOfRows + "\" ");
                        dataFieldDisBuff.append(this.dataFieldDisplayAddForFirefoxBug(tempColName));
                        dataFieldDisBuff.append("<TEXTAREA ").append(addAttrBuff.toString()).append(tooltipAttrib).append(" style=\"").append(styleStrBuff.toString()).append("\" >\n");
                        dataFieldDisBuff.append("<xsl:value-of select='").append(colName).append("'/>\n");
                        dataFieldDisBuff.append("</TEXTAREA>\n");
                    } else if (elemType.equalsIgnoreCase("ddlb")) {
                        dataFieldDisBuff.append("<SELECT ").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\">\n");
                        dataFieldDisBuff.append(optionString).append("\n");
                        dataFieldDisBuff.append("</SELECT>\n");
                    } else {
                        if (elemType.equalsIgnoreCase("checkbox")) {
                            dataFieldDisBuff.append("<INPUT type=\"checkbox\"").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\">\n");
                        } else if (elemType.equalsIgnoreCase("password")) {
                            dataFieldDisBuff.append("<INPUT type=\"password\"").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\">\n");
                        } else {
                            dataFieldDisBuff.append("<INPUT type=\"text\"").append(addAttrBuff.toString()).append(tooltipAttrib).append(" style=\"").append(styleStrBuff.toString()).append("\"  coltype=\"" + dataType + "\">\n");
                        }
                        dataFieldDisBuff.append("<xsl:attribute name=\"value\">\n");
                        dataFieldDisBuff.append("<xsl:value-of select='").append(colName).append("'/>\n");
                        dataFieldDisBuff.append("</xsl:attribute>\n");
                        dataFieldDisBuff.append("</INPUT>\n");
                    }
                    if (pageContxt.equals("1")) {
                        dataFieldDisBuff.append("</TD>\n");
                    }
                } else {
                    dataFieldDisBuff.append("<INPUT type=\"text\" ").append(" elementType=\"{").append(colName).append("/@elementType}\"").append(addAttrBuff.toString()).append(tooltipAttrib).append(" style=\"display:none;").append(styleStrBuff.toString()).append("\"  coltype=\"" + dataType + "\">\n");
                    dataFieldDisBuff.append("<xsl:attribute name=\"value\">\n");
                    dataFieldDisBuff.append("<xsl:value-of select='").append(colName).append("'/>\n");
                    dataFieldDisBuff.append("</xsl:attribute>\n");
                    dataFieldDisBuff.append("</INPUT>\n");
                    if (pageContxt.equals("1")) {
                        dataFieldDisBuff.append("</TD>\n");
                    }
                }
            } else if (pageContxt.equals("1")) {
                if (isVisible) {
                    if (alignStr != null && alignStr.length() > 0) {
                        alignStr = " align=\"" + alignStr + "\" ";
                        BaseLogger.log("3", null, null, "setting align [" + alignStr + "]");
                    }
                    if (gbPosList.size() > 0 && !this.checkColVisibility(dataMap, gbPosList)) {
                        styleStrBuff.append(" display:none; ");
                    }
                    styleStrBuff.append("text-align:" + textAlign + ";");
                    String displayEditClass = "editDisplayClass tableDisplayClass";
                    if (isPrimaryKey) {
                        displayEditClass = "pkField-editDisplayClass tableDisplayClass";
                    }
                    if (colName.equalsIgnoreCase("tax_amt") && !objName.equalsIgnoreCase("taxtran") && isTaxApplicable.booleanValue()) {
                        displayEditClass = String.valueOf(displayEditClass) + " taxAmountClass";
                    }
                    addAttrBuff.append(" protect=\"{").append(colName).append("/@protect}\"").append(" protectExpr=\"" + protectString + "\"");
                    if (elemType.equalsIgnoreCase("ddlb")) {
                        addAttrBuff.append(" disabled=\"disabled\" class=\"" + displayEditClass + "\"");
                    } else {
                        addAttrBuff.append(" readOnly=\"true\" class=\"" + displayEditClass + "\"");
                    }
                    tdAlignStr = "number".equalsIgnoreCase(dataType) ? "align: right;" : "align: left;";
                    if (gbPosList.size() > 0) {
                        if (this.checkColVisibility(dataMap, gbPosList)) {
                            if (colName.equalsIgnoreCase("tax_amt") && !objName.equalsIgnoreCase("taxtran") && isTaxApplicable.booleanValue()) {
                                dataFieldDisBuff.append("<TD style=\"width:" + width + ";" + tdAlignStr + "\" class=\"taxAmountColumn\" onClick=\"event.stopPropagation(); claculateTaxAmt('" + objContext + "','{normalize-space(@domID)}');\" title=\"View Tax\" > \n <p class=\"calcImgClass\" ><img src='/ibase/webitm/images/calculator.png'  height=\"15\" width=\"15\"/></p> \n");
                            } else {
                                dataFieldDisBuff.append("<TD style=\"width:" + width + ";" + tdAlignStr + "\">\n");
                            }
                        } else {
                            dataFieldDisBuff.append("<TD style=\"display:none;\">\n");
                        }
                    } else if (colName.equalsIgnoreCase("tax_amt") && !objName.equalsIgnoreCase("taxtran") && isTaxApplicable.booleanValue()) {
                        dataFieldDisBuff.append("<TD style=\"width:" + width + ";" + tdAlignStr + "\" class=\"taxAmountColumn\" onClick=\"claculateTaxAmt('" + objContext + "','{normalize-space(@domID)}');\" title=\"View Tax\" > \n <p class=\"calcImgClass\" ><img src='/ibase/webitm/images/calculator.png'  height=\"15\" width=\"15\"/></p> \n");
                    } else {
                        dataFieldDisBuff.append("<TD style=\"width:" + width + ";" + tdAlignStr + "\">\n");
                    }
                    if (elemType.equalsIgnoreCase("ddlb")) {
                        dataFieldDisBuff.append("<SELECT ").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\">\n");
                        dataFieldDisBuff.append(optionString);
                        dataFieldDisBuff.append("</SELECT>\n");
                    } else {
                        dataFieldDisBuff.append("<INPUT type=\"text\"").append(addAttrBuff).append(alignStr).append(" style=\"").append(styleStrBuff.toString()).append("TYPE:" + dataType + "\">\n\n");
                        if ("number".equalsIgnoreCase(dataType)) {
                            if (maskStr != null && maskStr.length() > 0) {
                                dataFieldDisBuff.append("<xsl:variable name=\"numVal\"><xsl:value-of select=\"format-number(" + newColName + ",'" + maskStr + "')\"/></xsl:variable>\n");
                                dataFieldDisBuff.append("<xsl:choose>\n<xsl:when test=\"normalize-space($numVal)='NaN'\">&#160;");
                                dataFieldDisBuff.append("</xsl:when>\n<xsl:otherwise>");
                                dataFieldDisBuff.append("&#160;<xsl:value-of select=\"$numVal\"/>");
                                dataFieldDisBuff.append("</xsl:otherwise>\n</xsl:choose>\n");
                            } else {
                                dataFieldDisBuff.append("<xsl:attribute name=\"value\">\n");
                                dataFieldDisBuff.append("<xsl:value-of select='").append(newColName).append("'/>\n");
                                dataFieldDisBuff.append("</xsl:attribute>\n");
                            }
                        } else {
                            dataFieldDisBuff.append("<xsl:attribute name=\"value\">\n");
                            dataFieldDisBuff.append("<xsl:value-of select='").append(newColName).append("'/>\n");
                            dataFieldDisBuff.append("</xsl:attribute>\n");
                        }
                        dataFieldDisBuff.append("</INPUT>\n");
                    }
                    dataFieldDisBuff.append("</TD>\n");
                } else {
                    if (alignStr != null && alignStr.length() > 0) {
                        alignStr = " align=\"" + alignStr + "\" ";
                        BaseLogger.log("3", null, null, "setting align [" + alignStr + "]");
                    }
                    dataFieldDisBuff.append("<TD").append(alignStr).append(addAttrBuff.toString()).append(" style=\"display:none; TYPE:" + dataType + "\">\n<NOBR>\n");
                    if ("number".equalsIgnoreCase(dataType)) {
                        if (maskStr != null && maskStr.length() > 0) {
                            dataFieldDisBuff.append("<xsl:variable name=\"numVal\"><xsl:value-of select=\"format-number(" + newColName + ",'" + maskStr + "')\"/></xsl:variable>\n");
                            dataFieldDisBuff.append("<xsl:choose>\n<xsl:when test=\"normalize-space($numVal)='NaN'\">&#160;");
                            dataFieldDisBuff.append("</xsl:when>\n<xsl:otherwise>");
                            dataFieldDisBuff.append("&#160;<xsl:value-of select=\"$numVal\"/>");
                            dataFieldDisBuff.append("</xsl:otherwise>\n</xsl:choose>\n");
                        } else {
                            dataFieldDisBuff.append("&#160;<xsl:value-of select='" + newColName + "'/>\n");
                        }
                        dataFieldDisBuff.append("</NOBR>\n</TD>\n");
                    } else {
                        dataFieldDisBuff.append("&#160;<xsl:value-of select='" + newColName + "'/>\n").append("</NOBR>\n</TD>\n");
                    }
                }
            } else {
                styleStrBuff.append(";TYPE:" + dataType + ";text-align:" + textAlign);
                String popUpString = colObj.getPophelpInfo();
                HashMap<String, String> pophelpInfoMap = this.createPophelpInfoMap(popUpString);
                if (pophelpInfoMap != null && !pophelpInfoMap.isEmpty()) {
                    String popupParams = pophelpInfoMap.get("POPUPPARAMETERS");
                    if ("null".equalsIgnoreCase(popupParams)) {
                        addAttrBuff.append(" POPUPEXISTS=\"false\"");
                    } else {
                        addAttrBuff.append(" POPUPEXISTS=\"true\"");
                        if ("NOPARAM".equalsIgnoreCase(popupParams)) {
                            addAttrBuff.append(" POPUPPARAMETERS=\"NULL\"");
                        } else {
                            addAttrBuff.append(" POPUPPARAMETERS=\"" + popupParams + "\"");
                        }
                        String helpOption = pophelpInfoMap.get("HELP_OPTION");
                        addAttrBuff.append(" HELPOPTION=\"" + helpOption + "\"");
                        if ("2".equalsIgnoreCase(helpOption)) {
                            addAttrBuff.append(" MINLENGTHAUTO=\"" + pophelpInfoMap.get("AUTO_FILL_LEN") + "\"");
                            addAttrBuff.append(" onkeyup=\"getAutocompleteData(this);\"");
                        }
                    }
                } else {
                    addAttrBuff.append(" POPUPEXISTS=\"false\"");
                }
                addAttrBuff.append(" protect=\"{").append(colName).append("/@protect}\"").append(" protectExpr=\"" + protectString + "\"");
                addAttrBuff.append(" visible=\"{").append(colName).append("/@visible}\"");
                if (elemType.equalsIgnoreCase("ddlb")) {
                    addAttrBuff.append(" ISCHANGED=\"false\"").append(" onChange=\"validateFld(this)\" onFocus=\"gotFocus(this)\"");
                } else {
                    addAttrBuff.append(" ISCHANGED=\"false\"").append(" onBlur=\"validateFld(this)\" onFocus=\"gotFocus(this)\"");
                }
                String displayEditClass = "headerDisableField";
                elemClass = "DISPLAY";
                if (autoVScroll.equalsIgnoreCase("yes")) {
                    displayEditClass = "headerDisableField verticalScrollClass";
                }
                if (isPrimaryKey) {
                    displayEditClass = "pkField-headerDisableField";
                }
                if (elemType.equalsIgnoreCase("ddlb")) {
                    addAttrBuff.append(" disabled=\"disabled\" class=\"" + displayEditClass + "\"");
                } else {
                    addAttrBuff.append(" readOnly=\"true\" class=\"" + displayEditClass + "\"");
                }
                if (isVisible) {
                    if (autoVScroll.equalsIgnoreCase("yes")) {
                        addAttrBuff.append(" rows=\"" + noOfRows + "\" ");
                        dataFieldDisBuff.append(this.dataFieldDisplayAddForFirefoxBug(tempColName));
                        dataFieldDisBuff.append("<TEXTAREA ").append(addAttrBuff.toString()).append(tooltipAttrib).append(" style=\"").append(styleStrBuff.toString()).append("\" >\n");
                        dataFieldDisBuff.append("<xsl:value-of select='").append(colName).append("'/>\n");
                        dataFieldDisBuff.append("</TEXTAREA>\n");
                    } else {
                        if (elemType.equalsIgnoreCase("password")) {
                            dataFieldDisBuff.append("<INPUT type='password' ").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\">\n");
                        } else if (elemType.equalsIgnoreCase("ddlb")) {
                            dataFieldDisBuff.append("<SELECT ").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\">\n");
                        } else {
                            dataFieldDisBuff.append("<INPUT ").append(addAttrBuff.toString()).append(tooltipAttrib).append(" style=\"").append(styleStrBuff.toString()).append("\"  coltype=\"" + dataType + "\">\n");
                            dataFieldDisBuff.append("<xsl:attribute name=\"value\">\n");
                        }
                        if (elemType.equalsIgnoreCase("ddlb")) {
                            dataFieldDisBuff.append(optionString);
                            dataFieldDisBuff.append("</SELECT>\n");
                        } else {
                            dataFieldDisBuff.append("<xsl:value-of select='").append(colName).append("'/>\n");
                            dataFieldDisBuff.append("</xsl:attribute>\n");
                            dataFieldDisBuff.append("</INPUT>\n");
                        }
                    }
                } else if (elemType.equalsIgnoreCase("ddlb")) {
                    dataFieldDisBuff.append("<SELECT ").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\">\n");
                    dataFieldDisBuff.append(optionString);
                    dataFieldDisBuff.append("</SELECT>\n");
                } else {
                    dataFieldDisBuff.append("<INPUT type=\"text\" ").append(" elementType=\"{").append(colName).append("/@elementType}\"").append(addAttrBuff.toString()).append(tooltipAttrib).append(" style=\"display:none;").append(styleStrBuff.toString()).append("\"  coltype=\"" + dataType + "\">\n");
                    dataFieldDisBuff.append("<xsl:attribute name=\"value\">\n");
                    dataFieldDisBuff.append("<xsl:value-of select='").append(colName).append("'/>\n");
                    dataFieldDisBuff.append("</xsl:attribute>\n");
                    dataFieldDisBuff.append("</INPUT>\n");
                }
            }
            xslInputToBeAdded = dataFieldDisBuff.toString();
            if (pageContxt.equals("1") && gbPosList.size() > 0) {
                isVisible = this.checkColVisibility(dataMap, gbPosList);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception:[GenerateFormLayout]:inputFieldFormMap" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("3", null, null, "10012023 Column final xslInputToBeAdded [" + xslInputToBeAdded + "]");
        inputFieldDataMap.put("DATA", xslInputToBeAdded);
        inputFieldDataMap.put("XPOS", String.valueOf(xPos));
        inputFieldDataMap.put("YPOS", String.valueOf(yPos));
        inputFieldDataMap.put("VISIBLE", String.valueOf(isVisible));
        inputFieldDataMap.put("WIDTH", String.valueOf(width));
        inputFieldDataMap.put("ELEM_CLASS", elemClass);
        inputFieldDataMap.put("HDR_ALIGN", headerAlign);
        inputFieldDataMap.put("REQUIRED", requiredString);
        inputFieldDataMap.put("FIELD_NAME", fieldName);
        inputFieldDataMap.put("DDLB", isDDLb);
        BaseLogger.log("3", null, null, "10012023 Column final inputFieldDataMap [" + inputFieldDataMap + "]");
        return inputFieldDataMap;
    }

    private HashMap<String, String> createPophelpInfoMap(String popHelpInfo) {
        HashMap<String, String> popHelpInfoMap = new HashMap<String, String>();
        E12GenericUtility utility = new E12GenericUtility();
        try {
            BaseLogger.log("3", null, null, "popHelpInfo[" + popHelpInfo + "]");
            Document popHelpInfoDom = utility.parseString(popHelpInfo);
            Node rootNode = popHelpInfoDom.getElementsByTagName("Root").item(0);
            NodeList pophelpParamsList = rootNode.getChildNodes();
            if (pophelpParamsList != null) {
                int len = pophelpParamsList.getLength();
                int ctr = 0;
                while (ctr < len) {
                    Node pophelpParamNode = pophelpParamsList.item(ctr);
                    if (pophelpParamNode != null && pophelpParamNode.getNodeType() == 1) {
                        String nodeName = pophelpParamNode.getNodeName();
                        String nodeValue = pophelpParamNode.getNodeValue();
                        if (nodeValue == null && pophelpParamNode.getFirstChild() != null) {
                            nodeValue = pophelpParamNode.getFirstChild().getNodeValue();
                        }
                        if ("POPUPPARAMETERS".equalsIgnoreCase(nodeName)) {
                            popHelpInfoMap.put("POPUPPARAMETERS", nodeValue);
                        } else if ("POPHELP_COLS".equalsIgnoreCase(nodeName)) {
                            popHelpInfoMap.put("POPHELP_COLS", nodeValue);
                        } else if ("POPHELP_SOURCE".equalsIgnoreCase(nodeName)) {
                            popHelpInfoMap.put("POPHELP_SOURCE", nodeValue);
                        } else if ("MULTI_OPT_POPUP".equalsIgnoreCase(nodeName)) {
                            popHelpInfoMap.put("MULTI_OPT_POPUP", nodeValue);
                        } else if ("HELP_OPTION".equalsIgnoreCase(nodeName)) {
                            popHelpInfoMap.put("HELP_OPTION", nodeValue);
                        } else if ("AUTO_FILL_LEN".equalsIgnoreCase(nodeName)) {
                            popHelpInfoMap.put("AUTO_FILL_LEN", nodeValue);
                        }
                    }
                    ++ctr;
                }
            }
            BaseLogger.log("3", null, null, "popHelpInfoMap[" + popHelpInfoMap + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "createPophelpInfoMap exception : " + e.getMessage());
            e.printStackTrace();
        }
        return popHelpInfoMap;
    }

    private void setObjFormInfoMap(ArrayList dbValues) {
        try {
            this.objFormInfoMap = new HashMap();
            int i = 0;
            while (i < dbValues.size()) {
                ArrayList currForm = (ArrayList)dbValues.get(i);
                String title = (String)currForm.get(0);
                String objContext = (String)currForm.get(14);
                String scrType = currForm.get(15) == null ? "" : currForm.get(15);
                String dbFormType = currForm.get(16) == null ? "" : currForm.get(16);
                String formName = currForm.get(32) == null ? "" : currForm.get(32);
                String parentKeyCol = currForm.get(18) == null ? "" : currForm.get(18);
                BaseLogger.log("3", null, null, "objContext =[" + objContext + "], formName =[" + formName + "]");
                this.objFormInfoMap.put(objContext, String.valueOf(dbFormType) + this.OBJ_INFO_SEPARATOR + parentKeyCol + this.OBJ_INFO_SEPARATOR + scrType + this.OBJ_INFO_SEPARATOR + formName);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "MasterStateful >> setObjFormInfoMap >> this.objFromInfoMap ::" + this.objFormInfoMap);
    }

    private String getObjPropValue(String formNo, String objPropName) {
        String value;
        block11: {
            value = "";
            if (this.objFormInfoMap != null) break block11;
            BaseLogger.log("3", null, null, String.valueOf(objPropName) + "= []");
            return "";
        }
        try {
            String objFromInfo = this.objFormInfoMap.get(formNo);
            if (objFromInfo != null) {
                String[] strArr = objFromInfo.split(this.OBJ_INFO_SEPARATOR);
                if ("FORM_TYPE".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 0 ? strArr[0] : "";
                } else if ("PARENT_KEY_COL".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 1 ? strArr[1] : "";
                } else if ("SCR_FLAG".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 2 ? strArr[2] : "";
                } else if ("FORM_NAME".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 3 ? strArr[3] : "";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, String.valueOf(objPropName) + "= [" + value + "]");
        return value;
    }

    private String getFormName(String formNo) {
        String formName = this.getObjPropValue(formNo, "FORM_NAME");
        if (formName == null || formName.length() == 0) {
            formName = "";
        }
        return formName;
    }
}

