/*
 Request ID:
 Purpose: WsfaDSRWizardEJB for implementing logic of itemchange and validation method.
  		  To Achive the functionality of OTC-Daily Sales Reporting
 Date:27-JAN-14
 Changes Done By : Shahu Mali
 */
package ibase.webitm.ejb.wsfa.transactions;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;



import CtsComponents.NEW_VALUES;

//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].
public class WsfaDSRWizardEJB extends ValidatorEJB
{
	static int domID = 1;

	//Validation Start*********
	public String wfValSalesPersAct(Document dom, Document dom2, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		GenericUtility genericUtility = GenericUtility.getInstance();

		String errString = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

		int noOfChilds = 0;
		try
		{
			ConnDriver connDriver =new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength["+parentNodeListLength+"]");

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();
					System.out.println("childNodeName =["+childNodeName+"]");

					if(childNodeName.equalsIgnoreCase("event_date"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
							break;
						}
						else //to validate future date and holidays
						{

							SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
							//Commented and Below Changes Done By Shahu Mali on 27-FEB-14
							//java.util.Date eventDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
							java.util.Date eventDate =null;
							try
							{
								eventDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
							}
							catch ( Exception e )
							{
								System.out.println("------------- INVDTFRMT ---------------");
								errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
								break;
							}

							String evtdat=childNode.getFirstChild().getNodeValue();
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] Start
							if (!sdfFormat.format(eventDate).equals(evtdat))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
								break;
							}
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] End

							if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
								break;
							}
							String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );

							//Added by Sneha on 31-Mar-14 [WS3LNOV005]
							//String planDate = genericUtility.getColumnValue( "event_date" , dom );
							java.util.Date plandate = getDateObject( columnValue );
						 	Calendar plandateCal = Calendar.getInstance();
			    	        plandateCal.setTime(plandate);
			    	        int plandateYear = plandateCal.get(Calendar.YEAR);
			    	        int plandateMonth = plandateCal.get(Calendar.MONTH );
			    	        int plandateDay = plandateCal.get(Calendar.DAY_OF_MONTH);
			    	        int endDay =  plandateCal.getActualMaximum(Calendar.DAY_OF_MONTH);

			    	        Calendar cal1 = Calendar.getInstance();
			    	        cal1.setTime(new Date());
			    	        int year = cal1.get(Calendar.YEAR);
			    	        int month = cal1.get(Calendar.MONTH );
			    	        int day = cal1.get(Calendar.DAY_OF_MONTH);

			    	        int maxAllowDays;
							System.out.println("month ["+month+"]"+"plandateMonth ["+plandateMonth+"]");

				    	    int monthNo=plandateMonth+1;
				    	    String monStr="";
				    	    if(monthNo <= 9)
				    	    {
				    	    	  monStr= "0"+ Integer.toString(monthNo);
				    	    }
				    	    else
				    	    {
				    	    	monStr = ""+monthNo;
				    	    }
				    	     // String yrs   =Integer.toString(plandateYear).substring(2);
				    	    String toDate = plandateYear+"-"+monStr+"-"+endDay;
						    String frmDate = plandateYear+"-"+monStr+"-"+"01";

						    System.out.println("toDate["+toDate+"],frmDate["+frmDate+"]");

				    	    if(month == plandateMonth && year == plandateYear)
					    	{
								String PlanConfSql="Select count(1) as count from sprs_plan  where sprs_code__plan  = ? and plan_date between ? and ? and confirm='Y'";

								int ConfCount=0;

								PreparedStatement psConfirmPlan= connectionObject.prepareStatement(PlanConfSql);
								psConfirmPlan.setString(1, salesPers);
								psConfirmPlan.setTimestamp(2,java.sql.Timestamp.valueOf(frmDate+ " 00:00:00") );
								psConfirmPlan.setTimestamp(3,java.sql.Timestamp.valueOf(toDate+ " 00:00:00") );

								ResultSet rsConfirm = psConfirmPlan.executeQuery();

								if(rsConfirm.next())
								{

									ConfCount = rsConfirm.getInt("count");

								}
								if(ConfCount == 0)
								{

				    	        	String sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MAX_ALLOW_PLAN_DAYS'";
									System.out.println("SQL ["+sql+"]");
									Statement stmt = connectionObject.createStatement();
									ResultSet	rs = stmt.executeQuery( sql );
									if( rs.next() )
									{
										maxAllowDays = rs.getInt("PROP_VALUE");
										System.out.println("maxAllowDays ["+maxAllowDays+"]");
										int mon =plandateMonth+1;
										String maxAllowDateStr =maxAllowDays+"/"+mon+"/"+plandateYear;

										System.out.println("maxAllowDate ["+maxAllowDateStr+"]");
										java.util.Date maxAllowDate = getDateObject( maxAllowDateStr );


										java.util.Date today = getDateObject(sdfFormat.format( new Date() ) ) ;
										System.out.println("today ["+today+"]");


										if ((today.compareTo( maxAllowDate )) <= 0)
										{
											errString = getErrorString( "event_date" , "PLNNOTCONF" , userId );
											break;
										}
									}

									if(rs != null)
									{
										rs.close(); rs = null;
									}
									if(stmt != null)
									{
										stmt.close(); stmt = null;
									}
									rs = ( rs!=null )? null : rs;
									stmt = ( stmt!=null )? null : stmt;


									}
									psConfirmPlan.close(); psConfirmPlan = null;
									rsConfirm.close(); rsConfirm = null;
							  }
							//End:Added by Sneha on 31-Mar-14 [WS3LNOV005]

							//Changed By Vidhya on 09/12/09[WS89NOV647 | validation order change] Start
							/*//for checking Holiday
							String eventdate = childNode.getFirstChild().getNodeValue();
							String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );

							if( salesPers != null && eventdate != null )
							{
								errString = valHoliday( eventdate, salesPers, userId, itmDBAccessLocal );
								if(errString != null && errString.length()>0 && errString.indexOf("ERRORS")!=-1)
								{
									System.out.println("Holiday!");
									break;

								}
							}

							int allowDays = 0;
							checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MAX_ALLOW_PRD_MEET'";
							pstmt = connectionObject.prepareStatement(checkSQL);
							rSet = pstmt.executeQuery( checkSQL );
							if( rSet.next() )
							{
								allowDays = rSet.getInt("PROP_VALUE");
								System.out.println("allowDays Exist In Properties are ["+allowDays+"]");
								java.util.Calendar cal = java.util.Calendar.getInstance();
								java.util.Date currDate = new java.util.Date();
								cal.setTime( currDate );
								cal.add( cal.DATE, -allowDays );
								if( eventDate.before( cal.getTime() ) )
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "XCIDMITLMT" , userId );
									break;
								}
							}
							rSet.close();
							rSet = null;
							pstmt.close();
							pstmt = null;*/



							//changed for not allow to edit the DCR once confirmed - Gulzar
							String dcrDate = genericUtility.getColumnValue( "event_date" , dom );

							String confirmed = "";
							dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							String selectSql = "SELECT CONFIRMED FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ?";
							PreparedStatement pstmtSel = connectionObject.prepareStatement(selectSql);
							pstmtSel.setString(1, salesPers);
							pstmtSel.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
							ResultSet rsSelect = pstmtSel.executeQuery();
							if(rsSelect.next())
							{
								confirmed = (rsSelect.getString("CONFIRMED") == null) ?"":rsSelect.getString("CONFIRMED").trim();
							}
							rsSelect.close(); rsSelect = null;
							pstmtSel.close(); pstmtSel = null;
							if("Y".equalsIgnoreCase(confirmed))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date" , "DCRCONFD" , userId );
								break;
							}

							//End changes - Gulzar

							int allowDays = 0;
							String propName = "MAX_ALLOW_PRD_MEET";//ADDED BY DIPAK FOR DB2
							//checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MAX_ALLOW_PRD_MEET'";//Commented By Dipak FOR DB2
							checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ? ";//ADDED By Dipak FOR DB2
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1, propName);//ADDED By Dipak FOR DB2
							rSet = pstmt.executeQuery();//ADDED By Dipak FOR DB2
							if( rSet.next() )
							{
								allowDays = rSet.getInt("PROP_VALUE");
								System.out.println("allowDays Exist In Properties are ["+allowDays+"]");
								java.util.Calendar cal = java.util.Calendar.getInstance();
								java.util.Date currDate = new java.util.Date();
								cal.setTime( currDate );
								cal.add( cal.DATE, -allowDays );
								if( eventDate.before( cal.getTime() ) )
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "XCIDMITLMT" , userId );
									break;
								}
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

							//for checking Holiday
							String eventdate = childNode.getFirstChild().getNodeValue();


							if( salesPers != null && eventdate != null )
							{
								errString = valHoliday( eventdate, salesPers, userId, itmDBAccessLocal, connectionObject );
								if(errString != null && errString.length()>0 && errString.indexOf("ERRORS")!=-1)
								{
									System.out.println("Holiday!");
									break;

								}
							}
							//Changed By Vidhya on 09/12/09[WS89NOV647 | validation order change] end

						}

					}
					else if(childNodeName.equalsIgnoreCase("activity_code"))
					{
						//Changed By Vidhya on 23/11/09[WS89NOV609 | to validate when acttivity field is blank]
						/*if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))*/
						String actDescr = genericUtility.getColumnValue( "activity_descr" , dom );
						System.out.println("@@@@@@@@@@actDescr["+actDescr+"]");
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))//|| actDescr == null || (actDescr != null && "null".equalsIgnoreCase(actDescr))
								)
						{
							errString = itmDBAccessLocal.getErrorString("activity_code","NULLACTCOD",userId);
							break;
						}
						else
						{
							if (columnValue.trim().length() > 2)
							{
								errString = itmDBAccessLocal.getErrorString("activity_code","LENGTH",userId);
								break;
							}
							else
							{
								checkSQL = "SELECT COUNT(1) COUNT FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
								pstmt = connectionObject.prepareStatement(checkSQL);
								pstmt.setString(1,checkNull(columnValue));
								rSet = pstmt.executeQuery();
								if(rSet.next() && rSet.getInt("COUNT") < 1 )
								{
									errString = itmDBAccessLocal.getErrorString("activity_code","INVEVET",userId);
									break;
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								String eventDate = genericUtility.getColumnValue( "event_date" , dom );
								if(eventDate == null || eventDate.trim().length() == 0 || "null".equalsIgnoreCase(eventDate))
								{
									errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
									break;
								}

								String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
								//Changed By Vidhya on 28/10/09[WS89BAS033 | to catch error] Start
								//String pDate = genericUtility.getValidDateString( eventDate , getApplDateFormat() , "dd-MMM-yyyy")"";
								String pDate = "";
								try
								{
									//pDate = genericUtility.getValidDateString( eventDate , getApplDateFormat() , "dd-MMM-yyyy");//Shahu - 27/10/12
									pDate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());//Shahu - 27/10/12
								}
								catch ( Exception e )
								{
									System.out.println("------------- INVALIDFRMT ---------------");
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}
								checkSQL = "SELECT ACTIVITY_TYPE FROM STRG_MEET,FIELDACTIVITY WHERE EVENT_DATE=? AND SALES_PERS=?  AND FIELDACTIVITY.ACTIVITY_CODE = STRG_MEET.EVENT_TYPE";
								pstmt = connectionObject.prepareStatement(checkSQL);
								//pstmt.setString(1, pDate);//Shahu - 27/10/12
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));//Shahu - 27/10/12
								pstmt.setString(2, salesPers);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									String activityType = rSet.getString(1);
									activityType = checkNull(activityType).toUpperCase();
									if(activityType.indexOf("LEAVE")!=-1 )
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmt = connectionObject.prepareStatement(checkSQL);
										pstmt.setString(1, columnValue);
										rSet =pstmt.executeQuery();
										if( rSet.next() )
										{
											if(!activityType.equalsIgnoreCase(rSet.getString(1)))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANLEAVE", userId );
												break;
											}
										}
									}
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("sales_pers","NULLSPRSCD",userId);
							break;
						}
						else
						{
							if( parentNodeListLength > 1 )
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","SPRSONCE",userId);
								break;
							}

							String eventDate = genericUtility.getColumnValue( "event_date" , dom );
							String sprs = childNode.getFirstChild().getNodeValue();
							String dcrID = genericUtility.getColumnValue( "dcr_id" , dom );
							if( dcrID == null || "null".equalsIgnoreCase(dcrID) )
							{
								dcrID = "x";
							}
							checkSQL = "SELECT * FROM SALES_PERS WHERE SALES_PERS = ?";
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1,checkNull(sprs));
							rSet = pstmt.executeQuery();
							if(!rSet.next())
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","WRGSPRSCD",userId);
								break;
							}

							/* Changed by Danish on 10/1/2009 [ Not to validate anymore as to get data for edit ] Uncommented for the moment
							checkSQL = "SELECT COUNT(1) COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? AND DCR_ID <> ?";
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1,checkNull(sprs));
							pstmt.setTimestamp( 2,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(checkNull(eventDate),genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.setString(3,dcrID);
							rSet = pstmt.executeQuery();
							if(rSet.next() && rSet.getInt("COUNT")>0)
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","SPRSEXIST",userId);
								break;
							}*/


							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("sprs_route_stan_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("sprs_route_stan_code","NULLSTANCD",userId);
							break;
						}
					}
				}
				if(errString.indexOf("<Errors>")!=-1)
				{
					break;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println ( "Exception :StrgMeetWizardEJB :wfValData():" + e.getMessage() + ":" );
			//Commented and added by Dipak 05/11/12
			//errString = generateErrorString(genericUtility.createErrorString(e));
			throw new ITMException(e);
			//End changes by Dipak 05/11/12
		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;
	}
	//Changed By Vidhya on 25/11/09[WS89NOV655 | separate method for validation in 'RIA'] Start
	public String wfValSalesPersActRIA(Document dom, Document dom2, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		GenericUtility genericUtility = GenericUtility.getInstance();

		String errString = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

		int noOfChilds = 0;
		try
		{
			ConnDriver connDriver =new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength["+parentNodeListLength+"]");

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("event_date"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
							break;
						}
						else //to validate future date and holidays
						{
							//SimpleDateFormat sdfFormat = new SimpleDateFormat("dd/MM/yyyy");//commented by vinayak
							SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());//Added by vinayak to set Date Format on [03/10/2016]

							String evtdat= childNode.getFirstChild().getNodeValue();
							java.util.Date eventDate = sdfFormat.parse( evtdat);
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] Start
							if (!sdfFormat.format(eventDate).equals(evtdat))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
								break;
							}
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] End

							if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
								break;
							}

							int allowDays = 0;
							checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MAX_ALLOW_PRD_MEET'";
							pstmt = connectionObject.prepareStatement(checkSQL);
							rSet = pstmt.executeQuery( checkSQL );
							if( rSet.next() )
							{
								allowDays = rSet.getInt("PROP_VALUE");
								System.out.println("allowDays Exist In Properties are ["+allowDays+"]");
								java.util.Calendar cal = java.util.Calendar.getInstance();
								cal.setTime( getDateObject( sdfFormat.format( new Date() ) ) );
								cal.add( cal.DATE, -allowDays );
								if( eventDate.before( cal.getTime() ) )
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "XCIDMITLMT" , userId );
									break;
								}
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

							//for checking Holiday
							String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
							if( salesPers != null && evtdat != null )
							{
								errString = valHoliday( evtdat, salesPers, userId, itmDBAccessLocal, connectionObject);
								if(errString != null && errString.length()>0 && errString.indexOf("ERRORS")!=-1)
								{
									errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
									System.out.println("Holiday!");
									break;

								}
							}

						}

					}
					else if(childNodeName.equalsIgnoreCase("activity_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{

							errString = itmDBAccessLocal.getErrorString("activity_code", "NULLACTCOD",userId);
							break;
						}
						else
						{
							if (columnValue.trim().length() > 2)
							{
								errString = itmDBAccessLocal.getErrorString("activity_code","LENGTH",userId);
								break;
							}
							else
							{
								checkSQL = "SELECT COUNT(1) COUNT FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
								pstmt = connectionObject.prepareStatement(checkSQL);
								pstmt.setString(1,checkNull(columnValue));
								rSet = pstmt.executeQuery();
								if(rSet.next() && rSet.getInt("COUNT") < 1 )
								{
									errString = itmDBAccessLocal.getErrorString("activity_code","INVEVET",userId);
									break;
								}

								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								String eventDate = genericUtility.getColumnValue( "event_date" , dom );

								if(eventDate == null || eventDate.trim().length() == 0 || "null".equalsIgnoreCase(eventDate))
								{
									errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
									break;
								}

								String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
								String pDate = "";
								try
								{
									//pDate = genericUtility.getValidDateString( eventDate , getApplDateFormat() , "dd-MMM-yyyy");//Shahu - 27/10/12
									pDate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());//Shahu - 27/10/12
								}
								catch ( Exception e )
								{
									System.out.println("------------- INVALIDFRMT ---------------");
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}
								checkSQL = "SELECT ACTIVITY_TYPE FROM STRG_MEET,FIELDACTIVITY WHERE EVENT_DATE=? AND SALES_PERS=?  AND FIELDACTIVITY.ACTIVITY_CODE = STRG_MEET.EVENT_TYPE";
								pstmt = connectionObject.prepareStatement(checkSQL);
								//pstmt.setString(1, pDate);//Shahu - 27/10/12
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));//Shahu - 27/10/12
								pstmt.setString(2, salesPers);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									String activityType = rSet.getString(1);
									activityType = checkNull(activityType).toUpperCase();
									System.out.println("activityType######["+activityType+"]");
									if(activityType.indexOf("LEAVE")!=-1 )
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmt = connectionObject.prepareStatement(checkSQL);
										pstmt.setString(1, columnValue);
										rSet = pstmt.executeQuery();
										if( rSet.next() )
										{
											if(!activityType.equalsIgnoreCase(rSet.getString(1)))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANLEAVE", userId );
												break;
											}
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}
									else if (activityType.indexOf("NFW")!=-1)
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmt = connectionObject.prepareStatement(checkSQL);
										pstmt.setString(1, columnValue);
										rSet =pstmt.executeQuery();
										if( rSet.next() )
										{
											if(!activityType.equalsIgnoreCase(rSet.getString(1)))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANNFW", userId );
												break;
											}
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}
									else if (activityType.indexOf("FW")!=-1)
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmt = connectionObject.prepareStatement(checkSQL);
										pstmt.setString(1, columnValue);
										rSet =pstmt.executeQuery();
										if( rSet.next() )
										{
											if(!activityType.equalsIgnoreCase(rSet.getString(1)))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANFW", userId );
												break;
											}
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}

								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("sales_pers","NULLSPRSCD",userId);
							break;
						}
						else
						{
							if( parentNodeListLength > 1 )
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","SPRSONCE",userId);
								break;
							}

							String eventDate = genericUtility.getColumnValue( "event_date" , dom );
							String sprs = childNode.getFirstChild().getNodeValue();
							String dcrID = genericUtility.getColumnValue( "dcr_id" , dom );
							if( dcrID == null || "null".equalsIgnoreCase(dcrID) )
							{
								dcrID = "x";
							}
							checkSQL = "SELECT * FROM SALES_PERS WHERE SALES_PERS = ?";
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1,checkNull(sprs));
							rSet = pstmt.executeQuery();
							if(!rSet.next())
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","WRGSPRSCD",userId);
								break;
							}

							/* Changed by Danish on 10/1/2009 [ Not to validate anymore as to get data for edit ] Uncommented for the moment
							checkSQL = "SELECT COUNT(1) COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? AND DCR_ID <> ?";
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1,checkNull(sprs));
							pstmt.setTimestamp( 2,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(checkNull(eventDate),genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.setString(3,dcrID);
							rSet = pstmt.executeQuery();
							if(rSet.next() && rSet.getInt("COUNT")>0)
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","SPRSEXIST",userId);
								break;
							}*/


							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("sprs_route_stan_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("sprs_route_stan_code","NULLSTANCD",userId);
							break;
						}
					}
				}
				if(errString.indexOf("<Errors>")!=-1)
				{
					break;
				}
			}
		}
		catch(Exception e)
		{

			System.out.println ( "Exception :StrgMeetWizardEJB :wfValData():" + e.getMessage() + ":" );

			//errString = generateErrorString(genericUtility.createErrorString(e));//Commented By Dipak
			throw new ITMException(e);//Commented By Dipak

		}
		finally
		{
			try
			{
				if (rSet !=null )
				{
					rSet.close();
				}
				if(pstmt != null)
				{
					pstmt.close();
				}


				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;
	}
	public String wfValLocality(Document dom, String currentFormNo, String userId) throws ITMException
	{
			NodeList parentList = null;
			NodeList childList = null;
			Node parentNode = null;
			Node childNode = null;

			GenericUtility genericUtility = GenericUtility.getInstance();

			String errString = "";
			String columnValue = "";
			String checkSQL = "";
			String childNodeName = "";
			String errString1 = "";
			String actType = "";

			Connection connectionObject = null;
			PreparedStatement pstmt = null;
			ResultSet rSet = null ;

			ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

			int ctr = 0;
			int noOfChilds = 0;
			boolean isAnyCustomerSel = false;
			//boolean isDoctorSelected = false;
			//boolean isChemistSelected = false;

			//boolean toValidateDoctor = true;
			//boolean toValidateChemist	= true;
			boolean isOvernightStay = false;

			boolean isWsellerSelected = false;
			boolean isDistBrSelected = false;
			boolean isMtradeSelected = false;

			boolean toValidateWseller = true;
			boolean toValidateDistBr = true;
			boolean toValidateMtrade = true;
			try
			{
				AppConnectParm appConnect = new AppConnectParm();
				Properties p = appConnect.getProperty();
				InitialContext ctx = new InitialContext(p);
				//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
				//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
				itmDBAccessLocal = new ITMDBAccessEJB();
				//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

				ConnDriver connDriver = connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB("DriverValidator");

				parentList = dom.getElementsByTagName("Detail" + currentFormNo);
				int parentNodeListLength = parentList.getLength();
				System.out.println("parentNodeListLength(wfValLocality)["+parentNodeListLength+"]");
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String locDescr = getSelectedRowValue(dom, currentFormNo, "sprs_route_descr",prntCtr);
					String actCode = genericUtility.getColumnValue("activity_code", dom);
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("locality_code"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
							{
								errString = itmDBAccessLocal.getErrorString("locality_code","NULLLOCTCD",userId);
								break;
							}
							else
							{
								actType = getActivityType(actCode);
								if( actType.indexOf("LEAVE")!= -1 )
								{
									if( parentNodeListLength > 1 )
									{
										errString1 = itmDBAccessLocal.getErrorString("locality_code","LOCALONCE",userId);
										break;
									}
								}
							}
						}
						else if( childNodeName.equalsIgnoreCase("travel_mode") )
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
							{
								errString = itmDBAccessLocal.getErrorString("travel_mode","NULLTRVLM",userId);
								break;
							}
							else
							{
								actType = getActivityType(actCode);
								if(actType.indexOf("LEAVE")!=-1 )
								{
									if( !columnValue.equalsIgnoreCase("ROAD"))
									{
										errString = itmDBAccessLocal.getErrorString("travel_mode","TRMODENFW",userId);
										break;
									}
								}
							}

						}
						else if(childNodeName.equalsIgnoreCase("over_night"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
							{
								errString = itmDBAccessLocal.getErrorString("over_night","NULLOVRNIT",userId);
								break;
							}
							else
							{
								actType = getActivityType(actCode);
								if( actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1 )
								{
									if( !columnValue.equalsIgnoreCase("N"))
									{
										errString = itmDBAccessLocal.getErrorString("over_night","OVRNITENFW",userId);
										break;
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("order_of_visit"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
							{
								errString = itmDBAccessLocal.getErrorString("order_of_visit","NULLORDVST",userId);
								break;
							}

						}
						else if ( "wseller_visit".equalsIgnoreCase( childNodeName )  || "distbr_visit".equalsIgnoreCase( childNodeName ) || "mtrader_visit".equalsIgnoreCase( childNodeName ))
						{
								String selectSql = "";
								int count = 0;
								String localityCode = getSelectedRowValue(dom, currentFormNo, "locality_code",prntCtr);
								String salesPers = getSelectedRowValue(dom, currentFormNo, "sales_pers",prntCtr);
								String overNight = getSelectedRowValue(dom, currentFormNo, "over_night",prntCtr);
								if(overNight.equalsIgnoreCase("Y"))
								{
									isOvernightStay=true;
								}
								System.out.println("Validating for "+childNodeName+" LocalityCode ["+localityCode+"] salesPers ["+salesPers+"]");

								if( "wseller_visit".equalsIgnoreCase( childNodeName ) )
								{
									//isWsellerSelected = true;
									selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type = 'W' and ss.status = 'Y'";

									System.out.println("selectSql ["+selectSql+"]");

									pstmt = connectionObject.prepareStatement(selectSql);
									pstmt.setString(1,localityCode);
									pstmt.setString(2,salesPers);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										count = rSet.getInt("count");
									}
									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("wseller count ["+count+"]");
									if (columnValue != null && "Y".equalsIgnoreCase(columnValue))
									{
										isAnyCustomerSel = true;
										isWsellerSelected = true;

										if ( count == 0 )
										{
											errString = itmDBAccessLocal.getErrorString( "","NOWSELLER",userId );
											break;
										}
									}
									else if (columnValue != null && "N".equalsIgnoreCase(columnValue))
									{
										if ( count > 0 )
										{
											isWsellerSelected = false;
										}
										else
										{
											toValidateWseller = false;
										}
									}

								}
								else if( "distbr_visit".equalsIgnoreCase( childNodeName ) )
								{
									//isDistBrSelected = true;
									selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers = ? and ss.sc_code = sc.sc_code and sc.cust_type = 'B' and ss.status = 'Y'";
									System.out.println("selectSql ["+selectSql+"]");

									pstmt = connectionObject.prepareStatement(selectSql);
									pstmt.setString(1,localityCode);
									pstmt.setString(2,salesPers);

									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										count = rSet.getInt("count");
									}
									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("distbr count ["+count+"]");
									if (columnValue != null && "Y".equalsIgnoreCase(columnValue))
									{
										isAnyCustomerSel = true;
										isDistBrSelected = true;

										if ( count == 0 )
										{
											errString = itmDBAccessLocal.getErrorString( "","NODISTBR",userId );
											break;
										}
									}
									else if (columnValue != null && "N".equalsIgnoreCase(columnValue))
									{
										if ( count > 0 )
										{
											isDistBrSelected = false;
										}
										else
										{
											toValidateDistBr = false;
										}
									}
								}
								else if( "mtrader_visit".equalsIgnoreCase( childNodeName ) )
								{
									//isMtradeSelected = true;
									selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers = ? and ss.sc_code = sc.sc_code and sc.cust_type = 'T' and ss.status = 'Y'";
									System.out.println("selectSql ["+selectSql+"]");

									pstmt = connectionObject.prepareStatement(selectSql);
									pstmt.setString(1,localityCode);
									pstmt.setString(2,salesPers);

									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										count = rSet.getInt("count");
									}
									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("mtrader count ["+count+"]");
									if (columnValue != null && "Y".equalsIgnoreCase(columnValue))
									{
										isAnyCustomerSel = true;
										isMtradeSelected = true;

										if ( count == 0 )
										{
											errString = itmDBAccessLocal.getErrorString( "","NOMTRADE",userId );
											break;
										}
									}
									else if (columnValue != null && "N".equalsIgnoreCase(columnValue))
									{
										if ( count > 0 )
										{
											isMtradeSelected = false;
										}
										else
										{
											toValidateMtrade = false;
										}
									}
								}
							}//
						}

					if( errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1 )
					{
						if( errString.length() > 0 )
						{
							String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for locality " + locDescr ;

							errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
							break;
						}
						else if( errString1.length() > 0 )
						{
							errString = errString1;
							break;
						}
					}
				} // End of loop
				if( errString == null || errString.trim().length() == 0 &&  !isOvernightStay )
				{
					System.out.println("isAnyCustomerSel ["+isAnyCustomerSel+"], actType=["+actType+"], isWsellerSelected =["+isWsellerSelected+"], isMtradeSelected=["+isMtradeSelected+"], isDistBrSelected=["+isDistBrSelected+"]");
					System.out.println(" toValidateWseller =["+toValidateWseller+"], toValidateDistBr=["+toValidateDistBr+"], toValidateMtrade=["+toValidateMtrade+"]");
					if( ! isAnyCustomerSel && ( actType.equalsIgnoreCase("FW") ) )
					{
						errString = itmDBAccessLocal.getErrorString( "","NOCUSTSELD",userId );
					}
					else
					{
						if( !isWsellerSelected && toValidateWseller && ( actType.equalsIgnoreCase("FW") ) )
						{
							errString = itmDBAccessLocal.getErrorString( "","NOWSESEL",userId );
						}

						if( !isDistBrSelected && toValidateDistBr && ( actType.equalsIgnoreCase("FW") ) )
						{
							errString = itmDBAccessLocal.getErrorString( "","NODISSEL",userId );
						}
						if( !isMtradeSelected && toValidateMtrade && ( actType.equalsIgnoreCase("FW") ) )
						{
							errString = itmDBAccessLocal.getErrorString( "","NOMTRSEL",userId );
						}
					}
				}
			}
			catch(Exception e)
			{
				System.out.println ( "Exception :WsfaDSRWizardEJB :wfValLocality():" + e.getMessage() + ":" );
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if (rSet!= null)
					{
						rSet.close();
						rSet = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}

					if (connectionObject != null)
					{
						connectionObject.close();
					}
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}
			}

			return errString;
	}


	public String wfValCustomer(Document dom, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		GenericUtility genericUtility = GenericUtility.getInstance();

		String errString = "";
		String errString1 = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

		int ctr = 0;
		int noOfChilds = 0;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			ConnDriver connDriver = connDriver = new ConnDriver();;
			connectionObject = connDriver.getConnectDB("DriverValidator");

			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("dddddd : parentNodeListLength(wfValCustomer)["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String custName = getSelectedRowValue(dom, currentFormNo, "cust_name",prntCtr);
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("short_id"))
					{
						if((childNode.getFirstChild() == null) || (childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("short_id","NULLMPLNID",userId);
							break;
						}

					}
					else if(childNodeName.equalsIgnoreCase("event_time_start"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_time_start","NULEVENTTS",userId);
							break;
						}
						else
						{
							String startTime = childNode.getFirstChild().getNodeValue().trim();
							int position = startTime.indexOf(':');

							if ( position < 0 )
							{
								errString = itmDBAccessLocal.getErrorString ("event_time_start", "STIMENV", userId );
								break;
							}
							else
							{
								String hour = startTime.substring( 0, position );
								String minute = startTime.substring( position + 1, startTime.length() ).trim();
								if ( hour.length() == 2 )
								{
									if(!checkIfNumber(hour))
									{
										System.out.println("HOUR IS NOT A NUMBER!!!!");
										errString = itmDBAccessLocal.getErrorString ("event_time_start", "STINVTIME", userId);
										break;
									}
									else if ( Integer.parseInt( hour.trim() ) > 23 )
									{
										errString = itmDBAccessLocal.getErrorString ("event_time_start", "SHOURENV", userId);
										break;
									}

								}
								else
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_start", "SHTIMENV", userId);
									break;
								}
								if ( minute.length() == 2 )
								{
									if(!checkIfNumber(minute))
									{
										System.out.println("MINUTE IS NOT A NUMBER!!!!");
										errString = itmDBAccessLocal.getErrorString ("event_time_start", "STINVTIME", userId);
										break;
									}
									else if ( Integer.parseInt(minute.trim()) >59 )
									{
										errString = itmDBAccessLocal.getErrorString ( "event_time_start", "SMINUTE", userId);
										break;
									}

								}
								else
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_start", "SMTIMENV", userId);
									break;
								}
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("event_time_end"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_time_end","NULEVENTTE",userId);
							break;
						}
						else
						{
							String endTime = childNode.getFirstChild().getNodeValue().trim();

							int position = endTime.indexOf(':');
							if ( position < 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "event_time_end", "ETIMENV", userId);
								break;
							}
							else
							{
								String hour = endTime.substring( 0, position);
								String minute = endTime.substring( position + 1, endTime.length() ).trim();

								if (hour.length() == 2 )
								{
									if(!checkIfNumber(hour))
									{
										System.out.println("HOUR IS NOT A NUMBER!!!!");
										errString = itmDBAccessLocal.getErrorString ("event_time_end", "STINVTIME", userId);
										break;
									}
									else if ( Integer.parseInt(hour.trim()) > 23 )
									{
										errString = itmDBAccessLocal.getErrorString ("event_time_end","EHOURE",userId );
										break;
									}
								}
								else
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_end","EHTIMENV",userId);
									break;
								}
								if ( minute.length() == 2 )
								{
									if(!checkIfNumber(minute))
									{
										System.out.println("MINUTE IS NOT A NUMBER!!!!");
										errString = itmDBAccessLocal.getErrorString ("event_time_end", "STINVTIME", userId);
										break;
									}
									else if ( Integer.parseInt(minute.trim()) > 59 )
									{
										errString = itmDBAccessLocal.getErrorString ("event_time_end","EMINUTE",userId);
										break;
									}
								}
								else
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_end","EMTIMENV",userId);
									break;
								}
								String eventTimeStart = getSelectedRowValue(dom, currentFormNo, "event_time_start",prntCtr);

								int stPosition = eventTimeStart.indexOf(':');
								if ( stPosition < 0 )
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_start","STIMENV",userId);
									break;
								}
								else
								{
									String stHoure = eventTimeStart.substring( 0, stPosition ).trim();
									String stMinute = eventTimeStart.substring( stPosition + 1, eventTimeStart.length() ).trim();

									position = endTime.indexOf(':');
									if ( position < 0 || stHoure.length() == 0 || stMinute.length() == 0 )
									{
										errString = itmDBAccessLocal.getErrorString ("event_time_end","ETIMENV",userId);
										break;
									}
									else
									{

										if ( stHoure.length() > 0 && hour.length() > 0 )
										{
											if ( Integer.parseInt(hour) < Integer.parseInt(stHoure) )
											{
												errString = itmDBAccessLocal.getErrorString ("event_time_end","ETHLSTH",userId);
												break;
											}

											if ( stHoure.equalsIgnoreCase( hour ) )
											{
												if ( stMinute.length() > 0 && minute.length() > 0 )
												{
													if ( Integer.parseInt( minute ) < Integer.parseInt( stMinute ) )
													{
														errString = itmDBAccessLocal.getErrorString ("event_time_end","ETMLSTM",userId);
														break;
													}
												}
											}
											if ( Integer.parseInt( stHoure ) == Integer.parseInt( hour ) && Integer.parseInt( stMinute ) == Integer.parseInt( minute ) )
											{
												errString = itmDBAccessLocal.getErrorString ("event_time_end","EQUAL",userId);
												break;
											}
										}
									}//End else(position)
								}//End else
							}//End else
						}
					}
					else if(childNodeName.equalsIgnoreCase("strg_code"))
					{
						String actCode = genericUtility.getColumnValue("event_type",dom);
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							if( actCode.equalsIgnoreCase("FW") || actCode.indexOf("FW")!= -1 )
							{
								errString1 = itmDBAccessLocal.getErrorString("strg_code","CUSTREQD",userId);
								break;

							}
							else
							{
								errString1 = itmDBAccessLocal.getErrorString("strg_code","NULSTRGCD",userId);
								break;
							}

						}
						else
						{
							String actType = getActivityType(actCode, connectionObject);
							if(actType.indexOf("LEAVE")!=-1)
							{
								if( parentNodeListLength > 1 )
								{
									errString1 = itmDBAccessLocal.getErrorString("strg_code","CUSTONCE",userId);
								}
							}

						}
					}
					else if ( "strg_type".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue( "strg_code", dom );
						//Verifying only in case "Doctor is selected"
						if(  strgCode != null &&  strgCode.length() > 0 && (   ( ! "null".equalsIgnoreCase(strgCode) ) || ( ! "-NA-".equalsIgnoreCase(strgCode) ) ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = itmDBAccessLocal.getErrorString("strg_type","NULSTRGT",userId);
								break;
							}

						}
					}
					else if ( "strg_class_code".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue("strg_code",dom);
						//Verifying only in case "Doctor is selected"
						if(  strgCode != null &&  strgCode.length() > 0 && (   ( ! "null".equalsIgnoreCase(strgCode) ) || ( ! "-NA-".equalsIgnoreCase(strgCode) ) ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = itmDBAccessLocal.getErrorString("strg_class_code","NULSTRCC",userId);
								break;
							}
						}
					}
					else if ( "strg_no_visit".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue( "strg_code", dom );
						//Verifying only in case "Doctor is selected"
						if(  strgCode != null &&  strgCode.length() > 0 && (   ( ! "null".equalsIgnoreCase(strgCode) ) || ( ! "-NA-".equalsIgnoreCase(strgCode) ) ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = itmDBAccessLocal.getErrorString("strg_no_visit","NULSTRGV",userId);
								break;
							}
						}
					}
					else if ( "strg_name".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue( "strg_code", dom );
						String strgType = genericUtility.getColumnValue( "strg_type", dom );
						if( strgCode == null  && strgType != null )
						{
							if ( childNode.getFirstChild() == null  )
							{
								errString = itmDBAccessLocal.getErrorString("strg_name","NULSTRGN",userId);
								break;
							}
						}
						else
						{
							if (strgCode != null && childNode.getFirstChild() != null)
							{
								errString = itmDBAccessLocal.getErrorString("strg_name","INSERTVALD",userId);
							}
						}
					}
					/*Commented by Shahu Mali on 11-FEB-14.START
					else if ( "order_booked".equalsIgnoreCase( childNodeName ) )
					{
						if ( childNode.getFirstChild() == null )
						{
							errString = itmDBAccessLocal.getErrorString("order_booked","ORBONONUL",userId );
							break;
						}
						else
						{
							//Changed By Vidhya on 19/11/09[WS89NOV613 | ORDER BOOKED LENGTH TO BE 6-DIGITS]
							//if( columnValue.length() > 2 )
							if( columnValue.length() > 6 )
							{
								String orderBooked =  "";
								String ordBookDec = "";
								if(columnValue.indexOf(".") != -1)
								{
									System.out.println("entered a decimal!!!!!");
									orderBooked =  columnValue.substring(0, columnValue.indexOf("."));
									ordBookDec =  columnValue.substring(columnValue.indexOf(".")+1,columnValue.length());
									if(!checkIfNumber(orderBooked) || !checkIfNumber(ordBookDec))
									{
										System.out.println("Not a number!!!!!");
										errString = itmDBAccessLocal.getErrorString( "order_booked","INVORDERBK",userId );
										break;

									}
									//Changed By Vidhya on 19/11/09[WS89NOV613 | ORDER BOOKED LENGTH TO BE 6-DIGITS]
									//else if(orderBooked.length() > 2)
									else if(orderBooked.length() > 6)
									{
										errString = itmDBAccessLocal.getErrorString( "order_booked","ORDERBKDGT",userId );
										break;
									}

								}
								else
								{
									System.out.println("Not a two-digit number!!!");
									errString = itmDBAccessLocal.getErrorString("order_booked","ORDERBKDGT",userId );
									break;

								}

							}
							else
							{
								if(!checkIfNumber(columnValue))
								{
									System.out.println("(2-dig)Not a number!!!!!");
									errString = itmDBAccessLocal.getErrorString( "order_booked","INVORDERBK",userId );
									break;

								}

							}

						}
					}
					Commented by Shahu Mali on 11-FEB-14.END
					*/

				}
				if(errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1)
				{
					if( errString.length() > 0 )
					{
						String msgDescr = "";
						msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for customer " + custName ;

						if( custName.length() != 0 && !custName.equalsIgnoreCase("") )
						{
							errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
						}
						break;
					}
					else if( errString1.length() > 0 )
					{
						errString = errString1;
						break;
					}

				}
			}


		}
		catch(Exception e)
		{
			System.out.println ( "Exception :WsfaDSRWizardEJB :wfValData():" + e.getMessage() + ":" );

			//errString = generateErrorString(genericUtility.createErrorString(e));//Commented By Dipak
			throw new ITMException(e);//Commented By Dipak

		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;

	}

	public String wfValItem(Document dom, Document dom2, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		GenericUtility genericUtility = GenericUtility.getInstance();

		String errString = "";
		String errString1 = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ArrayList itemPitchList = new ArrayList();

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

		int ctr = 0;
		int noOfChilds = 0;

		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			ConnDriver connDriver = connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");

			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength(wfValItem)["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String custCode = getSelectedRowValue(dom, currentFormNo, "strg_code",prntCtr);
				String sprsProdGrp = getSelectedRowValue(dom, currentFormNo, "sales_prod_grp", prntCtr);
				String itemCode = getSelectedRowValue(dom, currentFormNo, "item_code",prntCtr);
				String itemDescr = getSelectedRowValue(dom, currentFormNo, "item_descr",prntCtr);
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("item_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							if(sprsProdGrp == null || "null".equalsIgnoreCase(sprsProdGrp))
							{
								errString = itmDBAccessLocal.getErrorString("item_code","NULLITEMCD",userId);
								break;
							}
						}
						else
						{
							String pitch = getSelectedRowValue(dom, currentFormNo, "briefed_descr",prntCtr);
							if(!pitch.equalsIgnoreCase("Promo Material"))
							{
								errString = itmDBAccessLocal.getErrorString("item_code","INVLPITCH",userId);
								break;
							}
							String actCode = genericUtility.getColumnValue("activity_code",dom2);
							String actType = getActivityType(actCode,connectionObject);
							if(actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)
							{
								if( parentNodeListLength > 0 )
								{
									errString1 = itmDBAccessLocal.getErrorString("item_code","ITEMNOTREQ",userId);
									break;
								}
							}

						}

					}
					else if(childNodeName.equalsIgnoreCase("sales_prod_grp"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							if(itemCode == null || "null".equalsIgnoreCase(itemCode))
							{
								errString = itmDBAccessLocal.getErrorString("sales_prod_grp","NULLSPGRP",userId);
								break;

							}

						}
						else
						{
							String pitch = getSelectedRowValue(dom, currentFormNo, "briefed_descr",prntCtr);
							if(pitch.equalsIgnoreCase("Promo Material"))
							{
								if(!(pitch.equalsIgnoreCase("P1") || pitch.equalsIgnoreCase("P2") || pitch.equalsIgnoreCase("P3") || pitch.equalsIgnoreCase("P4")))
								{
									errString = itmDBAccessLocal.getErrorString("sales_prod_grp","INVLPITCH",userId);
									break;
								}
							}

							String actCode = genericUtility.getColumnValue("activity_code",dom2);
							String actType = getActivityType(actCode,connectionObject);
							if( actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1 )
							{
								if( parentNodeListLength > 0 )
								{
									errString1 = itmDBAccessLocal.getErrorString("sales_prod_grp","ITEMNOTREQ",userId);
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("briefed_descr"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("briefed_descr","NULLPITCH", userId);
							break;
						}
						else
						{
							String pitch = columnValue + "["+custCode+"]";
							if(!pitch.startsWith("Promo Material") && itemPitchList.contains(pitch) )
							{
								if ( sprsProdGrp.length() != 0 && !"null".equalsIgnoreCase(sprsProdGrp) )
								{
									errString = itmDBAccessLocal.getErrorString("briefed_descr","ITEMONCE",userId);
									break;
								}

							}
							itemPitchList.add(pitch);

						}

					}
					else if ( "quantity".equalsIgnoreCase( childNodeName ) )
					{
						if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
						{
							errString = itmDBAccessLocal.getErrorString("quantity","NULQUACD",userId);
							break;
						}
						else
						{

							if( Integer.parseInt( columnValue ) > 0 )
							{
								if( sprsProdGrp.length() != 0 && !"null".equalsIgnoreCase(sprsProdGrp) )
								{
									errString = itmDBAccessLocal.getErrorString("quantity","INVLQUANT",userId);
									break;
								}

							}
							else if(!( Integer.parseInt( columnValue ) > 0 ))
							{
								if( itemCode.length() != 0 && !"null".equalsIgnoreCase(itemCode) )
								{
									errString = itmDBAccessLocal.getErrorString("quantity","QUANTREQD",userId);
									break;
								}

							}
						}

					}

				}
				if( errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1)
				{
					if( errString.length() > 0 )
					{
						errString = getItemErrorString( errString,  custCode, itemDescr, itemCode, sprsProdGrp);
						break;
					}
					else if( errString1.length() > 0 )
					{
						errString = errString1;
						break;
					}
				}
			}
			itemPitchList.clear();

		}
		catch(Exception e)
		{
			System.out.println ( "Exception :WsfaDSRWizardEJB :wfValData():" + e.getMessage() + ":" );
			//errString = generateErrorString(genericUtility.createErrorString(e));//Commented By Dipak
			throw new ITMException(e);//Commented By Dipak

		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}


				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;

	}
	//Validation End*********

	//Getting Default Values for forms Start*********
	//Changed By Vidhya on 15/10/09[WI89BAS033 | changing signature ]
	//public String getSalesPers(Document dom, String currentForm, String userId, String salesPers, String actCode, String trvDate) throws ITMException
	public String getSalesPers(Document dom, Document dom2, String currentForm, String userId, String salesPers, String actCode, String trvDate) throws ITMException
	{
		ResultSet rs = null;
		Connection connectionObject = null;
		Statement stmt = null;

		String sql = "";
		String currDate = "";
		String chgTerm ="";
		String preFormDet ="";
		String actDescr = "";
		StringBuffer valueXmlString = new StringBuffer();
		boolean flag = false;
		//Changed By Vidhya on 15/10/09[WI89BAS033 | Changing signature]
		ArrayList temp = new ArrayList();

		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			System.out.println("SalesPerson  (getSalesPers)> "+salesPers);
			if( salesPers != null && salesPers.trim().length() > 0 && !salesPers.equalsIgnoreCase("") )
			{
				salesPers = salesPers.trim().toUpperCase();
			}
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );

			//to append previous values of current form from current dom on previous action
			flag = preDomExists( dom, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );
			if( flag )
			{
				//Changed By Vidhya on 15/10/09[WI89BAS033 | Changing signature]Start
				//preFormDet = getPrevFormValues( dom, currentForm, domID );
				preFormDet = getPrevFormValues( dom, currentForm, temp , "sales_pers");
				Document preFormDom =  genericUtility.parseString("<Root>"+preFormDet+"</Root>");
				String actCodePreDom = genericUtility.getColumnValue( "activity_code",preFormDom );
				java.util.Date eventDte = genericUtility.getDateObject(genericUtility.getColumnValue( "event_date", preFormDom ));

				//for creating act_desr node
				sql = "SELECT DESCR FROM FIELDACTIVITY WHERE ACTIVITY_CODE = '"+actCodePreDom+"'";
				stmt = connectionObject.createStatement();
				rs = stmt.executeQuery(sql);
				if(rs.next())
				{
					actDescr = rs.getString("DESCR");

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				Element element = (Element) preFormDom.getElementsByTagName("Detail"+currentForm).item(0);
				element.appendChild(preFormDom.createElement("activity_descr"));
				preFormDom.getElementsByTagName("activity_descr").item(0).appendChild(preFormDom.createCDATASection(actDescr));

				//for eventdate as long
				Node node = preFormDom.getElementsByTagName("Detail" + currentForm).item(0);
				NodeList nodeList = node.getChildNodes();
				for (int i = 0; i < nodeList.getLength(); i++ )
				{
					Node elementNode = nodeList.item(i);
					if ( elementNode.getNodeName().equals("event_date") )
					{
						if ( elementNode.getFirstChild() == null)
						{
							Element sourceElement = preFormDom.createElement( "event_date" );
							Text sourceText = preFormDom.createTextNode( Long.toString(eventDte.getTime()) );
							sourceElement.appendChild( sourceText );
							Node updatedNode = preFormDom.importNode( ( Node ) sourceElement,true );
							node.replaceChild( updatedNode, elementNode );
						}
						else
						{
							elementNode.getFirstChild().setNodeValue( Long.toString(eventDte.getTime()) );
						}
					}
				}
				//Changed By Vidhya on 15/10/09[WI89BAS033 | Changing signature] End
				preFormDet = genericUtility.serializeDom(preFormDom);
				if( preFormDet != null || !"null".equalsIgnoreCase( preFormDet ))
				{
					valueXmlString.append( preFormDet );
					domID = domID + 1;
				}

			}

			//for sales person
			sql = "SELECT DISTINCT SR.SPRS_CODE SALES_PERS, UPPER(SP.SP_NAME) SP_NAME FROM SPRS_ROUTE SR, SALES_PERS SP WHERE SR.SPRS_CODE = SP.SALES_PERS AND SP.SP_NAME LIKE '%"+checkNull(salesPers)+"%' ORDER BY SPRS_CODE ";
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery(sql);
			while(rs.next())
			{
				valueXmlString.append( "<Detail"+currentForm+" domID='" + domID + "' selected ='N'>\r\n" );
				valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(rs.getString("SALES_PERS"))).append( "]]></sales_pers>\r\n" );
				valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append(checkNull(rs.getString("SP_NAME"))).append( "]]></sales_pers_sp_name>\r\n" );
				valueXmlString.append( "<event_date><![CDATA[" ).append( checkNull( trvDate ) ).append( "]]></event_date>\r\n" );
				valueXmlString.append( "<activity_code><![CDATA[" ).append( checkNull( actCode )).append( "]]></activity_code>\r\n" );
				valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
				valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
				valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
				valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
				valueXmlString.append( "</Detail"+currentForm+">\r\n" );
				domID++;

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}

			domID = 1;

		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRWizardEJB :getPlaceOfWork():" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRWizardEJB :getPlaceOfWork :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}

	//Changed By Vidhya on 15/10/09[WI89BAS033 | changing signature]
	//public String getPlaceOfWork(Document dom, String currentForm, String userId, String sprsCode, String actCode, String trvDate) throws ITMException
	public String getPlaceOfWork( Document dom, Document dom2, String currentForm, String userId, String sprsCode, String actCode, String trvDate, String loginMode) throws ITMException
	{
		ResultSet rs = null;
		Connection connectionObject = null;
		PreparedStatement pstmt = null;

		String sql = "";
		String sqlEdit = "";
		String currDate = "";
		String chgTerm ="";
		String preFormDet ="";
		String locality ="";
		String planDataString="";
		String placeOfReturnStr="";
		String placeOfReturnDescr="";
		StringBuffer valueXmlString = new StringBuffer();
		GenericUtility genericUtility = GenericUtility.getInstance();
		boolean flag = false;
		int rowsRS = 0;
		int count=0;
		//Changed By Vidhya on 15/10/09[WI89BAS033 | Changing signature]
		ArrayList temp = new ArrayList();

		//Changed By Pragyannnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn
		//domID = 1;

		try{
			//Changed By Vidhya on 15/10/09[WI89BAS033 | Changing signature]
			temp.add("'"+sprsCode.trim()+"'");

			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			System.out.println("SalesPerson > " + sprsCode);

			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );

			//Added By Shahu Mali on 14-FEB-14
			 placeOfReturnStr = genericUtility.getColumnValue("last_place_of_return", dom2,"1");
			 placeOfReturnDescr = genericUtility.getColumnValue("last_place_of_descr_return", dom2,"1");

			 System.out.println("placeOfReturnStr...."+placeOfReturnStr+"placeOfReturnDescr...."+placeOfReturnDescr);

			//to append previous values of current form from current dom on previous action
			flag = preDomExists( dom, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );
			if( flag )
			{
				//Displaying Plan Activity and Plan Locality
				planDataString=getDSRPlanData(sprsCode,trvDate);
				System.out.println("planDataString=["+planDataString+"]");

				//Changed By Vidhya on 15/10/09[WI89BAS033 | Changing signature]
				//preFormDet = getPrevFormValues( dom, currentForm, domID );
				preFormDet = getPrevFormValues( dom, currentForm, temp , "sales_pers");
				if( preFormDet != null || !"null".equalsIgnoreCase( preFormDet ))
				{

					locality = getLocFromDom( genericUtility.parseString("<Root>"+preFormDet+"</Root>"), currentForm, sprsCode );
					System.out.println("locality:::::::["+locality+"]");
					System.out.println("preFormDet:::::::["+preFormDet+"]");

				    valueXmlString.append( preFormDet );

				}
			}
			else
			{


				//Commented and changed below by Gulzar on 16/04/13
				//sql = "SELECT COUNT(*) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ?";
				PreparedStatement pstmtSprsTravel =  null;
				ArrayList halfDayActList = halfDayActivityList("HALF_DAY_ACTIVITIES",connectionObject);
				String dcrID = getDCRId(connectionObject,sprsCode, trvDate, actCode );
				if(halfDayActList.contains(actCode))
				{
					sqlEdit = "SELECT ST.*, SR.DESCR DESCR FROM SPRS_TRAVEL ST, SPRS_ROUTE SR  WHERE ST.SALES_PERS = SR.SPRS_CODE AND ST.LOCALITY_CODE = SR.LOCALITY_CODE AND ST.SALES_PERS = ? AND ST.TRAVEL_DATE = ? AND ST.DCR_ID = ? ORDER BY ORDER_OF_VISIT, DESCR";

					sql = "SELECT COUNT(*) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ? and DCR_ID = ?";
					pstmtSprsTravel =  connectionObject.prepareStatement( sql );
					pstmtSprsTravel.setString(1, sprsCode);
					pstmtSprsTravel.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmtSprsTravel.setString(3, dcrID);
				}
				else
				{
					sqlEdit = "SELECT ST.*, SR.DESCR DESCR FROM SPRS_TRAVEL ST, SPRS_ROUTE SR  WHERE ST.SALES_PERS = SR.SPRS_CODE AND ST.LOCALITY_CODE = SR.LOCALITY_CODE AND ST.SALES_PERS = ? AND ST.TRAVEL_DATE = ? ORDER BY ORDER_OF_VISIT, DESCR";

					sql = "SELECT COUNT(*) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ?";
					pstmtSprsTravel =  connectionObject.prepareStatement( sql );
					pstmtSprsTravel.setString(1, sprsCode);
					pstmtSprsTravel.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				}

				ResultSet rsTravel = pstmtSprsTravel.executeQuery();
				if(rsTravel.next())
				{
					rowsRS = rsTravel.getInt(1);
				}

				//Commented and moved above by Gulzar on 16/04/13 not to display the 'MKTEV' activity type record
				//sqlEdit = "SELECT ST.*, SR.DESCR DESCR FROM SPRS_TRAVEL ST, SPRS_ROUTE SR  WHERE ST.SALES_PERS = SR.SPRS_CODE AND ST.LOCALITY_CODE = SR.LOCALITY_CODE AND ST.SALES_PERS = ? AND ST.TRAVEL_DATE = ? ORDER BY ORDER_OF_VISIT, DESCR";

				if( rowsRS > 0 )
				{
					pstmt =  connectionObject.prepareStatement( sqlEdit );
					pstmt.setString(1, sprsCode);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

					//Changed by Gulzar on 17/04/13
					if(halfDayActList.contains(actCode))
					{
						pstmt.setString(3, dcrID);
					}
					//Changed by Gulzar on 17/04/13 : END
					rs = pstmt.executeQuery();

					while(rs.next())
					{
						count++;
						valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<locality_code><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></sprs_route_descr>\r\n" );
						valueXmlString.append( "<stan_code><![CDATA[" ).append(checkNull(rs.getString("STAN_CODE"))).append( "]]></stan_code>\r\n" );
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append(checkNull(rs.getString("ORDER_OF_VISIT"))).append( "]]></order_of_visit>\r\n" );
						valueXmlString.append( "<travel_mode><![CDATA[" ).append(checkNull(rs.getString("TRAVEL_MODE"))).append( "]]></travel_mode>\r\n" );
						valueXmlString.append( "<over_night><![CDATA[" ).append(checkNull(rs.getString("OVER_NIGHT"))).append( "]]></over_night>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<travel_date><![CDATA[" ).append(trvDate).append( "]]></travel_date>\r\n" );
						valueXmlString.append( "<activity_code><![CDATA[" ).append(checkNull(actCode)).append( "]]></activity_code>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<plan_id><![CDATA[" ).append("").append( "]]></plan_id>\r\n" );
						valueXmlString.append( "<stan_code__from><![CDATA[" ).append("").append( "]]></stan_code__from>\r\n" );
						valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
						valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
						valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
						valueXmlString.append( "<locality_code_from><![CDATA[" ).append("").append( "]]></locality_code_from>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[]]></line_no>\r\n" );
						//valueXmlString.append( "<dr_visit><![CDATA[" ).append(checkNull(rs.getString("DR_VISIT"))).append( "]]></dr_visit>\r\n" );
						//valueXmlString.append( "<chem_visit><![CDATA[" ).append(checkNull(rs.getString("CHEM_VISIT"))).append( "]]></chem_visit>\r\n" );
						valueXmlString.append( "<to_disable><![CDATA[" ).append("Y").append( "]]></to_disable>\r\n" );//Added By Shahu Mali on 26-DEC-13[WS3INOV004]
						//Added By Shahu Mali on 27-JAN-14.START[ Added whole seller,distributer and modern trade tag in locality screen]
						valueXmlString.append( "<wseller_visit><![CDATA[" ).append(checkNull(rs.getString("WSELLER_VISIT"))).append( "]]></wseller_visit>\r\n" );
						valueXmlString.append( "<distbr_visit><![CDATA[" ).append(checkNull(rs.getString("DISTBR_VISIT"))).append( "]]></distbr_visit>\r\n" );
						valueXmlString.append( "<mtrader_visit><![CDATA[" ).append(checkNull(rs.getString("MTRADER_VISIT"))).append( "]]></mtrader_visit>\r\n" );
						valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( placeOfReturnStr ).append( "]]></last_place_of_return>\r\n" );
						valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(placeOfReturnDescr).append( "]]></last_place_of_descr_return>\r\n" );
						valueXmlString.append( "<stan_code__fr><![CDATA[" ).append("").append( "]]></stan_code__fr>\r\n" );
						valueXmlString.append( "<stan_code__to><![CDATA[" ).append("").append( "]]></stan_code__to>\r\n" );
						//Added By Shahu Mali on 27-JAN-14.END
						if(count==1)
						{
							//Displaying Plan Activity and Plan Locality
							planDataString=getDSRPlanData(sprsCode,trvDate);
							System.out.println("planDataString=["+planDataString+"]");
							//valueXmlString.append( "<dsr_plan_data>").append(planDataString).append( "</dsr_plan_data>\r\n" );
							valueXmlString.append(planDataString);
						}
						valueXmlString.append( "</Detail"+currentForm+">\r\n" );
						domID ++;

					}
					//added by rakesh kumar 13/12/12
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					locality = getLocFromDom(genericUtility.parseString("<Root>"+valueXmlString.toString()+"</Root>"), currentForm, sprsCode);
				}

		        if (rsTravel != null)
				{
		        	rsTravel.close();
		        	rsTravel = null;
				}
				if(pstmtSprsTravel!=null)
				{
					pstmtSprsTravel.close();
					pstmtSprsTravel = null;
				}
			}

			if( locality != null && locality.length() == 0 )
			{
				locality = "'x'";
			}
			//Changed by VIDHYA on 10/1/2009 [WI89BAS033 |  CHANGED QUERY FOR PREV-EDIT CASE]
			//sql = "SELECT LOCALITY_CODE, DESCR, STAN_CODE FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND STATUS='Y' ";
			if ( loginMode.equalsIgnoreCase("RIA") )
			{

				sql = "SELECT LOCALITY_CODE, DESCR, STAN_CODE FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND STATUS='Y'";
			}
			else if ( loginMode.equalsIgnoreCase("HTML") )
			{
				sql = "SELECT LOCALITY_CODE, DESCR, STAN_CODE FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND STATUS='Y' AND LOCALITY_CODE NOT IN ("+locality+") ";
			}

			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				count++;
				valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'N'>\r\n" );
				valueXmlString.append( "<locality_code><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></locality_code>\r\n" );
				valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></sprs_route_descr>\r\n" );
				valueXmlString.append( "<stan_code><![CDATA[" ).append(checkNull(rs.getString("STAN_CODE"))).append( "]]></stan_code>\r\n" );
				valueXmlString.append( "<order_of_visit><![CDATA[" ).append("").append( "]]></order_of_visit>\r\n" );
				valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
				valueXmlString.append( "<travel_date><![CDATA[" ).append(trvDate).append( "]]></travel_date>\r\n" );
				valueXmlString.append( "<activity_code><![CDATA[" ).append(checkNull(actCode)).append( "]]></activity_code>\r\n" );
				valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
				valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
				valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
				valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
				valueXmlString.append( "<plan_id><![CDATA[" ).append("").append( "]]></plan_id>\r\n" );
				valueXmlString.append( "<stan_code__from><![CDATA[" ).append("").append( "]]></stan_code__from>\r\n" );
				valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
				valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
				valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
				valueXmlString.append( "<locality_code_from><![CDATA[" ).append("").append( "]]></locality_code_from>\r\n" );
				valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
				valueXmlString.append( "<line_no><![CDATA[]]></line_no>\r\n" );
				valueXmlString.append( "<travel_mode><![CDATA[" ).append("ROAD").append( "]]></travel_mode>\r\n" );
				valueXmlString.append( "<over_night><![CDATA[" ).append("N").append( "]]></over_night>\r\n" );
				//valueXmlString.append( "<dr_visit><![CDATA[" ).append("N").append( "]]></dr_visit>\r\n" );
				//valueXmlString.append( "<chem_visit><![CDATA[" ).append("N").append( "]]></chem_visit>\r\n" );
				valueXmlString.append( "<to_disable><![CDATA[" ).append("N").append( "]]></to_disable>\r\n" );//Added By Shahu Mali on 26-DEC-13[WS3INOV004]
				//Added By Shahu Mali on 27-JAN-14.START[ Added whole seller,distributer and modern trade tag in locality screen]
				valueXmlString.append( "<wseller_visit><![CDATA[" ).append("N").append( "]]></wseller_visit>\r\n" );
				valueXmlString.append( "<distbr_visit><![CDATA[" ).append("N").append( "]]></distbr_visit>\r\n" );
				valueXmlString.append( "<mtrader_visit><![CDATA[" ).append("N").append( "]]></mtrader_visit>\r\n" );
				valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( placeOfReturnStr ).append( "]]></last_place_of_return>\r\n" );
				valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(placeOfReturnDescr).append( "]]></last_place_of_descr_return>\r\n" );
				valueXmlString.append( "<stan_code__fr><![CDATA[" ).append("").append( "]]></stan_code__fr>\r\n" );
				valueXmlString.append( "<stan_code__to><![CDATA[" ).append("").append( "]]></stan_code__to>\r\n" );

				//Added By Shahu Mali on 27-JAN-14.END
				if(count==1)
				{
					//Displaying Plan Activity and Plan Locality
					planDataString=getDSRPlanData(sprsCode,trvDate);
					System.out.println("planDataString=["+planDataString+"]");
					//valueXmlString.append( "<dsr_plan_data>").append(planDataString).append( "</dsr_plan_data>\r\n" );
					valueXmlString.append(planDataString);
				}
				valueXmlString.append( "</Detail"+currentForm+">\r\n" );
				domID ++;

			}
			domID = 1;
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRWizardEJB :getPlaceOfWork():" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRWizardEJB :getPlaceOfWork :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("placeof work detail:::"+valueXmlString.toString());
		return valueXmlString.toString();
	}

	public String getCustomerDetail(Document dom, Document dom2, String currentForm, String userId, String sprsCode, String actCode, String trvDate, String custTypeList) throws ITMException
	{
		ResultSet rs = null;
		Connection connectionObject = null;
		Statement stmt = null;
		PreparedStatement pstmt = null;


		String sql = "";
		String currDate = "";
		String chgTerm ="";
		String locality = "";
		String hours="";
		String startTime="";
		String hour = "";
		String minute = "";
		String interval ="";
		String preFormDet ="";
		String sqlEdit = "";
		String customers ="";
		String [] temp;
		String strgCode = "";//Gulzar 17/06/12
		String visitDatesInMonth = "";//Gulzar on 17/06/12

		StringBuffer valueXmlString = new StringBuffer();
		List<String> list = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		boolean flag = false;
		int locForm = 0;
		int rowsRS = 0;
		/*Added By Shahu Mali on 27-DEC-13.START*/
		NodeList parentList = null;
		Node parentNode = null;
		String chemistVisit = "";
		String wSellerVisit = "";
		boolean chemistExistFlag;
		boolean wSellerExistFlag;
		/*Added By Shahu Mali on 27-DEC-13.END*/

		try
		{
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			System.out.println("Salesperson >"+sprsCode);


			String trvDBDate =  genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			String eventDate =  genericUtility.getValidDateString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			String wsellerVisitValue = genericUtility.getColumnValue("wseller_visit", dom2);
			String distBrVisitValue = genericUtility.getColumnValue("distbr_visit", dom2);
			String mTraderVisitValue = genericUtility.getColumnValue("mtrader_visit", dom2);


			locForm = Integer.parseInt(currentForm) - 1;

			String custTypeListBuf = custTypeList;
			System.out.println("custTypeListBuf=["+custTypeListBuf+"]");
			if(custTypeListBuf != null && custTypeListBuf.startsWith("'"))
			{
				custTypeListBuf = custTypeListBuf.substring(1);
			}
			if(custTypeListBuf != null && custTypeListBuf.lastIndexOf("'") != -1)
			{
				custTypeListBuf = custTypeListBuf.substring(0,custTypeListBuf.lastIndexOf("'"));
			}
			System.out.println("custTypeListBuf111=["+custTypeListBuf+"]");

			String custTypeArr[] = new String[10];
			if(custTypeListBuf.indexOf("','") != -1)
			{
				custTypeArr = custTypeListBuf.split("','");
			}
			else
			{
				custTypeArr[0] =custTypeListBuf;
			}
			String custType = "";
			for(int i = 0; i < custTypeArr.length; i++)
			{
				custType = custTypeArr[i];
				String localityStr=getLocFromDom(dom2, ""+2, sprsCode, custType );
				//localityStr=localityStr+",";
				locality = locality+localityStr;
				custType = "";
			}
			System.out.println("before:locality=["+locality+"]");
			if(locality != null && locality.lastIndexOf(",") != -1)
			{
				locality=locality.substring(0,locality.lastIndexOf(","));
			}
			System.out.println("getLocFromDom:locality=["+locality+"]");

			//Gulzar on 17/06/12
			String otherParticipant = checkNull(genericUtility.getColumnValue("oth_participant", dom2, "1"));//Gulzar
			String workWithOther = checkNull(genericUtility.getColumnValue("work_with_other", dom2, "1"));
			String workWith = checkNull(genericUtility.getColumnValue("visited_with_display", dom2, "1"));
			String activityCodeDom = checkNull(genericUtility.getColumnValue("activity_code", dom2, "1"));

			System.out.println("otherParticipant=["+otherParticipant+"]");
			System.out.println("workWith=["+workWith+"]");


			temp = locality.split(",");
			String actType = getActivityType( actCode, connectionObject );

			int strgMeetCount = 0;
			String checkStrgMeetSql = "SELECT COUNT(1) AS COUNT FROM STRG_MEET WHERE EVENT_DATE  = ? AND SALES_PERS = ? AND STRG_CODE = ?";
			PreparedStatement pstmtCheckStrgMeet = connectionObject.prepareStatement(checkStrgMeetSql);

			int TotalRecord=0;
			int srNo=0;//Shahu 28/12/12

			//to append previous values of current form from current dom on previous action
			flag = preDomExists( dom, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );
			if(flag)
			{
				preFormDet = getPrevFormValues( dom, currentForm, new ArrayList<String>(Arrays.asList(temp)), "locality_code" );

				System.out.println( "preFormDet::::::::::::::"+preFormDet);

				String actCodePreDom = getSelectedRowValue(  genericUtility.parseString("<Root>"+preFormDet+"</Root>"), currentForm, "event_type", 0);
				String actTypePreDom = getActivityType( actCodePreDom, connectionObject );

				Document preFormDom =  genericUtility.parseString("<Root>"+preFormDet+"</Root>");
				NodeList preDomList = preFormDom.getElementsByTagName("Detail" + currentForm);
				for (int prntCtr = 0; prntCtr < preDomList.getLength(); prntCtr++ )
				{
					srNo++;// Added By Shahu Mali 0n 28/12/12

					String locDescr ="";
					String localityCode = getSelectedRowValue( preFormDom, currentForm,  "locality_code", prntCtr );
					sql = "SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
					pstmt =  connectionObject.prepareStatement(sql);
					pstmt.setString(1, localityCode);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
						locDescr = rs.getString("DESCR");

					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println(" locality descr ["+locDescr+"]");
					Element element = (Element) preFormDom.getElementsByTagName("Detail"+currentForm).item(prntCtr);
					element.appendChild(preFormDom.createElement("activity_type"));
					preFormDom.getElementsByTagName("activity_type").item(prntCtr).appendChild( preFormDom.createCDATASection( actTypePreDom ) );
					String custCode = getSelectedRowValue( preFormDom, currentForm,  "strg_code", prntCtr );
					pstmtCheckStrgMeet.setTimestamp(1, java.sql.Timestamp.valueOf(trvDBDate));
					pstmtCheckStrgMeet.setString(2, userId);
					pstmtCheckStrgMeet.setString(3, custCode);
					ResultSet rsCheckStrgMeet = pstmtCheckStrgMeet.executeQuery();
					if(rsCheckStrgMeet.next())
					{
						strgMeetCount = rsCheckStrgMeet.getInt("COUNT");
					}
					pstmtCheckStrgMeet.clearParameters();
					rsCheckStrgMeet.close(); rsCheckStrgMeet = null;
					if(strgMeetCount > 0 )
					{
						element.appendChild(preFormDom.createElement("to_disable"));
						preFormDom.getElementsByTagName("to_disable").item(prntCtr).appendChild( preFormDom.createCDATASection( "Y" ) );
					}
					else
					{
						element.appendChild(preFormDom.createElement("to_disable"));
						preFormDom.getElementsByTagName("to_disable").item(prntCtr).appendChild( preFormDom.createCDATASection( "N" ) );
					}
					element.appendChild(preFormDom.createElement("sr_no"));
					preFormDom.getElementsByTagName("sr_no").item(prntCtr).appendChild( preFormDom.createCDATASection( ""+srNo ) );
				}
				if( pstmtCheckStrgMeet != null )
				{
					pstmtCheckStrgMeet.close(); pstmtCheckStrgMeet = null;
				}
				preFormDet = genericUtility.serializeDom( preFormDom );

				if( preFormDet != null && preFormDet.indexOf("<Root>") != -1)
				{
					preFormDet = preFormDet.substring(preFormDet.indexOf("<Root>")+6,preFormDet.indexOf("</Root>"));
				}

				if( preFormDet != null || !"null".equalsIgnoreCase(preFormDet))
				{
					if ( actType.equalsIgnoreCase( actTypePreDom ) )
					{
						String preDomLocality = getLocFromDom( genericUtility.parseString("<Root>" + preFormDet + "</Root>"), currentForm, sprsCode );
						list = new ArrayList<String>( Arrays.asList( temp ) );
						list.removeAll( Arrays.asList( preDomLocality.split(",") ) );
						temp = list.toArray(new String[0]);
						customers = getCustFromDom( genericUtility.parseString("<Root>" + preFormDet + "</Root>"), currentForm, sprsCode , "Y");
						valueXmlString.append( preFormDet );
					}
				}

			}
			else
			{
				sql = "SELECT COUNT(*) FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ?";
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, sprsCode);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( trvDBDate ) );
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					rowsRS = rs.getInt(1);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}


				if ( locality == null || locality.trim().length() == 0 )
				{
					locality = "''";
				}

				sqlEdit="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
						"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+
						" STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3, STRG_MEET.STRG_TYPE AS CUST_TYPE ," +
						" (CASE WHEN STRG_MEET.STRG_TYPE = 'W' THEN 1  WHEN STRG_MEET.STRG_TYPE='B' THEN 2  WHEN STRG_MEET.STRG_TYPE='T' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ  "+
						" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
						"  WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
						" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
						" AND STRG_MEET.SALES_PERS = ? "+
						" AND STRG_MEET.EVENT_DATE = ? "+
						" AND STRG_MEET.STRG_CODE IN "+
						" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
						"    WHERE STRG_STATUS_HIST .EFF_FROM <= ?  "+
						"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
						"    AND STRG_CUSTOMER.CUST_TYPE in("+custTypeList+") " +
						"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) AND STRG_MEET.LOCALITY_CODE IN ("+locality+")" +
						" ORDER BY CUST_TYPE_SEQ,STRG_MEET.SHORT_ID ";

				System.out.println("Rows ["+rowsRS+"]");

				if( rowsRS > 0 )
				{

					pstmt =  connectionObject.prepareStatement( sqlEdit );
					pstmt.setString(1, sprsCode);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( trvDBDate ) );
					pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( trvDBDate ) );
					pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf( trvDBDate ) );
					//pstmt.setString(5, custType);

					rs = pstmt.executeQuery();

					while(rs.next())
					{
						srNo++;// added by shahu 28/12/12
						String actypeDB = checkNull(rs.getString("ACT_TYPE"));
						custType = checkNull(rs.getString("CUST_TYPE"));
						strgCode = checkNull(rs.getString("STRG_CODE"));//Gulzar on 17/06/12

						if (otherParticipant == null || otherParticipant.trim().length() == 0)
						{
							otherParticipant = checkNull(rs.getString("OTH_PARTICIPANT"));
						}

						visitDatesInMonth = getDocVistDatesInMonth(strgCode,sprsCode,eventDate,connectionObject);

						if ( actType.equalsIgnoreCase(actypeDB) )
						{
							String places = checkNull(rs.getString("LOCALITY_CODE"));
							list = new ArrayList<String>( Arrays.asList( temp ) );
							list.removeAll( Arrays.asList("'"+places+"'" ) );
							temp = list.toArray(new String[0]);
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append("<sr_no><![CDATA[" ).append(srNo).append( "]]></sr_no>\r\n"); // Added By Shahu Mali on  28/12/12
							valueXmlString.append("<to_disable><![CDATA[Y]]></to_disable>\r\n"); //rakesh kumar on 16/11/12 to disable the checkbox
							valueXmlString.append("<short_id><![CDATA[" ).append( checkNull(rs.getString("SHORT_ID")).trim()).append( "]]></short_id>\r\n");
							valueXmlString.append("<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");
							if(actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)
							{
								valueXmlString.append("<cust_name><![CDATA[-NA-]]></cust_name>\r\n");
							}
							else
							{
								valueXmlString.append("<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");
							}
							//Changed By Vidhya on 07/12/09[WS89NOV641 | to show locality]
							valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR"))).append( "]]></locality_descr>\r\n" );
							System.out.println("*****POB_VAL =["+rs.getString("POB_VAL")+"]******");
							valueXmlString.append( "<pob_val><![CDATA[" ).append( checkNull(rs.getString("POB_VAL"))).append( "]]></pob_val>\r\n" );
							valueXmlString.append( "<order_booked><![CDATA[" ).append( checkNull(rs.getString("ORDER_BOOKED"))).append( "]]></order_booked>\r\n" );
							valueXmlString.append( "<event_time_start><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></event_time_start>\r\n" );
							valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_END"))).append( "]]></event_time_end>\r\n" );
							valueXmlString.append( "<meet_summ><![CDATA[" ).append( checkNull(rs.getString("MEET_SUMM"))).append( "]]></meet_summ>\r\n" );
							valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

							valueXmlString.append( "<oth_participant><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
							valueXmlString.append( "<visited_with_display><![CDATA[" ).append(workWith).append( "]]></visited_with_display>\r\n" );
							if("JW".equalsIgnoreCase(actCode) && "FW".equalsIgnoreCase(actType))//Gulzar on 17/06/12
							{
								valueXmlString.append( "<work_with_other><![CDATA[" ).append(workWithOther).append( "]]></work_with_other>\r\n" );
							}
							else
							{
								valueXmlString.append( "<work_with_other><![CDATA[" ).append("").append( "]]></work_with_other>\r\n" );
							}
							valueXmlString.append( "<work_team><![CDATA[" ).append(checkNull(rs.getString("WORK_TEAM"))).append( "]]></work_team>\r\n" );
							//valueXmlString.append( "<work_team_disp><![CDATA[" ).append(checkNull(rs.getString("WT_DESCR"))).append( "]]></work_team_disp>\r\n" );
							valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );

							valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
							valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
							valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
							valueXmlString.append( "<locality_code><![CDATA[" ).append(places).append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append("").append( "]]></sales_pers_sp_name>\r\n" );
							valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
							valueXmlString.append( "<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
							//Commented and below changes done by Shahu Mali on 29-APR-13
							//valueXmlString.append( "<event_type><![CDATA[" ).append(checkNull(rs.getString("EVENT_TYPE"))).append( "]]></event_type>\r\n" );
							valueXmlString.append( "<event_type><![CDATA[" ).append(checkNull(activityCodeDom)).append( "]]></event_type>\r\n" );
							//Changed By Vidhya on 08/12/09[WS89NOV642 | adding actype node to hide team when leave.]
							valueXmlString.append( "<activity_type><![CDATA[" ).append(actypeDB).append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<strg_name><![CDATA[]]></strg_name>\r\n" );
							//@Vidhya on 10/11/09[fOR STRG_TYPE NULL MESSAGE] Start
							//valueXmlString.append( "<strg_type><![CDATA[ ]]></strg_type>\r\n" );
							//Commented and Below changes done by Shahu Mali on 03-FEB-14
							valueXmlString.append( "<strg_type><![CDATA["+custType+"]]></strg_type>\r\n" );

							valueXmlString.append( "<strg_no_visit><![CDATA[" ).append(checkNull(rs.getString("STRG_NO_VISIT"))).append("]]></strg_no_visit>\r\n" );
							//Vidhya 23/10/09
							//valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
							if(actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)
							{
								valueXmlString.append( "<strg_class_code><![CDATA[ ]]></strg_class_code>\r\n" );
							}
							else
							{
								valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
							}
							valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
							valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
							valueXmlString.append( "<last_meet_summ><![CDATA[" ).append("").append( "]]></last_meet_summ>\r\n" );
							valueXmlString.append( "<last_meet_date><![CDATA[" ).append("").append( "]]></last_meet_date>\r\n" );
							valueXmlString.append( "<last_prod_brf><![CDATA[" ).append("").append( "]]></last_prod_brf>\r\n" );
							valueXmlString.append( "<ref_tran_id><![CDATA[" ).append("").append( "]]></ref_tran_id>\r\n" );
							valueXmlString.append( "<conf_date><![CDATA[" ).append("").append( "]]></conf_date>\r\n" );
							valueXmlString.append( "<confirmed><![CDATA[" ).append("").append( "]]></confirmed>\r\n" );
							valueXmlString.append( "<emp_code__aprv><![CDATA[" ).append("").append( "]]></emp_code__aprv>\r\n" );
							valueXmlString.append( "<sc_code__ref><![CDATA[" ).append("").append( "]]></sc_code__ref>\r\n" );
							valueXmlString.append( "<meet_summ_mgr><![CDATA[" ).append("").append( "]]></meet_summ_mgr>\r\n" );
							valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
							valueXmlString.append( "<doc_visit_dates><![CDATA[" ).append(visitDatesInMonth).append( "]]></doc_visit_dates>\r\n" );//Gulzar on 17/06/12
							valueXmlString.append( "<addr1><![CDATA[" ).append(checkNull(rs.getString("ADDR1"))).append( "]]></addr1>\r\n" );//Gulzar on 17/06/12
							valueXmlString.append( "<addr2><![CDATA[" ).append(checkNull(rs.getString("ADDR2"))).append( "]]></addr2>\r\n" );//Gulzar on 17/06/12
							valueXmlString.append( "<addr3><![CDATA[" ).append(checkNull(rs.getString("ADDR3"))).append( "]]></addr3>\r\n" );//Gulzar on 17/06/12

							valueXmlString.append( "</Detail"+currentForm+">\r\n" );

							domID++;
						}
						System.out.println("valueXmlString.toString()=["+valueXmlString.toString()+"]");
						customers = getCustFromDom(genericUtility.parseString("<Root>"+valueXmlString.toString()+"</Root>"),currentForm ,sprsCode , "Y");
                        System.out.println(">>>>>>>>>>>customers=["+customers+"]");
					}
					TotalRecord=srNo;
					System.out.println("Edit Case >> TotalRecord=["+TotalRecord+"]");

					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}

				}

			}
			if(pstmtCheckStrgMeet!=null)
			{
				pstmtCheckStrgMeet.close();
				pstmtCheckStrgMeet = null;
			}
			if( customers != null && customers.length() == 0 )
			{
				customers = "'x'";
			}
			sql = "SELECT TRIM(PROP_VALUE) AS MEET_START_TIME FROM PROPERTIES WHERE PROP_NAME ='MEET_START_TIME'";
			System.out.println( " [WsfaDSRWizEJB]sql [" + sql + "]" );
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery( sql );
			if( rs.next() )
			{
				startTime = checkNull(rs.getString( "MEET_START_TIME" ));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			sql = "SELECT TRIM(PROP_VALUE) AS MEET_INTERVAL FROM PROPERTIES WHERE PROP_NAME ='MEET_INTERVAL'";
			System.out.println( " [WsfaDSRWizEJB]sql [" + sql + "]" );
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery( sql );
			if( rs.next() )
			{
				interval = checkNull(rs.getString( "MEET_INTERVAL" ));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			System.out.println("locality=["+locality+"]");

			if ( locality == null || locality.trim().length() == 0 )
			{
				locality = "''";
			}
			sql = " SELECT SS.SHORT_ID MPLNO,  "+
					" SC.SC_CODE CODE, UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME,   "+
					" L.DESCR LOC_DESCR, SS.CLASS_CODE CLASS_CODE,  "+
					" SS.NO_VISIT NO_VISIT, SC.LOCALITY_CODE LOCALITY_CODE,  "+
					" SC.ADDR1 AS ADDR1, SC.ADDR2 AS ADDR2, SC.ADDR3  AS ADDR3, SS.CUST_TYPE AS CUST_TYPE, " +
					" (CASE WHEN SS.CUST_TYPE = 'W' THEN 1 "+
					" WHEN SS.CUST_TYPE='B' THEN 2 "+
					" WHEN SS.CUST_TYPE='T' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ " +
					" FROM STRG_SERIES SS, STRG_CUSTOMER SC,  LOCALITY L  "+
					" WHERE SS.SC_CODE = SC.SC_CODE  "+
					" AND SC.LOCALITY_CODE = L.LOCALITY_CODE  "+
					" AND SS.SALES_PERS = ? "+
					" AND SS.SC_CODE IN "+
					" (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' "+
					" AND EFF_FROM <= ? AND VALID_UPTO >= ? "+
					" AND SALES_PERS = SS.SALES_PERS  "+
					" AND SC_CODE = SC.SC_CODE ) "+
					" AND SC.CUST_TYPE IN("+custTypeList+") " +
					" AND SC.LOCALITY_CODE IN ( "+locality+") AND SS.SC_CODE NOT IN ( "+customers+" )  "+
					" ORDER BY CUST_TYPE_SEQ, SHORT_ID ";

			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, checkNull(sprsCode));
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( trvDBDate ) );
			pstmt.setTimestamp(3, java.sql.Timestamp.valueOf( trvDBDate ) );
			//pstmt.setString(4, custType);//Gulzar on 17/06/12 //Commented by Shahu Mali 30-JAN-14

			if( actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)
			{
				String sqlLoc = "SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
				pstmt =  connectionObject.prepareStatement( sqlLoc );
				if ( temp.length > 0 )
				{
					for(int i = 0; i < temp.length; i++)
					{
						srNo++; // Added By Shahu Mali on  28/12/12
						String place = temp[i];
						System.out.println("place =["+place+"]");
						if (place != null && place.trim().length() > 0 )
						{
							place = place.substring(1, place.length()-1);
						}
						//Added By Shahu Mali on 19-FEB-13 --START
						System.out.println("Before Activity Type");

						if("NFW".equalsIgnoreCase(actType) && actType.trim().length() > 0)
						{
							System.out.println("Inside Activity Type");
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y'>\r\n" );
						}
						else
						{
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N'>\r\n" );
						}
						//Added By Shahu Mali on 19-FEB-13 --END
						valueXmlString.append("<sr_no><![CDATA[" ).append(srNo).append( "]]></sr_no>\r\n"); // Added By Shahu Mali on  28/12/12
						valueXmlString.append("<short_id><![CDATA[NA]]></short_id>\r\n");
						valueXmlString.append("<strg_code><![CDATA[-NA-]]></strg_code>\r\n");
						valueXmlString.append("<cust_name><![CDATA[-NA-]]></cust_name>\r\n");
						//Changed By Vidhya on 07/12/09[WS89NOV641 | to show locality] START
						//Changed By Pragyan [WS90NOV036] 6/14/2010
						//pstmt =  connectionObject.prepareStatement( sql );
						pstmt.setString(1, checkNull(place));
						rs = pstmt.executeQuery();
						if ( rs.next())
						{
							valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("DESCR"))).append( "]]></locality_descr>\r\n" );
						}

						//Changed By Vidhya on 07/12/09[WS89NOV641 | to show locality] END
						valueXmlString.append( "<pob_val><![CDATA[" ).append("0").append( "]]></pob_val>\r\n" );
						valueXmlString.append( "<order_booked><![CDATA[" ).append("0").append( "]]></order_booked>\r\n" );
						valueXmlString.append( "<event_time_start><![CDATA[" ).append( checkNull(startTime)).append( "]]></event_time_start>\r\n" );

						int position=startTime.indexOf(':');
						hour = startTime.substring(0,position).trim();
						minute = startTime.substring( position+1 , startTime.length() ).trim();
						int hr=Integer.parseInt(hour);
						int min=Integer.parseInt(minute);

						int intr =0;
						if( interval.length()>0 )
						{
							intr = Integer.parseInt( interval );
							min = min+intr;
							if( min>59 )
							{

								while( min > 59 )
								{
									hr=hr+1;
									min=min-60;
								}
								if( min==0 )
								{
									if( hr < 10 )
									{
										hours = "0"+hr;
									}
									else
									{
										hours = String.valueOf( hr );
									}
									valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":00")).append( "]]></event_time_end>\r\n" );
								}
								else
								{
									if( hr < 10 )
									{
										hours="0"+hr;
									}
									else
									{
										hours=String.valueOf( hr );
									}
									if(min<10)
									{
										valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":0"+min)).append( "]]></event_time_end>\r\n" );
									}
									else
									{
										valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );
									}
								}
							}
							else
							{

								if( hr < 10 )
								{
									hours="0"+hr;
								}
								else
								{
									hours=String.valueOf( hr );
								}
								valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );
							}
						}
						//valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );//Gulzar on 17/06/12


						valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<visited_with_display><![CDATA[" ).append(workWith).append( "]]></visited_with_display>\r\n" );
						if("JW".equalsIgnoreCase(actCode) && "FW".equalsIgnoreCase(actType))//Gulzar on 17/06/12
						{
							valueXmlString.append( "<work_with_other><![CDATA[" ).append(workWithOther).append( "]]></work_with_other>\r\n" );
						}
						else
						{
							valueXmlString.append( "<work_with_other><![CDATA[" ).append("").append( "]]></work_with_other>\r\n" );
						}
						valueXmlString.append( "<work_team><![CDATA[" ).append("Alone").append( "]]></work_team>\r\n" );
						//Changed By Vidhya on 08/12/09[WS89NOV642 | commented to get work team from strg_meet_team]
						//valueXmlString.append( "<work_team_disp><![CDATA[Alone]]></work_team_disp>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<locality_code><![CDATA[" ).append(place).append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<meet_summ><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
						valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append("").append( "]]></sales_pers_sp_name>\r\n" );
						valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
						valueXmlString.append( "<event_type><![CDATA[" ).append(actCode).append( "]]></event_type>\r\n" );
						//Changed By Vidhya on 08/12/09[WS89NOV642 | adding actype node to hide team when leave.]
						valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
						valueXmlString.append( "<strg_name><![CDATA[]]></strg_name>\r\n" );
						valueXmlString.append( "<strg_type><![CDATA[ ]]></strg_type>\r\n" );
						valueXmlString.append( "<strg_no_visit><![CDATA[0.0]]></strg_no_visit>\r\n" );
						valueXmlString.append( "<strg_class_code><![CDATA[ ]]></strg_class_code>\r\n" );
						valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
						valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
						valueXmlString.append( "<last_meet_summ><![CDATA[" ).append("").append( "]]></last_meet_summ>\r\n" );
						valueXmlString.append( "<last_meet_date><![CDATA[" ).append("").append( "]]></last_meet_date>\r\n" );
						valueXmlString.append( "<last_prod_brf><![CDATA[" ).append("").append( "]]></last_prod_brf>\r\n" );
						valueXmlString.append( "<ref_tran_id><![CDATA[" ).append("").append( "]]></ref_tran_id>\r\n" );
						valueXmlString.append( "<conf_date><![CDATA[" ).append("").append( "]]></conf_date>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("").append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<emp_code__aprv><![CDATA[" ).append("").append( "]]></emp_code__aprv>\r\n" );
						valueXmlString.append( "<sc_code__ref><![CDATA[" ).append("").append( "]]></sc_code__ref>\r\n" );
						valueXmlString.append( "<meet_summ_mgr><![CDATA[" ).append("").append( "]]></meet_summ_mgr>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
						valueXmlString.append( "<doc_visit_dates><![CDATA[" ).append("").append( "]]></doc_visit_dates>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr1><![CDATA[]]></addr1>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr2><![CDATA[]]></addr2>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr3><![CDATA[]]></addr3>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append("").append( "]]></order_of_visit>\r\n" );
						valueXmlString.append( "</Detail"+currentForm+">\r\n" );
						domID++;
					}
					TotalRecord=srNo;
					System.out.println("TotalRecord=["+TotalRecord+"]");
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			else
			{
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					srNo++; //Added By Shahu on 28/12/12
					strgCode = rs.getString("CODE");
					custType = rs.getString("CUST_TYPE");
					visitDatesInMonth = getDocVistDatesInMonth(strgCode,sprsCode,eventDate,connectionObject);
					valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N'>\r\n" );
					valueXmlString.append("<sr_no><![CDATA[").append(srNo).append("]]></sr_no>\r\n");// Added By Shahu Mali on  28/12/12.
					valueXmlString.append("<short_id><![CDATA[").append(checkNull(rs.getString("MPLNO"))).append("]]></short_id>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(checkNull(rs.getString("CODE"))).append("]]></strg_code>\r\n");
					valueXmlString.append("<cust_name><![CDATA[").append(checkNull(rs.getString("SC_NAME"))).append("]]></cust_name>\r\n");
					//Changed By Vidhya on 07/12/09[WS89NOV641 | to show locality]
					valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR"))).append( "]]></locality_descr>\r\n" );
					valueXmlString.append("<pob_val><![CDATA[").append("0").append("]]></pob_val>\r\n");
					valueXmlString.append( "<order_booked><![CDATA[" ).append("0").append( "]]></order_booked>\r\n" );
					valueXmlString.append( "<event_time_start><![CDATA[" ).append( checkNull(startTime)).append( "]]></event_time_start>\r\n" );
					int position=startTime.indexOf(':');
					hour = startTime.substring(0,position).trim();
					minute = startTime.substring( position+1 , startTime.length() ).trim();
					int hr=Integer.parseInt(hour);
					int min=Integer.parseInt(minute);
					int intr =0;
					if( interval.length()>0 )
					{
						intr = Integer.parseInt( interval );
						min = min+intr;
						if( min>59 )
						{

							while( min > 59 )
							{
								hr=hr+1;
								min=min-60;
							}
							if( min==0 )
							{
								if( hr < 10 )
								{
									hours = "0"+hr;
								}
								else
								{
									hours = String.valueOf( hr );
								}
								valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":00")).append( "]]></event_time_end>\r\n" );
							}
							else
							{
								if( hr < 10 )
								{
									hours="0"+hr;
								}
								else
								{
									hours=String.valueOf( hr );
								}
								if(min<10)
								{
									valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":0"+min)).append( "]]></event_time_end>\r\n" );
								}
								else
								{
									valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );
								}
							}
						}
						else
						{
							if( hr < 10 )
							{
								hours="0"+hr;
							}
							else
							{
								hours=String.valueOf( hr );
							}
							valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );
						}

						valueXmlString.append( "<oth_participant><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<visited_with_display><![CDATA[" ).append(workWith).append( "]]></visited_with_display>\r\n" );
						if("JW".equalsIgnoreCase(actCode) && "FW".equalsIgnoreCase(actType))//Gulzar on 17/06/12
						{
							valueXmlString.append( "<work_with_other><![CDATA[" ).append(workWithOther).append( "]]></work_with_other>\r\n" );
						}
						else
						{
							valueXmlString.append( "<work_with_other><![CDATA[" ).append("").append( "]]></work_with_other>\r\n" );
						}
						valueXmlString.append( "<work_team><![CDATA[" ).append("Alone").append( "]]></work_team>\r\n" );
						//Changed By Vidhya on 08/12/09[WS89NOV642 |Commenting work team display]
						//valueXmlString.append( "<work_team_disp><![CDATA[Alone]]></work_team_disp>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<locality_code><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<meet_summ><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
						valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append("").append( "]]></sales_pers_sp_name>\r\n" );
						valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
						valueXmlString.append( "<event_type><![CDATA[" ).append(actCode).append( "]]></event_type>\r\n" );
						//Changed By Vidhya on 08/12/09[WS89NOV642 | adding actype node to hide team when leave.]
						valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
						valueXmlString.append( "<strg_name><![CDATA[]]></strg_name>\r\n" );
						valueXmlString.append( "<strg_type><![CDATA["+custType+"]]></strg_type>\r\n" );
						valueXmlString.append( "<strg_no_visit><![CDATA[" ).append(checkNull(rs.getString("NO_VISIT"))).append( "]]></strg_no_visit>\r\n" );
						valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
						valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
						valueXmlString.append( "<last_meet_summ><![CDATA[" ).append("").append( "]]></last_meet_summ>\r\n" );
						valueXmlString.append( "<last_meet_date><![CDATA[" ).append("").append( "]]></last_meet_date>\r\n" );
						valueXmlString.append( "<last_prod_brf><![CDATA[" ).append("").append( "]]></last_prod_brf>\r\n" );
						valueXmlString.append( "<ref_tran_id><![CDATA[" ).append("").append( "]]></ref_tran_id>\r\n" );
						valueXmlString.append( "<conf_date><![CDATA[" ).append("").append( "]]></conf_date>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("").append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<emp_code__aprv><![CDATA[" ).append("").append( "]]></emp_code__aprv>\r\n" );
						valueXmlString.append( "<sc_code__ref><![CDATA[" ).append("").append( "]]></sc_code__ref>\r\n" );
						valueXmlString.append( "<meet_summ_mgr><![CDATA[" ).append("").append( "]]></meet_summ_mgr>\r\n" );
						valueXmlString.append( "<doc_visit_dates><![CDATA[" ).append(visitDatesInMonth).append( "]]></doc_visit_dates>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr1><![CDATA[" ).append(checkNull(rs.getString("ADDR1"))).append( "]]></addr1>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr2><![CDATA[" ).append(checkNull(rs.getString("ADDR2"))).append( "]]></addr2>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr3><![CDATA[" ).append(checkNull(rs.getString("ADDR3"))).append( "]]></addr3>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append("").append( "]]></order_of_visit>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					}
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );

					domID++;
				}//end of while
				TotalRecord=srNo;
				System.out.println("TotalRecord=["+TotalRecord+"]");
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}//end else activity type

			domID = 1;

			//For Wholeseller selection
			StringBuffer customerBuf = new StringBuffer("<CustomerSelected>");
			NodeList wsellerVisitNodeList = dom2.getElementsByTagName("wseller_visit");
			int noOfWsellerSelected = wsellerVisitNodeList.getLength();

			for( int wseller = 0; wseller < noOfWsellerSelected; wseller++ )
			{
				if ( wsellerVisitNodeList.item( wseller ).getFirstChild() != null && wsellerVisitNodeList.item(wseller ).getFirstChild().getNodeValue() != null )
				{
					String wsellerVisit = wsellerVisitNodeList.item( wseller ).getFirstChild().getNodeValue();
					if("Y".equalsIgnoreCase(wsellerVisit))
					{
						customerBuf.append( "<wseller_visit><![CDATA[Y]]></wseller_visit>\r\n" );
						break;
					}
				}
			}
			//For distributer selection
			NodeList distBrVisitNodeList = dom2.getElementsByTagName("distbr_visit");
			int noOfDistBrSelected = distBrVisitNodeList.getLength();

			for( int distBr = 0; distBr < noOfDistBrSelected; distBr++ )
			{
				if ( distBrVisitNodeList.item( distBr ).getFirstChild() != null && distBrVisitNodeList.item( distBr ).getFirstChild().getNodeValue() != null )
				{
					String distBrVisit = distBrVisitNodeList.item( distBr ).getFirstChild().getNodeValue();
					if("Y".equalsIgnoreCase(distBrVisit))
					{
						customerBuf.append( "<distbr_visit><![CDATA[Y]]></distbr_visit>\r\n" );
						break;
					}
				}
			}
			//For Modern Trader selection
			NodeList mTraderVisitNodeList = dom2.getElementsByTagName("mtrader_visit");
			int noOfmTraderSelected = mTraderVisitNodeList.getLength();

			for( int mTrader = 0; mTrader < noOfmTraderSelected; mTrader++ )
			{
				if ( mTraderVisitNodeList.item( mTrader ).getFirstChild() != null && mTraderVisitNodeList.item( mTrader ).getFirstChild().getNodeValue() != null )
				{
					String mTraderVisit = mTraderVisitNodeList.item( mTrader ).getFirstChild().getNodeValue();
					if("Y".equalsIgnoreCase(mTraderVisit))
					{
						customerBuf.append( "<mtrader_visit><![CDATA[Y]]></mtrader_visit>\r\n" );
						break;
					}
				}
			}

			customerBuf.append("</CustomerSelected>");
			valueXmlString.append(customerBuf);
			//End Gulzar on 11/09/12
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRWizardEJB :getCustomerDetail():" + e.getMessage() + ":" );
			e.printStackTrace();
			valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRWizardEJB :getCustomerDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}
	//Changed By Vidhya on 15/10/09[WI89BAS033 | changing signature]
	//public String getItemDetail( Document dom, String currentForm, String userId, String sprsCode, String custCode, String actCode) throws ITMException
	public String getItemDetail( Document dom, Document dom2, String currentForm, String userId, String sprsCode, String custCode, String actCode) throws ITMException
	{
		ResultSet rs = null;
		Connection connectionObject = null;
		PreparedStatement pstmt = null;

		String sql = "";
		String sql1 = "";
		String currDate = "";
		String chgTerm ="";
		String preFormDet ="";
		String trvDate = "";
		String preFormItems ="";
		String salesProdItems ="";
		String items ="";
		boolean flag = false;
		StringBuffer valueXmlString = new StringBuffer();
		String [] temp;

		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );
			int custForm = Integer.parseInt(currentForm) - 1;
			//to append previous values of current form from current dom on previous action START
			flag = preDomExists( dom, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );

			sql = "SELECT DISTINCT SPG.SALES_PROD_GRP CODE, SPG.DESCR DESCRIPTION FROM SALES_PROD_GRP SPG, ITEM M  WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";

			sql1 = "SELECT M.ITEM_CODE CODE, M.DESCR DESCRIPTION FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";

			String actType = getActivityType( actCode, connectionObject );
			if( actType.indexOf("NFW") == -1 && actType.indexOf("LEAVE") == -1 )
			{
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, checkNull(sprsCode));
				rs = pstmt.executeQuery();
				while(rs.next())
				{

					valueXmlString.append( "<Detail"+currentForm+" domID='" + domID + "' selected = 'N'>\r\n" );
					valueXmlString.append("<item_descr><![CDATA[").append(checkNull(rs.getString("DESCRIPTION"))).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( "0" ).append( "]]></quantity>\r\n" );					valueXmlString.append("<item_code><![CDATA[").append("").append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append(checkNull(rs.getString("CODE"))).append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(checkNull(custCode)).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed><![CDATA[" ).append("").append( "]]></briefed>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append("P1").append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );
					domID++;

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				pstmt =  connectionObject.prepareStatement( sql1 );
				pstmt.setString(1, checkNull(sprsCode));
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					valueXmlString.append( "<Detail"+currentForm+" domID='" + domID + "' selected = 'N'>\r\n" );
					valueXmlString.append("<item_descr><![CDATA[").append(checkNull(rs.getString("DESCRIPTION"))).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( "0" ).append( "]]></quantity>\r\n" );					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("CODE"))).append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append("").append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(checkNull(custCode)).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed><![CDATA[" ).append("").append( "]]></briefed>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append("Promo Material").append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );
					domID++;
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				domID = 1;
			}
			if(flag)
			{
				//Changed By Vidhya on 15/10/09[WI89BAS033 | changing signature]
				//preFormDet = getPrevFormValues( dom, currentForm, domID );
				String customers = getCustFromDom( dom2, Integer.toString( custForm ), sprsCode );
				temp = customers.split(",");
				preFormDet = getPrevFormValues( dom, currentForm, new ArrayList<String>( Arrays.asList( temp ) ), "strg_code" );
				if( preFormDet != null || !"null".equalsIgnoreCase(preFormDet))
				{
					valueXmlString.append( preFormDet );
					domID = domID + 1;
				}

			}
			else
			{
				trvDate =  getSelectedRowValue( dom2, "1", "event_date", 0);
				if ( trvDate != null )
				{
					trvDate = genericUtility.getValidDateString( trvDate , getApplDateFormat() , "dd-MMM-yyyy");
				}

				String dcrID = "";
				String smiQuery = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE EVENT_DATE =? AND SALES_PERS = ?";
				pstmt = connectionObject.prepareStatement( smiQuery );
				//pstmt.setString(1, trvDate);//Shahu - 27/10/12
				pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(trvDate));//Shahu - 27/10/12
				pstmt.setString(2, sprsCode);
				rs = pstmt.executeQuery();
				while( rs.next() )
				{
					dcrID = checkNull(rs.getString("DCR_ID"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}


				//smiQuery = "SELECT ITEM.DESCR DESCR, LINE_NO, ITEM_POB, STRG_MEET_ITEMS.ITEM_CODE, STRG_MEET_ITEMS.SALES_PROD_GRP, STRG_CODE, ITEM.ITEM_TYPE, ITEM.ITEM_USAGE, STRG_MEET_ITEMS.BRIEFED, STRG_MEET_ITEMS.QUANTITY, STRG_MEET_ITEMS.BRIEFED_DESCR, SALES_PROD_GRP.DESCR AS SPG_DESCR FROM STRG_MEET_ITEMS, ITEM ITEM ,SALES_PROD_GRP SALES_PROD_GRP  WHERE (STRG_MEET_ITEMS.ITEM_CODE = ITEM.ITEM_CODE (+)) AND (STRG_MEET_ITEMS.SALES_PROD_GRP = SALES_PROD_GRP.SALES_PROD_GRP (+)) AND STRG_MEET_ITEMS.DCR_ID= '"+dcrID+"' ";
				smiQuery = "SELECT ITEM.DESCR DESCR, LINE_NO, ITEM_POB, STRG_MEET_ITEMS.ITEM_CODE, STRG_MEET_ITEMS.SALES_PROD_GRP, STRG_CODE, ITEM.ITEM_TYPE, ITEM.ITEM_USAGE, STRG_MEET_ITEMS.BRIEFED, STRG_MEET_ITEMS.QUANTITY, STRG_MEET_ITEMS.BRIEFED_DESCR, SALES_PROD_GRP.DESCR AS SPG_DESCR " +
						"   FROM STRG_MEET_ITEMS LEFT OUTER JOIN ITEM ITEM ON (STRG_MEET_ITEMS.ITEM_CODE = ITEM.ITEM_CODE ) LEFT OUTER JOIN SALES_PROD_GRP SALES_PROD_GRP ON (STRG_MEET_ITEMS.SALES_PROD_GRP = SALES_PROD_GRP.SALES_PROD_GRP ) " +
						"   WHERE STRG_MEET_ITEMS.DCR_ID= '"+dcrID+"' ";

				pstmt = connectionObject.prepareStatement(smiQuery);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String item = checkNull(rs.getString("DESCR"));
					String sprogrp = checkNull(rs.getString("SPG_DESCR"));


					valueXmlString.append( "<Detail5 domID='" + domID + "' selected = 'Y'>\r\n" );
					if( !item.equals("") )
					{
						valueXmlString.append("<item_descr>").append( item ).append("</item_descr>\n");

					}
					else if ( ! sprogrp.equals("") )
					{
						valueXmlString.append("<item_descr>").append(sprogrp).append("</item_descr>\n");
					}

					//valueXmlString.append("<quantity>").append(checkNull(rs.getString("QUANTITY"))).append("</quantity>\n");//Gulzar
					valueXmlString.append("<quantity>").append(rs.getInt("QUANTITY")).append("</quantity>\n");//Gulzar
					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
					valueXmlString.append("<sales_prod_grp><![CDATA[").append(checkNull(rs.getString("SALES_PROD_GRP"))).append("]]></sales_prod_grp>\n");
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[").append( checkNull(rs.getString("LINE_NO")) ).append("]]></line_no>\r\n");

					valueXmlString.append( "<item_type><![CDATA[" ).append( checkNull(rs.getString("ITEM_TYPE")) ).append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed><![CDATA[" ).append( checkNull(rs.getString("BRIEFED"))).append( "]]></briefed>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append( checkNull(rs.getString("ITEM_POB")) ).append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append( checkNull(rs.getString("BRIEFED_DESCR")) ).append( "]]></briefed_descr>\r\n" );

					valueXmlString.append( "</Detail5>\r\n" );
					domID++;

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}


		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}

	//New overloaded method is added to select the pitch detail - Gulzar on 18/06/12
	public String getItemDetailMod( Document dom, Document dom2, String currentForm, String userId, String sprsCode, String custCode, String actCode) throws ITMException
	{
		ResultSet rs = null;
		Connection connectionObject = null;
		PreparedStatement pstmt = null;

		boolean flag = false;
		StringBuffer valueXmlString = new StringBuffer();

		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );
			int custForm = Integer.parseInt(currentForm) - 1;
			//to append previous values of current form from current dom on previous action START
			flag = preDomExists( dom, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );

			String actType = getActivityType( actCode, connectionObject );
			if( actType.indexOf("NFW") == -1 && actType.indexOf("LEAVE") == -1 )
			{
				String sql = "SELECT DISTINCT SPG.SALES_PROD_GRP CODE, SPG.DESCR DESCRIPTION FROM SALES_PROD_GRP SPG, ITEM M  WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";

				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, checkNull(sprsCode));
				rs = pstmt.executeQuery();
				while(rs.next())
				{

					valueXmlString.append( "<Detail"+currentForm+" domID='" + domID + "' selected = 'N'>\r\n" );
					valueXmlString.append("<item_descr><![CDATA[").append(checkNull(rs.getString("DESCRIPTION"))).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( "0" ).append( "]]></quantity>\r\n" );					valueXmlString.append("<item_code><![CDATA[").append("").append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append(checkNull(rs.getString("CODE"))).append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(checkNull(custCode)).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed><![CDATA[" ).append("").append( "]]></briefed>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append("P1").append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );
					domID++;

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				String sql1 = "SELECT M.ITEM_CODE CODE, M.DESCR DESCRIPTION FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";
				pstmt =  connectionObject.prepareStatement( sql1 );
				pstmt.setString(1, checkNull(sprsCode));
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					valueXmlString.append( "<Detail"+currentForm+" domID='" + domID + "' selected = 'N'>\r\n" );
					valueXmlString.append("<item_descr><![CDATA[").append(checkNull(rs.getString("DESCRIPTION"))).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( "0" ).append( "]]></quantity>\r\n" );					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("CODE"))).append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append("").append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(checkNull(custCode)).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed><![CDATA[" ).append("").append( "]]></briefed>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append("Promo Material").append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );
					domID++;
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				domID = 1;
			}
			if(flag)
			{
				//Changed By Vidhya on 15/10/09[WI89BAS033 | changing signature]
				//preFormDet = getPrevFormValues( dom, currentForm, domID );
				String customers = getCustFromDom( dom2, Integer.toString( custForm ), sprsCode );
				String [] temp = customers.split(",");
				String preFormDet = getPrevFormValues( dom, currentForm, new ArrayList<String>( Arrays.asList( temp ) ), "strg_code" );
				if( preFormDet != null || !"null".equalsIgnoreCase(preFormDet))
				{
					valueXmlString.append( preFormDet );
					domID = domID + 1;
				}

			}
			else
			{
				String trvDate  =  getSelectedRowValue( dom2, "1", "event_date", 0);
				if ( trvDate != null )
				{
					trvDate = genericUtility.getValidDateString( trvDate , getApplDateFormat() , "dd-MMM-yyyy");
				}

				String dcrID = "";
				String smiQuery = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE EVENT_DATE =? AND SALES_PERS = ?";
				pstmt = connectionObject.prepareStatement( smiQuery );
				pstmt.setString(1, trvDate);
				pstmt.setString(2, sprsCode);
				rs = pstmt.executeQuery();
				while( rs.next() )
				{
					dcrID = checkNull(rs.getString("DCR_ID"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				//smiQuery = "SELECT ITEM.DESCR DESCR, LINE_NO, ITEM_POB, STRG_MEET_ITEMS.ITEM_CODE, STRG_MEET_ITEMS.SALES_PROD_GRP, STRG_CODE, ITEM.ITEM_TYPE, ITEM.ITEM_USAGE, STRG_MEET_ITEMS.BRIEFED, STRG_MEET_ITEMS.QUANTITY, STRG_MEET_ITEMS.BRIEFED_DESCR, SALES_PROD_GRP.DESCR AS SPG_DESCR FROM STRG_MEET_ITEMS, ITEM ITEM ,SALES_PROD_GRP SALES_PROD_GRP  WHERE (STRG_MEET_ITEMS.ITEM_CODE = ITEM.ITEM_CODE (+)) AND (STRG_MEET_ITEMS.SALES_PROD_GRP = SALES_PROD_GRP.SALES_PROD_GRP (+)) AND STRG_MEET_ITEMS.DCR_ID= '"+dcrID+"' ";
				smiQuery = "SELECT ITEM.DESCR DESCR, LINE_NO, ITEM_POB, STRG_MEET_ITEMS.ITEM_CODE, STRG_MEET_ITEMS.SALES_PROD_GRP, STRG_CODE, ITEM.ITEM_TYPE, ITEM.ITEM_USAGE, STRG_MEET_ITEMS.BRIEFED, STRG_MEET_ITEMS.QUANTITY, STRG_MEET_ITEMS.BRIEFED_DESCR, SALES_PROD_GRP.DESCR AS SPG_DESCR " +
						"   FROM STRG_MEET_ITEMS LEFT OUTER JOIN ITEM ITEM  ON (STRG_MEET_ITEMS.ITEM_CODE = ITEM.ITEM_CODE ) " +
						"   LEFT OUTER JOIN SALES_PROD_GRP SALES_PROD_GRP ON (STRG_MEET_ITEMS.SALES_PROD_GRP = SALES_PROD_GRP.SALES_PROD_GRP) " +
						"   WHERE STRG_MEET_ITEMS.DCR_ID= '"+dcrID+"' ";

				pstmt = connectionObject.prepareStatement(smiQuery);
				rs = pstmt.executeQuery();

				while(rs.next())
				{
					String item = checkNull(rs.getString("DESCR"));
					String sprogrp = checkNull(rs.getString("SPG_DESCR"));



					valueXmlString.append( "<Detail5 domID='" + domID + "' selected = 'Y'>\r\n" );
					if( !item.equals("") )
					{
						valueXmlString.append("<item_descr>").append( item ).append("</item_descr>\n");

					}
					else if ( ! sprogrp.equals("") )
					{
						valueXmlString.append("<item_descr>").append(sprogrp).append("</item_descr>\n");
					}

					//valueXmlString.append("<quantity>").append(checkNull(rs.getString("QUANTITY"))).append("</quantity>\n");//Gulzar
					valueXmlString.append("<quantity>").append(rs.getInt("QUANTITY")).append("</quantity>\n");//Gulzar
					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
					valueXmlString.append("<sales_prod_grp><![CDATA[").append(checkNull(rs.getString("SALES_PROD_GRP"))).append("]]></sales_prod_grp>\n");
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[").append( checkNull(rs.getString("LINE_NO")) ).append("]]></line_no>\r\n");

					valueXmlString.append( "<item_type><![CDATA[" ).append( checkNull(rs.getString("ITEM_TYPE")) ).append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed><![CDATA[" ).append( checkNull(rs.getString("BRIEFED"))).append( "]]></briefed>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append( checkNull(rs.getString("ITEM_POB")) ).append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append( checkNull(rs.getString("BRIEFED_DESCR")) ).append( "]]></briefed_descr>\r\n" );

					valueXmlString.append( "</Detail5>\r\n" );
					domID++;

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}


		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}
	//Getting Default Values for forms End*********

	//Utility Functions Start****************
	//*****Public Methods ***** Start
	//to get StanCodeFrom of the salesPerson's last visited place from DB
	/*Commented By Shahu Mali on 12-FEB-14.START
	public String getStanCodeFrom( Connection con, String userId, String currDate ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			//Commented and changes by gulzar to get the last sation based on their max ordr of visit
			String stanCodeSql = "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
								" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
								" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?) ) "+
								" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
								" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?) ";
			//pstmt =  con.prepareStatement( "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC WHERE TRAN_ID = ( SELECT MAX( TRAN_ID ) FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE <= ? ) AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE" );
			pstmt =  con.prepareStatement(stanCodeSql);
			pstmt.setString(1, userId );
			//pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(2, userId );
			pstmt.setString(3, userId );
			pstmt.setString(4, userId );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				localityCodeFrom = rs.getString(1);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaDSRWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}

		return localityCodeFrom;
	}
	Commented By Shahu Mali on 12-FEB-14.END
	*/

	//to check if input is null or "null"
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	//to check if current dom contains values (for previous action)
	public boolean preDomExists(Document dom, String currentFormNo) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node childNode = null;
		boolean selected = false;

		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			if ( parentList.item(0) != null )
			{
				childList = parentList.item(0).getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						System.out.println("Column found!!!" + childNode.getNodeName());
						selected = true;
						break;
					}
				}
			}


		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaDSRWizardEJB :preDomExists :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("preDomExists =["+selected+"] and currentFormNo =["+currentFormNo+"]");

		return selected;
	}

	//to get previous dom values and set selected attribute to 'y' (for previous action)
	public String getPrevFormValues( Document dom, String currentFormNo, ArrayList temp, String colName) throws ITMException
	{
		GenericUtility genericUtility = GenericUtility.getInstance();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentlistlength["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								//elementAttr.setAttribute( "domID" , Integer.toString(domID) );
								elementAttr.setAttribute( "selected" , "Y" );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}

					}
				}

			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			System.out.println("getPrevFormValues >> returnPrevStr===["+returnPrevStr+"]");
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaDSRWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	public String getLocFromDom(Document dom, String currentForm, String sprsCode) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer localityBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("Driver");

			sql = "SELECT * FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?";
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
			pstmt = connectionObject.prepareStatement(sql);

			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					if( childNode.getNodeName().equalsIgnoreCase("locality_code"))
					{

						if ( temp.contains(columnValue))
						{
							continue;
						}

						pstmt.setString(1, sprsCode);
						pstmt.setString(2, columnValue);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(localityBuff.length() == 0)
							{
								localityBuff.append("'").append(columnValue.toUpperCase()).append("'");
							}
							else
							{
								localityBuff.append(",'").append(columnValue.toUpperCase()).append("'");
							}
						}
						temp.add(columnValue);
					}
				}
			}

			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return localityBuff.toString();

	}

	//Commented and Below changes Done by Shahu Mali on 03-FEB-14
	public String getLocFromDom(Document dom, String currentForm, String sprsCode, String custType) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer localityBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		String drVisit = "";//Gulzar  on 6/10/2012
		String chemVisit = "";//Gulzar on 17/06/12
		String localityCode = "";//Gulzar  on 6/10/2012
		//Added by Shahu Mali on 28-JAN-14.START
		String wsellerVisit="";
		String mtraderVisit="";
		String distbrVisit="";
		//Added by Shahu Mali on 28-JAN-14.END
		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("Driver");

			GenericUtility genericUtility = GenericUtility.getInstance();

			System.out.println("dom2:::"+genericUtility.serializeDom(dom));

			String activityCode = genericUtility.getColumnValue("activity_code", dom, "1");
			String activityType = checkNull(getActivityType(activityCode, connectionObject));
			if (!"FW".equalsIgnoreCase(activityType))
			{
				String localityDetail = getLocFromDom(dom, currentForm, sprsCode);
				System.out.println("localityDetail :::"+localityDetail);
				return localityDetail;
			}

			sql = "SELECT * FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?";
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
			pstmt = connectionObject.prepareStatement(sql);
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				//drVisit = "";
				//Added by Shahu Mali on 28-JAN-14.START
				wsellerVisit="";
				distbrVisit="";
				mtraderVisit="";
				localityCode = "";
				//Added by Shahu Mali on 28-JAN-14.END
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					if( childNode.getNodeName().equalsIgnoreCase("locality_code"))
					{
						if ( temp.contains(columnValue))
						{
							continue;
						}
						localityCode = columnValue;

					}
					//Added by Shahu Mali on 28-JAN-14.START
					else if( childNode.getNodeName().equalsIgnoreCase("wseller_visit"))
					{
						wsellerVisit = columnValue;
					}
					else if( childNode.getNodeName().equalsIgnoreCase("distbr_visit"))
					{
						distbrVisit = columnValue;
					}
					else if( childNode.getNodeName().equalsIgnoreCase("mtrader_visit"))
					{
						mtraderVisit = columnValue;
					}
					//Added by Shahu Mali on 28-JAN-14.END
				}
				System.out.println("\n wsellerVisit=["+wsellerVisit+"] \n distbrVisit=["+distbrVisit+"] \n mtraderVisit=["+mtraderVisit+"]");
				System.out.println("localityCode=["+localityCode+"]");
				if ( "W".equalsIgnoreCase(custType) && wsellerVisit != null && wsellerVisit.trim().length() > 0 && "Y".equalsIgnoreCase(wsellerVisit.trim()) && localityCode != null && localityCode.trim().length() > 0 )
				{
					pstmt.setString(1, sprsCode);
					pstmt.setString(2, localityCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(localityBuff.length() == 0)
						{
							localityBuff.append("'").append(localityCode.toUpperCase()).append("',");
						}
						else
						{
							localityBuff.append("'").append(localityCode.toUpperCase()).append("',");
						}
					}
					pstmt.clearParameters();
					temp.add(localityCode);
				}
				else if ( "B".equalsIgnoreCase(custType) && distbrVisit != null && distbrVisit.trim().length() > 0 && "Y".equalsIgnoreCase(distbrVisit.trim()) && localityCode != null && localityCode.trim().length() > 0 )
				{
					pstmt.setString(1, sprsCode);
					pstmt.setString(2, localityCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(localityBuff.length() == 0)
						{
							localityBuff.append("'").append(localityCode.toUpperCase()).append("',");
						}
						else
						{
							localityBuff.append("'").append(localityCode.toUpperCase()).append("',");
						}
					}
					pstmt.clearParameters();
					temp.add(localityCode);
				}
				else if ( "T".equalsIgnoreCase(custType) && mtraderVisit != null && mtraderVisit.trim().length() > 0 && "Y".equalsIgnoreCase(mtraderVisit.trim()) && localityCode != null && localityCode.trim().length() > 0 )
				{
					pstmt.setString(1, sprsCode);
					pstmt.setString(2, localityCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(localityBuff.length() == 0)
						{
							localityBuff.append("'").append(localityCode.toUpperCase()).append("',");
						}
						else
						{
							localityBuff.append("'").append(localityCode.toUpperCase()).append("',");
						}
					}
					pstmt.clearParameters();
					temp.add(localityCode);
				}
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("localityBuff =["+localityBuff.toString()+"]");

		return localityBuff.toString();

	}
	//get customers selected from given dom in a String Buffer
	public String getCustFromDom( Document dom, String currentForm, String sprsCode ) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
		//Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer custBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("Driver");
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] Start
			sql = "SELECT * FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SS.SALES_PERS = ? AND LOCALITY_CODE = ? AND SS.SC_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] end
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String locality = getSelectedRowValue( dom, currentForm, "locality_code", prntCtr);

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("strg_code") )
					{
						columnValue = childNode.getFirstChild().getNodeValue();

						if( temp.contains(columnValue) )
						{
							continue;
						}
						//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]Start
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, locality);
						pstmt.setString(3, columnValue);
						rs = pstmt.executeQuery();
						//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
						if( rs.next() )
						{
							if( custBuff.length() == 0)
							{
								custBuff.append("'").append( columnValue ).append("'");
							}
							else
							{
								custBuff.append(",'").append( columnValue ).append("'");
							}
						}
						//added by rakesh kumar 14/12/12.
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						temp.add( columnValue );

					}
				}
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End

				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return custBuff.toString();
	}

	//Vidhya on 23/10/09 overloaded method to get previoulsy customers selected from given dom in a String Buffer
	public String getCustFromDom( Document dom, String currentForm, String sprsCode, String attrValue ) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
		//Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer custBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("Driver");
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			//Changed By Pragyan 2/9/2011 to Solve the bug
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] Start
			//sql = "SELECT * FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SS.SALES_PERS = ? AND LOCALITY_CODE = ? AND SS.SC_CODE = ?";
			sql = "SELECT * FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SS.SALES_PERS = ? AND SC.LOCALITY_CODE = ? AND SS.SC_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String locality = getSelectedRowValue( dom, currentForm, "locality_code", prntCtr);

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("strg_code") )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
						if( parentNode.getAttributes().getNamedItem("selected").getNodeValue().equalsIgnoreCase(attrValue))
						{
							if( temp.contains(columnValue) )
							{

								continue;
							}
							//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] Start
							pstmt.setString(1, sprsCode);
							pstmt.setString(2, locality);
							pstmt.setString(3, columnValue);
							rs = pstmt.executeQuery();
							//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
							if( rs.next() )
							{
								if( custBuff.length() == 0)
								{
									custBuff.append("'").append( columnValue ).append("'");
								}
								else
								{
									custBuff.append(",'").append( columnValue ).append("'");
								}
							}
							//added by rakesh kumar 14/12/12.
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							temp.add( columnValue );
						}
					}
				}
			}

			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("custBuff=["+custBuff.toString()+"]");
		return custBuff.toString();
	}


	public String getItemsFromDom( Document dom, String currentForm, String sprsCode, String attrValue ) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		Statement stmt = null;
		ResultSet rs = null ;
		StringBuffer itemBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("Driver");
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("sales_prod_grp") )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if( parentNode.getAttributes().getNamedItem("selected").getNodeValue().equalsIgnoreCase(attrValue))
						{
							if( temp.contains(columnValue.trim()+"-SPG") )
							{
								continue;
							}
							sql = "SELECT DISTINCT SPG.SALES_PROD_GRP CODE FROM SALES_PROD_GRP SPG, ITEM M  WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = '"+sprsCode+"' ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + ) AND SPG.SALES_PROD_GRP='"+columnValue+"'";
							stmt = connectionObject.createStatement();
							rs = stmt.executeQuery(sql);
							if( rs.next() )
							{
								if( itemBuff.length() == 0)
								{
									itemBuff.append("'").append( columnValue ).append("'");
								}
								else
								{
									itemBuff.append(",'").append( columnValue ).append("'");
								}
							}
							//added by rakesh kumar 13/12/12
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(stmt!=null)
							{
								stmt.close();
								stmt = null;
							}
							//ended by rakesh kumar 13/12/12
							temp.add( columnValue+"-SPG");
						}
					}
					else if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("item_code"))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if( parentNode.getAttributes().getNamedItem("selected").getNodeValue().equalsIgnoreCase(attrValue))
						{
							if( temp.contains(columnValue) )
							{

								continue;
							}
							sql = "SELECT M.ITEM_CODE CODE FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS =  '"+sprsCode+"' ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + ) AND M.ITEM_CODE= '"+columnValue+"'";
							stmt = connectionObject.createStatement();
							rs = stmt.executeQuery(sql);
							if( rs.next() )
							{
								if( itemBuff.length() == 0)
								{
									itemBuff.append("'").append( columnValue ).append("'");
								}
								else
								{
									itemBuff.append(",'").append( columnValue ).append("'");
								}
							}
							//added by rakesh kumar 13/12/12
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(stmt!=null)
							{
								stmt.close();
								stmt = null;
							}
							//ended by rakesh kumar 13/12/12
							temp.add( columnValue );
						}

					}

				}
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}

				if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return itemBuff.toString();
	}

	//to get current dom
	public String getCurrentDom(String objContext, Document dom)
	{
		String returnStr = "";
		Document returnDom = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			returnDom = genericUtility.parseString("<Root/>");
			NodeList nodeList =  dom.getElementsByTagName("Detail" + objContext);
			for(int i=0; i< nodeList.getLength(); i++)
			{
				Node currentDom = nodeList.item(i);
				if(currentDom != null)
				{
					Node importedNode = returnDom.importNode( currentDom, true);
					returnDom.getDocumentElement().appendChild(importedNode);
				}
			}

			returnStr = genericUtility.serializeDom(returnDom);
			if(returnStr.indexOf("Detail") != -1)
			{
				returnStr = returnStr.substring(returnStr.indexOf(">") + 1, returnStr.lastIndexOf("</"));
			}
			returnStr = returnStr.indexOf("Detail") != -1 ? returnStr : "";

		}
		catch (Exception e){
			e.printStackTrace();
		}
		return returnStr;
	}

	//Changed By Vidhya on  24/10/09[new method to generate errorString]
	public String generateErrorString(String errorString)
	{
		//Changed By Sumit Sarkar on 12/11/11 [SY1GNOV001] update return xml <Errors> in place of <Error>
		//return ("<Error><error id = \"xxxx\" type=\"X\">" + errorString.substring(errorString.indexOf("<message>") , errorString.indexOf("</description>") + "</description>".length()) + "<redirect>1</redirect></error></Errors>");
		return ("<Errors><error id = \"xxxx\" type=\"X\">" + errorString.substring(errorString.indexOf("<message>") , errorString.indexOf("</description>") + "</description>".length()) + "<redirect>1</redirect></error></Errors>");

	}
	//*****Public Methods ***** End

	//****Private Methods ***** Start
	//to validate holiday for saleperson
	private String valHoliday(String eventdate, String sprs, String userId, ITMDBAccessLocal itmDBAccessLocal, Connection connectionObject) throws Exception
	{
		GenericUtility genericUtility = GenericUtility.getInstance();

		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		//Connection connectionObject = null;
		PreparedStatement pstmtPeriod = null;
		ResultSet rsPeriod = null ;

		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );
			//Checking Hodiday
			//eventdate = genericUtility.getValidDateString( eventdate , getApplDateFormat() , "dd-MMM-yyyy");//Shahu - 27/10/12
			eventdate = genericUtility.getValidDateTimeString( eventdate , getApplDateFormat() , getDBDateFormat());//Shahu - 27/10/12
			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			System.out.println(" sql [" + checkSQL + "]" );
			pstmtPeriod = connectionObject.prepareStatement(checkSQL);
			//pstmt.setString(1,checkNull(eventdate));//Shahu - 27/10/12
			pstmtPeriod.setTimestamp(1, java.sql.Timestamp.valueOf(eventdate));//Shahu - 27/10/12
			rsPeriod = pstmtPeriod.executeQuery();

			if(rsPeriod.next())
			{
				String code = rsPeriod.getString( "CODE" );

				checkSQL = "SELECT DDF_GET_EMP_HOLIDAY(?,?,?,?) HOLDATE FROM DUAL ";
				System.out.println("sql [" + checkSQL + "] ");

				PreparedStatement pstmt = connectionObject.prepareStatement(checkSQL);
				pstmt.setString(1,checkNull(sprs));
				pstmt.setString(2,checkNull(code));
				pstmt.setString(3,checkNull(code));
				//pstmt.setString(4,checkNull(eventdate));//Shahu - 27/10/12
				pstmt.setTimestamp(4, java.sql.Timestamp.valueOf(eventdate));//Shahu - 27/10/12
				ResultSet rs = pstmt.executeQuery();
				if(rs.next())
				{
					String holDate = rs.getString( 1 );
					System.out.println(" holDate [" + holDate + "] ");
					if ( holDate != null )
					{
						errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
					}
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			if (rsPeriod != null)
			{
				rsPeriod.close();
				rsPeriod = null;
			}
			if(pstmtPeriod !=null)
			{
				pstmtPeriod.close();
				pstmtPeriod = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			try
			{
				if (rsPeriod != null)
				{
					rsPeriod.close();
					rsPeriod = null;
				}
				if(pstmtPeriod !=null)
				{
					pstmtPeriod.close();
					pstmtPeriod = null;
				}
				/*
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}*/
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;
	}

	//to get value of selected attribute
	private String getDomAttrVal( Document dom,String objContext, int rowNo, String attribute )
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String attrVal = "";
		elementList = dom.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if ( elementName!=null && ("Detail"+objContext).equalsIgnoreCase( elementName.getNodeName()) )
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("domID")!=null && etlAttributes.getNamedItem("domID").getNodeValue().equalsIgnoreCase(Integer.toString(rowNo)))
				{
					attrVal = etlAttributes.getNamedItem( attribute ).getNodeValue();
				}
			}
		}
		return attrVal;
	}

	//Changed By Vidhya on 08/12/09 [WS89NOV642 | made public for work team issue] Start
	//private String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	public String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			detailListLength = detailList.getLength();
			parentNode = detailList.item(rowNo);
			elementAttr = (Element)parentNode;
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();

			if ( parentNode != null )
			{
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

		return columnValue;
	}

	//to get Activity type
	private String getActivityType( String actCode, Connection connectionObject )throws ITMException
	{
		String sql = "";
		String actType = "";
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;

		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );

			sql = "SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, actCode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				actType = rs.getString("ACTIVITY_TYPE");
				actType = checkNull(actType).toUpperCase();
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				/*
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}*/
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return actType;
	}

	//formatted errorstring for Item Detail
	private String getItemErrorString( String errString, String custCode ,String itemDescr, String itemCode, String sprsProdGrp)
	{
		String sql = "";
		String custName = "";
		String msgDescr = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;

		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );

			sql = "SELECT UPPER(FIRST_NAME)||\' \'||UPPER(LAST_NAME) AS SC_NAME FROM STRG_CUSTOMER WHERE SC_CODE = ?";
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, checkNull(custCode));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				custName = rs.getString("SC_NAME");
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(itemCode.length() != 0 && !itemCode.equalsIgnoreCase(""))
			{
				itemDescr = "Promo Material for "+ itemDescr;
			}
			else if( sprsProdGrp.length() != 0 && !sprsProdGrp.equalsIgnoreCase(""))
			{
				itemDescr = "Pitch value for " + itemDescr;
			}

			msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"))+
					"" +itemDescr+ " selected for " + custName;

			errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
		}

		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;

	}

	//to check if input is a number
	private boolean checkIfNumber(String in)
	{
		try
		{
			System.out.println("=====>IN VALUE"+in);
			//Integer.parseInt(in);//Commented By Dipak
			Double.parseDouble(in);//Added By Dipak

		} catch (NumberFormatException ex)
		{
			return false;
		}
		return true;
	}
	//****Private Methods ***** End
	//Utility Functions End****************
	public String getSelectedCustomerDetail( Document dom, String reqFormNo,String repformNo, ArrayList temp, String colName) throws ITMException
	{
		GenericUtility genericUtility = GenericUtility.getInstance();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			System.out.println("currentFormNo ["+reqFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + reqFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentlistlength["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						System.out.println("columnValue["+columnValue+"]");
						System.out.println("TEMP ARRAY ["+temp.toString()+"]");
						//System.out.println("TEMP ARRAY ["+temp[]+"]");

						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							System.out.println("Inside temp Contains Column value["+columnValue+"]");
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								elementAttr.setAttribute( "domID" , Integer.toString(domID) );
								elementAttr.setAttribute( "selected" , "Y" );
								elementAttr.setAttribute( "objContext" , repformNo );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}
					}
				}

			}

			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+reqFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+reqFormNo) != -1 ? returnPrevStr : "";

			returnPrevStr = returnPrevStr.replace("Detail"+reqFormNo,"Detail"+repformNo);
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaDSRWizardEJB :getSelectedCustomerDetail :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	private String getDocVistDatesInMonth(String strgCode,String sprsCode, String eventDate, Connection conn) throws ITMException
	{
		String visitDates = "";
		String sql="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		int maxDate = 0;
		StringBuffer sb = new StringBuffer();
		try
		{
			String dbDateFormat = genericUtility.getDBDateFormat();

			Calendar cal  = Calendar.getInstance();
			cal.setTime( new Date( java.sql.Timestamp.valueOf( eventDate+" 00:00:00" ).getTime() ) );
			maxDate =	cal.getActualMaximum(Calendar.DAY_OF_MONTH);
			int monInt =	cal.get( Calendar.MONTH );
			int yearInt =	cal.get( Calendar.YEAR );

			String dbName =CommonConstants .DB_NAME;

			System.out.println("maxDate ["+maxDate+"] monInt ["+monInt+"] yearInt ["+yearInt+"]");
			System.out.println("DATABASE NAME===>"+dbName);
			System.out.println("Commented code for visted dates===>");

			if(dbName.equalsIgnoreCase("ORACLE"))
			{

				/*Commented By Shahu Mali on 29-12-12
				 * sql = "select  to_char(event_date,'dd') as VisitDates from strg_meet "+
				"where strg_code = ? "+
				"and sales_pers = ? "+
				"and event_date >=  '01' || '-' || to_char(to_date(?,?),'MON') || to_char(to_date(?,?),'yy') "+
				"and event_date <  ?";


				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,strgCode);
				pstmt.setString(2,sprsCode);
				pstmt.setString(3,eventDate);
				pstmt.setString(4,dbDateFormat);
				pstmt.setString(5,eventDate);
				pstmt.setString(6,dbDateFormat);
				pstmt.setTimestamp(7,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));


				*/
				//Added By Shahu Mali on 29-12-12
				sql = "select  to_char(event_date,'dd/MON') as VisitDates from strg_meet "+
				"where strg_code = ? "+
				"and sales_pers = ? "+
				"and event_date <  ? order by event_date desc ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,strgCode);
				pstmt.setString(2,sprsCode);
				pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));
				//Ended  By Shahu Mali on 29-12-12


			}
			else if(dbName.equalsIgnoreCase("DB2"))
			{


				/*Added For DB2 BY DIPAK*/
				sql = "select VARCHAR_FORMAT(event_date,'DD') as VisitDates from strg_meet "+
						"where strg_code = ? "+
						"and sales_pers = ? "+
						"and event_date >=  VARCHAR_FORMAT(?,'YYYY')|| '-' ||VARCHAR_FORMAT(?,'MM')  || '-' ||'01' "+
						"and event_date <  ?";

				/*Ended For DB2 BY DIPAK*/

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,strgCode);
				pstmt.setString(2,sprsCode);
				pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));
				pstmt.setTimestamp(4,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));
				pstmt.setTimestamp(5,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));

			}
			rs = pstmt.executeQuery();
			int visitDtCnt = 0;
			while (rs.next())
			{
				visitDtCnt++;
				String dates = rs.getString("VisitDates");
				sb.append(dates).append(",");
				if(visitDtCnt == 3)
				{
					break;
				}
			}
			visitDates = sb.toString();
			if(visitDates.length() > 0 && visitDates.lastIndexOf(",") > 0  )
			{
				visitDates = visitDates.substring(0,visitDates.length() - 1);
			}
			System.out.println("visitDates =["+visitDates+"]");

		}

		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		return visitDates;
	}
	//Overloaded method is added by Gulzar [eventDate] on 18/06/12
	public String getSalesPersItemList( String sprsCode, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement landingRatePstmt=null;
		ResultSet rs = null;
		ResultSet lRateResSet= null;
		//String landingRate="";
		//String landingRateSQL="";
		String rate="";//Gaurav Singh on 22-12-14
		String rateSQL="";//Gaurav Singh on 22-12-14
		String targetQty = null;//Gaurav Singh on 31-12-14
		String targetValue = null;//Gaurav Singh on 31-12-14
		GenericUtility genericUtility = GenericUtility.getInstance();
		boolean isMasterPitchFound = false;
		try
		{
			valueXmlString.append( "<Root>\r\n" );
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );
            /* Commented By Shahu Mali on 07-FEB-14.START
			String pitchDetails = getPitchDetails( sprsCode, strgCode, eventDate );

			System.out.println("getSalesPersItemList :pitchDetails==["+pitchDetails+"]");
			if(pitchDetails != null && pitchDetails.trim().length() > 0 )
			{
				Document pitchDom = genericUtility.parseString("<Root>"+pitchDetails+"</Root>");
				NodeList pitchList = pitchDom.getElementsByTagName("Detail5");
				System.out.println("pitchList.getLength() =["+pitchList.getLength()+"]");
				if ( pitchList.getLength() > 0 )
				{
					isMasterPitchFound= true;
					return "<Root>"+pitchDetails+"</Root>";
				}
			}
              Commented By Shahu Mali on 07-FEB-14.END*/

			// changed by rakesh kumar status='Y' on 07/09/12 - start
			//sql = "SELECT DISTINCT SPG.SALES_PROD_GRP ITEM, SPG.DESCR DESCR FROM SALES_PROD_GRP SPG, ITEM M  WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ?  ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";
			//sql1 = "SELECT M.ITEM_CODE ITEM, M.DESCR DESCR FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";

			//	sql = "SELECT DISTINCT SPG.SALES_PROD_GRP ITEM, SPG.DESCR DESCR FROM SALES_PROD_GRP SPG, ITEM M  WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? AND STATUS='Y' ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";//Commented By Dipak For DB2
			//sql = 	"SELECT  DISTINCT  (SALES_PROD_GRP.SALES_PROD_GRP )AS ITEM ,(SALES_PROD_GRP.DESCR) AS  DESCR FROM SALES_PROD_GRP left outer join  ITEM  on SALES_PROD_GRP.SALES_PROD_GRP = item.SALES_PROD_GRP   AND  ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? AND STATUS='Y' ) ";

			sql = "SELECT DISTINCT SPG.SALES_PROD_GRP ITEM, SPG.DESCR DESCR "+
					"FROM SALES_PROD_GRP SPG LEFT OUTER JOIN ITEM M ON SPG.SALES_PROD_GRP = M.SALES_PROD_GRP "+
					"WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? AND STATUS='Y' ) ";

			sql1 = "SELECT M.BRAND_CODE BRAND_CODE ,M.ITEM_CODE ITEM, M.DESCR DESCR "+
					"FROM ITEM M LEFT OUTER JOIN SALES_PROD_GRP SPG ON M.SALES_PROD_GRP = SPG.SALES_PROD_GRP "+
					"WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? AND STATUS='Y' ) ";

			//End changes by rakesh on 07/09/12 - start

			System.out.println(" selectedItem ["+selectedItem+"]");
			HashMap itemMap = new HashMap();


			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("strg_item");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String pitch = "";
					String qty = "";
					String columnValue = "";

					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if("sales_prod_grp".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() + "-SPG";
							}
						}
						else if ( "briefed_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								pitch = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
					}
					System.out.println("itemCode["+itemCode+"] pitch["+pitch+"] qty["+qty+"]" );
					itemMap.put( itemCode, pitch+"~"+qty);

					System.out.println(" itemMap ["+itemMap+"]");
				}
			}

			String qty = "0";
			String pitch = "";
			int num = 1;
			//if( ! isMasterPitchFound )
			/*//Commented by Shahu Mali on 03-FEB-14.START
			 {
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, sprsCode);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String itemCode = (rs.getString("ITEM")).trim() + "-SPG";
					System.out.println("itemCode["+itemCode+"]");
					landingRateSQL="SELECT LANDING_RATE FROM LANDING_RATE_MST WHERE ITEM_CODE= ? ";
				    landingRatePstmt =  connectionObject.prepareStatement( landingRateSQL );
				    landingRatePstmt.setString(1, itemCode);
					lRateResSet = landingRatePstmt.executeQuery();
					while(lRateResSet.next())
					{
						landingRate=lRateResSet.getString("LANDING_RATE");
					}
					System.out.println("itemCode=["+itemCode+"] ,landingRate=["+landingRate+"]");
					if ( itemMap.get( itemCode ) != null )
					{
						String data = ( String ) itemMap.get( itemCode );
						pitch = data.substring(0, data.indexOf("~") );
						qty = data.substring( data.indexOf("~") + 1 );
						valueXmlString.append( "<Detail5 domID='" + num + "' selected = 'Y'>\r\n" );
					}
					else
					{
						valueXmlString.append( "<Detail5 domID='" + num + "' selected = 'N'>\r\n" );
					}

					valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );					valueXmlString.append("<item_code><![CDATA[").append("").append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append(rs.getString("ITEM")).append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append(pitch).append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<master_pitch><![CDATA[N]]></master_pitch>\r\n" );
					valueXmlString.append( "<landing_rate><![CDATA[" ).append(landingRate).append( "]]></landing_rate>\r\n" );
					valueXmlString.append( "</Detail5>\r\n" );
					num++;
					qty = "0";
					pitch = "";
				}
				if(rs != null)
				{
					rs.close(); rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close(); pstmt = null;
				}
			} //Commented by Shahu Mali on 03-FEB-14 .END*/

			pstmt =  connectionObject.prepareStatement( sql1 );
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				float pobValue=0.0f;
				String itemCode = rs.getString("ITEM");

				//Commented and changes done by Gaurav Singh on 22-DEC-2014 for getting the rate from sales_budget_cust_det master instead of LANDING_RATE_MST [Start]
				//landingRateSQL="SELECT LANDING_RATE FROM LANDING_RATE_MST WHERE ITEM_CODE= ? ";
				rateSQL = " SELECT DET.ITEM_CODE, ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR,DET.QUANTITY AS QUANTITY,DET.NET_AMT AS NET_AMT, DET.RATE AS RATE " +
						" FROM SALES_BUDGET_CUST HDR,SALES_BUDGET_CUST_DET DET,PERIOD PERIOD,ACCTPRD ACCTPRD,ITEM ITEM, SALES_PERS SP " +
						" WHERE DET.PRD_CODE = PERIOD.CODE " +
						" AND ? BETWEEN PERIOD.FR_DATE AND PERIOD.TO_DATE " +
						" AND DET.TRAN_ID = HDR.TRAN_ID " +
						" AND HDR.ACCT_PRD = ACCTPRD.CODE " +
						" AND ITEM.ITEM_SER = SP.ITEM_SER " +
						" AND DET.ITEM_CODE = ITEM.ITEM_CODE " +
						" AND DET.CUST_CODE = ? "+
						" AND DET.ITEM_CODE = ? " +
						" GROUP BY DET.ITEM_CODE,ITEM.DESCR,ITEM.SH_DESCR,DET.QUANTITY,DET.NET_AMT,DET.RATE " +
						" ORDER BY ITEM.SH_DESCR ";

			    //landingRatePstmt =  connectionObject.prepareStatement( landingRateSQL );
				landingRatePstmt =  connectionObject.prepareStatement( rateSQL );
			    //landingRatePstmt.setString(1, itemCode);
				landingRatePstmt.setTimestamp(1,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ));
				landingRatePstmt.setString(2, strgCode);
				landingRatePstmt.setString(3, itemCode);
				lRateResSet = landingRatePstmt.executeQuery();
				while(lRateResSet.next())
				{
					//landingRate=lRateResSet.getString("LANDING_RATE");
					rate=lRateResSet.getString("RATE");
					targetQty = lRateResSet.getString("QUANTITY");
					targetValue = lRateResSet.getString("NET_AMT");
				}

				System.out.println("targetQty=["+targetQty+"] ,targetValue=["+targetValue+"]");
				System.out.println("itemCode=["+itemCode+"] ,landingRate=["+rate+"]");
				lRateResSet.close();lRateResSet=null;
				landingRatePstmt.close();landingRatePstmt=null;

				if ( itemMap.get( itemCode.trim() ) != null )
				{
					String data = ( String ) itemMap.get( itemCode.trim() );
					qty = data.substring( data.indexOf("~") + 1 );
					valueXmlString.append("<Detail5 domID='"+num+"' selected = 'Y'>\r\n" );
				}
				else
				{
					valueXmlString.append("<Detail5 domID='"+num+"' selected = 'N'>\r\n" );
				}
			    valueXmlString.append("<brand_code><![CDATA[").append(rs.getString("BRAND_CODE")).append("]]></brand_code>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
				valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
				valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );
				valueXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM") ).append("]]></item_code>\r\n");
				valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
				valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
				valueXmlString.append( "<briefed_descr><![CDATA[" ).append("Promo Material").append( "]]></briefed_descr>\r\n" );
				valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append("").append( "]]></sales_prod_grp>\r\n" );
				valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
				valueXmlString.append( "<master_pitch><![CDATA[N]]></master_pitch>\r\n" );
				//valueXmlString.append( "<landing_rate><![CDATA[" ).append(landingRate).append( "]]></landing_rate>\r\n" );
				valueXmlString.append( "<landing_rate><![CDATA[" ).append(rate).append( "]]></landing_rate>\r\n" ); //Gaurav Singh on 22-12-14

				valueXmlString.append( "<target_qty><![CDATA[" ).append( targetQty ).append( "]]></target_qty>\r\n" );//Gaurav Singh on 31-12-14
				valueXmlString.append( "<target_value><![CDATA[" ).append( targetValue ).append( "]]></target_value>\r\n" );//Gaurav Singh on 31-12-14

				//pobValue=Integer.parseInt(qty)*Integer.parseInt(landingRate);
				//Commented and added by Sneha on 02-Apr-14 to accept float value[WS3JNOV003]
				//pobValue=Integer.parseInt(qty)*Float.parseFloat(landingRate);
				pobValue=Integer.parseInt(qty)*Float.parseFloat(rate);//Gaurav Singh on 22-12-14
				System.out.println("pob_value=["+pobValue+"]");
				valueXmlString.append( "<pob_value><![CDATA[" ).append(pobValue).append( "]]></pob_value>\r\n" );
				valueXmlString.append( "</Detail5>\r\n" );
				qty = "0";
				num++;
			}//end of while
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			num = 1;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception : WsfaDSRWizardEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRWizardEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	//end Overloaded method is added by Gulzar [eventDate] on 18/06/12

	//Added method by Gulzar on 18/06/12
	public String getPitchDetails( String salePersCode, String scCode, String wrkDate ) throws ITMException
	{
		int domId = 0;

		StringBuffer valueXmlString = new StringBuffer();
		GenericUtility genericUtility = GenericUtility.getInstance();

		PreparedStatement pstmtSelectPitch = null;
		ResultSet rsSelectPitch = null;
		ArrayList pitchList = new ArrayList();


		Connection conn = null;

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverValidator" );

			TreeMap<String, String> pitchMap = new TreeMap<String, String>();


			String pitchSql = "select sbv.* from mpl_sub_bu_link sbl, strg_series ss, sub_bu_validity sbv, sales_pers sp "+
					"where sbv.sub_bu_code = sp.sub_bu_code and ss.sales_pers = sp.sales_pers and sbl.mpl_no__fr <= ss.short_id "+
					"and sbv.master_id = sbl.master_id "+
					"and sbv.eff_from <= ? "+
					"and sbv.valid_upto >= ? "+
					"and sbl.mpl_no__to >= ss.short_id "+
					"and trim(ss.sc_code) = ? "+
					"and trim(ss.sales_pers) = ? ";

			pstmtSelectPitch = conn.prepareStatement(pitchSql);
			pstmtSelectPitch.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( wrkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmtSelectPitch.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( wrkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmtSelectPitch.setString(3,scCode.trim());
			pstmtSelectPitch.setString(4,salePersCode.trim());
			rsSelectPitch = pstmtSelectPitch.executeQuery();
			if (rsSelectPitch.next())
			{
				pitchMap.put("P1", checkNull(rsSelectPitch.getString("PITCH_1")));
				pitchMap.put("P2", checkNull(rsSelectPitch.getString("PITCH_2")));
				pitchMap.put("P3", checkNull(rsSelectPitch.getString("PITCH_3")));
				pitchMap.put("P4", checkNull(rsSelectPitch.getString("PITCH_4")));
				pitchMap.put("P5", checkNull(rsSelectPitch.getString("PITCH_5")));
				pitchMap.put("P6", checkNull(rsSelectPitch.getString("PITCH_6")));
				pitchMap.put("P7", checkNull(rsSelectPitch.getString("PITCH_7")));
				pitchMap.put("P8", checkNull(rsSelectPitch.getString("PITCH_8")));
				pitchMap.put("P9", checkNull(rsSelectPitch.getString("PITCH_9")));
				pitchMap.put("P10", checkNull(rsSelectPitch.getString("PITCH_10")));
			}
			String pitchValue = "";
			String pitchDescr = "";
			String pitchKey = "";
			int pitchMapSize = pitchMap.size();
			Iterator it = pitchMap.entrySet().iterator();
			while (it.hasNext())
			{
				domId++;
				Map.Entry mapEntry = (Map.Entry)it.next();
				pitchKey = (String)mapEntry.getKey();
				pitchValue = (String)mapEntry.getValue();

				if( pitchValue.length() == 0 )
				{
					continue;
				}
				pitchDescr = findValue(conn, "descr" ,"sales_prod_grp", "sales_prod_grp", pitchValue);
				valueXmlString.append("<Detail5 domID='" + domId + "' selected = 'Y'>\r\n");
				valueXmlString.append("<item_descr><![CDATA[").append(pitchDescr).append("]]></item_descr>\r\n");
				valueXmlString.append("<quantity><![CDATA[").append("0").append("]]></quantity>\r\n");
				valueXmlString.append("<item_code><![CDATA[").append("").append("]]></item_code>\r\n");
				valueXmlString.append("<sales_prod_grp><![CDATA[").append(pitchValue).append("]]></sales_prod_grp>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append(scCode).append("]]></strg_code>\r\n");
				valueXmlString.append("<line_no><![CDATA[").append("").append("]]></line_no>\r\n");
				valueXmlString.append("<item_type><![CDATA[").append("").append("]]></item_type>\r\n");
				valueXmlString.append("<briefed_descr><![CDATA[").append(pitchKey).append("]]></briefed_descr>\r\n");
				valueXmlString.append("<item_pob><![CDATA[").append("").append("]]></item_pob>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[").append("").append("]]></dcr_id>\r\n");
				valueXmlString.append( "<master_pitch><![CDATA[Y]]></master_pitch>\r\n" );
				valueXmlString.append("</Detail5>\r\n");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsSelectPitch !=null )
				{
					rsSelectPitch.close();
					rsSelectPitch = null;
				}
				if(pstmtSelectPitch != null)
				{
					pstmtSelectPitch.close();
					pstmtSelectPitch = null;
				}
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		return valueXmlString.toString();
	}
	private String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ;
		String sql = "";
		String findValue = "";
		try
		{
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from findValue " + findValue);
		return findValue;
	}

	private ArrayList getTeamList(String workWith) throws  ITMException
	{
		ArrayList teamList = new ArrayList();
		try
		{
			if ( workWith != null && workWith.trim().length() > 0 )
			{
				String searchIndex = "";
				if ( workWith.indexOf("<BR/>") > 0 )
				{
					searchIndex = "<BR/>";
				}
				else if ( workWith.indexOf(",") > 0 )
				{
					searchIndex = ",";
				}
				System.out.println("searchIndex =["+searchIndex+"]");
				if ( workWith.indexOf(searchIndex) > 0 )
				{
					String workWitthTeam [] = workWith.split(searchIndex);
					if ( workWitthTeam != null && workWitthTeam.length > 0 )
					{
						String teamMember = "";

						for ( int i=0; i<workWitthTeam.length; i++)
						{
							teamMember = workWitthTeam[i];
							System.out.println("teamMember =["+teamMember+"]");
							int leftIndex = teamMember.indexOf("(");
							int rightIndex = teamMember.indexOf(")");
							String newStr = "";
							if (leftIndex >= 0 && rightIndex >= 0 )
							{
								newStr = teamMember.substring(leftIndex+1,teamMember.lastIndexOf(")"));
								System.out.println("leftIndex_rightIndex =["+newStr+"]");
							}
							else if (leftIndex >= 0 )
							{
								newStr = teamMember.substring(leftIndex+1);
								System.out.println("newStr_leftIndex =["+newStr+"]");
							}
							else if (rightIndex >= 0 )
							{
								newStr = teamMember.substring(0,rightIndex);
								System.out.println("newStr_rightIndex =["+newStr+"]");
							}
							teamList.add(newStr.trim());
						}

					}
				}
				else
				{
					teamList.add(workWith);
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("Team List ::"+teamList);
		return teamList;
	}

	public String getSalesPersTeamList( String salesPers, String strgCode, String selectedTeam, String workWith ) throws ITMException
	{
		System.out.println("getSalesPersTeamList is called..............");
		String sql = "";
		String [] team = new String [25];
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection connectionObject = null;
		PreparedStatement pstmtPophelp = null;
		ResultSet rsPophelp = null;
		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			ArrayList teamList = getTeamList(workWith);//Gulzar on 23/06/12

			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );

			selectedTeam = ( selectedTeam != null ) ? selectedTeam.trim() : selectedTeam;
			team = selectedTeam.split(",");
			System.out.println("Team selected ["+Arrays.asList(team)+"] strgCode["+strgCode+"]");
			sql = "SELECT SQL_STR FROM POPHELP WHERE FIELD_NAME='SALES_PERS' AND MOD_NAME='W_STRG_MEET'";
			pstmtPophelp =  connectionObject.prepareStatement( sql );
			rsPophelp = pstmtPophelp.executeQuery();
			int num = 1;
			if (rsPophelp.next())
			{
				sql = rsPophelp.getString("SQL_STR").trim().replace("'?'", "?");
				PreparedStatement pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, salesPers);
				ResultSet rs = pstmt.executeQuery();
				while(rs.next())
				{
					String reportTo = rs.getString("REPORT_TO");
					String desgn= rs.getString("DESIGNATION");
					System.out.println("reportTo["+reportTo+"] desgn ["+desgn+"]");
					reportTo = ( reportTo != null ) ? reportTo.trim() : reportTo;
					if ( new ArrayList<String>(Arrays.asList(team)).contains( reportTo ) || (teamList != null && teamList.contains(reportTo)) )
					{

						valueXmlString.append( "<Detail6 domID='" + num + "' selected = 'Y'>\r\n" );
					}
					else
					{
						valueXmlString.append( "<Detail6 domID='" + num + "' selected = 'N'>\r\n" );
					}

					valueXmlString.append("<sales_pers><![CDATA[").append( reportTo ).append("]]></sales_pers>\r\n");
					valueXmlString.append("<name><![CDATA[").append( rs.getString("NAME") ).append("]]></name>\r\n");
					valueXmlString.append("<designation><![CDATA[").append( rs.getString("DESIGNATION")).append("]]></designation>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					valueXmlString.append("<role_code><![CDATA[]]></role_code>\r\n");

					sql = "SELECT DESIGN_CODE FROM EMPLOYEE WHERE EMP_CODE = ?";
					PreparedStatement pstmtEmp =  connectionObject.prepareStatement( sql );
					pstmtEmp.setString(1, reportTo);
					ResultSet rset = pstmtEmp.executeQuery();
					if ( rset.next())
					{
						String desgnCode = rset.getString("DESIGN_CODE") != null ?rset.getString("DESIGN_CODE").trim() :"";
						valueXmlString.append("<design_code><![CDATA[").append( desgnCode ).append("]]></design_code>\r\n");
					}
					rset.close(); rset = null;
					pstmtEmp.close(); pstmtEmp = null;

					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<deselect_strg_code><![CDATA[" ).append("N").append( "]]></deselect_strg_code>\r\n" );//Gulzar on 02/08/12
					valueXmlString.append( "</Detail6>\r\n" );
					num++;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;

				}
			}
			if(rsPophelp != null)
			{
				rsPophelp.close();
				rsPophelp = null;
			}
			if(pstmtPophelp != null)
			{
				pstmtPophelp.close();
				pstmtPophelp = null;

			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if ( rsPophelp != null )
				{
					rsPophelp.close();
					rsPophelp = null;
				}

				if ( pstmtPophelp != null )
				{
					pstmtPophelp.close();
					pstmtPophelp = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();

	}

	//End Added by Gulzar on 18/06/12
	//Added By Gulzar on 16-APR-13.START
	private String getDCRId(Connection conn, String salesPers, String dcrDate, String selActCode) throws Exception
	{
		String dcrID = "";
		PreparedStatement pstmtDCRID = null;
		ResultSet rsDCRID = null;
		try
		{
			String activityCode = "";
			GenericUtility genericUtility = GenericUtility.getInstance();
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			//Select the activity type of selected activity code
			String selActType = "";
			String actTypeSql = "SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";

			PreparedStatement pstmtActType = conn.prepareStatement( actTypeSql );
			pstmtActType.setString(1, selActCode);
			ResultSet rsActType = pstmtActType.executeQuery();
			if( rsActType.next() )
			{
				selActType = checkNull(rsActType.getString("ACTIVITY_TYPE"));
			}
			rsActType.close();rsActType = null;
			pstmtActType.close();pstmtActType = null;

			//Select the activity code from sprs_act_tran of selected activity type
			String actCodeDb = "";
			String actCodeSql = "SELECT A.ACTIVITY_CODE FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.EVENT_DATE = ? AND A.SALES_PERS = ? AND B.ACTIVITY_TYPE = ? ";

			PreparedStatement pstmtActCode = conn.prepareStatement( actCodeSql );
			pstmtActCode.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtActCode.setString(2, salesPers);
			pstmtActCode.setString(3, selActType);
			ResultSet rsActCode = pstmtActCode.executeQuery();
			if( rsActCode.next() )
			{
				actCodeDb = checkNull(rsActCode.getString("ACTIVITY_CODE"));
			}
			rsActCode.close();rsActCode = null;
			pstmtActCode.close();pstmtActCode = null;

			if(actCodeDb.trim().length() > 0)
			{
				activityCode = actCodeDb;
			}
			else
			{
				activityCode = selActCode;
			}

			String dcrSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE EVENT_DATE =? AND SALES_PERS = ? AND ACTIVITY_CODE = ? ";

			pstmtDCRID = conn.prepareStatement( dcrSql );
			pstmtDCRID.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtDCRID.setString(2, salesPers);
			pstmtDCRID.setString(3, activityCode);
			rsDCRID = pstmtDCRID.executeQuery();
			if( rsDCRID.next() )
			{
				dcrID = checkNull(rsDCRID.getString("DCR_ID"));
			}
			//added By Nilesh Start::02-06-2017
			if(rsDCRID!=null)
			{
				rsDCRID.close();
				rsDCRID=null;
			}
			if(pstmtDCRID!=null)
			{
				pstmtDCRID.close();
				pstmtDCRID=null;
			}
			//added By Nilesh End::02-06-2017

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsDCRID != null)
				{
					rsDCRID.close();
					rsDCRID = null;
				}
				if(pstmtDCRID !=null)
				{
					pstmtDCRID.close();
					pstmtDCRID = null;
				}
			}
			catch(Exception e1){}
		}
		return dcrID;
	}
	//Added by Gulzar on 16-APR-13.END
	//Added By Shahu Mali on 11/04/13 for Request Id [WS3ANOV003].START
	public ArrayList halfDayActivityList( String propName, Connection conn ) throws Exception
	{
		String propVal = "";
		PreparedStatement pstmtProp = null;
		ResultSet rsProp = null;
		boolean isActivityExist=false;
		ArrayList halfDayActList = new ArrayList();
		try
		{
			String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ?";
			pstmtProp = conn.prepareStatement(propSql);
			pstmtProp.setString(1,propName);
			rsProp = pstmtProp.executeQuery();
			if(rsProp.next())
			{
				propVal = (rsProp.getString("PROP_VALUE") == null) ?"":rsProp.getString("PROP_VALUE");
			}
			if(propVal.length() > 0)
			{
				halfDayActList = new ArrayList<String>(Arrays.asList(propVal.split(",")));
			}

		}
		catch(Exception e)
		{
			System.out.println("isActivityCodeExist Catch Exception"+e.getMessage());
			throw e;

		}
		finally
		{
			try
			{
				if(rsProp != null)
				{
					rsProp.close(); rsProp = null;
				}
				if(pstmtProp != null)
				{
					pstmtProp.close(); pstmtProp = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Finaly Catch Exception"+e.getMessage());
			}
		}
		System.out.println("is Activity code exist =["+isActivityExist+"]");

	    return 	 halfDayActList;

	}
	//Added By Shahu Mali on 11/04/13 for Request Id [WS3ANOV003].END

	public String getDSRPlanLocality( String salesPers, String eventDate ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		Connection conn = null;
		String localityDescr = "";
		StringBuffer valueXmlString = new StringBuffer();
		java.sql.Timestamp travelDate = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );

			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( "" ).append( "</editFlag>\r\n</Header>\r\n<Errors>\r\n</Errors>\r\n" );
			valueXmlString.append( "<Detail1 domID='1'>\r\n" );

			String activityType = "";
			String overNight = "";

			/*String sprsPlanSql = "SELECT A.LOCALITY_CODE, A.OVER_NIGHT, B.ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
								" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
								" AND A.TRAVEL_DATE = (SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ? )";
			*/

			String sprsPlanSql ="SELECT A.LOCALITY_CODE, B.ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_PLAN A, FIELDACTIVITY B, LOCALITY C " +
			"WHERE A.PLAN_ACTIVITY = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SPRS_CODE__PLAN = ? " +
			"AND A.PLAN_DATE =(SELECT MAX(PLAN_DATE) FROM SPRS_PLAN WHERE SPRS_CODE__PLAN = ? AND PLAN_DATE < ? ) " ;

			PreparedStatement pstmtTrv = conn.prepareStatement(sprsPlanSql);
			pstmtTrv.setString(1, salesPers );
			pstmtTrv.setString(2, salesPers );
			pstmtTrv.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

			ResultSet rsTrv = pstmtTrv.executeQuery();
			if(rsTrv.next())
			{
				localityCodeFrom = (rsTrv.getString("LOCALITY_CODE") == null) ?"":rsTrv.getString("LOCALITY_CODE").trim();
				localityDescr = (rsTrv.getString("LOC_DESCR") == null) ?"":rsTrv.getString("LOC_DESCR").trim();
				activityType = (rsTrv.getString("ACTIVITY_TYPE") == null) ?"":rsTrv.getString("ACTIVITY_TYPE").trim();
				//overNight = (rsTrv.getString("OVER_NIGHT") == null) ?"":rsTrv.getString("OVER_NIGHT").trim();
			}
			rsTrv.close(); rsTrv = null;
			pstmtTrv.close(); pstmtTrv = null;

			/*if(!("LEAVE".equalsIgnoreCase(activityType) || "NFW".equalsIgnoreCase(activityType)))
			{

				String stanCodeSql = "SELECT ST.LOCALITY_CODE AS LOC_CODE, ST.TRAVEL_DATE AS TRAVEL_DATE, LOC.DESCR AS LOC_DESCR FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
									" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
									" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ?) AND (DR_VISIT ='Y' OR CHEM_VISIT ='Y')) "+
									" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
									" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ?) ";
				pstmt =  conn.prepareStatement(stanCodeSql);
				pstmt.setString(1, salesPers );
				pstmt.setString(2, salesPers );
				pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(4, salesPers );
				pstmt.setString(5, salesPers );
				pstmt.setTimestamp( 6, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

				rs = pstmt.executeQuery();

				System.out.println("Inside method getStanCodeFrom eventDate"+eventDate);
				if(rs.next())
				{
					localityCodeFrom = (rs.getString("LOC_CODE") == null)?"":rs.getString("LOC_CODE").trim();
					localityDescr = (rs.getString("LOC_DESCR") == null)?"":rs.getString("LOC_DESCR").trim();
					travelDate = rs.getTimestamp("TRAVEL_DATE");
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				int overNightCount = 0;
				String checkOverNightSql = "SELECT COUNT(1) AS COUNT FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ? AND OVER_NIGHT = 'Y'";
				PreparedStatement pstmtOverNight = conn.prepareStatement(checkOverNightSql);
				pstmtOverNight.setString(1, salesPers );
				pstmtOverNight.setTimestamp(2, travelDate);
				ResultSet rsOverNight = pstmtOverNight.executeQuery();
				if(rsOverNight.next())
				{
					overNightCount = rsOverNight.getInt("COUNT");
				}
				rsOverNight.close(); rsOverNight = null;
				pstmtOverNight.close(); pstmtOverNight = null;

				System.out.println("overNightCount =["+overNightCount+"]");

				if(overNightCount > 0)
				{
					overNight = "Y";
				}
				else
				{
					overNight = "N";
				}

				//Getting last place of return
				if(overNight != null && "Y".equalsIgnoreCase(overNight))
				{
					String placeOfReturn[] = getPlaceOfReturnFrom(conn, salesPers, eventDate);
					if(placeOfReturn.length > 0)
					{
						valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( placeOfReturn[0] ).append( "]]></last_place_of_return>\r\n" );
						valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(placeOfReturn[1]).append( "]]></last_place_of_descr_return>\r\n" );
					}
				}
				else
				{
					valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( localityCodeFrom ).append( "]]></last_place_of_return>\r\n" );
					valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(localityDescr).append( "]]></last_place_of_descr_return>\r\n" );

				}
			}
			else
			{
				valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( localityCodeFrom ).append( "]]></last_place_of_return>\r\n" );
				valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(localityDescr).append( "]]></last_place_of_descr_return>\r\n" );
			}*/
			//valueXmlString.append( "<sprs_route_locality_code><![CDATA[" ).append( localityCodeFrom ).append( "]]></sprs_route_locality_code>\r\n" );
			//valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( localityDescr ).append( "]]></sprs_route_descr>\r\n" );

			valueXmlString.append( "<sprs_route_locality_code><![CDATA[" ).append( localityCodeFrom ).append( "]]></sprs_route_locality_code>\r\n" );
			valueXmlString.append( "<sprs_route_locality_code><![CDATA[" ).append( localityCodeFrom ).append( "]]></sprs_route_locality_code>\r\n" );

			valueXmlString.append("</Detail1>\r\n");
			valueXmlString.append("</Root>\r\n");

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaDSRWizardEJB :getDSRPlanLocality :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1){}
		}

		return valueXmlString.toString();
	}
	public String getDSRPlanData(String salesPers,String eventDate) throws ITMException
	{
		String returnXmlString="";
		String sprsPlanSql="";
		String planActivity="";
		String planLocality="";
		PreparedStatement sprsPstmt=null;
		ResultSet sprsResultSet= null;
		Connection conn = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		StringBuffer valueXmlString = new StringBuffer();
		StringBuffer sprsPlanDetail = new StringBuffer();
		int count=0;
		try
		{

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );

			sprsPlanSql=" SELECT A.LOCALITY_CODE, B.ACTIVITY_TYPE  ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_PLAN A, FIELDACTIVITY B, LOCALITY C " +
					    " WHERE A.PLAN_ACTIVITY = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SPRS_CODE__PLAN = ? " +
					    " AND A.PLAN_DATE = ? ";
			//valueXmlString.append("<table>\r\n");
			sprsPstmt = conn.prepareStatement(sprsPlanSql);
			sprsPstmt.setString(1, salesPers );
			//sprsPstmt.setString(2, salesPers );
			sprsPstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			sprsResultSet = sprsPstmt.executeQuery();
			while(sprsResultSet.next())
			{
				count++;
				planActivity=sprsResultSet.getString("ACTIVITY_TYPE");
				planLocality=sprsResultSet.getString("LOC_DESCR");
				System.out.println("planActivity=["+planActivity+"],planLocality=["+planLocality+"]");
				valueXmlString.append("<tr>");
				System.out.println("\n Count =["+count+"]");
				if(count==1)
				{
					valueXmlString.append("<td class=\"td_leftAlign\"><plan_activity>").append(planActivity).append("</plan_activity></td>");
				}
				else
				{
					valueXmlString.append("<td class=\"td_leftAlign\"><plan_activity>").append("").append("</plan_activity></td>");
				}
				valueXmlString.append("<td class=\"td_leftAlign\"><plan_locality>").append(planLocality).append("</plan_locality></td>");
				valueXmlString.append("</tr>");
			}
			//sprsPlanDetail.append("<dsr_plan_data>").append(valueXmlString).append("</dsr_plan_data>\r\n");
			 sprsPlanDetail.append("<dsr_plan_data>").append("<![CDATA["+valueXmlString+"]]>").append("</dsr_plan_data>\r\n");
			//valueXmlString.append("</table>\r\n");
			sprsResultSet.close();sprsResultSet=null;
			sprsPstmt.close();sprsPstmt=null;
		}
		catch (Exception e)
		{
			// TODO: handle exception
			System.out.println("Exception :WsfaDSRWizardEJB:getDSRPlanData()\n"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(sprsResultSet!=null)
				{
					sprsResultSet.close();
					sprsResultSet=null;
				}
				if(sprsPstmt!=null)
				{
					sprsPstmt.close();
					sprsPstmt=null;
				}
				if(conn!=null)
				{
					conn.close();
					conn=null;
				}

			}
			catch(Exception fe)
			{
				System.out.println("Exception :WsfaDSRWizardEJB:getDSRPlanData(): finaly block \n"+fe.getMessage());
				fe.printStackTrace();
			}
		}
		returnXmlString=sprsPlanDetail.toString();
		//System.out.println("returnXmlString=["+returnXmlString+"]");

		return returnXmlString;
	}
   //Added By Shahu Mali on 12-FEB-14.START
	public String[] getStanCodeFrom( Connection con, String userId, String currDate ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		String overNight = "";
		java.sql.Timestamp travelDate = null;

		String stanCodeFrom[] = new String[2];

		GenericUtility genericUtility = GenericUtility.getInstance();
		boolean isLocalConn = false;

		try
		{
			if(con == null)
			{
				ConnDriver connDriver = new ConnDriver();
				con = connDriver.getConnectDB( "DriverITM" );
				isLocalConn = true;
			}
			String activityType = "";
			String sprsTrvSql = "SELECT A.LOCALITY_CODE, A.ACTIVITY_CODE, A.OVER_NIGHT, B.ACTIVITY_TYPE, C.DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
								" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
								" AND A.TRAVEL_DATE = (SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ?) ";

			PreparedStatement pstmtTrv = con.prepareStatement(sprsTrvSql);
			pstmtTrv.setString(1, userId );
			pstmtTrv.setString(2, userId );
			pstmtTrv.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

			ResultSet rsTrv = pstmtTrv.executeQuery();
			if(rsTrv.next())
			{
				localityCodeFrom = (rsTrv.getString("LOCALITY_CODE") == null) ?"":rsTrv.getString("LOCALITY_CODE").trim();
				activityType = (rsTrv.getString("ACTIVITY_TYPE") == null) ?"":rsTrv.getString("ACTIVITY_TYPE").trim();
				//overNight = (rsTrv.getString("OVER_NIGHT") == null) ?"":rsTrv.getString("OVER_NIGHT").trim();
			}
			rsTrv.close(); rsTrv = null;
			pstmtTrv.close(); pstmtTrv = null;

			if(!("LEAVE".equalsIgnoreCase(activityType) || "NFW".equalsIgnoreCase(activityType)))
			{
				String stanCodeSql = "SELECT ST.LOCALITY_CODE, ST.TRAVEL_DATE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
									" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
									" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ?) " +
									//" AND (DR_VISIT ='Y' OR CHEM_VISIT ='Y')" + //Commented and AND Below Changes done by Shahu Mali on 10-MAR-14
									" AND (WSELLER_VISIT ='Y' OR DISTBR_VISIT ='Y' OR MTRADER_VISIT='Y') "+
									") "+
									" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
									" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ? )";
				pstmt =  con.prepareStatement(stanCodeSql);
				pstmt.setString(1, userId );
				pstmt.setString(2, userId );
				pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(4, userId );
				pstmt.setString(5, userId );
				pstmt.setTimestamp( 6, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

				rs = pstmt.executeQuery();

				if(rs.next())
				{
					localityCodeFrom = (rs.getString(1) == null)?"":rs.getString(1).trim();
					travelDate = rs.getTimestamp("TRAVEL_DATE");
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				int overNightCount = 0;
				String checkOverNightSql = "SELECT COUNT(1) AS COUNT FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ? AND OVER_NIGHT = 'Y'";
				PreparedStatement pstmtOverNight = con.prepareStatement(checkOverNightSql);
				pstmtOverNight.setString(1, userId );
				pstmtOverNight.setTimestamp(2, travelDate);
				ResultSet rsOverNight = pstmtOverNight.executeQuery();
				if(rsOverNight.next())
				{
					overNightCount = rsOverNight.getInt("COUNT");
				}
				rsOverNight.close(); rsOverNight = null;
				pstmtOverNight.close(); pstmtOverNight = null;

				if(overNightCount > 0)
				{
					overNight = "Y";
				}
				else
				{
					overNight = "N";
				}
			}
			stanCodeFrom[0] = localityCodeFrom;
			stanCodeFrom[1] = overNight;

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :StrgMeetWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null && isLocalConn)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e1){}
		}
		System.out.println("localityCodeFrom =["+localityCodeFrom+"], overNight =["+overNight+"]");
		//return localityCodeFrom;
		return stanCodeFrom;
	}
   //Added By Shahu Mali on 12-FEB-14.END
	//Added By Shahu Mali on 12-FEB-14.START
	public String[] getPlaceOfReturnFrom( Connection con, String userId, String eventDate ) throws ITMException
	{


		System.out.println("getPlaceOfReturnFrom......Called event_date=["+eventDate+"]");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String  []localityCodeFrom = new String[2];
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			String activityType = "";
			String sprsTrvSql = "SELECT A.LOCALITY_CODE, A.ACTIVITY_CODE, B.ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
								" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
								" AND A.TRAVEL_DATE = (SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ? )";

			PreparedStatement pstmtTrv = con.prepareStatement(sprsTrvSql);
			pstmtTrv.setString(1, userId );
			pstmtTrv.setString(2, userId );
			pstmtTrv.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

			ResultSet rsTrv = pstmtTrv.executeQuery();
			if(rsTrv.next())
			{
				localityCodeFrom[0] = (rsTrv.getString("LOCALITY_CODE") == null) ?"":rsTrv.getString("LOCALITY_CODE").trim();
				localityCodeFrom[1] = (rsTrv.getString("LOC_DESCR") == null) ?"":rsTrv.getString("LOC_DESCR").trim();
				activityType = (rsTrv.getString("ACTIVITY_TYPE") == null) ?"":rsTrv.getString("ACTIVITY_TYPE").trim();
			}
			rsTrv.close(); rsTrv = null;
			pstmtTrv.close(); pstmtTrv = null;

			if(!("LEAVE".equalsIgnoreCase(activityType) || "NFW".equalsIgnoreCase(activityType)))
			{
				String stanCodeSql = " SELECT ST.LOCALITY_CODE , LOC.descr FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
									 " WHERE LOC.LOCALITY_CODE = ST.LOCALITY_CODE  "+
									 " AND  SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=? and TRAVEL_DATE < ? )  "+
									 " AND ST.OVER_NIGHT='Y'";
				pstmt =  con.prepareStatement(stanCodeSql);
				pstmt.setString(1, userId );
				pstmt.setString(2, userId );
				pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
				rs = pstmt.executeQuery();

				if(rs.next())
				{
					localityCodeFrom[0] = rs.getString(1);
					localityCodeFrom[1] = rs.getString(2);

				}

				System.out.println("getPlaceOfReturnFrom......CalledlocalityCodeFrom[0].."+localityCodeFrom[0]+"localityCodeFrom[1].."+localityCodeFrom[1]);

				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :StrgMeetWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}

		return localityCodeFrom ;
	}
	//Added By Shahu Mali on 12-FEB-14.END
	//Added By Shahu Mali on 12-FEB-14.START
	public String getLastStanCode( String salesPers, String eventDate ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		Connection conn = null;
		String localityDescr = "";
		String planDataStr="";
		StringBuffer valueXmlString = new StringBuffer();
		java.sql.Timestamp travelDate = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );

			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( "" ).append( "</editFlag>\r\n</Header>\r\n<Errors>\r\n</Errors>\r\n" );
			valueXmlString.append( "<Detail1 domID='1'>\r\n" );

			String activityType = "";
			String overNight = "";

			String sprsTrvSql = "SELECT A.LOCALITY_CODE, A.OVER_NIGHT, B.ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
								" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
								" AND A.TRAVEL_DATE = (SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ? )";

			PreparedStatement pstmtTrv = conn.prepareStatement(sprsTrvSql);
			pstmtTrv.setString(1, salesPers );
			pstmtTrv.setString(2, salesPers );
			pstmtTrv.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

			ResultSet rsTrv = pstmtTrv.executeQuery();
			if(rsTrv.next())
			{
				localityCodeFrom = (rsTrv.getString("LOCALITY_CODE") == null) ?"":rsTrv.getString("LOCALITY_CODE").trim();
				localityDescr = (rsTrv.getString("LOC_DESCR") == null) ?"":rsTrv.getString("LOC_DESCR").trim();
				activityType = (rsTrv.getString("ACTIVITY_TYPE") == null) ?"":rsTrv.getString("ACTIVITY_TYPE").trim();
				//overNight = (rsTrv.getString("OVER_NIGHT") == null) ?"":rsTrv.getString("OVER_NIGHT").trim();
			}
			rsTrv.close(); rsTrv = null;
			pstmtTrv.close(); pstmtTrv = null;

			System.out.println("localityCodeFrom=["+localityCodeFrom+"]");
			if(!("LEAVE".equalsIgnoreCase(activityType) || "NFW".equalsIgnoreCase(activityType)))
			{

				String stanCodeSql = "SELECT ST.LOCALITY_CODE AS LOC_CODE, ST.TRAVEL_DATE AS TRAVEL_DATE, LOC.DESCR AS LOC_DESCR FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
									" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
									" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ?) " +
									//" AND (DR_VISIT ='Y' OR CHEM_VISIT ='Y')) "+
									" AND (WSELLER_VISIT ='Y' OR DISTBR_VISIT ='Y' OR MTRADER_VISIT='Y')) "+
									" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
									" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ?) ";
				pstmt =  conn.prepareStatement(stanCodeSql);
				pstmt.setString(1, salesPers );
				pstmt.setString(2, salesPers );
				pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(4, salesPers );
				pstmt.setString(5, salesPers );
				pstmt.setTimestamp( 6, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

				rs = pstmt.executeQuery();

				System.out.println("Inside method getStanCodeFrom eventDate"+eventDate);
				if(rs.next())
				{
					localityCodeFrom = (rs.getString("LOC_CODE") == null)?"":rs.getString("LOC_CODE").trim();
					localityDescr = (rs.getString("LOC_DESCR") == null)?"":rs.getString("LOC_DESCR").trim();
					travelDate = rs.getTimestamp("TRAVEL_DATE");
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				int overNightCount = 0;
				String checkOverNightSql = "SELECT COUNT(1) AS COUNT FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ? AND OVER_NIGHT = 'Y'";
				PreparedStatement pstmtOverNight = conn.prepareStatement(checkOverNightSql);
				pstmtOverNight.setString(1, salesPers );
				pstmtOverNight.setTimestamp(2, travelDate);
				ResultSet rsOverNight = pstmtOverNight.executeQuery();
				if(rsOverNight.next())
				{
					overNightCount = rsOverNight.getInt("COUNT");
				}
				rsOverNight.close(); rsOverNight = null;
				pstmtOverNight.close(); pstmtOverNight = null;

				System.out.println("overNightCount =["+overNightCount+"]");

				if(overNightCount > 0)
				{
					overNight = "Y";
				}
				else
				{
					overNight = "N";
				}

				//Getting last place of return
				if(overNight != null && "Y".equalsIgnoreCase(overNight))
				{
					String placeOfReturn[] = getPlaceOfReturnFrom(conn, salesPers, eventDate);
					if(placeOfReturn.length > 0)
					{
						valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( placeOfReturn[0] ).append( "]]></last_place_of_return>\r\n" );
						valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(placeOfReturn[1]).append( "]]></last_place_of_descr_return>\r\n" );
					}
				}
				else
				{
					valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( localityCodeFrom ).append( "]]></last_place_of_return>\r\n" );
					valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(localityDescr).append( "]]></last_place_of_descr_return>\r\n" );

				}
			}
			else
			{
				valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( localityCodeFrom ).append( "]]></last_place_of_return>\r\n" );
				valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(localityDescr).append( "]]></last_place_of_descr_return>\r\n" );
			}
			valueXmlString.append( "<sprs_route_locality_code><![CDATA[" ).append( localityCodeFrom ).append( "]]></sprs_route_locality_code>\r\n" );
			valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( localityDescr ).append( "]]></sprs_route_descr>\r\n" );
			//Added By Shahu Mali on 14-FEB-14.START
			planDataStr=getDSRPlanData(salesPers, eventDate);
			//--valueXmlString.append( "<dsr_plan_data>").append(planDataStr).append( "</dsr_plan_data>\r\n" );
			valueXmlString.append( planDataStr);
			//Added By Shahu Mali on 14-FEB-14.END
			valueXmlString.append("</Detail1>\r\n");
			valueXmlString.append("</Root>\r\n");

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :StrgMeetWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1){}
		}

		return valueXmlString.toString();
	}
	//Added By Shahu Mali on 12-FEB-14.END
	//to get Activity type
	private String getActivityType( String actCode )throws ITMException
	{
		String sql = "";
		String actType = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;

		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );

			sql = "SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, actCode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				actType = rs.getString("ACTIVITY_TYPE");
				actType = checkNull(actType).toUpperCase();
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return actType;
	}

	public String getCustTypeVisitList(Document dom, String currentForm) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer custTypeVisitBuf = new StringBuffer();
		ArrayList custTypeVisitList = new ArrayList();
		String sql = "";
		String columnValue = "";

		try
		{

			GenericUtility genericUtility = GenericUtility.getInstance();

			System.out.println("dom2:::"+genericUtility.serializeDom(dom));

			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}

					if( childNode.getNodeName().equalsIgnoreCase("wseller_visit") && columnValue != null && columnValue.equals("Y"))
					{
						if ( custTypeVisitList.contains("W"))
						{
							continue;
						}
						else
						{
							custTypeVisitList.add("W");
						}
						if(custTypeVisitBuf.length() == 0)
						{
							custTypeVisitBuf.append("'").append("W".toUpperCase()).append("'");
						}
						else
						{
							custTypeVisitBuf.append(",'").append("W".toUpperCase()).append("'");
						}

					}
					else if( childNode.getNodeName().equalsIgnoreCase("distbr_visit") && columnValue != null && columnValue.equals("Y") )
					{
						if ( custTypeVisitList.contains("B"))
						{
							continue;
						}
						else
						{
							custTypeVisitList.add("B");
						}
						if(custTypeVisitBuf.length() == 0)
						{
							custTypeVisitBuf.append("'").append("B".toUpperCase()).append("'");
						}
						else
						{
							custTypeVisitBuf.append(",'").append("B".toUpperCase()).append("'");
						}

					}
					else if( childNode.getNodeName().equalsIgnoreCase("mtrader_visit")  && columnValue != null && columnValue.equals("Y"))
					{
						if ( custTypeVisitList.contains("T"))
						{
							continue;
						}
						else
						{
							custTypeVisitList.add("T");
						}
						if(custTypeVisitBuf.length() == 0)
						{
							custTypeVisitBuf.append("'").append("T".toUpperCase()).append("'");
						}
						else
						{
							custTypeVisitBuf.append(",'").append("T".toUpperCase()).append("'");
						}

					}
				}
			}

			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("custTypeVisitList::"+custTypeVisitList);

		return custTypeVisitBuf.toString() ;

	}

}

