/********************************************************
	Title : StrgCustDeactCancel
	Date  : 05/07/12
	Name  : RAKESH KUMAR
 ********************************************************/

package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.ejb.*;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.system.config.*;
import java.rmi.RemoteException;
import java.sql.*;
import javax.ejb.Stateless;
import javax.naming.InitialContext;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class StrgCustDeactCancel extends ActionHandlerEJB implements StrgCustDeactCancelLocal, StrgCustDeactCancelRemote
{
	//changed by Rahul Barve on 3-sep-2014
	//GenericUtility genericUtility = GenericUtility.getInstance();
	 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

	String retString = "";
	public String confirm() throws RemoteException
	{
		return "";
	}
	public String confirm(String tranId, String xtraParams, String forcedFlag) throws ITMException ,RemoteException
	{
		Connection conn = null;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		try
		{
			String sql="";
			String status="";
			String loadStatus="";
			ConnDriver conDriver = new ConnDriver();
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			conn = conDriver.getConnectDB("DriverITM");
			System.out.println("TraId is equal to==============>"+tranId);
			sql="select status,load_status from strgcust_deactive where tran_id= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				status=checkNull(rs.getString("status"));
				loadStatus=checkNull(rs.getString("load_status"));
			}
			if("Y".equalsIgnoreCase(loadStatus))
			{
				retString = itmDBAccessLocal.getErrorString("","DRDEACTY","");
			}
			else if("X".equalsIgnoreCase(status))
			{
				retString = itmDBAccessLocal.getErrorString("","DRDEACTX","");
			}
			else if("N".equalsIgnoreCase(loadStatus))
			{
				sql="update strgcust_deactive set status ='X' where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				int count = pstmt.executeUpdate();
				System.out.println("I equal to======="+count);
				if( count > 0 )
				{
					conn.commit();
					System.out.println("***********updated sucessfully*************");
					retString = itmDBAccessLocal.getErrorString("","DRDEACTN","");
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("Closing Connection....");
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs=null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(conn !=null)
				{
					conn.close();
					conn=null;
				}
			}catch(Exception e)
			{
				System.out.println("Exception ::"+e.getMessage());
			}
		}
		return retString;
	}
	private String checkNull(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value;
	}
} //confirm end

