package ibase.webitm.ejb.wsfa.masters;

/*
  Name : EmpUsrSpPos
  Purpose : Franco requires a common screen for user, sales person and employee master in WSFA.
            Migration of Employee Master from EJB2 to EJB3 .
  Developed By : Shahu Mali
  Date :22-MAR-13
*/
import java.rmi.RemoteException;
import java.util.*;
import java.util.Date;
import java.text.DateFormat;
import java.sql.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import java.text.SimpleDateFormat;

import ibase.utility.CommonConstants;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;
//import ibase.webitm.utility.GenericUtility;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class WsfaEmpUsrSpPos extends ValidatorEJB implements WsfaEmpUsrSpPosLocal,WsfaEmpUsrSpPosRemote
{
	protected static String database = CommonConstants.DB_NAME;
 	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String tranId,String editFlag, String xtraParams, Connection conn, String domString) throws RemoteException,ITMException
	{

		String pkValues = null;
		PreparedStatement pStmtEmployee = null;
		PreparedStatement pStmtUsers = null;
		PreparedStatement pStmtSalesPers = null;

		PreparedStatement pStmtEmp = null;
		PreparedStatement pStmtUsr = null;
		PreparedStatement pStmtSp = null;

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		StringBuffer insEmployee = new StringBuffer();
		StringBuffer insUsers = new StringBuffer();
		StringBuffer insSprs = new StringBuffer();
		String sqlEmp = "SELECT COUNT(*) AS EMPCOUNT FROM EMPLOYEE WHERE EMP_CODE=?";
		String sqlUsr = "SELECT COUNT(*) AS USRCOUNT FROM USERS WHERE CODE=?";
		String sqlSp = "SELECT COUNT(*) AS SPCOUNT FROM SALES_PERS WHERE SALES_PERS=?";

		try
		{

			System.out.println("domString["+domString+"]");

			/*if( !editFlag.equalsIgnoreCase("E") )
			{*/
				if (conn == null)
				{
					/*ConnDriver connDriver = null;
					connDriver = new ConnDriver();
					conn = connDriver.getConnectDB("DriverITM");*/
					conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				}

				Document dom = genericUtility.parseString(domString);
				//String objName  = getObjNameFromDom(dom,"objName");
				//String pkValues = getObjNameFromDom(dom,"dbID");
				//System.out.println("objName:selSql"+objName);
				//System.out.println("pkValues:selSql"+pkValues);
				//For Updating Employee start
				String empCode = checkNull(genericUtility.getColumnValue("emp_code",dom));
				String empFname = checkNull(genericUtility.getColumnValue("emp_fname",dom));
				String empMname = checkNull(genericUtility.getColumnValue("emp_mname",dom));
				String empLname = checkNull(genericUtility.getColumnValue("emp_lname",dom));
				//Added variable by satya [WS89FRA008].start
				String fullName = (empFname.trim() + " " + empMname.trim() + " " + empLname.trim());
				if (fullName.length() > 40)
				{
					fullName    = fullName.substring(0,40);
				}
				//Added variable by satya [WS89FRA008].end
				String namePrefix = checkNull(genericUtility.getColumnValue("name_prefix",dom));
				String sex = checkNull(genericUtility.getColumnValue("sex",dom));
				String empType= checkNull(genericUtility.getColumnValue("emp_type",dom));
				String designCode= checkNull(genericUtility.getColumnValue("design_code",dom));
				String designation= checkNull(genericUtility.getColumnValue("designation",dom));
				String deptCode= checkNull(genericUtility.getColumnValue("dept_code",dom));
				String grade= checkNull(genericUtility.getColumnValue("grade",dom));
				String cadre= checkNull(genericUtility.getColumnValue("cadre",dom));
				String report_to = checkNull(genericUtility.getColumnValue("report_to",dom));
				String curAdd1 = checkNull(genericUtility.getColumnValue("cur_add1",dom));
				String curAdd2 = checkNull(genericUtility.getColumnValue("cur_add2",dom));
				String curAdd3 = checkNull(genericUtility.getColumnValue("cur_add3",dom));
				String curCity = checkNull(genericUtility.getColumnValue("cur_city",dom));
				String curState = checkNull(genericUtility.getColumnValue("cur_state",dom));
				String curPin = checkNull(genericUtility.getColumnValue("cur_pin",dom));
				String curTel1 = checkNull(genericUtility.getColumnValue("cur_tel1",dom));
				String curTel2 = checkNull(genericUtility.getColumnValue("cur_tel2",dom));
				String curTel3 = checkNull(genericUtility.getColumnValue("cur_tel3",dom));
				String birthDate = checkNull(genericUtility.getColumnValue("birth_date",dom));
				birthDate = genericUtility.getValidDateString(checkNull(birthDate),genericUtility.getApplDateFormat(),genericUtility.getDBDateTimeFormat());
				String dateJoin = genericUtility.getColumnValue("date_join",dom);
				dateJoin = genericUtility.getValidDateString(checkNull(dateJoin),genericUtility.getApplDateFormat(),genericUtility.getDBDateTimeFormat());
				String holTblno = genericUtility.getColumnValue("hol_tblno",dom);
				String empSite = checkNull(genericUtility.getColumnValue("emp_site",dom));
				String shortName = checkNull(genericUtility.getColumnValue("short_name",dom));
				if (shortName.length() > 20)
				{
					shortName = shortName.substring(0,20);
				}
				String stanCodeHq = checkNull(genericUtility.getColumnValue("stan_code__hq",dom));
				String mobileNo = checkNull(genericUtility.getColumnValue("mobile_no",dom)); // Added by Piyush on 28/04/2010 [WS89FRA008]
				String emailIdOff = checkNull(genericUtility.getColumnValue("email_id_off",dom));
				String emailIdPer = checkNull(genericUtility.getColumnValue("email_id_per",dom));
				String createUser = checkNull(genericUtility.getColumnValue("create_user",dom));
				String createSalesPers = checkNull(genericUtility.getColumnValue("create_sales_pers",dom));

				java.util.Calendar dateCreated = java.util.Calendar.getInstance();
				java.text.DateFormat df = new java.text.SimpleDateFormat(GenericUtility.getInstance().getDBDateTimeFormat());
				String chgDate = df.format(dateCreated.getTime());
				String chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
				String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");

				int empCtr = 0;
				pStmtEmp = conn.prepareStatement(sqlEmp);
				pStmtEmp.setString(1,empCode);

				ResultSet rsEmp = pStmtEmp.executeQuery();
				if(rsEmp.next())
				{
					empCtr = rsEmp.getInt("EMPCOUNT");
				}

				rsEmp.close();
				rsEmp = null;
				pStmtEmp.close();
				pStmtEmp = null;

				if(empCtr <= 0)
				{
					insEmployee.append("INSERT INTO EMPLOYEE(EMP_CODE , EMP_FNAME , EMP_MNAME,");
					insEmployee.append("EMP_LNAME ,NAME_PREFIX, SEX, EMP_TYPE ,DESIGN_CODE , DESIGNATION , DEPT_CODE ,");
					insEmployee.append("GRADE, CADRE, REPORT_TO , CUR_ADD1 , CUR_ADD2 ,CUR_ADD3 , CUR_CITY ,");
					insEmployee.append("CUR_STATE , CUR_PIN , CUR_TEL1 , CUR_TEL2 , CUR_TEL3 , BIRTH_DATE ,");
					insEmployee.append("DATE_JOIN , HOL_TBLNO , EMP_SITE,PAY_SITE,WORK_SITE , SHORT_NAME , STAN_CODE__HQ ,");
					insEmployee.append("MOBILE_NO , EMAIL_ID_OFF ,EMAIL_ID_PER,CHG_DATE,CHG_USER,CHG_TERM)");
					insEmployee.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,");
					insEmployee.append("?,?,?,?,?,?,?,?,?,?,?,");
					insEmployee.append("?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

				}
				else
				{

					insEmployee.append("UPDATE EMPLOYEE SET EMP_CODE = ? , EMP_FNAME = ? , EMP_MNAME = ?,");
					insEmployee.append("EMP_LNAME = ? ,NAME_PREFIX = ?, SEX = ?, EMP_TYPE = ? ,DESIGN_CODE = ? , DESIGNATION = ? , DEPT_CODE = ? ,");
					insEmployee.append("GRADE = ?, CADRE = ?, REPORT_TO = ? , CUR_ADD1 = ? , CUR_ADD2 = ? ,CUR_ADD3 = ? , CUR_CITY = ? ,");
					insEmployee.append("CUR_STATE = ? , CUR_PIN = ? , CUR_TEL1 = ? , CUR_TEL2 = ? , CUR_TEL3 = ? , BIRTH_DATE = ? ,");
					insEmployee.append("DATE_JOIN = ? , HOL_TBLNO = ? , EMP_SITE = ? ,PAY_SITE = ?,WORK_SITE = ? , SHORT_NAME = ? , STAN_CODE__HQ = ? ,");
					insEmployee.append("MOBILE_NO = ? , EMAIL_ID_OFF = ? ,EMAIL_ID_PER = ?,CHG_DATE = ?,CHG_USER = ?,CHG_TERM = ? ");
					insEmployee.append("WHERE EMP_CODE = '"+empCode+"'");
				}

				pStmtEmployee = conn.prepareStatement(insEmployee.toString());

				pStmtEmployee.setString(1,empCode);
				pStmtEmployee.setString(2,empFname);
				pStmtEmployee.setString(3,empMname);
				pStmtEmployee.setString(4,empLname);
				pStmtEmployee.setString(5,namePrefix);
				pStmtEmployee.setString(6,sex);
				pStmtEmployee.setString(7,empType);
				pStmtEmployee.setString(8,designCode);
				pStmtEmployee.setString(9,designation);
				pStmtEmployee.setString(10,deptCode);
				pStmtEmployee.setString(11,grade);
				pStmtEmployee.setString(12,cadre);
				pStmtEmployee.setString(13,report_to);
				pStmtEmployee.setString(14,curAdd1);
				pStmtEmployee.setString(15,curAdd2);
				pStmtEmployee.setString(16,curAdd3);
				pStmtEmployee.setString(17,curCity);
				pStmtEmployee.setString(18,curState);
				pStmtEmployee.setString(19,curPin);
				pStmtEmployee.setString(20,curTel1);
				pStmtEmployee.setString(21,curTel2);
				pStmtEmployee.setString(22,curTel3);
				pStmtEmployee.setTimestamp(23,java.sql.Timestamp.valueOf(birthDate));
				pStmtEmployee.setTimestamp(24,java.sql.Timestamp.valueOf(dateJoin));
				pStmtEmployee.setString(25,holTblno);
				pStmtEmployee.setString(26,empSite);
				pStmtEmployee.setString(27,empSite);
				pStmtEmployee.setString(28,empSite);
				pStmtEmployee.setString(29,shortName);
				pStmtEmployee.setString(30,stanCodeHq);
				// Remarked and changed bellow by Piyush on 28/04/2010 [WS89FRA008].Start
				//pStmtEmployee.setString(31,stanCodeHq);
				pStmtEmployee.setString(31,mobileNo);
				pStmtEmployee.setString(32,emailIdOff);
				pStmtEmployee.setString(33,emailIdPer);
				// Remarked by Piyush - 28/04/2010 [WS89FRA008].Start
				//pStmtEmployee.setString(34,createUser);
				//pStmtEmployee.setString(35,createSalesPers);
				// Remarked by Piyush - 28/04/2010 [WS89FRA008].End
				pStmtEmployee.setTimestamp(34,java.sql.Timestamp.valueOf(chgDate));
				pStmtEmployee.setString(35,chgUser);
				pStmtEmployee.setString(36,chgTerm);

				int empUpd = pStmtEmployee.executeUpdate();
				pStmtEmployee.close();
				pStmtEmployee = null;

				if(empUpd <= 0)
				{
					 throw new Exception();
				}

				//For Updating Employyee end

				//For Updating Users.start
				if(createUser.equalsIgnoreCase("Y"))
				{

					String	userCode = checkNull(genericUtility.getColumnValue("user_code",dom));
					String	userPwd	= checkNull(genericUtility.getColumnValue("user_pwd",dom));
					String	usrLev		= checkNull(genericUtility.getColumnValue("usr_lev",dom));
					String	delayPrd	= checkNull(genericUtility.getColumnValue("delay_prd",dom));
					String	userType	= checkNull(genericUtility.getColumnValue("user_type",dom));
					String	passwdFreq	= checkNull(genericUtility.getColumnValue("passwd_freq",dom));
					String	lastPwdChgdate	= checkNull(genericUtility.getColumnValue("last_pwd_chgdate",dom));
					lastPwdChgdate = (lastPwdChgdate == null)?"":genericUtility.getValidDateString(lastPwdChgdate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateTimeFormat());
					String	ascertainAttendance 	= checkNull(genericUtility.getColumnValue("ascertain_attendance",dom));
					String	acctLock		= checkNull(genericUtility.getColumnValue("acct_lock",dom));
					String	loginFirst		= checkNull(genericUtility.getColumnValue("login_first",dom));
					String	wrongLoginCnt	= checkNull(genericUtility.getColumnValue("wrong_login_cnt",dom));
					String	profileIdRes 	= checkNull(genericUtility.getColumnValue("profile_id__res",dom));
					String	profileIdDisp 	= checkNull(genericUtility.getColumnValue("profile_id__disp",dom));
					String	profileId 	= checkNull(genericUtility.getColumnValue("profile_id",dom));
					String entityCode = "";
					if(userType.equalsIgnoreCase("P"))
					{
							entityCode = checkNull(genericUtility.getColumnValue("sales_pers",dom));//for
					}
					else if(userType.equalsIgnoreCase("E"))
					{
						entityCode = empCode;

					}
					else
					{
						entityCode = userCode;
					}


					pStmtUsr = conn.prepareStatement(sqlUsr);
					pStmtUsr.setString(1,userCode);
					int usrCtr = 0;
					ResultSet rsUsr = pStmtUsr.executeQuery();

					if(rsUsr.next())
					{
							usrCtr = rsUsr.getInt("USRCOUNT");
					}

					rsUsr.close();
					rsUsr = null;
					pStmtUsr.close();
					pStmtUsr = null;

					if(usrCtr <= 0)
					{
							insUsers.append("INSERT INTO USERS(CODE , PASS_WD ,USR_LEV ,DELAY_PRD ,USER_TYPE ,");
							insUsers.append("PASSWD_FREQ ,LAST_PWD_CHGDATE ,ASCERTAIN_ATTENDANCE ,ACCT_LOCK , "); // Coma is added after ACCT_LOCK by Piyush on 28/04/2010 [WS89FRA008]
							insUsers.append("LOGIN_FIRST ,WRONG_LOGIN_CNT ,PROFILE_ID__RES ,PROFILE_ID__DISP, ");
							//added parameter profileId by satya on 03/05/2010 [WS89FRA008].start
							insUsers.append("ENTITY_CODE,CHG_DATE,CHG_USER,CHG_TERM,EMP_CODE, PROFILE_ID , NAME, STATUS )");
							//added parameter profileId by satya on 03/05/2010 [WS89FRA008].end
							insUsers.append("VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'A')");

					}
					else
					{
							insUsers.append("UPDATE USERS SET CODE = ? ,PASS_WD = ? ,USR_LEV = ? ,DELAY_PRD = ? ,USER_TYPE = ? ,");
							insUsers.append("PASSWD_FREQ = ? ,LAST_PWD_CHGDATE = ? ,ASCERTAIN_ATTENDANCE = ? ,ACCT_LOCK = ? , "); // Coma is added after ACCT_LOCK by Piyush on 28/04/2010 [WS89FRA008]
							insUsers.append("LOGIN_FIRST = ? ,WRONG_LOGIN_CNT = ? ,PROFILE_ID__RES = ? ,PROFILE_ID__DISP = ?, ");
							//added parameter profileId by satya on 03/05/2010 [WS89FRA008].start
							insUsers.append("ENTITY_CODE = ?,CHG_DATE = ?,CHG_USER = ?,CHG_TERM = ? , EMP_CODE = ?, PROFILE_ID = ?, NAME = ? , PASS_WD_SHA = null " ); // PASS_WD_SHA Added by Kailash Pal on [22-Jan-18].
							//added parameter profileId by satya on 03/05/2010 [WS89FRA008].end
							insUsers.append("WHERE CODE = '"+userCode+"'");
					}

					pStmtUsers = conn.prepareStatement(insUsers.toString());
					pStmtUsers.setString(1,userCode);
					pStmtUsers.setString(2,userPwd);
					pStmtUsers.setInt(3,Integer.parseInt(usrLev));
					pStmtUsers.setInt(4,Integer.parseInt(delayPrd));
					pStmtUsers.setString(5,userType);
					pStmtUsers.setInt(6,Integer.parseInt(passwdFreq));
					//Commented and changes by Gulzar on 02/10/13 as lastPwdChgdate may be null or  "" value :: START
					pStmtUsers.setTimestamp(7,java.sql.Timestamp.valueOf(lastPwdChgdate));
					//pStmtUsers.setString(7,lastPwdChgdate);//Changed by Gulzar on 02/10/13
					//changes by Gulzar on 02/10/13 as lastPwdChgdate may be null or  "" value : END
					pStmtUsers.setString(8,ascertainAttendance);
					pStmtUsers.setString(9,acctLock);
					pStmtUsers.setString(10,loginFirst);
					pStmtUsers.setInt(11,Integer.parseInt(wrongLoginCnt));
					pStmtUsers.setString(12,profileIdRes);
					pStmtUsers.setString(13,profileIdDisp);
					pStmtUsers.setString(14,entityCode);//for entity_code
					pStmtUsers.setTimestamp(15,java.sql.Timestamp.valueOf(chgDate));
					pStmtUsers.setString(16,chgUser);
					pStmtUsers.setString(17,chgTerm);
					pStmtUsers.setString(18,empCode);
					//added parameter profileId and changed parameter name from shortName to fullname by satya on 03/05/2010 [WS89FRA008].start
					pStmtUsers.setString(19,profileId);
					pStmtUsers.setString(20,fullName);
					//added parameter profileId and changed parameter name from shortName to fullname by satya on 03/05/2010 [WS89FRA008].end
					int usrUpd = pStmtUsers.executeUpdate();
					pStmtUsers.close();
					pStmtUsers = null;

					if(usrUpd <= 0)
					{
						 throw new Exception("Users not Updated......");
					}

				}
				//For Updating Users.end

				//For Updating SalesPerson.start
				if(createSalesPers.equalsIgnoreCase("Y"))
				{
					String	salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
					String	spType	   = checkNull(genericUtility.getColumnValue("sp_type",dom));
					String	itemSer   = checkNull(genericUtility.getColumnValue("item_ser",dom));
					String	lockStatus= checkNull(genericUtility.getColumnValue("lock_status",dom));
					String	active	   = checkNull(genericUtility.getColumnValue("active",dom));
					String	autoConf  = checkNull(genericUtility.getColumnValue("auto_conf",dom));

					int spCtr = 0;
					pStmtSp = conn.prepareStatement(sqlSp);
					pStmtSp.setString(1,salesPers);
					ResultSet rsSp = pStmtSp.executeQuery();
					if(rsSp.next())
					{
						spCtr = rsSp.getInt("SPCOUNT");
					}
					rsSp.close();
					rsSp = null;
					pStmtSp.close();
					pStmtSp = null;

					if(spCtr <= 0)
					{
						insSprs.append("INSERT INTO SALES_PERS(SALES_PERS ,SP_TYPE ,ITEM_SER ,LOCK_STATUS,");
						insSprs.append("ACTIVE ,AUTO_CONF,CHG_DATE,CHG_USER,CHG_TERM,EMP_CODE,SP_NAME,SH_NAME) ");
						insSprs.append("VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
					}
					else
					{
						insSprs.append("UPDATE SALES_PERS SET SALES_PERS = ? ,SP_TYPE = ?,ITEM_SER = ? ,LOCK_STATUS = ?,");
						insSprs.append("ACTIVE = ? ,AUTO_CONF = ?,CHG_DATE = ?,CHG_USER = ?,CHG_TERM = ?,EMP_CODE = ?, SP_NAME = ?, SH_NAME = ? ");
						insSprs.append("WHERE SALES_PERS='"+salesPers+"'");
					}

					pStmtSalesPers = conn.prepareStatement(insSprs.toString());
					pStmtSalesPers.setString(1,salesPers);
					pStmtSalesPers.setString(2,spType);
					pStmtSalesPers.setString(3,itemSer);
					pStmtSalesPers.setString(4,lockStatus);
					pStmtSalesPers.setString(5,active);
					pStmtSalesPers.setString(6,autoConf);
					pStmtSalesPers.setTimestamp(7,java.sql.Timestamp.valueOf(chgDate));
					pStmtSalesPers.setString(8,chgUser);
					pStmtSalesPers.setString(9,chgTerm);
					pStmtSalesPers.setString(10,empCode);
					//changed parameter name to fullName from shortName by satya on 03/05/2010 [WS89FRA008].start
					pStmtSalesPers.setString(11,fullName);
					pStmtSalesPers.setString(12,shortName);
					//changed parameter name to fullName from shortName by satya on 03/05/2010 [WS89FRA008].end

					int sprsUpd = pStmtSalesPers.executeUpdate();
					pStmtSalesPers.close();
					pStmtSalesPers = null;

					if(sprsUpd <= 0)
					{
						 throw new Exception("Sales Person not Updated......");
					}

				}
				//For Updating SalesPerson.end

			//}if block if( !editFlag.equalsIgnoreCase("E") )

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{

			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}


		}
		return "";
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
}