/**
Title : SFAPlanParamPos
Date  : 02/02/2017
Author: Samadhan Pawar
Request Id: W16JJOH003
*/

package ibase.webitm.ejb.wsfa.masters;

import ibase.webitm.ejb.ValidatorEJB;

import ibase.utility.E12GenericUtility;

import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;

import javax.ejb.Stateless;


import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


//@Stateless        	commented by Sagar M [22 Nov 2018].
public class SFAPlanParamPos extends ValidatorEJB implements SFAPlanParamPosRemote,SFAPlanParamPosLocal
{

	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String tranId, String editFlag, String xtraParams, Connection conn, String domString) throws RemoteException,ITMException
	{
		String retString = "";
		String columnValue = "";
		String columnName = "";

		PreparedStatement pstmt = null;
		ResultSet rs = null;

		Document dom = null;
		NodeList parentList = null;

		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		int workdays = 0;
		String userId="";//added by shraddha M[24/08/2020]
		String periodCode = "",empCode = "";
		Timestamp dateFrom = null;
		Timestamp dateTo= null;

		try
		{
			//conn=getConnection();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			dom = genericUtility.parseString(domString);

			System.out.println("tranId"+tranId);
			System.out.println("editFlag"+editFlag);
			System.out.println("xtraParam"+xtraParams);
			System.out.println("domString**"+domString);
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");//added by shraddha M[24/08/2020]
			parentList = dom.getElementsByTagName( "Detail2");

			for ( int pctr = 0; pctr < parentList.getLength(); pctr++ )
			{
				parentNode = parentList.item( pctr);
				childList = parentNode.getChildNodes();
				for ( int ctr = 0; ctr < childList.getLength(); ctr++ )
				{
					childNode = childList.item(ctr);
					columnName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}

					System.out.println(" columnName [" + columnName + "] columnValue [" + columnValue + "]");
					if( "work_days".equalsIgnoreCase(columnName) )
					{
						//checking for blank value
						if ( childNode != null || childNode.getFirstChild() != null )
						{
							if(columnValue.trim().length() > 0)
							{
								System.out.println("Current Value for workdays ["+columnValue+"]");
								workdays += Integer.parseInt(columnValue.trim());
								System.out.println("Total Value for workdays ["+workdays+"]");
							}
						}
					}

				}
			}

			periodCode = genericUtility.checkNull(genericUtility.getColumnValue("prd_code", dom));

			if(periodCode.length() == 0 && periodCode.equalsIgnoreCase(""))
			{
				return getErrorString("prd_code", "NULPRDCODE", "");
			}

			String sql = "SELECT EMP_CODE FROM EMPLOYEE WHERE EMP_CODE IN (SELECT S.EMP_CODE FROM SALES_PERS S , PROPERTIES P WHERE P.ITEM_SER = S.ITEM_SER AND P.PROP_NAME = ?) AND HOL_TBLNO IS NOT NULL ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "PARAM_TABLE");
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				empCode = genericUtility.checkNull(rs.getString("EMP_CODE"));
			}
			//added By Nilesh Start::02-06-2017
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			//added By Nilesh End::02-06-2017

			String prdCodeSql = "SELECT FR_DATE,TO_DATE FROM PERIOD WHERE CODE = ?";
			pstmt = conn.prepareStatement( prdCodeSql );
			pstmt.setString(1, periodCode );
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				dateFrom = rs.getTimestamp("FR_DATE");
				dateTo = rs.getTimestamp("TO_DATE");
			}
			else
			{
				return getErrorString("prd_code", "INVPRDCOD", "");
			}
			//added By Nilesh Start::02-06-2017
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			//added By Nilesh End::02-06-2017
			//Changes by shraddha M to remove hardcoded itemser [24/08/2020]START
			String itemSerSql="";
			String itemSer="";
			itemSerSql= "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS= ?";
			pstmt = conn.prepareStatement(itemSerSql);
			pstmt.setString(1, userId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				itemSer = genericUtility.checkNull(rs.getString("ITEM_SER"));
				System.out.println("itemSer value:::["+itemSer+"]");
			}
			//added By Nilesh Start::02-06-2017
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			//added By Nilesh End::02-06-2017
			//Changes by shraddha M to remove hardcoded itemser [24/08/2020]END
			
			int diffInDays = (int)( (dateTo.getTime() - dateFrom.getTime()) / (1000 * 60 * 60 * 24) )	;
			SFAPlanParamIC sfaAdminIc = new SFAPlanParamIC();
			//int workingDays = ( (diffInDays+1) - sfaAdminIc.getHolidayCount(conn, empCode, dateFrom, dateTo) );
			//int workingDays = sfaAdminIc.getWorkingDays(conn, dateFrom, dateTo);
			int workingDays = sfaAdminIc.getWorkingDays(conn, dateFrom, dateTo,itemSer);//Changes by shraddha M to remove hardcoded itemser [24/08/2020]
			if(workingDays != workdays)
			{
				return getErrorString("", "INVWRKDAYS", "");
			}

		}
		catch(Exception e)
		{
			System.out.println("Exception :SFAPlanParamPos : :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//added By Nilesh Start::02-06-2017
                if(rs!=null)
                {
                    rs.close();
                    rs=null;
                }
                if(pstmt!=null)
                {
                    pstmt.close();
                    pstmt=null;
                }
			//added By Nilesh End::02-06-2017
			}
			catch(Exception e)
			{
				System.out.println("Exception :SFAPlanParamPos : :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return string :"+retString);
		return retString;
	}
}



