
/********************************************************
	Title : MPLSubBuLink
	Date  : 11/06/2012
	Developer: Dipak Chattar

 ********************************************************/

package ibase.webitm.ejb.wsfa.masters;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.text.SimpleDateFormat;
import java.util.*;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.ejb.Stateless;


//@Stateless 		commented by Sagar M [22 Nov 2018].
public class MPLSubBuLink extends ValidatorEJB implements MPLSubBuLinkLocal, MPLSubBuLinkRemote
{
	//changed by Rahul Barve on 3-sep-2014
	//GenericUtility genericUtility = GenericUtility.getInstance();
	 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();


	//method for validation
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("Val xmlString :: " + xmlString);
			System.out.println("Val xmlString1 :: " + xmlString1);
			System.out.println("Val xmlString2 :: " + xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			errString = wfValData(dom, dom1,dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}

	//method for validation
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String errorType = "";
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		String userId = "";
		String sql = "";
		String tranDate = "";
		String mplNoFrom = "";
		String mplNoTo = "";
		String masterId = "";
		String effFrom = "";
		String validUpto = "";

		int ctr=0;
		int cnt = 0;
		int currentFormNo = 0;
		int childNodeListLength;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();

		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		/*ConnDriver connDriver = new ConnDriver();*/
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			/*conn = connDriver.getConnectDB("DriverITM");*/
			conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("tran_date"))
					{
						tranDate = genericUtility.getColumnValue("tran_date", dom);
						System.out.println("************* tranDate ****************" + tranDate);

						if(tranDate == null || (tranDate.trim().length() == 0))
						{
							errList.add("VMTRANUL");
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if(childNodeName.equalsIgnoreCase("sub_bu_code"))
					{
						if(childNode.getFirstChild() == null)
						{
							errList.add("VSUBCODE1");
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if(childNodeName.equalsIgnoreCase("mpl_no__fr"))
					{
						mplNoFrom = genericUtility.getColumnValue("mpl_no__fr", dom);
						System.out.println("************* mplNoFrom ****************" + mplNoFrom);
						if(mplNoFrom == null || mplNoFrom.trim().length() == 0 )
						{
							errCode = "VMPLFNUL";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else if(mplNoFrom !=null && mplNoFrom.trim().length() > 0 && Integer.parseInt(mplNoFrom) <=0)
						{
							errCode = "VMPLFINV";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if(childNodeName.equalsIgnoreCase("mpl_no__to"))
					{
						mplNoTo = genericUtility.getColumnValue("mpl_no__to", dom);
						System.out.println("************* mplNoTo ****************" + mplNoTo);

						if(mplNoTo == null || mplNoTo.trim().length() == 0)
						{
							errCode = "VMPLTNUL";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else if(mplNoTo !=null && mplNoTo.trim().length() > 0 && Integer.parseInt(mplNoTo) <=0)
						{
							errCode = "VMPLTINV";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("eff_from"))
					{
						effFrom = genericUtility.getColumnValue("eff_from",dom);

						if ( effFrom == null || effFrom.trim().trim().length() == 0 )
						{
							errCode = "VMNULEFDT";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							java.util.Date sDate = simpleDateFormat.parse(effFrom);
							java.sql.Date subBUeffFrom = null;
							masterId = genericUtility.getColumnValue("master_id",dom);
							String subBuValidUptoSql = "select eff_from from sub_bu_validity where master_id = ? ";
							pstmt =  conn.prepareStatement(subBuValidUptoSql);
							pstmt.setString(1,masterId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								subBUeffFrom =  rs.getDate("eff_from");
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if ( sDate.before(subBUeffFrom))
							{
								errCode="INVFRDATE";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("valid_upto"))
					{
						effFrom = genericUtility.getColumnValue("eff_from",dom);
						validUpto = genericUtility.getColumnValue("valid_upto",dom);

						if(validUpto == null || validUpto.trim().trim().length() == 0 )
						{
							errCode = "VMVLDUTNUL";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else if (effFrom != null && validUpto != null )
						{
							java.util.Date sDate = simpleDateFormat.parse(effFrom);
							java.util.Date eDate = simpleDateFormat.parse(validUpto);
							if(sDate.compareTo(eDate) > 0)
							{
								errCode="VMSDLTED";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
							java.sql.Date subBUvalidUpto = null;
							masterId = genericUtility.getColumnValue("master_id",dom);
							String subBuValidUptoSql = "select valid_upto from sub_bu_validity where master_id = ? ";
							pstmt =  conn.prepareStatement(subBuValidUptoSql);
							pstmt.setString(1,masterId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								subBUvalidUpto =  rs.getDate("valid_upto");
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if ( eDate.after(subBUvalidUpto))
							{
								errCode="INVTODATE";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}

							mplNoFrom = checkNull(genericUtility.getColumnValue("mpl_no__fr", dom));
							mplNoTo = checkNull(genericUtility.getColumnValue("mpl_no__to", dom));

							if( mplNoFrom.trim().length() > 0 && mplNoTo.trim().length() > 0 )
							{
								effFrom		= genericUtility.getValidDateTimeString( effFrom, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat() );
								validUpto	= genericUtility.getValidDateTimeString( validUpto, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat() );

								/*
								sql = "SELECT COUNT(*) FROM mpl_sub_bu_link WHERE ("+
										"(mpl_no__fr <= ? AND mpl_no__to >= ?) "+
										"OR (mpl_no__fr <= ? AND mpl_no__to >= ?) "+
										"OR (mpl_no__fr >= ? AND mpl_no__fr <= ?) "+
										"OR (mpl_no__to >= ? AND mpl_no__to <= ?)) "+
										"AND ((EFF_FROM <= ? AND VALID_UPTO >= ?) "+
										"OR (EFF_FROM <= ? AND VALID_UPTO >= ?) "+
										"OR (EFF_FROM >= ? AND EFF_FROM <= ?) "+
										"OR (VALID_UPTO >= ? AND VALID_UPTO <= ?)) "+
										"and master_id = ? ";
									*/
								String subBUCode = checkNull(genericUtility.getColumnValue("sub_bu_code", dom));

								sql = "SELECT COUNT(*) FROM mpl_sub_bu_link a, sub_bu_validity b WHERE "+
										"a.master_id = b.master_id and "+
										"("+
											"(a.mpl_no__fr <= ? AND a.mpl_no__to >= ?) "+
											"OR (a.mpl_no__fr <= ? AND a.mpl_no__to >= ?) "+
											"OR (a.mpl_no__fr >= ? AND a.mpl_no__fr <= ?) "+
											"OR (a.mpl_no__to >= ? AND a.mpl_no__to <= ?) "+
										") "+
										"AND "+
										"("+
											"(a.EFF_FROM <= ? AND a.VALID_UPTO >= ?) "+
											"OR (a.EFF_FROM <= ? AND a.VALID_UPTO >= ?) "+
											"OR (a.EFF_FROM >= ? AND a.EFF_FROM <= ?) "+
											"OR (a.VALID_UPTO >= ? AND a.VALID_UPTO <= ?) "+
										") "+
										"and b.sub_bu_code = ? ";


								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,mplNoFrom);
								pstmt.setString(2,mplNoFrom);
								pstmt.setString(3,mplNoTo);
								pstmt.setString(4,mplNoTo);
								pstmt.setString(5,mplNoFrom);
								pstmt.setString(6,mplNoTo);
								pstmt.setString(7,mplNoFrom);
								pstmt.setString(8,mplNoTo);
								pstmt.setTimestamp(9,java.sql.Timestamp.valueOf(effFrom));
								pstmt.setTimestamp(10,java.sql.Timestamp.valueOf(effFrom));
								pstmt.setTimestamp(11,java.sql.Timestamp.valueOf(validUpto));
								pstmt.setTimestamp(12,java.sql.Timestamp.valueOf(validUpto));
								pstmt.setTimestamp(13,java.sql.Timestamp.valueOf(effFrom));
								pstmt.setTimestamp(14,java.sql.Timestamp.valueOf(validUpto));
								pstmt.setTimestamp(15,java.sql.Timestamp.valueOf(effFrom));
								pstmt.setTimestamp(16,java.sql.Timestamp.valueOf(validUpto));
								pstmt.setString(17,subBUCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if(cnt > 0)
								{
									errCode = "VMINVRNG";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("master_id"))
					{
						masterId = genericUtility.getColumnValue("master_id", dom);

						if(masterId == null || masterId.trim().length() == 0)
						{
							errCode = "VMMIDNUL";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							sql = " select count(*) from sub_bu_validity where master_id  = ?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,masterId);

							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0)
							{
								errCode = "VMINVMID";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

						}

					}

				}
				break;

			}//end switch
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}//end try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation

	// method for item change
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			valueXmlString = itemChanged(dom, dom1,dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [JvVal][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	// method for item change
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		String dateNow = "";
		String masterId = "";
		String subBuCode = "";
		String subBuName = "";
		String buCode = "";
		String buName = "";

		String sql = "";
		int currentFormNo = 0;
		java.sql.Date effFrom = null;
		java.sql.Date validUpTo = null;
		String effFromDate="";
		String validUpToDate="";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		/*ConnDriver connDriver = new ConnDriver();*/
		try
		{
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			conn.setAutoCommit(false);
			//connDriver = null;
			System.out.println("******************Inside ItemChange***********" );
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			switch(currentFormNo)
			{
			case 1 :
				valueXmlString.append("<Detail1>");

				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					dateNow = simpleDateFormat.format(currentDate.getTime());
					valueXmlString.append("<tran_date>").append("<![CDATA[" + dateNow + "]]>").append("</tran_date>");
					valueXmlString.append("<confirmed>").append("Y").append("</confirmed>");
				}//end of if
				else if(currentColumn.trim().equalsIgnoreCase("master_id"))
				{
					masterId = genericUtility.getColumnValue("master_id", dom);
					sql = "select eff_from,valid_upto from sub_bu_validity where master_id = ? ";
					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1,masterId);

					rs = pstmt.executeQuery();
					if(rs.next())
					{
						effFrom =  rs.getDate("eff_from");
						validUpTo =  rs.getDate("valid_upto");
					}

					if (effFrom != null)
					{
						effFromDate = simpleDateFormat.format(effFrom.getTime());
					}
					else
					{
						effFromDate = "";
					}
					if (validUpTo != null)
					{
						validUpToDate = simpleDateFormat.format(validUpTo.getTime());
					}
					else
					{
						validUpToDate = "";
					}

					valueXmlString.append("<eff_from>").append("<![CDATA[" +  effFromDate + "]]>").append("</eff_from>");
					valueXmlString.append("<valid_upto>").append("<![CDATA[" +  validUpToDate + "]]>").append("</valid_upto>");

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				}
				else if(currentColumn.trim().equalsIgnoreCase("sub_bu_code"))
				{
					subBuCode = genericUtility.getColumnValue("sub_bu_code", dom);
					System.out.println("subBuCode=["+subBuCode+"]");
					sql = "select a.sub_bu_name as sub_bu_name,a.bu_code as bu_code, b.descr as bu_name "+
							"from sub_bu_master a, itemser b "+
							"where a.bu_code = b.item_ser and a.sub_bu_code = ? ";
					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1,subBuCode);

					rs = pstmt.executeQuery();
					if(rs.next())
					{
						subBuName =  checkNull(rs.getString("sub_bu_name"));
						buCode =  checkNull(rs.getString("bu_code"));
						buName =  checkNull(rs.getString("bu_name"));
					}
					valueXmlString.append("<sub_bu_name>").append("<![CDATA[" +  subBuName + "]]>").append("</sub_bu_name>");
					valueXmlString.append("<bu_code>").append("<![CDATA[" +  buCode + "]]>").append("</bu_code>");
					valueXmlString.append("<bu_name>").append("<![CDATA[" +  buName + "]]>").append("</bu_name>");
				}
				valueXmlString.append("</Detail1>");
				break;

			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(pstmt != null)
						pstmt.close();
					if(rs != null)
						rs.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
		}
		return valueXmlString.toString();
	}


	private String errorType(Connection conn , String errorCode) throws ITMException // throws added by kailash on 11-04-18.
	{
		String msgType = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		try
		{
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,errorCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}
	private String checkNull( String input )
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}
}
