/*
 * Decompiled with CFR 0.152.
 */
package ibase.scheduler.utility;

import ibase.scheduler.utility.ScheduleModel;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ScheduleUtility {
    static ScheduleUtility INST = null;

    private ScheduleUtility() {
    }

    public static ScheduleUtility getInstance() {
        if (INST == null) {
            INST = new ScheduleUtility();
        }
        return INST;
    }

    public boolean checkDateSchedule(String schXmlStr) throws BaseException {
        BaseLogger.log("3", null, null, "Checking ScheduleDate status........." + schXmlStr);
        Date schDate = null;
        Date currDate = null;
        String startDateStr = "";
        try {
            Document newScheduleDom = new E12GenericUtility().parseString(schXmlStr);
            String startDate = newScheduleDom.getElementsByTagName("START_DATE").item(0).getFirstChild().getNodeValue();
            String startTime = newScheduleDom.getElementsByTagName("START_TIME").item(0).getFirstChild().getNodeValue();
            startDateStr = String.valueOf(startDate) + " " + startTime;
            schDate = new SimpleDateFormat("dd-MM-yyyy HH:mm").parse(startDateStr);
            currDate = new Date();
            BaseLogger.log("3", null, null, "Current Date :[" + currDate + "] schDate :[" + schDate + "]");
        }
        catch (BaseException be) {
            be.printStackTrace();
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e);
        }
        return schDate.compareTo(currDate) < 0;
    }

    public Object copy(Object orig) {
        Object obj = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(orig);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            obj = in.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return obj;
    }

    public String updateXml(String schXml) throws Exception {
        ScheduleModel schModel = new ScheduleModel(schXml);
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd-MM-yyyy");
        SimpleDateFormat sdfTime = new SimpleDateFormat("kk:mm");
        Document newScheduleDom = new E12GenericUtility().parseString(schXml);
        String time = sdfTime.format(new Date());
        int minutes = Integer.parseInt(time.substring(3, 5)) + 1;
        time = String.valueOf(time.substring(0, 3)) + (("" + minutes).length() == 1 ? "0" + minutes : "" + minutes);
        Node newScheduleNode = newScheduleDom.getElementsByTagName("SCHEDULE").item(0);
        newScheduleDom.getElementsByTagName("START_DATE").item(0).getFirstChild().setNodeValue(sdfDate.format(new Date()));
        newScheduleDom.getElementsByTagName("START_TIME").item(0).getFirstChild().setNodeValue(time);
        ScheduleModel schModeltemp = new ScheduleModel(newScheduleDom);
        return schModeltemp.toString();
    }
}

