package ibase.webService;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

import com.itextpdf.text.pdf.PdfStructTreeController.returnType;

import ibase.hibernate.bean.InviteUser;
import ibase.hibernate.dao.UserInvitationDAO;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;;



//Created by chitranga Tandel on 14 AUG 2018
@Path("/UserInvitationService")
public class UserInvitationService {
	
	@Context
	HttpServletRequest request; // The proxy of Request will be injected into this singleton

	//Method to get list invited user-list based on chngUser 
	@GET
	@Path("/getInvitedUsers")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getInvitedUsers(@Context HttpServletRequest request) throws Exception {

		JSONObject resultJson = new JSONObject();
		JSONObject userList = new JSONObject();
		String authStatus = "";
		UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
		BaseLogger.log("2",userInfo,null, "*** In getInvitedUsers method 070119 *** " +userInfo);
		if (userInfo != null) 
		{
			authStatus = "VALID";
		}
		if ("VALID".equalsIgnoreCase(authStatus))
		{
			//String empCode = userInfo.getEmpCode() ;
			String chngUser = userInfo.getLoginCode() ;
			String enterpise = userInfo.getEnterprise();
			BaseLogger.log("2",userInfo,null, "<--enterpise in getInvitedUsers --> " +enterpise);
			List<InviteUser> invitedUserList = new ArrayList<InviteUser>();
			//List<InviteUser> userLiscenceList = new ArrayList<InviteUser>();
			JSONArray userLicListArr = new JSONArray();
			try 
			{
				UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
				//invitedUserList = userInvitationDAO.getInvitedUsers(empCode);
				invitedUserList = userInvitationDAO.getInvitedUsers(chngUser);
				userLicListArr = userInvitationDAO.getInviteUserLiscenceArr(enterpise);
				BaseLogger.log("2",userInfo,null, "userLicListArr in service " +userLicListArr);
				JSONArray invitedUserJsonArr = new JSONArray();
				
				for (InviteUser inviteUser : invitedUserList) {
					invitedUserJsonArr.put(new JSONObject(inviteUser));
				}
			
				
				/*resultJson.put("status", invitedUserJsonArr) ;*/
				BaseLogger.log("2",userInfo,null, "invitedUserJsonArr in service " +invitedUserJsonArr);
				userList.put("UserList", invitedUserJsonArr) ;
				BaseLogger.log("2",userInfo,null, "userList in service " +userList);
				userList.put("UserLiscence", userLicListArr) ;
				resultJson.put("status", userList);
				BaseLogger.log("2",userInfo,null, "resultJson " +resultJson);

			} catch (Exception e)
			{
				BaseLogger.log("0",userInfo,null, "In getInvitedUsers :: getInvited users : " + e.getMessage());
				e.printStackTrace();
				throw new Exception(e);
			}

		} else {
			resultJson.put("status", "error");
		}
		return Response.status(200).entity(resultJson.toString()).build();
	}
	
	
	//Method to get list invited user-list based on userCode 
	@GET
	@Path("/inviteUsers/{userCode}")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getInvitedUser(@PathParam( "userCode" ) String userCode ,@Context HttpServletRequest request) throws Exception
	{
		JSONObject resultJson = new JSONObject();
		String authStatus = "";
		UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
		if (userInfo != null) 
		{
			authStatus = "VALID";
		}
		if ("VALID".equalsIgnoreCase(authStatus))
		{
			InviteUser invitedUser = new InviteUser();
			try 
			{
				UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
				invitedUser = userInvitationDAO.getInviteUser(userCode);
		
			} catch (Exception e)
			{
				BaseLogger.log("0",userInfo,null, "In getInvitedUsers :: getInvited users : " + e.getMessage());
				e.printStackTrace();
				throw new Exception(e);
			}
			resultJson.put("status", new JSONObject(invitedUser));

		} else {
			resultJson.put("status", "error");
		}
		return Response.status(200).entity(resultJson.toString()).build();
		
	}

	@POST
	@Path("/inviteUsers")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public  Response addInviteUser(InviteUser inviteUser , @Context HttpServletRequest request ) throws Exception
	{
		BaseLogger.log("2",null,null,  " ** In addinviteUser method **" + new JSONObject(inviteUser));
		String result ="" ;
		String authStatus = "";
		JSONObject resultJson = new JSONObject();

		UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
		if (userInfo != null) 
		{
			authStatus = "VALID";
		}
		if ("VALID".equalsIgnoreCase(authStatus))
		{
			try 
			{
				inviteUser.setTransDB( userInfo.getTransDB() );
				inviteUser.setEnterprise( userInfo.getEnterprise() );
				//inviteUser.setChgUser(userInfo.getEmpCode());
				inviteUser.setChgUser(userInfo.getLoginCode());				
				UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
				
				String remoteHost = request.getHeader("Host");
				int portIndex = remoteHost.indexOf(":");
				if( portIndex != -1 )
				{
					remoteHost = remoteHost.substring(0, portIndex);
				}
				userInvitationDAO.setHostName(remoteHost);
				// Added by Nikhil on 28-05-21
				result = userInvitationDAO.addInviteUser(inviteUser ,false);
				resultJson.put("status", result);				

			} 
			catch (Exception e)
			{
				//Updated By Saitej D [On 16 April 2019] [To show error message]
				ITMDBAccessEJB itmDbAccess= new ITMDBAccessEJB();
				String msgNo="USRINVTERR";
				String errorMessage = itmDbAccess.getErrorString("", msgNo, userInfo.getLoginCode());
				
				resultJson.put("status", errorMessage);
				e.printStackTrace();
				//throw new Exception(e);
				//Updated By Saitej D [On 16 April 2019] [To show error message]
			}
		} 
		BaseLogger.log("2",userInfo,null, " *** Response In addInviteUser*** " + Response.status(200).entity(resultJson.toString()).build() );
		return Response.status(200).entity(resultJson.toString()).build();
	}
	
	@POST
	@Path("/inviteUsersArr")
	@Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    // Added by Nikhil on 28-05-21 for multiple user invitation change the return type from ArrayList to String
	public  String addInviteUser(ArrayList<InviteUser> inviteUsers  , @Context HttpServletRequest request) throws Exception
	{
		
		UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
        String authStatus = "";
        // Added by Nikhil on 28-05-21 for multiple user invitation [Start]
        String response = ""; 
        JSONObject resultJson = new JSONObject();
        // Added by Nikhil on 28-05-21 for multiple user invitation [End]
		if (userInfo != null) 
		{
			authStatus = "VALID";
		}
		if ("VALID".equalsIgnoreCase(authStatus))
		{
			try 
			{
                //Added by Nikhil on 28-05-21 for multiple user invitation [Start]
                for (InviteUser iUser : inviteUsers)
                {
                    iUser.setTransDB(userInfo.getTransDB());
                    iUser.setEnterprise(userInfo.getEnterprise());
                    iUser.setChgUser(userInfo.getLoginCode());
                }
                //Added by Nikhil on 28-05-21 for multiple user invitation [End]
				UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
				String remoteHost = request.getHeader("Host");
				int portIndex = remoteHost.indexOf(":");
				if( portIndex != -1 )
				{
					remoteHost = remoteHost.substring(0, portIndex);
				}
				userInvitationDAO.setHostName(remoteHost);
				// Added by Nikhil on 28-05-21 for multiple user invitation  
                response = userInvitationDAO.addInviteUsers( inviteUsers );
				
			} catch (Exception e)
			{
				e.printStackTrace();
				throw new Exception(e);
			}
        } 
        // Added by Nikhil on 28-05-21
		return response;
	}
	
	
	@POST
	@Path("/updateInviteUsers")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public InviteUser updateInviteUser( InviteUser inviteUser , @Context HttpServletRequest request ) throws Exception
	{
		UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
		String authStatus = "";
		if (userInfo != null) 
		{
			authStatus = "VALID";
		}
		if ("VALID".equalsIgnoreCase(authStatus))
		{
			try 
			{
				UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
				userInvitationDAO.updateInviteUser( inviteUser );
				
			} catch (Exception e)
			{
				e.printStackTrace();
				throw new Exception(e);
			}

		} 
		return inviteUser;
	}
	
	//Method to delete user from invited user - list 
	@DELETE
	@Path("/deleteUsers/{userCode}")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public Response updateInviteUser(@PathParam( "userCode" ) String userCode) throws Exception
	{
		UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
		JSONObject resultJson = new JSONObject();
		BaseLogger.log("2",userInfo,null, "In updateInviteUser method:userInfo:" + userInfo +" userCode " + userCode);
		String authStatus = "";
		if (userInfo != null) 
		{
			authStatus = "VALID";
		}
		if ("VALID".equalsIgnoreCase(authStatus))
		{
			BaseLogger.log("3",userInfo,null, " ***In updateInviteUser Method**** ");
			try 
			{
				if( userInfo != null )
				{
					UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
					userInvitationDAO.deleteInviteUser( userCode );
					BaseLogger.log("3",userInfo,null, "In updateInviteUser userCode:"  + userCode );
					resultJson.put("result", userCode);
				}
				
			} catch (Exception e)
			{
				e.printStackTrace();
				resultJson.put("result", "error" );
				throw new Exception(e);
			}
		}
		 return Response.status(200).entity(resultJson.toString()).build(); 
	}

	@POST
	@Path("/updateStatus/{userCode}/{status}")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public Response updateInviteUser( @PathParam( "userCode" ) String userCode, @PathParam( "status" ) String status ,@Context HttpServletRequest request) throws Exception
	{
		String errString ="";
		UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
		BaseLogger.log("2",userInfo,null, "In updateInviteUser method:userInfo:" + userInfo);
		String authStatus = "";
		JSONObject resultJson = new JSONObject();
		if (userInfo != null) 
		{
			authStatus = "VALID";
		}
		if ("VALID".equalsIgnoreCase(authStatus))
		{
			try 
			{
				UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
				errString = userInvitationDAO.updateRegstrationStatus( userCode, status );
				BaseLogger.log("3",userInfo,null, "In updateInviteUser userCode:"+ errString );
				resultJson.put("result", errString );
				
			} catch (Exception e)
			{
				resultJson.put("result", "error");
				e.printStackTrace();
				throw new Exception(e);
			}

		} 
		return Response.status(200).entity(resultJson.toString()).build();
		
	}
	
	@POST
	@Path("/generateLicense")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public Response generateLicense(String licData) throws Exception {
		
		UserInvitationDAO userInvitationDAO = new UserInvitationDAO();
		JSONObject respJson = new JSONObject();
		JSONObject licDataJson = new JSONObject(licData);
		String userLimit = licDataJson.optString("userLimit");
		String remoteHost = licDataJson.optString("hostName");// test.base231.com
		String remoteHostIp = licDataJson.optString("hostIp");// 192.168.0.231 
		String enterprise = licDataJson.optString("enterprise");
		
		BaseLogger.log("2",null,null,"In generateLicense userCode:: ["+licData+"]");

		String response = userInvitationDAO.generateServerLicense(remoteHost, "", userLimit, enterprise);
		respJson.put("status", response);
		
		return Response.status(200).entity(respJson.toString()).build();
	}
	
	//Commented by Prajyot on 16-APR-19 [ As Server License validation is not required ] Start
	/*
	@GET
	@Path("/checkLicense")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public Response checkLicense(@QueryParam("LICENSE_KEY") String encryptedKey, @QueryParam("ENTERPRISE") String enterprise) throws Exception {
		
		BaseLogger.log("2",null,null,"In checkLicense LICENSE_KEY: ["+encryptedKey+"]");
		JSONObject respJson = new JSONObject();
		String response;
		
		CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
		UserInvitationDAO userInvitationDAO = new UserInvitationDAO();
		
		
		try 
		{			
			String decryptedKey = commonDBAccessEJB.decrypt(encryptedKey);
			BaseLogger.log("2",null,null,"In encryptServerUrl decryptedKey: ["+decryptedKey+"]");
			
			if(decryptedKey != null && decryptedKey.trim().length() > 0) 
			{
				String[] parts = decryptedKey.split("_");
				String hostName = parts[0];
				String userCode = parts[1];
				BaseLogger.log("2",null,null,"In encryptServerUrl after split: ["+userCode+"] hostName:["+hostName+"]");
				
				response = userInvitationDAO.checkLicenseValidation(hostName , userCode, enterprise);
				respJson.put("status", response);
			}
			else
			{
				respJson.put("status", "Invalid License Key");
			}
		} 
		catch(Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception In checkLicense");
			e.printStackTrace();
		}

		return Response.status(200).entity(respJson.toString()).build();
	}
	
	@POST
	@Path("/generateUserLicense")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public Response generateUserLicense(@QueryParam("USER_DETAIL") String userDetail, @QueryParam("ENTERPRISE") String enterprise) throws Exception {
		
		UserInvitationDAO userInvitationDAO = new UserInvitationDAO();
		CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
		JSONObject respJson = new JSONObject();

		String decryptedKey = commonDBAccessEJB.decrypt(userDetail);
		BaseLogger.log("2",null,null,"In encryptServerUrl decryptedKey: ["+decryptedKey+"]");
		String[] parts = decryptedKey.split("_");
		String remoteHost = parts[0];
		String userCode = parts[1];
		
		BaseLogger.log("2",null,null,"In generateUserLicense USER_ID:: ["+userCode+"] Remote_Host ["+remoteHost+"] enterprise :"+enterprise);
		String response = userInvitationDAO.generateUserLicense(userCode, remoteHost, enterprise);
		respJson.put("status", response);
		
		return Response.status(200).entity(respJson.toString()).build();
	}
	
	@POST
	@Path("/generateServerLicense")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public Response generateServerLicense(@QueryParam("USER_DETAIL") String userDetail, @QueryParam("ENTERPRISE") String enterprise) throws Exception {
		
		UserInvitationDAO userInvitationDAO = new UserInvitationDAO();
		CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
		JSONObject respJson = new JSONObject();

		String decryptedKey = commonDBAccessEJB.decrypt(userDetail);
		BaseLogger.log("2",null,null,"In generateServerLicense decryptedKey: ["+decryptedKey+"]");
		String[] parts = decryptedKey.split("_");
		String remoteHost = parts[0];
		String userCode = parts[1];
		
		BaseLogger.log("2",null,null,"In generateServerLicense USER_ID:: ["+userCode+"] Remote_Host ["+remoteHost+"]");
		String response = userInvitationDAO.generateServerLicense(remoteHost, "", "5", enterprise);
		respJson.put("status", response);
		
		return Response.status(200).entity(respJson.toString()).build();
	}
	*/
	//Commented by Prajyot on 16-APR-19 [ As Server License validation is not required ] End
	
	@GET
	@Path("/getUserInfo")
	public Response getUserInfo(@Context HttpServletRequest request) throws Exception
	{
		String authStatus = "";
		JSONObject resultJson = new JSONObject();
		UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");

		if(userInfo != null)
		{
			authStatus = "VALID";
			resultJson.put( "result", "ERROR" );
		}
		if ( "VALID".equalsIgnoreCase( authStatus ) )
		{
			String userInfoString = userInfo.toString();
			JSONObject userInfoObject = XML.toJSONObject(userInfoString);
			BaseLogger.log("3",null,null,userInfoObject);
			resultJson.put( "result", userInfoObject );
		}
		return Response.status(200).entity( resultJson.toString() ).build();
	}
	
	private boolean checkIsHost(String hostname) {
	    Pattern p = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
	    Matcher m = p.matcher(hostname);
	    return !m.find();
	}
	
	/*
	 * @enterprise  : Enterprise code 
	 * @userLicType : E - Employee Users
	 * 				  P - Portal Users 
	 * 				  R - Read only Users
	 * 				  S - Service Users
	 * 
	 * To get List of Users from AUTH Schema for provided ENTERPRISE 
	 * Also provides LICENCE USERS LIMIT and currently ACTIVE USERS COUNT of provided ENTERPRISE
	 * 
	 * REST Service Path 
	 * e.g. /ibase/rest/UserInvitationService/userlicence/PROTEUS/E
	 *  
	 */
	@GET
	@Path("/userlicence/{enterprise}/{userLicType}")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getUsersData( @PathParam("enterprise") String enterprise, @PathParam("userLicType") String userLicType) throws Exception 
	{
		UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
		BaseLogger.log("2", userInfo, null,"In getUsersData enterprise ["+enterprise+"] userLicType["+userLicType+"]");
		JSONObject respJsonObject = new JSONObject();
		try
		{
			if( userInfo != null )
			{	
				UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
				JSONObject usersData = userInvitationDAO.getUsersData(enterprise, userLicType);
				respJsonObject.put("result", "success");
				respJsonObject.put("report", usersData);
			}
			else
			{
				respJsonObject.put("result","failure" );
				respJsonObject.put("message","Unauthorised access" );
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
            respJsonObject.put("result", "failure" );
		}
		return Response.status(200).entity( respJsonObject.toString() ).build();
	}
	

	/*
	 * @enterprise    : Enterprise code 
	 * @userLicType   : E - Employee Users
	 * 				    P - Portal Users 
	 * 				    R - Read only Users
	 * 				    S - Service Users
	 * @activeUsers	  : Active Users Count of Enterprise and User Licence Type 
	 * @selectedUsers : Selected users for which Licence to be generated 
	 * 
	 * To generate licence for Users and save in AUTH & USER Schema for provided Users List w.r.t. ENTERPRISE, USER_LIC_TYPE 
	 * 
	 * REST Service Path 
	 * e.g. /ibase/rest/UserInvitationService/userlicence/PROTEUS/E/10
	 *  
	 */
	@POST
	@Path("/userlicence/{enterprise}/{userLicType}/{activeUsers}")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes({ "application/json" })
	public Response updateUserLicences( @PathParam("enterprise") String enterprise, @PathParam("userLicType") String userLicType, @PathParam("activeUsers") String activeUsers, String selectedUsers) throws Exception 
	{
		UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
		BaseLogger.log("2", userInfo, null,"In updateUserLicences enterprise["+enterprise+"] userLicType["+userLicType+"]activeUsers["+activeUsers+"]selectedUsers["+selectedUsers+"]");
		JSONObject respJsonObject = new JSONObject();
		try
		{
			if( userInfo != null )
			{	
				String transDB = userInfo.getTransDB();
				UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
				
				JSONArray selectedUsersJA = new JSONArray(selectedUsers);
				BaseLogger.log("2", userInfo, null,"In updateUserLicences selectedUsersJA["+selectedUsersJA+"]");
				userInvitationDAO.updateUserLicence(transDB, enterprise, userLicType, activeUsers, selectedUsersJA);				
				respJsonObject.put("result", "success");
			}
			else
			{
				respJsonObject.put("result","failure" );
				respJsonObject.put("message","Unauthorised access" );
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
            respJsonObject.put("result", "failure" );
		}
		return Response.status(200).entity( respJsonObject.toString() ).build();
	}
	// Added by mayuri on 27-aug-2023 for user type is employee and entity type avialable in employee table then get data  [start]
	@POST
	@Path("/getEmplyeeDetail/{entityCode}")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public Response getEmployee( @PathParam( "entityCode" ) String entityCode, @Context HttpServletRequest request) throws Exception
	{
		String errString ="";
		UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
		BaseLogger.log("2",userInfo,null, "In getEmployee method:userInfo:" + userInfo);
		JSONObject resultJson = new JSONObject();
		try 
		{
			UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
			errString = userInvitationDAO.getEmpDetail( entityCode, userInfo );
			BaseLogger.log("3",userInfo,null, "In getEmployee userCode:"+ errString );
			resultJson.put("result", errString );
			
		} catch (Exception e)
		{
			resultJson.put("result", "error");
			e.printStackTrace();
			throw new Exception(e);
		}
		return Response.status(200).entity(resultJson.toString()).build();
	}
	// Added by mayuri on 27-aug-2023 for user type is employee and entity type avialable in employee table then get data  [end]
	
	//Added by ManishK to set department,grade by default when profile is set on 03-APR-24[START]
	@POST
	@Path("/getDefaultData/{profileId}")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public Response getDefaultValue( @PathParam( "profileId" ) String profileId, @Context HttpServletRequest request) 
	{
		// Changed by Rahul P. on 02-05-24 [To get the description for profileId, deptCode, grade and itemSer] :: START
		String resultString = "";
		UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
		BaseLogger.log("2",userInfo,null, "In getDefaultValue method:userInfo:" + userInfo);
		try 
		{
			UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
			resultString = userInvitationDAO.getDefaultData( profileId, userInfo );
			BaseLogger.log("3",userInfo,null, "In getDefaultValue >> resultString:"+ resultString );
			
		} 
		catch (Exception e)
		{
			BaseLogger.log("2",userInfo,null, "Exception in getDefaultValue :: " + e.getMessage());
			e.printStackTrace();
		}
		return Response.status(200).entity(resultString).build();
		// Changed by Rahul P. on 02-05-24 [To get the description for profileId, deptCode, grade and itemSer] :: END
	}
	//Added by ManishK to set department,grade by default when profile is set on 03-APR-24[END]
	
	//Added by ManishK to set stationCode by default on 12-APR-24[START]
	@POST
	@Path("/getDefaultStanCode")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public Response getDefaultStanCode( @Context HttpServletRequest request) throws Exception
	{
		// Changed by Rahul P. on 02-05-24 [To get the StationCode and its description] :: START
		String resultString ="";
		UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
		BaseLogger.log("2",userInfo,null, "In getDefaultStanCode method:userInfo:" + userInfo);
		try 
		{
			UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
			resultString = userInvitationDAO.getDefaultStationCode( userInfo );
			BaseLogger.log("2",userInfo,null, "In getDefaultStationCode resultString ::"+ resultString );
			
		} 
		catch (Exception e)
		{
			BaseLogger.log("2",userInfo,null, "Exception in getDefaultStanCode :: " + e.getMessage());
			e.printStackTrace();
		}
		return Response.status(200).entity(resultString).build();
		// Changed by Rahul P. on 02-05-24 [To get the StationCode and its description] :: END
	}
	//Added by ManishK to set stationCode by default on 12-APR-24[END]
	
	@GET
	@Path("/description/{fieldName}")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public Response getDescription( @PathParam( "fieldName" ) String fieldName, @Context HttpServletRequest request) throws Exception
	{
		String resultString ="";
		UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
		BaseLogger.log("3",userInfo,null, "Inside getDescription >> userInfo:" + userInfo);
		try 
		{
			UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
			resultString = userInvitationDAO.getDescriptionData(fieldName, userInfo);
			BaseLogger.log("3",userInfo,null, "getDescription >> resultString :: "+ resultString );
		} 
		catch (Exception e)
		{
			BaseLogger.log("3",userInfo,null, "Exception in getDescription :: " + e.getMessage());
			e.printStackTrace();
		}
		return Response.status(200).entity(resultString).build();
	}
	
}