package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.w3c.dom.Document;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class SprsSellTargetPreSave extends ValidatorEJB 
{
	private E12GenericUtility genericUtility = new E12GenericUtility();

	public String preSave() throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave(String xmlString, String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		try
		{
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = genericUtility.parseString(xmlString);
				errString = executePreSave( dom, editFlag, xtraParams, conn );
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :SellInItemPreSave:" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}

	public String executePreSave( Document dom, String editFlag, String xtraParams, Connection conn ) throws RemoteException, ITMException, SQLException
	{
		String errString = "";
		int cnt =0;
		String sprsSellstrgtSQl = ""; 
		String grpCode = "", sgrpCode="", itemSer="", prdCode ="", stanCodeHq = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{			
			if (conn == null ||  conn.isClosed())
			{
				conn = getConnection();
			}

			prdCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("prd_code", dom) );
			stanCodeHq = E12GenericUtility.checkNull( genericUtility.getColumnValue("stan_code__hq", dom) );
			itemSer = E12GenericUtility.checkNull( genericUtility.getColumnValue("item_ser", dom) );
			grpCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("grp_code", dom) );
			sgrpCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("sgrp_code", dom) );

			sprsSellstrgtSQl = "SELECT COUNT(*) AS COUNT FROM SPRS_SELLS_TRGT "
					+ "WHERE PRD_CODE = ? AND STAN_CODE__HQ = ? AND ITEM_SER = ? AND GRP_CODE = ? AND SGRP_CODE = ?";
			pstmt = conn.prepareStatement( sprsSellstrgtSQl );
			pstmt.setString( 1, prdCode );
			pstmt.setString( 2, stanCodeHq );
			pstmt.setString( 3, itemSer );
			pstmt.setString( 4, grpCode );
			pstmt.setString( 5, sgrpCode );

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				cnt = rs.getInt("COUNT");
				System.out.println("cnt ["+cnt+"]");
			}
			if( cnt > 0 )
			{
				updateStatus( conn, prdCode, stanCodeHq, itemSer, grpCode, sgrpCode );
			}
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
		}
		catch(Exception e)
		{
			System.out.println("The Exception occurs in SELL_TRGT PRE SAVE :"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (rs != null )
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return errString;
	}

	private void updateStatus( Connection conn, String prdCode, String stanCodeHq, String itemSer, String grpCode, String sgrpCode )
	{
		PreparedStatement pstmt = null;
		try
		{
			String sellPlanningSql = "UPDATE SPRS_SELLS_TRGT SET STATUS = ? "
					+ " WHERE PRD_CODE = ? AND STAN_CODE__HQ = ? AND ITEM_SER = ? AND GRP_CODE = ? AND SGRP_CODE = ?";
			pstmt = conn.prepareStatement( sellPlanningSql );
			pstmt.setString( 1, "N" );
			pstmt.setString( 2, prdCode );
			pstmt.setString( 3, stanCodeHq );
			pstmt.setString( 4, itemSer );
			pstmt.setString( 5, grpCode );
			pstmt.setString( 6, sgrpCode );

			int updCnt = pstmt.executeUpdate();
			if( updCnt > 0 )
			{
				System.out.println("POST SAVE updCnt success =["+updCnt+"]");
			}
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			System.out.println( "The Exception occurs in SPRS_SELLS_TRGT PRE SAVE :"+e );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
	}
}