
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;

public class DbConnection {
	
	Properties properties;
	
	public Connection getConnection() {
		properties = loadProperties();
		System.out.println(properties);
		Connection conn =null;
		try {
			String jdbcURL =  "jdbc:oracle:thin:@" + properties.getProperty("DB_HOST_NAME") + ":1521/" + properties.getProperty("SERVICE_NAME");;
			Class.forName(properties.getProperty("DB_DRIVER"));
			conn = DriverManager.getConnection(jdbcURL, properties.getProperty("USER_NAME"), properties.getProperty("PASSWORD"));
			
			System.out.println("Connected");
		} catch (Exception e) {
		e.printStackTrace();
		System.out.println("Error ="+e.getMessage());
			e.printStackTrace();
		}
		return conn;
	}
	
	public static void main(String[] args) {
		new DbConnection().getConnection();
	}
	public Properties loadProperties()
	{
		Properties prop = new Properties();
		try {
			prop.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("db.properties"));
		} catch (IOException e) {
			e.printStackTrace();
		}
		return prop;
	}
	
	
	

}
