/*
	Author: Dipak Chattar
	Date: 3/21/2013
	Reason : SalesPersNPL
 */
package ibase.webitm.ejb.wsfa.transactions;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.w3c.dom.*;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class SalesPersNPL extends ValidatorEJB implements SalesPersNPLRemote,SalesPersNPLLocal//implements SessionBean
{
	static int domID = 1;
	// Code for Validation
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			System.out.println("xmlString ["+xmlString+"]");
			System.out.println("xmlString1 ["+xmlString1+"]");
			System.out.println("xmlString2 ["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println ( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception: SalesPersNPL: wfValData(String xmlString): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		return errString;
	}


	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		Connection connectionObject = null;
		String salesPersMgr = "";
		String nplName = "";
		String rsrCode = "";
		String month = "";
		String year = "";
		String target = "";
		String actual = "";

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			String columnValue = "";
			int currentFormNo = 0;
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			NodeList parentList = dom.getElementsByTagName( "Detail" + currentFormNo );
			NodeList childList = parentList.item( 0 ).getChildNodes();
			int noOfChilds = childList.getLength();
			for (int ctr = 0; ctr < noOfChilds; ctr++)
			{
				Node childNode = childList.item( ctr );
				String childNodeName = childNode.getNodeName();
				if ( childNode != null && childNode.getFirstChild() != null )
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}
				System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
				switch ( currentFormNo )
				{
				case 1:
				{
					if(childNodeName.equalsIgnoreCase("mgr_code"))
					{
						salesPersMgr = genericUtility.getColumnValue("mgr_code",dom);

						if ( salesPersMgr == null || salesPersMgr.trim().length() == 0 )
						{
							errString = getErrorString("mgr_code","NULSPMGR",userId);
							break;
						}
					}

					else if(childNodeName.equalsIgnoreCase("month"))
					{
						month = genericUtility.getColumnValue("month",dom);

						if ( month == null || month.trim().length() == 0 )
						{
							errString = getErrorString("month","NULMONTH",userId);
							break;
						}

					}
					else if(childNodeName.equalsIgnoreCase("year"))
					{
						year = genericUtility.getColumnValue("year",dom);
						month = genericUtility.getColumnValue("month",dom);

						if ( year == null || year.trim().length() == 0 )
						{
							errString = getErrorString("year","NULLYEAR",userId);
							break;
						}

						else if(month != null && month.trim().length() > 0 && year != null && year.trim().length() > 0 )
						{
							SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
							sdfFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
							String eventDateStr = sdfFormat.format( new Date() );
							java.util.Date calenderDateObject=null;

							String nplDate= "01/" + month.trim()+"/"+ year.trim();
							System.out.println("[nplDate = " + nplDate + "]" );
							if(nplDate.length()>0)
							{
								java.util.Date eventDateObject=null;
								java.util.Date dateObject=null;
								try
								{
									dateObject=sdfFormat.parse(nplDate);
									eventDateObject=sdfFormat.parse(eventDateStr);
								}
								catch (Exception e)
								{
									errString = getErrorString("","DATEFORMAT",userId);
									break;
								}
								Calendar calobject = Calendar.getInstance();
								calobject.setTime(dateObject);
								calenderDateObject= calobject.getTime();

								if ( calenderDateObject.compareTo(eventDateObject) > 0)
								{
									errString = getErrorString("year","INVDATE",userId);
									break;
								}
							}

						}
					}
				}
				break;
				case 2 :
				{
					if(childNodeName.equalsIgnoreCase("npl_name"))
					{
						nplName = genericUtility.getColumnValue("npl_name",dom);
						System.out.println("[nplName in 2nd form = " + nplName + "]");

						if ( nplName == null || nplName.trim().length() == 0 )
						{
							errString = getErrorString("npl_name","NULNPLNAM",userId);
							break;
						}
					}

				}

				break;
				case 3 :
				{
					if(childNodeName.equalsIgnoreCase("sprs_code"))
					{
						rsrCode = genericUtility.getColumnValue("sprs_code",dom);

						if ( rsrCode == null || rsrCode.trim().length() == 0 )
						{
							errString = getErrorString("sprs_code","NULRSRNAM",userId);
							break;
						}
					}

					else if(childNodeName.equalsIgnoreCase("mgr_code"))
					{
						salesPersMgr = genericUtility.getColumnValue("mgr_code",dom);

						if ( salesPersMgr == null || salesPersMgr.trim().length() == 0 )
						{

							errString = getErrorString("mgr_code","NULSPMGR",userId);
							break;
						}


					}

					else if(childNodeName.equalsIgnoreCase("target"))
					{
						target = genericUtility.getColumnValue("target",dom);

						if ( target == null || target.trim().length() == 0 )
						{
							errString = getErrorString("target","NULTARGT",userId);
							break;
						}

					}

					else if(childNodeName.equalsIgnoreCase("actual"))
					{
						actual = genericUtility.getColumnValue("actual",dom);

						if ( actual == null || actual.trim().length() == 0 )
						{
							errString = getErrorString("actual","NULACTL",userId);
							break;
						}

					}

				}

				if (errString != null && errString.trim().length() > 0)
				{
					break;
				}
				}// Switch Block Closed
			}// For Loop Closed
		}  //Try Block Close
		catch (Exception e)
		{
			System.out.println ( "Exception: SalesPersNPL: wfValData(Document dom): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :SalesPersNPL:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}

		return errString;
	}

	// Code for ItemChange
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :SalesPersNPL :itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from SalesPersNPL itemChanged" );
		return errString;
	}
	public String itemChanged( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		String userId = "";
		String sprsCode = "";
		String mgrCode = "";
		String rsrName = "";
		String mgrName = "";
		String month = "";
		String year = "";
		String nplName = "";
		//String sprsDetails = "";
		int currentFormNo = 0;
		int sprsFrom = 0;
		String [] temp;
		boolean flag = false;

		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			genericUtility.getColumnValue( currentColumn, dom );

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate =  dtFormat.format( date );

			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n" );
			System.out.println("currentFormNo=========================["+currentFormNo+"]");

			switch ( currentFormNo )
			{

			case 1:
			{

				System.out.println( "columnValue [" + currentColumn + "]" );
				valueXmlString.append( "<Detail1 domID='1' >\r\n" );
				if( currentColumn.equalsIgnoreCase( "itm_default" ))
				{
					System.out.println("Calling the Dfault Data ["+currentFormNo+"][");

					nplName = genericUtility.getColumnValue( "npl_name", dom );
					month = genericUtility.getColumnValue( "month", dom );
					year = genericUtility.getColumnValue( "year", dom );
					System.out.println("nplName = ["+nplName+"],month = ["+month+"], year =["+ year +"]");
					String sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+userId+"' ";
					PreparedStatement pstmt =  connectionObject.prepareStatement(sql);

					ResultSet rs = pstmt.executeQuery();

					if(rs.next())
					{
						mgrName = rs.getString(1);
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;

					String sqlMonthYear = "SELECT year,month FROM (SELECT rownum as  row_1,year,month "+
							" FROM SPRS_NPL ORDER BY YEAR DESC,MONTH DESC)A where row_1=1 ";
					PreparedStatement pstmtMonthYear= connectionObject.prepareStatement(sqlMonthYear);

					ResultSet rsMonthYear = pstmtMonthYear.executeQuery();

					if(rsMonthYear.next())
					{
						month = checkNull(rsMonthYear.getString("month"));
						year = checkNull(rsMonthYear.getString("year"));
					}
					rsMonthYear.close(); rsMonthYear = null;
					pstmtMonthYear.close();pstmtMonthYear = null;

					if(month != null && month.trim().length() > 0 && year != null && year.trim().length() > 0 )
					{
						valueXmlString.append("<year><![CDATA[").append( checkNull(year) ).append("]]></year>\r\n");
						valueXmlString.append("<month><![CDATA[").append( checkNull(month) ).append("]]></month>\r\n");
					}
					else
					{
						year="2013";
						month = "01";
						valueXmlString.append("<year><![CDATA[").append( checkNull(year) ).append("]]></year>\r\n");
						valueXmlString.append("<month><![CDATA[").append( checkNull(month) ).append("]]></month>\r\n");
					}

					valueXmlString.append( "<mgr_code><![CDATA[" ).append(userId).append( "]]></mgr_code>\r\n" );
					valueXmlString.append( "<mgr_name><![CDATA[" ).append(mgrName).append( "]]></mgr_name>\r\n" );
					valueXmlString.append( "<npl_name><![CDATA[" ).append("").append( "]]></npl_name>\r\n" );
					valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
				}
				valueXmlString.append( "</Detail1>\r\n" );

			}//case 1 end
			break;
			case 2:
			{
				System.out.println( "columnValue [" + currentColumn + "]" );
				if( currentColumn.equalsIgnoreCase( "itm_default" ))
				{
					int i=1;
					System.out.println("Calling the Dfault Data ["+currentFormNo+"][");
					month = genericUtility.getColumnValue( "month", dom1 );
					year = genericUtility.getColumnValue( "year", dom1 );
					System.out.println("month = ["+month+"], year =["+ year +"]");

					if(month != null && month.trim().length() > 0 && year != null && year.trim().length() > 0)
					{
						String sql = "Select npl_name from sprs_npl where month = ? and year = ? ";
						PreparedStatement pstmt= connectionObject.prepareStatement(sql);

						pstmt.setString(1,month);
						pstmt.setString(2,year);
						ResultSet rs = pstmt.executeQuery();
						if(rs.next())
						{
							nplName = checkNull(rs.getString("npl_name"));
						}
						rs.close(); rs = null;
						pstmt.close();pstmt = null;
					}

					valueXmlString.append( "<Detail2 domID='" + i + "' selected = 'Y'>\r\n" );

					valueXmlString.append( "<npl_name><![CDATA[" ).append(nplName).append( "]]></npl_name>\r\n" );
					valueXmlString.append( "<mgr_code><![CDATA[" ).append(userId).append( "]]></mgr_code>\r\n" );
					valueXmlString.append( "<mgr_name><![CDATA[" ).append(mgrName).append( "]]></mgr_name>\r\n" );
					valueXmlString.append( "<month><![CDATA[" ).append(month).append( "]]></month>\r\n" );
					valueXmlString.append( "<year><![CDATA[" ).append(year).append( "]]></year>\r\n" );
					//valueXmlString.append( "<blockEdit><![CDATA[" ).append(blockEdit).append( "]]></blockEdit>\r\n" );
					valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );

					valueXmlString.append( "</Detail2>\r\n" );
				}
			}
			break;

			case 3:
			{
				System.out.println( "columnValue [" + currentColumn + "]" );
				if( currentColumn.equalsIgnoreCase( "itm_default" ))
				{
					int domId = 1;
					System.out.println("Calling the Dfault Data ["+currentFormNo+"][");
					month = genericUtility.getColumnValue( "month", dom1 );
					year = genericUtility.getColumnValue( "year", dom1 );
					nplName = genericUtility.getColumnValue( "npl_name", dom2, "2" );
					System.out.println("--------------------nplName2-----------" + nplName);
					if(nplName == null || nplName.trim().length() == 0)
					{
						nplName = "";
					}
			/*		sprsCode = genericUtility.getColumnValue( "sprs_code", dom2 );
					System.out.println("month = ["+month+"], year =["+ year +"], sprsCode =["+ sprsCode +"]");

					System.out.println("--------------------sprsFrom-----------" + sprsFrom);
					String sprsCodes = getSprsFromDom(dom2, Integer.toString(currentFormNo) );

					System.out.println("sprsCodes:::" + sprsCodes);

					flag = preDomExists( dom, ""+currentFormNo );
					System.out.println("flag:::" + flag);

					String [] sprsCodeArr = sprsCodes.split(",");

					String preFormDet = "";
					if( flag )
					{
						preFormDet = getPrevFormValues( dom2, ""+currentFormNo, new ArrayList<String>(Arrays.asList(sprsCodeArr)) , "sprs_code");
						System.out.println("preFormDet:::" + preFormDet);
						valueXmlString.append(preFormDet);
					}
					else
					{
*/
						String editSql = "select e.emp_code as sprs_code ,upper(e.emp_fname || ' ' || e.emp_mname || ' ' || " +
								" e.emp_lname)  as RSR_name,e.report_to as mgr_code,upper(r.emp_fname || ' ' || r.emp_mname  " +
								" || ' ' || r.emp_lname) as MGR_name ,snd.target target, snd.actual actual "+
								" from employee e, sales_pers s,employee r, sprs_npldet snd " +
								" where  e.emp_code = s.sales_pers and r.emp_code = e.report_to " +
								" and snd.sprs_code=s.sales_pers "+
								" and s.active_yn ='Y' and e.hobby1='RSR'  "+
								" and snd.month= ? and snd.year = ?  order by MGR_name,RSR_name";

						PreparedStatement pstmtEdit =  connectionObject.prepareStatement(editSql);
						pstmtEdit.setString(1,month);
						pstmtEdit.setString(2,year);
						ResultSet rsEdit = pstmtEdit.executeQuery();

						while(rsEdit.next())
						{
							sprsCode = rsEdit.getString("sprs_code");
							mgrCode = rsEdit.getString("mgr_code");
							rsrName = rsEdit.getString("RSR_name");
							mgrName = rsEdit.getString("MGR_name");
							String target = rsEdit.getString("target");
							String actual = rsEdit.getString("actual");

							valueXmlString.append( "<Detail3 domID='" + domId + "' selected = 'Y'>\r\n" );
							valueXmlString.append("<mgr_code><![CDATA[").append( checkNull(mgrCode) ).append("]]></mgr_code>\r\n");
							valueXmlString.append("<mgr_name><![CDATA[").append( checkNull(mgrName) ).append("]]></mgr_name>\r\n");
							valueXmlString.append("<sprs_code><![CDATA[").append( checkNull(sprsCode) ).append("]]></sprs_code>\r\n");
							valueXmlString.append("<sp_name><![CDATA[").append( checkNull(rsrName) ).append("]]></sp_name>\r\n");
							valueXmlString.append("<year><![CDATA[").append( checkNull(year) ).append("]]></year>\r\n");
							valueXmlString.append("<month><![CDATA[").append( checkNull(month) ).append("]]></month>\r\n");
							valueXmlString.append("<target><![CDATA[").append(target).append("]]></target>\r\n");
							valueXmlString.append("<actual><![CDATA[").append(actual).append("]]></actual>\r\n");
							valueXmlString.append("<npl_name><![CDATA[").append(nplName).append("]]></npl_name>\r\n");
							valueXmlString.append( "</Detail3>\r\n" );

							domId++;
						}

						rsEdit.close();rsEdit = null;
						pstmtEdit.close();pstmtEdit = null;

				/*	}

					String sqlNew = "";
					if(sprsCodes !=null && sprsCodes.trim().length() > 0)
					{
						sqlNew = "select e.emp_code as sprs_code , e.emp_fname || ' ' || e.emp_mname || ' ' || " +
								" e.emp_lname  as RSR_name,e.report_to as mgr_code,r.emp_fname || ' ' || r.emp_mname  " +
								" || ' ' || r.emp_lname as MGR_name "+
								" from employee e, sales_pers s,employee r " +
								" where  e.emp_code = s.sales_pers and r.emp_code = e.report_to " +
								" and s.active_yn ='Y' and e.hobby1='RSR'  "+
								" and s.sales_pers not in( select sprs_code from sprs_npldet where month = ? and year = ? ) " +
								" and s.sales_pers not in ("+sprsCodes+")";

					}
					else
					{*/
						String sqlNew = "select e.emp_code as sprs_code , upper(e.emp_fname || ' ' || e.emp_mname || ' ' || " +
								" e.emp_lname) as RSR_name,e.report_to as mgr_code,upper(r.emp_fname || ' ' || r.emp_mname  " +
								" || ' ' || r.emp_lname) as MGR_name "+
								" from employee e, sales_pers s,employee r " +
								" where  e.emp_code = s.sales_pers and r.emp_code = e.report_to " +
								" and s.active_yn ='Y' and e.hobby1='RSR'  "+
								" and s.sales_pers not in( select sprs_code from sprs_npldet where month = ? and year = ? ) order by MGR_name,RSR_name" ;


					/*}*/
					PreparedStatement pstmtNew =  connectionObject.prepareStatement(sqlNew);
					pstmtNew.setString(1,month);
					pstmtNew.setString(2,year);
					ResultSet rsNew = pstmtNew.executeQuery();
					while(rsNew.next())
					{
						sprsCode = rsNew.getString("sprs_code");
						mgrCode = rsNew.getString("mgr_code");
						rsrName = rsNew.getString("RSR_name");
						mgrName= rsNew.getString("MGR_name");

						valueXmlString.append( "<Detail3 domID='" + domId + "' selected = 'N'>\r\n" );
						valueXmlString.append("<mgr_code><![CDATA[").append( checkNull(mgrCode) ).append("]]></mgr_code>\r\n");
						valueXmlString.append("<mgr_name><![CDATA[").append( checkNull(mgrName) ).append("]]></mgr_name>\r\n");
						valueXmlString.append("<sprs_code><![CDATA[").append( checkNull(sprsCode) ).append("]]></sprs_code>\r\n");
						valueXmlString.append("<sp_name><![CDATA[").append( checkNull(rsrName) ).append("]]></sp_name>\r\n");
						valueXmlString.append("<year><![CDATA[").append( checkNull(year) ).append("]]></year>\r\n");
						valueXmlString.append("<month><![CDATA[").append( checkNull(month) ).append("]]></month>\r\n");
						valueXmlString.append("<target><![CDATA[").append( checkNull("") ).append("]]></target>\r\n");
						valueXmlString.append("<actual><![CDATA[").append( checkNull("") ).append("]]></actual>\r\n");
						valueXmlString.append("<npl_name><![CDATA[").append(nplName).append("]]></npl_name>\r\n");
						valueXmlString.append( "</Detail3>\r\n" );
						domId++;
					}

					rsNew.close();rsNew = null;
					pstmtNew.close();pstmtNew = null;
				}
			}
			break;
			}//switch statement ends here

		}//try block ends here
		catch(Exception e)
		{
			System.out.println( "Exception :SalesPersNPL :itemChanged(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :SalesPersNPL:itemChanged :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}

/*	public String getSprsFromDom(Document dom, String currentForm ) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer sprsCodeBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("Driver");

			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					System.out.println("childNode.getNodeName() ::::" + childNode.getNodeName());
					if( childNode.getNodeName().equalsIgnoreCase("sprs_code"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							System.out.println("columnValue::::" + columnValue);
						}
						if ( temp.contains(columnValue))
						{
							continue;
						}
						if(columnValue != null && columnValue.trim().length() > 0)
						{
							if(sprsCodeBuff.length() == 0)
							{
								sprsCodeBuff.append("'").append(columnValue.toUpperCase()).append("'");
							}
							else
							{
								sprsCodeBuff.append(",'").append(columnValue.toUpperCase()).append("'");
							}
						}
						temp.add(columnValue);
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return sprsCodeBuff.toString();

	}*/
/*	public boolean preDomExists(Document dom, String currentFormNo) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node childNode = null;
		boolean selected = false;

		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			if ( parentList.item(0) != null )
			{
				childList = parentList.item(0).getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						System.out.println("Column found!!!" + childNode.getNodeName());
						selected = true;
						break;
					}
				}
			}


		}
		catch ( Exception e )
		{
			System.out.println( "Exception :StrgMeetWizardEJB :preDomExists :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("preDomExists =["+selected+"] and currentFormNo =["+currentFormNo+"]");

		return selected;
	}

	public String getPrevFormValues( Document dom, String currentFormNo, ArrayList temp, String colName) throws ITMException
	{
		GenericUtility genericUtility = GenericUtility.getInstance();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentlistlength["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						System.out.println("childNode.getNodeName() =["+childNode.getNodeName()+"], colName =["+colName+"], columnValue =["+columnValue+"], temp.contains(columnValue) =["+temp.contains(columnValue)+"]");
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								elementAttr.setAttribute( "selected" , "Y" );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}

					}
				}
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			System.out.println("returnPrevStr :::::::"+returnPrevStr);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
*/
}