package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.wsfa.transactions.StrgSeriesPreSave;
import ibase.webitm.utility.ITMException;

/* 
	 Author Name: Mrunalini sinkar on [30-Jul-19] 
 	 Created Date : 26-Apr-19 
*/

@Stateless
public class StrgSeriesApproval extends ValidatorEJB  
{

	E12GenericUtility genericUtility = new E12GenericUtility();
	public String CustomerApprove( String refID ,String xmlData ,String signBy ,String refSer, String SalesPers, String appoverCode ,String userInfoStr )throws RemoteException, ITMException
	{
		System.out.println("Inside CustomerApprove method");
		System.out.println("tranID : ["+refID+"]");
		System.out.println("xmlData : ["+xmlData+"]");
		System.out.println("refSer : ["+refSer+"]");
		boolean isError=false;
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		String childNodeName = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null; 	
		int updCnt = 0;
		int parentNodeListLength = 0;
		int childNodeListLength = 0;	

		String returnString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
		String updateFlag ="";
		
		try
		{
			
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			String transDB="";
			System.out.println("Inside expenseConfirm confirm section: "+userInfoStr);
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if(userInfo!=null)
			{	
				transDB = userInfo.getTransDB();
			}
	    	System.out.println("get TransDB connection in expenseConfirm : "+transDB);
	    	
		    if (transDB != null && transDB.trim().length() > 0)
		    {
		    	connectionObject = connDriver.getConnectDB(transDB);
		    }
		    else
		    {
		    	connectionObject = connDriver.getConnectDB("DriverITM");
		    }
		    connectionObject.setAutoCommit( false );
			Document dom = genericUtility.parseString(xmlData);

			parentNodeList = dom.getElementsByTagName("Detail1");
			parentNodeListLength = parentNodeList.getLength(); 
			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{				
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength::routeApprove: "+ childNodeListLength+"\n");

				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();	
					if("attribute".equalsIgnoreCase(childNodeName))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						}
					}

					
				}
			}	
			StrgSeriesPreSave preSave = new StrgSeriesPreSave();
			preSave.preSave( xmlData, updateFlag, "", connectionObject);
			
			String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
			String division = checkNull(genericUtility.getColumnValue("item_ser", dom));
			String scCode = checkNull(genericUtility.getColumnValue("sc_code", dom));
			String routeId = checkNull(genericUtility.getColumnValue("route_id",dom));
			
			String splCode = checkNull(genericUtility.getColumnValue("spl_code",dom));
			String shortId = checkNull(genericUtility.getColumnValue("short_id",dom));
			String classCode = checkNull(genericUtility.getColumnValue("class_code",dom));
			String subClassCode = checkNull(genericUtility.getColumnValue("subclass_code",dom));
			String category = checkNull(genericUtility.getColumnValue("category",dom));
			String ageBracket = checkNull(genericUtility.getColumnValue("age_bracket",dom));
			String noVisit = checkNull(genericUtility.getColumnValue("no_visit",dom));
			String noVisitPer = checkNull(genericUtility.getColumnValue("no_visit_per",dom));
			String noPatientDay = checkNull(genericUtility.getColumnValue("no_patient_day",dom));
			String maxInterval = checkNull(genericUtility.getColumnValue("max_interval_visit",dom));
			String minInterval = checkNull(genericUtility.getColumnValue("min_interval_visit",dom));
			String totalBusiness = checkNull(genericUtility.getColumnValue("total_business",dom));
			String businessToUs = checkNull(genericUtility.getColumnValue("business_to_us",dom));
			String occuType = checkNull(genericUtility.getColumnValue("occu_type",dom));
			String subsplCode = checkNull(genericUtility.getColumnValue("sub_spl_code",dom));

			String assoType = checkNull(genericUtility.getColumnValue("asso_type",dom));
			String patientProfile = checkNull(genericUtility.getColumnValue("patient_profile",dom));
			String salesPersOld = checkNull(genericUtility.getColumnValue("sales_pers__old",dom));
			String reason = checkNull(genericUtility.getColumnValue("reason",dom));
			String otehrRemark = checkNull(genericUtility.getColumnValue("other_remark",dom));
			String replyStatus = checkNull(genericUtility.getColumnValue("reply_status",dom));
			String status = checkNull(genericUtility.getColumnValue("status",dom));

			String otehr1 = checkNull(genericUtility.getColumnValue("other_1",dom));
			String otehr2 = checkNull(genericUtility.getColumnValue("other_2",dom));
			String confirm = checkNull(genericUtility.getColumnValue("confirm",dom));

			if(updateFlag.equalsIgnoreCase("A") && status.equalsIgnoreCase("N"))
			{
				status = "Y";
			}
			
			updCnt = 0;

			String updateSql = "UPDATE STRG_SERIES SET   WF_STATUS ='A',SPL_CODE=?,SHORT_ID=?,CLASS_CODE=?,SUBCLASS_CODE=?,CATEGORY=?,AGE_BRACKET=?,NO_VISIT=?,NO_VISIT_PER=?,NO_PATIENT_DAY=?,MAX_INTERVAL_VISIT=?,MIN_INTERVAL_VISIT=?, "
					+ "TOTAL_BUSINESS=?,BUSINESS_TO_US=?,OCCU_TYPE=?,SUB_SPL_CODE=?,ASSO_TYPE=? ,PATIENT_PROFILE=?,SALES_PERS__OLD=?,REASON=?,OTHER_REMARK=?,REPLY_STATUS=?,OTHER_1=?,OTHER_2=?,CONFIRM=?,STATUS=? "
					+ "  WHERE SALES_PERS = ?  AND ITEM_SER = ?  AND SC_CODE = ? AND ROUTE_ID=? "; 
			
			pstmt = connectionObject.prepareStatement(updateSql);
			
			pstmt.setString(1, splCode);
			pstmt.setString(2, shortId);
			pstmt.setString(3, classCode);
			pstmt.setString(4, subClassCode);
			pstmt.setString(5, category);
			pstmt.setString(6, ageBracket);
			pstmt.setString(7, noVisit);
			pstmt.setString(8, noVisitPer);
			pstmt.setString(9, noPatientDay);
			pstmt.setString(10, maxInterval);
			pstmt.setString(11, minInterval);
			pstmt.setString(12, totalBusiness);
			pstmt.setString(13, businessToUs);
			pstmt.setString(14, occuType);
			pstmt.setString(15, subsplCode);
			pstmt.setString(16, assoType);
			pstmt.setString(17, patientProfile);
			pstmt.setString(18, salesPersOld);
			pstmt.setString(19, reason);
			pstmt.setString(20, otehrRemark);
			pstmt.setString(21, replyStatus);
			pstmt.setString(22, otehr1);
			pstmt.setString(23, otehr2);
			pstmt.setString(24, confirm);
			pstmt.setString(25, status);

			pstmt.setString(26, salesPers);
			pstmt.setString(27,  division);
			pstmt.setString(28, scCode);
			pstmt.setString(29, routeId);

			updCnt = pstmt.executeUpdate();
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("updCnt:CustomerApprove::["+updCnt+"]");
		}
		catch (SQLException se)
		{
			try
			{
				isError=true;
				connectionObject.rollback();
			}
			catch(Exception sqe)
			{
				sqe.printStackTrace();
				isError=true; 
				returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Rollback failed during SQLException]]></RESULT></ROOT>";
           }
 			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some SQLException occurred ]]></RESULT></ROOT>";

		}
		catch( Exception ex )
		{
			try
			{
				connectionObject.rollback();
				isError=true;
			}
			catch(Exception e)
			{
				e.printStackTrace();
				isError=true;
            }
			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some other Exception came]]></RESULT></ROOT>";
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(!isError)
				{
					connectionObject.commit();
					System.out.println("Connection committed.");
				}
				if(connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}				
			}
			catch ( Exception e)
			{
				e.printStackTrace();
			}		
		}
		return returnString;
	}

	
	public String rejectionUpdate(String scCOde ,String userInfoStr ,String salesPersDom , String routeId , String localityCode ) throws RemoteException, ITMException 
	{

		System.out.println("rejectionUpdate CAALED");
		Connection conn = null;
		PreparedStatement pStmt = null;
		ConnDriver connDriver = null;
		boolean isError = false;
		String retString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ Rejected successfully ]]></RESULT></ROOT>";
		try
		{
			/*connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;*/
			//ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			
			String transDB="";
			System.out.println("Inside BeatConfirm confirm section: "+userInfoStr);
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if(userInfo!=null)
			{	
				transDB = userInfo.getTransDB();
			}
	    	System.out.println("get TransDB connection in expenseConfirm : "+transDB);
	    	
		    if (transDB != null && transDB.trim().length() > 0)
		    {
		    	conn = connDriver.getConnectDB(transDB);
		    }
		    else
		    {
		    	conn = connDriver.getConnectDB("DriverITM");
		    }
		    conn.setAutoCommit( false );

			System.out.println("localitCode ..> " + localityCode);
			localityCode = checkNull(localityCode);
			int updCnt = 0;

			String sql =  "UPDATE STRG_SERIES SET   WF_STATUS ='R'  WHERE SALES_PERS = ?    AND SC_CODE = ? AND ROUTE_ID=?  ";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, salesPersDom);
			pStmt.setString(2, scCOde);
			pStmt.setString(3, routeId);
			updCnt = pStmt.executeUpdate();
			pStmt.clearParameters();
			System.out.println("in rejection records updated count is >>> "+updCnt);
			
			if(updCnt == 0)
			{
				retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[ Rejection Update failed for tran_id "+scCOde+"  ]]></RESULT></ROOT>";
			}
			System.out.println("updCntupdCnt:::["+updCnt+"]");
		} 
		catch (Exception e) 
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			if (conn != null) 
			{
				try 
				{
					if (isError) 
					{
						conn.rollback();
						System.out.println("BeatConfirm Connection Rollback");
					} 
					else 
					{
						conn.commit();
						System.out.println("BeatConfirm Connection Commit");
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}													
					
				}
				catch (Exception e) 
				{
					e.printStackTrace();
				}
			}
		}
		return retString;
	}
	public String checkMode( String refID ,String xmlData ,String signBy ,String refSer, String SalesPers, String appoverCode ,String userInfoStr )throws RemoteException, ITMException
	{
		//String xtraParams ="";
		System.out.println("[checkMode] SprsRouteConfirmation Method called..."+signBy+"]::appoverCode:::["+appoverCode+"]");
		System.out.println("tranID : ["+refID+"]");
		System.out.println("xmlData : ["+xmlData+"]");
		System.out.println("refSer : ["+refSer+"]");
		boolean isError=false;
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInner = null;
		ResultSet rsInner = null;
		String returnString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
		String retString = "0";
		try
		{
			
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			 
			
			String transDB="";
			System.out.println("Inside expenseConfirm confirm section: "+userInfoStr);
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if(userInfo!=null)
			{	
				transDB = userInfo.getTransDB();
			}
	    	System.out.println("get TransDB connection in expenseConfirm : "+transDB);
	    	
		    if (transDB != null && transDB.trim().length() > 0)
		    {
		    	connectionObject = connDriver.getConnectDB(transDB);
		    }
		    else
		    {
		    	connectionObject = connDriver.getConnectDB("DriverITM");
		    }
		    connectionObject.setAutoCommit( false );
			Document dom = genericUtility.parseString(xmlData);
			
			String salesPersDom = checkNull(genericUtility.getColumnValue("sales_pers",dom));
			String routeIdDom = checkNull(genericUtility.getColumnValue("route_id",dom));
			String localityCodeDom  = checkNull(genericUtility.getColumnValue("locality_code",dom));
			String itemSer  = checkNull(genericUtility.getColumnValue("item_ser",dom));
			String SCCode  = checkNull(genericUtility.getColumnValue("sc_code",dom));

			
			String tourCntSql = "SELECT COUNT(*) AS CNT FROM STRG_SERIES WHERE SC_CODE = ?   AND ROUTE_ID = ? AND ITEM_SER=? ";
			pstmtInner = connectionObject.prepareStatement(tourCntSql);
			pstmtInner.setString(1, SCCode);
			pstmtInner.setString(2,  localityCodeDom);
			pstmtInner.setString(3, routeIdDom);
			pstmtInner.setString(4, itemSer);

			rsInner = pstmtInner.executeQuery();
			int submitCnt = 0;
			if ( rsInner.next() )
			{				
				submitCnt = rsInner.getInt("CNT");
			}
			System.out.println("submitCnt..["+submitCnt+"]");
			if ( rsInner != null )
			{
				rsInner.close();
				rsInner = null;
			}
			if ( pstmtInner != null )
			{
				pstmtInner.close();
				pstmtInner = null;
			}
			
			if (submitCnt > 0)
			{
				retString = "<ROOT><STATUS><![CDATA[1]]></STATUS></ROOT>";
			}
			else
			{
				retString = "<ROOT><STATUS><![CDATA[0]]></STATUS></ROOT>";
			}	
			
		}
		catch (SQLException se)
		{
			try
			{
				isError=true;
				connectionObject.rollback();
			}
			catch(Exception sqe)
			{
				sqe.printStackTrace();
				isError=true; 
				returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Rollback failed during SQLException]]></RESULT></ROOT>";
           }
 			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some SQLException occurred ]]></RESULT></ROOT>";

		}
		catch( Exception ex )
		{
			try
			{
				connectionObject.rollback();
				isError=true;
			}
			catch(Exception e)
			{
				e.printStackTrace();
				isError=true;
            }
			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some other Exception came]]></RESULT></ROOT>";
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(!isError)
				{
					connectionObject.commit();
					System.out.println("Connection committed.");
				}
				if(connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}				
			}
			catch ( Exception e)
			{
				e.printStackTrace();
			}		
		}
		System.out.println("before return ..["+retString+"]");
		return retString ;
	}

	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	//Added by Bhagyashri T For Checking approver is HO or not[26/04/21][START][W21ASUN046]
	public String findNextApprover(String refSer, String refId, String salesPers, String currApprover, String xmlString ,String userInfoStr ) throws RemoteException, ITMException
	{

		System.out.println("findNextApprover is called......");
		Connection conn = null;
		ConnDriver connDriver = null;
		PreparedStatement pstmtEmp = null;
		PreparedStatement pstmtobjSign = null;
		PreparedStatement pstmtUpd = null;
		ResultSet rsEmp = null;
		ResultSet rsObjSign = null;
		String nextAprvr = "";
		String reportTo = "";
		String entityCode = "";
		String gradeLevel ="";
		boolean isHOF=false;
		java.sql.Date relieveDate = null;
		boolean isError = false;
		
		try 
		{
			System.out.println("refSer =["+refSer+"], refId =["+refId+"], salesPers =["+salesPers+"], currApprover =["+currApprover+"]");
			String transDB = "";
		      System.out.println("Inside STRGSERIESConfirm confirm section: " + userInfoStr);
		      connDriver = new ConnDriver();
		      UserInfoBean userInfo = new UserInfoBean(userInfoStr);
		      if (userInfo != null)
		      {
		        transDB = userInfo.getTransDB();
		      }
		      System.out.println("get TransDB connection in STRGSERIESConfirm : " + transDB);
	
		      if ((transDB != null) && (transDB.trim().length() > 0))
		      {
		        conn = connDriver.getConnectDB(transDB);
		      }
		      else
		      {
		        conn = connDriver.getConnectDB("DriverITM");
		      }
				conn.setAutoCommit(false);
				String signTransSql = "SELECT ENTITY_CODE FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS ='S' AND LINE_NO = (SELECT MAX(LINE_NO) FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS ='S')";
				pstmtobjSign = conn.prepareStatement(signTransSql);
				pstmtobjSign.setString(1, refSer);
				pstmtobjSign.setString(2, refId);
				pstmtobjSign.setString(3, refSer);
				pstmtobjSign.setString(4, refId);
				rsObjSign = pstmtobjSign.executeQuery();
				if(rsObjSign.next())
				{
					entityCode = checkNull(rsObjSign.getString("ENTITY_CODE"));
				}
				if (rsObjSign != null)
				{
					rsObjSign.close();
					rsObjSign = null;
				}
				if ( pstmtobjSign != null )
				{
					pstmtobjSign.close();
					pstmtobjSign = null;
				}
				System.out.println("entityCode =["+entityCode+"]");
				String empSql = "SELECT TRIM(REPORT_TO) AS REPORT_TO FROM EMPLOYEE WHERE EMP_CODE = ? ";
				pstmtEmp = conn.prepareStatement(empSql);
				pstmtEmp.setString(1, entityCode);
				rsEmp = pstmtEmp.executeQuery();
				if(rsEmp.next())
				{
					reportTo = checkNull(rsEmp.getString("REPORT_TO"));
				if(rsEmp != null)
				{
					rsEmp.close();
					rsEmp = null;
				}
				if(pstmtEmp != null)
				{
					pstmtEmp.close();
					pstmtEmp = null;
				}
				System.out.println("Report to CONF =["+reportTo+"]");
				if (reportTo == null || reportTo.trim().length() == 0)
				{
					nextAprvr = "NO";  //Report_To is HO
				}
				else
				{
					String sql=" SELECT TRIM(GRADE.LEVEL_NO) AS APRV_LEVEL FROM GRADE GRADE, EMPLOYEE EMP WHERE EMP.GRADE = GRADE.GRADE_CODE"
							+ " AND EMP.EMP_CODE = ? AND RELIEVE_DATE IS NULL ";
						
					pstmtEmp = conn.prepareStatement(sql);
					pstmtEmp.setString(1, reportTo);
					rsEmp = pstmtEmp.executeQuery();
					if(rsEmp.next())
					{
						gradeLevel = checkNull(rsEmp.getString("APRV_LEVEL"));
					}
					if(rsEmp != null)
					{
						rsEmp.close();
						rsEmp = null;
					}
					if(pstmtEmp != null)
					{
						pstmtEmp.close();
						pstmtEmp = null;
					}
					System.out.println("gradeLevel CONF =["+gradeLevel+"]");
					if (gradeLevel == null || gradeLevel.trim().length() == 0)
					{
						nextAprvr = "NO";  //Report_To is HO
					}
					else
					{
						if(gradeLevel.equalsIgnoreCase("1") || gradeLevel.equalsIgnoreCase("2") || gradeLevel.equalsIgnoreCase("3") || gradeLevel.equalsIgnoreCase("4"))
						{
							nextAprvr = "YES";
						}
						else
						{
							nextAprvr = "NO";    //Report_To is HO
						}
					}
				}	
			}
		}
		catch (Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally
		{
			try
			{
				if(rsEmp != null)
				{
					rsEmp.close();
					rsEmp = null;
				}
				if(rsObjSign != null)
				{
					rsObjSign.close();
					rsObjSign = null;
				}
				if(pstmtEmp != null)
				{
					pstmtEmp.close();
					pstmtEmp = null;
				}
				if(pstmtobjSign != null)
				{
					pstmtobjSign.close();
					pstmtobjSign = null;
				}
				if(conn != null)
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		System.out.println("nextAprvr =["+nextAprvr+"]");
		return nextAprvr;	
	}	
	//Added by Bhagyashri T For Checking approver is HO or not[26/04/21][end][W21ASUN046]
}
