package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.itextpdf.text.log.SysoCounter;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

@Stateless
public class StrgCustomerType extends ValidatorEJB {
	
	protected static String database = CommonConstants.DB_NAME;

	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException {
		
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try {
			BaseLogger.log("3",null,null,"xmlString:::" + xmlString);

			if (xmlString != null && xmlString.length() != 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.length() != 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.length() != 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		} catch (Exception e) {
			BaseLogger.log("3",null,null,"Exception : HealthProfile : wfValData(String xmlString) : ==>\n " + e.getMessage());
		}
		return errString;
	}

	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException {
		Connection conn = null;
		conn = getConnection();

		PreparedStatement ptmt = null;
		
		ResultSet rs = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility utility = new E12GenericUtility();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

		
		BaseLogger.log("3",null,null,"wfValData.....called.[HealthProfile]");
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String columnValue = "";
		
		int ctr = 0, currentFormNo = 0, childNodeListLength = 0, cnt = 0;
		String errString = "", errCode = "", userId = "";
		String hrProfile = "", descr = "", shortDescr = "", profType = "", mesuremType = "", recordfreq = "";
		String msrType = "";
		try {
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}
			BaseLogger.log("3",null,null,"wdom:::::::::: : " + genericUtility.serializeDom(dom));
			BaseLogger.log("3",null,null,"wdom11111111111111:::::::::: : " + genericUtility.serializeDom(dom1));
			BaseLogger.log("3",null,null,"wdom222222222222222:::::::::: : " + genericUtility.serializeDom(dom2));
			switch (currentFormNo) {
			case 1:// First Form
				parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				BaseLogger.log("3",null,null,"child node list length=" + childNodeListLength);
				for (ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					BaseLogger.log("3",null,null,"idchildNodeName.editFlag." + childNodeName + ".." + editFlag);

					if (childNodeName.equalsIgnoreCase("type")) 
					{
						BaseLogger.log("3",null,null,"---- FirstChild::" + childNode.getFirstChild());
						System.out.println("firstchild: "+childNode.getFirstChild());
						if (childNode.getFirstChild() == null) 
						{
							errString =itmDBAccessEJB.getErrorString("type","NULCUSTTYP",userId);
							break ;
						}
						if (childNode.getFirstChild() != null && editFlag.equalsIgnoreCase("A")) 
						{
							columnValue = checkNull(childNode.getFirstChild().getNodeValue().trim());
							
							System.out.println("coluomn value 11/5: "+columnValue);
							BaseLogger.log("3",null,null,"--VINKITA-- columnValue::" + columnValue);
							if (columnValue!= null)
							{
								String sql= "SELECT TYPE FROM STRG_CUST_TYPE  WHERE TYPE = ?";
								ptmt = conn.prepareStatement(sql);
								ptmt.setString(1, columnValue);
								rs= ptmt.executeQuery();
								if(rs.next()) {
									errString = getErrorString("type","TYPEDUP", userId);
									break;
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(ptmt != null)
								{
									ptmt.close();
									ptmt = null;
								}
								
							}
						}
					}
					
					else if ( childNodeName.equalsIgnoreCase("descr") )
					{
						String descr1= E12GenericUtility.checkNull( genericUtility.getColumnValue("descr", dom) ).trim();
						if( descr1 == null || descr1.length() <= 0 ) 
						{
							errString = getErrorString("descr", "NULCUSTDES", userId);
							break;
						}
						
						if (childNode.getFirstChild()!= null && editFlag.equalsIgnoreCase("A"))
						{
						
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							System.out.println("columnValue360["+columnValue+"]");
							if( columnValue != null )
							{
								System.out.println("duplicate block of the descr 25/5/22");
								String sql = "SELECT DESCR FROM STRG_CUST_TYPE WHERE DESCR  = ?";
								ptmt = conn.prepareStatement(sql);
								ptmt.setString(1, columnValue);
								rs = ptmt.executeQuery();
								if (rs.next())
								{
									errString = getErrorString("descr","Descrdup", userId);
									break;
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(ptmt != null)
								{
									ptmt.close();
									ptmt = null;
								}
								
								
							}
						}
					}
					
						
						
					else if (childNodeName.equalsIgnoreCase("enterprise"))
					{
						System.out.println("ENTERPRISE VALIDATION ");
						BaseLogger.log("3",null,null,"--- FirstChild::" + childNode.getFirstChild());
						
						
						System.out.println("-- FirstChild::" + childNode.getFirstChild());
						if (childNode.getFirstChild() != null && editFlag.equalsIgnoreCase("A"))
							
						{
							columnValue = checkNull(childNode.getFirstChild().getNodeValue());
							System.out.println(childNode.getFirstChild().getNodeValue());


							if (columnValue!= null)
							{
								String sql= "SELECT ENTERPRISE FROM STRG_CUST_TYPE  WHERE ENTERPRISE = ?";
								ptmt = conn.prepareStatement(sql);
								ptmt.setString(1, columnValue);
								rs= ptmt.executeQuery();
								if(rs.next()) {
									errString = getErrorString("enterprise", "Entpdup", userId);
									break;
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(ptmt != null)
								{
									ptmt.close();
									ptmt = null;
								}
								
							}
						}
						
						if(childNode.getFirstChild() != null)
                        {
							System.out.println("pophelp validation else block");
							
							
							int code =0;	
							String entp = checkNull(genericUtility.getColumnValue( "enterprise", dom ));

							String Sql="SELECT COUNT(*) AS COUNT FROM ENTERPRISE  WHERE ENTERPRISE = ?";
							
							ptmt=conn.prepareStatement(Sql);
							
							ptmt.setString(1, entp);
							
							
							rs = ptmt.executeQuery();
							if (rs.next())
							{
							
								code = rs.getInt("COUNT");
								System.out.println("colvalue of enterprise: "+ rs.getInt("COUNT"));

							}
							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
							if(ptmt!=null)
							{
								ptmt.close();
								ptmt = null;
							}
							
							if (code == 0) 
							{
								errString = getErrorString("enterprise", "INVENTPOP", userId); 
								break;
							}		
							
                         }
					
					 }
					else if (childNodeName.equalsIgnoreCase("survey_templ"))
					{
						System.out.println("survey templ VALIDATION ");
						BaseLogger.log("3",null,null,"-- FirstChild::" + childNode.getFirstChild());
						if (childNode.getFirstChild() != null && editFlag.equalsIgnoreCase("A"))
							
						{
							columnValue = checkNull(childNode.getFirstChild().getNodeValue());


							if (columnValue!= null)
							{
								String sql= "SELECT SURVEY_TEMPL FROM STRG_CUST_TYPE  WHERE SURVEY_TEMPL = ?";
								ptmt = conn.prepareStatement(sql);
								ptmt.setString(1, columnValue);
								rs= ptmt.executeQuery();
								if(rs.next()) {
									errString = getErrorString("survey_templ","SURVEYDUP", userId);
									break;
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(ptmt != null)
								{
									ptmt.close();
									ptmt = null;
								}
								
							}
						}
						

						if(childNode.getFirstChild() != null)
                        {
							System.out.println("pophelp validation SURVEY TEMPLATE  else block ");
							
							
							int code =0;	
							String entp = checkNull(genericUtility.getColumnValue( "survey_templ", dom ));

							String Sql="SELECT COUNT(*) AS COUNT FROM SURVEY_TEMPLATE  WHERE SURVEY_TEMPL = ?";
							
							ptmt=conn.prepareStatement(Sql);
							
							ptmt.setString(1, entp);
							
							
							rs = ptmt.executeQuery();
							if (rs.next())
							{
							
								code = rs.getInt("COUNT");
								System.out.println("colvalue of SURVEY_TEMPL: "+ rs.getInt("COUNT"));

							}
							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
							if(ptmt!=null)
							{
								ptmt.close();
								ptmt = null;
							}
							
							if (code == 0) 
							{
								errString = getErrorString("survey_templ", "INVSURVEY", userId); 
								break;
							}		
							
                         }
					
					 }


				}
				
				break;
			}
		}
	
		catch (Exception e) {
			BaseLogger.log("3",null,null,"Exception ::" + e);
			e.printStackTrace();
			errString = e.getMessage();
		} finally {
			try {
				if (conn != null) {
					conn.close();
					conn = null;
				}
				
			} catch (Exception d) {
				d.printStackTrace();
			}
		}
		BaseLogger.log("3",null,null,"ErrString ::" + errString);
		return errString;

	}

	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext,
			String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
				
		GenericUtility genericUtility = GenericUtility.getInstance();

		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";

		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				BaseLogger.log("3",null,null,"xmlString>>>>" + xmlString);
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				BaseLogger.log("3",null,null,"xmlString1>>>>" + xmlString1);
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				BaseLogger.log("3",null,null,"xmlString2>>>>" + xmlString2);
				dom2 = genericUtility.parseString(xmlString2);
				BaseLogger.log("3",null,null,"dom2:::-" + genericUtility.serializeDom(dom2));
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		} catch (Exception e) {
			BaseLogger.log("3",null,null,"Exception :HealthProfile:itemChanged::::" + e.getMessage() + ":");
			e.printStackTrace();
		}
		BaseLogger.log("3",null,null,"returning from HealthProfile:itemChanged itemChanged");

		return valueXmlString;
	}

	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws RemoteException, ITMException {
		Connection conn = null;
		conn = getConnection();

		GenericUtility genericUtility = GenericUtility.getInstance();
		
		BaseLogger.log("3",null,null,"Itemchanged Called[HealthProfile]-------");
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		String userId = "";
		String empName ="";
		String thGroup = "";
		
		PreparedStatement ppstmt = null;
		Statement pstmt = null;
		ResultSet rs = null;
		ResultSet rSet = null;
		
		String chgDate = "", chgUser = "", chgTerm = "", addDate="", addUser="", addTerm="";
		SimpleDateFormat sdf;
		Timestamp timestamp;
		try {
			BaseLogger.log("3",null,null,"dom:::::::::: : " + genericUtility.serializeDom(dom));
			BaseLogger.log("3",null,null,"dom11111111111111:::::::::: : " + genericUtility.serializeDom(dom1));
			BaseLogger.log("3",null,null,"dom222222222222222:::::::::: : " + genericUtility.serializeDom(dom2));
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			//------------------------------------------
			String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			
			//--------------------------------------------------------
			timestamp = new Timestamp(System.currentTimeMillis());
			chgDate = (sdf.format(timestamp).toString()).trim();
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			BaseLogger.log("3",null,null,"Change Date :::-[" + chgDate + "]\n Change User:::-[" + chgUser
					+ "] \n Change Term:::-[" + chgTerm + "]");
			addDate = chgDate;
			addUser = chgUser;
			addTerm = chgTerm;
			if (objContext != null && objContext.trim().length() > 0)
				currentFormNo = Integer.parseInt(objContext);
			BaseLogger.log("3",null,null,"current form no: " + currentFormNo);
			currentColumn = currentColumn == null ? "" : currentColumn.trim();
			BaseLogger.log("3",null,null,"currentColumn : " + currentColumn);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch (currentFormNo) {
			case 1:// first From
				valueXmlString.append("<Detail1>");
				
				//------------------------------------------------------------------------
				if ("itm_default".equalsIgnoreCase(currentColumn)) 
				{	
					
					
					try {
						//--------------------------------------------------------------------
					
						String getGradeCodeSql =  "SELECT NAME FROM USERS WHERE EMP_CODE=?";

						ppstmt = conn.prepareStatement(getGradeCodeSql);
					
						ppstmt.setString(1,loginEmpCode);
						rSet = ppstmt.executeQuery();
						 
						
						if( rSet.next())
						{
							empName =rSet.getString("NAME");
							System.out.println("Name of empNameinfo "+empName);
							System.out.println("Name of usersid");
						}
						if(rSet != null)
						{
							rSet.close();
							rSet = null;
						}
						if(ppstmt != null)
						{
							ppstmt.close();
							ppstmt = null;
						}
						
						
						}catch(Exception e) {
							System.out.println("@@@@username:"+e.getMessage());
							e.printStackTrace();
							
						}
					System.out.println("@@@@ loginEmpCode ::"+loginEmpCode);
					userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
					
					System.out.println("UserIdInfo:"+userId);
					
					//SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
					SimpleDateFormat formatter = new SimpleDateFormat(genericUtility.getApplDateFormat()); 
					Date dte = new Date();
					String currentDate = "";
					BaseLogger.log("3",null,null,"current Date::" + dte);
					try 
					{
						currentDate = formatter.format(dte);
						BaseLogger.log("3",null,null,"String current Date::" + currentDate);
					} 
					catch (Exception ae) {
					}
					
					//it is used to fetch the userid who already login 
					//valueXmlString.append( "<user_id>" ).append( userId ).append( "</user_id>\r\n" );
					valueXmlString.append( "<user_id><![CDATA[" ).append( userId ).append( "]]></user_id>" );
					
					
					valueXmlString.append("<tran_date>").append("<![CDATA[" + currentDate + "]]>").append("</tran_date>");
					valueXmlString.append("<status_date>").append("<![CDATA[" + currentDate + "]]>").append("</status_date>");
					//------------------------------------------------------------------------
					
				
					//it is used to fetch the of user who login 
					//valueXmlString.append("<users_name><![CDATA[").append(empName).append("]]></users_name>");
					valueXmlString.append( "<users_name><![CDATA[" ).append( empName ).append( "]]></users_name>\r\n" );
					System.out.println(" valueXmlString::"+valueXmlString);
					
					
					//-----------------------------------------------------------------------
				 } 
				 
				//it is used to fetch thename of the user after clicking on the name of pophelp the name is fetch which you selected in pophelp
				else if( "enterprise".equalsIgnoreCase(currentColumn) )
				{
				    try
				    {
				    	
				    	
				    	String code = genericUtility.getColumnValue("enterprise",dom);
					    System.out.println("thGroup ["+thGroup+"]");
					 
				     	String sql = "SELECT ENTERPRISE_DESCR FROM ENTERPRISE WHERE ENTERPRISE ='"+code+"'";
				    	System.out.println("thGroup sql["+sql+"]");
				
					    pstmt = conn.createStatement();
					    rs = pstmt.executeQuery( sql );
					    System.out.println("sqlQuery:"+rs);
					    String Name = "";
					    if( rs.next() )
					    {
					    	Name=rs.getString("ENTERPRISE_DESCR") != null ? rs.getString("ENTERPRISE_DESCR").trim() : "" ;
					    	System.out.println("Triuser1"+Name);
			
					    }
					    if(rs != null)
						{
							rs.close();
							rs = null;
						}
					    if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					  
					    valueXmlString.append("<enterprise_enterprise_descr><![CDATA[" ).append( Name ).append( "]]></enterprise_enterprise_descr>\r\n" );
			
					//valueXmlString.append("</Detail1></Root>");
					}
				    catch(Exception e)
					{
						System.out.println("Hello");
						e.printStackTrace();
					}
				    
				}
				
				
				 
				//it is used to fetch thename of the user after clicking on the name of pophelp the name is fetch which you selected in pophelp
				else if( "survey_templ".equalsIgnoreCase(currentColumn) )
				{
				    try
				    {
				    	
				    	
				    	String code = genericUtility.getColumnValue("survey_templ",dom);
					    System.out.println("thGroup ["+thGroup+"]");
					 
				     	String sql = "SELECT DESCR FROM SURVEY_TEMPLATE WHERE SURVEY_TEMPL ='"+code+"'";
				    	System.out.println("thGroup sql["+sql+"]");
				
					    pstmt = conn.createStatement();
					    rs = pstmt.executeQuery( sql );
					    System.out.println("sqlQuery:"+rs);
					    String Name = "";
					    if( rs.next() )
					    {
					    	Name=rs.getString("DESCR") != null ? rs.getString("DESCR").trim() : "" ;
					    	System.out.println("Triuser1"+Name);
			
					    }
					    if(rs != null)
						{
							rs.close();
							rs = null;
						}
					    if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					  
					    valueXmlString.append("<survey_template_descr><![CDATA[" ).append( Name ).append( "]]></survey_template_descr>\r\n" );
			
					//valueXmlString.append("</Detail1></Root>");
					}
				    catch(Exception e)
					{
						System.out.println("Hello");
						e.printStackTrace();
					}
				}
				//------------------------------------------------------------------------------
				
				//it is used for edit purpose because you use compute for column user_assigned_name in free 
				else if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit")) 
				{
					String code = genericUtility.getColumnValue("user_id_assigned",dom);
					String sql = "SELECT NAME FROM USERS WHERE CODE=?";
					System.out.println("thGroup sql["+sql+"]");
					pstmt = conn.createStatement();
					rs = pstmt.executeQuery( sql );
					System.out.println("sqlQuery:"+rs);
					String Name = "";
					if( rs.next() )
					{
						
						Name=rs.getString("NAME") != null ? rs.getString("NAME").trim() : "" ;
						//fldValue = checkNull(rs.getString("CODE"));
			
						//valueXmlString.append("<users_name_1>").append( Name ).append("</users_name_1>");
						valueXmlString.append("<user_assigned_name><![CDATA[" ).append( Name ).append( "]]></user_assigned_name>\r\n" );
						
						System.out.println("Triuser1"+Name);
					}
					 
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					
					//valueXmlString.append("<chg_date>").append("<![CDATA[" + chgDate + "]]>").append("</chg_date>");
					
//					System.out.println("ankit code::"+code);
					
					
				}
				valueXmlString.append("</Detail1>");
				break;

			

			}// End Switch
			valueXmlString.append("</Root>");
		} // End Try

		catch (Exception e) {
			e.printStackTrace();
			BaseLogger.log("3",null,null,"Exception ::" + e.getMessage());
			throw new ITMException(e);
		} 
		finally 
		{
			try {
				if (conn != null) {
					conn.close();
					conn = null;
				}
				
			} catch (Exception d) {
				d.printStackTrace();
			}
		}
		BaseLogger.log("3",null,null,"\n HealthProfile:ValueXmlString :" + valueXmlString + ":*******");
		return valueXmlString.toString();

	}

	public static String checkNull(String input) {
		if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
			input = "";
		}
		return input.trim();
	}
}