/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.hibernate.bean.ObjUserPref;
import ibase.hibernate.dao.ObjUserPrefDao;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONObject;

@Path(value="/")
public class ObjUserPrefService {
    @Context
    HttpServletRequest request;
    @Context
    ServletContext context;

    @POST
    @Path(value="/exploreReport/{objName}/{reportName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response saveExploreReport(@PathParam(value="objName") String objName, @PathParam(value="reportName") String reportName, String reportConfig) throws Exception {
        UserInfoBean userInfo = this.getUserInfo();
        BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In saveExploreReport [" + reportName + "] reportConfig[" + reportConfig + "]"));
        JSONObject respJsonObject = new JSONObject();
        String trandDb = userInfo.getTransDB();
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("trandDb for save explore report==>" + trandDb));
        try {
            if (userInfo != null) {
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("if user info is not null==>" + userInfo));
                ObjUserPrefDao objUserPrefDao = new ObjUserPrefDao();
                String loginCode = userInfo.getLoginCode();
                objUserPrefDao.saveExploreReport(loginCode, objName, reportName, reportConfig, trandDb);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("util result for save explore report==>" + objUserPrefDao));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            respJsonObject.put("result", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @DELETE
    @Path(value="/deleteExploreReport/{objName}/{prefName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteExploreReport(@PathParam(value="objName") String objName, @PathParam(value="prefName") String prefName, String reportConfig) throws Exception {
        System.out.println("objName::::::" + objName + "prefName:::::" + prefName);
        ObjUserPrefDao ObjUserPre = new ObjUserPrefDao();
        JSONObject resultJson = new JSONObject();
        UserInfoBean userInfo = this.getUserInfo();
        System.out.println("userInfo:::::: " + userInfo);
        String tranDB = userInfo.getTransDB();
        String loginCode = userInfo.getLoginCode();
        System.out.println("tranDB:::::::::::" + tranDB);
        String str = ObjUserPre.deleteExploreReport(loginCode, objName, prefName, reportConfig, tranDB);
        resultJson.put("result", (Object)str);
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @GET
    @Path(value="/exploreReport/{loginCode}/{objName}/{reportName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getExploreReport(@PathParam(value="loginCode") String loginCode, @PathParam(value="objName") String objName, @PathParam(value="reportName") String reportName) throws Exception {
        UserInfoBean userInfo = this.getUserInfo();
        BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In getExploreReport [" + reportName + "]"));
        JSONObject respJsonObject = new JSONObject();
        String tranDB = userInfo.getTransDB();
        try {
            if (userInfo != null) {
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("inside dashboard service if userInfo is not null for get Explore report" + userInfo));
                ObjUserPrefDao objUserPrefDao = new ObjUserPrefDao();
                ObjUserPref userPref = objUserPrefDao.getExploreReport(loginCode, objName, reportName, tranDB);
                JSONObject reportConfig = new JSONObject(userPref.getPrefValue());
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("jsonObjectof reportConfig in get Explore Report===>" + reportConfig));
                if (reportConfig != null) {
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("if reportConfig is not null in getExploreReport ===>" + reportConfig));
                    respJsonObject.put("result", (Object)"success");
                    respJsonObject.put("report", (Object)reportConfig);
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("respJsonObject in getExploreReport===>" + reportConfig));
                } else {
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"in else of get Explore report");
                    respJsonObject.put("result", (Object)"failure");
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)"exception in service for get explore report");
            e.printStackTrace();
            respJsonObject.put("result", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    private UserInfoBean getUserInfo() {
        UserInfoBean userInfo = null;
        HttpSession session = this.request.getSession();
        Object userObj = session.getAttribute("USER_INFO");
        if (userObj != null) {
            try {
                userInfo = new UserInfoBean(userObj.toString());
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        return userInfo;
    }

    @POST
    @Path(value="/userPreference/{objName}/{prefName}/{prefValType}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response setObjectPreference(@PathParam(value="objName") String objName, @PathParam(value="prefName") String prefName, @PathParam(value="prefValType") String prefValType, String prefValue) throws Exception {
        JSONObject respJsonObject = new JSONObject();
        UserInfoBean userInfo = this.getUserInfo();
        try {
            if (userInfo != null) {
                ObjUserPrefDao objUserPrefDao = new ObjUserPrefDao();
                objUserPrefDao.setObjectPreference(userInfo, objName, prefName, prefValue, prefValType);
            }
        }
        catch (ITMException itmexp) {
            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("Exception in setObjectPreference [" + itmexp.getMessage() + "]"));
            respJsonObject.put("result", (Object)"failure");
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("Exception in setObjectPreference [" + e + "]"));
            e.printStackTrace();
            respJsonObject.put("result", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @GET
    @Path(value="/userPreference/{objName}/{prefName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getObjectPreference(@PathParam(value="objName") String objName, @PathParam(value="prefName") String prefName) throws Exception {
        JSONObject respJsonObject = new JSONObject();
        UserInfoBean userInfo = this.getUserInfo();
        try {
            if (userInfo != null) {
                ObjUserPrefDao objUserPrefDao = new ObjUserPrefDao();
                ObjUserPref userPref = objUserPrefDao.getObjectPreference(userInfo, objName, prefName);
                if (userPref != null) {
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"In if of getObjectPreference");
                    respJsonObject.put("result", (Object)"success");
                    respJsonObject.put("prefVal", (Object)userPref.getPrefValue());
                    respJsonObject.put("prefValType", (Object)userPref.getPrefValueType());
                } else {
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"In else of getObjectPreference");
                    respJsonObject.put("result", (Object)"failure");
                }
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("respJsonObject in getObjectPreference :[" + respJsonObject + "]"));
            }
        }
        catch (ITMException itmexp) {
            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("Exception in getObjectPreference [" + itmexp.getMessage() + "]"));
            respJsonObject.put("result", (Object)"failure");
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("Exception in getObjectPreference [" + e + "]"));
            e.printStackTrace();
            respJsonObject.put("result", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @GET
    @Path(value="/exploreReport/{objName}/layouts")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getAllLayoutPreferences(@PathParam(value="objName") String objName) throws Exception {
        UserInfoBean userInfo = this.getUserInfo();
        BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In getAllLayoutPreferences [" + objName + "]"));
        JSONObject respJsonObject = new JSONObject();
        String tranDB = userInfo.getTransDB();
        try {
            if (userInfo != null) {
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("inside dashboard service if userInfo is not null for get Explore report" + userInfo));
                ObjUserPrefDao objUserPrefDao = new ObjUserPrefDao();
                String loginCode = userInfo.getLoginCode();
                JSONObject allUserPrefJsonObj = objUserPrefDao.getAllLayoutPreferences(loginCode, objName, tranDB);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"jsonObjectof reportConfig in get Explore Report===>");
                if (allUserPrefJsonObj != null) {
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"if reportConfig is not null in getExploreReport ===>");
                    respJsonObject.put("result", (Object)"success");
                    respJsonObject.put("allLayoutPref", (Object)allUserPrefJsonObj);
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"respJsonObject in getExploreReport===>");
                } else {
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"in else of get Explore report");
                    respJsonObject.put("result", (Object)"failure");
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)"exception in service for get explore report");
            e.printStackTrace();
            respJsonObject.put("result", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }
}

