package ibase.webitm.ejb.wsfa.masters;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import java.rmi.RemoteException;
import java.sql.DriverManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.DOMException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.ejb.Stateless;
import javax.ejb.CreateException;
import java.text.SimpleDateFormat;
import java.util.Vector;

import javax.naming.InitialContext;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
public class SprsStockistStatusChgPrcGWT extends ProcessEJB 
{
	GenericUtility genericUtility = GenericUtility.getInstance();

	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	//PROCESS
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
			String retStr = "";
			Document detailDom = null;
			Document headerDom = null;
			try
			{	
				System.out.println("@@@@ inside try block of process() method...");
				if(xmlString != null && xmlString.trim().length()!=0)
				{
					System.out.println("@@@@ xmlString in process() method : "+xmlString);
					headerDom = genericUtility.parseString(xmlString); 
					//System.out.println("@@@@ headerDom" + headerDom);
				}
				if(xmlString2 != null && xmlString2.trim().length()!=0)
				{
					System.out.println("@@@@ xmlString2 in process() method : "+xmlString2);
					detailDom = genericUtility.parseString(xmlString2); 
					//System.out.println("@@@@ detailDom" + detailDom);
				}
										
			    retStr = process(headerDom, detailDom, windowName, xtraParams);
			}
			catch (Exception e)
			{
				System.out.println("@@@@ Exception :SprsStockistStatusChgPosGWT :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
				e.printStackTrace();
				retStr = e.getMessage();
			}
			return retStr;
		
	}//END OF PROCESS (1)
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams,UserInfoBean userInfoBean) throws RemoteException,ITMException
	{
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		String termId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
		String currentDate = null;
		java.sql.Timestamp sysDate = null;
		String salesPerson = "";
		String status = "";
		String statusOld = "";
		String custCode = "";
		String custName = "";
		String updateSql = "";
		String selectSql = "";
		String locDescr = "";
		String isSelect = "";
		String localityCode = "";
		String routeID = "";
		String routeStatus = "";

		int shortID = 0;
		int updCnt = 0;
		int updCntSt = 0;
		int cntrCust = 0;
		int msgCntr = 0;
		int noOfSelect = 0;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		int parentNodeListLength =0;
		int childNodeListLength = 0;
		String childNodeName = "";
		Node parentNode = null;
		Node childNode = null;

		Connection conn = null;
		ResultSet rs = null;
		//Statement stmt = null;
		PreparedStatement pstmt = null;
		String errString = "";
		StringBuffer strBuff = new StringBuffer();
		StringBuffer msgBuff = new StringBuffer();
		int msgCtr = 0;

		String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");

		try
		{
			System.out.println("@@@@ inside try block of process(Document headerDom, Document detailDom, String windowName, String xtraParams) method...");
			ConnDriver connDriver = new ConnDriver();
			//commented & added userinfo in process method for creating connection(start) 

			//conn = connDriver.getConnectDB("DriverITM");
			String transDB = userInfoBean.getTransDB();
			System.out.println("transDB is process["+transDB+"]");
			if(transDB != null && transDB.trim().length() > 0 && !"null".equalsIgnoreCase(transDB))
			{
				conn = connDriver.getConnectDB(transDB);
				conn.setAutoCommit(false);

			}
			else
			{
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);

			}
			//commented & added userinfo in process method for creating connection(end) 

            SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currentDate = sdf.format(new java.util.Date());
			sysDate = java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(currentDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
           
			parentNodeList = detailDom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength(); 
			salesPerson = genericUtility.getColumnValue("sprs_code",headerDom);

			selectSql = "SELECT CASE WHEN MAX(SHORT_ID) IS NULL THEN 0 ELSE MAX(SHORT_ID) END "+
						"FROM SPRS_STOCKIST WHERE SPRS_CODE = ? AND STATUS = 'Y' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString(1, salesPerson);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				shortID = rs.getInt(1);
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			strBuff.append("For the Following Sales Person and Customer The Status is Changed\n"); 
			strBuff.append("Sales Person            Customer\n"); 
			strBuff.append("------------------      ----------------------------------\n"); 
			msgBuff.append("\n\nFor the Following Sales Person and Item The Status is not Changed\n");
			msgBuff.append("Sales Person            Customer\n"); 
			msgBuff.append("------------------      ----------------------------------\n"); 
			
			//ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();

			Boolean isErrStringFound = false;
			String chkStatus = null;
			String chkStatusx = null;
			// Modified by Ganesh [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [Start]					
			String [] arrPropValue = null;
			String propValues = "";
			String routeType = "";
			Vector vector = new Vector();
			Boolean isNonCoverageRTypeDefined = false;
			propValues = getAllowedRouteType( salesPerson, conn );
			if (propValues.trim().length() > 0)
			{
				if(propValues.indexOf(',')>0)
				{
					arrPropValue = propValues.split(",");
				}
				else 
				{
					arrPropValue = new String[1];
					arrPropValue[0] = propValues;
				}
				for(int k=0 ; k<arrPropValue.length ; k++)
				{
					vector.add(arrPropValue[k]);
				}
				isNonCoverageRTypeDefined = true;
			}
			// Modified by Ganesh [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor][End]
			for (int parentListRow = 0; parentListRow < parentNodeListLength; parentListRow++)
			{
				parentNode = parentNodeList.item(parentListRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				chkStatus = "";
				chkStatusx = "";

				for (int childListRow = 0; childListRow < childNodeListLength; childListRow++)
				{
					childNode = childNodeList.item(childListRow);
					childNodeName = childNode.getNodeName();

					if (childNodeName.equals("status"))
					{
						if(childNode.getFirstChild()!=null)
						{
							chkStatus = childNode.getFirstChild().getNodeValue();
						}
					}
					if(childNodeName.equals("status_old"))
					{
						if(childNode.getFirstChild()!=null)
							{
								chkStatusx = childNode.getFirstChild().getNodeValue();
							}
					}
					//Modified by Ganesh on [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [Start]
					if (childNodeName.equals("cust_code"))
					{
						if (childNode.getFirstChild()!=null)
						{
							custCode = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("custCode ::"+custCode);
					}
					//Modified by Ganesh on [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [End]

				}
				if( !chkStatus.equalsIgnoreCase(chkStatusx) )
				{
					if((!chkStatus.equalsIgnoreCase("Y") && !chkStatus.equalsIgnoreCase("N")))
					{
						isErrStringFound = true;
						errString = itmDBAccess.getErrorString( "status", "VSTKSTATUS", userId );
						break;
					}
					//Modified by Ganesh on [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [Start]
					else if (chkStatus != null && chkStatus.equalsIgnoreCase("Y"))
					{
						selectSql = "SELECT ROUTE_ID FROM SPRS_STOCKIST WHERE SPRS_CODE = ? AND CUST_CODE = ? ";
						pstmt = conn.prepareStatement(selectSql);
						pstmt.setString(1, salesPerson);
						pstmt.setString(2, custCode);

						rs = pstmt.executeQuery();
						System.out.println("selectSql:: "+selectSql);
						if ( rs.next() )
						{															
							routeID = checkNull(rs.getString("ROUTE_ID"));
						}
						if(rs != null)
						{
							rs.close();	
							rs = null;																			
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						selectSql =  "SELECT ROUTE_TYPE FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND ROUTE_ID = ? ";								
						pstmt = conn.prepareStatement(selectSql);
						pstmt.setString(1, salesPerson);
						pstmt.setString(2, routeID);

						rs = pstmt.executeQuery();
						if ( rs.next() )
						{						
							routeType = checkNull(rs.getString("ROUTE_TYPE"));
						}	
						if(rs != null)
						{
							rs.close();	
							rs = null;																			
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if (isNonCoverageRTypeDefined)
						{							
							//if(vector.contains(routeType))
							// Request id :W17JSUN003  Changed by Sachin Satre on [22-Jan-18] for CHC div user in propertis table define the route for CHC user. if route is M ot T then give the validation for all division as well as CHC [Start]
							if ( vector.contains(routeType)  )
						    {
						    	if ( ( routeType.equalsIgnoreCase("M") || routeType.equalsIgnoreCase("T")) )
						    	{	
									isErrStringFound = true;
									//Modified by Aadesh on [26/09/2014][To change msg no as "VPDTROUTE5"][Start]
									errString = itmDBAccess.getErrorString("status","VPDTROUTE5",userId);
									//Modified by Aadesh on [26/09/2014][To change msg no as "VPDTROUTE5"][End]
									break;
								}
						    }
						    else
						    {
						    	if ( ( routeType.equalsIgnoreCase("M") || routeType.equalsIgnoreCase("T")) )
						    	{
						    		isErrStringFound = true;
									//Modified by Aadesh on [26/09/2014][To change msg no as "VPDTROUTE5"][Start]
									errString = itmDBAccess.getErrorString("status","VPDTROUTE5",userId);
									//Modified by Aadesh on [26/09/2014][To change msg no as "VPDTROUTE5"][End]
									break;
						    	}
						    }
							// Request id :W17JSUN003  Changed by Sachin Satre on [22-Jan-18] for CHC div user in propertis table define the route for CHC user. if route is M ot T then give the validation for all division as well as CHC [Start]
						}	
					}
						//Modified by Ganesh on [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [End]
				}
			
			}
			if( isErrStringFound == false )
			{
				for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
				{
					parentNode = parentNodeList.item(selectedRow);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();

					for (int childRow = 0; childRow < childNodeListLength; childRow++)
					{
						childNode = childNodeList.item(childRow);
						childNodeName = childNode.getNodeName(); 
						if (childNodeName.equals("sprs_code"))
						{
							if(childNode.getFirstChild()!=null)
							{
								salesPerson = childNode.getFirstChild().getNodeValue();
							}
						}
						if (childNodeName.equals("cust_code"))
						{
							if (childNode.getFirstChild()!=null)
							{
								custCode = childNode.getFirstChild().getNodeValue();
							}
						}
						if (childNodeName.equals("status")) 
						{
							if (childNode.getFirstChild()!=null)
							{
								if (childNode.getFirstChild().getNodeValue()!=null)
								{
									status = childNode.getFirstChild().getNodeValue();
								}
							}
						}
						if (childNodeName.equals("status_old"))
						{
							if (childNode.getFirstChild()!=null)
							{
								if (childNode.getFirstChild().getNodeValue()!=null)
								{
									statusOld = childNode.getFirstChild().getNodeValue();
								}
							}
						}
						if (childNodeName.equals("cust_name"))
						{
							if (childNode.getFirstChild()!=null)
							{
								custName = childNode.getFirstChild().getNodeValue();
							}
						}
						if (childNodeName.equals("locality_descr"))
						{
							if (childNode.getFirstChild()!=null)
							{
								locDescr = childNode.getFirstChild().getNodeValue();
							}
						}
					}//End Of for (int childRow = 0; childRow < childNodeListLength; childRow++)
					if ( !status.equals(statusOld) )
					{
						if ( status.equals("Y") || status.equals("N") )
						{
							if ( status.equals("Y") )
							{
								selectSql = "SELECT COUNT(*) FROM CUSTOMER WHERE CUST_CODE = ? AND BLACK_LISTED = 'Y' ";
								pstmt = conn.prepareStatement(selectSql);
								pstmt.setString(1, custCode);
								rs = pstmt.executeQuery();
								if ( rs.next() )
								{
									cntrCust = rs.getInt(1);
								}
								if(rs != null)
								{
									rs.close();	
									rs = null;																			
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}								
								if (cntrCust > 0)
								{							
									System.out.println("@@@@ Customer is black listed:: " + custCode);
									msgBuff.append(""+salesPerson+"                  " + custCode.trim() + " \n");
									msgCtr++;
									continue;
								}
								selectSql = "SELECT ROUTE_ID FROM SPRS_STOCKIST WHERE SPRS_CODE = ? AND CUST_CODE = ? ";																
								pstmt = conn.prepareStatement(selectSql);
								pstmt.setString(1, salesPerson);
								pstmt.setString(2, custCode);

								rs = pstmt.executeQuery();
								if ( rs.next() )
								{
									routeID = checkNull(rs.getString("ROUTE_ID"));
								}
								if(rs != null)
								{
									rs.close();	
									rs = null;																			
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}									
								selectSql =  "SELECT STATUS FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND ROUTE_ID = ? ";
								pstmt = conn.prepareStatement(selectSql);
								pstmt.setString(1, salesPerson);
								pstmt.setString(2, routeID);
								rs = pstmt.executeQuery();

								if ( rs.next() )
								{
									routeStatus = checkNull(rs.getString("STATUS"));									
								}
								if(rs != null)
								{
									rs.close();	
									rs = null;																			
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if ( routeStatus != null && routeStatus.trim().equalsIgnoreCase("N"))
								{
									System.out.println("@@@@ Root is Inactive in spsr_route :: " + routeStatus);
									msgBuff.append(""+salesPerson+"                  " + custCode.trim() + " \n");
									msgCtr++;
									continue;
								}
								strBuff.append(""+salesPerson+"                  " + custCode.trim() + " \n");							}
							else
							{
								strBuff.append(""+salesPerson+"                  " + custCode.trim() + " \n");
							}
							updateSql = "UPDATE SPRS_STOCKIST SET STATUS = '"+status+"', REPLY_STATUS = '0', "+
										"CHG_DATE = ?, CHG_USER= ?, CHG_TERM = ? "+
										"WHERE SPRS_CODE = ? AND CUST_CODE = ? ";
							pstmt = conn.prepareStatement(updateSql);
							pstmt.setTimestamp(1, sysDate);
							pstmt.setString(2, userId);
							pstmt.setString(3, chgTerm);
							pstmt.setString(4, salesPerson);
							pstmt.setString(5, custCode);

							updCntSt = pstmt.executeUpdate();
							if ( updCntSt > 0 )
							{
								System.out.println("@@@@ Updated into SPRS_STOCKIST Successfully [updCnt] ::"+updCntSt);
								conn.commit();
								msgCntr ++;
							}
							pstmt.close();
							pstmt = null;
						}
						else
						{
							msgBuff.append(""+salesPerson+"                  " + custCode.trim() + " \n");
							msgCtr++;
						}
					}
					else
					{
						System.out.println("@@@@ Same Status................");
						continue;
					}
				}//End Of for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
				if ( msgCtr > 0 )
				{
					strBuff.append(msgBuff);
				}
				if (msgCntr > 0)
				{
					//errString = itmDBAccessLocal.getErrorString( "status", "VPROCESS", userId );//Commented by Arpit [23/06/2015]
				}
				else if( msgCtr > 0 )
				{
					errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS\" type=\"E\" column_name=\"\"><message>Process Not Done </message><description>"+msgBuff.toString()+"</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
				}
				else
				{
					errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS1\" type=\"E\" column_name=\"\"><message>Process Not Done </message><description>No data Found For Process </description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";	
				}
			}// if isErrStringFound
		}//try end	
		catch(SQLException se)
		{
			System.out.println("@@@@ Exception : SprsStockistStatusChgPosGWT : process():" +se.getMessage());
			try
			{
				conn.rollback();
			}
			catch(Exception se1){}
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			System.out.println("@@@@ Exception :SprsStockistStatusChgPosGWT :process():"+e.getMessage());
			try
			{
				conn.rollback();
			}
			catch(Exception e1){}
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("@@@@ Closing Connection....");
			try
			{
				if(rs != null)
				{ 
					rs.close();
					rs = null;
				}
				
				if(pstmt != null)
				{ 
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
			}
		}
		System.out.println("@@@@ errString...:: "+errString);
		return errString;
	}//END OF PROCESS(2)

	protected InitialContext getInitialContext() throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("@@@@ ITMException :[SprsStockistStatusChgPrcGWT][getInitialContext() :==>]");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("@@@@ Exception :[SprsStockistStatusChgPrcGWT][getInitialContext()  :==>]");
			throw new ITMException(e);
		}
		return ctx;
	}
	//Modified by Ganesh on [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [Start]
	private String getAllowedRouteType( String loginEmpCode, Connection conn ) throws ITMException
	{
		Statement cstmt = null;
		ResultSet rst = null;
		String propValue = "";
		String propSql = "";
		Statement cstmt1 = null;
		ResultSet rst1 = null;
		String propSql1 = "";
		Boolean isPropFound = false;
		try
		{		
			propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER = (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+loginEmpCode+"') "  ;
			cstmt = conn.createStatement();
			rst = cstmt.executeQuery(propSql);	
			System.out.println("[SprsStockistStatusChgPrc] [getAllowedRouteType()][QUERY::] " +propSql);
			if(rst.next())
			{
				propValue = rst.getString("PROP_VALUE");	
				isPropFound = true;
			}
			System.out.println("propValue:::"+propValue);
			if(isPropFound == false)
			{
				propSql1 = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER ='ALL' "  ;
				cstmt1 = conn.createStatement();
				rst1 = cstmt1.executeQuery(propSql1);	
				System.out.println("[SprsStockistStatusChgPrc] [getAllowedRouteType()][QUERY@IF::] " +propSql1);
				if(rst1.next())
				{
					propValue = rst1.getString("PROP_VALUE");	
				}
				System.out.println("[SprsStockistStatusChgPrc] [getAllowedRouteType()][propValue@IF:::] " +propValue);
			}
			
			if (rst != null)
			{
				rst.close();
				rst = null;
			}
			if ( cstmt != null )
			{
				cstmt.close();
				cstmt = null;
			}
			if (rst1 != null)
			{
				rst1.close();
				rst1 = null;
			}
			if ( cstmt1 != null )
			{
				cstmt1.close();
				cstmt1 = null;
			}
			if (propValue == null)
			{
				propValue = "";
			}

		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rst != null)
				{
					rst.close();
					rst = null;
				}
				if ( cstmt != null )
				{
					cstmt.close();
					cstmt = null;
				}
				if (rst1 != null)
				{
					rst1.close();
					rst1 = null;
				}
				if ( cstmt1 != null )
				{
					cstmt1.close();
					cstmt1 = null;
				}
			}
			catch(Exception e1){}
		}
		return propValue;
	}
	//Modified by Ganesh on [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [End]
}
