/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw.utility;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationLocal;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.WorkflowProcessDataMangerEJB;
import ibase.wrkflw.WorkflowProcessInstanceMonitorEJB;
import ibase.wrkflw.utility.WorkflowLogger;
import ibase.wrkflw.utility.WorkflowProcessIdGenerator;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.InitialContext;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class SignTrans {
    public String insertSign(String processInstanceId, String roleCodeSign, String entityCode, String formatCode, String xslFileName) throws RemoteException, BaseException {
        WorkflowLogger.info("[SignTrans]Inserting sign for processInstanceId [" + processInstanceId + "] roleCodeSign :[" + roleCodeSign + "] entityCode :[" + entityCode + "] ");
        String retStr = new String();
        Connection conn = null;
        try {
            retStr = this.insertSign(processInstanceId, roleCodeSign, entityCode, formatCode, xslFileName, conn);
        }
        catch (BaseException be) {
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            be.printStackTrace();
            WorkflowLogger.info("Exception occured : insertSign : [" + be.getMessage() + "]");
        }
        catch (Exception e) {
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            e.printStackTrace();
            WorkflowLogger.info("Exception occured : insertSign : [" + e.getMessage() + "]");
        }
        return retStr;
    }

    public String insertSign(String processInstanceId, String roleCodeSign, String entityCode, String formatCode, String xslFileName, Connection conn) throws RemoteException, BaseException {
        String retStr;
        block4: {
            WorkflowLogger.info("[SignTrans]Inserting sign for processInstanceId with connection [" + processInstanceId + "] roleCodeSign :[" + roleCodeSign + "] entityCode :[" + entityCode + "] ");
            retStr = new String();
            if (!this.isInstExistInObjSignTrans(processInstanceId, conn)) break block4;
            return "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Already Exists]]></RESULT></ROOT>";
        }
        try {
            String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
            String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
            String activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
            String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
            WorkflowProcessDataMangerEJB workflowProcessDataManger = new WorkflowProcessDataMangerEJB();
            HashMap paramMap = null;
            paramMap = conn != null ? workflowProcessDataManger.getProcessInputData(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId), conn) : workflowProcessDataManger.getProcessInputData(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId));
            WorkflowLogger.info("paramMap " + paramMap);
            String objName = (String)paramMap.get("$OBJ_NAME");
            String refSer = (String)paramMap.get("$REF_SER");
            String refId = (String)paramMap.get("$REF_ID");
            String transInfo = (String)paramMap.get("$XML_DATA_ALL");
            this.insertSign(processInstanceId, objName, refSer, refId, roleCodeSign, entityCode, transInfo, formatCode, xslFileName, conn);
            retStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
        }
        catch (BaseException be) {
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            be.printStackTrace();
            WorkflowLogger.info("Exception occured : insertSign : [" + be.getMessage() + "]");
        }
        catch (Exception e) {
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            e.printStackTrace();
            WorkflowLogger.info("Exception occured : insertSign : [" + e.getMessage() + "]");
        }
        return retStr;
    }

    public String insertSignCtx(String processInstanceId, String roleCodeSign, String entityCode, String formatCode, String xslFileName, String signFor, String context1, String context2, String context3) throws RemoteException, BaseException {
        WorkflowLogger.info("[SignTransEJB]Inserting sign for processInstanceId [" + processInstanceId + "] roleCodeSign :[" + roleCodeSign + "] entityCode :[" + entityCode + "] with context1 [" + context1 + "] context2 [" + context2 + "] context1 [" + context3 + "] ");
        boolean isError = false;
        String retStr = new String("");
        Connection conn = null;
        try {
            retStr = this.insertSignCtx(processInstanceId, roleCodeSign, entityCode, formatCode, xslFileName, signFor, context1, context2, context3, "", conn);
        }
        catch (BaseException be) {
            be.printStackTrace();
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            isError = true;
            WorkflowLogger.info("Exception occured : insertSignCtx : [" + be.getMessage() + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            isError = true;
            WorkflowLogger.info("Exception occured : insertSignCtx : [" + e.getMessage() + "]");
        }
        return retStr;
    }

    public String insertSignCtx(String processInstanceId, String roleCodeSign, String entityCode, String formatCode, String xslFileName, String signFor, String context1, String context2, String context3, Connection conn) throws RemoteException, BaseException {
        WorkflowLogger.info("[SignTransEJB]Inserting sign for processInstanceId with connection111 [" + processInstanceId + "] roleCodeSign :[" + roleCodeSign + "] entityCode :[" + entityCode + "] with context1 [" + context1 + "] context2 [" + context2 + "] context1 [" + context3 + "] ");
        boolean isError = false;
        String retStr = new String("");
        try {
            retStr = this.insertSignCtx(processInstanceId, roleCodeSign, entityCode, formatCode, xslFileName, signFor, context1, context2, context3, "", conn);
        }
        catch (BaseException be) {
            be.printStackTrace();
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "", conn);
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            isError = true;
            WorkflowLogger.info("Exception occured : insertSignCtx : [" + be.getMessage() + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "", conn);
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            isError = true;
            WorkflowLogger.info("Exception occured : insertSignCtx : [" + e.getMessage() + "]");
        }
        BaseLogger.log("2", null, null, "retStr ::" + retStr);
        return retStr;
    }

    public String insertSign(String processInstanceId, String objName, String refSer, String refId, String roleCodeSign, String entityCode, String transInfo, String formatCode, String xslFileName) throws RemoteException, BaseException {
        WorkflowLogger.info("[SignTransEJB]Inserting sign for refSer :[" + refSer + "] refId :[" + refId + "] roleCodeSign :[" + roleCodeSign + "] entityCode :[" + entityCode + "] transInfo.length() :[" + transInfo.length() + "]");
        boolean isError = false;
        Object mQuery = null;
        Object pStmt = null;
        String retStr = new String();
        String query = "";
        boolean updStatus = false;
        Connection conn = null;
        try {
            retStr = this.insertSign(processInstanceId, objName, refSer, refId, roleCodeSign, entityCode, transInfo, formatCode, xslFileName, conn);
        }
        catch (BaseException be) {
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            WorkflowLogger.info("Exception occured : insertSign : [" + be.getMessage() + "]");
            isError = true;
        }
        catch (Exception e) {
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            e.printStackTrace();
            WorkflowLogger.info("Exception occured : insertSign : [" + e.getMessage() + "]");
            isError = true;
        }
        return retStr;
    }

    public String insertSign(String processInstanceId, String objName, String refSer, String refId, String roleCodeSign, String entityCode, String transInfo, String formatCode, String xslFileName, Connection conn) throws RemoteException, BaseException {
        WorkflowLogger.info("[SignTransEJB]Inserting sign for refSer with connection :[" + refSer + "] refId :[" + refId + "] roleCodeSign :[" + roleCodeSign + "] entityCode :[" + entityCode + "] transInfo.length() :[" + transInfo.length() + "]");
        boolean isError = false;
        Object mQuery = null;
        PreparedStatement pStmt = null;
        String retStr = new String();
        String query = "";
        boolean updStatus = false;
        boolean isLocalConn = false;
        try {
            if (conn == null) {
                conn = this.getConnection();
                conn.setAutoCommit(false);
                isLocalConn = true;
                BaseLogger.log("3", null, null, "Local connection created >>insertSign >> isLocalConn =[" + isLocalConn + "]");
            }
            if (this.isInstExistInObjSignTrans(processInstanceId, conn)) {
                String string = retStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
                return string;
            }
            try {
                int noOfRows = 0;
                AppConnectParm appConnect = new AppConnectParm();
                InitialContext ctx = new InitialContext(appConnect.getProperty());
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                ArrayList roleInfoList = dbAccessEJB.getRoleInfoList(conn, roleCodeSign);
                dbAccessEJB = null;
                int signTransLineNo = this.getMaxLineNoSignTransRole(refSer, refId, roleCodeSign, conn) + 1;
                WorkflowLogger.info("CommonConstants.DB_NAME [" + CommonConstants.DB_NAME + "] ");
                if ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    String insertQuery = "INSERT INTO OBJ_SIGN_TRANS(REF_SER, REF_ID, LINE_NO, ROLE_CODE__SIGN, CREATE_DATE, SIGN_STATUS, TITLE, ROLE_TYPE, ROLE_ENTITY, ENTITY_CODE, PRC_INST__WF, TRANS_INFO, MSG_FRM_FNAME, OBJ_NAME) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
                    WorkflowLogger.info("Sign Trans ..Inserting into OBJ_SIGN_TRANS [" + insertQuery + "]");
                    pStmt = conn.prepareStatement(insertQuery);
                    pStmt.setString(1, refSer);
                    pStmt.setString(2, refId);
                    pStmt.setInt(3, signTransLineNo);
                    pStmt.setString(4, roleCodeSign);
                    pStmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(6, "U");
                    pStmt.setString(7, "");
                    pStmt.setString(8, (String)roleInfoList.get(0));
                    pStmt.setString(9, (String)roleInfoList.get(1));
                    pStmt.setString(10, entityCode);
                    pStmt.setString(11, processInstanceId);
                    byte[] encoded = transInfo.getBytes();
                    ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(encoded);
                    pStmt.setBinaryStream(12, (InputStream)byteArrayIn, byteArrayIn.available());
                    if (xslFileName != null && xslFileName.length() > 0) {
                        pStmt.setString(13, xslFileName);
                    } else {
                        pStmt.setNull(13, 0);
                    }
                    pStmt.setString(14, objName);
                    WorkflowLogger.info("Pstmt values refSer :[" + refSer + "], refId :[" + refId + "], lineNo :[" + signTransLineNo + "], roleCodeSign :[" + roleCodeSign + "], roleType :[" + (String)roleInfoList.get(0) + "], roleEntity :[" + (String)roleInfoList.get(1) + "], entityCode :[" + entityCode + "], processInstanceId :[" + processInstanceId + "]");
                    noOfRows = pStmt.executeUpdate();
                    pStmt.close();
                    pStmt = null;
                    this.sendMail(objName, transInfo, refSer, refId, signTransLineNo, formatCode, entityCode, (String)roleInfoList.get(1), xslFileName, conn);
                } else {
                    String insertQuery = "INSERT INTO OBJ_SIGN_TRANS(REF_SER, REF_ID, LINE_NO, ROLE_CODE__SIGN, CREATE_DATE, SIGN_STATUS, TITLE, ROLE_TYPE, ROLE_ENTITY, ENTITY_CODE, PRC_INST__WF, TRANS_INFO, MSG_FRM_FNAME,OBJ_NAME) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, EMPTY_BLOB(),?,?)";
                    WorkflowLogger.info("Sign Trans ..Inserting into OBJ_SIGN_TRANS [" + insertQuery + "]");
                    pStmt = conn.prepareStatement(insertQuery);
                    pStmt.setString(1, refSer);
                    pStmt.setString(2, refId);
                    pStmt.setInt(3, signTransLineNo);
                    pStmt.setString(4, roleCodeSign);
                    pStmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(6, "U");
                    pStmt.setString(7, "");
                    pStmt.setString(8, (String)roleInfoList.get(0));
                    pStmt.setString(9, (String)roleInfoList.get(1));
                    pStmt.setString(10, entityCode);
                    pStmt.setString(11, processInstanceId);
                    if (xslFileName != null && xslFileName.length() > 0) {
                        pStmt.setString(12, xslFileName);
                    } else {
                        pStmt.setNull(12, 0);
                    }
                    pStmt.setString(13, objName);
                    WorkflowLogger.info("Pstmt values refSer :[" + refSer + "], refId :[" + refId + "], lineNo :[" + signTransLineNo + "], roleCodeSign :[" + roleCodeSign + "], roleType :[" + (String)roleInfoList.get(0) + "], roleEntity :[" + (String)roleInfoList.get(1) + "], entityCode :[" + entityCode + "], processInstanceId :[" + processInstanceId + "]");
                    noOfRows = pStmt.executeUpdate();
                    pStmt.close();
                    pStmt = null;
                    query = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? "UPDATE OBJ_SIGN_TRANS SET TRANS_INFO_XML = XMLType(?) WHERE REF_SER=? AND REF_ID=? AND LINE_NO=? " : "SELECT TRANS_INFO FROM OBJ_SIGN_TRANS WHERE REF_SER=? AND REF_ID=? AND LINE_NO=? FOR UPDATE NOWAIT";
                    ArrayList<String> bindVarValues = new ArrayList<String>();
                    bindVarValues.add(refSer);
                    bindVarValues.add(refId);
                    bindVarValues.add(String.valueOf(signTransLineNo));
                    ArrayList<String> bindVarTypes = new ArrayList<String>();
                    bindVarTypes.add("String");
                    bindVarTypes.add("String");
                    bindVarTypes.add("Int");
                    updStatus = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.updateXMLTypeStr(conn, query, transInfo, bindVarValues, bindVarTypes) : this.updateBlob(conn, query, transInfo, bindVarValues, bindVarTypes);
                    WorkflowLogger.info("[SignTransEJB]Insertion into OBJ_SIGN_TRANS done... updStatus [" + updStatus + "]");
                    if (updStatus) {
                        this.sendMail(objName, transInfo, refSer, refId, signTransLineNo, formatCode, entityCode, (String)roleInfoList.get(1), xslFileName, conn);
                    }
                }
                retStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
            }
            catch (BaseException be) {
                String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
                retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
                WorkflowLogger.info("Exception occured : insertSign : [" + be.getMessage() + "]");
                isError = true;
                try {
                    if (conn != null && isError) {
                        BaseLogger.log("3", null, null, "[insertSign]isLocalConn =" + isLocalConn + " and rollback the changes");
                        conn.rollback();
                    }
                    if (conn != null && isLocalConn) {
                        BaseLogger.log("3", null, null, "[insertSign]isLocalConn =" + isLocalConn + " and commiting the changes");
                        conn.commit();
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :SignTransEJB :insertSign :==>finally\n" + e.getMessage());
                    throw new BaseException(e);
                }
            }
            catch (Exception e) {
                String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
                retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
                e.printStackTrace();
                WorkflowLogger.info("Exception occured : insertSign : [" + e.getMessage() + "]");
                isError = true;
            }
        }
        finally {
            try {
                if (conn != null && isError) {
                    BaseLogger.log("3", null, null, "[insertSign]isLocalConn =" + isLocalConn + " and rollback the changes");
                    conn.rollback();
                }
                if (conn != null && isLocalConn) {
                    BaseLogger.log("3", null, null, "[insertSign]isLocalConn =" + isLocalConn + " and commiting the changes");
                    conn.commit();
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignTransEJB :insertSign :==>finally\n" + e.getMessage());
                throw new BaseException(e);
            }
        }
        return retStr;
    }

    private boolean updateBlob(Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes) throws BaseException {
        WorkflowLogger.info("query [" + query + "]");
        WorkflowLogger.info("bindVarTypes [" + bindVarTypes + "]");
        WorkflowLogger.info("bindVarValues [" + bindVarValues + "]");
        boolean updStatus = false;
        PreparedStatement pStmt = null;
        try {
            try {
                pStmt = con.prepareStatement(query);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 1, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 1, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) {
                    Blob mapBlob = rs.getBlob(1);
                    OutputStream blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                    byte[] dataByteArray = null;
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    if ((dataStr = genericUtility.remAllXmlDec(dataStr)) != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                        dataByteArray = dataStr.getBytes();
                    } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                        dataByteArray = dataStr.getBytes();
                    }
                    if (dataByteArray != null) {
                        BaseLogger.log("3", null, null, "Writing to blob data of length [" + dataByteArray.length + "]");
                    }
                    blobOutputStream.write(dataByteArray);
                    blobOutputStream.close();
                    updStatus = true;
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Exception :SignTrans :updateBlob :==>finally\n" + e.getMessage());
                throw new BaseException(e);
            }
        }
        return updStatus;
    }

    private boolean updateXMLTypeStr(Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException {
        BaseLogger.log("2", null, null, "@@@@ inside updateXMLType");
        WorkflowLogger.info("query [" + query + "]");
        WorkflowLogger.info("bindVarTypes [" + bindVarTypes + "]");
        WorkflowLogger.info("bindVarValues [" + bindVarValues + "]");
        boolean updStatus = false;
        Statement pStmt = null;
        Object oConnection = null;
        try {
            try {
                byte[] dataByteArray = null;
                E12GenericUtility genericUtility = new E12GenericUtility();
                dataStr = genericUtility.remAllXmlDec(dataStr);
                if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                    dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                    dataByteArray = dataStr.getBytes();
                } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                    dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                    dataByteArray = dataStr.getBytes();
                }
                pStmt = con.prepareStatement(query);
                CLOB dataStrXml = CLOB.createTemporary((Connection)con.getMetaData().getConnection(), (boolean)true, (int)10);
                dataStrXml.putString(1L, dataStr);
                pStmt.setClob(1, (Clob)dataStrXml);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 2, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 2, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                int updateCnt = pStmt.executeUpdate();
                BaseLogger.log("3", null, null, "@@@@ updateCnt in updateXMLType" + updateCnt);
                if (updateCnt > 0) {
                    updStatus = true;
                }
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :updateBlob :==>finally\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return updStatus;
    }

    private void sendMail(String objName, String xmlString, String refSer, String refId, int lineNo, String formatCode, String entityCode, String entityType, String xslFileName, Connection connection) throws BaseException {
        WorkflowLogger.info("[SignTransEJB]Sending mail to minimum unsigned signature for objName :[" + objName + "] refSer :[" + refSer + "] refId :[" + refId + "] lineNo :[" + lineNo + "] formatCode :[" + formatCode + "] xmlString length :[" + xmlString.length() + "]");
        boolean emailFlag = false;
        try {
            if (formatCode != null) {
                String mailDomStr = "<ROOT><TRANS_INFO><OBJ_NAME>" + objName + "</OBJ_NAME>" + "<REF_SER>" + refSer + "</REF_SER><REF_ID>" + refId + "</REF_ID>" + "<LINE_NO>" + lineNo + "</LINE_NO><XSL_FILE_NAME>" + xslFileName + "</XSL_FILE_NAME></TRANS_INFO>" + "<MAIL><EMAIL_TYPE>link</EMAIL_TYPE><ENTITY_CODE>" + entityCode + "</ENTITY_CODE>" + "<ENTITY_TYPE>" + entityType + "</ENTITY_TYPE><FORMAT_CODE>" + formatCode + "</FORMAT_CODE>" + "<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>" + "</MAIL><XML_DATA>" + xmlString + "</XML_DATA></ROOT>";
                EMail email = new EMail();
                email.sendMail(mailDomStr, "ITM", connection);
            }
        }
        catch (BaseException be) {
            WorkflowLogger.info("Mail Sending failed");
        }
        catch (Exception e) {
            WorkflowLogger.info("Mail Sending failed");
        }
    }

    private boolean isInstExistInObjSignTrans(String processInstanceId, Connection con) throws BaseException {
        boolean isExist = false;
        Statement pStmt = null;
        ResultSet rs = null;
        BufferedWriter logFileWriter = null;
        boolean isLocalConn = false;
        try {
            try {
                if (con == null) {
                    con = this.getConnection();
                    isLocalConn = true;
                }
                String prcIdSelQry = "SELECT PRC_INST__WF FROM OBJ_SIGN_TRANS WHERE PRC_INST__WF = ? ";
                WorkflowLogger.info("Executing Process Id Select Query :[" + prcIdSelQry + "] processInstanceId [" + processInstanceId + "]");
                pStmt = con.prepareStatement(prcIdSelQry);
                pStmt.setString(1, processInstanceId);
                rs = pStmt.executeQuery();
                WorkflowLogger.info("Executing Query ..... ");
                if (rs.next()) {
                    WorkflowLogger.info("Instance Found In OBJ_SIGN_TRANS FOR processInstanceId [" + processInstanceId + "]");
                    Timestamp currTime = new Timestamp(System.currentTimeMillis());
                    StringBuffer logStringBuff = new StringBuffer("Data Exists for ");
                    logStringBuff.append(processInstanceId);
                    if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "ObjSignTrans.log").exists()) {
                        new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "ObjSignTrans.log").createNewFile();
                    }
                    String logFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "ObjSignTrans.log";
                    WorkflowLogger.info(" ObjSignTrans :logFileName[" + logFileName + "]");
                    logFileWriter = new BufferedWriter(new FileWriter(logFileName, true));
                    logFileWriter.newLine();
                    logFileWriter.write(logStringBuff.toString());
                    isExist = true;
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "In isInstExistInObjSignTrans[" + e.getMessage() + "]");
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null && isLocalConn) {
                    con.close();
                    con = null;
                }
                if (logFileWriter != null) {
                    logFileWriter.flush();
                    logFileWriter = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignTransEJB : isInstExistInObjSignTrans :==>\n" + e.getMessage());
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("Returning processInstanceIdExists [" + isExist + "]");
        return isExist;
    }

    private String getProcessInstanceId(String refSer, String refId, String lineNo, Connection conn) throws BaseException {
        String processInstanceId = null;
        Statement pStmt = null;
        ResultSet rs = null;
        try {
            try {
                String prcIdSelQry = "SELECT PRC_INST__WF FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ?";
                WorkflowLogger.info("Executing Process Id Select Query :[" + prcIdSelQry + "] refSer [" + refSer + "] refId [" + refId + "] lineNo [" + lineNo + "]");
                pStmt = conn.prepareStatement(prcIdSelQry);
                pStmt.setString(1, refSer.trim());
                pStmt.setString(2, refId.trim());
                pStmt.setInt(3, Integer.parseInt(lineNo));
                rs = pStmt.executeQuery();
                WorkflowLogger.info("Executing Query ..... ");
                if (rs.next()) {
                    WorkflowLogger.info("Instance Found ...");
                    processInstanceId = rs.getString("PRC_INST__WF");
                }
                if (processInstanceId == null) {
                    throw new Exception("No Process Instance Id found for current Activity");
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (BaseException be) {
                WorkflowLogger.info("From not accessible method:" + be.getMessage(), be.getCause());
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignTransEJB : :==>\n" + e.getMessage());
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("Returning processInstanceId [" + processInstanceId + "]");
        return processInstanceId;
    }

    private Connection getConnection() throws BaseException {
        Connection con = null;
        try {
            ConnDriver connDriver = new ConnDriver();
            con = connDriver.getConnectDB(CommonConstants.WRKFLW_DB);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return con;
    }

    private int getMaxLineNoSignTransRole(String refSer, String refId, String roleCodeSign, Connection conn) throws BaseException {
        WorkflowLogger.info("Getting MaxLineNo from OBJ_SIGN_TRANS ...");
        Statement stmt = null;
        int lineNo = 0;
        try {
            try {
                stmt = conn.createStatement();
                String sql = "SELECT MAX(LINE_NO) AS LINE_NO FROM OBJ_SIGN_TRANS WHERE REF_SER='" + refSer + "' AND REF_ID='" + refId + "' ";
                WorkflowLogger.info(" sql " + sql);
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    lineNo = rs.getInt("LINE_NO");
                }
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("From Obj_sign_trans lineNo [" + lineNo + "]");
        return lineNo;
    }

    private InitialContext getInitialContext() throws BaseException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return ctx;
    }

    private String sendErrMail(String processInstanceId, String resultStr) {
        String wrkflwErrDirectory = "";
        try {
            WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitor = new WorkflowProcessInstanceMonitorEJB();
            wrkflwErrDirectory = workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, resultStr);
            workflowProcessInstanceMonitor = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wrkflwErrDirectory;
    }

    private String sendErrMail(String processInstanceId, String resultStr, Connection conn) {
        String wrkflwErrDirectory = "";
        try {
            WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitor = new WorkflowProcessInstanceMonitorEJB();
            wrkflwErrDirectory = workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, resultStr, conn);
            workflowProcessInstanceMonitor = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wrkflwErrDirectory;
    }

    public String insertSignCtx(String processInstanceId, String roleCodeSign, String entityCode, String formatCode, String xslFileName, String signFor, String context1, String context2, String context3, String signRightsChar) throws RemoteException, BaseException {
        WorkflowLogger.info("[SignTransEJB]Inserting sign for processInstanceId [" + processInstanceId + "] roleCodeSign :[" + roleCodeSign + "] entityCode :[" + entityCode + "] with context1 [" + context1 + "] context2 [" + context2 + "] context1 [" + context3 + "] signRightsChar [" + signRightsChar + "] ");
        boolean isError = false;
        Object mQuery = null;
        Object pStmt = null;
        Object stmt = null;
        String retStr = new String("");
        Connection conn = null;
        try {
            retStr = this.insertSignCtx(processInstanceId, roleCodeSign, entityCode, formatCode, xslFileName, signFor, context1, context2, context3, signRightsChar, conn);
        }
        catch (BaseException be) {
            be.printStackTrace();
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            isError = true;
            WorkflowLogger.info("Exception occured : insertSignCtx : [" + be.getMessage() + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            isError = true;
            WorkflowLogger.info("Exception occured : insertSignCtx : [" + e.getMessage() + "]");
        }
        return retStr;
    }

    public String insertSignCtx(String processInstanceId, String roleCodeSign, String entityCode, String formatCode, String xslFileName, String signFor, String context1, String context2, String context3, String signRightsChar, Connection conn) throws RemoteException, BaseException {
        WorkflowLogger.info("[SignTransEJB]Inserting sign for processInstanceId with connection 222[" + processInstanceId + "] roleCodeSign :[" + roleCodeSign + "] entityCode :[" + entityCode + "] with context1 [" + context1 + "] context2 [" + context2 + "] context1 [" + context3 + "] signRightsChar [" + signRightsChar + "] ");
        boolean isError = false;
        Object mQuery = null;
        PreparedStatement pStmt = null;
        Object stmt = null;
        String retStr = new String("");
        boolean isLocalConn = false;
        UserInfoBean userInfo = new UserInfoBean();
        String userType = "";
        ResultSet rs = null;
        try {
            if (conn == null) {
                conn = this.getConnection();
                conn.setAutoCommit(false);
                isLocalConn = true;
                BaseLogger.log("3", null, null, "Local Connection created in >>insertSignCtx >> isLocalConn =[" + isLocalConn + "]");
            }
            if (this.isInstExistInObjSignTrans(processInstanceId, conn)) {
                String string = retStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Already Exists]]></RESULT></ROOT>";
                return string;
            }
            try {
                String insertQuery;
                String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                String activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
                WorkflowProcessDataMangerEJB workflowProcessDataManger = new WorkflowProcessDataMangerEJB();
                HashMap paramMap = workflowProcessDataManger.getProcessInputData(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId), conn);
                workflowProcessDataManger = null;
                WorkflowLogger.info("paramMap " + paramMap);
                String objName = (String)paramMap.get("$OBJ_NAME");
                String refSer = (String)paramMap.get("$REF_SER");
                String refId = (String)paramMap.get("$REF_ID");
                String transInfo = (String)paramMap.get("$XML_DATA_ALL");
                int noOfRows = 0;
                AppConnectParm appConnect = new AppConnectParm();
                InitialContext ctx = new InitialContext(appConnect.getProperty());
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                ArrayList roleInfoList = dbAccessEJB.getRoleInfoList(conn, roleCodeSign);
                dbAccessEJB = null;
                int signTransLineNo = this.getMaxLineNoSignTransRole(refSer, refId, roleCodeSign, conn) + 1;
                WorkflowLogger.info("[SignTransEJB] insertSignCtx entityCode : [" + entityCode + "]");
                String entityType = "";
                if (entityCode != null && entityCode.contains(",")) {
                    String[] entityDetailArr = entityCode.split(",");
                    entityType = entityDetailArr[0];
                    entityCode = entityDetailArr[1];
                } else {
                    String getUserType = "SELECT USER_TYPE FROM USERS WHERE EMP_CODE =  ? ";
                    pStmt = conn.prepareStatement(getUserType);
                    pStmt.setString(1, entityCode);
                    rs = pStmt.executeQuery();
                    if (rs.next()) {
                        userType = E12GenericUtility.checkNull(rs.getString("USER_TYPE"));
                        BaseLogger.log("3", userInfo, null, "userType :==>" + userType);
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                }
                boolean updStatus = false;
                if ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    insertQuery = "INSERT INTO OBJ_SIGN_TRANS( REF_SER, REF_ID, LINE_NO, ROLE_CODE__SIGN, CREATE_DATE, SIGN_STATUS, TITLE, ROLE_TYPE, ROLE_ENTITY, ENTITY_CODE, PRC_INST__WF, TRANS_INFO, MSG_FRM_FNAME, SIGN_FOR, CONTEXT_1, CONTEXT_2, CONTEXT_3, RIGHTS_CHAR_SIGN,OBJ_NAME ) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?)";
                    WorkflowLogger.info("Sign Trans ..Inserting into OBJ_SIGN_TRANS [" + insertQuery + "]");
                    pStmt = conn.prepareStatement(insertQuery);
                    pStmt.setString(1, refSer);
                    pStmt.setString(2, refId);
                    pStmt.setInt(3, signTransLineNo);
                    pStmt.setString(4, roleCodeSign);
                    pStmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(6, "U");
                    pStmt.setString(7, "");
                    pStmt.setString(8, (String)roleInfoList.get(0));
                    if (entityType != null && entityType.length() > 0) {
                        pStmt.setString(9, entityType);
                    } else if (userType.length() > 0) {
                        pStmt.setString(9, userType);
                    } else {
                        pStmt.setString(9, (String)roleInfoList.get(1));
                    }
                    pStmt.setString(10, entityCode);
                    pStmt.setString(11, processInstanceId);
                    pStmt.setString(14, signFor);
                    pStmt.setString(15, context1);
                    pStmt.setString(16, context2);
                    pStmt.setString(17, context3);
                    pStmt.setString(18, signRightsChar);
                    pStmt.setString(19, objName);
                    byte[] encoded = transInfo.getBytes();
                    ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(encoded);
                    pStmt.setBinaryStream(12, (InputStream)byteArrayIn, byteArrayIn.available());
                    if (xslFileName != null && xslFileName.length() > 0) {
                        pStmt.setString(13, xslFileName);
                    } else {
                        pStmt.setNull(13, 0);
                    }
                    WorkflowLogger.info("Pstmt values refSer :[" + refSer + "], refId :[" + refId + "], lineNo :[" + signTransLineNo + "], roleCodeSign :[" + roleCodeSign + "], roleType :[" + (String)roleInfoList.get(0) + "], roleEntity :[" + (String)roleInfoList.get(1) + "], entityCode :[" + entityCode + "], processInstanceId :[" + processInstanceId + "]");
                    noOfRows = pStmt.executeUpdate();
                    pStmt.close();
                    pStmt = null;
                    updStatus = true;
                } else {
                    insertQuery = "INSERT INTO OBJ_SIGN_TRANS(REF_SER, REF_ID, LINE_NO, ROLE_CODE__SIGN, CREATE_DATE, SIGN_STATUS, TITLE, ROLE_TYPE, ROLE_ENTITY, ENTITY_CODE, PRC_INST__WF, TRANS_INFO, MSG_FRM_FNAME, SIGN_FOR, CONTEXT_1, CONTEXT_2, CONTEXT_3, RIGHTS_CHAR_SIGN, USER_INPUT,OBJ_NAME ) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, EMPTY_BLOB(),?,?,?,?,?,?,?,?)";
                    WorkflowLogger.info("Sign Trans ..Inserting into OBJ_SIGN_TRANS with context [" + insertQuery + "]");
                    pStmt = conn.prepareStatement(insertQuery);
                    pStmt.setString(1, refSer);
                    pStmt.setString(2, refId);
                    pStmt.setInt(3, signTransLineNo);
                    pStmt.setString(4, roleCodeSign);
                    pStmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(6, "U");
                    pStmt.setString(7, "");
                    pStmt.setString(8, (String)roleInfoList.get(0));
                    if (entityType != null && entityType.length() > 0) {
                        pStmt.setString(9, entityType);
                    } else if (userType.length() > 0) {
                        pStmt.setString(9, userType);
                    } else {
                        pStmt.setString(9, (String)roleInfoList.get(1));
                    }
                    pStmt.setString(10, entityCode);
                    pStmt.setString(11, processInstanceId);
                    pStmt.setString(13, signFor);
                    pStmt.setString(14, context1);
                    pStmt.setString(15, context2);
                    pStmt.setString(16, context3);
                    pStmt.setString(17, signRightsChar);
                    if (xslFileName != null && xslFileName.length() > 0) {
                        pStmt.setString(12, xslFileName);
                    } else {
                        pStmt.setNull(12, 0);
                    }
                    if ("emp_statuschg".equalsIgnoreCase(objName)) {
                        pStmt.setString(18, "Y");
                    } else {
                        pStmt.setString(18, "N");
                    }
                    pStmt.setString(19, objName);
                    WorkflowLogger.info("Pstmt values refSer :[" + refSer + "], refId :[" + refId + "], lineNo :[" + signTransLineNo + "], roleCodeSign :[" + roleCodeSign + "], roleType :[" + (String)roleInfoList.get(0) + "], roleEntity :[" + (String)roleInfoList.get(1) + "], entityCode :[" + entityCode + "], processInstanceId :[" + processInstanceId + "]");
                    noOfRows = pStmt.executeUpdate();
                    pStmt.close();
                    pStmt = null;
                    String query = "";
                    query = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? "UPDATE OBJ_SIGN_TRANS SET TRANS_INFO_XML = XMLType(?) WHERE REF_SER=? AND REF_ID=? AND LINE_NO=? " : "SELECT TRANS_INFO FROM OBJ_SIGN_TRANS WHERE REF_SER=? AND REF_ID=? AND LINE_NO=? FOR UPDATE NOWAIT";
                    ArrayList<String> bindVarValues = new ArrayList<String>();
                    bindVarValues.add(refSer);
                    bindVarValues.add(refId);
                    bindVarValues.add(String.valueOf(signTransLineNo));
                    ArrayList<String> bindVarTypes = new ArrayList<String>();
                    bindVarTypes.add("String");
                    bindVarTypes.add("String");
                    bindVarTypes.add("Int");
                    updStatus = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.updateXMLTypeStr(conn, query, transInfo, bindVarValues, bindVarTypes) : this.updateBlob(conn, query, transInfo, bindVarValues, bindVarTypes);
                }
                WorkflowLogger.info("[SignTransEJB]Insertion into OBJ_SIGN_TRANS with context done... updStatus [" + updStatus + "]");
                if (updStatus) {
                    BaseLogger.log("3", null, null, "new changes conn!!!!" + conn);
                    conn.commit();
                    this.sendMail(objName, transInfo, refSer, refId, signTransLineNo, formatCode, entityCode, (String)roleInfoList.get(1), xslFileName, conn);
                    retStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
                    try {
                        String tableName = " WF_ROLE_USERS ";
                        String columnName = " USERID ";
                        StringBuilder condition = new StringBuilder();
                        condition.append(" WHERE ROLE_CODE='").append(roleCodeSign).append("' ");
                        ArrayList<String> userIdList = this.getDBColumnValues(tableName, columnName, condition.toString(), conn, userInfo.getTransDB());
                        String tableNm = " USERS ";
                        String columnNm = " CODE ";
                        StringBuilder condn = new StringBuilder();
                        condn.append(" WHERE ENTITY_CODE='").append(entityCode).append("' ");
                        ArrayList<String> userCodeList = this.getDBColumnValues(tableNm, columnNm, condn.toString(), conn, userInfo.getTransDB());
                        userIdList.addAll(userCodeList);
                        WorkflowLogger.info("In SignTrans utility userIdList[" + userIdList + "]");
                        String userMessage = "Workflow : " + signFor;
                        String loginUserCode = "";
                        String notificationType = "";
                        notificationType = "K".equalsIgnoreCase(signRightsChar) ? "" : "approvals";
                        StringBuilder xmlDataBuilder = new StringBuilder("<ROOT>");
                        xmlDataBuilder.append(this.createXMLTag("OBJ_NAME", objName)).append(this.createXMLTag("REF_SER", refSer)).append(this.createXMLTag("REF_ID", refId)).append(this.createXMLTag("LINE_NO", "" + signTransLineNo)).append(this.createXMLTag("USER_ID", userInfo.getLoginCode())).append(this.createXMLTag("SERVER_URL", CommonConstants.TOMCAT_HOME)).append(this.createXMLTag("SITE_CODE", userInfo.getSiteCode())).append("</ROOT>");
                        BaseLogger.log("3", null, null, "xmldatabuilder:::" + xmlDataBuilder.toString());
                        this.publishPushNotificationEJB().invockPushNotification(userMessage, loginUserCode, "W", refId, userIdList, xmlDataBuilder.toString(), refId, refSer, loginUserCode, signTransLineNo, notificationType, userInfo);
                    }
                    catch (Exception ne) {
                        ne.printStackTrace();
                    }
                }
            }
            catch (BaseException be) {
                be.printStackTrace();
                String workflowErrDirectory = this.sendErrMail(processInstanceId, "", conn);
                retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
                isError = true;
                WorkflowLogger.info("Exception occured : insertSignCtx : [" + be.getMessage() + "]");
                try {
                    if (conn != null && isError) {
                        BaseLogger.log("3", null, null, "[insertSign]isLocalConn =" + isLocalConn + " and rollback the changes");
                        conn.rollback();
                    }
                    if (conn != null && isLocalConn) {
                        BaseLogger.log("3", null, null, "[insertSignCtx]isLocalConn =" + isLocalConn + " and commiting the changes");
                        conn.commit();
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :SignTransEJB :insertSign :==>finally\n" + e.getMessage());
                    WorkflowLogger.info("Exception occured : insertSignCtx : finally : [" + e.getMessage() + "]");
                    throw new BaseException(e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String workflowErrDirectory = this.sendErrMail(processInstanceId, "", conn);
                retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
                isError = true;
                WorkflowLogger.info("Exception occured : insertSignCtx : [" + e.getMessage() + "]");
            }
        }
        finally {
            try {
                if (conn != null && isError) {
                    BaseLogger.log("3", null, null, "[insertSign]isLocalConn =" + isLocalConn + " and rollback the changes");
                    conn.rollback();
                }
                if (conn != null && isLocalConn) {
                    BaseLogger.log("3", null, null, "[insertSignCtx]isLocalConn =" + isLocalConn + " and commiting the changes");
                    conn.commit();
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignTransEJB :insertSign :==>finally\n" + e.getMessage());
                WorkflowLogger.info("Exception occured : insertSignCtx : finally : [" + e.getMessage() + "]");
                throw new BaseException(e);
            }
        }
        return retStr;
    }

    private PublishPushNotificationLocal publishPushNotificationEJB() throws BaseException {
        PublishPushNotificationEJB publishPushNotificationEJB = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            BaseLogger.log("3", null, null, "Looking Up for PublishPushNotification EJB with Properties==>\n" + p);
            publishPushNotificationEJB = new PublishPushNotificationEJB();
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "Exception: publishPushNotificationEJB:==>\n" + be);
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: publishPushNotificationEJB:==>\n" + e);
            throw new BaseException(e);
        }
        return publishPushNotificationEJB;
    }

    public ArrayList<String> getDBColumnValues(String tableName, String columnName, String condition, Connection conn, String transDB) throws ITMException {
        String sql = "";
        Statement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> columnValues = new ArrayList<String>();
        boolean isLocalConn = false;
        try {
            try {
                if (conn == null) {
                    ConnDriver connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(transDB);
                    isLocalConn = true;
                }
                sql = " SELECT " + columnName + " FROM " + tableName + " " + condition;
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    columnValues.add(rs.getString(columnName.trim()));
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (SQLException e) {
                BaseLogger.log("0", null, null, "Excepton in getDBColumnValues -- >" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception exp) {
                BaseLogger.log("0", null, null, "Excepton in getDBColumnValues -- >" + exp.getMessage());
                exp.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null && isLocalConn) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException se) {
                    se.printStackTrace();
                    throw new ITMException(se);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null && isLocalConn) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return columnValues;
    }

    String createXMLTag(String tagName, String value) {
        return "<" + tagName + "><![CDATA[" + value + "]]></" + tagName + ">";
    }
}

