/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.itextpdf.text.pdf.PdfReader;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import ibase.bis.utility.BISDictionary;
import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.EMail;
import ibase.utility.Firewall;
import ibase.utility.JSONtoXMLConverter;
import ibase.utility.UserInfoBean;
import ibase.utility.ValidateXMLInput;
import ibase.utility.XMLtoJSONConverter;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.UploadFileEJB;
import ibase.webitm.utility.Column;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.ResourceModifier;
import ibase.webitm.utility.TransIDGenerator;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.rmi.RemoteException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.ejb.EJBHome;
import javax.imageio.ImageIO;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jcodec.api.FrameGrab;
import org.jcodec.common.model.Picture;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class E12GenericUtility {
    HashMap<String, String> editableListMap = new HashMap();
    private String idxOfSubArrLst = "";
    private boolean subarraylist = false;

    public HashMap<String, String> getEditableListMap() {
        return this.editableListMap;
    }

    public Document parseString(String xmlString) throws ITMException {
        Document dom1 = null;
        DocumentBuilderFactory dbf = null;
        DocumentBuilder db = null;
        OutputStreamWriter errorWriter = null;
        ByteArrayInputStream baos = null;
        try {
            try {
                if (xmlString != null && xmlString.length() > 0) {
                    xmlString = this.setXmlDec(xmlString);
                    dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    dbf.setIgnoringComments(true);
                    db = dbf.newDocumentBuilder();
                    errorWriter = new OutputStreamWriter((OutputStream)System.err, CommonConstants.ENCODING);
                    baos = new ByteArrayInputStream(xmlString.getBytes(CommonConstants.ENCODING));
                    dom1 = db.parse(baos);
                    baos.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : [GenericUtility][parseString] :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            dbf = null;
            db = null;
            try {
                try {
                    if (errorWriter != null) {
                        errorWriter.close();
                    }
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (IOException e) {
                    throw new ITMException(e);
                }
            }
            finally {
                errorWriter = null;
                baos = null;
            }
        }
        return dom1;
    }

    public byte[] transformToBytes(String xslType, String xmlType, String targetDir, String fileNamePrefix, String fileNameSuffix) throws ITMException {
        byte[] data = null;
        FileInputStream fis = null;
        ByteArrayOutputStream baos = null;
        ValidateXMLInput vxi = null;
        String outputFileName = "";
        try {
            try {
                vxi = new ValidateXMLInput();
                outputFileName = vxi.validate(xslType, xmlType, targetDir, fileNamePrefix, fileNameSuffix);
                fis = new FileInputStream(outputFileName);
                baos = new ByteArrayOutputStream();
                int i = -1;
                while ((i = fis.read()) != -1) {
                    baos.write(i);
                }
                data = baos.toByteArray();
            }
            catch (ITMException itme) {
                throw itme;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
                if (outputFileName.length() > 0) {
                    File tempFile = new File(outputFileName);
                    tempFile.delete();
                    tempFile = null;
                }
                vxi = null;
                outputFileName = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in releasing file resource :");
                e.printStackTrace();
            }
        }
        return data;
    }

    public String transformToString(String xslType, String xmlType, String targetDir, String fileNamePrefix, String fileNameSuffix) throws ITMException {
        String transformedString = "";
        ValidateXMLInput vxi = null;
        String outputFileName = null;
        File tempFile = null;
        try {
            try {
                vxi = new ValidateXMLInput();
                outputFileName = vxi.validate(xslType, xmlType, targetDir, fileNamePrefix, fileNameSuffix);
                transformedString = this.readFile(outputFileName);
                tempFile = new File(outputFileName);
                tempFile.delete();
                tempFile = null;
            }
            catch (ITMException itme) {
                throw itme;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            vxi = null;
            outputFileName = null;
            tempFile = null;
        }
        return transformedString;
    }

    public String readFile(String fileName) throws Exception {
        StringBuffer fileContent = new StringBuffer();
        BufferedReader bfr = null;
        FileInputStream fMainIn = null;
        String outTempStr = null;
        try {
            fMainIn = new FileInputStream(fileName);
            bfr = new BufferedReader(new InputStreamReader((InputStream)fMainIn, CommonConstants.ENCODING));
            while ((outTempStr = bfr.readLine()) != null) {
                fileContent.append(outTempStr);
            }
            bfr.close();
            bfr = null;
        }
        finally {
            block18: {
                try {
                    try {
                        if (bfr != null) {
                            bfr.close();
                            bfr = null;
                        }
                        if (fMainIn != null) {
                            fMainIn.close();
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception in releasing file resource :[" + fileName + "]");
                        e.printStackTrace();
                        fMainIn = null;
                        outTempStr = null;
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    fMainIn = null;
                    outTempStr = null;
                    throw throwable;
                }
                fMainIn = null;
                outTempStr = null;
            }
        }
        return fileContent.toString();
    }

    public String serializeDom(Node dom) throws ITMException {
        String retString = null;
        ByteArrayOutputStream out = null;
        Transformer serializer = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                serializer = TransformerFactory.newInstance().newTransformer();
                serializer.setOutputProperty("omit-xml-declaration", "yes");
                serializer.setOutputProperty("encoding", CommonConstants.ENCODING);
                serializer.transform(new DOMSource(dom), new StreamResult(out));
                retString = out.toString(CommonConstants.ENCODING);
                out.flush();
                out.close();
                out = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : GenericUtility : serializeDom :" + e);
                throw new ITMException(e);
            }
        }
        finally {
            if (out != null) {
                try {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new ITMException(e);
                    }
                }
                finally {
                    out = null;
                }
            }
            serializer = null;
        }
        return retString;
    }

    private synchronized String removeAllDec(String xmlData) throws ITMException {
        StringBuffer retXmlDataBuff = new StringBuffer();
        String xmlDataFirst = null;
        String xmlDatasecond = null;
        String logFileName = null;
        String xmlStr = xmlData;
        try {
            try {
                if (xmlStr.trim().startsWith("<?xml")) {
                    xmlStr = xmlStr.substring(xmlStr.indexOf(">") + 1, xmlStr.length()).trim();
                    retXmlDataBuff.append(xmlStr);
                } else if (xmlStr.indexOf("<?xml") != -1) {
                    if (xmlStr.contains("<?xml")) {
                        int idx = xmlStr.indexOf("<?xml");
                        int strLen = xmlStr.length();
                        if (idx != -1 && strLen >= idx) {
                            xmlDataFirst = xmlStr.substring(0, idx).trim();
                            xmlDatasecond = xmlStr.substring(idx, strLen);
                            xmlDatasecond = xmlDatasecond.substring(xmlDatasecond.indexOf(">") + 1, xmlDatasecond.length()).trim();
                            retXmlDataBuff.append(xmlDataFirst);
                            retXmlDataBuff.append(xmlDatasecond);
                        }
                    }
                } else {
                    retXmlDataBuff.append(xmlStr);
                }
            }
            catch (Exception e) {
                try {
                    BaseLogger.log("3", null, null, "removeAllDecError : xmlData[" + xmlStr + "]");
                    logFileName = this.generateLog(xmlStr, "removeAllDecError", "removeAllDecError", true);
                    BaseLogger.log("3", null, null, "logFileName in removeAllDec[" + logFileName + "]");
                }
                catch (Exception ex) {
                    BaseLogger.log("0", null, null, "Exception : E12GenericUtility : removeAllDec : generateLog" + ex);
                    throw new ITMException(ex);
                }
                BaseLogger.log("3", null, null, "Exception : E12GenericUtility : removeAllDec :" + e);
                throw new ITMException(e);
            }
        }
        finally {
            xmlDataFirst = null;
            xmlDatasecond = null;
            logFileName = null;
        }
        return retXmlDataBuff.toString();
    }

    public synchronized String remAllXmlDec(String xmlDomStr) throws ITMException {
        try {
            boolean isXmlDecExist = true;
            while (xmlDomStr != null && isXmlDecExist) {
                if (xmlDomStr.indexOf("<?xml") != -1) {
                    if (!xmlDomStr.contains("<?xml")) continue;
                    xmlDomStr = this.removeAllDec(xmlDomStr);
                    continue;
                }
                isXmlDecExist = false;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : GenericUtility : remAllXmlDec :" + e);
            throw new ITMException(e);
        }
        return xmlDomStr;
    }

    public String setXmlDec(String xmlDomStr) throws ITMException {
        StringBuffer xmlStrBuff = null;
        try {
            try {
                if (xmlDomStr != null && xmlDomStr.length() > 0) {
                    if (xmlDomStr.indexOf("<?xml") != -1) {
                        xmlDomStr = this.remAllXmlDec(xmlDomStr);
                    }
                    xmlStrBuff = new StringBuffer("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>");
                    xmlStrBuff.append(xmlDomStr);
                    xmlDomStr = xmlStrBuff.toString();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility : : setXmlDec :" + e);
                throw new ITMException(e);
            }
        }
        finally {
            xmlStrBuff = null;
        }
        return xmlDomStr;
    }

    public String serializeDom(Node dom, boolean spclCharParsing) throws ITMException {
        String retString = null;
        ByteArrayOutputStream out = null;
        Transformer serializer = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                serializer = TransformerFactory.newInstance().newTransformer();
                if (dom.getNodeType() == 1) {
                    serializer.setOutputProperty("omit-xml-declaration", "yes");
                }
                serializer.setOutputProperty("encoding", CommonConstants.ENCODING);
                serializer.transform(new DOMSource(dom), new StreamResult(out));
                retString = out.toString(CommonConstants.ENCODING);
                out.flush();
                out.close();
                out = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility : : serializeDom :" + e);
                throw new ITMException(e);
            }
        }
        finally {
            if (out != null) {
                try {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new ITMException(e);
                    }
                }
                finally {
                    out = null;
                }
            }
            serializer = null;
        }
        return retString;
    }

    public String getColumnValue(String colName, Document dom) throws ITMException {
        String colValue = "";
        try {
            colValue = this.getColumnValue(colName, dom, "0");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : [GenericUtility][getColumnValue(1)] :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return colValue;
    }

    public String getColumnValue(String colName, Document dom, String formNo) throws ITMException {
        Node elementName = null;
        Node parentNode = null;
        NodeList elementList = null;
        Element elementAttr = null;
        String columnName = "";
        String columnValue = null;
        boolean continueLoop = true;
        boolean isFormNo = false;
        try {
            try {
                elementList = dom.getElementsByTagName(colName);
                if (Integer.parseInt(formNo) < 1) {
                    isFormNo = true;
                }
                int ctr = 0;
                while (ctr < elementList.getLength()) {
                    elementName = elementList.item(ctr);
                    parentNode = elementName.getParentNode();
                    elementAttr = (Element)parentNode;
                    if (elementAttr.getAttribute("objContext").equals(formNo) || elementAttr.getAttribute("formno").equals(formNo) || isFormNo) {
                        columnName = elementName.getNodeName();
                        columnValue = "";
                        columnValue = elementName.getFirstChild() != null ? elementName.getFirstChild().getNodeValue() : null;
                    }
                    ++ctr;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : [GenericUtility][getColumnValue(2)] :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            elementName = null;
            parentNode = null;
            elementList = null;
            elementAttr = null;
            columnName = null;
        }
        return columnValue;
    }

    public String getColumnValue(String colName, Document dom, String formNo, String rowNo) throws ITMException {
        String returnVal = "";
        Node elementName = null;
        NodeList elementList = null;
        Element elementAttr = null;
        NodeList parentList = null;
        NodeList childList = null;
        Node parentNode = null;
        Node childNode = null;
        String childNodeName = null;
        int pNode = 0;
        int ctr = 0;
        int noOfChilds = 0;
        boolean currentFormNo = false;
        int parentNodes = 0;
        String columnName = "";
        String columnValue = null;
        boolean isFormNo = false;
        try {
            try {
                if (formNo != null && formNo.length() > 0 && Integer.parseInt(formNo) < 1) {
                    isFormNo = true;
                }
                if (rowNo == null || "".equals(rowNo)) {
                    parentList = dom.getElementsByTagName("Detail" + formNo);
                    parentNodes = parentList.getLength();
                    BaseLogger.log("3", null, null, " GenericUtility::parentList.getLength  [" + parentList.getLength() + "]  ");
                    pNode = 0;
                    while (pNode < parentNodes) {
                        parentNode = parentList.item(pNode);
                        childList = parentNode.getChildNodes();
                        noOfChilds = childList.getLength();
                        BaseLogger.log("3", null, null, "noOfChilds length  [" + noOfChilds + "]");
                        ctr = 0;
                        while (ctr < noOfChilds) {
                            childNode = childList.item(ctr);
                            childNodeName = childNode.getNodeName();
                            if (childNodeName.equals(colName) && childNode.getFirstChild() != null) {
                                columnValue = childNode.getFirstChild().getNodeValue().trim();
                                returnVal = pNode == 0 ? columnValue : String.valueOf(returnVal) + "," + columnValue;
                            }
                            ++ctr;
                        }
                        ++pNode;
                    }
                } else {
                    elementList = dom.getElementsByTagName(colName);
                    ctr = 0;
                    while (ctr < elementList.getLength()) {
                        elementName = elementList.item(ctr);
                        parentNode = elementName.getParentNode();
                        elementAttr = (Element)parentNode;
                        if ((elementAttr.getAttribute("objContext").equals(formNo) || elementAttr.getAttribute("formno").equals(formNo) || isFormNo) && elementAttr.getAttribute("domID").equals(rowNo)) {
                            columnName = elementName.getNodeName();
                            columnValue = "";
                            returnVal = elementName.getFirstChild() != null ? elementName.getFirstChild().getNodeValue() : null;
                        }
                        ++ctr;
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : GenericUtility: getColumnValue() :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            elementName = null;
            elementList = null;
            elementAttr = null;
            parentList = null;
            childList = null;
            parentNode = null;
            childNode = null;
            childNodeName = null;
            columnName = null;
            columnValue = null;
        }
        BaseLogger.log("2", null, null, " returnVal [" + returnVal + "]");
        return returnVal;
    }

    public String getColumnValueFromNode(String colName, Node detailNode) throws ITMException {
        String colValue = null;
        NodeList childList = null;
        try {
            try {
                childList = detailNode.getChildNodes();
                int noOfChilds = childList.getLength();
                int colCtr = 0;
                while (colCtr < noOfChilds) {
                    Node colNode = childList.item(colCtr);
                    if (colNode != null && colNode.getNodeType() == 1 && colNode.getNodeName().equals(colName)) {
                        if (colNode.getFirstChild() != null) {
                            colValue = colNode.getFirstChild().getNodeValue();
                        }
                        break;
                    }
                    colNode = null;
                    ++colCtr;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            childList = null;
        }
        return colValue;
    }

    public ArrayList getTokenList(String tokenString, String delimiter) throws Exception {
        BaseLogger.log("2", null, null, "getTokenList tokenString :[" + tokenString + "] delimiter :[" + delimiter + "]");
        ArrayList<String> returnList = null;
        if (tokenString != null && tokenString.length() > 0) {
            returnList = new ArrayList<String>();
            while (tokenString.indexOf(delimiter) != -1) {
                int endIndex = tokenString.indexOf(delimiter);
                returnList.add(tokenString.substring(0, endIndex));
                tokenString = tokenString.substring(endIndex + delimiter.length(), tokenString.length());
            }
            returnList.add(tokenString.substring(0, tokenString.length()));
        }
        return returnList;
    }

    public Date getDateObject(String date) throws ITMException {
        Date dat = null;
        Object df = null;
        SimpleDateFormat simpleDateFormat = null;
        try {
            try {
                simpleDateFormat = new SimpleDateFormat(this.getApplDateFormat());
                dat = simpleDateFormat.parse(date);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getDateObject :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            df = null;
            simpleDateFormat = null;
        }
        return dat;
    }

    public String getValidDateString(String dateStr, String sourceDateFormat, String targetDateFormat) throws ITMException {
        Date date = null;
        SimpleDateFormat sdfOutput = null;
        String retDateStr = "";
        try {
            try {
                if (!sourceDateFormat.equalsIgnoreCase(targetDateFormat)) {
                    if (sourceDateFormat.indexOf("/") != -1) {
                        dateStr.replace('/', '-');
                    } else if (sourceDateFormat.indexOf(".") != -1) {
                        dateStr.replace('.', '-');
                    }
                    date = new SimpleDateFormat(sourceDateFormat).parse(dateStr);
                    sdfOutput = new SimpleDateFormat(targetDateFormat);
                    retDateStr = sdfOutput.format((Object)date);
                } else {
                    retDateStr = dateStr;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getValidDateString :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            sdfOutput = null;
            date = null;
        }
        return retDateStr;
    }

    public String getValidDateTimeString(String dateTimeStr, String sourceDateTimeFormat, String targetDateTimeFormat) throws ITMException {
        Date date = null;
        SimpleDateFormat sdfOutput = null;
        String retDateStr = "";
        try {
            try {
                if (!sourceDateTimeFormat.equalsIgnoreCase(targetDateTimeFormat)) {
                    if (sourceDateTimeFormat.indexOf("/") != -1) {
                        dateTimeStr.replace('/', '-');
                    } else if (sourceDateTimeFormat.indexOf(".") != -1) {
                        dateTimeStr.replace('.', '-');
                    }
                    if (sourceDateTimeFormat.toLowerCase().indexOf("hh:mm:ss") != -1) {
                        date = dateTimeStr.indexOf("00:00:00") == -1 ? new SimpleDateFormat(sourceDateTimeFormat).parse(String.valueOf(dateTimeStr) + " 00:00:00") : new SimpleDateFormat(sourceDateTimeFormat).parse(dateTimeStr);
                        sdfOutput = targetDateTimeFormat.toLowerCase().indexOf("hh:mm:ss") == -1 ? new SimpleDateFormat(String.valueOf(targetDateTimeFormat) + " HH:mm:ss") : new SimpleDateFormat(targetDateTimeFormat);
                        retDateStr = sdfOutput.format((Object)date);
                    } else {
                        date = dateTimeStr.indexOf("00:00:00") == -1 ? new SimpleDateFormat(String.valueOf(sourceDateTimeFormat) + " HH:mm:ss").parse(String.valueOf(dateTimeStr) + " 00:00:00") : new SimpleDateFormat(String.valueOf(sourceDateTimeFormat) + " HH:mm:ss").parse(dateTimeStr);
                        sdfOutput = targetDateTimeFormat.toLowerCase().indexOf("hh:mm:ss") == -1 ? new SimpleDateFormat(String.valueOf(targetDateTimeFormat) + " HH:mm:ss") : new SimpleDateFormat(targetDateTimeFormat);
                        retDateStr = sdfOutput.format((Object)date);
                    }
                } else {
                    retDateStr = dateTimeStr;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getValidDateString :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            sdfOutput = null;
            date = null;
        }
        return retDateStr;
    }

    public String getDispDateFormat() throws ITMException, Exception {
        DocumentBuilderFactory dbf = null;
        DocumentBuilder db = null;
        Document doc = null;
        NodeList nlDateFormat = null;
        Node ndDateFormat = null;
        try {
            try {
                if ((CommonConstants.DISP_DATE_FORMAT == null || CommonConstants.DISP_DATE_FORMAT.trim().length() == 0) && (ndDateFormat = (nlDateFormat = (doc = (db = (dbf = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("DISP_DATE_FORMAT")).item(0)) != null && ndDateFormat.getFirstChild() != null) {
                    CommonConstants.DISP_DATE_FORMAT = ndDateFormat.getFirstChild().getNodeValue();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getDispDateFormat :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            dbf = null;
            db = null;
            doc = null;
            nlDateFormat = null;
            ndDateFormat = null;
        }
        return this.getValidDateFormat(CommonConstants.DISP_DATE_FORMAT);
    }

    public String getDispDateTimeFormat() throws ITMException, Exception {
        DocumentBuilderFactory dbf = null;
        DocumentBuilder db = null;
        Document doc = null;
        NodeList nlDateFormat = null;
        Node ndDateFormat = null;
        try {
            try {
                if ((CommonConstants.DISP_DATETIME_FORMAT == null || CommonConstants.DISP_DATETIME_FORMAT.trim().length() == 0) && (ndDateFormat = (nlDateFormat = (doc = (db = (dbf = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("DISP_DATETIME_FORMAT")).item(0)) != null && ndDateFormat.getFirstChild() != null) {
                    CommonConstants.DISP_DATETIME_FORMAT = ndDateFormat.getFirstChild().getNodeValue();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getDispDateFormat :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            dbf = null;
            db = null;
            doc = null;
            nlDateFormat = null;
            ndDateFormat = null;
        }
        return this.getValidDateFormat(CommonConstants.DISP_DATETIME_FORMAT);
    }

    public String getApplDateTimeFormat() throws ITMException, Exception {
        DocumentBuilderFactory dbf = null;
        DocumentBuilder db = null;
        Document doc = null;
        NodeList nlDateFormat = null;
        Node ndDateFormat = null;
        String dateTimeFormat = null;
        try {
            try {
                if ((CommonConstants.APPL_DATETIME_FORMAT == null || CommonConstants.APPL_DATETIME_FORMAT.trim().length() == 0) && (ndDateFormat = (nlDateFormat = (doc = (db = (dbf = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("APPL_DATETIME_FORMAT")).item(0)) != null && ndDateFormat.getFirstChild() != null) {
                    dateTimeFormat = ndDateFormat.getFirstChild().getNodeValue();
                    BaseLogger.log("3", null, null, "dateTimeFormat[" + dateTimeFormat + "]");
                    if (dateTimeFormat.endsWith("HH:mm")) {
                        dateTimeFormat = String.valueOf(dateTimeFormat) + ":ss";
                    }
                    BaseLogger.log("3", null, null, "dateTimeFormat Assign SS[" + dateTimeFormat + "]");
                    CommonConstants.APPL_DATETIME_FORMAT = dateTimeFormat;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getApplDateTimeFormat :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            dbf = null;
            db = null;
            doc = null;
            nlDateFormat = null;
            ndDateFormat = null;
            dateTimeFormat = null;
        }
        return this.getValidDateFormat(CommonConstants.APPL_DATETIME_FORMAT);
    }

    public String getApplDateFormat() throws ITMException, Exception {
        DocumentBuilderFactory dbf = null;
        DocumentBuilder db = null;
        Document doc = null;
        NodeList nlDateFormat = null;
        Node ndDateFormat = null;
        try {
            try {
                if ((CommonConstants.APPL_DATE_FORMAT == null || CommonConstants.APPL_DATE_FORMAT.trim().length() == 0) && (ndDateFormat = (nlDateFormat = (doc = (db = (dbf = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("APPL_DATE_FORMAT")).item(0)) != null && ndDateFormat.getFirstChild() != null) {
                    CommonConstants.APPL_DATE_FORMAT = ndDateFormat.getFirstChild().getNodeValue();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getApplDateFormat :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            dbf = null;
            db = null;
            doc = null;
            nlDateFormat = null;
            ndDateFormat = null;
        }
        return this.getValidDateFormat(CommonConstants.APPL_DATE_FORMAT);
    }

    public String getDBDateFormat() throws ITMException, Exception {
        DocumentBuilderFactory dbf = null;
        DocumentBuilder db = null;
        Document doc = null;
        NodeList nlDateFormat = null;
        Node ndDateFormat = null;
        try {
            try {
                if ((CommonConstants.DB_DATE_FORMAT == null || CommonConstants.DB_DATE_FORMAT.trim().length() == 0) && (ndDateFormat = (nlDateFormat = (doc = (db = (dbf = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("DB_DATE_FORMAT")).item(0)) != null && ndDateFormat.getFirstChild() != null) {
                    CommonConstants.DB_DATE_FORMAT = ndDateFormat.getFirstChild().getNodeValue();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getDBDateFormat :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            dbf = null;
            db = null;
            doc = null;
            nlDateFormat = null;
            ndDateFormat = null;
        }
        return this.getValidDateFormat(CommonConstants.DB_DATE_FORMAT);
    }

    public String getDisplayTimeFormat() throws ITMException, Exception {
        DocumentBuilderFactory dbf = null;
        DocumentBuilder db = null;
        Document doc = null;
        NodeList nlDateFormat = null;
        Node ndDateFormat = null;
        try {
            try {
                if ((CommonConstants.DISP_TIME_FORMAT == null || CommonConstants.DISP_TIME_FORMAT.trim().length() == 0) && (ndDateFormat = (nlDateFormat = (doc = (db = (dbf = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("DISP_TIME_FORMAT")).item(0)) != null && ndDateFormat.getFirstChild() != null) {
                    CommonConstants.DISP_TIME_FORMAT = ndDateFormat.getFirstChild().getNodeValue();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getDisplayTimeFormat :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            dbf = null;
            db = null;
            doc = null;
            nlDateFormat = null;
            ndDateFormat = null;
        }
        return this.getValidDateFormat(CommonConstants.DISP_TIME_FORMAT);
    }

    public Date getDateTimeObject(String date) throws ITMException {
        Date dat = null;
        Object df = null;
        SimpleDateFormat simpleDateFormat = null;
        try {
            try {
                simpleDateFormat = new SimpleDateFormat(this.getApplDateTimeFormat());
                dat = simpleDateFormat.parse(date);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getDateTimeObject :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            df = null;
            simpleDateFormat = null;
        }
        return dat;
    }

    public float timeDiff(Date d1, Date d2) throws ITMException {
        long t1 = d1.getTime();
        long t2 = d2.getTime();
        long t3 = t1 - t2;
        float hr = (float)t3 / 3600000.0f;
        float min = (float)((int)((hr - (float)((int)hr)) * 60.0f)) / 100.0f;
        float time = (float)((int)hr) + min;
        return time;
    }

    public int getParameterCount(String str) throws ITMException {
        int indx = 0;
        int cnt = 0;
        try {
            while (indx != -1) {
                ++indx;
                indx = str.indexOf(63, indx);
                ++cnt;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : GenericUtility : genParameterCount :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return --cnt;
    }

    public String getValueFromXTRA_PARAMS(String xtraParams, String searchParam) throws ITMException {
        String searchParamVal = "";
        try {
            int searchParamPos = xtraParams.indexOf(searchParam);
            if (searchParamPos != -1) {
                int equalsPos = xtraParams.indexOf("=", searchParamPos);
                int endPos = xtraParams.indexOf("~", equalsPos);
                if (endPos < 0) {
                    endPos = xtraParams.length();
                }
                if ((searchParamVal = xtraParams.substring(equalsPos + 1, endPos)) != null && ("null".equalsIgnoreCase(searchParamVal) || "undefined".equalsIgnoreCase(searchParamVal))) {
                    searchParamVal = "";
                }
            } else {
                BaseLogger.log("3", null, null, String.valueOf(searchParam) + " index not found in xtraParam");
            }
            BaseLogger.log("3", null, null, "Value of " + searchParam + " : [" + searchParamVal + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GenericUtility :getValueFromXTRA_PARAMS :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return searchParamVal;
    }

    public String createErrorString(Exception e) {
        ITMException ie = new ITMException(e);
        String errString = "<?xml version=\"1.0\"?>\r\n" + ie.getMessage();
        ie = null;
        return errString;
    }

    public String createErrorString(Exception e, String dataFormat) {
        ITMException ie = new ITMException(dataFormat, e);
        String errString = ie.getMessage();
        if (!"JSON".equalsIgnoreCase(dataFormat)) {
            errString = "<?xml version=\"1.0\"?>\r\n" + errString;
        }
        ie = null;
        return errString;
    }

    public String formatDouble(double value, int sigDigit) throws ITMException {
        BaseLogger.log("2", null, null, "GenericUtility=>Converting double value [" + value + "] by formatDouble()");
        String retValue = null;
        BigDecimal bgd = null;
        String decimalStr = null;
        String afterSigDigit = null;
        DecimalFormat dec = null;
        try {
            try {
                int indexOfDot;
                retValue = String.valueOf(value);
                if (retValue.indexOf(69) != -1) {
                    bgd = new BigDecimal(value);
                    retValue = bgd.toString();
                }
                if ((indexOfDot = retValue.indexOf(".")) != -1) {
                    int noOfDigitsAfterDot = retValue.substring(indexOfDot + 1).length();
                    double tempDouble = 0.0;
                    if (noOfDigitsAfterDot > sigDigit) {
                        decimalStr = retValue.substring(0, indexOfDot + sigDigit + 1);
                        afterSigDigit = retValue.substring(indexOfDot + sigDigit + 1, indexOfDot + sigDigit + 2);
                        int afterSigDigitInt = Integer.parseInt(afterSigDigit);
                        tempDouble = afterSigDigitInt >= 5 ? Double.parseDouble(decimalStr) + 1.0 / Math.pow(10.0, sigDigit) : Double.parseDouble(decimalStr);
                    } else {
                        tempDouble = Double.parseDouble(retValue);
                    }
                    dec = new DecimalFormat();
                    dec.applyPattern("#.#");
                    dec.setMaximumFractionDigits(sigDigit);
                    retValue = dec.format(tempDouble);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            bgd = null;
            decimalStr = null;
            afterSigDigit = null;
            dec = null;
        }
        BaseLogger.log("2", null, null, "GenericUtility=>Returning converted string from by formatDouble():[" + retValue + "]");
        return retValue;
    }

    public String getNormalizeString(String nodeString) throws ITMException {
        StringBuffer tempStringBuff = new StringBuffer();
        try {
            tempStringBuff.append("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>");
            tempStringBuff.append("<DocumentRoot>");
            tempStringBuff.append("<description>Datawindow Root</description>");
            tempStringBuff.append("<group0>");
            tempStringBuff.append("<description>Group0 description</description>");
            tempStringBuff.append("<Header0>");
            tempStringBuff.append("<description>Header0 members</description>");
            tempStringBuff.append(nodeString);
            tempStringBuff.append("</Header0>");
            tempStringBuff.append("</group0>");
            tempStringBuff.append("</DocumentRoot>");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GenericUtility :getNormalizeString :==>\n" + e);
            throw new ITMException(e);
        }
        return tempStringBuff.toString();
    }

    public String initCap(String dataString, String wordSeparator) throws ITMException {
        try {
            int index = 0;
            do {
                StringBuffer dataStringBuffer = new StringBuffer(dataString);
                dataStringBuffer.replace(index, index + 1, dataString.substring(index, index + 1).toUpperCase());
                dataString = dataStringBuffer.toString();
                dataStringBuffer = null;
                index = dataString.indexOf(wordSeparator, index + 1);
            } while (++index != 0);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GenericUtility :initCap :==>\n" + e);
            throw new ITMException(e);
        }
        return dataString;
    }

    public String removeElementValues(String xmlString, String elements, String sep) throws ITMException {
        BaseLogger.log("2", null, null, "Removing Element Values :[" + elements + "]");
        Document document = null;
        StringTokenizer elementsStrTokenizer = null;
        String detailXMLString = "";
        try {
            try {
                document = this.parseString(xmlString);
                elementsStrTokenizer = new StringTokenizer(elements, sep);
                while (elementsStrTokenizer.hasMoreTokens()) {
                    String nextToken = elementsStrTokenizer.nextToken();
                    NodeList elementNodeList = document.getElementsByTagName(nextToken.trim());
                    int nodeListLen = elementNodeList.getLength();
                    int i = 0;
                    while (i < nodeListLen) {
                        Node element = elementNodeList.item(i);
                        Object val = null;
                        element.getFirstChild().setNodeValue(detailXMLString);
                        ++i;
                    }
                    nextToken = null;
                    elementNodeList = null;
                }
                detailXMLString = this.serializeDom(document);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :MasterStatefulEJB : removeElementValues :==>\n" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            document = null;
            elementsStrTokenizer = null;
        }
        return detailXMLString;
    }

    public boolean isNodePresent(String colName, String formNo, Document dom) throws ITMException {
        NodeList nodeList = null;
        NodeList detailNodeList = null;
        boolean isColumn = false;
        try {
            try {
                detailNodeList = dom.getElementsByTagName("Detail" + formNo);
                if (detailNodeList.item(0) != null) {
                    nodeList = detailNodeList.item(0).getChildNodes();
                }
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node childNode = nodeList.item(i);
                    if (childNode != null && childNode.getNodeType() == 1 && childNode.getNodeName().equalsIgnoreCase(colName)) {
                        isColumn = true;
                        childNode = null;
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : [GenericUtility][getColumnValue(2)] :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            nodeList = null;
            detailNodeList = null;
        }
        return isColumn;
    }

    public String generateTabSeparatedData(String xmlData, String objContext, String domID) throws ITMException {
        StringBuffer tabSepDataBuff = new StringBuffer();
        Node detailNode = null;
        NodeList detailNodeList = null;
        try {
            try {
                detailNode = this.searchNode(this.parseString(xmlData), objContext, domID);
                if (detailNode != null && detailNode.getNodeType() == 1 && detailNode.getNodeName().startsWith("Detail")) {
                    detailNodeList = detailNode.getChildNodes();
                    int detailNodeListLen = detailNodeList.getLength();
                    int i = 0;
                    while (i < detailNodeListLen) {
                        Node childNode = detailNodeList.item(i);
                        if (childNode != null && childNode.getNodeType() == 1 && !childNode.getNodeName().equalsIgnoreCase("attribute") && !childNode.getNodeName().equalsIgnoreCase("DB_ID")) {
                            String nodeVal = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "";
                            tabSepDataBuff.append(nodeVal);
                            nodeVal = null;
                            if (i > 0 && i != detailNodeListLen) {
                                tabSepDataBuff.append("\t");
                            }
                        }
                        childNode = null;
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : [GenericUtility][ generateTabSeparatedData ] :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            detailNode = null;
            detailNodeList = null;
        }
        return tabSepDataBuff.toString();
    }

    public Document parseFile(Object sourceXMLFile) throws Exception {
        Document dom = null;
        File file = null;
        DocumentBuilderFactory dbf = null;
        DocumentBuilder parser = null;
        try {
            try {
                file = sourceXMLFile.getClass().getName().equalsIgnoreCase("java.lang.String") ? new File((String)sourceXMLFile) : (File)sourceXMLFile;
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setIgnoringComments(true);
                parser = dbf.newDocumentBuilder();
                dom = parser.parse(file);
            }
            catch (Exception e) {
                dom = null;
                BaseLogger.log("0", null, null, "Exception :GenericUtility :parseFile :\n" + e.getMessage());
                throw e;
            }
        }
        finally {
            file = null;
            dbf = null;
            parser = null;
        }
        return dom;
    }

    public String createITMAddDom(String objName, String objCtx, String xmlFileName) throws ITMException {
        StringBuffer itmAddDomBuff = new StringBuffer();
        BaseLogger.log("3", null, null, " -------------44444444--------- Calling GenericUtility for creating ITMAddDom....");
        Document dom = null;
        NodeList tableColNodeList = null;
        try {
            try {
                if (xmlFileName != null) {
                    itmAddDomBuff.append("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>");
                    itmAddDomBuff.append("<DocumentRoot>");
                    itmAddDomBuff.append("<description>Datawindow Root</description>");
                    itmAddDomBuff.append("<group0>");
                    itmAddDomBuff.append("<description>Group0 description</description>");
                    itmAddDomBuff.append("<Header0>");
                    itmAddDomBuff.append("<description>Header0 members</description>");
                    if (objName.equalsIgnoreCase("TAXTRAN")) {
                        itmAddDomBuff.append("<Tax domID=''>");
                    } else {
                        itmAddDomBuff.append("<Detail" + objCtx + " dbID='' domID='' objName='" + objName + "' objContext='" + objCtx + "'>");
                    }
                    itmAddDomBuff.append("<attribute pkNames='' status='N' updateFlag='A' selected='N'/>");
                    dom = this.parseFile(xmlFileName);
                    tableColNodeList = dom.getElementsByTagName("table_column");
                    int noOfTableCol = tableColNodeList.getLength();
                    int i = 0;
                    while (i < noOfTableCol) {
                        String name = "";
                        String type = "";
                        String initial = "";
                        String spaceStr = "";
                        Node currTableNode = tableColNodeList.item(i);
                        NodeList currTableNodeList = currTableNode.getChildNodes();
                        currTableNode = null;
                        int noOfTabColChildNodes = currTableNodeList.getLength();
                        int j = 0;
                        while (j < noOfTabColChildNodes) {
                            Node currChild = currTableNodeList.item(j);
                            if (currChild.getNodeName().equalsIgnoreCase("name") && currChild.getFirstChild() != null) {
                                name = currChild.getFirstChild().getNodeValue();
                            } else if (currChild.getNodeName().equalsIgnoreCase("type") && currChild.getFirstChild() != null) {
                                String sizeStr;
                                type = currChild.getFirstChild().getNodeValue();
                                String string = sizeStr = currChild.getAttributes().getNamedItem("size") != null ? currChild.getAttributes().getNamedItem("size").getNodeValue().trim() : "0";
                                if (sizeStr.length() > 0) {
                                    int spaces = Integer.parseInt(sizeStr);
                                    int ctr = 0;
                                    while (ctr < spaces) {
                                        spaceStr = String.valueOf(spaceStr) + " ";
                                        ++ctr;
                                    }
                                }
                                sizeStr = null;
                            } else if (currChild.getNodeName().equalsIgnoreCase("initial") && currChild.getFirstChild() != null) {
                                initial = currChild.getFirstChild().getNodeValue();
                            }
                            currChild = null;
                            ++j;
                        }
                        currTableNodeList = null;
                        String val = "";
                        if ("SPACES".equalsIgnoreCase(initial)) {
                            val = spaceStr;
                        } else if ("TODAY".equalsIgnoreCase(initial)) {
                            java.sql.Date currDate = new java.sql.Date(System.currentTimeMillis());
                            if ("DATE".equalsIgnoreCase(type)) {
                                val = this.getValidDateString(currDate.toString(), "yyyy-MM-dd", this.getApplDateFormat());
                            } else if ("DATETIME".equalsIgnoreCase(type)) {
                                val = this.getValidDateTimeString(currDate.toString(), "yyyy-MM-dd", this.getApplDateTimeFormat());
                            }
                        } else if (initial.length() > 0) {
                            val = initial;
                        }
                        itmAddDomBuff.append("<" + name + ">").append(val).append("</" + name + ">");
                        name = null;
                        type = null;
                        initial = null;
                        spaceStr = null;
                        val = null;
                        ++i;
                    }
                    if (objName.equalsIgnoreCase("TAXTRAN")) {
                        itmAddDomBuff.append("</Tax>");
                    } else {
                        itmAddDomBuff.append("</Detail" + objCtx + ">");
                    }
                    itmAddDomBuff.append("</Header0>");
                    itmAddDomBuff.append("</group0>");
                    itmAddDomBuff.append("</DocumentRoot>");
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : [GenericUtility][createITMAddDom] :==>\n" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            dom = null;
            tableColNodeList = null;
        }
        BaseLogger.log("2", null, null, " -------------77777777 --------itmAddDomBuff.toString():[" + itmAddDomBuff.toString() + "]");
        return itmAddDomBuff.toString();
    }

    public Node searchNode(Document dom, String objContext, String nodeID) throws ITMException {
        BaseLogger.log("2", null, null, "Searching node from dom :[" + dom + "] for objContext :[" + objContext + "] nodeID :[" + nodeID + "]");
        Node detailNode = null;
        NodeList detailList = null;
        try {
            try {
                objContext = objContext == null ? "1" : objContext;
                nodeID = nodeID == null ? "1" : nodeID;
                detailList = dom.getElementsByTagName("Detail" + objContext);
                int detListLength = detailList.getLength();
                int ctr = 0;
                while (ctr < detListLength) {
                    Node curDetail = detailList.item(ctr);
                    if (curDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(nodeID)) {
                        detailNode = curDetail;
                        curDetail = null;
                        break;
                    }
                    ++ctr;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : GenericUtility :searchNode :==>" + e);
                throw new ITMException(e);
            }
        }
        finally {
            detailList = null;
        }
        return detailNode;
    }

    public ResultSet executeQuery(Connection myCon, String sqlQry, String pkValues, String pkColumnsDataType) throws ITMException {
        BaseLogger.log("2", null, null, "Query Parameters :[" + pkValues + "] and their types :[" + pkColumnsDataType + "]");
        ResultSet rs = null;
        Statement pstmt = null;
        String COLUMN_SEPARATOR = ":";
        E12GenericUtility genericUtility = null;
        StringTokenizer qryParamTokens = null;
        try {
            try {
                genericUtility = new E12GenericUtility();
                pstmt = myCon.prepareStatement(sqlQry);
                if (pkValues != null && sqlQry.indexOf("?") != -1) {
                    qryParamTokens = new StringTokenizer(pkValues);
                    int pCount = 1;
                    while (qryParamTokens.hasMoreTokens()) {
                        String testParam = qryParamTokens.nextToken(COLUMN_SEPARATOR);
                        if (pkColumnsDataType != null) {
                            String testParamType = pkColumnsDataType.substring(0, pkColumnsDataType.indexOf(COLUMN_SEPARATOR));
                            BaseLogger.log("3", null, null, "Setting Param value :[" + testParam + "] Type :[" + testParamType + "] position :[" + pCount + "]");
                            if (testParamType.equalsIgnoreCase("DATETIME")) {
                                testParam = genericUtility.getValidDateTimeString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat());
                                pstmt.setTimestamp(pCount, Timestamp.valueOf(testParam));
                            } else if (testParamType.equalsIgnoreCase("DATE")) {
                                testParam = this.getValidDateString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat());
                                pstmt.setDate(pCount, java.sql.Date.valueOf(testParam));
                            } else if (testParamType.equalsIgnoreCase("DECIMAL")) {
                                pstmt.setDouble(pCount, Double.parseDouble(testParam));
                            } else {
                                pstmt.setString(pCount, testParam);
                            }
                            pkColumnsDataType = pkColumnsDataType.substring(pkColumnsDataType.indexOf(COLUMN_SEPARATOR) + 1);
                            testParamType = null;
                        } else {
                            pstmt.setString(pCount, testParam);
                        }
                        testParam = null;
                        ++pCount;
                    }
                }
                rs = pstmt.executeQuery();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :DB2XMLGenerator :executeQuery() ==>");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                try {
                    if (pstmt != null && !pstmt.isClosed()) {
                        pstmt.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
            finally {
                pstmt = null;
            }
            genericUtility = null;
            qryParamTokens = null;
        }
        return rs;
    }

    public String getDBDateTimeFormat() throws ITMException, Exception {
        DocumentBuilderFactory dbf = null;
        DocumentBuilder db = null;
        Document doc = null;
        NodeList nlDateFormat = null;
        try {
            try {
                if (CommonConstants.DB_DATETIME_FORMAT == null && (nlDateFormat = (doc = (db = (dbf = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("DB_DATETIME_FORMAT")) != null) {
                    Node ndDateFormat = nlDateFormat.item(0);
                    if (ndDateFormat != null && ndDateFormat.getFirstChild() != null) {
                        CommonConstants.DB_DATETIME_FORMAT = ndDateFormat.getFirstChild().getNodeValue();
                    }
                    ndDateFormat = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getDBDateFormat :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            dbf = null;
            db = null;
            doc = null;
            nlDateFormat = null;
        }
        return CommonConstants.DB_DATETIME_FORMAT;
    }

    public String getValidDateTimeString(Date dateTime, String targetDateTimeFormat) throws ITMException {
        String retDateStr = "";
        SimpleDateFormat sdfOutput = null;
        try {
            try {
                sdfOutput = new SimpleDateFormat(targetDateTimeFormat);
                retDateStr = sdfOutput.format(dateTime);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getValidDateTimeString :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            sdfOutput = null;
        }
        BaseLogger.log("2", null, null, "retDateStr :" + retDateStr);
        return retDateStr;
    }

    public Column getColumnObject(ArrayList columnObjects, String colLogicalName) throws ITMException, Exception {
        Column colObj = null;
        try {
            int colIndex = 0;
            while (colIndex < columnObjects.size()) {
                if (((Column)columnObjects.get(colIndex)).getLogicalName().equalsIgnoreCase(colLogicalName)) {
                    colObj = (Column)columnObjects.get(colIndex);
                    break;
                }
                ++colIndex;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GenericUtility :getColumnObject :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return colObj;
    }

    public String getValidDateTimeString(String dateTime, String targetDateTimeFormat) throws ITMException {
        String retDateStr = "";
        Date dateTimeObj = null;
        SimpleDateFormat sdfOutput = null;
        try {
            try {
                dateTimeObj = this.getDateTimeObject(dateTime);
                sdfOutput = new SimpleDateFormat(targetDateTimeFormat);
                retDateStr = sdfOutput.format(dateTimeObj);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getValidDateTimeString :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            dateTimeObj = null;
            sdfOutput = null;
        }
        BaseLogger.log("2", null, null, "retDateStr :" + retDateStr);
        return retDateStr;
    }

    public String getValidDateString(String dateTime, String targetDateTimeFormat) throws ITMException {
        String retDateStr = "";
        Date dateTimeObj = null;
        SimpleDateFormat sdfOutput = null;
        try {
            try {
                dateTimeObj = this.getDateObject(dateTime);
                sdfOutput = new SimpleDateFormat(targetDateTimeFormat);
                retDateStr = sdfOutput.format(dateTimeObj);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getValidDateString :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            dateTimeObj = null;
            sdfOutput = null;
        }
        BaseLogger.log("2", null, null, "retDateStr :" + retDateStr);
        return retDateStr;
    }

    public String getThemeFormat() throws ITMException, Exception {
        DocumentBuilderFactory dbf = null;
        DocumentBuilder db = null;
        Document doc = null;
        NodeList nlThemeFormat = null;
        Node ndThemeFormat = null;
        try {
            try {
                if (CommonConstants.THEME == null && (ndThemeFormat = (nlThemeFormat = (doc = (db = (dbf = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse("/IBASEHOME" + File.separator + "ibase.xml")).getElementsByTagName("THEME")).item(0)) != null && ndThemeFormat.getFirstChild() != null) {
                    CommonConstants.THEME = ndThemeFormat.getFirstChild().getNodeValue();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :GenericUtility :getThemeFormat :==>[" + e + "]");
                throw new ITMException(e);
            }
        }
        finally {
            dbf = null;
            db = null;
            doc = null;
            nlThemeFormat = null;
            ndThemeFormat = null;
        }
        BaseLogger.log("2", null, null, "CommonConstants.THEME:==> [" + CommonConstants.THEME + "]");
        return CommonConstants.THEME;
    }

    public boolean isErrorNodeFound(String errXmlString) throws ITMException, Exception {
        boolean isErrorNodeFound;
        block8: {
            isErrorNodeFound = false;
            NodeList errorNodeList = null;
            try {
                try {
                    if (errXmlString.indexOf("<Errors>") == -1) break block8;
                    errorNodeList = this.parseString(errXmlString).getElementsByTagName("error");
                    int errorNodeListLen = errorNodeList.getLength();
                    int i = 0;
                    while (i < errorNodeListLen) {
                        String errorType = errorNodeList.item(i).getAttributes().getNamedItem("type").getNodeValue();
                        BaseLogger.log("3", null, null, "errorType :[" + errorType + "]");
                        if ("E".equals(errorType)) {
                            isErrorNodeFound = true;
                            errorType = null;
                            break;
                        }
                        if ("X".equals(errorType)) {
                            isErrorNodeFound = true;
                            errorType = null;
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
            finally {
                errorNodeList = null;
            }
        }
        return isErrorNodeFound;
    }

    public void writeLoggerFile(String userId, String siteCode, String eventCode, String focussedColumn, String xmlDataAll, String xmlData, String returnData) throws Exception {
        BufferedReader bf = null;
        BufferedWriter bw = null;
        Date date = null;
        String time = null;
        String infoData = null;
        String tranData = null;
        String filePath = null;
        File file = null;
        StringBuffer fileContent = null;
        try {
            try {
                date = new Date();
                time = String.valueOf(date.getHours()) + ":" + date.getMinutes() + ":" + date.getSeconds();
                infoData = "Time [" + time + "] User::[" + userId + "] SiteCode::[" + siteCode + "] EventCode::[" + eventCode + "] focussedColumn::[" + focussedColumn + "]";
                tranData = "[" + xmlDataAll + "] " + "Data Send::[" + xmlData + "] " + "Data Returned::[" + returnData + "] ";
                filePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + userId + ".txt";
                file = new File(filePath);
                fileContent = new StringBuffer("");
                if (file.exists()) {
                    bf = new BufferedReader(new FileReader(file));
                    String outTempStr = null;
                    while ((outTempStr = bf.readLine()) != null) {
                        if (outTempStr == null || outTempStr.trim().length() <= 0) continue;
                        fileContent = fileContent.append(String.valueOf(outTempStr) + "\n");
                        outTempStr = null;
                    }
                    if (bf != null) {
                        bf.close();
                    }
                } else {
                    fileContent.append("");
                }
                bw = new BufferedWriter(new FileWriter(file));
                bw.newLine();
                bw.write(fileContent.append(infoData).toString());
                bw.newLine();
                bw.write(tranData);
                bw.flush();
                bw.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception occured while writting logger file: In GenericUtility:writeLoggerFile [" + userId + "]");
                throw new ITMException(e);
            }
        }
        finally {
            if (bf != null) {
                bf.close();
            }
            if (bw != null) {
                bw.close();
            }
            bf = null;
            bw = null;
            date = null;
            time = null;
            infoData = null;
            tranData = null;
            filePath = null;
            file = null;
            fileContent = null;
        }
    }

    public String generateLog(String dataString, String mailSubject, String logFileName, boolean sendMailFlag) throws ITMException, Exception {
        BufferedWriter logFileWriter = null;
        double randomNo = Math.random();
        try {
            try {
                if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + logFileName + randomNo + ".txt").exists()) {
                    new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + logFileName + randomNo + ".txt").createNewFile();
                }
                logFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + logFileName + randomNo + ".txt";
                BaseLogger.log("3", null, null, "GenericUtility:generateLog[" + logFileName + "]");
                logFileWriter = new BufferedWriter(new FileWriter(logFileName));
                logFileWriter.newLine();
                logFileWriter.write(dataString);
                logFileWriter.flush();
                logFileWriter.close();
                logFileWriter = null;
                this.sendMail(logFileName, mailSubject);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Error when generating the log : In GenericUtility:generateLog[" + randomNo + "]");
                throw new ITMException(e);
            }
        }
        finally {
            block17: {
                try {
                    try {
                        if (logFileWriter != null) {
                            logFileWriter.flush();
                            logFileWriter.close();
                            logFileWriter = null;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logFileWriter = null;
                        logFileWriter = null;
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    logFileWriter = null;
                    throw throwable;
                }
                logFileWriter = null;
            }
        }
        return logFileName;
    }

    private void sendMail(String logFileName, String mailSubject) throws ITMException, Exception {
        String emailID = null;
        EMail emailObj = null;
        StringBuffer mailInfoXml = null;
        if (mailSubject == null || mailSubject != null && mailSubject.trim().length() == 0) {
            mailSubject = "No Subject";
        }
        try {
            try {
                emailID = this.checkEmailId();
                if (emailID != null && emailID.trim().length() > 0) {
                    emailObj = new EMail();
                    mailInfoXml = new StringBuffer();
                    mailInfoXml.append("<MAILINFO>");
                    mailInfoXml.append("<EMAIL_TYPE><![CDATA[page]]></EMAIL_TYPE>");
                    mailInfoXml.append("<TO_ADD><![CDATA[" + emailID + "]]></TO_ADD>");
                    mailInfoXml.append("<SUBJECT><![CDATA[" + mailSubject + "]]></SUBJECT>");
                    mailInfoXml.append("<MESSAGE><![CDATA[" + logFileName + "]]></MESSAGE>");
                    mailInfoXml.append("<XML_DATA_FILE><![CDATA[" + logFileName + "]]></XML_DATA_FILE>");
                    mailInfoXml.append("</MAILINFO>");
                    emailObj.sendMail(mailInfoXml.toString(), null);
                } else {
                    BaseLogger.log("3", null, null, "Tech Support E-mail id not defined.");
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Error when Sending the mail : In GenericUtility:sendMail [" + logFileName + "]");
                throw new ITMException(e);
            }
        }
        finally {
            emailID = null;
            emailObj = null;
            mailInfoXml = null;
        }
    }

    private String checkEmailId() throws ITMException, Exception {
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String emailId = null;
        String query = null;
        try {
            try {
                con = new ConnDriver().getConnectDB("Driver");
                query = "SELECT EMAIL_ID FROM PARAMETER";
                pstmt = con.prepareStatement(query);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    emailId = rs.getString("EMAIL_ID");
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Error when checking email Id : In GenericUtility:checkEmailId");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null && !pstmt.isClosed()) {
                    pstmt.close();
                }
                if (con != null && !con.isClosed()) {
                    con.close();
                }
                query = null;
                pstmt = null;
                rs = null;
                con = null;
            }
            catch (Exception ex) {
                throw new ITMException(ex);
            }
            query = null;
            pstmt = null;
            rs = null;
            con = null;
        }
        return emailId;
    }

    public String writePrintStacktrace(Exception e) {
        String errorlog = null;
        ByteArrayOutputStream b = null;
        PrintStream p = null;
        try {
            try {
                b = new ByteArrayOutputStream();
                p = new PrintStream(b);
                e.printStackTrace(p);
                errorlog = b.toString();
                p.flush();
                b.close();
                p.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (b != null) {
                    b = null;
                }
                if (p != null) {
                    p = null;
                }
            }
        }
        finally {
            if (b != null) {
                b = null;
            }
            if (p != null) {
                p = null;
            }
        }
        return errorlog;
    }

    public void removeWhitespaces(Node n) {
        this.removeWhitespaceInner(n, null);
    }

    public void removeWhitespaceInner(Node n, Node parent) {
        ArrayList<Node> toBeProcessed = null;
        if (parent != null && n instanceof Text && !(n instanceof CDATASection)) {
            Text t = (Text)n;
            if (t.getData().matches("[ \t\n]*")) {
                parent.removeChild(t);
            }
            t = null;
        }
        if (n.hasChildNodes()) {
            int length = n.getChildNodes().getLength();
            toBeProcessed = new ArrayList<Node>();
            int i = 0;
            while (i < length) {
                toBeProcessed.add(n.getChildNodes().item(i));
                ++i;
            }
            for (Node childNode : toBeProcessed) {
                this.removeWhitespaceInner(childNode, n);
            }
        }
    }

    public String getDisplayValues(String value) throws ParserConfigurationException, SAXException, IOException {
        String tagValues = null;
        String fileName = CommonConstants.APPLICATION_CONTEXT;
        String separator = System.getProperty("file.separator");
        String applFilePath = null;
        BaseLogger.log("0", null, null, "Called getDisplayValues():: " + fileName);
        Document doc = null;
        File fXmlFile = null;
        NodeList nList = null;
        NodeList tagValue = null;
        Node nValue = null;
        try {
            try {
                if (fileName.contains(".war")) {
                    int lastSeparatorIndex = fileName.lastIndexOf(String.valueOf(separator) + "ibase.war");
                    applFilePath = lastSeparatorIndex == -1 ? fileName : String.valueOf(fileName.substring(0, lastSeparatorIndex + 1)) + "META-INF/application.xml";
                }
                fXmlFile = new File(applFilePath);
                try {
                    doc = this.parseFile(fXmlFile);
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception in parsing file: " + e.getMessage());
                    e.printStackTrace();
                }
                nList = doc.getElementsByTagName("application");
                int temp = 0;
                while (temp < nList.getLength()) {
                    Node nNode = nList.item(temp);
                    if (nNode.getNodeType() == 1) {
                        Element eElement = (Element)nNode;
                        if (value != null) {
                            tagValue = eElement.getElementsByTagName(value).item(0).getChildNodes();
                            eElement = null;
                            nValue = tagValue.item(0);
                            tagValues = nValue.getNodeValue();
                            nValue = null;
                            BaseLogger.log("3", null, null, "display Details for user connections: " + tagValues);
                        }
                    }
                    nNode = null;
                    ++temp;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in GenericUtility:getDisplayValues: " + e.getMessage());
                e.printStackTrace();
                doc = null;
                fXmlFile = null;
                nList = null;
                tagValue = null;
                nValue = null;
            }
        }
        finally {
            doc = null;
            fXmlFile = null;
            nList = null;
            tagValue = null;
            nValue = null;
        }
        return tagValues;
    }

    public boolean isWarnNodeFound(String errXmlString) throws ITMException, Exception {
        boolean isErrorNodeFound;
        block7: {
            isErrorNodeFound = false;
            NodeList errorNodeList = null;
            try {
                try {
                    if (errXmlString.indexOf("<Errors>") == -1) break block7;
                    errorNodeList = this.parseString(errXmlString).getElementsByTagName("error");
                    int errorNodeListLen = errorNodeList.getLength();
                    int i = 0;
                    while (i < errorNodeListLen) {
                        String errorType = errorNodeList.item(i).getAttributes().getNamedItem("type").getNodeValue();
                        BaseLogger.log("3", null, null, "errorType :[" + errorType + "]");
                        if ("W".equals(errorType)) {
                            isErrorNodeFound = true;
                            errorType = null;
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
            finally {
                errorNodeList = null;
            }
        }
        return isErrorNodeFound;
    }

    public boolean isSuccessNodeFound(String errXmlString) throws ITMException, Exception {
        boolean isSuccessFound;
        block8: {
            isSuccessFound = true;
            NodeList errorNodeList = null;
            try {
                try {
                    if (errXmlString.indexOf("<Errors>") == -1) break block8;
                    errorNodeList = this.parseString(errXmlString).getElementsByTagName("error");
                    int errorNodeListLen = errorNodeList.getLength();
                    int i = 0;
                    while (i < errorNodeListLen) {
                        String errorType = errorNodeList.item(i).getAttributes().getNamedItem("type").getNodeValue();
                        BaseLogger.log("3", null, null, "errorType :[" + errorType + "]");
                        if ("X".equals(errorType)) {
                            isSuccessFound = false;
                            errorType = null;
                            break;
                        }
                        if ("E".equals(errorType)) {
                            isSuccessFound = false;
                            errorType = null;
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
            finally {
                errorNodeList = null;
            }
        }
        return isSuccessFound;
    }

    private String getValidDateFormat(String dateFormat) {
        if (dateFormat != null && dateFormat.indexOf("[.fffffffff]") != -1) {
            dateFormat = dateFormat.replace("[.fffffffff]", "");
        }
        return dateFormat;
    }

    public boolean isXMLString(String xmlString) {
        boolean isXml = false;
        if (xmlString != null) {
            if ((xmlString = xmlString.trim()).startsWith("<") && xmlString.indexOf("</") != -1 && xmlString.indexOf(">") != -1) {
                isXml = true;
            }
            BaseLogger.log("3", null, null, "xmlString[" + xmlString + "]isXml[" + isXml + "]");
        }
        return isXml;
    }

    public String getValidDateString(Date date, String targetDateFormat) throws BaseException {
        String retDateStr = "";
        try {
            SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateFormat);
            retDateStr = sdfOutput.format(date);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GenericUtility :getValidDateString :==>" + e.getMessage());
            throw new BaseException(e);
        }
        return retDateStr;
    }

    public String getValidDateString(java.sql.Date date, String targetDateFormat) throws BaseException {
        String retDateStr = "";
        try {
            SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateFormat);
            retDateStr = sdfOutput.format(date);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GenericUtility :getValidDateString :==>" + e.getMessage());
            throw new BaseException(e);
        }
        return retDateStr;
    }

    public String getValidDateTimeString(Timestamp dateTime, String targetDateTimeFormat) throws BaseException {
        String retDateStr = "";
        try {
            if (targetDateTimeFormat.toLowerCase().indexOf("hh:mm:ss") == -1) {
                targetDateTimeFormat = String.valueOf(targetDateTimeFormat) + " HH:mm:ss";
            }
            SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateTimeFormat);
            retDateStr = sdfOutput.format(dateTime);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GenericUtility :getValidDateString :==>" + e.getMessage());
            throw new BaseException(e);
        }
        BaseLogger.log("2", null, null, "retDateStr :" + retDateStr);
        return retDateStr;
    }

    public String arrayListToString(ArrayList inputArrayList) throws Exception {
        String xmlStringOfArrayList = "";
        int sizeOfArray = inputArrayList.size();
        if (!this.subarraylist) {
            xmlStringOfArrayList = "<Root>";
        }
        int i = 0;
        while (i < sizeOfArray) {
            if (inputArrayList.get(i) == null) {
                xmlStringOfArrayList = !this.subarraylist ? String.valueOf(xmlStringOfArrayList) + "<index" + i + ">" + (String)inputArrayList.get(i) + "</index" + i + ">" : String.valueOf(xmlStringOfArrayList) + "<index" + Integer.parseInt(this.idxOfSubArrLst) + i + ">" + (String)inputArrayList.get(i) + "</index" + Integer.parseInt(this.idxOfSubArrLst) + i + ">";
            }
            if (inputArrayList.get(i) != null && inputArrayList.get(i).getClass().getName().equals("java.lang.String")) {
                xmlStringOfArrayList = !this.subarraylist ? String.valueOf(xmlStringOfArrayList) + "<index" + i + ">" + (String)inputArrayList.get(i) + "</index" + i + ">" : String.valueOf(xmlStringOfArrayList) + "<index" + Integer.parseInt(this.idxOfSubArrLst) + i + ">" + (String)inputArrayList.get(i) + "</index" + Integer.parseInt(this.idxOfSubArrLst) + i + ">";
            }
            if (inputArrayList.get(i) != null && inputArrayList.get(i).getClass().getName().equals("java.util.ArrayList")) {
                this.idxOfSubArrLst = "" + i;
                this.subarraylist = true;
                xmlStringOfArrayList = String.valueOf(xmlStringOfArrayList) + "<index" + i + ">" + this.arrayListToString((ArrayList)inputArrayList.get(i)) + "</index" + i + ">";
                this.subarraylist = false;
            }
            ++i;
        }
        if (!this.subarraylist) {
            xmlStringOfArrayList = String.valueOf(xmlStringOfArrayList) + "</Root>";
        }
        return xmlStringOfArrayList;
    }

    public ArrayList stringToArrayList(String inputStringXML) throws Exception {
        String nodevalue = "";
        ArrayList stringToArrayList = new ArrayList();
        TreeMap<String, Object> valueofNodeTreeMap = new TreeMap<String, Object>();
        Document dom1 = this.parseString(inputStringXML);
        NodeList nodelist = dom1.getElementsByTagName("Root");
        Node node = nodelist.item(0);
        NodeList childnodelist = node.getChildNodes();
        int size = childnodelist.getLength();
        int iTot = 0;
        while (iTot < size) {
            Node valueNode = childnodelist.item(iTot);
            if (valueNode.getFirstChild().getNodeType() == 3) {
                nodevalue = valueNode.getNodeName();
                valueofNodeTreeMap.put(nodevalue, valueNode.getFirstChild().getNodeValue());
            } else {
                nodevalue = valueNode.getNodeName();
                valueofNodeTreeMap.put(nodevalue, this.subStringTosubArrayList(valueNode, iTot));
            }
            ++iTot;
        }
        iTot = 0;
        while (iTot < size) {
            stringToArrayList.add(valueofNodeTreeMap.get("index" + iTot));
            ++iTot;
        }
        return stringToArrayList;
    }

    public ArrayList subStringTosubArrayList(Node inputsubStringXML, int index) throws Exception {
        String subnodeName = " ";
        ArrayList subStringToArrayList = new ArrayList();
        TreeMap<String, String> valueofsubNodeTreeMap = new TreeMap<String, String>();
        Node getNextNode = inputsubStringXML.getFirstChild();
        while (getNextNode != null) {
            subnodeName = getNextNode.getNodeName();
            valueofsubNodeTreeMap.put(subnodeName, getNextNode.getFirstChild().getNodeValue());
            getNextNode = getNextNode.getNextSibling();
        }
        int sizeofTreeMap = valueofsubNodeTreeMap.size();
        int iTot = 0;
        while (iTot < sizeofTreeMap) {
            subStringToArrayList.add(valueofsubNodeTreeMap.get("index" + index + iTot));
            ++iTot;
        }
        return subStringToArrayList;
    }

    public String HashmapToString(HashMap inputHashMap) throws Exception {
        String xmlStringOfHashMap = null;
        try {
            xmlStringOfHashMap = "<Root>";
            int sizeOfHashMap = inputHashMap.size();
            Set keyset = inputHashMap.keySet();
            ArrayList arraykeylist = new ArrayList(keyset);
            int i = 0;
            while (i < sizeOfHashMap) {
                if (inputHashMap.get(arraykeylist.get(i)) == null) {
                    xmlStringOfHashMap = String.valueOf(xmlStringOfHashMap) + "<" + arraykeylist.get(i) + ">" + inputHashMap.get(arraykeylist.get(i)) + "</" + arraykeylist.get(i) + ">";
                }
                if (inputHashMap.get(arraykeylist.get(i)) != null && inputHashMap.get(arraykeylist.get(i)).getClass().getName().equals("java.lang.String")) {
                    xmlStringOfHashMap = String.valueOf(xmlStringOfHashMap) + "<" + arraykeylist.get(i) + ">" + inputHashMap.get(arraykeylist.get(i)) + "</" + arraykeylist.get(i) + ">";
                }
                ++i;
            }
            xmlStringOfHashMap = String.valueOf(xmlStringOfHashMap) + "</Root>";
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GenericUtility :HashmapToString :==>\n" + e.getMessage());
            throw new BaseException(e);
        }
        return xmlStringOfHashMap;
    }

    public HashMap StringToHashmap(String inputStringXML) throws Exception {
        HashMap<String, String> stringToHashMap = new HashMap<String, String>();
        try {
            BaseLogger.log("3", null, null, "In StringToHashmap");
            Document dom1 = this.parseString(inputStringXML);
            NodeList nodelist = dom1.getElementsByTagName("Root");
            Node node = nodelist.item(0);
            NodeList childnodelist = node.getChildNodes();
            int size = childnodelist.getLength();
            int iTot = 0;
            while (iTot < size) {
                Node valueNode = childnodelist.item(iTot);
                if (!valueNode.getFirstChild().getNodeValue().equals("null")) {
                    stringToHashMap.put(valueNode.getNodeName(), valueNode.getFirstChild().getNodeValue());
                } else {
                    stringToHashMap.put(valueNode.getNodeName(), null);
                }
                ++iTot;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GenericUtility :StringToHashmap :==>\n" + e.getMessage());
            throw new BaseException(e);
        }
        return stringToHashMap;
    }

    public Document getDocument(String inputString) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, CommonConstants.ENCODING);
        ByteArrayInputStream baos = new ByteArrayInputStream(inputString.getBytes(CommonConstants.ENCODING));
        Document dom1 = db.parse(baos);
        return dom1;
    }

    public void writeToFile(Node xmlNode, String filePath) throws BaseException {
        try {
            String serializeDomStr = null;
            serializeDomStr = xmlNode.getNodeType() == 1 ? this.serializeDom(xmlNode, true) : this.serializeDom(xmlNode);
            this.writeToFile(serializeDomStr, filePath);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public void writeToFile(String xmlDomString, String filePath) throws BaseException {
        try {
            FileWriter fw = new FileWriter(filePath, StandardCharsets.UTF_8);
            BaseLogger.log("3", null, null, "E12GeneericUtility writeToFile using StandardCharsets.UTF_8");
            fw.write(xmlDomString);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public String getErrorMsgDescr(String errorXmlStr) throws BaseException {
        StringBuffer retStrBuff = new StringBuffer("");
        try {
            String tempStr = "";
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(errorXmlStr.getBytes(CommonConstants.ENCODING));
            Document doc = db.parse(bais);
            NodeList nlApp = doc.getElementsByTagName("message");
            if (nlApp.item(0).getFirstChild() != null) {
                tempStr = nlApp.item(0).getFirstChild().getNodeValue();
            }
            if ((nlApp = doc.getElementsByTagName("description")).item(0).getFirstChild() != null) {
                tempStr = nlApp.item(0).getFirstChild().getNodeValue();
            }
            if (tempStr.indexOf("INVALID_ACCESS") != -1) {
                tempStr = "Session time out.";
            }
            retStrBuff.append(" Error Description : " + tempStr);
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return retStrBuff.toString();
    }

    public Object getObj(String lookupName) throws Exception {
        EJBHome obHome = this.getHome(lookupName);
        Method m = obHome.getClass().getDeclaredMethod("create", new Class[0]);
        Object obj = m.invoke((Object)obHome, new Object[0]);
        return obj;
    }

    private EJBHome getHome(String lookupName) throws Exception {
        AppConnectParm appConnect = new AppConnectParm();
        Properties p = appConnect.getProperty();
        InitialContext ctx = new InitialContext(p);
        Object home = ctx.lookup(lookupName);
        EJBHome obHome = (EJBHome)PortableRemoteObject.narrow((Object)home, EJBHome.class);
        return obHome;
    }

    public void writeFile(String fileName, String contents) {
        try {
            if ("1".equals(CommonConstants.COMP_LOG)) {
                String filePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + fileName + "_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".cvs";
                File file = new File(filePath);
                if (!file.exists()) {
                    BaseLogger.log("3", null, null, "New File created.....");
                    file.createNewFile();
                }
                FileWriter fos = new FileWriter(file, true);
                fos.write(contents);
                fos.flush();
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    public boolean isNumeric(String numberStr) {
        boolean isNumber;
        try {
            Integer.parseInt(numberStr);
            isNumber = true;
        }
        catch (Exception ex) {
            isNumber = false;
        }
        return isNumber;
    }

    public void deleteDir(String dirPath) throws Throwable {
        File file = new File(dirPath);
        if (file.exists()) {
            FileUtils.deleteDirectory((File)file);
            BaseLogger.log("3", null, null, "This " + file.getName() + " dir has been deleted.");
        }
    }

    public void deleteFile(String filePath) throws Throwable {
        File file = new File(filePath);
        if (file.exists() && file.delete()) {
            BaseLogger.log("3", null, null, "This " + file.getName() + " file has been deleted.");
        }
    }

    public boolean compareFiles(String filePath1, String filePath2) {
        BaseLogger.log("2", null, null, "------------Comparing files--------------");
        boolean isOld = false;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            File file1 = new File(filePath1);
            File file2 = new File(filePath2);
            String file1Date = sdf.format(file1.lastModified());
            String file2Date = sdf.format(file2.lastModified());
            Date date1 = sdf.parse(file1Date);
            Date date2 = sdf.parse(file2Date);
            if (date1.after(date2)) {
                isOld = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isOld;
    }

    public String xmlToJSONString(String xmlString) throws Exception {
        return new XMLtoJSONConverter().xmlToJSONString(xmlString);
    }

    public String jsonToXMLString(String jsonString) throws ITMException {
        return new JSONtoXMLConverter().jsonToXMLString(jsonString);
    }

    public boolean isJSONValid(String jsonString) {
        try {
            new JSONObject(jsonString);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(jsonString);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public boolean isJSONArrayValid(String jsonString) {
        try {
            new JSONArray(jsonString);
        }
        catch (JSONException ex) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getReorderedXML(String targetXml, String inputXML) throws ITMException, NumberFormatException, RemoteException {
        Document transDom = this.parseString(inputXML);
        Document blankDom = null;
        NodeList transDomChildNL = null;
        if (transDom.getElementsByTagName("Header0").item(0) != null) {
            transDomChildNL = transDom.getElementsByTagName("Header0").item(0).getChildNodes();
        }
        int transDomChildNLLength = transDomChildNL.getLength();
        int i = 0;
        while (i < transDomChildNLLength) {
            Node transDomChildNode = null;
            if (transDomChildNL.item(i) != null) {
                transDomChildNode = transDomChildNL.item(i);
            }
            Node tempNode = null;
            if (transDomChildNode.getNodeName().indexOf("Detail") != -1) {
                blankDom = this.parseString(targetXml);
                String currObjCtx = "";
                String currDomID = "";
                if (transDomChildNode.getAttributes().getNamedItem("domID") != null) {
                    currDomID = transDomChildNode.getAttributes().getNamedItem("domID").getNodeValue();
                }
                if (transDomChildNode.getAttributes().getNamedItem("objContext") != null) {
                    currObjCtx = transDomChildNode.getAttributes().getNamedItem("objContext").getNodeValue();
                }
                tempNode = blankDom.getElementsByTagName(transDomChildNode.getNodeName()).item(0);
                NamedNodeMap attributesH = tempNode.getAttributes();
                Node searchNode = transDomChildNode;
                int attCtr = 0;
                while (attCtr < attributesH.getLength()) {
                    Node attr = attributesH.item(attCtr);
                    String attributeString = E12GenericUtility.getAttributeValue(transDom, currObjCtx, currDomID, attr.getNodeName());
                    attr.setNodeValue(attributeString);
                    ++attCtr;
                }
                NodeList nodeList = tempNode.getChildNodes();
                String valueData = "";
                int nodeCtr = 0;
                while (nodeCtr < nodeList.getLength()) {
                    Node currNode = nodeList.item(nodeCtr);
                    if (!"#text".equals(currNode.getNodeName())) {
                        if (!currNode.getNodeName().equalsIgnoreCase("attribute")) {
                            valueData = this.getColumnValueFromNode(currNode.getNodeName(), searchNode);
                            BaseLogger.log("3", null, null, String.valueOf(searchNode.getNodeName()) + "=" + currNode.getNodeName() + "=" + valueData);
                            if (valueData == null) {
                                valueData = "";
                            }
                            if (currNode.getFirstChild() != null) {
                                currNode.removeChild(currNode.getFirstChild());
                            }
                            if (currNode.getFirstChild() != null) {
                                currNode.setNodeValue(valueData);
                            } else {
                                CDATASection cDataSection = blankDom.createCDATASection(valueData);
                                currNode.appendChild(cDataSection);
                            }
                        } else {
                            NamedNodeMap attributes = currNode.getAttributes();
                            int attCtr2 = 0;
                            while (attCtr2 < attributes.getLength()) {
                                Node attr = attributes.item(attCtr2);
                                String attribString = E12GenericUtility.getAttributeValue(searchNode, attr.getNodeName());
                                attr.setNodeValue(attribString);
                                ++attCtr2;
                            }
                        }
                    }
                    ++nodeCtr;
                }
                Node headerNode = transDom.getElementsByTagName("Header0").item(0);
                headerNode.replaceChild(headerNode.getOwnerDocument().importNode(tempNode, true), transDomChildNode);
            }
            ++i;
        }
        return this.serializeDom(transDom);
    }

    private static String getAttributeValue(Document dom, String objContext, String domID, String attributeName) throws ITMException {
        String attributeValue = null;
        try {
            objContext = objContext == null || objContext.length() == 0 ? "1" : objContext;
            domID = domID == null || domID.length() == 0 ? "1" : domID;
            NodeList detailList = dom.getElementsByTagName("Detail" + objContext);
            int detListLength = detailList.getLength();
            int ctr = 0;
            while (ctr < detListLength) {
                Node curDetail = detailList.item(ctr);
                if (curDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(domID)) {
                    if (curDetail.getAttributes().getNamedItem(attributeName) != null) {
                        attributeValue = curDetail.getAttributes().getNamedItem(attributeName).getNodeValue();
                    }
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : : searchNode :[" + e.getMessage() + "]");
            throw new ITMException(e);
        }
        return attributeValue;
    }

    public static String getAttributeValue(Node dom, String attributeName) throws ITMException {
        String attributeValue = null;
        try {
            NodeList detailList = dom.getChildNodes();
            int detListLength = detailList.getLength();
            int ctr = 0;
            while (ctr < detListLength) {
                Node curDetail = detailList.item(ctr);
                if ("attribute".equals(curDetail.getNodeName())) {
                    if (curDetail.getAttributes().getNamedItem(attributeName) != null) {
                        attributeValue = curDetail.getAttributes().getNamedItem(attributeName).getNodeValue();
                    }
                    BaseLogger.log("3", null, null, "attributeValue 3712!!![" + attributeValue + "]");
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : : searchNode :" + e);
            throw new ITMException(e);
        }
        return attributeValue;
    }

    public static void printOnDemand(Object msg) {
        if ("9".equals(CommonConstants.DEBUG_LEVEL)) {
            BaseLogger.log("3", null, null, msg);
        }
    }

    public static void printAlways(Object msg) {
        BaseLogger.log("2", null, null, msg);
    }

    public void setAttribValue(Node node, String nodeName, String value) {
        if (node.hasAttributes()) {
            NamedNodeMap detAttrMap = node.getAttributes();
            int ind = 0;
            while (ind < detAttrMap.getLength()) {
                Node attr = detAttrMap.item(ind);
                BaseLogger.log("3", null, null, "Print nodename::: 3580 [" + attr.getNodeName() + "]");
                if (nodeName.equalsIgnoreCase(attr.getNodeName())) {
                    attr.setNodeValue(value);
                    break;
                }
                ++ind;
            }
        }
    }

    public String editWebSocketXml(String infiStr) {
        HashMap<void, void> transPkDataMap = new HashMap<void, void>();
        StringBuilder finalInfiString = new StringBuilder();
        String PKFieldNames = "";
        String PKFieldValues = "";
        String dataXml = "";
        String[] pkNamesData = null;
        String[] pkValuesData = null;
        String currentUpdateFlag = "";
        try {
            NodeList detailNodeList;
            Document document;
            block16: {
                if (!"".equalsIgnoreCase(infiStr) && infiStr.length() > 0) {
                    String[] newData = infiStr.split("~");
                    PKFieldNames = newData[0];
                    PKFieldValues = newData[1];
                    dataXml = newData[2];
                    pkNamesData = PKFieldNames.split(":");
                    pkValuesData = PKFieldValues.split(":");
                }
                int j = 0;
                while (j < pkNamesData.length) {
                    transPkDataMap.put(pkNamesData[j], pkValuesData[j]);
                    ++j;
                }
                BaseLogger.log("3", null, null, "PKFieldNames [" + PKFieldNames + "] PKFieldValues [" + PKFieldValues + "] *** transPkDataMap [" + transPkDataMap + "]  \n");
                document = this.parseString(dataXml);
                detailNodeList = document.getElementsByTagName("Detail1");
                try {
                    Node detNode = detailNodeList.item(0);
                    String id = "";
                    String objCtxt = "1";
                    String domId = "1";
                    NodeList detChildList = detNode.getChildNodes();
                    if (!detNode.hasAttributes() || detNode.getAttributes().getNamedItem("dbID") == null || !"".equalsIgnoreCase(detNode.getAttributes().getNamedItem("dbID").getNodeValue().trim())) break block16;
                    BaseLogger.log("3", null, null, "Vlaue of dbId is blank");
                    id = String.valueOf(objCtxt) + ":" + domId + ":" + PKFieldValues;
                    this.setAttribValue(detNode, "dbID", PKFieldValues);
                    this.setAttribValue(detNode, "id", id);
                    int i = 0;
                    while (i < detChildList.getLength()) {
                        Node detChildNode = detChildList.item(i);
                        if ("attribute".equalsIgnoreCase(detChildNode.getNodeName())) {
                            this.setAttribValue(detChildNode, "pkNames", PKFieldNames);
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("3", null, null, "Exception inside editWebSocketXml line 3573 [" + e.getMessage() + "]");
                }
            }
            NodeList attributeNodeList = document.getElementsByTagName("attribute");
            int n = 0;
            while (n < attributeNodeList.getLength()) {
                Node attributeNode = attributeNodeList.item(n);
                if (attributeNode.hasAttributes()) {
                    NamedNodeMap detailAttrMap = attributeNode.getAttributes();
                    int k = 0;
                    while (k < detailAttrMap.getLength()) {
                        Node tempNode = detailAttrMap.item(k);
                        if ("updateFlag".equalsIgnoreCase(tempNode.getNodeName())) {
                            currentUpdateFlag = tempNode.getFirstChild().getNodeValue();
                        }
                        ++k;
                    }
                }
                ++n;
            }
            BaseLogger.log("3", null, null, "E12GenUtlt currentUpdateFlag [" + currentUpdateFlag + "]");
            if (currentUpdateFlag.equalsIgnoreCase("A") || currentUpdateFlag.equalsIgnoreCase("N")) {
                int j = 0;
                while (j < detailNodeList.getLength()) {
                    Node detailNode = detailNodeList.item(j);
                    NodeList detailChildList = detailNode.getChildNodes();
                    int k = 0;
                    while (k < detailChildList.getLength()) {
                        String nodeName;
                        Node childNode = detailChildList.item(k);
                        if (childNode.getNodeType() == 1 && !"attribute".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() == null && transPkDataMap.containsKey(nodeName = childNode.getNodeName())) {
                            BaseLogger.log("3", null, null, "Node name --" + childNode.getNodeName());
                            childNode.appendChild(document.createCDATASection((String)transPkDataMap.get(nodeName)));
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            document.normalize();
            finalInfiString.append(String.valueOf(PKFieldNames) + "~" + PKFieldValues + "~" + this.serializeDom(document));
            BaseLogger.log("3", null, null, "Changes XML finalInfiString Value [" + finalInfiString + "]  \n");
            infiStr = finalInfiString.toString();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :RequestHandlerServlet :editTransEditorXMLData :==> " + e.getMessage());
        }
        return infiStr;
    }

    public static String updateLog(String trace, String folderPath, String fileName) {
        String exceptionLogFile = "";
        File logFile = null;
        try {
            Random random = new Random();
            int randomInt = random.nextInt(100000);
            String filePath = E12GenericUtility.checkNull(folderPath).length() > 0 ? folderPath : String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "ExceptionLog";
            File logDir = new File(filePath);
            String string = exceptionLogFile = E12GenericUtility.checkNull(fileName).length() > 0 ? fileName : String.valueOf(randomInt);
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            logFile = new File(filePath, String.valueOf(exceptionLogFile) + ".txt");
            logFile.createNewFile();
            PrintWriter writer = new PrintWriter(logFile);
            writer.print(trace);
            writer.close();
        }
        catch (IOException er) {
            BaseLogger.log("0", null, null, "BaseException :: updateLog : " + er.getMessage());
            er.printStackTrace();
        }
        return exceptionLogFile;
    }

    public String getSummaryXSL(String objName, String callerInterface, String enterprise) {
        return this.getObjNameWiseXSL(objName, callerInterface, null, enterprise);
    }

    public String getSummaryXSL(String objName, String callerInterface) {
        return this.getObjNameWiseXSL(objName, callerInterface, null);
    }

    public String getObjNameWiseXSL(String objName, String callerInterface, String dataModelName, String enterprise) {
        String xsl = "";
        try {
            callerInterface = E12GenericUtility.checkNull(callerInterface);
            String xslFileName = "";
            String xslFilePath = "";
            if (!"".equalsIgnoreCase(callerInterface)) {
                xslFileName = E12GenericUtility.checkNull(dataModelName).length() > 0 ? (callerInterface.equalsIgnoreCase("MOBILE") ? String.valueOf(dataModelName) + "_MOBILE.xsl" : String.valueOf(dataModelName) + ".xsl") : (callerInterface.equalsIgnoreCase("MOBILE") ? String.valueOf(objName) + "_preview_MOBILE.xsl" : String.valueOf(objName) + "_preview.xsl");
            }
            xslFilePath = this.getXSLFilePath(xslFileName, enterprise);
            if (callerInterface.equalsIgnoreCase("MOBILE") && xslFilePath == null) {
                xslFileName = String.valueOf(objName) + "_preview.xsl";
                xslFilePath = this.getXSLFilePath(xslFileName, enterprise);
            }
            BaseLogger.log("0", null, null, "!!** Path is [" + xslFilePath + "]");
            if (xslFilePath == null) {
                xsl = "<Root></Root>";
            } else {
                FileReader fr = new FileReader(xslFilePath);
                StringBuilder xslBuilder = new StringBuilder();
                BufferedReader bufr = new BufferedReader(fr);
                boolean count = true;
                String line = bufr.readLine();
                while (line != null) {
                    xslBuilder.append(line);
                    line = bufr.readLine();
                }
                bufr.close();
                xsl = xslBuilder.toString();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception while reading xsl file E12Gen [" + e.getMessage() + "]");
        }
        return xsl;
    }

    public String getObjNameWiseXSL(String objName, String callerInterface, String dataModelName) {
        String xsl = "";
        try {
            callerInterface = E12GenericUtility.checkNull(callerInterface);
            String xslFileName = "";
            String xslFilePath = "";
            if (!"".equalsIgnoreCase(callerInterface)) {
                xslFileName = E12GenericUtility.checkNull(dataModelName).length() > 0 ? (callerInterface.equalsIgnoreCase("MOBILE") ? String.valueOf(dataModelName) + "_MOBILE.xsl" : String.valueOf(dataModelName) + ".xsl") : (callerInterface.equalsIgnoreCase("MOBILE") ? String.valueOf(objName) + "_preview_MOBILE.xsl" : String.valueOf(objName) + "_preview.xsl");
            }
            xslFilePath = this.getXSLFilePath(xslFileName);
            if (callerInterface.equalsIgnoreCase("MOBILE") && xslFilePath == null) {
                xslFileName = String.valueOf(objName) + "_preview.xsl";
                xslFilePath = this.getXSLFilePath(xslFileName);
            }
            BaseLogger.log("0", null, null, "!!** Path is [" + xslFilePath + "]");
            if (xslFilePath == null) {
                xsl = "<Root></Root>";
            } else {
                FileReader fr = new FileReader(xslFilePath);
                StringBuilder xslBuilder = new StringBuilder();
                BufferedReader bufr = new BufferedReader(fr);
                boolean count = true;
                String line = bufr.readLine();
                while (line != null) {
                    xslBuilder.append(line);
                    line = bufr.readLine();
                }
                bufr.close();
                xsl = xslBuilder.toString();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception while reading xsl file E12Gen [" + e.getMessage() + "]");
        }
        return xsl;
    }

    private String getXSLFilePath(String fileName, String enterprise) {
        BaseLogger.log("2", null, null, "getXSLFileName:fileName::: " + fileName);
        BaseLogger.log("2", null, null, "getXSLFileName:Enterprise::: " + enterprise);
        String retFileName = null;
        try {
            String defaultPath = null;
            if (CommonConstants.APPLICATION_CONTEXT != null) {
                defaultPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm";
                BaseLogger.log("3", null, null, "default Application context path:" + defaultPath);
            } else {
                defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
            }
            if (!new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME).exists()) {
                new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME).mkdir();
            }
            File xslFile = new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME, fileName);
            File xslFileInEnterprise = new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME + File.separator + enterprise, fileName);
            BaseLogger.log("3", null, null, "File exists in Standard :" + xslFile.exists());
            BaseLogger.log("3", null, null, "File exists in Enterprise Folder :" + xslFileInEnterprise.exists());
            if (xslFileInEnterprise.exists()) {
                retFileName = xslFileInEnterprise.getAbsolutePath();
                BaseLogger.log("3", null, null, "File found @ " + xslFileInEnterprise.getAbsolutePath());
            } else if (xslFile.exists()) {
                retFileName = xslFile.getAbsolutePath();
                BaseLogger.log("3", null, null, "File found @ " + xslFile.getAbsolutePath());
            } else {
                BaseLogger.log("3", null, null, "File not found @ " + xslFileInEnterprise.getAbsolutePath() + " OR @ " + xslFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retFileName;
    }

    private String getXSLFilePath(String fileName) {
        BaseLogger.log("2", null, null, "getXSLFileName:fileName: " + fileName);
        String retFileName = null;
        try {
            String defaultPath = null;
            if (CommonConstants.APPLICATION_CONTEXT != null) {
                defaultPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm";
                BaseLogger.log("3", null, null, "default Application context path:" + defaultPath);
            } else {
                defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
            }
            if (!new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME).exists()) {
                new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME).mkdir();
            }
            File xslFile = new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME, fileName);
            BaseLogger.log("3", null, null, "xslFile exists :" + xslFile.exists());
            if (xslFile.exists()) {
                retFileName = xslFile.getAbsolutePath();
            } else {
                BaseLogger.log("3", null, null, "Default file not found @ " + xslFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retFileName;
    }

    public String getMetaDataFilePath(String objName, String objContext, String pageContext, String formName, HashMap<String, String> propEditorInfoMap, String transDB) {
        BaseLogger.log("2", null, null, "E12GenericUtils:getMetaDataFilePath: objName: [" + objName + "]");
        BaseLogger.log("2", null, null, "E12GenericUtils:getMetaDataFilePath: objContext: [" + objContext + "]");
        BaseLogger.log("2", null, null, "E12GenericUtils:getMetaDataFilePath: pageContext: [" + pageContext + "]");
        BaseLogger.log("2", null, null, "E12GenericUtils:getMetaDataFilePath: formName: [" + formName + "]");
        BaseLogger.log("2", null, null, "E12GenericUtils:getMetaDataFilePath: propEditorInfoMap: [" + propEditorInfoMap + "]");
        String retFilePath = null;
        ResourceModifier resModifier = null;
        ArrayList<String> enterpriseResList = new ArrayList();
        ArrayList<Object> profileResList = new ArrayList();
        String metaDataFilePath = "";
        String exportToFolderName = "";
        String mataDataDefaultPath = "";
        File metaDataFile = null;
        String metaDatafileName = "";
        String profileIdRes = "";
        String enterpriseIdRes = "";
        String profileId = "";
        String editor = "";
        try {
            metaDatafileName = formName != null && !"null".equalsIgnoreCase(formName) && formName.trim().length() > 0 ? String.valueOf(objName) + pageContext + formName : String.valueOf(objName) + pageContext + objContext;
            profileIdRes = E12GenericUtility.checkNull(propEditorInfoMap.get("PROFILE_ID_RES"));
            enterpriseIdRes = E12GenericUtility.checkNull(propEditorInfoMap.get("ENTERPRISE_ID_RES"));
            profileId = E12GenericUtility.checkNull(propEditorInfoMap.get("PROFILE_ID"));
            propEditorInfoMap.put("EDITOR", editor);
            String userId = E12GenericUtility.checkNull(propEditorInfoMap.get("USER_ID"));
            boolean tablePropFileExist = false;
            boolean prResPropFileExist = false;
            boolean entrResPropFileExist = false;
            resModifier = new ResourceModifier();
            mataDataDefaultPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator;
            if ("".equalsIgnoreCase(profileIdRes) && "".equalsIgnoreCase(enterpriseIdRes)) {
                metaDataFilePath = mataDataDefaultPath;
                tablePropFileExist = resModifier.isTablePropertiesFileExist(objName, objContext, pageContext, editor, formName, userId, profileId);
                if (tablePropFileExist) {
                    metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + profileId + File.separator + userId + File.separator;
                }
            } else {
                metaDataFilePath = "".equalsIgnoreCase(profileIdRes) && !"".equalsIgnoreCase(enterpriseIdRes) ? String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + enterpriseIdRes + File.separator + userId + File.separator : (!"".equalsIgnoreCase(profileIdRes) && "".equalsIgnoreCase(enterpriseIdRes) ? String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + profileIdRes + File.separator + userId + File.separator : String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + enterpriseIdRes + "-" + profileIdRes + File.separator + userId + File.separator);
            }
            BaseLogger.log("3", null, null, "E12GenericUtils:getMetaDataFilePath:metaDataFilePath :[" + metaDataFilePath + "]");
            metaDataFile = new File(metaDataFilePath, String.valueOf(metaDatafileName) + ".xml");
            if (!metaDataFile.exists()) {
                if (!"".equalsIgnoreCase(profileIdRes)) {
                    profileResList = resModifier.getResourcePath(profileIdRes, transDB);
                }
                if (!"".equalsIgnoreCase(enterpriseIdRes)) {
                    enterpriseResList = resModifier.getEnterpriseResPath(enterpriseIdRes, transDB);
                }
                if (profileResList.size() <= 0 && enterpriseResList.size() <= 0) {
                    metaDataFilePath = mataDataDefaultPath;
                    tablePropFileExist = resModifier.isTablePropertiesFileExist(objName, objContext, pageContext, editor, formName, userId, profileId);
                    if (tablePropFileExist) {
                        metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + profileId + File.separator + userId + File.separator;
                        exportToFolderName = userId;
                    }
                } else {
                    prResPropFileExist = resModifier.isPropertiesFileExist(profileResList, objName, objContext, pageContext, editor, formName);
                    entrResPropFileExist = resModifier.isPropertiesFileExist(enterpriseResList, objName, objContext, pageContext, editor, formName);
                    if (profileResList.size() > 0 && enterpriseResList.size() > 0 && prResPropFileExist && entrResPropFileExist) {
                        metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + enterpriseIdRes + "-" + profileIdRes + File.separator + userId + File.separator;
                        exportToFolderName = String.valueOf(enterpriseIdRes) + "-" + profileIdRes + File.separator + userId;
                    } else if (profileResList.size() > 0 && prResPropFileExist) {
                        metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + profileIdRes + File.separator + userId + File.separator;
                        exportToFolderName = String.valueOf(profileIdRes) + File.separator + userId;
                    } else if (enterpriseResList.size() > 0 && entrResPropFileExist) {
                        metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + enterpriseIdRes + File.separator + userId + File.separator;
                        exportToFolderName = String.valueOf(enterpriseIdRes) + File.separator + userId;
                    } else {
                        metaDataFilePath = mataDataDefaultPath;
                    }
                }
                if (!(metaDataFile = new File(metaDataFilePath, String.valueOf(metaDatafileName) + ".xml")).exists() && (prResPropFileExist || entrResPropFileExist || tablePropFileExist)) {
                    CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                    UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userId);
                    DWFactory dws = new DWFactory(userInfo);
                    DWObject dwObject = dws.getDataWindow(metaDatafileName);
                    String string = dwObject.exportToXML(exportToFolderName, objName, objContext, pageContext, formName, profileResList, enterpriseResList, propEditorInfoMap, transDB);
                }
                BaseLogger.log("3", null, null, "E12GenericUtils:getMetaDataFilePath:metaDataFilePath :[" + metaDataFilePath + "]");
            }
            BaseLogger.log("3", null, null, "Metadata file exists :" + metaDataFile.exists());
            if (metaDataFile.exists()) {
                retFilePath = metaDataFile.getAbsolutePath();
            } else {
                retFilePath = "";
                BaseLogger.log("3", null, null, "E12GenericUtils:getMetaDataFilePath: MetaDataFilePath not found......");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "E12GenericUtils:getMetaDataFilePath: retFilePath :[" + retFilePath + "]");
        return retFilePath;
    }

    public String getAngCompFilePath(HashMap<String, String> propEditorInfoMap, String transDB, String objName) throws ITMException {
        BaseLogger.log("2", null, null, "23012023 Inside getAngCompFilePath");
        ResourceModifier resModifier = null;
        ArrayList<Object> enterpriseResList = new ArrayList();
        ArrayList<Object> profileResList = new ArrayList();
        String xslFilePath = "";
        String xslDefaultPath = "";
        String profileIdRes = "";
        String enterpriseIdRes = "";
        String profileId = "";
        try {
            profileIdRes = E12GenericUtility.checkNull(propEditorInfoMap.get("PROFILE_ID_RES"));
            enterpriseIdRes = E12GenericUtility.checkNull(propEditorInfoMap.get("ENTERPRISE_ID_RES"));
            profileId = E12GenericUtility.checkNull(propEditorInfoMap.get("PROFILE_ID"));
            resModifier = new ResourceModifier();
            xslDefaultPath = CommonConstants.APPLICATION_CONTEXT != null ? CommonConstants.APPLICATION_CONTEXT : ".." + File.separator + "webapps" + File.separator + "ibase";
            xslDefaultPath = String.valueOf(xslDefaultPath) + File.separator + "angular" + File.separator + "components";
            if (!"".equalsIgnoreCase(profileIdRes)) {
                profileResList = resModifier.getResourcePath(profileIdRes, transDB);
            }
            if (!"".equalsIgnoreCase(enterpriseIdRes)) {
                enterpriseResList = resModifier.getEnterpriseResPath(enterpriseIdRes, transDB);
            }
            if (profileResList.size() <= 0 && enterpriseResList.size() <= 0) {
                xslFilePath = xslDefaultPath;
            } else if (profileResList.size() > 0 && enterpriseResList.size() > 0) {
                xslFilePath = String.valueOf(xslDefaultPath) + File.separator + enterpriseIdRes + "-" + profileIdRes + File.separator;
            } else if (profileResList.size() > 0) {
                xslFilePath = String.valueOf(xslDefaultPath) + File.separator + profileIdRes + File.separator;
            } else if (enterpriseResList.size() > 0) {
                xslFilePath = String.valueOf(xslDefaultPath) + File.separator + enterpriseIdRes + File.separator;
            }
            xslFilePath = String.valueOf(xslFilePath) + File.separator + objName;
            if (!new File(xslFilePath).exists()) {
                new File(xslFilePath).mkdirs();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "E12GenericUtils: getAngCompFilePath: e :[" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "E12GenericUtils: getAngCompFilePath: xslFilePath :[" + xslFilePath + "]");
        return xslFilePath;
    }

    public String getWebEditorXslPath(HashMap<String, String> propEditorInfoMap, String transDB) throws ITMException {
        ResourceModifier resModifier = null;
        ArrayList<Object> enterpriseResList = new ArrayList();
        ArrayList<Object> profileResList = new ArrayList();
        String xslFilePath = "";
        String xslDefaultPath = "";
        String profileIdRes = "";
        String enterpriseIdRes = "";
        String profileId = "";
        try {
            profileIdRes = E12GenericUtility.checkNull(propEditorInfoMap.get("PROFILE_ID_RES"));
            enterpriseIdRes = E12GenericUtility.checkNull(propEditorInfoMap.get("ENTERPRISE_ID_RES"));
            profileId = E12GenericUtility.checkNull(propEditorInfoMap.get("PROFILE_ID"));
            resModifier = new ResourceModifier();
            xslDefaultPath = CommonConstants.APPLICATION_CONTEXT != null ? String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm";
            xslDefaultPath = String.valueOf(xslDefaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME;
            if (!"".equalsIgnoreCase(profileIdRes)) {
                profileResList = resModifier.getResourcePath(profileIdRes, transDB);
            }
            if (!"".equalsIgnoreCase(enterpriseIdRes)) {
                enterpriseResList = resModifier.getEnterpriseResPath(enterpriseIdRes, transDB);
            }
            if (profileResList.size() <= 0 && enterpriseResList.size() <= 0) {
                xslFilePath = xslDefaultPath;
            } else if (profileResList.size() > 0 && enterpriseResList.size() > 0) {
                xslFilePath = String.valueOf(xslDefaultPath) + File.separator + enterpriseIdRes + "-" + profileIdRes + File.separator;
            } else if (profileResList.size() > 0) {
                xslFilePath = String.valueOf(xslDefaultPath) + File.separator + profileIdRes + File.separator;
            } else if (enterpriseResList.size() > 0) {
                xslFilePath = String.valueOf(xslDefaultPath) + File.separator + enterpriseIdRes + File.separator;
            }
            if (!new File(xslFilePath).exists()) {
                new File(xslFilePath).mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "E12GenericUtils: getWebEditorXslPath: xslFilePath :[" + xslFilePath + "]");
        return xslFilePath;
    }

    public String getErrorString(String columnName, String msgNo, String userId) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement stmt = null;
        Statement stmt1 = null;
        Statement stmt2 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String msgType = "";
        String msgString = "";
        String msgDescription = "";
        String profileId = "";
        String errSource = "";
        String tempMsgType = "";
        String msgOption = "";
        String msgTime = "";
        String redirerr = "";
        String soundPlay = "";
        try {
            try {
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("Driver");
                connDriver = null;
                String sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sqlQuery);
                if (rs.next()) {
                    msgType = rs.getString("MSG_TYPE");
                    msgString = rs.getString("MSG_STR");
                    msgDescription = rs.getString("MSG_DESCR");
                    errSource = rs.getString("ERR_SOURCE");
                    msgOption = rs.getString("MSG_OPT");
                    msgTime = rs.getString("MSG_TIME");
                    soundPlay = rs.getString("ALARM");
                } else {
                    msgDescription = "Message Id not found [" + msgNo + "]";
                    msgType = "E";
                    msgString = "";
                }
                if (msgType.equals("E") || msgType.trim().length() == 0) {
                    String sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
                    stmt1 = conn.createStatement();
                    rs1 = stmt1.executeQuery(sqlQuery1);
                    if (rs1.next()) {
                        profileId = rs1.getString("profile_id");
                        if (profileId == null) {
                            profileId = "";
                        }
                        sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND ( PROFILE_ID='" + profileId.trim() + "' OR PROFILE_ID = 'X' )";
                        stmt2 = conn.createStatement();
                        rs2 = stmt2.executeQuery(sqlQuery1);
                        if (rs2.next()) {
                            tempMsgType = rs2.getString("msg_type");
                        }
                        rs2.close();
                    }
                    rs1.close();
                    if (tempMsgType != null && tempMsgType.trim().length() > 0) {
                        msgType = tempMsgType;
                    }
                }
                if (msgType.equals("W")) {
                    msgString = "Warning : " + msgString;
                } else if (msgType.equals("P")) {
                    msgString = "Prompt : " + msgString;
                } else if (msgType.equals("F")) {
                    msgString = "Information : " + msgString;
                } else {
                    msgType = "E";
                    msgString = "Error : " + msgString;
                }
                if (errSource != null && errSource.trim().equals("D")) {
                    msgDescription = String.valueOf(msgDescription) + " * From Database ";
                }
                if (redirerr == null || redirerr.trim().length() == 0) {
                    redirerr = "1";
                }
                if (msgOption != null && msgOption.trim().equals("M")) {
                    redirerr = redirerr.trim().equals("1") ? "2" : "1";
                }
                if (rs != null) {
                    rs.close();
                    stmt.close();
                }
                if (rs1 != null) {
                    rs1.close();
                    stmt1.close();
                }
                if (rs2 != null) {
                    rs2.close();
                    stmt2.close();
                }
                conn.close();
            }
            catch (ITMException itme) {
                BaseLogger.log("0", null, null, "ITMException : [E12GenericUtility][getErrorString] :==>\n" + itme.getMessage());
                throw itme;
            }
            catch (SQLException se) {
                msgDescription = se.getMessage();
                msgType = "";
                msgString = "";
                BaseLogger.log("0", null, null, "Exception : [E12GenericUtility][getErrorString] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : [E12GenericUtility][getErrorString] :==>\n" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        StringBuffer errStringXml = new StringBuffer();
        errStringXml.append(this.getErrorString(msgNo, msgType, columnName, msgString, msgDescription, msgString, msgOption, msgTime, soundPlay, errSource, redirerr));
        return errStringXml.toString();
    }

    public String getErrorString(String columnName, String messageValue, String message, String errorId) {
        return this.getErrorString(columnName, messageValue, message, errorId, "Error : NO DATA");
    }

    public String getXmlTag(String xmlData, String objContext, String domID) throws ITMException {
        StringBuffer tabSepDataBuff = new StringBuffer();
        Node detailNode = null;
        NodeList detailNodeList = null;
        try {
            try {
                detailNode = this.searchNode(this.parseString(xmlData), objContext, domID);
                if (detailNode != null && detailNode.getNodeType() == 1 && detailNode.getNodeName().startsWith("Detail")) {
                    detailNodeList = detailNode.getChildNodes();
                    int detailNodeListLen = detailNodeList.getLength();
                    int i = 0;
                    while (i < detailNodeListLen) {
                        Node childNode = detailNodeList.item(i);
                        String tagVlaue = childNode.getNodeName();
                        if (childNode != null && childNode.getNodeType() == 1 && !childNode.getNodeName().equalsIgnoreCase("attribute") && !childNode.getNodeName().equalsIgnoreCase("DB_ID")) {
                            tabSepDataBuff.append(tagVlaue);
                            tagVlaue = null;
                            if (i > 0 && i != detailNodeListLen) {
                                tabSepDataBuff.append("\t");
                            }
                        }
                        childNode = null;
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : [GenericUtility][ generateTabSeparatedData ]4395 :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            detailNode = null;
            detailNodeList = null;
        }
        return tabSepDataBuff.toString();
    }

    public String TabSeparatedDataForAllFormData(String xmlData, String objContext, String domID) throws ITMException {
        StringBuffer tabSepDataBuff = new StringBuffer();
        Node detailNode = null;
        NodeList detailNodeList = null;
        NodeList detailList = null;
        try {
            try {
                Document dom = this.parseString(xmlData);
                detailList = dom.getElementsByTagName("Detail" + objContext);
                int detListLength = detailList.getLength();
                int documentId = Integer.parseInt(domID);
                BaseLogger.log("3", null, null, "inside TabSeparatedDataForAllFormData domid[" + domID + "]detListLength[" + detListLength + "] documentId[" + documentId + "]");
                int k = 1;
                while (k <= detListLength) {
                    domID = String.valueOf(documentId);
                    detailNode = this.searchNode(this.parseString(xmlData), objContext, domID);
                    if (detailNode != null && detailNode.getNodeType() == 1 && detailNode.getNodeName().startsWith("Detail")) {
                        detailNodeList = detailNode.getChildNodes();
                        int detailNodeListLen = detailNodeList.getLength();
                        int i = 0;
                        while (i < detailNodeListLen) {
                            Node childNode = detailNodeList.item(i);
                            if (childNode != null && childNode.getNodeType() == 1 && !childNode.getNodeName().equalsIgnoreCase("attribute") && !childNode.getNodeName().equalsIgnoreCase("DB_ID")) {
                                String nodeVal = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : "";
                                tabSepDataBuff.append(nodeVal);
                                nodeVal = null;
                                if (i > 0 && i != detailNodeListLen) {
                                    tabSepDataBuff.append("\t");
                                }
                            }
                            childNode = null;
                            ++i;
                        }
                    }
                    ++documentId;
                    tabSepDataBuff.append("\r\n");
                    ++k;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : [GenericUtility][ generateTabSeparatedData ]4459 :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            detailNode = null;
            detailNodeList = null;
        }
        return tabSepDataBuff.toString();
    }

    public static String getFormattedProfileId(String profileID) {
        StringBuffer profileIdSql = new StringBuffer();
        try {
            profileID = E12GenericUtility.checkNull(profileID);
            BaseLogger.log("3", null, null, "@@@ getFormattedProfileId profileID:::[" + profileID + "]");
            if (profileID.length() > 0 && profileID.contains(",")) {
                profileIdSql.append("(");
                String[] pArr = profileID.split(",");
                int i = 0;
                while (i < pArr.length) {
                    if (i == pArr.length - 1) {
                        profileIdSql.append("'" + pArr[i] + "'");
                    } else {
                        profileIdSql.append("'" + pArr[i] + "',");
                    }
                    ++i;
                }
                profileIdSql.append(")");
            } else {
                profileIdSql.append("('" + profileID + "')");
            }
            BaseLogger.log("3", null, null, "@@@ getFormattedProfileId profileIdSql:::[" + profileIdSql.toString() + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : [E12GenericUtility][getFormattedProfileId] :==>\n" + e.getMessage());
            e.printStackTrace();
        }
        return profileIdSql.toString();
    }

    public String isPromptOrWarningMsg(String errXmlString) {
        NodeList errorNodeList = null;
        String errorType = "";
        boolean isPrompt = false;
        try {
            if (errXmlString.indexOf("<Errors>") != -1) {
                errorNodeList = this.parseString(errXmlString).getElementsByTagName("error");
                int errorNodeListLen = errorNodeList.getLength();
                int i = 0;
                while (i < errorNodeListLen) {
                    errorType = errorNodeList.item(i).getAttributes().getNamedItem("type").getNodeValue();
                    if ("P".equals(errorType) || "W".equals(errorType)) {
                        isPrompt = true;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!isPrompt) {
            errorType = "";
        }
        BaseLogger.log("2", null, null, "inside isPromptMsg...2128 errorType[" + errorType + "]");
        return errorType;
    }

    public String appendErrorXMLString(String errorXML, String detailString) throws ITMException {
        String retString = "";
        try {
            if (errorXML.length() > 0 && detailString.length() > 0) {
                Document doc = this.parseString(errorXML);
                Node errorNode = doc.getElementsByTagName("Errors").item(0);
                Document detailDom = this.parseString(detailString);
                Node rootNode = detailDom.getElementsByTagName("Root").item(0);
                if (rootNode != null) {
                    NodeList list = rootNode.getChildNodes();
                    BaseLogger.log("3", null, null, "In appendErrorXMLString method list :: 4624!!!!!![" + list.getLength() + "]");
                    Node childNode = list.item(1);
                    rootNode.insertBefore(detailDom.importNode(errorNode, true), childNode);
                    BaseLogger.log("3", null, null, "child Node 4634!!!");
                }
                retString = E12GenericUtility.checkNull(this.serializeDom(detailDom));
                BaseLogger.log("3", null, null, "In appendErrorXMLString method retString :: 4638!!!!!![" + retString.length() + "]");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception when taking error node {" + e.getMessage() + "}");
            throw new ITMException(e);
        }
        return retString;
    }

    public String updateDataHeader(String chgStr, String chgAttributeValue, String chgAttributeName) throws ITMException {
        String returnChgStr = "";
        if (!"".equalsIgnoreCase(chgStr = E12GenericUtility.checkNull(chgStr))) {
            Document doc = this.parseString(chgStr);
            Node headerNode = doc.getElementsByTagName("header").item(0);
            if (headerNode != null) {
                NodeList detailNodeList = headerNode.getChildNodes();
                int headerNodeLen = detailNodeList.getLength();
                int i = 0;
                while (i < headerNodeLen) {
                    Node curDetail = detailNodeList.item(i);
                    if (chgAttributeName.equals(curDetail.getNodeName())) {
                        if (curDetail.getFirstChild().getNodeValue() == null) break;
                        curDetail.getFirstChild().setNodeValue(chgAttributeValue);
                        break;
                    }
                    ++i;
                }
            }
            returnChgStr = this.serializeDom(doc);
        }
        return returnChgStr;
    }

    public String getCustomImageURL(String objName, String object, String fldValue, String altFldValue, String docAttachType) {
        StringBuffer imageURL = new StringBuffer();
        imageURL.append(CommonConstants.TOMCAT_HOME);
        imageURL.append("/ibase/CustomMenuImageServlet?");
        imageURL.append("fldValue=").append(E12GenericUtility.checkNull(fldValue));
        imageURL.append("&ALT_FLD_VALUE=").append(E12GenericUtility.checkNull(altFldValue));
        imageURL.append("&objName=").append(E12GenericUtility.checkNull(objName));
        imageURL.append("&object=").append(E12GenericUtility.checkNull(object));
        imageURL.append("&docAttachType=").append(E12GenericUtility.checkNull(docAttachType));
        BaseLogger.log("2", null, null, "E12GenericUtility.getCustomImageURL :[" + imageURL.toString() + "]");
        return imageURL.toString();
    }

    public static String getSysdate() {
        String sysdateStr = "";
        sysdateStr = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) ? " current timestamp " : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? " getdate() " : ("mysql".equalsIgnoreCase(CommonConstants.DB_NAME) ? " DATE(CURRENT_TIMESTAMP) " : " sysdate "));
        return sysdateStr;
    }

    public Node applyItemchangeData(String itemchangeData, Node currDataDoc, String formNo, HashMap<String, String> copyDataMap, HashMap<String, String> tabOrderWiseLogicalNameMap) throws ITMException {
        int totalDetailNodes;
        BaseLogger.log("2", null, null, "inside applyItemchangeData start");
        Document doc = this.parseString(itemchangeData);
        Document temDocument = currDataDoc.getOwnerDocument();
        Node tempNode = temDocument.getElementsByTagName("Detail" + formNo).item(0);
        if (tempNode == null) {
            tempNode = temDocument.getElementsByTagName("Detail").item(0);
        }
        if ((totalDetailNodes = doc.getElementsByTagName("Detail" + formNo).getLength()) == 0) {
            totalDetailNodes = doc.getElementsByTagName("Detail").getLength();
        }
        Node currDetailNode = null;
        currDetailNode = currDataDoc;
        Node appendNode = null;
        if (totalDetailNodes > 0) {
            int j = 0;
            while (j < totalDetailNodes) {
                Node detailNode = doc.getElementsByTagName("Detail" + formNo).item(j);
                if (detailNode == null) {
                    detailNode = doc.getElementsByTagName("Detail").item(j);
                }
                if (detailNode != null) {
                    NodeList detailNodeList = detailNode.getChildNodes();
                    int detailLength = detailNodeList.getLength();
                    int k = 0;
                    while (k < detailLength) {
                        Node curitemchangeDetail = detailNodeList.item(k);
                        if (curitemchangeDetail != null && curitemchangeDetail.getNodeType() == 1) {
                            appendNode = curitemchangeDetail;
                            String nodename = E12GenericUtility.checkNull(curitemchangeDetail.getNodeName());
                            String nodeValue = E12GenericUtility.checkNull(curitemchangeDetail.getTextContent());
                            boolean isnodeExist = this.isNodeExist(nodename, formNo, currDataDoc);
                            if (currDetailNode != null && isnodeExist) {
                                NodeList currDetailNodeList = currDetailNode.getChildNodes();
                                int currDetailLength = currDetailNodeList.getLength();
                                int m = 0;
                                while (m < currDetailLength) {
                                    Node curData;
                                    Node replaceNode = curData = currDetailNodeList.item(m);
                                    String currNodename = curData.getNodeName();
                                    if (nodename.equalsIgnoreCase(currNodename) && !"".equalsIgnoreCase(nodeValue) && !"#text".equals(nodename) && !"attribute".equalsIgnoreCase(nodename)) {
                                        boolean iscpoyData = copyDataMap.containsKey(nodename);
                                        if (iscpoyData) {
                                            for (Map.Entry<String, String> entry : copyDataMap.entrySet()) {
                                                String copyDataNodeName = entry.getKey();
                                                String copyDataNodeValue = entry.getValue();
                                                if (nodename.equalsIgnoreCase(copyDataNodeName) && !"".equalsIgnoreCase(nodeValue) && !"".equalsIgnoreCase(copyDataNodeValue) && tabOrderWiseLogicalNameMap.containsKey(copyDataNodeName)) {
                                                    if (replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null) {
                                                        replaceNode.getFirstChild().setNodeValue(copyDataNodeValue);
                                                        continue;
                                                    }
                                                    replaceNode.setTextContent(copyDataNodeValue);
                                                    continue;
                                                }
                                                if (replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null) {
                                                    replaceNode.getFirstChild().setNodeValue(nodeValue);
                                                    continue;
                                                }
                                                replaceNode.setTextContent(nodeValue);
                                            }
                                        } else if (replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null) {
                                            replaceNode.getFirstChild().setNodeValue(nodeValue);
                                        } else {
                                            replaceNode.setTextContent(nodeValue);
                                        }
                                        currDetailNode.replaceChild(replaceNode, curData);
                                        break;
                                    }
                                    ++m;
                                }
                            } else if (!"#text".equals(nodename) && !"attribute".equalsIgnoreCase(nodename)) {
                                Element tempEle = temDocument.createElement(nodename);
                                tempEle.appendChild(temDocument.createCDATASection(nodeValue));
                                tempNode.appendChild(tempEle);
                                currDetailNode = tempNode;
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        BaseLogger.log("2", null, null, "inside applyItemchangeData start[" + this.serializeDom(currDetailNode) + "]");
        return currDetailNode;
    }

    public boolean isNodeExist(String colName, String formNo, Node DetailNode) throws ITMException {
        boolean isColumn;
        block7: {
            BaseLogger.log("2", null, null, "inside isNodeExist start");
            isColumn = false;
            NodeList currDetailNodeList = null;
            try {
                try {
                    if (DetailNode == null) break block7;
                    currDetailNodeList = DetailNode.getChildNodes();
                    int detailLength = currDetailNodeList.getLength();
                    int i = 0;
                    while (i < detailLength) {
                        Node childNode = currDetailNodeList.item(i);
                        if (childNode != null && childNode.getNodeType() == 1 && childNode.getNodeName().equalsIgnoreCase(colName)) {
                            isColumn = true;
                            childNode = null;
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : [GenericUtility][getColumnValue(2)] 5057 :==>\n" + e.getMessage());
                    throw new ITMException(e);
                }
            }
            finally {
                DetailNode = null;
                currDetailNodeList = null;
            }
        }
        BaseLogger.log("2", null, null, "inside isNodeExist end isColumn[" + isColumn + "]");
        return isColumn;
    }

    public Document applyItemchangeDataOnDetail(String itemchangeData, Document detailDom, String formNo, String DomID, HashMap<String, String> copyDataMap, HashMap<String, String> tabOrderWiseLogicalNameMap) throws ITMException {
        BaseLogger.log("2", null, null, "inside applyItemchangeDataOnDetail start.");
        Document doc = this.parseString(itemchangeData);
        int currDomId = Integer.parseInt(DomID);
        Document temDocument = detailDom;
        Node tempNode = null;
        int totalDetailNodes = doc.getElementsByTagName("Detail" + formNo).getLength();
        if (totalDetailNodes == 0) {
            totalDetailNodes = doc.getElementsByTagName("Detail").getLength();
        }
        int cuurtotalDetailNodes = detailDom.getElementsByTagName("Detail" + formNo).getLength();
        int i = 0;
        while (i < cuurtotalDetailNodes) {
            String currentNewDomId;
            Node currNode = detailDom.getElementsByTagName("Detail" + formNo).item(i);
            if (currNode != null && (currentNewDomId = currNode.getAttributes().getNamedItem("domID").getNodeValue()).equalsIgnoreCase(DomID)) {
                tempNode = currNode;
            }
            ++i;
        }
        Node currDetailNode = null;
        if (totalDetailNodes > 0) {
            int j = 0;
            while (j < totalDetailNodes) {
                Node detailNode = doc.getElementsByTagName("Detail" + formNo).item(j);
                if (detailNode == null) {
                    detailNode = doc.getElementsByTagName("Detail").item(j);
                }
                if (detailNode != null) {
                    NodeList detailNodeList = detailNode.getChildNodes();
                    int detailLength = detailNodeList.getLength();
                    int k = 0;
                    while (k < detailLength) {
                        Node curitemchangeDetail = detailNodeList.item(k);
                        if (curitemchangeDetail != null && curitemchangeDetail.getNodeType() == 1) {
                            String nodename = curitemchangeDetail.getNodeName();
                            String nodeValue = curitemchangeDetail.getTextContent();
                            if (cuurtotalDetailNodes > 0) {
                                int detilLen = detailDom.getElementsByTagName("Detail" + formNo).getLength();
                                int i2 = 0;
                                while (i2 < detilLen) {
                                    if (detailDom.getElementsByTagName("Detail" + formNo).item(i2).getAttributes().getNamedItem("domID") != null) {
                                        String cuurRecordDomId = E12GenericUtility.checkNull(detailDom.getElementsByTagName("Detail" + formNo).item(i2).getAttributes().getNamedItem("domID").getNodeValue().toString());
                                        BaseLogger.log("2", null, null, "inside applyItemchnageon detail.......5060[" + cuurRecordDomId + "]DomID[" + DomID + "]");
                                        if (DomID.equalsIgnoreCase(cuurRecordDomId)) {
                                            currDetailNode = detailDom.getElementsByTagName("Detail" + formNo).item(i2);
                                        }
                                    }
                                    ++i2;
                                }
                                boolean isnodeExist = this.isNodeExist(nodename, formNo, currDetailNode);
                                if (currDetailNode != null && isnodeExist) {
                                    NodeList currDetailNodeList = currDetailNode.getChildNodes();
                                    int currDetailLength = currDetailNodeList.getLength();
                                    int m = 0;
                                    while (m < currDetailLength) {
                                        Node curData = currDetailNodeList.item(m);
                                        Node replaceNode = curData.cloneNode(true);
                                        String currNodename = curData.getNodeName();
                                        if (nodename.equalsIgnoreCase(currNodename) && !"".equalsIgnoreCase(nodeValue) && !"#text".equals(nodename) && !"attribute".equalsIgnoreCase(nodename)) {
                                            boolean iscpoyData = copyDataMap.containsKey(nodename);
                                            if (iscpoyData) {
                                                for (Map.Entry<String, String> entry : copyDataMap.entrySet()) {
                                                    String copyDataNodeName = entry.getKey();
                                                    String copyDataNodeValue = entry.getValue();
                                                    if (nodename.equalsIgnoreCase(copyDataNodeName) && !"".equalsIgnoreCase(nodeValue) && tabOrderWiseLogicalNameMap.containsKey(copyDataNodeName)) {
                                                        if (replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null) {
                                                            replaceNode.getFirstChild().setNodeValue(copyDataNodeValue);
                                                            continue;
                                                        }
                                                        replaceNode.setTextContent(copyDataNodeValue);
                                                        continue;
                                                    }
                                                    if (replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null) {
                                                        replaceNode.getFirstChild().setNodeValue(nodeValue);
                                                        continue;
                                                    }
                                                    replaceNode.setTextContent(nodeValue);
                                                }
                                            } else if (replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null) {
                                                replaceNode.getFirstChild().setNodeValue(nodeValue);
                                            } else {
                                                replaceNode.setTextContent(nodeValue);
                                            }
                                            currDetailNode.replaceChild(replaceNode, curData);
                                            break;
                                        }
                                        ++m;
                                    }
                                } else if (!"#text".equals(nodename) && !"attribute".equalsIgnoreCase(nodename)) {
                                    Element tempEle = temDocument.createElement(nodename);
                                    tempEle.appendChild(temDocument.createCDATASection(nodeValue));
                                    tempNode.appendChild(tempEle);
                                    currDetailNode = tempNode;
                                }
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        BaseLogger.log("2", null, null, "inside applyItemchangeDataOnDetail end[" + this.serializeDom(detailDom) + "]");
        return detailDom;
    }

    public Node copyDataOnBalnkDom(String copyData, String blankDomData, String childObjCtx, HashMap<String, String> copyDataMap, HashMap<String, String> tabOrderWiseLogicalNameMap, ArrayList primaryKeyMap) throws ITMException {
        BaseLogger.log("2", null, null, "inside copyDataOnBalnkDom start");
        Document blankDataDom = this.parseString(blankDomData);
        int totalNode = blankDataDom.getElementsByTagName("Detail" + childObjCtx).getLength();
        Node detailNode = null;
        Document copyDataDom = this.parseString(copyData);
        int totalCopyData = copyDataDom.getElementsByTagName("Detail" + childObjCtx).getLength();
        Node appendNode = null;
        if (totalNode > 0) {
            int i = 0;
            while (i < totalNode) {
                detailNode = blankDataDom.getElementsByTagName("Detail" + childObjCtx).item(i);
                if (detailNode != null) {
                    NodeList detailNodeList = detailNode.getChildNodes();
                    int detailLength = detailNodeList.getLength();
                    int k = 0;
                    while (k < detailLength) {
                        Node cuurentBlnkDetail;
                        appendNode = cuurentBlnkDetail = detailNodeList.item(k);
                        if (cuurentBlnkDetail != null && cuurentBlnkDetail.getNodeType() == 1) {
                            String nodename = E12GenericUtility.checkNull(cuurentBlnkDetail.getNodeName());
                            String nodeValue = E12GenericUtility.checkNull(cuurentBlnkDetail.getTextContent());
                            int j = 0;
                            while (j < totalCopyData) {
                                Node copyDetailNode = copyDataDom.getElementsByTagName("Detail" + childObjCtx).item(j);
                                NodeList copyDeatiNodeList = copyDetailNode.getChildNodes();
                                int copyDetailLen = copyDeatiNodeList.getLength();
                                int l = 0;
                                while (l < copyDetailLen) {
                                    Node currCopyDetail = copyDeatiNodeList.item(l);
                                    if (currCopyDetail != null && currCopyDetail.getNodeType() == 1) {
                                        String curCopyNodeName = E12GenericUtility.checkNull(currCopyDetail.getNodeName());
                                        String curCopyNodeValue = E12GenericUtility.checkNull(currCopyDetail.getTextContent());
                                        if (nodename.equalsIgnoreCase(curCopyNodeName) && tabOrderWiseLogicalNameMap.containsKey(curCopyNodeName) && !"".equalsIgnoreCase(curCopyNodeValue) || !"".equalsIgnoreCase(curCopyNodeName) && primaryKeyMap.contains(curCopyNodeName) && nodename.equalsIgnoreCase(curCopyNodeName)) {
                                            if (cuurentBlnkDetail.getFirstChild() != null && cuurentBlnkDetail.getFirstChild().getNodeValue() != null) {
                                                cuurentBlnkDetail.getFirstChild().setNodeValue(curCopyNodeValue);
                                            } else {
                                                cuurentBlnkDetail.setTextContent(curCopyNodeValue);
                                            }
                                        }
                                    }
                                    ++l;
                                }
                                ++j;
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        BaseLogger.log("2", null, null, "inside copyDataOnBalnkDom end[" + this.serializeDom(detailNode) + "]");
        return detailNode;
    }

    public String getValueFromJson(JSONObject responseJson, String tagNamePath, String tagName) throws ITMException {
        String jsonValue = null;
        try {
            ArrayList<String> tagNamePathList = new ArrayList<String>(Arrays.asList(tagNamePath.split("\\s*:\\s*")));
            int tagNamePathListSize = tagNamePathList.size();
            JSONObject childJson = responseJson;
            int childCnt = 0;
            while (childCnt < tagNamePathListSize) {
                childJson = childJson.getJSONObject(tagNamePathList.get(childCnt));
                ++childCnt;
            }
            jsonValue = (String)childJson.get(tagName);
        }
        catch (JSONException e) {
            BaseLogger.log("0", null, null, "getValueFromJson : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException((Exception)((Object)e));
        }
        return jsonValue;
    }

    public void updateValueInJson(JSONObject responseJson, String tagNamePath, String tagName, String updateValue) throws ITMException {
        try {
            ArrayList<String> tagNamePathList = new ArrayList<String>(Arrays.asList(tagNamePath.split("\\s*:\\s*")));
            int tagNamePathListSize = tagNamePathList.size();
            JSONObject childJson = responseJson;
            int childCnt = 0;
            while (childCnt < tagNamePathListSize) {
                childJson = childJson.getJSONObject(tagNamePathList.get(childCnt));
                ++childCnt;
            }
            childJson.put(tagName, (Object)updateValue);
        }
        catch (JSONException e) {
            BaseLogger.log("0", null, null, "updateValueInJson : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException((Exception)((Object)e));
        }
    }

    public String getErrorString(String response) {
        String errorStr = "";
        String msgStr = "";
        String descrStr = "";
        String traceStr = "";
        try {
            Document document = this.parseString(response);
            if (document != null) {
                Node errorNode = document.getElementsByTagName("error").item(0);
                if (errorNode != null && errorNode.getNodeType() == 1) {
                    BaseLogger.log("2", null, null, "errorNode:[" + this.serializeDom(errorNode) + "]");
                    NodeList childNodeList = errorNode.getChildNodes();
                    int len = childNodeList.getLength();
                    int i = 0;
                    while (i < len) {
                        Node childNode = childNodeList.item(i);
                        if (childNode != null && childNode.getNodeType() == 1) {
                            String nodeName = E12GenericUtility.checkNull(childNode.getNodeName());
                            BaseLogger.log("3", null, null, "NodeName:[" + nodeName + "]");
                            String nodeValue = "";
                            if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null) {
                                nodeValue = childNode.getFirstChild().getNodeValue();
                            }
                            BaseLogger.log("3", null, null, "NodeValue:[" + nodeValue + "]");
                            if ("message".equals(nodeName)) {
                                msgStr = nodeValue;
                            } else if ("description".equals(nodeName)) {
                                descrStr = nodeValue;
                            } else if ("trace".equals(nodeName)) {
                                traceStr = nodeValue;
                            }
                        }
                        ++i;
                    }
                }
                errorStr = String.valueOf(msgStr) + " " + descrStr + " " + traceStr;
            }
        }
        catch (ITMException e) {
            BaseLogger.log("0", null, null, "E12GenericUtility getErrorString():[" + e + "]");
            e.printStackTrace();
        }
        return errorStr;
    }

    public Document applyPostSaveDataOnDetail(String postSaveData, Document detailDom, int noOfForms) throws ITMException {
        BaseLogger.log("2", null, null, "Inside applyPostSaveDataOnDetail noOfForms:[" + noOfForms + "]");
        BaseLogger.log("2", null, null, "Inside applyPostSaveDataOnDetail postSaveData:[" + postSaveData + "]");
        postSaveData = E12GenericUtility.checkNull(postSaveData);
        if (postSaveData.length() > 0) {
            BaseLogger.log("3", null, null, "Inside applyPostSaveDataOnDetail detailDom before update:[" + this.serializeDom(detailDom) + "]");
            try {
                Document postSavedocument = this.parseString(postSaveData);
                Document temDocument = detailDom;
                int i = 1;
                while (i <= noOfForms) {
                    NodeList nodeList;
                    int len;
                    if (postSavedocument != null && (len = (nodeList = postSavedocument.getElementsByTagName("Detail" + i)).getLength()) > 0) {
                        int j = 0;
                        while (j < len) {
                            Node detailNode = nodeList.item(j);
                            if (detailNode != null && detailNode.getNodeType() == 1) {
                                String domID = "";
                                if (i == 1) {
                                    domID = "1";
                                } else if (detailNode.getAttributes() != null && detailNode.getAttributes().getNamedItem("domID") != null) {
                                    domID = E12GenericUtility.checkNull(detailNode.getAttributes().getNamedItem("domID").getNodeValue().toString());
                                }
                                BaseLogger.log("3", null, null, "domID:[" + domID + "]");
                                NodeList detailNodeList = detailNode.getChildNodes();
                                int detailNodeListLen = detailNodeList.getLength();
                                int k = 0;
                                while (k < detailNodeListLen) {
                                    Node childNode = detailNodeList.item(k);
                                    if (childNode != null && childNode.getNodeType() == 1) {
                                        String nodeName = E12GenericUtility.checkNull(childNode.getNodeName());
                                        BaseLogger.log("3", null, null, "NodeName:[" + nodeName + "]");
                                        if (!"#text".equals(nodeName) && !"attribute".equalsIgnoreCase(nodeName)) {
                                            String nodeValue = "";
                                            if (childNode != null && childNode.getFirstChild() != null) {
                                                nodeValue = E12GenericUtility.checkNull(childNode.getFirstChild().getNodeValue());
                                            }
                                            NodeList currDetailNodeList = detailDom.getElementsByTagName("Detail" + i);
                                            int currDetailListLen = currDetailNodeList.getLength();
                                            int l = 0;
                                            while (l < currDetailListLen) {
                                                Node currDetailNode;
                                                Node tempNode = currDetailNode = currDetailNodeList.item(l);
                                                String currDomID = "";
                                                if (currDetailNode != null && currDetailNode.getNodeType() == 1) {
                                                    if (currDetailNode.getAttributes() != null && currDetailNode.getAttributes().getNamedItem("domID") != null) {
                                                        currDomID = E12GenericUtility.checkNull(currDetailNode.getAttributes().getNamedItem("domID").getNodeValue().toString());
                                                    }
                                                    BaseLogger.log("3", null, null, "currDomID:[" + currDomID + "]");
                                                    if (domID.equals(currDomID)) {
                                                        boolean isNodeExist = this.isNodeExist(nodeName, "", currDetailNode);
                                                        if (currDetailNode != null && isNodeExist) {
                                                            NodeList currDetailChildNodeList = currDetailNode.getChildNodes();
                                                            int currDetailLength = currDetailChildNodeList.getLength();
                                                            int m = 0;
                                                            while (m < currDetailLength) {
                                                                Node currChildNode = currDetailChildNodeList.item(m);
                                                                Node replaceNode = currChildNode.cloneNode(true);
                                                                String currNodeName = E12GenericUtility.checkNull(currChildNode.getNodeName());
                                                                BaseLogger.log("3", null, null, "CurrNodeName:[" + nodeName + "]");
                                                                if (nodeName.equalsIgnoreCase(currNodeName) && !"#text".equals(nodeName) && !"attribute".equalsIgnoreCase(nodeName)) {
                                                                    BaseLogger.log("3", null, null, "New NodeValue:[" + nodeValue + "]");
                                                                    String currNodeValue = "";
                                                                    if (currChildNode != null && currChildNode.getFirstChild() != null) {
                                                                        currNodeValue = E12GenericUtility.checkNull(currChildNode.getFirstChild().getNodeValue());
                                                                    }
                                                                    BaseLogger.log("3", null, null, "Old NodeValue:[" + currNodeValue + "]");
                                                                    if (replaceNode.getFirstChild() != null && replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null) {
                                                                        replaceNode.getFirstChild().setNodeValue(nodeValue);
                                                                    } else {
                                                                        replaceNode.setTextContent(nodeValue);
                                                                    }
                                                                    currDetailNode.replaceChild(replaceNode, currChildNode);
                                                                    break;
                                                                }
                                                                ++m;
                                                            }
                                                        } else if (!"#text".equals(nodeName) && !"attribute".equalsIgnoreCase(nodeName)) {
                                                            Element tempEle = temDocument.createElement(nodeName);
                                                            tempEle.appendChild(temDocument.createCDATASection(nodeValue));
                                                            tempNode.appendChild(tempEle);
                                                            currDetailNode = tempNode;
                                                        }
                                                    }
                                                } else {
                                                    BaseLogger.log("3", null, null, "DomId not match");
                                                }
                                                ++l;
                                            }
                                        }
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in applyPostSaveDataOnDetail:[" + e + "]");
                e.printStackTrace();
                throw new ITMException(e);
            }
            BaseLogger.log("3", null, null, "Inside applyPostSaveDataOnDetail end updated detailDom:[" + this.serializeDom(detailDom) + "]");
        }
        return detailDom;
    }

    public String getErrorString(String columnName, String msgDescr, String message, String msgNo, String trace) {
        return this.getErrorString(msgNo, "", columnName, message, msgDescr, trace, "", "", "", "", "");
    }

    public String getErrorString(String msgNo, String msgType, String columnName, String message, String msgDescr, String trace) {
        return this.getErrorString(msgNo, msgType, columnName, message, msgDescr, trace, "", "", "", "", "");
    }

    public String getErrorString(String msgNo, String msgType, String columnName, String message, String msgDescr, String trace, String msgOption, String msgTime, String soundPlay, String errSource, String redirErr) {
        String errString = "";
        try {
            columnName = E12GenericUtility.checkNull(columnName);
            if (columnName.length() == 0) {
                columnName = "description";
            }
            if ((msgType = E12GenericUtility.checkNull(msgType)).length() == 0) {
                msgType = "E";
            }
            msgOption = E12GenericUtility.checkNull(msgOption);
            msgTime = E12GenericUtility.checkNull(msgTime);
            soundPlay = E12GenericUtility.checkNull(soundPlay);
            errSource = E12GenericUtility.checkNull(errSource);
            if ((redirErr = E12GenericUtility.checkNull(redirErr)).length() == 0) {
                redirErr = "1";
            }
            StringBuffer valueXmlErrorString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Errors>\r\n");
            valueXmlErrorString.append("<error id=\"").append(msgNo).append("\" type=\"").append(msgType).append("\" column_name=\"").append(columnName).append("\" >\r\n");
            valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
            valueXmlErrorString.append("<description><![CDATA[").append(msgDescr).append("]]></description>\r\n");
            valueXmlErrorString.append("<type><![CDATA[").append(msgType).append("]]></type>\r\n");
            if (msgOption.length() > 0) {
                valueXmlErrorString.append("<option><![CDATA[").append(msgOption).append("]]></option>\r\n");
            }
            if (msgTime.length() > 0) {
                valueXmlErrorString.append("<time><![CDATA[").append(msgTime).append("]]></time>\r\n");
            }
            if (soundPlay.length() > 0) {
                valueXmlErrorString.append("<alarm><![CDATA[").append(soundPlay).append("]]></alarm>\r\n");
            }
            if (errSource.length() > 0) {
                valueXmlErrorString.append("<source><![CDATA[").append(errSource).append("]]></source>\r\n");
            }
            valueXmlErrorString.append("<trace><![CDATA[").append(trace).append("]]></trace>\r\n");
            valueXmlErrorString.append("<redirect><![CDATA[").append(redirErr).append("]]></redirect>\r\n");
            valueXmlErrorString.append("</error>\r\n");
            valueXmlErrorString.append("</Errors>\r\n");
            valueXmlErrorString.append("</Root>");
            errString = valueXmlErrorString.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        BaseLogger.log("3", null, null, "getErrorString :: errString : [" + errString + "]");
        return errString;
    }

    public static String getStackTrace(Exception ex) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elements = ex.getStackTrace();
        sb.append(String.valueOf(ex.getClass().getSimpleName()) + " : " + ex.getMessage() + "\n");
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append("\nat " + element.toString());
            ++n2;
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elements = ex.getStackTrace();
        sb.append(String.valueOf(ex.getClass().getSimpleName()) + " : " + ex.getMessage() + "\n");
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append("\nat " + element.toString());
            ++n2;
        }
        return sb.toString();
    }

    public String getCamelCaseStr(String inputStr) {
        StringBuilder camelCaseStr = new StringBuilder(inputStr);
        boolean isLastSpace = true;
        int i = 0;
        while (i < camelCaseStr.length()) {
            char ch = camelCaseStr.charAt(i);
            if (isLastSpace && ch >= 'a' && ch <= 'z') {
                camelCaseStr.setCharAt(i, (char)(ch + -32));
                isLastSpace = false;
            } else {
                isLastSpace = ch == ' ';
            }
            ++i;
        }
        return camelCaseStr.toString();
    }

    public static String checkJsonObjectNull(Object input) {
        if (!JSONObject.NULL.equals(input)) {
            return input.toString();
        }
        return "";
    }

    public String getErrorXmlToJsonString(String errCode, String messageType, String errMsg, String errorDescr, String errorTrace) {
        String gException = "";
        try {
            JSONObject errorDataJson = new JSONObject();
            errorDataJson.put("@id", (Object)errCode);
            errorDataJson.put("@type", (Object)messageType);
            errorDataJson.put("message", (Object)errMsg);
            errorDataJson.put("description", (Object)errorDescr);
            errorDataJson.put("type", (Object)messageType);
            errorDataJson.put("trace", (Object)errorTrace);
            JSONObject resultJson = new JSONObject();
            resultJson.put("error", (Object)errorDataJson);
            JSONObject detailJson = new JSONObject();
            detailJson.put("Errors", (Object)resultJson);
            JSONObject responseJson = new JSONObject();
            responseJson.put("Root", (Object)detailJson);
            gException = responseJson.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return gException;
    }

    public Document removeEmptyNode(Document newDomAdd) {
        String inputXML = "";
        Document validDom = null;
        try {
            inputXML = this.serializeDom(newDomAdd);
            Pattern emptyValueTag = Pattern.compile("\\s*<\\w+/>");
            Pattern emptyTagMultiLine = Pattern.compile("\\s*<\\w+>\n*\\s*</\\w+>");
            inputXML = emptyValueTag.matcher(inputXML).replaceAll("");
            while (inputXML.length() != (inputXML = emptyTagMultiLine.matcher(inputXML).replaceAll("")).length()) {
            }
            validDom = this.parseString(inputXML);
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        return validDom;
    }

    public static long copy(InputStream source, OutputStream target) throws IOException, NullPointerException {
        if (source == null || target == null) {
            throw new NullPointerException("Either source or target is null");
        }
        byte[] buffer = new byte[4096];
        int readed = -1;
        long total = 0L;
        while (-1 != (readed = source.read(buffer))) {
            target.write(buffer, 0, readed);
            total += (long)readed;
        }
        return total;
    }

    public static byte[] readStreamAsBytes(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int readed = -1;
        while ((readed = is.read(buffer)) != -1) {
            ((OutputStream)os).write(buffer, 0, readed);
        }
        return os.toByteArray();
    }

    public static String readStreamAsString(InputStream is) throws IOException {
        return new String(E12GenericUtility.readStreamAsBytes(is));
    }

    public static byte[] makeRequest(String url, InputStream postDataInputStream) throws IOException {
        return E12GenericUtility.makeRequest(url, postDataInputStream, 0);
    }

    public static byte[] makeRequest(String url, InputStream postDataInputStream, int readTimeout) throws IOException {
        byte[] result = new byte[]{};
        URL serviceURL = new URL(url);
        HttpURLConnection httpConnection = (HttpURLConnection)serviceURL.openConnection();
        if (readTimeout > 0) {
            httpConnection.setReadTimeout(2000);
        }
        httpConnection.setRequestMethod("GET");
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        httpConnection.setUseCaches(false);
        if (postDataInputStream != null) {
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpConnection.setRequestProperty("charset", "UTF-8");
            httpConnection.setRequestProperty("Content-Length", Integer.toString(postDataInputStream.available()));
            OutputStream connectionOutputStream = httpConnection.getOutputStream();
            E12GenericUtility.copy(postDataInputStream, connectionOutputStream);
        }
        httpConnection.connect();
        InputStream responseStream = httpConnection.getInputStream();
        result = E12GenericUtility.readStreamAsBytes(responseStream);
        return result;
    }

    public static byte[] makeMultipartRequest(String endPoint, File ... files) throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(endPoint);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        int totalFiles = 0;
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file != null && file.exists()) {
                FileBody fileBody = new FileBody(file);
                multipartEntityBuilder.addPart(String.format("file_%s", i), (ContentBody)fileBody);
                ++totalFiles;
            }
            ++i;
        }
        multipartEntityBuilder.addTextBody("totalFiles", String.valueOf(totalFiles));
        HttpEntity httpEntity = multipartEntityBuilder.build();
        httpPost.setEntity(httpEntity);
        CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity response = closeableHttpResponse.getEntity();
        InputStream responseInputStream = response.getContent();
        byte[] responseBytes = E12GenericUtility.readStreamAsBytes(responseInputStream);
        try {
            responseInputStream.close();
            closeableHttpResponse.close();
            httpClient.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        return responseBytes;
    }

    public static byte[] makeRequest(String url, InputStream postDataInputStream, int readTimeout, String sessionID, String contentType) throws IOException {
        byte[] result = new byte[]{};
        URL serviceURL = new URL(url);
        HttpURLConnection httpConnection = (HttpURLConnection)serviceURL.openConnection();
        if (readTimeout > 0) {
            httpConnection.setReadTimeout(2000);
        }
        httpConnection.setRequestMethod("GET");
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        httpConnection.setUseCaches(false);
        if (postDataInputStream != null) {
            httpConnection.setRequestMethod("POST");
            if (contentType == null) {
                httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            } else {
                httpConnection.setRequestProperty("Content-Type", contentType);
            }
            httpConnection.setRequestProperty("charset", "UTF-8");
            httpConnection.setRequestProperty("Content-Length", Integer.toString(postDataInputStream.available()));
            OutputStream connectionOutputStream = httpConnection.getOutputStream();
            E12GenericUtility.copy(postDataInputStream, connectionOutputStream);
        }
        httpConnection.connect();
        InputStream responseStream = httpConnection.getInputStream();
        result = E12GenericUtility.readStreamAsBytes(responseStream);
        return result;
    }

    public static String buildQueryString(Map<String, String> queryParamters) throws UnsupportedEncodingException {
        if (queryParamters == null || queryParamters.size() == 0) {
            return "";
        }
        Set<String> keys = queryParamters.keySet();
        String queryString = "";
        for (String key : keys) {
            String value = queryParamters.get(key);
            queryString = String.valueOf(queryString) + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8") + "&";
        }
        return queryString;
    }

    public Node applyValueOnParentNode(String nodeName, String value, Node parentNode, String formNo, Document detailDom) throws ITMException {
        try {
            NodeList subChildList;
            int totalDetailNodes;
            Node currDetailNode = parentNode;
            Node appendNode = null;
            if (currDetailNode != null && currDetailNode.getNodeType() == 1 && (totalDetailNodes = (subChildList = currDetailNode.getChildNodes()).getLength()) > 0) {
                int j = 0;
                while (j < totalDetailNodes) {
                    String currNodeName;
                    appendNode = subChildList.item(j);
                    if (appendNode != null && appendNode.getNodeType() == 1 && (currNodeName = appendNode.getNodeName()).equalsIgnoreCase(nodeName)) {
                        if (appendNode.getFirstChild() != null && appendNode.getFirstChild().getNodeValue() != null) {
                            appendNode.getFirstChild().setNodeValue(value);
                            break;
                        }
                        CDATASection cDataSection = detailDom.createCDATASection(value);
                        appendNode.appendChild(cDataSection);
                        break;
                    }
                    ++j;
                }
            }
            return currDetailNode;
        }
        catch (DOMException e) {
            BaseLogger.log("0", null, null, "Exception in applyVlaue[" + e.getMessage() + "]");
            e.printStackTrace();
            return null;
        }
    }

    public void seteditableListMap(String itemchangeString, String formNo) throws ITMException {
        Document itemchangrespDom = this.parseString(itemchangeString);
        NodeList newDetailList = itemchangrespDom.getElementsByTagName("Detail" + formNo);
        int k = 0;
        while (k < newDetailList.getLength()) {
            Node currentDetail = newDetailList.item(k);
            if (currentDetail != null && currentDetail.getNodeType() == 1) {
                NodeList childNodeList = currentDetail.getChildNodes();
                int i = 0;
                while (i <= childNodeList.getLength()) {
                    Node currChildNode = childNodeList.item(i);
                    if (currChildNode != null && currChildNode.getNodeType() == 1) {
                        String nodeName = E12GenericUtility.checkNull(currChildNode.getNodeName());
                        if (currChildNode.hasAttributes()) {
                            String value = currChildNode.getAttributes().getNamedItem("protect").getNodeValue();
                            this.editableListMap.put(nodeName, value);
                        }
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    public String checkConsistency(String headerString, UserInfoBean userInfo, String editorId, String objName, String formNo, String objType, TreeMap<String, String> argumentMap) throws ITMException {
        String responseStr;
        block70: {
            BaseLogger.log("2", userInfo, editorId, "E12GenericUtility.checkConsistency() start");
            responseStr = null;
            Boolean isValidate = false;
            Document headerDom = null;
            Connection connection = null;
            Statement pstmt = null;
            ResultSet rs = null;
            String confirm_col = null;
            String confirm_val = null;
            String site_acc_col = null;
            String emp_acc_col = null;
            String cust_acc_col = null;
            String supp_acc_col = null;
            String sales_pers_acc_col = null;
            try {
                Node salesPersAccColNode;
                formNo = E12GenericUtility.checkNull(formNo);
                objType = E12GenericUtility.checkNull(objType);
                headerString = E12GenericUtility.checkNull(headerString);
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() formNo:[" + formNo + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() objType:[" + objType + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() objName:[" + objName + "]");
                if (formNo.length() <= 0 || !"1".equals(formNo) || (!"T".equals(objType) && !"P".equals(objType) && !"W".equals(objType) || headerString.length() <= 0 || !headerString.contains("Detail1")) && (!"R".equals(objType) || argumentMap == null)) break block70;
                headerDom = this.parseString(headerString);
                String userId = userInfo.getLoginCode();
                String userLevel = E12GenericUtility.checkNull(userInfo.getUserLevel());
                String transDB = userInfo.getTransDB();
                String siteCode = E12GenericUtility.checkNull(userInfo.getSiteCode());
                String entityType = E12GenericUtility.checkNull(userInfo.getUserType());
                String entityCode = E12GenericUtility.checkNull(userInfo.getEntityCode());
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() userId:[" + userId + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() userLevel:[" + userLevel + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() transDB:[" + transDB + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() siteCode:[" + siteCode + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() entityType:[" + entityType + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() entityCode:[" + entityCode + "]");
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(transDB);
                String sql = "SELECT CONFIRM_COL, CONFIRM_VAL, EMP_ACC_COL, SITE_ACC_COL, CUST_ACC_COL, SUPP_ACC_COL, SALES_PERS_ACC_COL FROM TRANSETUP WHERE TRAN_WINDOW='w_" + objName + "'";
                pstmt = connection.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    confirm_col = E12GenericUtility.checkNull(rs.getString("CONFIRM_COL"));
                    confirm_val = E12GenericUtility.checkNull(rs.getString("CONFIRM_VAL"));
                    emp_acc_col = E12GenericUtility.checkNull(rs.getString("EMP_ACC_COL"));
                    site_acc_col = E12GenericUtility.checkNull(rs.getString("SITE_ACC_COL"));
                    cust_acc_col = E12GenericUtility.checkNull(rs.getString("CUST_ACC_COL"));
                    supp_acc_col = E12GenericUtility.checkNull(rs.getString("SUPP_ACC_COL"));
                    sales_pers_acc_col = E12GenericUtility.checkNull(rs.getString("SALES_PERS_ACC_COL"));
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() confirm_col:[" + confirm_col + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() confirm_val:[" + confirm_val + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() emp_acc_col:[" + emp_acc_col + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() site_acc_col:[" + site_acc_col + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() cust_acc_col:[" + cust_acc_col + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() supp_acc_col:[" + supp_acc_col + "]");
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() sales_pers_acc_col:[" + sales_pers_acc_col + "]");
                if (confirm_col != null && confirm_val != null && !"".equals(confirm_col) && !"".equals(confirm_val)) {
                    Node confrimNode;
                    String confirmColVal = "";
                    if ("R".equals(objType)) {
                        confirmColVal = E12GenericUtility.checkNull(argumentMap.get(confirm_col.toLowerCase()));
                        isValidate = true;
                    } else if (("T".equals(objType) || "P".equals(objType) || "W".equals(objType)) && (confrimNode = headerDom.getElementsByTagName(confirm_col.toLowerCase()).item(0)) != null && confrimNode.getNodeType() == 1 && confrimNode.getFirstChild() != null) {
                        confirmColVal = E12GenericUtility.checkNull(confrimNode.getFirstChild().getNodeValue());
                        isValidate = true;
                    }
                    BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() confirmColVal:[" + confirmColVal + "]");
                    if (isValidate.booleanValue() && confirm_val.equals(confirmColVal)) {
                        responseStr = this.getErrorString(confirm_col, "VTINVTDATA", userId);
                        this.writeSystemInconsistencyLogInFile(userInfo, "ProtectedDataAltered", objName, "", confirm_col, confirmColVal, confirm_val, "Non editable column ( " + confirm_col + " ) value is mismatch");
                        String string = responseStr = this.updateXMLString("trace", "Non editable column ( " + confirm_col + " ) value is mismatch", responseStr, userInfo);
                        return string;
                    }
                    isValidate = false;
                }
                if (!(site_acc_col == null || "".equals(site_acc_col) || "0".equals(userLevel) || "1".equals(userLevel))) {
                    String siteAccColVal = "";
                    if ("R".equals(objType)) {
                        boolean result = this.validateSites(userInfo, argumentMap, site_acc_col);
                        if (!result) {
                            responseStr = this.getErrorString(site_acc_col, "VTINVTDATA", userId);
                            String siteCodes = argumentMap.get(site_acc_col.toLowerCase());
                            if (siteCodes != null && siteCodes.indexOf(".") != -1) {
                                siteCodes = siteCodes.substring(siteCodes.indexOf(".") + 1);
                            }
                            this.writeSystemInconsistencyLogInFile(userInfo, "ProtectedDataAltered", objName, "", site_acc_col, siteCode, siteCodes, "Non editable column ( " + site_acc_col + " ) value is mismatch");
                            String string = responseStr = this.updateXMLString("trace", "Non editable column ( " + site_acc_col + " ) value is mismatch", responseStr, userInfo);
                            return string;
                        }
                    } else if ("T".equals(objType) || "P".equals(objType) || "W".equals(objType)) {
                        Node siteAccColNode = headerDom.getElementsByTagName(site_acc_col.toLowerCase()).item(0);
                        if (siteAccColNode != null && siteAccColNode.getNodeType() == 1 && siteAccColNode.getFirstChild() != null) {
                            siteAccColVal = E12GenericUtility.checkNull(siteAccColNode.getFirstChild().getNodeValue());
                            isValidate = true;
                        }
                        BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() siteAccColVal:[" + siteAccColVal + "]");
                        if (isValidate.booleanValue() && !siteCode.equals(siteAccColVal)) {
                            responseStr = this.getErrorString(site_acc_col, "VTINVTDATA", userId);
                            this.writeSystemInconsistencyLogInFile(userInfo, "ProtectedDataAltered", objName, "", site_acc_col, siteAccColVal, siteCode, "Non editable column ( " + site_acc_col + " ) value is mismatch");
                            String string = responseStr = this.updateXMLString("trace", "Non editable column ( " + site_acc_col + " ) value is mismatch", responseStr, userInfo);
                            return string;
                        }
                        isValidate = false;
                    }
                }
                if ("E".equals(entityType) && emp_acc_col != null && !"".equals(emp_acc_col)) {
                    Node empAccColNode;
                    String empAccColVal = "";
                    if ("R".equals(objType)) {
                        empAccColVal = E12GenericUtility.checkNull(argumentMap.get(emp_acc_col.toLowerCase()));
                        isValidate = true;
                    } else if (("T".equals(objType) || "P".equals(objType) || "W".equals(objType)) && (empAccColNode = headerDom.getElementsByTagName(emp_acc_col.toLowerCase()).item(0)) != null && empAccColNode.getNodeType() == 1 && empAccColNode.getFirstChild() != null) {
                        empAccColVal = E12GenericUtility.checkNull(empAccColNode.getFirstChild().getNodeValue());
                        isValidate = true;
                    }
                    BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() empAccColVal:[" + empAccColVal + "]");
                    if (isValidate.booleanValue() && !entityCode.equals(empAccColVal)) {
                        responseStr = this.getErrorString(emp_acc_col, "VTINVTDATA", userId);
                        this.writeSystemInconsistencyLogInFile(userInfo, "ProtectedDataAltered", objName, "", emp_acc_col, empAccColVal, entityCode, "Non editable column ( " + emp_acc_col + " ) value is mismatch");
                        String string = responseStr = this.updateXMLString("trace", "Non editable column ( " + emp_acc_col + " ) value is mismatch", responseStr, userInfo);
                        return string;
                    }
                    isValidate = false;
                    break block70;
                }
                if ("C".equals(entityType) && cust_acc_col != null && !"".equals(cust_acc_col)) {
                    Node custAccColNode;
                    String custAccColVal = "";
                    if ("R".equals(objType)) {
                        custAccColVal = E12GenericUtility.checkNull(argumentMap.get(cust_acc_col.toLowerCase()));
                        isValidate = true;
                    } else if (("T".equals(objType) || "P".equals(objType) || "W".equals(objType)) && (custAccColNode = headerDom.getElementsByTagName(cust_acc_col.toLowerCase()).item(0)) != null && custAccColNode.getNodeType() == 1 && custAccColNode.getFirstChild() != null) {
                        custAccColVal = E12GenericUtility.checkNull(custAccColNode.getFirstChild().getNodeValue());
                        isValidate = true;
                    }
                    BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() custAccColVal:[" + custAccColVal + "]");
                    if (isValidate.booleanValue() && !entityCode.equals(custAccColVal)) {
                        responseStr = this.getErrorString(cust_acc_col, "VTINVTDATA", userId);
                        this.writeSystemInconsistencyLogInFile(userInfo, "ProtectedDataAltered", objName, "", cust_acc_col, custAccColVal, entityCode, "Non editable column ( " + cust_acc_col + " ) value is mismatch");
                        String string = responseStr = this.updateXMLString("trace", "Non editable column ( " + cust_acc_col + " ) value is mismatch", responseStr, userInfo);
                        return string;
                    }
                    isValidate = false;
                    break block70;
                }
                if ("S".equals(entityType) && supp_acc_col != null && !"".equals(supp_acc_col)) {
                    Node suppAccColNode;
                    String suppAccColVal = "";
                    if ("R".equals(objType)) {
                        suppAccColVal = E12GenericUtility.checkNull(argumentMap.get(supp_acc_col.toLowerCase()));
                        isValidate = true;
                    } else if (("T".equals(objType) || "P".equals(objType) || "W".equals(objType)) && (suppAccColNode = headerDom.getElementsByTagName(supp_acc_col.toLowerCase()).item(0)) != null && suppAccColNode.getNodeType() == 1 && suppAccColNode.getFirstChild() != null) {
                        suppAccColVal = E12GenericUtility.checkNull(suppAccColNode.getFirstChild().getNodeValue());
                        isValidate = true;
                    }
                    BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() suppAccColVal:[" + suppAccColVal + "]");
                    if (isValidate.booleanValue() && !entityCode.equals(suppAccColVal)) {
                        responseStr = this.getErrorString(supp_acc_col, "VTINVTDATA", userId);
                        this.writeSystemInconsistencyLogInFile(userInfo, "ProtectedDataAltered", objName, "", supp_acc_col, suppAccColVal, entityCode, "Non editable column ( " + supp_acc_col + " ) value is mismatch");
                        String string = responseStr = this.updateXMLString("trace", "Non editable column ( " + supp_acc_col + " ) value is mismatch", responseStr, userInfo);
                        return string;
                    }
                    isValidate = false;
                    break block70;
                }
                if (!"P".equals(entityType) || sales_pers_acc_col == null || "".equals(sales_pers_acc_col)) break block70;
                String salesPersAccColVal = "";
                if ("R".equals(objType)) {
                    salesPersAccColVal = E12GenericUtility.checkNull(argumentMap.get(sales_pers_acc_col.toLowerCase()));
                    isValidate = true;
                } else if (("T".equals(objType) || "P".equals(objType) || "W".equals(objType)) && (salesPersAccColNode = headerDom.getElementsByTagName(sales_pers_acc_col.toLowerCase()).item(0)) != null && salesPersAccColNode.getNodeType() == 1 && salesPersAccColNode.getFirstChild() != null) {
                    salesPersAccColVal = E12GenericUtility.checkNull(salesPersAccColNode.getFirstChild().getNodeValue());
                    isValidate = true;
                }
                BaseLogger.log("3", userInfo, editorId, "E12GenericUtility.checkConsistency() salesPersAccColVal:[" + salesPersAccColVal + "]");
                if (isValidate.booleanValue() && !entityCode.equals(salesPersAccColVal)) {
                    responseStr = this.getErrorString(sales_pers_acc_col, "VTINVTDATA", userId);
                    this.writeSystemInconsistencyLogInFile(userInfo, "ProtectedDataAltered", objName, "", sales_pers_acc_col, salesPersAccColVal, entityCode, "Non editable column ( " + sales_pers_acc_col + " ) value is mismatch");
                    String string = responseStr = this.updateXMLString("trace", "Non editable column ( " + sales_pers_acc_col + " ) value is mismatch", responseStr, userInfo);
                    return string;
                }
                try {
                    isValidate = false;
                }
                catch (ITMException itmException) {
                    BaseLogger.log("0", userInfo, editorId, "ITMException in E12GenericUtility.checkConsistency() :[" + itmException.getMessage() + "]");
                    throw itmException;
                }
                catch (Exception e) {
                    BaseLogger.log("0", userInfo, editorId, "Exception in E12GenericUtility.checkConsistency() :[" + E12GenericUtility.getStackTrace(e) + "]");
                    throw new ITMException(e);
                }
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ex) {
                    BaseLogger.log("0", userInfo, editorId, "E12GenericUtility.checkConsistency() Exception in finally:[" + E12GenericUtility.getStackTrace(ex) + "]");
                }
            }
        }
        BaseLogger.log("2", userInfo, editorId, "E12GenericUtility.checkConsistency() responseStr:[" + responseStr + "]");
        BaseLogger.log("2", userInfo, editorId, "E12GenericUtility.checkConsistency() end");
        return responseStr;
    }

    public boolean validateSites(UserInfoBean userInfo, TreeMap<String, String> argumentMap, String fieldName) {
        boolean result;
        block28: {
            result = false;
            Statement pstmt = null;
            ResultSet rs = null;
            Connection connection = null;
            try {
                try {
                    String transDB = userInfo.getTransDB();
                    String userID = userInfo.getLoginCode();
                    BaseLogger.log("2", userInfo, null, "E12GenericUtility.validateSites() userID:[" + userID + "]");
                    ConnDriver connDriver = new ConnDriver();
                    connection = connDriver.getConnectDB(transDB);
                    String siteCodes = argumentMap.get(fieldName.toLowerCase());
                    BaseLogger.log("2", userInfo, null, "E12GenericUtility.validateSites() siteCodes:[" + siteCodes + "]");
                    if (!(siteCodes == null || "null".equals(siteCodes) || "undefined".equals(siteCodes) || "".equals(siteCodes.trim()))) {
                        if (siteCodes.indexOf(".") != -1) {
                            siteCodes = siteCodes.substring(siteCodes.indexOf(".") + 1);
                        }
                        if (siteCodes.indexOf(",") != -1) {
                            siteCodes = siteCodes.replace("'", "");
                        }
                        BaseLogger.log("2", userInfo, null, "E12GenericUtility.validateSites() siteCodes after:[" + siteCodes + "]");
                        String[] siteCodeArr = siteCodes.split(",");
                        String sql = "SELECT COUNT(1) FROM USER_SITE WHERE USER_ID=? AND SITE_CODE IN " + E12GenericUtility.getFormattedProfileId(siteCodes);
                        pstmt = connection.prepareStatement(sql);
                        pstmt.setString(1, userID);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            int count = rs.getInt("COUNT(1)");
                            BaseLogger.log("2", userInfo, null, "E12GenericUtility.validateSites() count:[" + count + "]");
                            BaseLogger.log("2", userInfo, null, "E12GenericUtility.validateSites() siteCodeArr size:[" + siteCodeArr.length + "]");
                            if (count == siteCodeArr.length) {
                                BaseLogger.log("2", userInfo, null, "E12GenericUtility.validateSites() in if");
                                result = true;
                            }
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", userInfo, null, "E12GenericUtility.validateSites() Exception :[" + E12GenericUtility.getStackTrace(e) + "]");
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                        break block28;
                    }
                    catch (Exception ex) {
                        BaseLogger.log("0", userInfo, null, "E12GenericUtility.validateSites() Exception in finally:[" + E12GenericUtility.getStackTrace(ex) + "]");
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ex) {
                    BaseLogger.log("0", userInfo, null, "E12GenericUtility.validateSites() Exception in finally:[" + E12GenericUtility.getStackTrace(ex) + "]");
                }
                throw throwable;
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", userInfo, null, "E12GenericUtility.validateSites() Exception in finally:[" + E12GenericUtility.getStackTrace(ex) + "]");
            }
        }
        BaseLogger.log("2", userInfo, null, "E12GenericUtility.validateSites() result:[" + result + "]");
        return result;
    }

    public static String getPythonServiceURL(String serviceName) {
        Map<String, String> pythonServiceDetails;
        String pythonServerPath = null;
        Map<String, Map<String, String>> pythonServicesMap = CommonConstants.PYTHON_SERVICES;
        if (pythonServicesMap != null && (pythonServiceDetails = pythonServicesMap.get(serviceName)) != null) {
            String protocol = pythonServiceDetails.get("PROTOCOL");
            String host = pythonServiceDetails.get("HOST");
            String port = E12GenericUtility.checkNull(pythonServiceDetails.get("PORT"));
            String path = pythonServiceDetails.get("ENDPOINT");
            pythonServerPath = String.format("%s://%s%s/%s", protocol, host, port, path);
        }
        return pythonServerPath;
    }

    public String updateXMLString(String nodeName, String nodeValue, String xmlString, UserInfoBean userInfo) {
        String returnXML = xmlString;
        try {
            if (!"".equals(E12GenericUtility.checkNull(xmlString))) {
                Node node;
                Document doc = this.parseString(xmlString = this.setXmlDec(xmlString));
                if (doc != null && (node = doc.getElementsByTagName(nodeName).item(0)) != null) {
                    if (node.getNodeType() == 1 && node.getFirstChild() != null && node.getFirstChild().getNodeValue() != null) {
                        node.getFirstChild().setNodeValue(nodeValue);
                    } else {
                        node.setTextContent(nodeValue);
                    }
                }
                returnXML = this.serializeDom(doc);
                BaseLogger.log("0", userInfo, null, "In updateXMLString returnXML:[" + returnXML + "]");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "In updateXMLString Exception:[" + e + "]");
            return returnXML;
        }
        return returnXML;
    }

    public String checkVulnerability(String queryString, String servletPathString, UserInfoBean userInfo, String requestURI, String requestURL, String host) throws ITMException {
        String result = "";
        try {
            Firewall firewall;
            String returnString;
            requestURL = requestURL.substring(0, requestURL.indexOf("/ibase"));
            String domainName = requestURL.substring(requestURL.indexOf("/") + 2);
            if (domainName.contains(":")) {
                domainName = domainName.substring(0, domainName.indexOf(":"));
            }
            if (!(E12GenericUtility.checkNull(CommonConstants.DOMAIN_NAMES).length() <= 0 || CommonConstants.DOMAIN_NAMES.contains(domainName) && CommonConstants.DOMAIN_NAMES.contains(host))) {
                String loginCode = "";
                if (userInfo != null) {
                    loginCode = userInfo.getLoginCode();
                }
                result = this.getErrorString("", "VTINVDNAME", loginCode);
                result = this.updateXMLString("trace", "Domain found mismatch in the requested URL : " + requestURL, result, userInfo);
                this.writeSystemInconsistencyLogInFile(userInfo, "HostHeaderInjection", servletPathString, "", "DomainName", domainName, "<DOMAIN_NAMES>" + CommonConstants.DOMAIN_NAMES + "</DOMAIN_NAMES>", "");
            } else if (!"".equals(E12GenericUtility.checkNull(queryString)) && (returnString = (firewall = new Firewall()).checkVulnerability(queryString, servletPathString, userInfo, requestURI, requestURL)) != null && returnString.startsWith("INVALID_REQUEST_PARAMETER")) {
                String[] stringArray = returnString.split("~~");
                String key = stringArray[1];
                String value = stringArray[2];
                String inconsistencyReason = stringArray[3];
                String loginCode = "";
                if (userInfo != null) {
                    loginCode = userInfo.getLoginCode();
                }
                result = this.getErrorString(key, "VTINVPDATA", loginCode);
                result = this.updateXMLString("trace", "Request parameter ( " + key + " ) value found mismatch in request " + servletPathString + "?" + queryString, result, userInfo);
                this.writeSystemInconsistencyLogInFile(userInfo, "ParameterInjection", servletPathString, "", key, value, "", inconsistencyReason);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "E12GenericUtility.checkVulnerability() Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        BaseLogger.log("0", null, null, "E12GenericUtility.checkVulnerability() result : [" + result + "]");
        return result;
    }

    public String convertXMLtoExcel(Document dom, String docName, String hostURL) throws ITMException {
        String serverFilePath = "";
        try {
            Object detailNode;
            XSSFWorkbook workbook = new XSSFWorkbook();
            NodeList headerNodeList = dom.getElementsByTagName("Detail");
            BaseLogger.log("3", null, null, "E12GenericUtility.doPost() header count:[" + headerNodeList.getLength() + "]");
            if (headerNodeList != null) {
                XSSFSheet sheet = workbook.createSheet("Header");
                int i = 0;
                while (i < headerNodeList.getLength()) {
                    Cell cell;
                    Node node;
                    int j;
                    if (i == 0) {
                        XSSFRow headingRow = sheet.createRow(i);
                        detailNode = headerNodeList.item(i);
                        if (detailNode != null) {
                            NodeList deatilChildList = detailNode.getChildNodes();
                            j = 0;
                            while (j < deatilChildList.getLength()) {
                                node = deatilChildList.item(j);
                                if (node != null && 1 == node.getNodeType()) {
                                    String colName = node.getNodeName();
                                    BaseLogger.log("3", null, null, "E12GenericUtility.doPost() colName:[" + colName + "]");
                                    cell = headingRow.createCell(j);
                                    cell.setCellValue(colName);
                                }
                                ++j;
                            }
                        }
                    }
                    XSSFRow row = sheet.createRow(i + 1);
                    detailNode = headerNodeList.item(i);
                    if (detailNode != null) {
                        NodeList detailChildList = detailNode.getChildNodes();
                        j = 0;
                        while (j < detailChildList.getLength()) {
                            node = detailChildList.item(j);
                            if (node != null && 1 == node.getNodeType() && node.getFirstChild() != null) {
                                String colValue = node.getFirstChild().getNodeValue();
                                BaseLogger.log("3", null, null, "E12GenericUtility.doPost() colValule:[" + colValue + "]");
                                cell = row.createCell(j);
                                cell.setCellValue(colValue);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if ("".equals(E12GenericUtility.checkNull(docName))) {
                docName = "Order.xlsx";
            } else {
                docName = docName.substring(0, docName.lastIndexOf("."));
                docName = String.valueOf(docName) + ".xlsx";
            }
            BaseLogger.log("3", null, null, "E12GenericUtility.convertXMLtoExcel() docName :[" + docName + "]");
            String folderPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "upload_orders";
            File file = new File(folderPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            String filePath = String.valueOf(folderPath) + File.separator + docName;
            try {
                detailNode = null;
                Object var11_15 = null;
                try (FileOutputStream fileOutputStream = new FileOutputStream(filePath);){
                    if (workbook.getNumberOfSheets() > 0) {
                        workbook.write((OutputStream)fileOutputStream);
                        serverFilePath = String.valueOf(hostURL) + File.separator + "ibase" + File.separator + "upload_orders" + File.separator + docName;
                    }
                }
                catch (Throwable throwable) {
                    if (detailNode == null) {
                        detailNode = throwable;
                    } else if (detailNode != throwable) {
                        ((Throwable)detailNode).addSuppressed(throwable);
                    }
                    throw detailNode;
                }
            }
            catch (Exception exp) {
                BaseLogger.log("0", null, null, "E12GenericUtility.doPost() Exception@@@:[" + E12GenericUtility.getStackTrace(exp) + "]");
                throw new ITMException(exp);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "E12GenericUtility.convertXMLtoExcel() Exception:[" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        return serverFilePath;
    }

    public HashMap<String, String> getUserInfoMap(UserInfoBean userInfo) {
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        try {
            Document dom = this.parseString(userInfo.toString());
            NodeList nodeList = dom.getElementsByTagName("UserInfo").item(0).getChildNodes();
            String fieldName = "";
            String fieldValue = "";
            int ctr = 0;
            while (ctr < nodeList.getLength()) {
                Node childNode = nodeList.item(ctr);
                if (childNode != null && childNode.getNodeType() == 1) {
                    fieldName = childNode.getNodeName();
                    fieldValue = "";
                    if (childNode.getFirstChild() != null) {
                        fieldValue = childNode.getFirstChild().getNodeValue();
                    }
                    userInfoMap.put(fieldName, fieldValue);
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userInfoMap;
    }

    public String getErrorMessage(String columnName, String msgNo, String userId) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement stmt = null;
        Statement stmt1 = null;
        Statement stmt2 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String msgType = "";
        String msgString = "";
        String msgDescription = "";
        String profileId = "";
        String errSource = "";
        String tempMsgType = "";
        String msgOption = "";
        String msgTime = "";
        String redirerr = "";
        String soundPlay = "";
        try {
            try {
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("Driver");
                connDriver = null;
                String sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sqlQuery);
                if (rs.next()) {
                    msgType = rs.getString("MSG_TYPE");
                    msgString = rs.getString("MSG_STR");
                    msgDescription = rs.getString("MSG_DESCR");
                    errSource = rs.getString("ERR_SOURCE");
                    msgOption = rs.getString("MSG_OPT");
                    msgTime = rs.getString("MSG_TIME");
                    soundPlay = rs.getString("ALARM");
                } else {
                    msgDescription = "Message Id not found [" + msgNo + "]";
                    msgType = "E";
                    msgString = "";
                }
                if (msgType.equals("E") || msgType.trim().length() == 0) {
                    String sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
                    stmt1 = conn.createStatement();
                    rs1 = stmt1.executeQuery(sqlQuery1);
                    if (rs1.next()) {
                        profileId = rs1.getString("profile_id");
                        if (profileId == null) {
                            profileId = "";
                        }
                        sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND ( PROFILE_ID='" + profileId.trim() + "' OR PROFILE_ID = 'X' )";
                        stmt2 = conn.createStatement();
                        rs2 = stmt2.executeQuery(sqlQuery1);
                        if (rs2.next()) {
                            tempMsgType = rs2.getString("msg_type");
                        }
                        rs2.close();
                    }
                    rs1.close();
                    if (tempMsgType != null && tempMsgType.trim().length() > 0) {
                        msgType = tempMsgType;
                    }
                }
                if (msgType.equals("W")) {
                    msgString = "Warning : " + msgString;
                } else if (msgType.equals("P")) {
                    msgString = "Prompt : " + msgString;
                } else if (msgType.equals("F")) {
                    msgString = "Information : " + msgString;
                } else {
                    msgType = "E";
                    msgString = "Error : " + msgString;
                }
                if (errSource != null && errSource.trim().equals("D")) {
                    msgDescription = String.valueOf(msgDescription) + " * From Database ";
                }
                if (redirerr == null || redirerr.trim().length() == 0) {
                    redirerr = "1";
                }
                if (msgOption != null && msgOption.trim().equals("M")) {
                    redirerr = redirerr.trim().equals("1") ? "2" : "1";
                }
                if (rs != null) {
                    rs.close();
                    stmt.close();
                }
                if (rs1 != null) {
                    rs1.close();
                    stmt1.close();
                }
                if (rs2 != null) {
                    rs2.close();
                    stmt2.close();
                }
                conn.close();
            }
            catch (ITMException itme) {
                BaseLogger.log("0", null, null, "ITMException : [E12GenericUtility][getErrorString] :==>\n" + itme.getMessage());
                throw itme;
            }
            catch (SQLException se) {
                msgDescription = se.getMessage();
                msgType = "";
                msgString = "";
                BaseLogger.log("0", null, null, "Exception : [E12GenericUtility][getErrorString] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : [E12GenericUtility][getErrorString] :==>\n" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        StringBuffer errStringXml = new StringBuffer();
        errStringXml.append("<Message id=\"");
        errStringXml.append(msgNo).append("\" type=\"").append(msgType).append("\" column_name=\"");
        errStringXml.append(columnName).append("\">\r\n");
        errStringXml.append("<message><![CDATA[ " + msgString + "]]></message>");
        errStringXml.append("<description><![CDATA[" + msgDescription + "]]></description>");
        errStringXml.append("<type><![CDATA[" + msgType + "]]></type>");
        errStringXml.append("<time><![CDATA[" + msgTime + "]]></time>");
        errStringXml.append("<alarm><![CDATA[" + soundPlay + "]]></alarm>");
        errStringXml.append("<source><![CDATA[" + errSource + "]]></source>");
        errStringXml.append("<trace><![CDATA[" + msgString + "]]></trace>");
        errStringXml.append("<redirect><![CDATA[" + redirerr + "]]></redirect>");
        errStringXml.append("</Message>");
        return errStringXml.toString();
    }

    public String getFormNoDetailStrFromDom(String allXmlString, String formNo) throws ITMException {
        StringBuffer detailXml = new StringBuffer();
        try {
            Document dom = this.parseString(allXmlString);
            NodeList detailNodeList = dom.getElementsByTagName("Detail" + formNo);
            if (detailNodeList.getLength() > 0) {
                int domCtr = 0;
                while (domCtr < detailNodeList.getLength()) {
                    detailXml.append(this.serializeDom(detailNodeList.item(domCtr)));
                    ++domCtr;
                }
            } else {
                detailXml.append(allXmlString);
            }
        }
        catch (ITMException e) {
            e.printStackTrace();
            throw e;
        }
        return detailXml.toString();
    }

    public String applyPropertiesOnMetadata(JSONObject jsonObject, HashMap<String, String> propEditorInfoMap, UserInfoBean userInfo) {
        String retFilePath = null;
        ResourceModifier resModifier = null;
        ArrayList<String> enterpriseResList = new ArrayList();
        ArrayList<String> profileResList = new ArrayList();
        String metaDataFilePath = "";
        String exportToFolderName = "";
        File metaDataFile = null;
        String metaDatafileName = "";
        String profileIdRes = "";
        String enterpriseIdRes = "";
        String profileId = "";
        String editor = "";
        try {
            JSONObject jsonObjectMetadata = jsonObject.getJSONObject("REORDER_DATA");
            String formName = jsonObjectMetadata.getString("FORM_NAME");
            String objContext = jsonObjectMetadata.getString("FORM_NO");
            String objName = jsonObjectMetadata.getString("OBJ_NAME");
            String pageContext = "1";
            metaDatafileName = formName != null && !"null".equalsIgnoreCase(formName) && formName.trim().length() > 0 ? String.valueOf(objName) + pageContext + formName : String.valueOf(objName) + pageContext + objContext;
            profileIdRes = E12GenericUtility.checkNull(propEditorInfoMap.get("PROFILE_ID_RES"));
            enterpriseIdRes = E12GenericUtility.checkNull(propEditorInfoMap.get("ENTERPRISE_ID_RES"));
            profileId = E12GenericUtility.checkNull(propEditorInfoMap.get("PROFILE_ID"));
            propEditorInfoMap.put("EDITOR", editor);
            String userId = E12GenericUtility.checkNull(propEditorInfoMap.get("USER_ID"));
            String mataDataDefaultPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator;
            resModifier = new ResourceModifier();
            if (!"".equalsIgnoreCase(profileIdRes)) {
                profileResList = resModifier.getResourcePath(profileIdRes, userInfo.getTransDB());
                BaseLogger.log("3", null, null, "metaDataFile.profileResList " + profileResList);
            }
            if (!"".equalsIgnoreCase(enterpriseIdRes)) {
                enterpriseResList = resModifier.getEnterpriseResPath(enterpriseIdRes, userInfo.getTransDB());
                BaseLogger.log("3", null, null, "metaDataFile.enterpriseResList " + enterpriseResList);
            }
            if (profileResList.size() <= 0 && enterpriseResList.size() <= 0) {
                BaseLogger.log("3", null, null, "metaDataFile.profileId " + profileId);
                this.updatePropertiesFile(jsonObject, "", userInfo);
                metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + profileId + File.separator + userId + File.separator;
                exportToFolderName = String.valueOf(profileId) + File.separator + userId;
                BaseLogger.log("3", null, null, "metaDataFile.metaDataFilePath " + metaDataFilePath);
                BaseLogger.log("3", null, null, "metaDataFile.exportToFolderName " + exportToFolderName);
            } else {
                String prResPropFilePath = resModifier.getPropertiesFilePath(profileResList, objName, objContext, pageContext, editor, formName, false);
                String entrResPropFilePath = resModifier.getPropertiesFilePath(enterpriseResList, objName, objContext, pageContext, editor, formName, false);
                if (profileResList.size() > 0 && enterpriseResList.size() > 0 && prResPropFilePath.length() > 0 && entrResPropFilePath.length() > 0) {
                    this.updatePropertiesFile(jsonObject, prResPropFilePath, userInfo);
                    metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + enterpriseIdRes + "-" + profileIdRes + File.separator + userId + File.separator;
                    exportToFolderName = String.valueOf(enterpriseIdRes) + "-" + profileIdRes + File.separator + userId;
                } else if (profileResList.size() > 0 && prResPropFilePath.length() > 0) {
                    this.updatePropertiesFile(jsonObject, prResPropFilePath, userInfo);
                    metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + profileIdRes + File.separator + userId + File.separator;
                    exportToFolderName = String.valueOf(profileIdRes) + File.separator + userId;
                } else if (enterpriseResList.size() > 0 && entrResPropFilePath.length() > 0) {
                    this.updatePropertiesFile(jsonObject, entrResPropFilePath, userInfo);
                    metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + enterpriseIdRes + File.separator + userId + File.separator;
                    exportToFolderName = String.valueOf(enterpriseIdRes) + File.separator + userId;
                } else {
                    this.updatePropertiesFile(jsonObject, "", userInfo);
                    metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + profileIdRes + File.separator + userId + File.separator;
                    exportToFolderName = String.valueOf(profileIdRes) + File.separator + userId;
                }
            }
            BaseLogger.log("3", null, null, "metaDataFile : [" + metaDataFilePath + "]");
            metaDataFile = new File(metaDataFilePath, String.valueOf(metaDatafileName) + ".xml");
            BaseLogger.log("3", null, null, "Metadata file exists : [" + metaDataFile.exists() + "]");
            if (metaDataFile.exists() && !mataDataDefaultPath.equalsIgnoreCase(metaDataFilePath)) {
                metaDataFile.delete();
            }
            DWFactory dws = new DWFactory(userInfo);
            DWObject dwObject = dws.getDataWindow(metaDatafileName);
            dwObject.exportToXML(exportToFolderName, objName, objContext, pageContext, formName, profileResList, enterpriseResList, propEditorInfoMap, userInfo.getTransDB());
            BaseLogger.log("3", null, null, "E12GenericUtils : applyPropertiesOnMetadata : metaDataFilePath :[" + metaDataFilePath + "]");
            BaseLogger.log("3", null, null, "Metadata file exists : [" + metaDataFile.exists() + "]");
            if (metaDataFile.exists()) {
                retFilePath = metaDataFile.getAbsolutePath();
            } else {
                retFilePath = "";
                BaseLogger.log("3", null, null, "E12GenericUtils:getMetaDataFilePath: MetaDataFilePath not found......");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "E12GenericUtils:getMetaDataFilePath: retFilePath :[" + retFilePath + "]");
        return retFilePath;
    }

    private void updatePropertiesFile(JSONObject jsonObject, String tablePropertiesFilepath, UserInfoBean userInfo) {
        BaseLogger.log("3", null, null, "updatePropertiesFile propertiesFilepath [" + tablePropertiesFilepath + "]");
        String dataPropertieseStr = "";
        String formName = "";
        String formNo = "";
        String objName = "";
        String logicalname = "";
        String pageContext = "1";
        String profileId = E12GenericUtility.checkNull(userInfo.getProfileId());
        try {
            JSONObject jsonObjectFormData = jsonObject.getJSONObject("REORDER_DATA");
            BaseLogger.log("3", null, null, "updatePropertiesFile jsonObjectFormData [" + jsonObjectFormData + "]");
            formName = jsonObjectFormData.getString("FORM_NAME");
            formNo = jsonObjectFormData.getString("FORM_NO");
            objName = jsonObjectFormData.getString("OBJ_NAME");
            JSONArray jsonArray = jsonObject.getJSONArray("REORDER_COORDINATE");
            BaseLogger.log("3", null, null, "updatePropertiesFile jsonArray [" + jsonArray + "]");
            int i = 0;
            while (i < jsonArray.length()) {
                String jsonStr = jsonArray.get(i).toString();
                JSONObject jsonXcorObject = new JSONObject(jsonStr);
                int xcordinate = jsonXcorObject.getInt("X_CORDINATE");
                logicalname = jsonXcorObject.getString("LOGICAL_NAME");
                logicalname = logicalname.substring(logicalname.indexOf(".") + 1, logicalname.length());
                dataPropertieseStr = String.valueOf(dataPropertieseStr) + "\nColumnObject." + logicalname + ".x=" + xcordinate + "\nTextObject." + logicalname + "_t.x=" + xcordinate;
                ++i;
            }
            BaseLogger.log("3", null, null, "dataPropertieseStr Data created: [" + dataPropertieseStr + "]");
            tablePropertiesFilepath = E12GenericUtility.checkNull(tablePropertiesFilepath);
            String tablePropertiesFileName = "";
            String userId = userInfo.getLoginCode().trim();
            if (tablePropertiesFilepath.length() == 0) {
                tablePropertiesFileName = String.valueOf(objName) + "_" + pageContext + formNo + "_table.properties";
                tablePropertiesFilepath = String.valueOf(CommonConstants.RESOURCE_PROFILE_PATH) + File.separator + profileId + File.separator + userId;
                BaseLogger.log("3", null, null, "tablePropertiesFilepath after created: [" + tablePropertiesFilepath + "]");
                if (formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName)) {
                    tablePropertiesFileName = String.valueOf(objName) + "_" + pageContext + formName + "_table.properties";
                    tablePropertiesFilepath = String.valueOf(CommonConstants.RESOURCE_PROFILE_PATH) + File.separator + profileId + File.separator + userId;
                }
            } else {
                tablePropertiesFileName = tablePropertiesFilepath.substring(tablePropertiesFilepath.lastIndexOf(File.separator) + 1);
                tablePropertiesFileName = tablePropertiesFileName.substring(0, tablePropertiesFileName.lastIndexOf("."));
                tablePropertiesFileName = String.valueOf(tablePropertiesFileName) + "_table.properties";
                tablePropertiesFilepath = tablePropertiesFilepath.substring(0, tablePropertiesFilepath.lastIndexOf(File.separator));
                tablePropertiesFilepath = String.valueOf(tablePropertiesFilepath) + File.separator + userId;
            }
            BaseLogger.log("3", null, null, "propertiesFilepath : [" + tablePropertiesFilepath + "]");
            File propertiesFilesObj = new File(tablePropertiesFilepath);
            if (!propertiesFilesObj.exists()) {
                BaseLogger.log("3", null, null, "table properties file path created");
                propertiesFilesObj.mkdirs();
            }
            if ((propertiesFilesObj = new File(String.valueOf(tablePropertiesFilepath) + File.separator + tablePropertiesFileName)).exists()) {
                BaseLogger.log("3", null, null, "existing table propertise file deleted");
                propertiesFilesObj.delete();
            }
            if (!(propertiesFilesObj = new File(String.valueOf(tablePropertiesFilepath) + File.separator + tablePropertiesFileName)).exists()) {
                propertiesFilesObj.createNewFile();
                BaseLogger.log("3", null, null, "new table propertise file created");
            }
            FileWriter propertiesFileWriter = new FileWriter(propertiesFilesObj);
            propertiesFileWriter.write(dataPropertieseStr);
            propertiesFileWriter.close();
        }
        catch (JSONException e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception :: JSONException : [" + e.getMessage() + "]");
        }
        catch (IOException e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception :: IOException : [" + e.getMessage() + "]");
        }
    }

    public String updateXMLStringWithCDATA(String nodeName, String nodeValue, String xmlString, UserInfoBean userInfo) {
        String returnXML = xmlString;
        try {
            if (!"".equals(E12GenericUtility.checkNull(xmlString))) {
                Node node;
                Document doc = this.parseString(xmlString = this.setXmlDec(xmlString));
                if (doc != null && (node = doc.getElementsByTagName(nodeName).item(0)) != null) {
                    if (node.getNodeType() == 1 && node.getFirstChild() != null && node.getFirstChild().getNodeValue() != null) {
                        node.getFirstChild().setNodeValue(nodeValue);
                    } else {
                        CDATASection cDataSection = doc.createCDATASection(nodeValue);
                        node.appendChild(cDataSection);
                    }
                }
                returnXML = this.serializeDom(doc);
                BaseLogger.log("0", userInfo, null, "In updateXMLStringWithCDATA returnXML:[" + returnXML + "]");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "In updateXMLStringWithCDATA Exception:[" + e + "]");
            return returnXML;
        }
        return returnXML;
    }

    public static JsonObject readJsonFile(String fileName) throws Exception {
        BaseLogger.log("3", null, null, "In readJsonFile fileName:[" + fileName + "]");
        StringBuffer fileContent = new StringBuffer();
        BufferedReader bfr = null;
        FileInputStream fMainIn = null;
        String outTempStr = null;
        try {
            fMainIn = new FileInputStream(fileName);
            bfr = new BufferedReader(new InputStreamReader((InputStream)fMainIn, CommonConstants.ENCODING));
            while ((outTempStr = bfr.readLine()) != null) {
                fileContent.append(outTempStr);
            }
            bfr.close();
            bfr = null;
        }
        finally {
            block18: {
                try {
                    try {
                        if (bfr != null) {
                            bfr.close();
                            bfr = null;
                        }
                        if (fMainIn != null) {
                            fMainIn.close();
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception in readJsonFile file resource :[" + e.getMessage() + "]");
                        e.printStackTrace();
                        fMainIn = null;
                        outTempStr = null;
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    fMainIn = null;
                    outTempStr = null;
                    throw throwable;
                }
                fMainIn = null;
                outTempStr = null;
            }
        }
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(fileContent.toString());
        BaseLogger.log("3", null, null, "In readJsonFile 7347[" + jsonObject.toString() + "]");
        return jsonObject;
    }

    public void writeSystemInconsistencyLogInFile(UserInfoBean userInfo, String inconsistencyMessage, String componentName, String methodName, String parameterName, String parameterClientValue, String parameterServerValue, String inconsistencyReason) {
        try {
            Date date;
            SimpleDateFormat formatter;
            String sysDate;
            String logFileName;
            File logFile;
            BaseLogger.log("0", null, null, "E12Genericutility : writeSystemInconsistencyLogInFile");
            String folderPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "ExceptionLog";
            File logDir = new File(folderPath);
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            if (!(logFile = new File(folderPath, logFileName = "Firewall_breach_attempts.log")).exists()) {
                logFile.createNewFile();
            }
            if (componentName != null && componentName.startsWith("/")) {
                componentName = componentName.substring(1);
            }
            if ((sysDate = (formatter = new SimpleDateFormat("dd/MM/yyyy")).format(date = new Date())) != null && sysDate.indexOf("/") != -1) {
                sysDate = sysDate.replaceAll("/", "-");
            }
            formatter = new SimpleDateFormat("hh:mm:ss");
            String sysTime = formatter.format(date);
            String loginCode = "";
            if (userInfo != null) {
                loginCode = userInfo.getLoginCode();
            }
            String message = "";
            if ("HostHeaderInjection".equalsIgnoreCase(inconsistencyMessage)) {
                message = String.valueOf(sysDate) + "," + sysTime + "," + loginCode + "," + inconsistencyMessage + "," + componentName + "," + parameterName + "," + parameterClientValue + "," + parameterServerValue + "\n\n";
            } else if ("ParameterInjection".equalsIgnoreCase(inconsistencyMessage)) {
                message = String.valueOf(sysDate) + "," + sysTime + "," + loginCode + "," + inconsistencyMessage + "," + componentName + "," + parameterName + "," + parameterClientValue + "," + inconsistencyReason + "\n\n";
            } else if ("ProtectedDataAltered".equalsIgnoreCase(inconsistencyMessage)) {
                message = String.valueOf(sysDate) + "," + sysTime + "," + loginCode + "," + inconsistencyMessage + "," + componentName + "," + parameterName + "," + parameterClientValue + "," + parameterServerValue + "\n\n";
            }
            BaseLogger.log("0", null, null, "E12Genericutility : writeSystemInconsistencyLogInFile inconsistency details:[" + message + "]");
            FileWriter writer = new FileWriter(logFile, true);
            writer.write(message);
            writer.flush();
            writer.close();
        }
        catch (IOException er) {
            BaseLogger.log("0", null, null, "E12Genericutilty : writeSystemInconsistencyLogInFile : " + E12GenericUtility.getStackTrace(er));
        }
    }

    public static void deleteOldFilesFromFolder(String folderPath, String extensionCouldBeNull, int limit) {
        try {
            if (limit <= 1) {
                return;
            }
            BaseLogger.log("3", null, null, "default limit [" + limit + "]");
            File dir = new File(folderPath);
            if (!dir.exists()) {
                return;
            }
            Path parentFolder = dir.toPath();
            BaseLogger.log("3", null, null, "parentFolder [" + parentFolder.getFileName() + "]");
            List<Path> files = E12GenericUtility.getSortedFilesByDateCreated(parentFolder, extensionCouldBeNull, false);
            BaseLogger.log("3", null, null, "files.size() [" + files.size() + "]");
            if (files.size() <= limit) {
                return;
            }
            int removeFileLimit = CommonConstants.DELETE_LOG_FILE_COUNT;
            if (limit >= removeFileLimit) {
                limit -= removeFileLimit;
            }
            BaseLogger.log("3", null, null, "limit [" + limit + "]");
            files.subList(0, limit).clear();
            files.forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: deleteOldFilesFromFolder : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    private static List<Path> getSortedFilesByDateCreated(Path parentFolder, String targetExtensionCouldBeNull, boolean ascendingOrder) {
        try {
            Comparator<Path> pathComparator = Comparator.comparingLong(p -> E12GenericUtility.getFileCreationEpoch(p.toFile()));
            return Files.list(parentFolder).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(p -> targetExtensionCouldBeNull == null || p.getFileName().toString().endsWith(targetExtensionCouldBeNull)).sorted(ascendingOrder ? pathComparator : pathComparator.reversed()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static long getFileCreationEpoch(File file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return attr.creationTime().toInstant().toEpochMilli();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JSONObject getOrderedJSONObject() {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject();
            Field map = jsonObject.getClass().getDeclaredField("map");
            map.setAccessible(true);
            map.set(jsonObject, new LinkedHashMap());
            map.setAccessible(false);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: getOrderedJSONObject : [" + e.getMessage() + "]");
            e.printStackTrace();
            jsonObject = new JSONObject();
        }
        return jsonObject;
    }

    public String setAttribValue(String formDetailXml, String nodeName, String attribStr, String attribValue) {
        try {
            Document detailDom = this.parseString(formDetailXml);
            Node attributeNode = detailDom.getElementsByTagName(nodeName).item(0);
            if (attributeNode != null && attributeNode.getAttributes() != null) {
                Node attribNode = attributeNode.getAttributes().getNamedItem(attribStr);
                if (attribNode != null) {
                    attribNode.setNodeValue(attribValue);
                } else {
                    ((Element)attributeNode).setAttribute(attribStr, attribValue);
                }
            }
            formDetailXml = this.serializeDom(detailDom);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : setAttribValue : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return formDetailXml;
    }

    public String getReorderMetaDataFilePath(String objName, String objContext, String pageContext, String formName, HashMap<String, String> propEditorInfoMap, String transDB) {
        BaseLogger.log("2", null, null, "E12GenericUtils:getReorderMetaDataFilePath: objName: [" + objName + "]");
        BaseLogger.log("2", null, null, "E12GenericUtils:getReorderMetaDataFilePath: objContext: [" + objContext + "]");
        BaseLogger.log("2", null, null, "E12GenericUtils:getReorderMetaDataFilePath: pageContext: [" + pageContext + "]");
        BaseLogger.log("2", null, null, "E12GenericUtils:getReorderMetaDataFilePath: formName: [" + formName + "]");
        BaseLogger.log("2", null, null, "E12GenericUtils:getReorderMetaDataFilePath: propEditorInfoMap: [" + propEditorInfoMap + "]");
        String retFilePath = null;
        ResourceModifier resModifier = null;
        ArrayList<String> enterpriseResList = new ArrayList();
        ArrayList<Object> profileResList = new ArrayList();
        String metaDataFilePath = "";
        String exportToFolderName = "";
        String mataDataDefaultPath = "";
        File metaDataFile = null;
        String metaDatafileName = "";
        String profileIdRes = "";
        String enterpriseIdRes = "";
        String profileId = "";
        String editor = "";
        try {
            metaDatafileName = formName != null && !"null".equalsIgnoreCase(formName) && formName.trim().length() > 0 ? String.valueOf(objName) + pageContext + formName : String.valueOf(objName) + pageContext + objContext;
            profileIdRes = E12GenericUtility.checkNull(propEditorInfoMap.get("PROFILE_ID_RES"));
            enterpriseIdRes = E12GenericUtility.checkNull(propEditorInfoMap.get("ENTERPRISE_ID_RES"));
            profileId = E12GenericUtility.checkNull(propEditorInfoMap.get("PROFILE_ID"));
            propEditorInfoMap.put("EDITOR", editor);
            String userId = E12GenericUtility.checkNull(propEditorInfoMap.get("USER_ID"));
            boolean tablePropFileExist = false;
            boolean prResPropFileExist = false;
            boolean entrResPropFileExist = false;
            resModifier = new ResourceModifier();
            mataDataDefaultPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator;
            if ("".equalsIgnoreCase(profileIdRes) && "".equalsIgnoreCase(enterpriseIdRes)) {
                metaDataFilePath = mataDataDefaultPath;
                tablePropFileExist = resModifier.isTablePropertiesFileExist(objName, objContext, pageContext, editor, formName, userId, profileId);
                if (tablePropFileExist) {
                    metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + profileId + File.separator + userId + File.separator;
                }
            } else if (!"".equalsIgnoreCase(profileIdRes) && !"".equalsIgnoreCase(enterpriseIdRes)) {
                metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + enterpriseIdRes + "-" + profileIdRes + File.separator + userId + File.separator;
            } else if (!"".equalsIgnoreCase(profileIdRes) && "".equalsIgnoreCase(enterpriseIdRes)) {
                metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + profileIdRes + File.separator + userId + File.separator;
            } else if ("".equalsIgnoreCase(profileIdRes) && !"".equalsIgnoreCase(enterpriseIdRes)) {
                metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + enterpriseIdRes + File.separator + userId + File.separator;
            }
            BaseLogger.log("3", null, null, "E12GenericUtils: getReorderMetaDataFilePath : metaDataFilePath :[" + metaDataFilePath + "]");
            metaDataFile = new File(metaDataFilePath, String.valueOf(metaDatafileName) + ".xml");
            if (!metaDataFile.exists()) {
                if (!"".equalsIgnoreCase(profileIdRes)) {
                    profileResList = resModifier.getResourcePath(profileIdRes, transDB);
                }
                if (!"".equalsIgnoreCase(enterpriseIdRes)) {
                    enterpriseResList = resModifier.getEnterpriseResPath(enterpriseIdRes, transDB);
                }
                if (profileResList.size() <= 0 && enterpriseResList.size() <= 0) {
                    metaDataFilePath = mataDataDefaultPath;
                    metaDataFile = new File(metaDataFilePath, String.valueOf(metaDatafileName) + ".xml");
                    tablePropFileExist = resModifier.isTablePropertiesFileExist(objName, objContext, pageContext, editor, formName, userId, profileId);
                    if (tablePropFileExist) {
                        metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + profileId + File.separator + userId + File.separator;
                        exportToFolderName = userId;
                    }
                } else {
                    String prResPropFilePath = resModifier.getPropertiesFilePath(profileResList, objName, objContext, pageContext, editor, formName, false);
                    String entrResPropFilePath = resModifier.getPropertiesFilePath(enterpriseResList, objName, objContext, pageContext, editor, formName, false);
                    if (profileResList.size() > 0 && enterpriseResList.size() > 0 && prResPropFilePath.length() > 0 && entrResPropFilePath.length() > 0) {
                        metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + enterpriseIdRes + "-" + profileIdRes + File.separator + userId + File.separator;
                        exportToFolderName = String.valueOf(enterpriseIdRes) + "-" + profileIdRes + File.separator + userId;
                    } else if (profileResList.size() > 0 && prResPropFilePath.length() > 0) {
                        metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + profileIdRes + File.separator + userId + File.separator;
                        exportToFolderName = String.valueOf(profileIdRes) + File.separator + userId;
                    } else if (enterpriseResList.size() > 0 && entrResPropFilePath.length() > 0) {
                        metaDataFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + enterpriseIdRes + File.separator + userId + File.separator;
                        exportToFolderName = String.valueOf(enterpriseIdRes) + File.separator + userId;
                    } else {
                        metaDataFilePath = mataDataDefaultPath;
                    }
                }
                BaseLogger.log("3", null, null, "E12GenericUtils: getReorderMetaDataFilePath :metaDataFilePath :[" + metaDataFilePath + "]");
                metaDataFile = new File(metaDataFilePath, String.valueOf(metaDatafileName) + ".xml");
            }
            BaseLogger.log("3", null, null, "Metadata file exists :[" + metaDataFile.exists() + "]");
            if (metaDataFile.exists()) {
                retFilePath = metaDataFile.getAbsolutePath();
            } else {
                retFilePath = "";
                BaseLogger.log("3", null, null, "E12GenericUtils: getReorderMetaDataFilePath : MetaDataFilePath not found......");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "E12GenericUtils: getReorderMetaDataFilePath : retFilePath :[" + retFilePath + "]");
        return retFilePath;
    }

    public String writeFile(String filePath, String fileName, String data) throws ITMException {
        String fileSize = this.writeFile(filePath, fileName, data, false);
        return fileSize;
    }

    public String writeFile(String filePath, String fileName, String data, boolean append) throws ITMException {
        String fileSize = "";
        try {
            File fileDir = new File(filePath);
            if (!fileDir.exists()) {
                fileDir.mkdirs();
                BaseLogger.log("3", null, null, "New Directory Created");
            }
            filePath = fileDir + File.separator + fileName;
            File file = new File(filePath);
            BaseLogger.log("3", null, null, "file : [" + file + "]");
            if (!file.exists()) {
                file.createNewFile();
                BaseLogger.log("3", null, null, "new File Created");
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filePath, append)));
            out.println(data);
            out.close();
            long fileSizeL = file.length();
            fileSize = String.valueOf(fileSizeL);
            BaseLogger.log("3", null, null, "file size::[" + fileSize + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception in writeFile : [" + e.getMessage() + "]");
            throw new ITMException(e);
        }
        return fileSize;
    }

    public String decodeXMLString(String encodeXMLString) {
        if (encodeXMLString == null) {
            return "";
        }
        return encodeXMLString.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&apos;", "'").replaceAll("&quot;", "\"");
    }

    public String encodeXMLString(String xmlString) {
        if (xmlString == null) {
            return "";
        }
        return xmlString.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public static JSONObject callJsonResponseService(String serviceURL, String paramStr, InputStream postDataStream) throws JSONException, UnsupportedEncodingException {
        BaseLogger.log("2", null, null, "In callJsonResponseService");
        String result = "{}";
        try {
            if (paramStr != null) {
                postDataStream = new ByteArrayInputStream(paramStr.getBytes());
            }
            byte[] resultBytes = E12GenericUtility.makeRequest(serviceURL, postDataStream);
            result = new String(resultBytes);
            BaseLogger.log("2", null, null, "JsonResponse result [" + result + "]");
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exception in ProjectDeployment :: callJsonResponseService : [" + ex.getMessage() + "]");
            result = "{\"status\": \"error\", \"results\": \"" + ex + "\"}";
        }
        return new JSONObject(result);
    }

    public byte[] readFileAsBytes(String fileName) throws Exception {
        BufferedInputStream bfr = null;
        FileInputStream fileInputStream = null;
        byte[] byteArray = new byte[1];
        try {
            fileInputStream = new FileInputStream(fileName);
            bfr = new BufferedInputStream(fileInputStream);
            byteArray = E12GenericUtility.readStreamAsBytes(bfr);
            bfr.close();
            bfr = null;
            fileInputStream.close();
        }
        finally {
            block17: {
                try {
                    try {
                        if (bfr != null) {
                            bfr.close();
                            bfr = null;
                        }
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception in releasing file resource :[" + fileName + "]");
                        e.printStackTrace();
                        fileInputStream = null;
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    fileInputStream = null;
                    throw throwable;
                }
                fileInputStream = null;
            }
        }
        return byteArray;
    }

    public static byte[] makeMultipartRequest(String endPoint, HashMap<String, Object> paramsMap) throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(endPoint);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        if (paramsMap != null) {
            for (Map.Entry<String, Object> paramEntry : paramsMap.entrySet()) {
                String paramName = paramEntry.getKey();
                Object paramValue = paramEntry.getValue();
                if (paramValue instanceof File) {
                    File file = (File)paramValue;
                    if (file == null || !file.exists()) continue;
                    FileBody fileBody = new FileBody(file);
                    builder.addPart("file", (ContentBody)fileBody);
                    continue;
                }
                if (!(paramValue instanceof String)) continue;
                builder.addTextBody(paramName, (String)paramValue, ContentType.TEXT_PLAIN);
            }
        }
        HttpEntity entity = builder.build();
        httpPost.setEntity(entity);
        CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
        int responseCode = closeableHttpResponse.getStatusLine().getStatusCode();
        BaseLogger.log("3", null, null, "responseCode : [" + responseCode + "], ReasonPhrase : [" + closeableHttpResponse.getStatusLine().getReasonPhrase() + "]");
        HttpEntity responseEntity = closeableHttpResponse.getEntity();
        InputStream responseInputStream = responseEntity.getContent();
        byte[] responseBytes = E12GenericUtility.readStreamAsBytes(responseInputStream);
        try {
            responseInputStream.close();
            closeableHttpResponse.close();
            httpClient.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        return responseBytes;
    }

    public static JSONObject callMultipartJsonResponseService(String serviceURL, HashMap<String, Object> paramsMap) throws JSONException, UnsupportedEncodingException {
        BaseLogger.log("2", null, null, "In callJsonResponseService");
        String result = "{}";
        try {
            byte[] resultBytes = E12GenericUtility.makeMultipartRequest(serviceURL, paramsMap);
            result = new String(resultBytes);
            BaseLogger.log("2", null, null, "JsonResponse result [" + result + "]");
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exception in ProjectDeployment :: callJsonResponseService : [" + ex.getMessage() + "]");
            result = "{\"status\": \"error\", \"error\": \"" + ex + "\"}";
        }
        return new JSONObject(result);
    }

    public void copyFile(File src, File dest) throws ITMException {
        InputStream is = null;
        OutputStream os = null;
        try {
            try {
                int bytesRead;
                is = new FileInputStream(src);
                os = new FileOutputStream(dest);
                byte[] buf = new byte[1024];
                while ((bytesRead = is.read(buf)) > 0) {
                    os.write(buf, 0, bytesRead);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                is.close();
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getJSONValue(JSONObject dataJson, String fieldName) throws JSONException {
        String fieldValue = "";
        if (dataJson != null) {
            if (dataJson.has(fieldName)) {
                fieldValue = dataJson.getString(fieldName);
            } else if (dataJson.has(fieldName.toLowerCase())) {
                fieldValue = dataJson.getString(fieldName.toLowerCase());
            } else if (dataJson.has(fieldName.toUpperCase())) {
                fieldValue = dataJson.getString(fieldName.toUpperCase());
            }
        }
        return fieldValue;
    }

    public static String encodeWildflyDataSourcePwd(String secret) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, ITMException {
        String retString = "";
        try {
            byte[] kbytes = "jaas is the way".getBytes();
            SecretKeySpec key = new SecretKeySpec(kbytes, "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(1, key);
            byte[] encoding = cipher.doFinal(secret.getBytes());
            BigInteger n = new BigInteger(encoding);
            retString = n.toString(16);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "In E12GenericUtility.encodeWildflyDataSourcePwd() Exception :[" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        BaseLogger.log("3", null, null, "In E12GenericUtility.decodeWildflyDataSourcePwd() Encoded String :[" + retString + "]");
        return retString;
    }

    public static String decodeWildflyDataSourcePwd(String secret) throws ITMException {
        String retString = "";
        try {
            byte[] kbytes = "jaas is the way".getBytes();
            SecretKeySpec key = new SecretKeySpec(kbytes, "Blowfish");
            BigInteger n = new BigInteger(secret, 16);
            byte[] encoding = n.toByteArray();
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(2, key);
            byte[] decode = cipher.doFinal(encoding);
            retString = new String(decode);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "In E12GenericUtility.decodeWildflyDataSourcePwd() Exception :[" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        BaseLogger.log("3", null, null, "In E12GenericUtility.decodeWildflyDataSourcePwd() Decoded String :[" + retString + "]");
        return retString;
    }

    public void writeCommunicationLog(UserInfoBean userInfo, boolean isException, String commType, String commStatus, String commErrMsg, String sendTo, String sendCC, String sendBCC, String subject, String mailBody, int attachCount, ArrayList<File> attachmentList) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        String tranID = null;
        String comLogOpt = "";
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        ConnDriver connDriver = new ConnDriver();
        try {
            try {
                conn = connDriver.getConnectDB(userInfo);
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                comLogOpt = dbAccessEJB.getDBColumnValue("ENTERPRISE", "COMM_LOG_OPT", "ENTERPRISE  = '" + userInfo.getEnterprise() + "'", userInfo.getTransDB());
                tranID = commonDBAccessEJB.generateSeq("comm_log_seq", 20, userInfo.getTransDB());
                if (comLogOpt != null && "A".equalsIgnoreCase(comLogOpt) || comLogOpt != null && "E".equalsIgnoreCase(comLogOpt) && isException) {
                    String sqlQuery = "INSERT INTO COMM_LOG(TRAN_ID,TRAN_DATE,COMM_TYPE,COMM_STATUS,COMM_ERR_MSG,COMM_TO,COMM_CC,COMM_BCC,COMM_SUBJECT,COMM_BODY,ATTACH_COUNT) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
                    pstmt = conn.prepareStatement(sqlQuery);
                    pstmt.setString(1, tranID);
                    pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(3, commType);
                    pstmt.setString(4, commStatus);
                    pstmt.setString(5, commErrMsg);
                    pstmt.setString(6, sendTo);
                    pstmt.setString(7, sendCC);
                    pstmt.setString(8, sendBCC);
                    pstmt.setString(9, subject);
                    pstmt.setString(10, mailBody);
                    pstmt.setInt(11, attachCount);
                    int insCnt = pstmt.executeUpdate();
                    if (insCnt > 0) {
                        conn.commit();
                    }
                }
                int k = 0;
                while (k < attachCount) {
                    File file = attachmentList.get(k);
                    String filePath = file.getAbsolutePath();
                    this.addDocument(filePath, tranID, userInfo, attachCount);
                    ++k;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception message.........:" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String addDocument(String filePath, String tranID, UserInfoBean userInfo, int attachCount) throws Exception {
        StringBuffer retXMLStringBuff = null;
        String retString = null;
        byte[] byteArray = new byte[1];
        byte[] videoFrameByteArray = new byte[1];
        BufferedInputStream bfr = null;
        ByteArrayOutputStream bout = null;
        try {
            try {
                File file = new File(filePath);
                FileInputStream input = new FileInputStream(file);
                bfr = new BufferedInputStream(input);
                bout = new ByteArrayOutputStream();
                int i = -1;
                while ((i = bfr.read()) != -1) {
                    bout.write(i);
                }
                byteArray = bout.toByteArray();
                String refId = tranID;
                String refCol = " ";
                String objName = "comm_log";
                String refSer = "COMLOG";
                String fileType = filePath.substring(filePath.lastIndexOf(".") + 1);
                String documentType = "EMAIL_ATTACHMENT";
                String attachFileType = fileType;
                String user = userInfo.getLoginCode();
                String docLinkOptn = " ";
                int noOfPages = 0;
                if ("pdf".equalsIgnoreCase(attachFileType)) {
                    FileInputStream pdfFileStream = new FileInputStream(file);
                    PdfReader pdfReader = new PdfReader((InputStream)pdfFileStream);
                    noOfPages = pdfReader.getNumberOfPages();
                    ((InputStream)pdfFileStream).close();
                }
                if ("mp4".equalsIgnoreCase(attachFileType) || "avi".equalsIgnoreCase(attachFileType) || "3gp".equalsIgnoreCase(attachFileType) || "mov".equalsIgnoreCase(attachFileType)) {
                    File videoFile = new File(filePath);
                    if (videoFile.exists()) {
                        try {
                            Picture picFrame = FrameGrab.getNativeFrame((File)videoFile, (int)10);
                            int height = picFrame.getHeight();
                            int width = picFrame.getWidth();
                            BufferedImage bufferedImage = new BufferedImage(width, height, 5);
                            byte[] bufferedImageData = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                            int[] picData = picFrame.getPlaneData(0);
                            int m = 0;
                            int len = bufferedImageData.length;
                            while (m < len) {
                                bufferedImageData[m] = (byte)picData[m];
                                ++m;
                            }
                            ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)bufferedImage, "png", arrayOutputStream);
                            videoFrameByteArray = arrayOutputStream.toByteArray();
                        }
                        catch (IOException ex) {
                            BaseLogger.log("0", userInfo, null, "Exception in videoFrameByteArray 7964 : " + ex);
                        }
                        catch (Exception ex) {
                            BaseLogger.log("0", userInfo, null, "Exception in videoFrameByteArray 7968 : " + ex);
                        }
                    } else {
                        BaseLogger.log("3", userInfo, null, "@@@@@ E12GenericUtility :: addDocument() : Video file NOT found at [" + videoFile.toString() + "]");
                    }
                }
                String referenceDescription = " ";
                String extractedData = " ";
                String fileMetadata = " ";
                retXMLStringBuff = new StringBuffer();
                retXMLStringBuff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                retXMLStringBuff.append("<?xml version=\"1.0\" encoding=\"" + CommonConstants.ENCODING + "\"?>");
                retXMLStringBuff.append("<DocumentRoot>");
                retXMLStringBuff.append("<description>Datawindow Root</description>");
                retXMLStringBuff.append("<group0>");
                retXMLStringBuff.append("<description>Group0 description</description>");
                retXMLStringBuff.append("<Header0>");
                retXMLStringBuff.append("<description>Header0 members</description>");
                retXMLStringBuff.append("<header>");
                retXMLStringBuff.append("<ref_id><![CDATA[" + refId + "]]></ref_id>");
                retXMLStringBuff.append("<ref_col><![CDATA[" + refCol + "]]></ref_col>");
                retXMLStringBuff.append("<obj_name><![CDATA[" + objName + "]]></obj_name>");
                retXMLStringBuff.append("<ref_ser><![CDATA[" + refSer + "]]></ref_ser>");
                retXMLStringBuff.append("<doc_name><![CDATA[" + file.getName() + "]]></doc_name>");
                retXMLStringBuff.append("<doc_type><![CDATA[" + fileType + "]]></doc_type>");
                retXMLStringBuff.append("<document_type><![CDATA[" + documentType + "]]></document_type>");
                retXMLStringBuff.append("<file_type><![CDATA[" + attachFileType + "]]></file_type>");
                retXMLStringBuff.append("<created_by><![CDATA[" + user + "]]></created_by>");
                retXMLStringBuff.append("<doc_link_optn><![CDATA[" + docLinkOptn + "]]></doc_link_optn>");
                retXMLStringBuff.append("<ref_descr><![CDATA[" + referenceDescription + "]]></ref_descr>");
                retXMLStringBuff.append("<doc_pages><![CDATA[" + noOfPages + "]]></doc_pages>");
                retXMLStringBuff.append("<extracted_data><![CDATA[" + extractedData + "]]></extracted_data>");
                retXMLStringBuff.append("<file_metadata><![CDATA[" + fileMetadata + "]]></file_metadata>");
                retXMLStringBuff.append("</header>");
                retXMLStringBuff.append("</Header0>");
                retXMLStringBuff.append("</group0>");
                retXMLStringBuff.append("</DocumentRoot>");
                retString = this.uploadDocument(file, byteArray, videoFrameByteArray, retXMLStringBuff.toString(), userInfo);
            }
            catch (ITMException itme) {
                throw itme;
            }
            catch (Exception e) {
                throw e;
            }
        }
        finally {
            try {
                if (bfr != null) {
                    bfr.close();
                    bfr = null;
                }
                if (bout != null) {
                    bout.close();
                    bout = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in releasing file resource :");
                e.printStackTrace();
            }
        }
        return retString;
    }

    public String uploadDocument(File uploadFile, byte[] fileBytes, byte[] videoFrameBytes, String xmlStr, UserInfoBean userInfo) throws ITMException {
        String response = "";
        try {
            String requestURL = String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/rest/E12ExtService/uploadDocument";
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(requestURL);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addTextBody("UPLOAD_XML_STR", xmlStr, ContentType.DEFAULT_BINARY);
            builder.addTextBody("USER_INFO", userInfo.toString(), ContentType.DEFAULT_BINARY);
            builder.addBinaryBody("fileBytes", fileBytes, ContentType.DEFAULT_BINARY, uploadFile.getName());
            builder.addBinaryBody("videoFrameBytes", videoFrameBytes, ContentType.DEFAULT_BINARY, uploadFile.getName());
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse closehttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            BaseLogger.log("3", userInfo, null, "StatusCode : [" + closehttpResponse.getStatusLine().getStatusCode() + "], ReasonPhrase : [" + closehttpResponse.getStatusLine().getReasonPhrase() + "]");
            HttpEntity responseEntity = closehttpResponse.getEntity();
            InputStream inStream = responseEntity.getContent();
            response = IOUtils.toString((InputStream)inStream, (String)CommonConstants.ENCODING);
            inStream.close();
            httpClient.close();
        }
        catch (UnsupportedEncodingException e) {
            BaseLogger.log("3", userInfo, null, "uploadDocument :: UnsupportedEncodingException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            BaseLogger.log("3", userInfo, null, "uploadDocument :: ClientProtocolException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (UnsupportedOperationException e) {
            BaseLogger.log("0", userInfo, null, "uploadDocument :: UnsupportedOperationException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (IOException e) {
            BaseLogger.log("0", userInfo, null, "uploadDocument :: IOException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        BaseLogger.log("2", userInfo, null, "uploadDocument :: response : [" + response + "]");
        return response;
    }

    public static String printCurrDateTime() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        return dtf.format(now);
    }

    public static String callStringResponseService(String serviceURL, String paramStr, InputStream postDataStream, String sessionId) throws JSONException, UnsupportedEncodingException {
        BaseLogger.log("2", null, null, "In callStringResponseService");
        String result = "";
        try {
            if (paramStr != null) {
                postDataStream = new ByteArrayInputStream(paramStr.getBytes());
            }
            byte[] resultBytes = E12GenericUtility.makeRequest(serviceURL, postDataStream, 0, sessionId);
            result = new String(resultBytes);
            BaseLogger.log("2", null, null, "String result [" + result + "]");
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exception in E12GenericUtility :: callStringResponseService : [" + ex.getMessage() + "]");
            result = "Error";
        }
        return result;
    }

    public static byte[] makeRequest(String url, InputStream postDataInputStream, int readTimeout, String sessionId) throws IOException {
        byte[] result = new byte[]{};
        URL serviceURL = new URL(url);
        HttpURLConnection httpConnection = (HttpURLConnection)serviceURL.openConnection();
        if (readTimeout > 0) {
            httpConnection.setReadTimeout(2000);
        }
        httpConnection.setRequestMethod("GET");
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        httpConnection.setUseCaches(false);
        if (postDataInputStream != null) {
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpConnection.setRequestProperty("charset", "UTF-8");
            httpConnection.setRequestProperty("Content-Length", Integer.toString(postDataInputStream.available()));
            httpConnection.setRequestProperty("Cookie", "JSESSIONID=" + URLEncoder.encode(sessionId, CommonConstants.ENCODING));
            OutputStream connectionOutputStream = httpConnection.getOutputStream();
            E12GenericUtility.copy(postDataInputStream, connectionOutputStream);
        }
        httpConnection.connect();
        InputStream responseStream = httpConnection.getInputStream();
        result = E12GenericUtility.readStreamAsBytes(responseStream);
        return result;
    }

    public String callPythonService(String url, JSONObject queryParamObj, UserInfoBean userInfo) throws ITMException {
        String result = "";
        BaseLogger.log("0", userInfo, null, "[callPythonService] url [" + url + "] queryParamObj [" + queryParamObj + "]");
        try {
            String queryParamStr = null;
            ByteArrayInputStream postDataInputStream = null;
            StringBuffer queryParam = new StringBuffer();
            queryParam.append("jsonData=").append(queryParamObj.toString());
            queryParamStr = queryParam.toString();
            if (queryParamStr != null) {
                postDataInputStream = new ByteArrayInputStream(queryParamStr.getBytes(StandardCharsets.UTF_8));
            }
            byte[] responseData = E12GenericUtility.makeRequest(url, postDataInputStream, 0, null, "application/json");
            result = new String(responseData);
            BaseLogger.log("0", userInfo, null, "[callPythonService] result [" + result + "]");
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exception in E12GenericUtility :: callPythonService : [" + ex.getMessage() + "]");
            throw new ITMException(ex);
        }
        return result;
    }

    public JSONObject convertCSVToJSON(String csvData, UserInfoBean userInfo) throws ITMException {
        JSONObject jsonObject = new JSONObject();
        try {
            String value;
            if ("".equalsIgnoreCase(E12GenericUtility.checkNull(csvData))) {
                return jsonObject;
            }
            BaseLogger.log("0", userInfo, null, "[convertCSVToJSON] csvData [" + csvData + "]");
            JSONObject prodIdentificationObj = new JSONObject();
            BISDictionary bis = new BISDictionary();
            prodIdentificationObj = bis.getProductIdentificationAlias(userInfo);
            BaseLogger.log("0", userInfo, null, "[convertCSVToJSON] prodIdentificationObj [" + prodIdentificationObj + "]");
            if (this.isJSONValid(csvData)) {
                JSONObject csvObject = new JSONObject(csvData);
                if (csvObject.has("Header") && csvObject.has("Details")) {
                    jsonObject = this.replacePhraseInJSON(csvObject, prodIdentificationObj);
                    return jsonObject;
                }
                if (!(csvObject.has("Header") || csvObject.has("Details") || csvObject.has("Line Items") || csvObject.has("lines"))) {
                    jsonObject = this.replacePhraseInJSONObject(csvObject, prodIdentificationObj);
                    return jsonObject;
                }
            }
            String headerJson = "";
            if (csvData.contains("}")) {
                headerJson = csvData.substring(0, csvData.indexOf("}") + 1).trim();
            } else if (csvData.contains("\"Sr.No")) {
                headerJson = csvData.substring(0, csvData.indexOf("\"Sr.No")).trim();
            } else if (csvData.contains("\"Sr. No")) {
                headerJson = csvData.substring(0, csvData.indexOf("\"Sr. No")).trim();
            } else if (csvData.contains("Sr.No")) {
                headerJson = csvData.substring(0, csvData.indexOf("Sr.No")).trim();
            } else if (csvData.contains("Sr. No")) {
                headerJson = csvData.substring(0, csvData.indexOf("Sr. No")).trim();
            } else {
                JSONObject errorObj = new JSONObject();
                errorObj.put("status", (Object)"error");
                errorObj.put("message", (Object)"Invalid Extraction");
                return errorObj;
            }
            if (this.isJSONValid(headerJson)) {
                JSONObject tempObj = new JSONObject(headerJson);
                Iterator iterator = tempObj.keys();
                while (iterator.hasNext()) {
                    String label = E12GenericUtility.checkNull((String)iterator.next());
                    String value2 = E12GenericUtility.checkNull(tempObj.optString(label));
                    if (prodIdentificationObj.has(label)) {
                        label = E12GenericUtility.checkNull(prodIdentificationObj.optString(label));
                    }
                    jsonObject.put(label, (Object)value2);
                }
            } else {
                String[] headers;
                if (headerJson.contains("{") && headerJson.contains("}")) {
                    headerJson = headerJson.substring(headerJson.indexOf("{") + 1, headerJson.indexOf("}"));
                }
                headerJson = headerJson.replaceAll("\"", "").trim();
                String[] stringArray = headers = headerJson.split("\n");
                int value2 = headers.length;
                int label = 0;
                while (label < value2) {
                    String header = stringArray[label];
                    String[] values = header.split(":");
                    int len = values.length - 1;
                    String label2 = E12GenericUtility.checkNull(values[0]);
                    value = E12GenericUtility.checkNull(values[len]);
                    if (prodIdentificationObj.has(label2)) {
                        label2 = E12GenericUtility.checkNull(prodIdentificationObj.optString(label2));
                    }
                    if (value.endsWith(",")) {
                        value = value.substring(0, value.length() - 1);
                    }
                    jsonObject.put(label2, (Object)value);
                    ++label;
                }
            }
            String dataToConvert = "";
            if (csvData.contains("[") && csvData.contains("]")) {
                dataToConvert = csvData.substring(csvData.indexOf("["), csvData.indexOf("]") + 1);
            }
            JSONArray linesArray = new JSONArray();
            if (this.isJSONArrayValid(dataToConvert)) {
                JSONArray tempArray = new JSONArray(dataToConvert);
                int i = 0;
                while (i < tempArray.length()) {
                    JSONObject tempRowObj = tempArray.optJSONObject(i);
                    if (tempRowObj != null) {
                        JSONObject rowObj = new JSONObject();
                        Iterator rowItr = tempRowObj.keys();
                        while (rowItr.hasNext()) {
                            String key = E12GenericUtility.checkNull((String)rowItr.next());
                            value = E12GenericUtility.checkNull(tempRowObj.optString(key));
                            if (prodIdentificationObj.has(key)) {
                                String resValKey = E12GenericUtility.checkNull(prodIdentificationObj.optString(key));
                                rowObj.put(resValKey, (Object)value);
                                continue;
                            }
                            rowObj.put(key, (Object)value);
                        }
                        linesArray.put((Object)rowObj);
                    }
                    ++i;
                }
            }
            if (linesArray.length() == 0) {
                if (csvData.contains("\"Sr.No")) {
                    dataToConvert = csvData.substring(csvData.indexOf("\"Sr.No"), csvData.length());
                } else if (csvData.contains("\"Sr. No")) {
                    dataToConvert = csvData.substring(csvData.indexOf("\"Sr. No"), csvData.length());
                } else if (csvData.contains("Sr.No")) {
                    dataToConvert = csvData.substring(csvData.indexOf("Sr.No"), csvData.length());
                } else if (csvData.contains("Sr. No")) {
                    dataToConvert = csvData.substring(csvData.indexOf("Sr. No"), csvData.length());
                } else {
                    JSONObject errorObj = new JSONObject();
                    errorObj.put("status", (Object)"error");
                    errorObj.put("message", (Object)"Invalid Extraction");
                    return errorObj;
                }
                if (dataToConvert.toLowerCase().contains("note:") || dataToConvert.toLowerCase().contains("please note")) {
                    int end = dataToConvert.toLowerCase().contains("note:") ? dataToConvert.toLowerCase().indexOf("note:") : dataToConvert.toLowerCase().indexOf("please note");
                    dataToConvert = dataToConvert.substring(0, end);
                }
                String csvHeaders = dataToConvert.substring(0, dataToConvert.indexOf("\n"));
                String[] csvHeadersArr = csvHeaders.split(",");
                String resValue = "";
                String[] stringArray = csvHeadersArr;
                int n = csvHeadersArr.length;
                int n2 = 0;
                while (n2 < n) {
                    String csvHeader = stringArray[n2];
                    resValue = (csvHeader = E12GenericUtility.checkNull(csvHeader)) != null && csvHeader.startsWith("\"") && csvHeader.endsWith("\"") ? (prodIdentificationObj.has(csvHeader = csvHeader.substring(1, csvHeader.length() - 1)) ? String.valueOf(resValue) + "\"" + prodIdentificationObj.optString(csvHeader) + "\"," : String.valueOf(resValue) + "\"" + csvHeader + "\",") : (prodIdentificationObj.has(csvHeader) ? String.valueOf(resValue) + prodIdentificationObj.optString(csvHeader) + "," : String.valueOf(resValue) + csvHeader + ",");
                    ++n2;
                }
                resValue = resValue.substring(0, resValue.length() - 1);
                dataToConvert = dataToConvert.replace(csvHeaders, resValue);
                BaseLogger.log("0", userInfo, null, "[convertCSVToJSON] dataToConvert [" + dataToConvert + "]");
                linesArray = this.csvToJson(dataToConvert);
            }
            BaseLogger.log("0", userInfo, null, "[convertCSVToJSON] linesArray [" + linesArray + "]");
            linesArray = this.calculateQuantity(linesArray);
            jsonObject.putOpt("lines", (Object)linesArray);
            BaseLogger.log("0", userInfo, null, "[convertCSVToJSON] jsonObject [" + String.valueOf(jsonObject) + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in E12GenericUtility :: convertCSVToJSON : [" + e.getMessage() + "]");
            throw new ITMException(e);
        }
        return jsonObject;
    }

    private JSONObject replacePhraseInJSON(JSONObject csvObject, JSONObject prodIdentificationObj) {
        JSONObject jsonObject = new JSONObject();
        try {
            JSONObject headerObj = csvObject.optJSONObject("Header");
            Iterator headerItr = headerObj.keys();
            while (headerItr.hasNext()) {
                String label = E12GenericUtility.checkNull((String)headerItr.next());
                String value = E12GenericUtility.checkNull(headerObj.optString(label));
                if (prodIdentificationObj.has(label)) {
                    label = E12GenericUtility.checkNull(prodIdentificationObj.optString(label));
                }
                jsonObject.put(label, (Object)value);
            }
            JSONArray detailJSONArr = csvObject.optJSONArray("Details");
            int i = 0;
            while (i < detailJSONArr.length()) {
                JSONObject lineObj = detailJSONArr.optJSONObject(i);
                Iterator lineObjItr = lineObj.keys();
                while (lineObjItr.hasNext()) {
                    String label = E12GenericUtility.checkNull((String)lineObjItr.next());
                    String value = E12GenericUtility.checkNull(lineObj.optString(label));
                    if (!prodIdentificationObj.has(label)) continue;
                    lineObj.remove(label);
                    label = E12GenericUtility.checkNull(prodIdentificationObj.optString(label));
                    lineObj.put(label, (Object)value);
                }
                ++i;
            }
            jsonObject.putOpt("lines", (Object)detailJSONArr);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in E12GenericUtility :: replacePhraseInJSON : [" + e.getMessage() + "]");
        }
        return jsonObject;
    }

    private JSONObject replacePhraseInJSONObject(JSONObject csvObject, JSONObject prodIdentificationObj) {
        JSONObject jsonObject = new JSONObject();
        try {
            Iterator headerItr = csvObject.keys();
            while (headerItr.hasNext()) {
                String label = E12GenericUtility.checkNull((String)headerItr.next());
                String value = E12GenericUtility.checkNull(csvObject.optString(label));
                if (prodIdentificationObj.has(label)) {
                    label = E12GenericUtility.checkNull(prodIdentificationObj.optString(label));
                }
                jsonObject.put(label, (Object)value);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in E12GenericUtility :: replacePhraseInJSONObject : [" + e.getMessage() + "]");
        }
        return jsonObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONArray csvToJson(String csvData) {
        JSONArray jsonArray = new JSONArray();
        try {
            CSVReader csvReader = new CSVReaderBuilder((Reader)new StringReader(csvData)).build();
            String[] headers = csvReader.readNext();
            if (headers == null) {
                throw new RuntimeException("CSV data is empty.");
            }
            block2: while (true) {
                String[] row;
                if ((row = csvReader.readNext()) == null) {
                    BaseLogger.log("0", null, null, "E12GenericUtility :: csvToJson :jsonArray [" + jsonArray.toString() + "]");
                    return jsonArray;
                }
                if (row.length <= 1) continue;
                JSONObject jsonObject = new JSONObject();
                int i = 0;
                while (true) {
                    String value;
                    if (i >= headers.length) {
                        jsonArray.put((Object)jsonObject);
                        continue block2;
                    }
                    if (headers[i].indexOf("\"") != -1) {
                        headers[i] = headers[i].replaceAll("\"", "");
                    }
                    String string = value = row.length > i ? row[i] : "";
                    if (value.indexOf("\"") != -1) {
                        value = value.replaceAll("\"", "");
                    }
                    jsonObject.put(E12GenericUtility.checkNull(headers[i]), (Object)E12GenericUtility.checkNull(value));
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "E12GenericUtility :: csvToJson :Exception [" + e + "]");
            e.printStackTrace();
        }
        return jsonArray;
    }

    public JSONArray csvToJsonWoLibrary(String csvData) {
        JSONArray linesArray = new JSONArray();
        try {
            String[] csvLines = csvData.split("\n");
            String[] headerRow = new String[]{};
            int i = 0;
            while (i < csvLines.length) {
                String row = csvLines[i];
                if (row.contains(",")) {
                    String[] columns = row.split(",");
                    if (i == 0) {
                        headerRow = columns;
                    } else {
                        JSONObject lineObject = new JSONObject();
                        int j = 0;
                        while (j < headerRow.length) {
                            String label;
                            String value = "";
                            if (j < columns.length && (value = E12GenericUtility.checkNull(columns[j])).indexOf("\"") != -1) {
                                value = value.replaceAll("\"", "");
                            }
                            if ((label = E12GenericUtility.checkNull(headerRow[j])).indexOf("\"") != -1) {
                                label = label.replaceAll("\"", "");
                            }
                            lineObject.put(label, (Object)value);
                            ++j;
                        }
                        linesArray.put((Object)lineObject);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in E12GenericUtility :: csvToJson : [" + e.getMessage() + "]");
        }
        return linesArray;
    }

    public JSONArray calculateQuantity(JSONArray linesArray) throws ITMException {
        try {
            BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() linesArray before update : [" + linesArray + "]");
            int i = 0;
            while (i < linesArray.length()) {
                JSONObject lineJsonObject = linesArray.optJSONObject(i);
                BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() lineJsonObject : [" + lineJsonObject + "]");
                String quantity = E12GenericUtility.checkNull(lineJsonObject.getString("quantity"));
                BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() quantity : [" + quantity + "]");
                double qty = 0.0;
                if (quantity != null && quantity.length() > 0) {
                    if (quantity.indexOf(",") != -1) {
                        quantity = quantity.replace(",", "");
                    }
                    if (!quantity.matches("[0-9]+")) {
                        BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() quantity contains non numeric values");
                        char[] cArray = quantity.toCharArray();
                        int n = cArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char c = cArray[n2];
                            if (!(Character.isDigit(c) || "+".equalsIgnoreCase("" + c) || ".".equalsIgnoreCase("" + c))) {
                                quantity = quantity.replace("" + c, "");
                            }
                            ++n2;
                        }
                    }
                    BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() quantity after replace non numeric values : [" + quantity + "]");
                    quantity = E12GenericUtility.checkNull(quantity);
                    if (quantity != null && quantity.length() > 0) {
                        if (quantity.indexOf("+") != -1) {
                            String preQuqntity = E12GenericUtility.checkNull(quantity.substring(0, quantity.indexOf("+")));
                            BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() preQuqntity : [" + preQuqntity + "]");
                            String postQuqntity = E12GenericUtility.checkNull(quantity.substring(quantity.indexOf("+") + 1));
                            BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() postQuqntity : [" + postQuqntity + "]");
                            double preQty = 0.0;
                            if (preQuqntity != null && preQuqntity.length() > 0) {
                                preQty = Double.parseDouble(preQuqntity);
                                BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() preQty : [" + preQty + "]");
                            }
                            double postQty = 0.0;
                            if (postQuqntity != null && postQuqntity.length() > 0) {
                                postQty = Double.parseDouble(postQuqntity);
                                BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() postQty : [" + postQty + "]");
                            }
                            qty = preQty + postQty;
                        } else {
                            qty = Double.parseDouble(quantity);
                        }
                        BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() qty : [" + qty + "]");
                        if (lineJsonObject.has("FREE")) {
                            String FREE = E12GenericUtility.checkNull(lineJsonObject.getString("FREE"));
                            BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() FREE : [" + FREE + "]");
                            if (FREE != null && FREE.length() > 0 && !FREE.contains("%")) {
                                if (FREE.indexOf(",") != -1) {
                                    FREE = FREE.replace(",", "");
                                }
                                if (!FREE.matches("[0-9]+")) {
                                    BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() FREE contains non numeric values");
                                    char[] postQty = FREE.toCharArray();
                                    int n = postQty.length;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        char c = postQty[n3];
                                        if (!(Character.isDigit(c) || "+".equalsIgnoreCase("" + c) || ".".equalsIgnoreCase("" + c))) {
                                            FREE = FREE.replace("" + c, "");
                                        }
                                        ++n3;
                                    }
                                    BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() FREE after replace non numeric values : [" + FREE + "]");
                                }
                                if ((FREE = E12GenericUtility.checkNull(FREE)) != null && FREE.length() > 0) {
                                    double free = 0.0;
                                    if (FREE.indexOf("+") != -1) {
                                        String preFREE = E12GenericUtility.checkNull(FREE.substring(0, FREE.indexOf("+")));
                                        BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() preFREE : [" + preFREE + "]");
                                        String postFREE = E12GenericUtility.checkNull(FREE.substring(FREE.indexOf("+") + 1));
                                        BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() postFREE : [" + postFREE + "]");
                                        double preFree = 0.0;
                                        if (preFREE != null && preFREE.length() > 0) {
                                            preFree = Double.parseDouble(preFREE);
                                            BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() preFree : [" + preFree + "]");
                                        }
                                        double postFree = 0.0;
                                        if (postFREE != null && postFREE.length() > 0) {
                                            postFree = Double.parseDouble(postFREE);
                                            BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() postFree : [" + postFree + "]");
                                        }
                                        free = preFree + postFree;
                                    } else {
                                        free = Double.parseDouble(FREE);
                                    }
                                    BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() free : [" + free + "]");
                                    BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() qty after adding FREE : [" + (qty += free) + "]");
                                }
                            }
                        }
                    }
                }
                lineJsonObject.put("quantity", (int)qty);
                BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() lineJsonObject after adding free: [" + lineJsonObject + "]");
                ++i;
            }
            BaseLogger.log("3", null, null, "E12GenericUtility.calculateQuantity() linesArray after update : [" + linesArray + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "E12GenericUtility.calculateQuantity() Exception:[" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        return linesArray;
    }

    public boolean validateXML(String xmlString) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.parse(new InputSource(new StringReader(xmlString)));
            return true;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return false;
        }
    }

    public String getDetailXMLDomString(String objName, String objContext, String editFlag, String pkValues, String argFieldValues, UserInfoBean userInfo) throws RemoteException, ITMException, ITMException {
        String resultString = "";
        MasterStatefulLocal masterStateful = null;
        try {
            try {
                masterStateful = (MasterStatefulLocal)this.getInitialContext().lookup("ibase/MasterStatefulEJB/local");
                int randInt = new Random().nextInt();
                masterStateful.setEditorId("" + randInt);
                masterStateful.setUserInfo(userInfo);
                resultString = masterStateful.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues);
            }
            catch (NamingException e) {
                BaseLogger.log("0", null, null, "NamingException :: getDetailXMLDomString() :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            if (masterStateful != null) {
                masterStateful.remove();
                masterStateful = null;
            }
        }
        return resultString;
    }

    private InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException : getInitialContext : " + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getInitialContext : " + e.getMessage());
            throw new ITMException(e);
        }
        return ctx;
    }

    public String getSortedJson(String xmlStr, String objName, UserInfoBean userInfo) {
        StringBuilder json = new StringBuilder("{\"Root\":{");
        Document document = this.convertStringToDocument(xmlStr);
        try {
            UploadFileEJB uploadFileEJB = new UploadFileEJB();
            TreeMap<Integer, String> formDetailInfo = uploadFileEJB.getFormWiseTitleMap(objName, userInfo);
            TreeMap<String, List> detailDataMap = new TreeMap<String, List>();
            int mapIndex = 1;
            while (mapIndex <= formDetailInfo.size()) {
                NodeList detailNodeList = document.getElementsByTagName("Detail" + mapIndex);
                int detailIndex = 0;
                while (detailIndex < detailNodeList.getLength()) {
                    List<String> list;
                    Node detailNode = detailNodeList.item(detailIndex);
                    BaseLogger.log("3", null, null, "DetailNode=" + detailNode.getNodeName());
                    NodeList detailList = detailNode.getChildNodes();
                    String data = "";
                    int index = 0;
                    while (index < detailList.getLength()) {
                        Node child = detailList.item(index);
                        if (child.getTextContent().contains("{") && child.getTextContent().contains("}")) {
                            BaseLogger.log("3", null, null, "Found Json obj" + child.getTextContent());
                            String jsonData = "\"" + child.getTextContent().replace("\"", "\\\"") + "\"";
                            BaseLogger.log("3", null, null, "Found Json obj" + jsonData);
                            data = String.valueOf(data) + "\"" + child.getNodeName() + "\":" + jsonData + ",";
                        } else {
                            data = child.getTextContent().equals("\"\"") ? String.valueOf(data) + "\"" + child.getNodeName() + "\":" + child.getTextContent() + "," : String.valueOf(data) + "\"" + child.getNodeName() + "\":\"" + child.getTextContent() + "\",";
                        }
                        ++index;
                    }
                    if (!data.equals("")) {
                        data = "{" + data.substring(0, data.length() - 1) + "}";
                    }
                    if (!detailDataMap.containsKey(detailNode.getNodeName())) {
                        list = new ArrayList<String>();
                        list.add(data);
                        detailDataMap.put(detailNode.getNodeName(), list);
                    } else {
                        list = (List)detailDataMap.get(detailNode.getNodeName());
                        list.add(data);
                        detailDataMap.put(detailNode.getNodeName(), list);
                    }
                    ++detailIndex;
                }
                ++mapIndex;
            }
            detailDataMap.forEach((key, value) -> {
                json.append("\"" + key + "\":");
                json.append(value + ",");
            });
            json.append("}}");
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Error in getSortedJson()" + e.getMessage());
        }
        return json.toString().replace("],}", "]}");
    }

    private Document convertStringToDocument(String xmlStr) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getFormattedXML(String result, String objName, UserInfoBean userInfo) {
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root>");
        try {
            UploadFileEJB uploadFileEJB = new UploadFileEJB();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(result.getBytes()));
            TreeMap<Integer, String> formDetailInfo = uploadFileEJB.getFormWiseTitleMap(objName, userInfo);
            BaseLogger.log("3", null, null, "formDetailInfoMAP=[" + formDetailInfo + "]");
            int mapIndex = 1;
            while (mapIndex <= formDetailInfo.size()) {
                NodeList detailNodeList = document.getElementsByTagName("Detail" + mapIndex);
                BaseLogger.log("3", null, null, "Detail node count=" + detailNodeList.getLength());
                int detailIndex = 0;
                while (detailIndex < detailNodeList.getLength()) {
                    if (!detailNodeList.item(detailIndex).getNodeName().contains("#")) {
                        Node detailNode = detailNodeList.item(detailIndex);
                        xml.append("<" + detailNode.getNodeName() + ">");
                        NodeList detailChildList = detailNode.getChildNodes();
                        int childIndex = 0;
                        while (childIndex < detailChildList.getLength()) {
                            Node childNode = detailChildList.item(childIndex);
                            if (!childNode.getNodeName().contains("#") && !childNode.getNodeName().equalsIgnoreCase("attribute")) {
                                String data = "\"\"";
                                if (childNode.hasChildNodes()) {
                                    data = childNode.getFirstChild().getTextContent();
                                }
                                xml.append("<" + childNode.getNodeName() + "><![CDATA[" + data + "]]>");
                                xml.append("</" + childNode.getNodeName() + ">");
                            }
                            ++childIndex;
                        }
                        xml.append("</" + detailNode.getNodeName() + ">");
                    }
                    ++detailIndex;
                }
                ++mapIndex;
            }
            xml.append("</Root>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("3", null, null, "xml String output=" + xml.toString());
        return xml.toString();
    }

    public static HttpResponse<String> makeApiCall(String apiURL, Map<String, String> headers, JSONObject parameters) {
        Unirest.setTimeouts((long)0L, (long)0L);
        HttpResponse response = null;
        BaseLogger.log("3", null, null, "Inside makeApiCall");
        try {
            BaseLogger.log("3", null, null, "Inside makeApiCall try");
            Unirest.setTimeouts((long)0L, (long)0L);
            response = Unirest.post((String)apiURL).headers(headers).body(parameters).asString();
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return response;
    }

    public void removePropertiesWithEmptyValues(JSONObject jsonObject) throws JSONException {
        JSONArray keys = jsonObject.names();
        if (keys != null) {
            int i = 0;
            while (i < keys.length()) {
                String key = keys.getString(i);
                Object value = jsonObject.get(key);
                if (value instanceof JSONObject) {
                    this.removePropertiesWithEmptyValues((JSONObject)value);
                } else if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    int j = 0;
                    while (j < array.length()) {
                        if (array.get(j) instanceof JSONObject) {
                            this.removePropertiesWithEmptyValues(array.getJSONObject(j));
                        }
                        ++j;
                    }
                } else if (value instanceof String && ((String)value).isEmpty()) {
                    jsonObject.remove(key);
                } else if (value == null) {
                    jsonObject.remove(key);
                }
                ++i;
            }
        }
    }

    public static String removeEmptyProperties(String jsonString) {
        String pattern = "\"(\\w+)\":\\s*\"\",?";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(jsonString);
        String result = matcher.replaceAll("");
        result = result.replaceAll(",\\s*}", "}");
        return result;
    }

    public int jsonDetailCount(String jsonData) {
        int detailCount = 0;
        try {
            JSONObject jsonObject = new JSONObject(jsonData);
            JSONObject rootObject = jsonObject.getJSONObject("Root");
            int i = 1;
            while (i <= rootObject.length()) {
                if (rootObject.has("Detail" + i)) {
                    ++detailCount;
                }
                ++i;
            }
            BaseLogger.log("3", null, null, "Number of Detail objects: " + detailCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return detailCount;
    }

    public String jsonFormatter(String jsonData, int detailCount) {
        String finalJson = "";
        try {
            JSONObject originalObject = new JSONObject(jsonData);
            StringBuilder jsonBuilder = new StringBuilder();
            jsonBuilder.append("{ \"Root\": {");
            boolean isFirstDetail = true;
            int i = 1;
            while (i <= detailCount) {
                String detailArrayName = "Detail" + i;
                if (originalObject.getJSONObject("Root").has(detailArrayName)) {
                    JSONArray jsonArray = originalObject.getJSONObject("Root").getJSONArray(detailArrayName);
                    if (!isFirstDetail) {
                        jsonBuilder.append(",");
                    }
                    jsonBuilder.append("\"").append(detailArrayName).append("\": ").append(jsonArray.toString());
                    isFirstDetail = false;
                }
                ++i;
            }
            jsonBuilder.append("}}");
            finalJson = jsonBuilder.toString();
            BaseLogger.log("3", null, null, "Formatted JSON: " + finalJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalJson;
    }

    public static void addisDataUploadAttribute(Document document) {
        NodeList detailList = document.getElementsByTagName("*");
        int i = 0;
        while (i < detailList.getLength()) {
            Element detail = (Element)detailList.item(i);
            if (detail.getTagName().startsWith("Detail")) {
                NodeList children = detail.getChildNodes();
                int j = 0;
                while (j < children.getLength()) {
                    Node child = children.item(j);
                    if (child.getNodeType() == 1) {
                        Element element = (Element)child;
                        element.setAttribute("isDataUpload", "true");
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static String documentToString(Document document) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.toString();
    }

    public static boolean fileExists(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    public static String readFileContents(String filePath) {
        StringBuilder content = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content.toString();
    }

    /*
     * Exception decompiling
     */
    public String getExternalAPIURL(String appId, String serviceClass, UserInfoBean userInfo) throws ITMException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String convertCSVToExcel(String csvData, String docName, String docType, String hostURL) throws ITMException {
        String serverFilePath = "";
        try {
            String[] nextLine;
            docType = "".equalsIgnoreCase(E12GenericUtility.checkNull(docType)) ? "Order" : docType;
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet(docType);
            BaseLogger.log("3", null, null, "E12GenericUtility.convertCSVToExcel() csvData :[" + csvData + "]");
            CSVReader csvReader = new CSVReaderBuilder((Reader)new StringReader(csvData)).build();
            String[] header = csvReader.readNext();
            XSSFRow headerRow = sheet.createRow(0);
            int i = 0;
            while (i < header.length) {
                Cell cell = headerRow.createCell(i);
                cell.setCellValue(header[i]);
                ++i;
            }
            int rowIndex = 1;
            while ((nextLine = csvReader.readNext()) != null) {
                XSSFRow row = sheet.createRow(rowIndex++);
                int i2 = 0;
                while (i2 < nextLine.length) {
                    Cell cell = row.createCell(i2);
                    cell.setCellValue(nextLine[i2]);
                    ++i2;
                }
            }
            if ("".equals(E12GenericUtility.checkNull(docName))) {
                docName = "Order.xlsx";
            } else {
                docName = docName.substring(0, docName.lastIndexOf("."));
                docName = String.valueOf(docName) + ".xlsx";
            }
            BaseLogger.log("3", null, null, "E12GenericUtility.convertCSVToExcel() docName :[" + docName + "]");
            String folderPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "upload_orders";
            File file = new File(folderPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            String filePath = String.valueOf(folderPath) + File.separator + docName;
            try {
                Throwable throwable = null;
                Object var17_23 = null;
                try (FileOutputStream fileOutputStream = new FileOutputStream(filePath);){
                    if (workbook.getNumberOfSheets() > 0) {
                        workbook.write((OutputStream)fileOutputStream);
                        serverFilePath = String.valueOf(hostURL) + File.separator + "ibase" + File.separator + "upload_orders" + File.separator + docName;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exp) {
                BaseLogger.log("0", null, null, "E12GenericUtility.convertCSVToExcel() Exception@@@:[" + E12GenericUtility.getStackTrace(exp) + "]");
                throw new ITMException(exp);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "E12GenericUtility.convertCSVToExcel() Exception = [" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        return serverFilePath;
    }

    public static String updateDbIDAttribute(String xmlString, String pkValues) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            NodeList detailNodes = doc.getElementsByTagName("Detail1");
            Element detailElement = (Element)detailNodes.item(0);
            String dbIDValue = detailElement.getAttribute("dbID");
            if (dbIDValue.isEmpty()) {
                detailElement.setAttribute("dbID", pkValues);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(doc), new StreamResult(writer));
                return writer.toString();
            }
            return xmlString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sortXmlByTabSequence(String xmlString) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(xmlString));
            Document document = builder.parse(inputSource);
            NodeList detailNodes = document.getDocumentElement().getChildNodes();
            ArrayList<Element> detailElements = new ArrayList<Element>();
            int i = 0;
            while (i < detailNodes.getLength()) {
                Node node = detailNodes.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().startsWith("Detail")) {
                    detailElements.add((Element)node);
                }
                ++i;
            }
            for (Element detailElement : detailElements) {
                NodeList childNodes = detailElement.getChildNodes();
                ArrayList<Element> childElements = new ArrayList<Element>();
                int i2 = 0;
                while (i2 < childNodes.getLength()) {
                    Node childNode = childNodes.item(i2);
                    if (childNode.getNodeType() == 1) {
                        childElements.add((Element)childNode);
                    }
                    ++i2;
                }
                List sortedChildElements = childElements.stream().sorted(Comparator.comparingInt(e -> {
                    String tabSequenceAttr = e.getAttribute("tabSequence");
                    return tabSequenceAttr.isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(tabSequenceAttr);
                })).collect(Collectors.toList());
                for (Element childElement : childElements) {
                    detailElement.removeChild(childElement);
                }
                for (Element sortedChildElement : sortedChildElements) {
                    detailElement.appendChild(sortedChildElement);
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return xmlString;
        }
    }

    public int getObjFormCount(String objName, UserInfoBean userInfo) throws SQLException {
        int count = 0;
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String getFailedTranIDSQL = "SELECT COUNT(*) AS ROW_COUNT FROM OBJ_FORMS WHERE WIN_NAME = ?";
                pstmt = connection.prepareStatement(getFailedTranIDSQL);
                pstmt.setString(1, objName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    count = rs.getInt("ROW_COUNT");
                    BaseLogger.log("3", null, null, "Row count: " + count);
                }
            }
            catch (Exception exception) {
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return count;
    }

    /*
     * Loose catch block
     */
    public String getErrorJson(String columnName, String msgNo, String userId) {
        String soundPlay;
        String redirerr;
        String msgTime;
        String msgOption;
        String errSource;
        String msgDescription;
        String msgString;
        String msgType;
        block66: {
            BaseLogger.log("3", null, null, "getErrorJson :: line no 9387: [" + columnName + "]");
            ConnDriver connDriver = null;
            Connection conn = null;
            Statement stmt = null;
            Statement stmt1 = null;
            Statement stmt2 = null;
            ResultSet rs = null;
            ResultSet rs1 = null;
            ResultSet rs2 = null;
            msgType = "";
            msgString = "";
            msgDescription = "";
            String profileId = "";
            errSource = "";
            String tempMsgType = "";
            msgOption = "";
            msgTime = "";
            redirerr = "";
            soundPlay = "";
            try {
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("Driver");
                connDriver = null;
                String sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sqlQuery);
                if (rs.next()) {
                    msgType = rs.getString("MSG_TYPE");
                    msgString = rs.getString("MSG_STR");
                    msgDescription = rs.getString("MSG_DESCR");
                    errSource = rs.getString("ERR_SOURCE");
                    msgOption = rs.getString("MSG_OPT");
                    msgTime = rs.getString("MSG_TIME");
                    soundPlay = rs.getString("ALARM");
                } else {
                    msgDescription = "Message Id not found [" + msgNo + "]";
                    msgType = "E";
                    msgString = "";
                }
                if (msgType.equals("E") || msgType.trim().length() == 0) {
                    String sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
                    stmt1 = conn.createStatement();
                    rs1 = stmt1.executeQuery(sqlQuery1);
                    if (rs1.next()) {
                        profileId = rs1.getString("profile_id");
                        if (profileId == null) {
                            profileId = "";
                        }
                        sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND ( PROFILE_ID='" + profileId.trim() + "' OR PROFILE_ID = 'X' )";
                        stmt2 = conn.createStatement();
                        rs2 = stmt2.executeQuery(sqlQuery1);
                        if (rs2.next()) {
                            tempMsgType = rs2.getString("msg_type");
                        }
                        rs2.close();
                    }
                    rs1.close();
                    if (tempMsgType != null && tempMsgType.trim().length() > 0) {
                        msgType = tempMsgType;
                    }
                }
                if (msgType.equals("W")) {
                    msgString = "Warning : " + msgString;
                } else if (msgType.equals("P")) {
                    msgString = "Prompt : " + msgString;
                } else if (msgType.equals("F")) {
                    msgString = "Information : " + msgString;
                } else {
                    msgType = "E";
                    msgString = "Error : " + msgString;
                }
                if (errSource != null && errSource.trim().equals("D")) {
                    msgDescription = String.valueOf(msgDescription) + " * From Database ";
                }
                if (redirerr == null || redirerr.trim().length() == 0) {
                    redirerr = "1";
                }
                if (msgOption != null && msgOption.trim().equals("M")) {
                    redirerr = redirerr.trim().equals("1") ? "2" : "1";
                }
                if (rs != null) {
                    rs.close();
                    stmt.close();
                }
                if (rs1 != null) {
                    rs1.close();
                    stmt1.close();
                }
                if (rs2 != null) {
                    rs2.close();
                    stmt2.close();
                }
                conn.close();
            }
            catch (ITMException itme) {
                BaseLogger.log("0", null, null, "ITMException : [E12GenericUtility][getErrorJson] :==>\n" + itme.getMessage());
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (stmt1 != null) {
                        stmt1.close();
                        stmt1 = null;
                    }
                    if (stmt2 != null) {
                        stmt2.close();
                        stmt2 = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (rs1 != null) {
                        rs1.close();
                        rs1 = null;
                    }
                    if (rs2 != null) {
                        rs2.close();
                        rs2 = null;
                    }
                    break block66;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                break block66;
            }
            catch (SQLException se) {
                msgDescription = se.getMessage();
                msgType = "";
                msgString = "";
                BaseLogger.log("0", null, null, "Exception : [E12GenericUtility][getErrorJson] :==>\n" + se.getMessage());
                se.printStackTrace();
                break block66;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : [E12GenericUtility][getErrorJson] :==>\n" + e.getMessage());
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (stmt1 != null) {
                        stmt1.close();
                        stmt1 = null;
                    }
                    if (stmt2 != null) {
                        stmt2.close();
                        stmt2 = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (rs1 != null) {
                        rs1.close();
                        rs1 = null;
                    }
                    if (rs2 != null) {
                        rs2.close();
                        rs2 = null;
                    }
                    break block66;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                break block66;
            }
            {
                finally {
                    try {
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        if (stmt1 != null) {
                            stmt1.close();
                            stmt1 = null;
                        }
                        if (stmt2 != null) {
                            stmt2.close();
                            stmt2 = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (rs1 != null) {
                            rs1.close();
                            rs1 = null;
                        }
                        if (rs2 != null) {
                            rs2.close();
                            rs2 = null;
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        String errStringJson = this.getErrorJson(msgNo, msgType, columnName, msgString, msgDescription, msgString, msgOption, msgTime, soundPlay, errSource, redirerr);
        return errStringJson;
    }

    public String getErrorJson(String msgNo, String msgType, String columnName, String message, String msgDescr, String trace, String msgOption, String msgTime, String soundPlay, String errSource, String redirErr) {
        JSONObject errJson = new JSONObject();
        try {
            JSONObject rootJson = new JSONObject();
            JSONArray errors = new JSONArray();
            JSONObject errorJson = new JSONObject();
            JSONObject errorsJson = new JSONObject();
            columnName = E12GenericUtility.checkNull(columnName);
            if (columnName.length() == 0) {
                columnName = "description";
            }
            if ((msgType = E12GenericUtility.checkNull(msgType)).length() == 0) {
                msgType = "E";
            }
            msgOption = E12GenericUtility.checkNull(msgOption);
            msgTime = E12GenericUtility.checkNull(msgTime);
            soundPlay = E12GenericUtility.checkNull(soundPlay);
            errSource = E12GenericUtility.checkNull(errSource);
            if ((redirErr = E12GenericUtility.checkNull(redirErr)).length() == 0) {
                redirErr = "1";
            }
            errorJson.put("message", (Object)message);
            errorJson.put("description", (Object)msgDescr);
            errorJson.put("type", (Object)msgType);
            if (msgOption.length() > 0) {
                errorJson.put("option", (Object)msgOption);
            }
            if (msgTime.length() > 0) {
                errorJson.put("time", (Object)msgTime);
            }
            if (soundPlay.length() > 0) {
                errorJson.put("alarm", (Object)soundPlay);
            }
            if (errSource.length() > 0) {
                errorJson.put("source", (Object)errSource);
            }
            errorJson.put("trace", (Object)trace);
            errorJson.put("redirect", (Object)redirErr);
            errorJson.put("column_name", (Object)columnName);
            errorsJson.put("error", (Object)errorJson);
            errors.put((Object)errorsJson);
            rootJson.put("Errors", (Object)errors);
            errJson.put("Root", (Object)rootJson);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        BaseLogger.log("3", null, null, "getErrorString :: errString line no 9675: [" + errJson + "]");
        return errJson.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyFileWithNewName(String fromPath, String toPath, String newFileName) throws IOException {
        File sourceFile = new File(fromPath);
        if (!sourceFile.exists()) {
            System.err.println("Source file does not exist.");
            return;
        }
        File destinationDirectory = new File(toPath);
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdirs();
        }
        File destinationFile = new File(toPath, newFileName);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                FileInputStream inStream = new FileInputStream(sourceFile);
                try {
                    try (FileOutputStream outStream = new FileOutputStream(destinationFile);){
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                            ((OutputStream)outStream).write(buffer, 0, length);
                        }
                        BaseLogger.log("3", null, null, "File copied successfully to: " + destinationFile.getAbsolutePath());
                    }
                    if (inStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inStream == null) throw throwable;
                    ((InputStream)inStream).close();
                    throw throwable;
                }
                ((InputStream)inStream).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Error copying the file: " + e.getMessage());
        }
    }

    public void createAIApiLog(UserInfoBean userInfo, int noOfPages, String objName, String apiProvider) throws ITMException {
        BaseLogger.log("2", null, null, "createAIApiLog: userInfo: [" + userInfo + "]");
        BaseLogger.log("2", null, null, "createAIApiLog: objName: [" + objName + "]");
        BaseLogger.log("2", null, null, "createAIApiLog: apiProvider: [" + apiProvider + "]");
        Connection conn = null;
        ResultSet rs = null;
        Statement pstmt = null;
        String tranId = "";
        int requestCount = 1;
        String serverIp = "";
        try {
            try {
                int updateCount = 0;
                String userTranID = "";
                String transDB = userInfo.getTransDB();
                String userID = userInfo.getLoginCode();
                String enterprise = userInfo.getEnterprise();
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                String addUser = userInfo.getLoginCode();
                String addTerm = userInfo.getRemoteHostName();
                if (addTerm != null && addTerm.length() > 15) {
                    addTerm = addTerm.substring(0, 15);
                } else if (addTerm == null || addTerm.length() == 0) {
                    addTerm = userInfo.getRemoteHost();
                }
                serverIp = this.getAppServerIPAddr();
                BaseLogger.log("2", userInfo, null, "E12GenericUtility.callOpenAiLog() userID:[" + userID + "]");
                TransIDGenerator tranIDGenerator = new TransIDGenerator("<Root></Root>", userID, CommonConstants.DB_NAME);
                userTranID = tranIDGenerator.generateTranSeqID("AILOG", "TRAN_ID", "_seq15", conn);
                String insertQry = "INSERT INTO AI_API_LOG (TRAN_ID, OBJ_NAME, ENTERPRISE, API_PROVIDER, REQUEST_COUNT, NO_OF_PAGES, SERVER_IP,CHG_USER,CHG_DATE,CHG_TERM) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                pstmt = conn.prepareStatement(insertQry);
                pstmt.setString(1, userTranID);
                pstmt.setString(2, objName);
                pstmt.setString(3, enterprise);
                pstmt.setString(4, apiProvider);
                pstmt.setInt(5, requestCount);
                pstmt.setInt(6, noOfPages);
                pstmt.setString(7, serverIp);
                pstmt.setString(8, addUser);
                pstmt.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(10, addTerm);
                updateCount = pstmt.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in callOpenAiLog [" + e.getMessage() + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("3", null, null, "Exception in callOpenAiLog :" + e.getMessage());
            }
        }
    }

    public String getAppServerIPAddr() throws Exception {
        String ipAddr = "";
        try {
            Enumeration<NetworkInterface> b = NetworkInterface.getNetworkInterfaces();
            while (b.hasMoreElements()) {
                for (InterfaceAddress f : b.nextElement().getInterfaceAddresses()) {
                    if (!f.getAddress().isSiteLocalAddress()) continue;
                    ipAddr = f.getAddress().toString();
                }
            }
            BaseLogger.log("3", null, null, "ipAddr =[" + ipAddr + "]");
            if (ipAddr.startsWith("\"") || ipAddr.startsWith("/")) {
                ipAddr = ipAddr.substring(1, ipAddr.length());
            }
            BaseLogger.log("3", null, null, "ipAddr1 =[" + ipAddr + "]");
            if (ipAddr == null || ipAddr.trim().length() == 0) {
                InetAddress inetAddress = InetAddress.getLocalHost();
                String hostName = inetAddress.getHostName();
                ipAddr = inetAddress.getHostAddress();
                BaseLogger.log("3", null, null, "hostName =[" + hostName + "]");
            }
            BaseLogger.log("3", null, null, "ipAddr2 =[" + ipAddr + "]");
        }
        catch (SocketException se) {
            se.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ipAddr;
    }

    public int getPDFNumberOfPages(InputStream pdfFileStream) {
        int noOfPages = 0;
        try {
            PdfReader pdfReader = new PdfReader(pdfFileStream);
            noOfPages = pdfReader.getNumberOfPages();
        }
        catch (IOException ex) {
            BaseLogger.log("0", null, null, "IOException in DocumentHandlerServlet :: getPDFNumberOfPages() : " + ex);
        }
        catch (Throwable throwable) {
            BaseLogger.log("0", null, null, "Exception or Error in DocumentHandlerServlet :: getPDFNumberOfPages() : " + throwable);
            BaseLogger.log("0", null, null, "The PDF file may be password protected or locked from copying, printing and modifying etc.\nFor error detailing, refer below stack trace");
            String stackTrace = this.buildStackTrace(throwable);
            BaseLogger.log("0", null, null, stackTrace);
        }
        BaseLogger.log("2", null, null, "DocumentHandlerServlet :: getPDFPageCount() : noOfPages [" + noOfPages + "]");
        return noOfPages;
    }

    private String buildStackTrace(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elements = ex.getStackTrace();
        sb.append(String.format("%s : %s\n", ex.getClass().getSimpleName(), ex.getMessage()));
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append(String.format("\tat %s\n", element.toString()));
            ++n2;
        }
        return sb.toString();
    }

    public String isRequestLimitExceeded(String enterprise, String format, UserInfoBean userInfo) throws ITMException {
        String errMessage = "";
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        String sql = "";
        try {
            try {
                int aiProcCount = 0;
                int noOfPages = 0;
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                sql = "SELECT AI_PROC_LIMIT FROM ENTERPRISE WHERE ENTERPRISE=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, enterprise);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    aiProcCount = rs.getInt(1);
                    BaseLogger.log("3", userInfo, null, "aiProcCount :" + aiProcCount + ":");
                }
                pstmt.clearParameters();
                rs.close();
                sql = "";
                sql = "mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT SUM(NO_OF_PAGES) FROM AI_API_LOG WHERE MONTH(CHG_DATE) = MONTH(GETDATE()) AND ENTERPRISE=?" : ("mysql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT SUM(NO_OF_PAGES) FROM AI_API_LOG WHERE MONTH(CHG_DATE) = MONTH(CURDATE()) AND ENTERPRISE=?" : "SELECT SUM(NO_OF_PAGES) FROM AI_API_LOG WHERE EXTRACT(MONTH FROM CHG_DATE) = EXTRACT(MONTH FROM SYSDATE) AND ENTERPRISE=?");
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, enterprise);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    noOfPages = rs.getInt(1);
                    BaseLogger.log("3", userInfo, null, "noOfPages:" + noOfPages + ":");
                }
                if (aiProcCount == 0) {
                    errMessage = "xml".equalsIgnoreCase(format) ? this.getErrorString("", "AINTCONFIG", userInfo.getLoginCode()) : this.getErrorJson("", "AINTCONFIG", userInfo.getLoginCode());
                } else if (aiProcCount >= 0 && aiProcCount < noOfPages) {
                    errMessage = "xml".equalsIgnoreCase(format) ? this.getErrorString("", "AIREQEXCD", userInfo.getLoginCode()) : this.getErrorJson("", "AIREQEXCD", userInfo.getLoginCode());
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in  isRequestLimitExceeded[" + e.getMessage() + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception in :isRequestLimitExceeded:finally " + e.getMessage());
            }
        }
        System.out.println("E12GenericUtility.isRequestLimitExceeded() errMessage:[" + errMessage + "]");
        return errMessage;
    }

    public String getCumulativeLoggedInTimeForTheDay(String userID, String transDB) throws SQLException {
        String result = "";
        BaseLogger.log("3", null, null, "getCumulativeLoggedInTimeForTheDay userID: [" + userID + "]");
        BaseLogger.log("3", null, null, "getCumulativeLoggedInTimeForTheDay transDB: [" + transDB + "]");
        Connection connection = null;
        Statement getCumulativeLoggedInTimeForTheDayPS = null;
        ResultSet getCumulativeLoggedInTimeForTheDayRS = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(transDB);
                String getCumulativeLoggedInTimeForTheDaySQL = "SELECT SUM( ROUND( (CAST( LOGOUTTIME AS DATE) - CAST( LOGINTIME  AS DATE)) * 24 * 60  ) ) AS TOTAL_LOGGED_IN_TIME_IN_MINUTES FROM LOGINTRACE WHERE LOGINTIME >= TRUNC(SYSDATE) AND USERID = ?";
                getCumulativeLoggedInTimeForTheDayPS = connection.prepareStatement(getCumulativeLoggedInTimeForTheDaySQL);
                getCumulativeLoggedInTimeForTheDayPS.setString(1, userID);
                getCumulativeLoggedInTimeForTheDayRS = getCumulativeLoggedInTimeForTheDayPS.executeQuery();
                while (getCumulativeLoggedInTimeForTheDayRS.next()) {
                    String totalLoggedinTimeInMinutes = getCumulativeLoggedInTimeForTheDayRS.getString("TOTAL_LOGGED_IN_TIME_IN_MINUTES");
                    if (E12GenericUtility.checkNull(totalLoggedinTimeInMinutes).equalsIgnoreCase("")) {
                        totalLoggedinTimeInMinutes = "0";
                    }
                    BaseLogger.log("3", null, null, "TOTAL_LOGGED_IN_TIME_IN_MINUTES: [" + totalLoggedinTimeInMinutes + "]");
                    result = totalLoggedinTimeInMinutes;
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (getCumulativeLoggedInTimeForTheDayRS != null) {
                        getCumulativeLoggedInTimeForTheDayRS.close();
                        getCumulativeLoggedInTimeForTheDayRS = null;
                    }
                    if (getCumulativeLoggedInTimeForTheDayPS != null) {
                        getCumulativeLoggedInTimeForTheDayPS.close();
                        getCumulativeLoggedInTimeForTheDayPS = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (getCumulativeLoggedInTimeForTheDayRS != null) {
                    getCumulativeLoggedInTimeForTheDayRS.close();
                    getCumulativeLoggedInTimeForTheDayRS = null;
                }
                if (getCumulativeLoggedInTimeForTheDayPS != null) {
                    getCumulativeLoggedInTimeForTheDayPS.close();
                    getCumulativeLoggedInTimeForTheDayPS = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void jmsLog(String jmsData, String sendStatus, String recvdStatus, String msgType) throws Exception {
        Object parts;
        Object pair;
        Object childNode;
        int i;
        BaseLogger.log("3", null, null, "E12GenericUtility.jmsLog() => jmsData : [" + jmsData + "]");
        if (jmsData == null || jmsData.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid input! jmsData is " + (jmsData == null ? "null" : "empty"));
        }
        BaseLogger.log("3", null, null, "sendStatus: [" + sendStatus + "] & recvdStatus : [" + recvdStatus + "] & msgType : [" + msgType + "]");
        Object[] inputArr = jmsData.split("!~~!");
        BaseLogger.log("3", null, null, "inputArr => " + Arrays.toString(inputArr));
        BaseLogger.log("3", null, null, "inputArr.length => [" + inputArr.length + "]");
        Object objName = "";
        Object action = "";
        String transDB = "";
        String loginCode = "";
        String chgTerm = "";
        UserInfoBean userInfo = null;
        Object refId = msgType.equals("WORKFLOW") ? inputArr[2] : "";
        String xmlString = msgType.equals("UPDATE_DIRTY_DATAMODEL") ? inputArr[1] : "";
        BaseLogger.log("3", null, null, "xmlString : [" + xmlString + "]");
        if (!xmlString.trim().isEmpty()) {
            Document doc = this.parseString(xmlString);
            NodeList parentNodeList = doc.getElementsByTagName("Detail1");
            BaseLogger.log("3", null, null, "parentNodeList length : " + parentNodeList.getLength());
            Node parentNode = parentNodeList.item(0);
            BaseLogger.log("3", null, null, "parentNodeName : " + parentNode.getNodeName());
            NodeList childNodeList = parentNode.getChildNodes();
            BaseLogger.log("3", null, null, "childNodeList length : " + childNodeList.getLength());
            i = 1;
            while (i < childNodeList.getLength()) {
                childNode = childNodeList.item(i);
                if (childNode.getFirstChild() != null) {
                    BaseLogger.log("3", null, null, String.valueOf(childNode.getNodeName()) + " : " + childNode.getFirstChild().getNodeValue());
                    if (childNode.getNodeName().equalsIgnoreCase("tran_id")) {
                        refId = childNode.getFirstChild().getNodeValue();
                        break;
                    }
                }
                ++i;
            }
        }
        BaseLogger.log("3", null, null, "refId : " + (String)refId);
        switch (msgType) {
            case "WORKFLOW": {
                BaseLogger.log("3", null, null, "jmsLog => WORKFLOW");
                userInfo = new UserInfoBean((String)inputArr[3]);
                objName = inputArr[0];
                action = "WORKFLOW";
                break;
            }
            case "UPDATE_DIRTY_DATAMODEL": {
                BaseLogger.log("3", null, null, "jmsLog => UPDATE_DIRTY_DATAMODEL");
                userInfo = new UserInfoBean((String)inputArr[3]);
                objName = inputArr[0];
                action = "UPDT_DRTY_DTMOD";
                break;
            }
            case "FOLLOWUP_ACTIONS": {
                BaseLogger.log("3", null, null, "jmsLog => FOLLOWUP_ACTIONS");
                userInfo = new UserInfoBean((String)inputArr[7]);
                String[] strArray = ((String)inputArr[6]).split("~~");
                childNode = strArray;
                i = strArray.length;
                int n = 0;
                while (n < i) {
                    pair = childNode[n];
                    parts = ((String)pair).split("=");
                    if (((String[])parts).length == 2 && parts[0].equals("chgTerm")) {
                        chgTerm = parts[1];
                        break;
                    }
                    ++n;
                }
                objName = inputArr[1];
                refId = inputArr[4];
                action = inputArr[5];
                break;
            }
            default: {
                BaseLogger.log("3", null, null, "default >> MsgType :: [" + msgType + "]");
            }
        }
        if (userInfo != null) {
            loginCode = userInfo.getLoginCode();
            transDB = userInfo.getTransDB();
        }
        BaseLogger.log("3", null, null, "jmsLog => transDB : [" + transDB + "]");
        BaseLogger.log("3", null, null, "refId : [" + (String)refId + "] & objName : [" + (String)objName + "] & action : [" + (String)action + "]");
        String query = "SELECT COUNT(1) AS COUNT FROM jms_logs WHERE obj_name = ? AND action_name = ? AND ref_id = ? ";
        if (refId == null || ((String)refId).trim().isEmpty()) {
            BaseLogger.log("3", null, null, "Changing query...");
            query = "SELECT COUNT(1) AS COUNT FROM jms_logs WHERE obj_name = ? AND action_name = ? AND ref_id IS NULL ";
        }
        try {
            pair = null;
            Object var17_19 = null;
            try {
                Connection conn = new ConnDriver().getConnectDB(transDB);
                try {
                    block84: {
                        try (PreparedStatement ps = conn.prepareStatement(query);){
                            ps.setString(1, (String)objName);
                            ps.setString(2, (String)action);
                            if (refId != null && !((String)refId).trim().isEmpty()) {
                                BaseLogger.log("3", null, null, "setting refId param value..");
                                ps.setString(3, (String)refId);
                            }
                            try {
                                parts = null;
                                Object var21_29 = null;
                                try (ResultSet rs = ps.executeQuery();){
                                    if (!rs.next()) break block84;
                                    int count = rs.getInt("COUNT");
                                    BaseLogger.log("3", null, null, "count : [" + count + "]");
                                    java.sql.Date currentDate = new java.sql.Date(System.currentTimeMillis());
                                    BaseLogger.log("3", null, null, "currentDate : [" + currentDate + "] & empCode : [" + loginCode + "] & chgTerm : [" + chgTerm + "]");
                                    if (sendStatus != null && !sendStatus.trim().isEmpty() && count == 0) {
                                        BaseLogger.log("3", null, null, "sendStatus and count == 0");
                                        String insertQuery = "INSERT INTO jms_logs (tran_id, obj_name, ref_id, action_name, jms_data, send_on, send_status, add_date, add_user, add_term) SELECT SUBSTR('0000000000' || JMSLOG_SEQ.nextval, -10) AS tran_id,  ?, ?, ?, ?, ?, ?, ?, ?, ? FROM dual";
                                        Throwable throwable = null;
                                        Object var27_44 = null;
                                        try (PreparedStatement pstmt = conn.prepareStatement(insertQuery);){
                                            pstmt.setString(1, (String)objName);
                                            pstmt.setString(2, (String)refId);
                                            pstmt.setString(3, (String)action);
                                            pstmt.setString(4, jmsData);
                                            pstmt.setDate(5, currentDate);
                                            pstmt.setString(6, sendStatus);
                                            pstmt.setDate(7, currentDate);
                                            pstmt.setString(8, loginCode);
                                            pstmt.setString(9, chgTerm);
                                            int updatedRows = pstmt.executeUpdate();
                                            if (updatedRows == 1) {
                                                conn.commit();
                                                BaseLogger.log("3", null, null, "log is added in jms_logs..");
                                            }
                                            break block84;
                                        }
                                        catch (Throwable throwable2) {
                                            if (throwable == null) {
                                                throwable = throwable2;
                                                throw throwable;
                                            } else {
                                                if (throwable == throwable2) throw throwable;
                                                throwable.addSuppressed(throwable2);
                                            }
                                            throw throwable;
                                        }
                                    }
                                    if (sendStatus != null && !sendStatus.trim().isEmpty() && count == 1) {
                                        BaseLogger.log("3", null, null, "sendStatus and count == 1");
                                        String updateQuery = "UPDATE jms_logs SET send_status = ?, chg_date = ?, chg_user = ?, chg_term = ? WHERE obj_name = ? AND action_name = ? AND ref_id = ? ";
                                        if (refId == null || ((String)refId).trim().isEmpty()) {
                                            BaseLogger.log("3", null, null, "Changing query..");
                                            updateQuery = "UPDATE jms_logs SET send_status = ?, chg_date = ?, chg_user = ?, chg_term = ? WHERE obj_name = ? AND action_name = ? AND ref_id IS NULL ";
                                        }
                                        Throwable throwable = null;
                                        Object var27_46 = null;
                                        try (PreparedStatement pstmt = conn.prepareStatement(updateQuery);){
                                            int updatedRows;
                                            pstmt.setString(1, sendStatus);
                                            pstmt.setDate(2, currentDate);
                                            pstmt.setString(3, loginCode);
                                            pstmt.setString(4, chgTerm);
                                            pstmt.setString(5, (String)objName);
                                            pstmt.setString(6, (String)action);
                                            if (!msgType.equals("WORKFLOW") && !msgType.equals("UPDATE_DIRTY_DATAMODEL") || refId != null && !((String)refId).trim().isEmpty()) {
                                                pstmt.setString(7, (String)refId);
                                            }
                                            if ((updatedRows = pstmt.executeUpdate()) == 1) {
                                                conn.commit();
                                                BaseLogger.log("3", null, null, "log updated in jms_logs..");
                                            }
                                            break block84;
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable == null) {
                                                throwable = throwable3;
                                                throw throwable;
                                            } else {
                                                if (throwable == throwable3) throw throwable;
                                                throwable.addSuppressed(throwable3);
                                            }
                                            throw throwable;
                                        }
                                    }
                                    if (recvdStatus == null || recvdStatus.trim().isEmpty() || count != 1) break block84;
                                    BaseLogger.log("3", null, null, "recvdStatus and count == 1");
                                    String updateQuery = "UPDATE jms_logs SET recvd_on = ?, rcvd_status = ?, chg_date = ?, chg_user = ?, chg_term = ? WHERE obj_name = ? AND action_name = ? AND ref_id = ? ";
                                    if (refId == null || ((String)refId).trim().isEmpty()) {
                                        BaseLogger.log("3", null, null, "Changing query..");
                                        updateQuery = "UPDATE jms_logs SET recvd_on = ?, rcvd_status = ?, chg_date = ?, chg_user = ?, chg_term = ? WHERE obj_name = ? AND action_name = ? AND ref_id IS NULL ";
                                    }
                                    Throwable throwable = null;
                                    Object var27_48 = null;
                                    try (PreparedStatement pstmt = conn.prepareStatement(updateQuery);){
                                        int updatedRows;
                                        pstmt.setDate(1, currentDate);
                                        pstmt.setString(2, recvdStatus);
                                        pstmt.setDate(3, currentDate);
                                        pstmt.setString(4, loginCode);
                                        pstmt.setString(5, chgTerm);
                                        pstmt.setString(6, (String)objName);
                                        pstmt.setString(7, (String)action);
                                        if (!msgType.equals("WORKFLOW") && !msgType.equals("UPDATE_DIRTY_DATAMODEL") || refId != null && !((String)refId).trim().isEmpty()) {
                                            pstmt.setString(8, (String)refId);
                                        }
                                        if ((updatedRows = pstmt.executeUpdate()) == 1) {
                                            conn.commit();
                                            BaseLogger.log("3", null, null, "log updated in jms_logs..");
                                        }
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable == null) {
                                            throwable = throwable4;
                                            throw throwable;
                                        } else {
                                            if (throwable == throwable4) throw throwable;
                                            throwable.addSuppressed(throwable4);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (parts == null) {
                                        parts = throwable;
                                        throw parts;
                                    } else {
                                        if (parts == throwable) throw parts;
                                        ((Throwable)parts).addSuppressed(throwable);
                                    }
                                    throw parts;
                                }
                            }
                            catch (Exception e) {
                                BaseLogger.log("3", null, null, "Exception occur in jmsLogs => " + e);
                                try {
                                    if (conn != null) {
                                        conn.rollback();
                                    }
                                }
                                catch (SQLException rollbackException) {
                                    BaseLogger.log("3", null, null, "Rollback Exception occur in jmsLogs => " + rollbackException);
                                }
                            }
                        }
                    }
                    if (conn == null) return;
                }
                catch (Throwable throwable) {
                    if (pair == null) {
                        pair = throwable;
                    } else if (pair != throwable) {
                        ((Throwable)pair).addSuppressed(throwable);
                    }
                    if (conn == null) throw pair;
                    conn.close();
                    throw pair;
                }
                conn.close();
                return;
            }
            catch (Throwable throwable) {
                if (pair == null) {
                    pair = throwable;
                    throw pair;
                } else {
                    if (pair == throwable) throw pair;
                    ((Throwable)pair).addSuppressed(throwable);
                }
                throw pair;
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception occur in jmsLogs => " + e);
        }
    }

    public static String getFileExtension(String filename) {
        String fileName;
        int dotIndex;
        if (filename == null) {
            return null;
        }
        Path path = Path.of(filename, new String[0]);
        String fileExtension = null;
        if (path.getFileName() != null && (dotIndex = (fileName = path.getFileName().toString()).lastIndexOf(46)) > 0 && dotIndex < fileName.length() - 1) {
            fileExtension = fileName.substring(dotIndex + 1);
        }
        return fileExtension;
    }
}

