package ibase.webitm.ejb.sys;

import java.rmi.RemoteException;	
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.bean.ExtAuthApplicationBean;
import ibase.bean.ExtAuthRespBean;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CryptographyUtil;
import ibase.utility.E12GenericUtility;
import ibase.utility.GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.RestAPIServiceUtility;
import org.json.JSONObject;

@Stateless
public class ApplicationApi extends ValidatorEJB {
	GenericUtility genericUtility = GenericUtility.getInstance();
	String userId = "";

	public String wfValData() throws RemoteException, ITMException {
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException {

		BaseLogger.log("3", null, null, "Edit Flag value=" + editFlag);
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;

		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try {
			BaseLogger.log("3", null, null, "wfValData value of xmlString [" + xmlString + "]");
			//BaseLogger.log("3", null, null,"wfValData value of xmlString [" + xmlString1 + "]");
			BaseLogger.log("3", null, null, "wfValData value of xmlString [" + xmlString2 + "]");
			if (xmlString != null && xmlString.trim().length() != 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			BaseLogger.log("3", null, null, "ErrString: " + errString);
		} catch (Exception e) {
			BaseLogger.log("3", null, null, "Exception: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		BaseLogger.log("3", null, null, "Returning from  wfValData errString=[" + errString + "]");
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException {
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		UserInfoBean userInfo = super.getUserInfo();
		int ctr = 0, currentFormNo = 0, childNodeListLenght = 0;
		String childNodeName = null;
		String updateFlag = "";
		//String childNodeValue = null;
		String errString = "";
		//String errCode = "";
		String userId = "";
//		String loginSite = "";
		try {
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
//			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}
			BaseLogger.log("3", null, userInfo.getLoginCode(), "*************Validation for empty inputs Formno=" + currentFormNo);
			switch (currentFormNo) {
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);

				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLenght = childNodeList.getLength();

				for (ctr = 0; ctr < childNodeListLenght; ctr++) {
					childNode = childNodeList.item(ctr);
					BaseLogger.log("3", null, null, "Child Node=>" + ctr + "=>" + childNode);
					childNodeName = childNode.getNodeName().trim();
					BaseLogger.log("3", null, null, "Child Node Name=>" + ctr + "=>" + childNodeName);
					BaseLogger.log("3", null, null,
							"Child Node Value=>" + ctr + "=>" + genericUtility.getColumnValue(childNodeName, dom));

					if (childNodeName.equalsIgnoreCase("app_id") && editFlag.equalsIgnoreCase("a")) {
						if (checkAppid(genericUtility.getColumnValue("app_id", dom2))) {
							errString = getErrorString("app_id", "EXISTAPPID", userId);
							break;

						}
					} else if (childNodeName.equalsIgnoreCase("eff_from")) {
						Date fromDate = sdf.parse(genericUtility.getColumnValue("eff_from", dom));
						Date toDate = sdf.parse(genericUtility.getColumnValue("valid_upto", dom));
						if (fromDate.compareTo(toDate) > 0) {
							// errString = getErrorString("valid_upto", "VALAPPDATE", userId);
							// break;
						}

					}

				}
				break;
			case 2:
				
				parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
				BaseLogger.log("3", null, null, "Parent node list Size" + parentNodeList.getLength());
				BaseLogger.log("3", null, null, "Current form no" + currentFormNo);
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLenght = childNodeList.getLength();

				for (ctr = 0; ctr < childNodeListLenght; ctr++) {

					childNode = childNodeList.item(ctr);
					BaseLogger.log("3", null, null, "Child Node=>" + ctr + "=>" + childNode);
					childNodeName = childNode.getNodeName().trim();
					BaseLogger.log("3", null, null, "Child Node Name=>" + ctr + "=>" + childNodeName);
					BaseLogger.log("3", null, null,
							"Child Node Value=>" + ctr + "=>" + genericUtility.getColumnValue(childNodeName, dom2));
					if(childNodeName.equalsIgnoreCase("attribute"))
                    {
                        if(childNode.getAttributes().getNamedItem("updateFlag") != null)
                        {
                            updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
                        }
                        System.out.println("updateFlag is:::::::"+updateFlag);
                    }

					if (childNodeName.equalsIgnoreCase("app_id") && editFlag.equalsIgnoreCase("a")) {
						if (checkAppid(genericUtility.getColumnValue("app_id", dom2))) {
							// errString = getErrorString("app_id", "EXISTAPPID", userId);
							// break;
						}
					}
					if (childNodeName.equalsIgnoreCase("user_id") && editFlag.equalsIgnoreCase("a")) {
//						String user = genericUtility.getColumnValue("userupdateFlag_id", dom2);
					}
					if (childNodeName.equalsIgnoreCase("user_id")) {
						userId = checkNull(genericUtility.getColumnValue("user_id", dom));
					}
					//Changes done by Amol s on 13 Feb -24, to apply validation on endpoint field it should not be blank --start
					if (childNodeName.equalsIgnoreCase("endpoint")) 
					{
						String endpoint = checkNull(genericUtility.getColumnValue("endpoint", dom2));
					    BaseLogger.log("3", null, null, "Value of endpoint ::" +endpoint );

					   // endpoint = checkNull(genericUtility.getColumnValue("endpoint", dom));
						
						if (endpoint.equals("")) {
						    BaseLogger.log("3", null, null, "inside the block for -- ::[" +endpoint + "]");

							errString = getErrorString("endpoint", "VMENDPT", userId);
						} 
						
					}
					
					/*if (childNodeName.equalsIgnoreCase("is_external"))
					{
						String isExternal = checkNull(genericUtility.getColumnValue("is_external", dom2));
						if(updateFlag.equalsIgnoreCase("E") && isExternal.equalsIgnoreCase("Y")) 
						{
							errString = getErrorString("endpoint", "VMEXTAER", userId);//Add a entry in messages table
							
						}
					}*/
					
					
				}
				//Changes done by Amol s on 13 Feb -24, to apply validation on endpoint field it should not be blank --end
				BaseLogger.log("3", null, null, "User Id from auth_apps_api=" + userId);
				break;
			case 3:
				parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
				BaseLogger.log("3", null, null, "Current form no" + currentFormNo);
				BaseLogger.log("3", null, null, "Paren node list Size" + parentNodeList.getLength());
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLenght = childNodeList.getLength();
				for (ctr = 0; ctr < childNodeListLenght; ctr++) {
					childNode = childNodeList.item(ctr);
					BaseLogger.log("3", null, null, "Child Node=>" + ctr + "=>" + childNode);
					childNodeName = childNode.getNodeName().trim();
					BaseLogger.log("3", null, null, "Child Node Name=>" + ctr + "=>" + childNodeName);
					BaseLogger.log("3", null, null,
							"Child Node Value=>" + ctr + "=>" + genericUtility.getColumnValue(childNodeName, dom2));
					if (childNodeName.equalsIgnoreCase("app_id") && editFlag.equalsIgnoreCase("a")) {
						if (childNode.getFirstChild() == null
								|| checkEmpty(genericUtility.getColumnValue("app_id", dom2))) {
							errString = getErrorString("app_id", "NULLAPPID", userId);
							break;
						}
					} 
					
					else if (childNodeName.equalsIgnoreCase("enterprise")) {

						String enterprise = genericUtility.getColumnValue("enterprise", dom2);
						String userid = genericUtility.getColumnValue("user_id", dom2);
						if (!checkEnterpriseName(enterprise)) {
							errString = getErrorString("enterprise", "EXAPPENTER", userId);
							break;
						}
						if (checkEnterprise(enterprise, userid)) {
							// errString = getErrorString("user_id", "EXUSER", userId);
							// break;
						}
					} else if (childNodeName.equalsIgnoreCase("channel_id")) {

						String channelId = genericUtility.getColumnValue("channel_id", dom2);
						if (checkChannelID(channelId)) {
							errString = getErrorString("channel_id", "EXCHID", userId);

							break;
						}
					}

				} // end of for
				break;

			}
		} catch (Exception e) {
			e.getMessage();
			e.printStackTrace();
			BaseLogger.log("3", null, null, "Got Error in Validation=>" + e.getMessage());
		}
		BaseLogger.log("3", null, null, "Error String by Ankush==>" + errString + "<=");
		return errString;
		/**/}

	private boolean checkEmpty(String columnValue) {
		if (columnValue.length() <= 0) {
			return true;
		}
		if (columnValue.trim().equals("")) {
			return true;
		}
		return false;
	}

	public String itemChanged() throws RemoteException, ITMException {
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext,
			String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {

		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";
		BaseLogger.log("3", null, null, "Current column in itemchange==>" + currentColumn);
		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				BaseLogger.log("3", null, null, "itemchange header xmlString>>>>" + xmlString);
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				BaseLogger.log("3", null, null, "xmlString1>>>>" + xmlString1);
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				BaseLogger.log("3", null, null, "xmlString2>>>>" + xmlString2);
				dom2 = genericUtility.parseString(xmlString2);
				BaseLogger.log("3", null, null, "dom2:::-" + genericUtility.serializeDom(dom2));
			}

			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);

		} catch (Exception e) {
			BaseLogger.log("3", null, null, "Exception itemChanged::::" + e.getMessage() + ":");
			e.printStackTrace();
		}
		BaseLogger.log("3", null, null, "returning from itemChanged method");

		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws RemoteException, ITMException {
		BaseLogger.log("3", null, null, "itemChanged by Ankush --Ams ");
		BaseLogger.log("3", null, null, "Itemchanged Called");

		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
//		NodeList parentNodeList = null;
//		Node childNode = null;
		String userId = "", enterprise = "";
//		String chgDate = "", chgUser = "", chgTerm = "", addDate = "", addUser = "", addTerm = "";
		String errString = "";
		try {
			BaseLogger.log("3", null, null, "dom: : " + genericUtility.serializeDom(dom));
			BaseLogger.log("3", null, null, "dom1: : " + genericUtility.serializeDom(dom1));
			BaseLogger.log("3", null, null, "dom2: : " + genericUtility.serializeDom(dom2));
			UserInfoBean userInfo = super.getUserInfo();
//			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
//			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
//			ConnDriver conndriver = new ConnDriver();
//			Connection conn = conndriver.getConnectDB("DriverITM");
			if (objContext != null && objContext.trim().length() > 0)
				currentFormNo = Integer.parseInt(objContext);
			BaseLogger.log("3", null, null, "current form no: " + currentFormNo);
			currentColumn = currentColumn == null ? "" : currentColumn.trim();
			BaseLogger.log("3", null, null, "Application API currentColumn : " + currentColumn);
			BaseLogger.log("3", null, null, "Application API editFlag : " + editFlag);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			Date date = new Date();
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(date);
			calendar.add(Calendar.YEAR, 20);
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currentDate = sdf.format(date);
			String validUptoDate = sdf.format(calendar.getTime());

			switch (currentFormNo) {

			case 1:
				valueXmlString.append("<Detail1>");
				if ("itm_default".equalsIgnoreCase(currentColumn.trim())) {

					valueXmlString.append("<eff_from><![CDATA[").append(currentDate).append("]]></eff_from>\r\n");
					valueXmlString.append("<valid_upto><![CDATA[").append(validUptoDate).append("]]></valid_upto>\r\n");

					valueXmlString.append("<shared_key><![CDATA[").append("a3edd11a09ea4e0ccd09c6cd2828021b")
							.append("]]></shared_key>\r\n");

					BaseLogger.log("3", null, null,
							"set current Date " + currentDate + " Valid Upto Date=" + validUptoDate);

				}
				if ("ENABLE_SECURITY".equalsIgnoreCase(currentColumn)) {

					String security = checkNull(genericUtility.getColumnValue("enable_security", dom2));
					valueXmlString.append("<enable_securirty><![CDATA[").append(security)
							.append("]]></enable_securirty>\r\n");
					BaseLogger.log("3", null, null, "Item change enable security=" + security);
					BaseLogger.log("3", null, null, "Item change enable security set="
							+ checkNull(genericUtility.getColumnValue("enable_security", dom2)));
				}
				valueXmlString.append("</Detail1>\r\n");
				// valueXmlString.append("</Root>\r\n");

				break;
			case 2:
				BaseLogger.log("3", null, null, "Application API editFlag  Case 2: " + editFlag);
				valueXmlString.append("<Detail2>");
				String objName = "";
				String serviceClass = "";
				String appId = "";

				if ("itm_defaultedit".equalsIgnoreCase(currentColumn.trim())) {
					serviceClass = checkNull(genericUtility.getColumnValue("service_class", dom));
					objName = checkNull(genericUtility.getColumnValue("obj_name", dom));
					String serviceSetting = checkNull(genericUtility.getColumnValue("service_setting", dom));

					JSONObject jsonObject = new JSONObject(serviceSetting);
					
					String isExternal = "";
					
					if(jsonObject.has("is_External"))
					{
						isExternal = jsonObject.getString("is_External");
					}
					else
					{
						isExternal = "false";
						valueXmlString.append("<service_setting><![CDATA[").append("{\"obj_name\":\"" + objName
								+ "\", \"field_name\":\"CHG_DATE\", \"template_id\":\"\" ,\"field_data_type\": \"DATE\",\"field_data_format\": \"dd-MM-yy\", \"is_External\":\""
								+ isExternal + "\"}").append("]]></service_setting>\r\n");
					}
		
					BaseLogger.log("3", null, null, "isExternal::" + isExternal);
					
					String isExternalValue = isExternal.equalsIgnoreCase("true") ? "Y" : "N";
					
					valueXmlString.append("<descr><![CDATA[").append("Description").append("]]></descr>\r\n");

					String tableName = checkNull(genericUtility.getColumnValue("table_name", dom2));
					String primaryKey = checkNull(genericUtility.getColumnValue("primary_key", dom2));
					BaseLogger.log("3", null, null, "Table Name:" + tableName + " Primary key: " + primaryKey);
					BaseLogger.log("3", null, null, "Application API editFlag  Case 2 Item_defaultedit: " + editFlag);
					valueXmlString.append("<obj_name protect = '1'><![CDATA[").append(objName)
					.append("]]></obj_name>\r\n");
					valueXmlString.append("<service_class protect = '1'><![CDATA[").append(serviceClass)
					.append("]]></service_class>\r\n");
				    valueXmlString.append("<is_external protect ='1'><![CDATA[").append(isExternalValue).append("]]></is_external>\r\n");

				}
				else if ("itm_default".equalsIgnoreCase(currentColumn.trim())) {
					BaseLogger.log("3", null, null, "Application API editFlag  Case 2 Item_default: " + editFlag);
					valueXmlString.append("<user_id><![CDATA[").append(userInfo.getLoginCode())
							.append("]]></user_id>\r\n");

				} else if ("service_class".equalsIgnoreCase(currentColumn.trim())) {
					String isExternal = checkNull(genericUtility.getColumnValue("is_external", dom));
					BaseLogger.log("3", null, null, "isExternal gsb: [" + isExternal + "]");
					// gsb: if the isExternal is true then endpoint itechange should not happen.
					if (!isExternal.equalsIgnoreCase("Y"))  {
						serviceClass = checkNull(genericUtility.getColumnValue("service_class", dom));
						objName = checkNull(genericUtility.getColumnValue("obj_name", dom));
						userId = checkNull(genericUtility.getColumnValue("user_id", dom));
						appId = checkNull(genericUtility.getColumnValue("app_id", dom));
						enterprise = getUserEnterprise(userId);
						String fldValue = checkNull(getFLD_VALUE(serviceClass));
//						String serviceDescription = getDescriptionFromGencodes(fldValue);
						String endpoint = createEndpoint(fldValue,serviceClass, objName, enterprise, appId);
						BaseLogger.log("3", null, null, "fldValue:[" + fldValue + "] serviceDescription:[" + serviceClass
								+ "] objName:[" + objName + "] endpoint:[" + endpoint + "]Enterprise:[" + enterprise);

						// show erroe message if user id is empty
						if (userId.equals("")) {
							errString = getErrorString("user_id", "NULLAPPUSR", userId);
							enterprise = "";
							endpoint = createEndpoint(fldValue,serviceClass, objName, enterprise, appId);
							valueXmlString.append("<endpoint><![CDATA[").append(endpoint).append("]]></endpoint>\r\n");
							return errString;
						}
						// show error if service class is incorrect
						if (fldValue.equals("")) {
							errString = getErrorString("service_class", "NULLAPITYP", userId);
							fldValue = "";
							endpoint = createEndpoint(fldValue,serviceClass, objName, enterprise, appId);
							valueXmlString.append("<endpoint><![CDATA[").append(endpoint).append("]]></endpoint>\r\n");
							return errString;
						}
						
						
						BaseLogger.log("3", null, null, "fldValue:[" + fldValue + "] serviceDescription:[" + serviceClass
								+ "] objName:[" + objName + "] endpoint:[" + endpoint);
						valueXmlString.append("<service_class><![CDATA[").append(fldValue)
								.append("]]></service_class>\r\n");
						valueXmlString.append("<descr><![CDATA[").append(serviceClass).append("]]></descr>\r\n");
						valueXmlString.append("<endpoint><![CDATA[").append(endpoint).append("]]></endpoint>\r\n");
						valueXmlString.append("<service_class_1><![CDATA[").append(serviceClass)
								.append("]]></service_class_1>\r\n");
						BaseLogger.log("3", null, null, "valueXmlString detail 2:[" + valueXmlString);
						if (editFlag.equalsIgnoreCase("E")) {
							BaseLogger.log("3", null, null, "setting For EditFlag");
							valueXmlString.append("<service_class><![CDATA[").append(fldValue)
									.append("]]></service_class>\r\n");
							valueXmlString.append("<descr><![CDATA[").append(serviceClass).append("]]></descr>\r\n");
							valueXmlString.append("<endpoint><![CDATA[").append(endpoint).append("]]></endpoint>\r\n");
						}
						
						
					
					}
					//
					if (isExternal.equalsIgnoreCase("Y")) 
					{
							
						BaseLogger.log("3", null, null, "Inside the Ext block for item_change ");
						serviceClass = checkNull(genericUtility.getColumnValue("service_class", dom));

						String fldValue1 = checkNull(getFLD_VALUE(serviceClass));

						valueXmlString.append("<descr><![CDATA[").append(serviceClass).append("]]></descr>\r\n");
						valueXmlString.append("<service_class_1><![CDATA[").append(serviceClass)
								.append("]]></service_class_1>\r\n");
						if(fldValue1==null || fldValue1.equalsIgnoreCase("")) {
							valueXmlString.append("<service_class><![CDATA[").append(serviceClass)
							.append("]]></service_class>\r\n");
						} else {
						valueXmlString.append("<service_class><![CDATA[").append(fldValue1)
						.append("]]></service_class>\r\n"); 
						}
						
						valueXmlString.append("<endpoint protect='0'><![CDATA[").append("")
						.append("]]></endpoint>\r\n");
					
				} 
				
				
				}
				else if ("obj_name".equalsIgnoreCase(currentColumn.trim())) {
					String isExternal = checkNull(genericUtility.getColumnValue("is_external", dom));
					BaseLogger.log("3", null, null, "isExternal gsb: [" + isExternal + "]");
					
					if (!isExternal.equalsIgnoreCase("Y")) {
						serviceClass = checkNull(genericUtility.getColumnValue("service_class", dom));
						objName = checkNull(genericUtility.getColumnValue("obj_name", dom));
						userId = checkNull(genericUtility.getColumnValue("user_id", dom));
						appId = checkNull(genericUtility.getColumnValue("app_id", dom));
						enterprise = getUserEnterprise(userId);
						String fldValue = checkNull(getFLD_VALUE(serviceClass));
						fldValue = serviceClass;
						serviceClass = checkNull(genericUtility.getColumnValue("service_class_1", dom));
						String endpoint = createEndpoint(fldValue,serviceClass, objName, enterprise, appId);
						BaseLogger.log("3", null, null, "fldValue:[" + fldValue + "] serviceDescription:[" + serviceClass
								+ "] objName:[" + objName + "] endpoint:[" + endpoint + "]Enterprise:[" + enterprise);
						// Object name validation
						if (!checkObject(objName)) {
							errString = getErrorString("obj_name", "NOTOBJ", userId);
							objName = "";
							endpoint = createEndpoint(fldValue,serviceClass, objName, enterprise, appId);
							valueXmlString.append("<endpoint><![CDATA[").append(endpoint).append("]]></endpoint>\r\n");
							valueXmlString.append("<obj_name_1><![CDATA[").append("").append("]]></obj_name_1>\r\n");
							return errString;
						}
						
						if (fldValue.equals("")) {
							errString = getErrorString("service_class", "NULLAPITYP", userId);
							fldValue = "";
							endpoint = createEndpoint(fldValue,serviceClass, objName, enterprise, appId);
							valueXmlString.append("<endpoint><![CDATA[").append("").append("]]></endpoint>\r\n");
							return errString;
						}
						if (userId.equals("")) {
							errString = getErrorString("user_id", "NULLAPPUSR", userId);
							enterprise = "";
							endpoint = createEndpoint(fldValue,serviceClass, objName, enterprise, appId);
							valueXmlString.append("<endpoint><![CDATA[").append("").append("]]></endpoint>\r\n");
							return errString;
						}
						List<String> dataList = getTableAndPrimaryKey(objName);
						BaseLogger.log("3", null, null, "dataList:" + dataList + " DataList Size=" + dataList.size());
						if (dataList.size() == 0) {
							errString = getErrorString("user_id", "NULLTBL", userId);
							BaseLogger.log("3", null, null, "Table name not found obj_name=[" + dataList);

							return errString;
						}
						
						if (dataList.size() > 0 && (dataList.get(0).equals(null) || dataList.get(0).equals("null"))) {
							errString = getErrorString("user_id", "NULLTBL", userId);
							BaseLogger.log("3", null, null, "Table name not found obj_name=[" + dataList);
							valueXmlString.append("<table_name><![CDATA[").append("").append("]]></table_name>\r\n");
							valueXmlString.append("<primary_key><![CDATA[").append("").append("]]></primary_key>\r\n");
							return errString;
						}
						if (dataList.size() > 0) {
							BaseLogger.log("3", null, null, "dataList:" + dataList + " DataList Size=" + dataList.size());
							valueXmlString.append("<table_name><![CDATA[").append(dataList.get(0))
									.append("]]></table_name>\r\n");
							valueXmlString.append("<primary_key><![CDATA[").append(dataList.get(1))
									.append("]]></primary_key>\r\n");
						}
						valueXmlString.append("<endpoint><![CDATA[").append(endpoint).append("]]></endpoint>\r\n");
						valueXmlString.append("<obj_name_1><![CDATA[").append(getObjDescription(objName))
								.append("]]></obj_name_1>\r\n");
						valueXmlString.append("<endpoint><![CDATA[").append(endpoint).append("]]></endpoint>\r\n");
						
						valueXmlString.append("<service_setting><![CDATA[")
						
						.append("{\"obj_name\":\""+objName+"\", \"field_name\":\"CHG_DATE\", \"template_id\":\"\" ,\"field_data_type\": \"DATE\",\"field_data_format\": \"dd-MM-yy\", \"is_External\":\" false\"}")
						.append("]]></service_setting>\r\n");
					}
				
					else if (isExternal.equalsIgnoreCase("Y"))
					{

						objName = checkNull(genericUtility.getColumnValue("obj_name", dom));

						BaseLogger.log("3", null, null, "inside the if block for Y :");

						valueXmlString.append("<service_setting><![CDATA[")

								.append("{\"obj_name\":\"" + objName
										+ "\", \"field_name\":\"CHG_DATE\", \"template_id\":\"\" ,\"field_data_type\": \"DATE\",\"field_data_format\": \"dd-MM-yy\", \"is_External\":\"true\"}")
								.append("]]></service_setting>\r\n");
						valueXmlString.append("<obj_name_1><![CDATA[").append(objName).append("]]></obj_name_1>\r\n");

						

					// validation 
						if (!checkObject(objName)) {
					
							String endpoint = checkNull(genericUtility.getColumnValue("endpoint", dom2));
							String fldValue = checkNull(getFLD_VALUE(serviceClass));
							fldValue = serviceClass;

							errString = getErrorString("obj_name", "NOTOBJ", userId);
							objName = "";
							endpoint = createEndpoint(fldValue, serviceClass, objName, enterprise, appId);
							valueXmlString.append("<obj_name_1><![CDATA[").append("").append("]]></obj_name_1>\r\n");
							return errString;
						}
					}
					
				} 
				else if ("user_id".equalsIgnoreCase(currentColumn.trim())) 
				{
					BaseLogger.log("3", null, null, "User id item change");
					serviceClass = checkNull(genericUtility.getColumnValue("service_class", dom));
					objName = checkNull(genericUtility.getColumnValue("obj_name", dom));
					userId = checkNull(genericUtility.getColumnValue("user_id", dom));
					appId = checkNull(genericUtility.getColumnValue("app_id", dom));
					String userCode = checkNull(genericUtility.getColumnValue("user_id", dom));
					enterprise = getUserEnterprise(userCode);
					String fldValue = checkNull(getFLD_VALUE(serviceClass));
					fldValue = serviceClass;
					String endpoint = "";

					if (!checkUserCode(userCode)) {
						errString = getErrorString("user_id", "NOTUSR", userId);
						enterprise = "";
						endpoint = createEndpoint(fldValue,serviceClass, objName, enterprise, appId);
						valueXmlString.append("<endpoint><![CDATA[").append(endpoint).append("]]></endpoint>\r\n");
						return errString;
					}
					endpoint = createEndpoint(fldValue,serviceClass, objName, enterprise, appId);
					valueXmlString.append("<endpoint><![CDATA[").append(endpoint).append("]]></endpoint>\r\n");
					BaseLogger.log("3", null, null, "fldValue:[" + fldValue + "] serviceDescription:[" + serviceClass
							+ "] objName:[" + objName + "] endpoint:[" + endpoint + "]Enterprise:[" + enterprise);

				} else if ("req_data_format".equals(currentColumn.trim())) {
					String dataFormat = checkNull(genericUtility.getColumnValue("req_data_format", dom));
					valueXmlString.append("<resp_data_format><![CDATA[").append(dataFormat)
							.append("]]></resp_data_format>\r\n");
					BaseLogger.log("3", null, null, "Data Format set" + dataFormat);
				} else if ("endpoint".equalsIgnoreCase(currentColumn)) {
					String endpoint = checkNull(genericUtility.getColumnValue("endpoint", dom2));
					valueXmlString.append("<endpoint><![CDATA[").append(endpoint).append("]]></endpoint>\r\n");
				}
				
				
				/* Changes done  by Amol S on 8-Feb-24 ,itemchnage for is_external field ,if is_external is Y 
				 * is_External=true is append to the service_setting, and endpoint becomes blank and API Type field validation get removed --start

				*/
				else if ("is_external".equalsIgnoreCase(currentColumn))
				{
					String isExternal = checkNull(genericUtility.getColumnValue("is_external", dom));
					String updateFlag = getupdateFlag(dom2);
					BaseLogger.log("3", null, null, "Value of Is_External" + isExternal);

					serviceClass = checkNull(genericUtility.getColumnValue("service_class", dom));
					objName = checkNull(genericUtility.getColumnValue("obj_name", dom));
					userId = checkNull(genericUtility.getColumnValue("user_id", dom));
					appId = checkNull(genericUtility.getColumnValue("app_id", dom));
                    String reqType = checkNull(genericUtility.getColumnValue("req_data_format", dom));
					String userCode = checkNull(genericUtility.getColumnValue("user_id", dom));
					enterprise = getUserEnterprise(userCode);

					BaseLogger.log("3", null, null, "Insidee the Is_External");

					String isExternalValue = isExternal.equalsIgnoreCase("Y") ? "true" : "false";

					valueXmlString.append("<service_setting><![CDATA[").append("{\"obj_name\":\"" + objName
							+ "\", \"field_name\":\"CHG_DATE\", \"template_id\":\"\" ,\"field_data_type\": \"DATE\",\"field_data_format\": \"dd-MM-yy\", \"is_External\":\""
							+ isExternalValue + "\"}").append("]]></service_setting>\r\n");

					String endpoint = checkNull(genericUtility.getColumnValue("endpoint", dom2));
					BaseLogger.log("3", null, null, "Value of endpoint ::" + endpoint);

					if (isExternal.equalsIgnoreCase("N")) {
						BaseLogger.log("3", null, null, "isExternal is N");
						String fldValue = checkNull(getFLD_VALUE(serviceClass));
						fldValue = serviceClass;
						//endpoint = createEndpoint(fldValue, serviceClass, objName, enterprise, appId);
						BaseLogger.log("3", null, null, "Value of endpoint gsb ::[" + endpoint + "]");

						valueXmlString.append("<endpoint protect='1'><![CDATA[").append(endpoint)
								.append("]]></endpoint>\r\n");
                        valueXmlString.append("<service_class><![CDATA[").append(serviceClass).append("]]></service_class>\r\n");
					    valueXmlString.append("<req_data_format><![CDATA[").append(reqType).append("]]></req_data_format>\r\n");
					    valueXmlString.append("<obj_name><![CDATA[").append(objName).append("]]></obj_name>\r\n");
					    valueXmlString.append("<obj_name_1><![CDATA[").append(getObjDescription(objName)).append("]]></obj_name_1>\r\n");
					    valueXmlString.append("<service_class_1><![CDATA[").append(fldValue).append("]]></service_class_1>\r\n");
					}
					
					else if (isExternal.equalsIgnoreCase("N") && updateFlag.equalsIgnoreCase("N")) {
						BaseLogger.log("3", null, null, "isExternal is N");
						String fldValue = checkNull(getFLD_VALUE(serviceClass));
						fldValue = serviceClass;
						//endpoint = createEndpoint(fldValue, serviceClass, objName, enterprise, appId);
						BaseLogger.log("3", null, null, "Value of endpoint gsb ::[" + endpoint + "]");

						valueXmlString.append("<endpoint protect='1'><![CDATA[").append(endpoint)
								.append("]]></endpoint>\r\n");
                        valueXmlString.append("<service_class><![CDATA[").append(serviceClass).append("]]></service_class>\r\n");
					    valueXmlString.append("<req_data_format><![CDATA[").append(reqType).append("]]></req_data_format>\r\n");
					    valueXmlString.append("<obj_name><![CDATA[").append(objName).append("]]></obj_name>\r\n");
					    valueXmlString.append("<obj_name_1><![CDATA[").append(getObjDescription(objName)).append("]]></obj_name_1>\r\n");
					    valueXmlString.append("<service_class_1><![CDATA[").append(fldValue).append("]]></service_class_1>\r\n");
					}

					//else if (isExternal.equalsIgnoreCase("Y") && editFlag.equalsIgnoreCase("A")) {
                    else if (isExternal.equalsIgnoreCase("Y") && updateFlag.equalsIgnoreCase("A")) {
						BaseLogger.log("3", null, null, "Application API editFlag when isExternal Y : " + editFlag);

						BaseLogger.log("3", null, null, "inside the if block for Y ::[" + endpoint + "]");
                        valueXmlString.append("<service_setting><![CDATA[").append("{\"obj_name\":\"" + ""
							    + "\", \"field_name\":\"CHG_DATE\", \"template_id\":\"\" ,\"field_data_type\": \"DATE\",\"field_data_format\": \"dd-MM-yy\", \"is_External\":\""
							    + isExternalValue + "\"}").append("]]></service_setting>\r\n");
					    valueXmlString.append("<service_class><![CDATA[").append("").append("]]></service_class>\r\n");
					    valueXmlString.append("<req_data_format><![CDATA[").append("").append("]]></req_data_format>\r\n");
					    valueXmlString.append("<obj_name><![CDATA[").append("").append("]]></obj_name>\r\n");
					    valueXmlString.append("<obj_name_1><![CDATA[").append("").append("]]></obj_name_1>\r\n");
					    valueXmlString.append("<service_class_1><![CDATA[").append("").append("]]></service_class_1>\r\n");

						valueXmlString.append("<endpoint protect='0'><![CDATA[").append("")
								.append("]]></endpoint>\r\n");

					}
                    /*else if (isExternal.equalsIgnoreCase("Y") && updateFlag.equalsIgnoreCase("N")) {
                    	
						BaseLogger.log("3", null, null, "Application API editFlag when isExternal Y : " + editFlag);

						BaseLogger.log("3", null, null, "inside the if block for Y ::[" + endpoint + "]");
                        valueXmlString.append("<service_setting><![CDATA[").append("{\"obj_name\":\"" + ""
							    + "\", \"field_name\":\"CHG_DATE\", \"template_id\":\"\" ,\"field_data_type\": \"DATE\",\"field_data_format\": \"dd-MM-yy\", \"is_External\":\""
							    + isExternalValue + "\"}").append("]]></service_setting>\r\n");
					    valueXmlString.append("<service_class><![CDATA[").append("").append("]]></service_class>\r\n");
					    valueXmlString.append("<req_data_format><![CDATA[").append("").append("]]></req_data_format>\r\n");
					    valueXmlString.append("<obj_name><![CDATA[").append("").append("]]></obj_name>\r\n");
					    valueXmlString.append("<obj_name_1><![CDATA[").append("").append("]]></obj_name_1>\r\n");
					    valueXmlString.append("<service_class_1><![CDATA[").append("").append("]]></service_class_1>\r\n");

						valueXmlString.append("<endpoint protect='0'><![CDATA[").append("")
								.append("]]></endpoint>\r\n");
						errString = getErrorString("is_external", "VMEXTAER", userId);
						return errString;
					}

					//else if (isExternal.equalsIgnoreCase("Y") && editFlag.equalsIgnoreCase("E")) {
					else if (isExternal.equalsIgnoreCase("Y") && updateFlag.equalsIgnoreCase("E")) {
						BaseLogger.log("3", null, null, "Inside ye gsb " + editFlag);
                        
                        valueXmlString.append("<service_setting><![CDATA[").append("{\"obj_name\":\"" + ""
							    + "\", \"field_name\":\"CHG_DATE\", \"template_id\":\"\" ,\"field_data_type\": \"DATE\",\"field_data_format\": \"dd-MM-yy\", \"is_External\":\""
							    + isExternalValue + "\"}").append("]]></service_setting>\r\n");
					    valueXmlString.append("<req_data_format><![CDATA[").append("").append("]]></req_data_format>\r\n");
					    valueXmlString.append("<obj_name_1><![CDATA[").append("").append("]]></obj_name_1>\r\n");
					    valueXmlString.append("<service_class_1><![CDATA[").append("").append("]]></service_class_1>\r\n");

						valueXmlString.append("<endpoint protect='1'><![CDATA[").append("")
								.append("]]></endpoint>\r\n");
						valueXmlString.append("<service_class protect='1'><![CDATA[").append("")
								.append("]]></service_class>\r\n");
						valueXmlString.append("<obj_name protect='0'><![CDATA[").append("")
								.append("]]></obj_name>\r\n");
						errString = getErrorString("is_external", "VMEXTAER", userId);
						

						BaseLogger.log("3", null, null, "inside the if block for Y ::[" + endpoint + "]");
						
						
						return errString;

					}*/
				}
				/* Changes done  by Amol S on 8-Feb-24 ,itemchnage for is_external field ,if is_external is Y 
				 * is_External=true is append to the service_setting, and endpoint becomes blank and API Type field validation get removed --end

				*/
				//errString = getErrorString("obj_name", "NOTOBJ", userId);

				valueXmlString.append("</Detail2>");
				BaseLogger.log("3", null, null, "value xml string for detail2" + valueXmlString);
				break;

			case 3:
				valueXmlString.append("<Detail3>");
				if ("itm_default".equalsIgnoreCase(currentColumn.trim())) {
					ExtAuthApplicationBean applicationBean = getExtAuthApplicationInfo(dom1);
					BaseLogger.log("3", null, null, "Application Bean=[" + applicationBean);
					String tokenId = getJWTToken(userInfo.getLoginCode(), applicationBean);
					BaseLogger.log("3", null, null, "tOKEN iD:::::[" + tokenId);

					NodeList detailList = dom2.getElementsByTagName("Detail2");

					NodeList detailChildList = detailList.item(0).getChildNodes();
					for (int index = 0; index < detailChildList.getLength(); index++) {
						Node dataNode = detailChildList.item(index);
						if (dataNode.getNodeName().equalsIgnoreCase("user_id")) {
							userId = dataNode.getFirstChild().getNodeValue();
						}
					}

					valueXmlString.append("<user_id><![CDATA[").append(userId).append("]]></user_id>\r\n");
					valueXmlString.append("<enterprise><![CDATA[").append(getUserEnterprise(userId))
							.append("]]></enterprise>\r\n");
					valueXmlString.append("<enterprise_id><![CDATA[").append(getUserEnterprise(userId))
							.append("]]></enterprise_id>\r\n");
					valueXmlString.append("<username><![CDATA[").append(userId).append("]]></username>\r\n");
					valueXmlString.append("<token_id><![CDATA[").append(tokenId).append("]]></token_id>\r\n");
					valueXmlString.append("<user_type><![CDATA[").append(getUserType(userId)).append("]]></user_type>\r\n");

				}

				valueXmlString.append("</Detail3>");

				break;
			}
			valueXmlString.append("</Root>\r\n");

		} catch (Exception e) {
			BaseLogger.log("3", null, null, e.getMessage());
		}
		BaseLogger.log("3", null, null, "\n****ValueXmlString By Ankush :" + valueXmlString + ":********");
		
		return valueXmlString.toString();
	}

	private Object getUserType(String userId) {
		String userType="";
		try {
			String sql = "SELECT USER_TYPE FROM USERS WHERE CODE='" + userId + "'";

			Connection conn = getConnection();
			Statement pstmt = conn.createStatement();
			ResultSet rs = pstmt.executeQuery(sql);
			if (rs.next()) {
				userType = rs.getString("USER_TYPE");
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			conn.close();
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
		return userType;
	}

	private String getUserEnterprise(String userId) {
		try {
			String enterprise = "";
			String sql = "SELECT ENTERPRISE FROM USERS WHERE CODE='" + userId + "'";

			Connection conn = getConnection();
			Statement pstmt = conn.createStatement();
			ResultSet rs = pstmt.executeQuery(sql);
			if (rs.next()) {
				enterprise = rs.getString("ENTERPRISE");
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			conn.close();
			return enterprise;
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}

	private String getFLD_VALUE(String serviceDescr) {
		String fldValue = "";
		
		try {

			String sql = "SELECT FLD_VALUE FROM GENCODES WHERE DESCR='" + serviceDescr + "'";
			Connection conn = getConnection();
			Statement pstmt = conn.createStatement();
			ResultSet rs = pstmt.executeQuery(sql);
			if (rs.next()) {
				fldValue = rs.getString("FLD_VALUE");
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			conn.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		// if(fldValue.equalsIgnoreCase("writeFileSaveTrans")||fldValue.equalsIgnoreCase("writeFile")) fldValue="fileWrite";
		return fldValue;
	}

	private boolean checkChannelID(String channelId) {
		Connection connectionObject = null;
		Statement stmt = null;
		try {
			connectionObject = getConnection();
			String sql = "SELECT * FROM USER_ACC_CHANNEL WHERE CHANNEL_ID='" + channelId + "'";
			stmt = connectionObject.createStatement();
			ResultSet rs = stmt.executeQuery(sql);
			if (rs.next())
				return true;
			else
				return false;
		} catch (Exception e) {
			return false;
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (connectionObject != null) {
					connectionObject.close();
					connectionObject = null;
				}
			} catch (Exception e) {
				BaseLogger.log("3", null, null, e.getMessage());
			}

		}
	}

	private boolean checkEnterprise(String enterprise, String userId) {
		Connection connectionObject = null;
		Statement stmt = null;
		try {
			connectionObject = getConnection();
			String sql = "SELECT * FROM USER_ACC_CHANNEL WHERE ENTERPRISE='" + enterprise + "' AND USER_ID='" + userId
					+ "'";
			stmt = connectionObject.createStatement();
			ResultSet rs = stmt.executeQuery(sql);
			if (rs.next())
				return true;
			else
				return false;
		} catch (Exception e) {
			return false;
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (connectionObject != null) {
					connectionObject.close();
					connectionObject = null;
				}
			} catch (Exception e) {
				BaseLogger.log("3", null, null, e.getMessage());
			}

		}
	}

	private boolean checkObject(String object) {
		Connection connectionObject = null;
		Statement stmt = null;
		try {
			connectionObject = getConnection();
			String sql = "SELECT DISTINCT OBJ_NAME FROM OBJ_ACTIONS WHERE OBJ_NAME='" + object + "'";
			stmt = connectionObject.createStatement();
			ResultSet rs = stmt.executeQuery(sql);
			if (rs.next())
				return true;
			else
				return false;
		} catch (Exception e) {
			return false;
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (connectionObject != null) {
					connectionObject.close();
					connectionObject = null;
				}
			} catch (Exception e) {
				BaseLogger.log("3", null, null, e.getMessage());
			}

		}
	}

	private String getObjDescription(String objName) {
		String description = "";
		Connection conn = null;
		Statement pstmt = null;
		try {
			String sql = "SELECT DESCR FROM ITM2MENU WHERE WIN_NAME='w_" + objName + "'";
			 conn = getConnection();
			 pstmt = conn.createStatement();
			ResultSet rs = pstmt.executeQuery(sql);
			if (rs.next()) {
				description = rs.getString("DESCR");
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			conn.close();
		} catch (Exception e) {
			// TODO: handle exception
		}finally {
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {

			}
		}
		return description;

	}

	private String checkNull(String input) {
		if (input == null) {
			input = "";
		} else {
			input = input.trim();
		}
		return input;
	}

	/*
	private String getDescriptionFromGencodes(String fldValue) {
		String description = "";
		Connection conn =null;
		Statement pstmt = null;
		try {
			String sql = "select descr from gencodes where fld_value='" + fldValue + "'";
			 conn = getConnection();
			 pstmt = conn.createStatement();
			ResultSet rs = pstmt.executeQuery(sql);
			if (rs.next()) {
				description = rs.getString("DESCRIPTION");
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			conn.close();
		} catch (Exception e) {
			// TODO: handle exception
		}
		finally {
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {

			}
		}
		return description;
	}
	*/

	private boolean checkUserCode(String userCode) {
		boolean result = false;
		Connection conn = null;
		Statement pstmt = null;
		try {
			String sql = "SELECT * FROM USERS WHERE CODE='" + userCode + "'";
			 conn = getConnection();
			 pstmt = conn.createStatement();
			ResultSet rs = pstmt.executeQuery(sql);
			if (rs.next()) {
				result = true;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			conn.close();
		} catch (Exception e) {
			// TODO: handle exception
		}finally {
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {

			}
		}
		return result;
	}

	private List<String> getTableAndPrimaryKey(String objName) {
		List<String> dataList = new ArrayList<>();
		Connection conn = null;
		Statement pstmt = null;
		try {
			String sql = "SELECT TABLE_NAME,TRAN_ID_COL FROM TRANSETUP WHERE TRAN_WINDOW='w_" + objName + "'";
			 conn = getConnection();
			 pstmt = conn.createStatement();
			ResultSet rs = pstmt.executeQuery(sql);
			if (rs.next()) {
				System.out.println("Table Name=:"+rs.getString("TABLE_NAME"));
				if(!rs.getString("TABLE_NAME").equals(null)&&
						!rs.getString("TABLE_NAME").equals("null")&&
						!rs.getString("TABLE_NAME").equals("")) {
					
				dataList.add(rs.getString("TABLE_NAME"));
				dataList.add(rs.getString("TRAN_ID_COL"));
				}
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			if (dataList.size() > 0) {
				BaseLogger.log("3", null, null, "primary key=" + dataList.get(1));
				if ("null".equals(dataList.get(1)) || null == dataList.get(1) || dataList.get(1).equals("")
						|| dataList.get(1).equals(null)) {

					String query = "SELECT cols.column_name " + "FROM all_constraints cons, all_cons_columns cols "
							+ "WHERE cols.table_name = '" + dataList.get(0).toUpperCase() + "' "
							+ "AND cons.constraint_type = 'P' " + "AND cons.constraint_name = cols.constraint_name "
							+ "AND cons.owner = cols.owner " + "AND POSITION='1' "
							+ "ORDER BY cols.table_name, cols.position";

					pstmt = conn.createStatement();
					rs = pstmt.executeQuery(query);
					if (rs.next()) {
						dataList.add(1, rs.getString("column_name"));
					}
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}
				}
			}
			conn.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		finally {
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {

			}
		}
		return dataList;
	}


	private String createEndpoint(String fldValue,String description, String objName, String enterprise, String appId) {
		 BaseLogger.log("3", null, null, "Insidel createEndpoint::[" +fldValue + "]");
		 BaseLogger.log("3", null, null, "Insidel createEndpoint::[" +description + "]");
		 BaseLogger.log("3", null, null, "Insidel createEndpoint::[" +objName + "]");
		 BaseLogger.log("3", null, null, "Insidel createEndpoint::[" +enterprise + "]");
		 BaseLogger.log("3", null, null, "Insidel createEndpoint::[" +appId + "]");
		String endpoint = "";
		String serviceConfig="";
		try {
			if (!fldValue.equals("") && !objName.equals("") && !enterprise.equals("") && !appId.equals("")) {
				if (fldValue.equals("writeFile") || fldValue.equals("writeFileSaveTrans")) {
					fldValue = "setData";
				}
				System.out.println("description in create url:"+description);
				
				//
				if(!description.equals("")&& description.equalsIgnoreCase("Accept Data (Write File And Save Transaction)")) {
					serviceConfig="writeFileSaveTrans";
					endpoint = ("/ibase/rest/EDIService/" + "setData" + "/" + objName.toLowerCase() + "/" + enterprise + "/" + appId+"/"+serviceConfig.toLowerCase());
							
				}
			
				else if(!description.equals("")&& description.equalsIgnoreCase("Accept Data (Only Write File)")){
					serviceConfig="writeFile";
					serviceConfig="";
					endpoint = ("/ibase/rest/EDIService/" + "setData" + "/" + objName.toLowerCase() + "/" + enterprise + "/" + appId);
							
				}
				else if (!description.equals("")&& description.equalsIgnoreCase("Set Data And Confirm"))
				{
					serviceConfig="setDataAndConfirm";
					endpoint = ("/ibase/rest/EDIService/" + "setData" + "/" + objName.toLowerCase() + "/" + enterprise + "/" + appId+"/"+serviceConfig);
				}
				//Added by Amol S on 03-Sep- 24 , for the writeFilesavetransBG  --start
				else if(!description.equals("")&& description.equalsIgnoreCase("Accept Data (Save Transaction in Background)"))
				{
					BaseLogger.log("3", null, null, "Inside the  else block for the writeFilesavetransBG...");
					serviceConfig="writeFilesavetransBG";
					endpoint = ("/ibase/rest/EDIService/" + "setData" + "/" + objName.toLowerCase() + "/" + enterprise + "/" + appId+"/"+serviceConfig.toLowerCase());
					BaseLogger.log("3", null, null, " writeFilesavetransBG Endpoint is::[" +endpoint + "]");
				}
				//Added by Amol S on 03-Sep- 24 , for the writeFilesavetransBG  ---End
				else {
					endpoint = fldValue;
				}
				
				//for creating url for getData
				if(fldValue.equalsIgnoreCase("getData")) {
					endpoint = "/ibase/rest/E12ExtService/getData/"+objName+"/"+enterprise+"/"+appId;
				}

			}

		} catch (Exception e) {

		}
		return endpoint;
	}
	// For checking Application id unique
	private boolean checkAppid(String appid) {
		Connection connectionObject = null;
		Statement stmt = null;
		try {
			connectionObject = getConnection();
			String sql = "select app_id from auth_apps where app_id='" + appid + "'";
			stmt = connectionObject.createStatement();
			ResultSet rs = stmt.executeQuery(sql);
			if (rs.next())
				return true;
			else
				return false;
		} catch (Exception e) {
			return false;
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (connectionObject != null) {
					connectionObject.close();
					connectionObject = null;
				}
			} catch (Exception e) {
				BaseLogger.log("3", null, null, e.getMessage());
			}

		}

	}

	private boolean checkEnterpriseName(String enterprise) {
		Connection connectionObject = null;
		Statement stmt = null;
		try {
			connectionObject = getConnection();
			String sql = "select enterprise from enterprise where enterprise='" + enterprise + "'";
			stmt = connectionObject.createStatement();
			ResultSet rs = stmt.executeQuery(sql);
			if (rs.next())
				return true;
			else
				return false;
		} catch (Exception e) {
			return false;
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (connectionObject != null) {
					connectionObject.close();
					connectionObject = null;
				}
			} catch (Exception e) {

			}
		}

	}

	
	/**
	 *
	 * Create and get base64 encoded JWT token based on user and application
	 * information.
	 *
	 * @param userCode
	 * @param applicationBean
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	protected String getJWTToken(String userCode, ExtAuthApplicationBean applicationBean)
			throws BaseException, Exception {
		BaseLogger.log("2", null, null, "ExtAuthAppService :: getJWTToken");
		// Get user details
		RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
		ExtAuthRespBean userBean = restapiserviceutility.getCommonDBAccess().getExtAuthRespBean(userCode);

		// Create Base64 Encoded JWT token
		String jwtToken = CryptographyUtil.createBase64EncodedJWT(applicationBean, userBean, "");

		BaseLogger.log("2", null, null, "ExtAuthAppService :: getJWTToken: jwtToken : [" + jwtToken + "]");

		return jwtToken;
	}

	/**
	 * 
	 * This method is for getting application information based on appId
	 * 
	 */
	public ExtAuthApplicationBean getExtAuthApplicationInfo(Document dom1) throws BaseException, Exception {

		//ConnDriver connDriver = null;
		//Connection connection = null;
		//PreparedStatement preparedStatement = null;
		//ResultSet resultSet = null;
		ExtAuthApplicationBean applicationBean = new ExtAuthApplicationBean();
		// applicationBean.setAppId(appId);
		try {
			BaseLogger.log("3", null, null, "ApplicationAPI :: getExtAuthApplicationInfo ");

			applicationBean.setAppId(E12GenericUtility.checkNull(genericUtility.getColumnValue("app_id", dom1)));
			BaseLogger.log("3", null, null, "getExtAuthApplicationInfo :: AppId"
					+ E12GenericUtility.checkNull(genericUtility.getColumnValue("app_id", dom1)));

			applicationBean.setAppName(E12GenericUtility.checkNull(genericUtility.getColumnValue("app_name", dom1)));
			BaseLogger.log("3", null, null, "getExtAuthApplicationInfo :: AppName"
					+ E12GenericUtility.checkNull(genericUtility.getColumnValue("app_name", dom1)));

			applicationBean.setAppRedirectURL(
					E12GenericUtility.checkNull(genericUtility.getColumnValue("redirect_url", dom1)));
			BaseLogger.log("3", null, null, "getExtAuthApplicationInfo :: redirect URL"
					+ E12GenericUtility.checkNull(genericUtility.getColumnValue("redirect_url", dom1)));

			applicationBean.setDescr(E12GenericUtility.checkNull(genericUtility.getColumnValue("descr", dom1)));
			BaseLogger.log("3", null, null, "getExtAuthApplicationInfo :: description"
					+ E12GenericUtility.checkNull(genericUtility.getColumnValue("descr", dom1)));

			applicationBean.setEffFrom(E12GenericUtility.checkNull(genericUtility.getColumnValue("eff_from", dom1)));
			BaseLogger.log("3", null, null, "getExtAuthApplicationInfo :: EFF_FROM"
					+ E12GenericUtility.checkNull(genericUtility.getColumnValue("eff_from", dom1)));

			applicationBean.setActive(E12GenericUtility.checkNull(genericUtility.getColumnValue("active", dom1)));
			BaseLogger.log("3", null, null, "getExtAuthApplicationInfo :: ACTIVE"
					+ E12GenericUtility.checkNull(genericUtility.getColumnValue("active", dom1)));

			applicationBean.setEnableSecurity(
					E12GenericUtility.checkNull(genericUtility.getColumnValue("enable_security", dom1)));
			BaseLogger.log("3", null, null, "getExtAuthApplicationInfo :: ENABLE_SECURITY"
					+ E12GenericUtility.checkNull(genericUtility.getColumnValue("enable_security", dom1)));

			applicationBean
					.setSharedKey(E12GenericUtility.checkNull(genericUtility.getColumnValue("shared_key", dom1)));
			BaseLogger.log("3", null, null, "getExtAuthApplicationInfo :: SHARED_KEY"
					+ E12GenericUtility.checkNull(genericUtility.getColumnValue("shared_key", dom1)));
			if (applicationBean.getSharedKey().equals("")) {
				applicationBean.setSharedKey("a3edd11a09ea4e0ccd09c6cd2828021b");
			}

			applicationBean.setTtl(Integer.parseInt(genericUtility.getColumnValue("ttl", dom1).trim()));
			BaseLogger.log("3", null, null, "getExtAuthApplicationInfo :: TTL"
					+ E12GenericUtility.checkNull(genericUtility.getColumnValue("ttl", dom1)));

			applicationBean
					.setWhiteListIp(E12GenericUtility.checkNull(genericUtility.getColumnValue("white_list_ip", dom1)));
			BaseLogger.log("3", null, null, "getExtAuthApplicationInfo :: WHITE_LIST_IP"
					+ E12GenericUtility.checkNull(genericUtility.getColumnValue("white_list_ip", dom1)));

			applicationBean
					.setEncryptMth(E12GenericUtility.checkNull(genericUtility.getColumnValue("encrypt_mth", dom1)));
			BaseLogger.log("3", null, null, "getExtAuthApplicationInfo :: ENCRYPT_MTH"
					+ E12GenericUtility.checkNull(genericUtility.getColumnValue("encrypt_mth", dom1)));

			applicationBean
					.setSecretKey(E12GenericUtility.checkNull(genericUtility.getColumnValue("secret_key", dom1)));
			BaseLogger.log("3", null, null, "getExtAuthApplicationInfo :: SECRET_KEY"
					+ E12GenericUtility.checkNull(genericUtility.getColumnValue("secret_key", dom1)));

		} catch (Exception e) {
			BaseLogger.log("0", null, null, "Exception in CommonDBAccessEJB getExtAuthApplicationInfo()........." + e);
		} 
		return applicationBean;
	}
	
	private String getupdateFlag(Document dom2)
    {
        NodeList parentList = null;
        NodeList childList = null;
        Node parentNode = null;
        Node childNode = null;

        String columnValue = "";
        String childNodeName = "";
        String updateFlag = "";

        int ctr = 0;
        int noOfChilds = 0;

        parentList = dom2.getElementsByTagName("Detail2");
        int parentNodeListLength = parentList.getLength();
        System.out.println("parentNodeListLength(getupdateFlag)[" + parentNodeListLength + "]");
        if (parentNodeListLength > 0)
        {
            for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++)
            {
                parentNode = parentList.item(prntCtr);
                childList = parentNode.getChildNodes();
                noOfChilds = childList.getLength();
                for (ctr = 0; ctr < noOfChilds; ctr++)
                {
                    childNode = childList.item(ctr);
                    if (childNode.getNodeType() != Node.ELEMENT_NODE)
                    {
                        continue;
                    }
                    if (childNode != null && childNode.getFirstChild() != null)
                    {
                        columnValue = childNode.getFirstChild().getNodeValue().trim();
                        System.out.println("columnValue  :::::@@@@  " + columnValue);
                    }
                    childNodeName = childNode.getNodeName();
                    System.out.println("childNodeName[" + childNodeName + "] columnValue [" + columnValue + "]");
                    if (childNodeName.equalsIgnoreCase("attribute"))
                    {
                        updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
                        System.out.println("[updateFlag]" + updateFlag);
                    }
                }

            }

        }

        System.out.println("updateFlag is @@@@@ ::::" + updateFlag);
        return updateFlag;
    }
	
}
