
<!doctype html>
<%@page import="java.util.Base64"%>
<%@page import="java.rmi.RemoteException"%>

<%@page import="ibase.webitm.ejb.DBAccessEJB"%>
<%@page import="ibase.utility.BaseLogger"%>
<%@page import="ibase.utility.CommonConstants"%>
<%@page import="java.io.File"%>
<%@page import="java.util.*"%>

<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Sample Code for calling API</title>
</head>

<%
String userCode = request.getParameter("chg_user");
BaseLogger.log( "3", null, null, "userCode in APISampleCode : ["+ userCode +"]" );
String appId = request.getParameter( "app_id" );
BaseLogger.log( "3", null, null, "APP ID in APISampleCode : ["+ appId +"]" );

String hostIP = "";
if(CommonConstants.BACKGROUND_JOB_SERVER != null && !CommonConstants.BACKGROUND_JOB_SERVER.equals("")) {
		BaseLogger.log( "3", null, null, "hostIP set from BACKGROUND_JOB_SERVER: => [ " + hostIP + " ] ");
		hostIP = CommonConstants.BACKGROUND_JOB_SERVER;
		} else {
			hostIP = CommonConstants.TOMCAT_HOME;
			BaseLogger.log( "3", null, null, "hostIP set from TOMCAT_HOME: APISample.jsp => [ " + hostIP + " ] ");
		}


%>

<style type="text/css" onload="APISampleCode()">
	
    table {
  border-collapse: collapse;
  width: 100%;
  margin: 1em 0;
  font-family: Arial, sans-serif;
  font-size: 14px;
}

th {
  background-color: #f5f5f5;
  color: #333;
  font-weight: bold;
  border: 1px solid #ccc;
  /* padding: 0.5em; */
}

td {
  background-color: #fff;
  color: #333;
  border: 1px solid #ccc;
  padding: 0.5em;
}

tr:nth-child(2n) td {
  background-color: #f5f5f5;
}

tr:first-child {
  font-weight: bold;
}



	h4
	{
		color: #000000;
		margin: 0px;
	}

	.code-style {
        background: #f4f4f4;
        border: 1px solid #ddd;
        border-left: 3px solid #000000;
        border-radius: 5px;
        color: #666;
        page-break-inside: avoid;
        font-family: monospace;
        font-size: 13px;
        line-height: 1.6;
        margin-bottom: 1.6em;
        max-width: 100%;
        overflow: auto;
        padding: 1em 1.5em;
        display: block;
        word-wrap: break-word;
        width: 80%;
       
    }

.divScroll {
    /* Overflow-x:scroll; */
    Overflow-y:scroll;
    font-family: sans-serif;
    
    }

.jsSampleCode {
    margin-top: 20px;
}
select {
  padding: 10px;
  border: 1 px solid grey;
  border-radius: 5px;
  width: auto;
  font-size: 16px;
  background-color: #fff;
  color: #555;
}
input[type="text"] {
  padding: 10px;
  font-size: 16px;
  border-radius: 5px;
  border: none;
  background-color: #e8e8e8;
  margin-bottom: 10px;
  margin-top: 10px;

}

button {
  padding: 10px 20px;
  background-color: #158E6A;
  color: #fff;
  border: none;
  border-radius: 5px;
  cursor: pointer;
  transition: all 0.2s ease-in-out;
  margin: 0 10px;
}

button:hover {
  background-color: #687285;
  transform: translateY(-2px);
}

button:active {
  transform: translateY(0);
}

#APIParameterTable {
    margin-top: 10px;
       
}

table, th, td {
  border: 1px solid black;
  padding: 10px;
}

</style>

<script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>


<script>
var objectEndpoint = "";
function APISampleCode() {
    console.log = console.info;
    console.log("Hello ji");
    var url = window.location.origin + "/ibase/WebITMAPISampleServlet";
    var userCode = document.getElementById("userCode").value;
    var appId = document.getElementById("appId").value;
    

    return $.ajax({
            type:'GET',
            async:false,
            data:{
                userCode: userCode,
                appId: appId
                //action: "plangantt"
            },
            url: url,
            success:function(response){
            objectEndpoint = JSON.stringify(response);
                var select = document.getElementById('endpointObject');
                var service = "";
                const map = new Map(Object.entries(response));
                const result = [];
                Object.keys(response).forEach((key)=>{
                    const endpointArray = response[key];
                    var option = document.createElement('option');
                    for(let i=0; i<endpointArray.length; i++) {
                        console.log("Array elements= ",endpointArray[i]);
                        service = generateServiceName(endpointArray[i]);
                        const endpoint = "Object: " + key + ", Service: " + service + ",  Endpoint: " + endpointArray[i];
                        console.log("Dropdown::" + endpoint);
                        result.push(endpoint);
                    }                    
                })
                buildURL();
                console.log("result list=",result);
               select.innerHTML = "";
               if(result.length===0) {
                alert("API Endpoint not defined!");
                return;
               }
                for(var i = 0; i < result.length; i++) {
                    var opt = result[i];
                    
                    var el = document.createElement("option");
                    var start = opt.indexOf("Object:");
                    var end = opt.indexOf("Endpoint:") - 3;
                    
                    var dispValue = opt.slice(start,end);
                    
                    el.textContent = dispValue;
                    el.value = opt;
                    select.appendChild(el);
                }               
            },
            error:function(data){
                jQuery('.alert').show();
                jQuery('.alert').html(data.fail);
            }
        });
        

}



function downloadSampleData(fileType) {
	var reffId = document.getElementById('reffId').value;
	
	if(reffId===''){
		alert("Please Enter Reference ID");
		return;
	}
    console.log('Download sample data called!');
    var select = document.getElementById('endpointObject');
    var value = select.value;
    var text = select.options[select.selectedIndex].text;
    console.log("text::" + text);
    var start = text.indexOf("Object:");
    var objName = text.slice(start).trim();
    start = objName.indexOf(":") + 1;
    var end = objName.indexOf(",");
    objName = objName.slice(start,end).trim();
    console.log("objName::", objName);
    
    var url = window.location.origin + "/ibase/WebITMAPISampleServlet";
    var fileType = fileType;
    console.log("Got File Type"+fileType);
    return $.ajax({
            type:'GET',
            async:false,
            data:{
                objName: objName,
                action: "downloadSampleData",
                fileType:fileType,
                reffId:reffId
            },
            url: url,
            success:function(response){
                console.log("downloadSampleData",response);
                var a = document.createElement('a');
                var downloadURL = url + "?" + "action=downloadSampleData&objName="+objName+"&fileType="+fileType+"&reffId="+reffId;
                a.href = downloadURL;
                a.click();
                a.remove();
                window.URL.revokeObjectURL(url);
            },
            error:function(data){
                jQuery('.alert').show();
                jQuery('.alert').html(data.fail);
            }
        });
}

function buildURL() {
    console.log('buildURL method called!');
    var hostIP = document.getElementById('host-IP').getAttribute('hostIP');
    console.log('hostIP::' , hostIP );

    var dropdown = document.getElementById('endpointObject');
    console.log('dropdown value::' , dropdown.value);

    var start = dropdown.value.indexOf("Endpoint:") ;
    var endpoint = dropdown.value.slice(start).trim();
    start = endpoint.indexOf(":") + 1;
    endpoint = endpoint.slice(start).trim();
    console.log('endpoint value from buildURL::' , endpoint);
    var requestURL = "";
   

    generateAPIParameters();
    requestURL = generateRequestURL(endpoint);
    console.log('requestURL value from buildURL::' , requestURL);

    document.getElementById('result-endpoint-js-json').innerHTML = requestURL;
    document.getElementById('result-endpoint-js-xml').innerHTML = requestURL;
    document.getElementById('result-endpoint-java-json').innerHTML = requestURL;
    document.getElementById('result-endpoint-java-xml').innerHTML = requestURL;
   
}

function generateServiceName (endpoint) {
    var serviceName;
    
    if(endpoint.includes("login")) {
        serviceName = "Login";
    } else if (endpoint.includes("getData")) {
        serviceName = "Return Data";
    } //Changes on 28-Oct-24 By Amol S --strt
     else if (endpoint.includes("writefilesavetransbg")) {
        serviceName = "Accept Data (Save Transaction in Background)";
    }//Changes on 28-Oct-24 By Amol S --end
    else if (endpoint.includes("writefilesavetrans")) {
        serviceName = "Accept Data (Write File and Save Transaction)";
    } else if(endpoint.includes("setDataAndConfirm")) {
        serviceName = "Accept Data (Write File, Save Transaction and Confirm)";
    } else if (endpoint.includes("setData")) {
        serviceName = "Accept Data (Write File)";
    }
   
    return serviceName;
}

function generateRequestURL(endpoint) {
    var hostIP = document.getElementById('host-IP').getAttribute('hostIP');
    console.log('hostIP::' , hostIP );
    if(endpoint.includes("login")) {
        requestURL = hostIP + "/ibase/rest/E12ExtService/login";
        console.log('requestURL (login) value from buildURL::' , requestURL);
    } else if(endpoint.includes("getData")) {
        requestURL = hostIP + "/ibase/rest/E12ExtService/getData";
        console.log('requestURL (getdata) value from buildURL::' , requestURL);
    } else if(endpoint.includes("setData")) {
        requestURL = hostIP + endpoint;
        console.log('requestURL (setdata) value from buildURL::' , requestURL);
    }
    //Changes on 28-Oct-24 By Amol S --strt
    else if(endpoint.includes("writefilesavetransbg")) {
        requestURL = hostIP + endpoint;
        console.log('requestURL (writefilesavetransBG) value from buildURL::' , requestURL);
    }
    //Changes on 28-Oct-24 By Amol S --end
    else if(endpoint.includes("writefilesavetrans")) {
        requestURL = hostIP + endpoint;
        console.log('requestURL (writefilesavetrans) value from buildURL::' , requestURL);
    }
    else if(endpoint.includes("setDataAndConfirm")){
    	requestURL = hostIP + endpoint;
    }
   
    else {
    	requestURL=hostIP+"/ibase/rest/EDIService/"+endpoint;
    }
    return requestURL;
}

function getObjectName(endpoint) {
  const objName = endpoint.split('/');
  if (objName.length < 5) {
    return null; 
  }
  return objName[5];
}

function getEnterprise(endpoint) {
  const enterprise = endpoint.split('/');
  if (enterprise.length < 5) {
    return null; 
  }
  return enterprise[6];
}

function generateAPIParameters() {
    var appId = document.getElementById("appId").value;
    var dropdown = document.getElementById('endpointObject');
    console.log('dropdown value from generateAPIParameters()::' , dropdown.value);

    var start = dropdown.value.indexOf("Endpoint:") ;
    var endpoint = dropdown.value.slice(start).trim();
    start = endpoint.indexOf(":") + 1;
    endpoint = endpoint.slice(start).trim();
    console.log('endpoint value from generateAPIParameters()::' , endpoint);
    var objectName = getObjectName(endpoint);
    var enterprise = getEnterprise(endpoint);
    var serviceName = generateServiceName(endpoint)
    console.log('serviceName value from generateAPIParameters()::' , serviceName);
     

    var table = document.getElementById('APIParameterTable');
    table.innerHTML = "";
    //$("#APIParameterTable tr").remove(); 
    var rowCount = table.rows.length;
    var row = table.insertRow(rowCount);
    row.insertCell(0).innerHTML = "KEY";
    row.insertCell(1).innerHTML = "VALUE";
    row.insertCell(2).innerHTML = "Description";
    row = null;

    if (serviceName === "Login") {
        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "USER_CODE";
        row.insertCell(1).innerHTML = "&ltuser_code&gt";
        row.insertCell(2).innerHTML = "Enter User Code."

        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "PASSWORD";
        row.insertCell(1).innerHTML = "&ltpassword&gt";
        row.insertCell(2).innerHTML = "Enter Password."

        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "IS_PWD_ENCRYPT";
        row.insertCell(1).innerHTML = "true/false";
        row.insertCell(2).innerHTML = "Default value is false."

        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "APP_ID";
        row.insertCell(1).innerHTML = appId;
        row.insertCell(2).innerHTML = "App ID against which login endpoint is defined."

        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "DATA_FORMAT";
        row.insertCell(1).innerHTML = "JSON/XML";
        row.insertCell(2).innerHTML = "Format in which we wants the output in."
    } else if(serviceName === "Return Data") {
        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "TOKEN_ID";
        row.insertCell(1).innerHTML = "&lttoken_id&gt";
        row.insertCell(2).innerHTML = "Short Lived token which is generated via Login API.If passed blank or expired SLT, then system will automatically look for Long lived token in USER_ACC_CHANNEL."

        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "OBJ_NAME";
        row.insertCell(1).innerHTML = objectName;
        row.insertCell(2).innerHTML = "Object Name for which we need to get the data."

        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "ENTERPRISE";
        row.insertCell(1).innerHTML = enterprise;
        row.insertCell(2).innerHTML = "Enterprise of the user."

        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "REF_ID";
        row.insertCell(1).innerHTML = "&ltref_id&gt";
        row.insertCell(2).innerHTML = "Primary key value of the table for which we need to get Data."

        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "APP_ID";
        row.insertCell(1).innerHTML = appId;
        row.insertCell(2).innerHTML = "App ID against which getData endpoint is defined."

        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "DATA_FORMAT";
        row.insertCell(1).innerHTML = "JSON/XML";
        row.insertCell(2).innerHTML = "Format in which we wants the data in."
    } else {
        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "TOKEN_ID";
        row.insertCell(1).innerHTML = "&ltTOKEN_ID&gt";
        row.insertCell(2).innerHTML = "User will pass Token Id for authentication purpose.";

        row = table.insertRow(++rowCount);
        row.insertCell(0).innerHTML = "INPUT_DATA";
        row.insertCell(1).innerHTML = "&ltINPUT_DATA&gt";
        row.insertCell(2).innerHTML = "Data in JSON/XML format";
    }

    // row.insertCell(0).innerHTML= "hello";
    // row.insertCell(1).innerHTML= "world";
    // row.insertCell(2).innerHTML= "gsb";
}

</script>

<body class="divScroll" onload="APISampleCode(); generateAPIParameters();">
  <div class="head-div">
  		<input type="text" id="userCode" value="<%=userCode%>" style="display: none"/>
  		<input type="text" id="appId" value="<%=appId%>" style="display: none"/>
		<b><label>Endpoint List</label></b><br>
  		<select id="endpointObject" name="endpointObject" onchange="buildURL()"></select>
  		<br><br>
  		
  		<b><label>Reference ID</label></b><br>
  		<input type="text" id="reffId" placeholder="Enter Reference ID"/>
  		<br>
  		<br>
        
        <button onclick="downloadSampleData('json')">Download Sample JSON</button>
		<button id ="sampleButton" onclick="downloadSampleData('xml')">Download Sample XML</button>
		<button id ="sampleButton" onclick="downloadSampleData('xmlWithAttrib')">Download Sample XML With Attributes</button>
        <button id="host-IP" hostIP="<%=hostIP%>" style="display: none" ></button>

        <div>
            <h3>API Parameters</h3>
            <h4>Method: POST</h4>
            <table id="APIParameterTable">
                <thead>
                    <th>KEY</th>
                    <th>VALUE</th>
                    <th>Description</th>
                </thead>
              </table>
              
        </div>

        <div class="jsSampleCode">
        <h4 style="text-align: center;">

            <u> Javascript Sample Code </u>
        </h4>
        <h4>
            <u> JSON format </u>
        </h4>
        <h4 class="code-style">
            
            const baseURL =  "<span id="result-endpoint-js-json" ></span>"; <br>
 
            fetch(baseURL) <br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.then(resp => resp.json()) <br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.then(data => console.log(data));
        </h4>
        <h4>
           <u> XML format </u>
        </h4>
        <h4 class="code-style">
            const baseURL =  "<span id="result-endpoint-js-xml" ></span>"; <br>
 
            fetch(baseURL) <br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.then(resp => resp.text()) <br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.then(data => { <br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;const parser = new DOMParser(); <br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;const xml = parser.parseFromString(data, "application/xml");<br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;console.log(xml); <br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  }) <br>
              .catch(console.error); <br>
            
        </h4>
        </div>

<br><br>      
        <div class="javaSampleCode">
            <h4 style="text-align: center;">
                <u>Java Sample Code </u>
            </h4>

            <h4>
                <u> JSON format </u>
            </h4>
            <h4 class="code-style">
                // Create a URL object to hold the URL <br>
                URL url = new URL ("<span id="result-endpoint-java-json" ></span>"); <br><br>
     
                // Open a connection on the URL and cast the response <br>
                HttpURLConnection connection = (HttpURLConnection) url.openConnection(); <br><br>

                // Now it's "open", we can set the request method, headers etc.<br>
                connection.setRequestProperty("accept", "application/json");<br><br>

                // This line makes the request <br>
                InputStream responseStream = connection.getInputStream();

            </h4>
            <h4>
               <u> XML format </u> 
            </h4>
            <h4 class="code-style">
                // Create a URL object to hold the URL <br>
                URL url = new URL ("<span id="result-endpoint-java-xml" ></span>"); <br><br>
     
                // Open a connection on the URL and cast the response <br>
                HttpURLConnection connection = (HttpURLConnection) url.openConnection(); <br><br>

                // Now it's "open", we can set the request method, headers etc.<br>
                connection.setRequestProperty("accept", "application/xml");<br><br>

                // This line makes the request <br>
                InputStream responseStream = connection.getInputStream();

            </h4>
        </div>
    </div>



</body>





</html>


