/**
 * 
 */
package ibase.webitm.servlet.wsfa;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
//Commented and Changes done by Gaurav Singh on 03-Sep-14
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.servlet.Messages;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.E12FollowUpActionEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.wsfa.transactions.*;
import ibase.webitm.utility.wsfa.WSFACommon;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DSRReportServlet extends HttpServlet 
{
	ServletContext servletContext = null;
	ServletConfig servletConfig = null;
	InitialContext ctx = null;
	UserInfoBean userInfo = null; //Added by kailash on 21-feb-18.
	WSFACommon wsfaCommon = new WSFACommon();
	public void init(ServletConfig servletConfig) throws ServletException
	{
		this.servletConfig = servletConfig;
		this.servletContext = servletConfig.getServletContext();
	}
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		 doPost( request, response );
	}
    
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		System.out.println("XXXXXXXXXXXXXXXXXXXXXX[doPost is DSRReportServlet]XXXXXXXXXXXXXXXXXXXX");
		ServletOutputStream outputStream = null;
		HttpSession sess = null;
		String responseStr ="";
		ArrayList<String> custList =new ArrayList<String>();
		Connection conn = null;
		ConnDriver connDriver =  new ConnDriver();
		try 
		{  
			String actionFlag = request.getParameter("ACTION");
			sess = request.getSession();
			System.out.println( "\nsess.getId() :["+sess.getId()+"]" );	
			userInfo = (ibase.utility.UserInfoBean)request.getSession().getAttribute("USER_INFO");
			System.out.println("userInfo["+userInfo.toString()+"]");
			if( userInfo != null )
			{
				System.out.println("userInfo.getTransDB() for invoice stk["+userInfo.getTransDB());
				conn = connDriver.getConnectDB(userInfo.getTransDB());
				System.out.println("connection invoice["+conn+"]");
			}
			if(ctx == null)
			{
				ctx = getInitialContext();  
			}
			//Added by Sagar B. for photo capture report on[02-Apr-2018]START
			if( "GET_PHOTO_CAPTURED_DATA".equals( actionFlag ) )
			{
				try 
				{
					String teamSelection = E12GenericUtility.checkNull( request.getParameter("teamSelection") );
					String fromDate = E12GenericUtility.checkNull( request.getParameter("dcrFromDate") );
					String toDate = E12GenericUtility.checkNull( request.getParameter("dcrToDate") );
					String photoAttch = E12GenericUtility.checkNull( request.getParameter("photoAttch") );
					String custType = E12GenericUtility.checkNull( request.getParameter("custType") );
					System.out.println("In GET_PHOTO_CAPTURED_DATA action fromDate["+fromDate+"] toDate["+toDate+"] teamSelection["+teamSelection+"] photoAttch["+photoAttch+"] custType["+custType+"]");
					String allDataXML = getPhotoCapturedData(teamSelection, fromDate, toDate, photoAttch, custType, userInfo);
					System.out.println("In GET_PHOTO_CAPTURED_DATA action allDataXML["+allDataXML+"]");
					responseStr = allDataXML;
				}
				catch (Exception e) 
				{
					responseStr = e.getMessage();
					System.out.println( "Exception inh GET_PHOTO_CAPTURED_DATA - "+ responseStr );
				}
			}
			//Added by Sagar B. for photo capture report on[02-Apr-2018]END
			//Added by sunny soni for getting NPC data from database according to datewise[Start]
			else if( "GET_NPC_DATA".equalsIgnoreCase(actionFlag) )
			{
				try
				{
					String teamSelection = E12GenericUtility.checkNull( request.getParameter("teamSelection") );
					String fromDate = E12GenericUtility.checkNull( request.getParameter("dcrFromDate") );
					String toDate = E12GenericUtility.checkNull( request.getParameter("dcrToDate") );
					System.out.println("In GET_NPC_DATA action fromDate["+fromDate+"] toDate["+toDate+"]");
					String allDataXML = getNPCDetailsData(fromDate, toDate, userInfo, "NPC", teamSelection);
					System.out.println("In GET_NPC_DATA action allDataXML["+allDataXML+"]");
					responseStr = allDataXML;
				}
				catch (Exception e) 
				{
					responseStr = e.getMessage();
					System.out.println( "Exception inh GET_NPC_DATA - "+ responseStr );
				}
			}
			//Added by sunny soni for getting NPC data from database according to datewise[End]
			else
			{
				String returnXMLString="";
				String dcrDate = checkNull(request.getParameter("EVENT_DATE")); 
				String SalesPersonCode = checkNull(request.getParameter("SALES_PERS"));
				String xtraParam = SalesPersonCode+ "#" + dcrDate;
				String reportType = checkNull(request.getParameter("REPORT_TYPE"));
				System.out.println(" EVENT_DATE = ["+dcrDate+"], SALES_PERS =["+SalesPersonCode+"] ACTION =["+actionFlag+"], reportType=["+reportType+"]");
				String dcrId = getdcrID(dcrDate, SalesPersonCode, conn);
				//System.out.println("dcr ID inside do post:---->>>>"+dcrId);
				//System.out.println("actionFlag inside do PostSave:---->>>>"+actionFlag);
				
				if("confirm".equalsIgnoreCase(actionFlag))
				{
					//Added by Mrunalini Sinkar on 08-01-2019 for calling servicehandler2(start)
					String url = getUrl(dcrId, conn);
					//Added by Prasad on 18/06/2021 [force_save related implementation] START
					String forcedFlag = request.getParameter("FORCESAVE");
					url += "&FORCESAVE="+forcedFlag;
					//Added by Prasad on 18/06/2021 [force_save related implementation] END
					//System.out.println("Inside confirm url is>>>>"+url);
					RequestDispatcher rd = request.getRequestDispatcher("/WebITMServiceHandlerServlet2?"+url); 
					request.setAttribute("USER_INFO", userInfo);
					rd.forward(request,response);
					//System.out.println("After calling servlet>>>>"+url);
					//Added By Bhagyashri T for instance Workflow changes for LBCP Customer Start 20-11-22
					PreparedStatement pstmtwrkflw=null;
					ResultSet rswrkflw=null;
					String sqlwrk="",wrkflwInit="",wrkOptCust="0";
					sqlwrk = "SELECT WRKFLW_INIT,WORKFLOW_OPT FROM TRANSETUP WHERE TRAN_WINDOW = 'w_strg_cust_add_aprv'";
					pstmtwrkflw = conn.prepareStatement(sqlwrk);
					rswrkflw = pstmtwrkflw.executeQuery();
					if (rswrkflw.next())
					{
						wrkflwInit = rswrkflw.getString("WRKFLW_INIT") == null ? "" : rswrkflw.getString("WRKFLW_INIT");
						wrkOptCust = rswrkflw.getString("WORKFLOW_OPT") == null ? "" : rswrkflw.getString("WORKFLOW_OPT");
					}
					if (rswrkflw != null)
					{
						rswrkflw.close();
						rswrkflw = null;
					}
					if (pstmtwrkflw != null)
					{
						pstmtwrkflw.close();
						pstmtwrkflw = null;
					}
					DBAccessEJB dbAccess = new DBAccessEJB();
					if(wrkOptCust !=null && wrkOptCust.trim().length()>0 && !(wrkOptCust.equals("0")))
					{
						StrgCustomerAdd strgCustAdd = new StrgCustomerAdd();
						strgCustAdd.setUserInfo(userInfo);
						ArrayList<String> getStrgCustAdd = strgCustAdd.checkStrgCustRecord(dcrDate,SalesPersonCode ,dcrId );
						//System.out.println("getStrgCustAdd is>>>>"+getStrgCustAdd);
						if(getStrgCustAdd.size() > 0)
						{
							if(getStrgCustAdd != null && !getStrgCustAdd.isEmpty())
							{
								for(int i=0; i< getStrgCustAdd.size(); i++)
								{
									String schTranId = getStrgCustAdd.get(i);
									int workFlowOp=0;
									String objName="strg_cust_add_aprv";
									String coreModelID = generateRandomNo()+"";
									String columnName ="WORKFLOW_OPT";
									String tableName = "TRANSETUP";
			
									
									String condition = " TRAN_WINDOW ='w_" + objName + "' ";
									String workFlowOpt= dbAccess.getDBColumnValue( tableName, columnName, condition, userInfo.getTransDB());
									
									if(workFlowOpt.length()>0)
									{
										workFlowOp=Integer.parseInt(workFlowOpt);
									}
									
									if(schTranId!=null && schTranId.length() > 0 && workFlowOp > 0)
									{
										//System.out.println("in side the addFollowUpAction >>>>"+getStrgCustAdd);
										addFollowUpAction( SalesPersonCode, coreModelID, schTranId, objName, userInfo );
									}
								}
							}	
						}
					}
				}
				else if("submit".equalsIgnoreCase(actionFlag))
				{
					PreparedStatement pstmtwrkflw=null;
					ResultSet rswrkflw=null;
					String sqlwrk="",wrkflwStock="",wrkOptStock="0";
					sqlwrk = "SELECT WRKFLW_INIT,WORKFLOW_OPT FROM TRANSETUP WHERE TRAN_WINDOW = 'w_invoice_stock_aprv'";
					pstmtwrkflw = conn.prepareStatement(sqlwrk);
					rswrkflw = pstmtwrkflw.executeQuery();
					if (rswrkflw.next())
					{
						wrkflwStock = rswrkflw.getString("WRKFLW_INIT") == null ? "" : rswrkflw.getString("WRKFLW_INIT");
						wrkOptStock = rswrkflw.getString("WORKFLOW_OPT") == null ? "" : rswrkflw.getString("WORKFLOW_OPT");
					}
					if (rswrkflw != null)
					{
						rswrkflw.close();
						rswrkflw = null;
					}
					if (pstmtwrkflw != null)
					{
						pstmtwrkflw.close();
						pstmtwrkflw = null;
					}
					DBAccessEJB dbAccess = new DBAccessEJB();
					//System.out.println("Before strgMeetDCrWizConf");
					StrgMeetDCRWizConf StrgMeetDCRWizConf = new StrgMeetDCRWizConf();
					StrgMeetDCRWizConf.setUserInfo(userInfo);
					//System.out.println("Before strgMeetDCrWizConf after");
					custList = StrgMeetDCRWizConf.createCustomerWrkflow( dcrDate,SalesPersonCode ,dcrId,conn);
					//System.out.println("after calling method createCustomerWrkflow");
					if(wrkOptStock !=null && wrkOptStock.trim().length()>0 && !(wrkOptStock.equals("0")))
					{
						//System.out.println("Inside invoice stock aprv follow");
						String schTranId = dcrId;
						int workFlowOp=0;
						String objName="invoice_stock_aprv";
						String coreModelID = generateRandomNo()+"";
						String columnName ="WORKFLOW_OPT";
						String tableName = "TRANSETUP";

						String condition = " TRAN_WINDOW ='w_" + objName + "' ";
						String workFlowOpt= dbAccess.getDBColumnValue( tableName, columnName, condition, userInfo.getTransDB());
						
						if(workFlowOpt.length()>0)
						{
							workFlowOp=Integer.parseInt(workFlowOpt);
						}								
						if(schTranId!=null && schTranId.length() > 0 && workFlowOp > 0)
						{
							//System.out.println("in side the addFollowUpAction >>>> invoice_stock_aprv");
							addFollowUpAction( SalesPersonCode, coreModelID, schTranId, objName, userInfo );
						}
					}
				}
				else if("delete".equalsIgnoreCase(actionFlag))
				{
	
					//StrgMeetDCRWizDeleteLocal strgMeetDCRWizDelete = (StrgMeetDCRWizDeleteLocal)ctx.lookup("ibase/webitm/ejb/wsfa/transactions/StrgMeetDCRWizDelete/local");
					StrgMeetDCRWizDelete strgMeetDCRWizDelete = new StrgMeetDCRWizDelete();
					strgMeetDCRWizDelete.setUserInfo(userInfo);
					responseStr = strgMeetDCRWizDelete.delete( dcrId, xtraParam, "");
				}
				if(responseStr.trim().length()>0)
				{
					if(responseStr.indexOf("<description>")>0)
					{
						System.out.println("responseStr=["+responseStr+"]");
						String responseStr1 = responseStr.substring(responseStr.indexOf("<description>"), responseStr.indexOf("</description>"));
						responseStr1 = responseStr1.replace("<description>", "");
						//System.out.println("DSRReportServlet responseStr1=::::["+responseStr1+"]");
						responseStr = responseStr1;
					}
				}
	            
			}
			if(responseStr.trim().length()>0)
			{
				/*System.out.println("responseStr=["+responseStr+"]");
				String responseStr1 = responseStr.substring(responseStr.indexOf("<description>"), responseStr.indexOf("</description>"));
				responseStr1 = responseStr1.replace("<description>", "");
				//System.out.println("DSRReportServlet responseStr1=::::["+responseStr1+"]");
				responseStr = responseStr1;*/
				
				response.setContentType("text/xml");
				
				if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(responseStr.getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", "");
					OutputStream outStream = response.getOutputStream();
					outStream.write(responseStr.getBytes());
					outStream.flush();
					outStream.close();
				}
			}
            System.out.println("DSRReportServlet responseStr=::::["+responseStr+"]");

            
			System.out.println("****** DSRReportServlet call end successfully ***********");
            
		}
		catch (Exception e)
		{
			e.printStackTrace();
	        System.out.println("Exception :DSRReportServlet: doPost :==>"+e);
	        try 
	        {
				throw new ITMException(e);
			} 
	        catch (ITMException e1) 
	        {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			
		}
		catch (Error er)
		{
			System.out.println("Inside error");
			er.printStackTrace();
			
		}
		finally
		{
			try
			{
				
				conn.close();
				conn = null;
                    
			}
			catch(Exception e)
			{
				System.out.println("Exception :StrgMeetDCRWizConf :confirm :==>\n"+e.getMessage());
			}
		}
	
	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[DSRReportServlet] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[DSRReportServlet] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}
	
	private String validateDSR(String eventDate, String salesPers)throws ITMException
	{
		String returnString = "";
		Connection conn = null;
		ConnDriver connDriver =  new ConnDriver();
		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			int confCnt = 0;
			conn = connDriver.getConnectDB("DriverITM");
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			//GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			String selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? AND (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END) = 'Y' ";
			pstmt = conn.prepareStatement(selectSql);
			
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp( 2 ,java.sql.Timestamp.valueOf(eventDate) );
			
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				confCnt = rs.getInt("COUNT");
			}
			if(confCnt >= 2)
			{
				returnString = "Confirmed : DSR already confirmed, please select another date ";
			}
			else
			{
				returnString = "SUCCESS";
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception expRsc)
			{
				expRsc.printStackTrace();
			}
		}
		
		return returnString;
	}
	private String confirmReport(String eventDate, String salesPers, String reportType)throws ITMException
	{
		String returnString = "";
		Connection conn = null;
		ConnDriver connDriver =  new ConnDriver();
		
		PreparedStatement pstmt = null;
		PreparedStatement pstmtSel = null;
		ResultSet rs = null;
		
		int updCnt = -1;
		int pendCnt = 0;
		try
		{
			
			conn = connDriver.getConnectDB("DriverITM");
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			//GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			if("PR".equalsIgnoreCase(reportType))
			{
				String selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE < ? "+
									"AND (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END) = 'N' " +
									"AND ACTIVITY_CODE IN(SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE='PR')";
				
				pstmtSel = conn.prepareStatement(selectSql);
				pstmtSel.setString(1, salesPers);
				pstmtSel.setTimestamp( 2 ,java.sql.Timestamp.valueOf(eventDate) );
				
				rs = pstmtSel.executeQuery();
				if(rs.next())
				{
					pendCnt = rs.getInt("COUNT");
				}
				
				if(pendCnt > 0)
				{
					returnString = "PENDING:" + getMessageDescr(conn,"PENDDCRCON");
				}
				else
				{
				
					String updSql = "UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'Y' , CONF_DATE = SYSDATE WHERE SALES_PERS = ? AND EVENT_DATE = ? "+
									"AND ACTIVITY_CODE IN(SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE='PR')";
					
					pstmt = conn.prepareStatement(updSql);
					
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp( 2 ,java.sql.Timestamp.valueOf(eventDate) );
					
					updCnt = pstmt.executeUpdate();
				}
			}
			else
			{
				String selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE < ? "+
						"AND (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END) = 'N' " +
						"AND ACTIVITY_CODE IN(SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')";
	
				pstmtSel = conn.prepareStatement(selectSql);
				pstmtSel.setString(1, salesPers);
				pstmtSel.setTimestamp( 2 ,java.sql.Timestamp.valueOf(eventDate) );
				
				rs = pstmtSel.executeQuery();
				if(rs.next())
				{
					pendCnt = rs.getInt("COUNT");
				}
				
				if(pendCnt > 0)
				{
					returnString = "PENDING :" + getMessageDescr(conn,"PENDDCRCON");
				}
				else
				{
					String updSql = "UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'Y' , CONF_DATE = SYSDATE WHERE SALES_PERS = ? AND EVENT_DATE = ? "+
									"AND ACTIVITY_CODE IN(SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')";
			
					pstmt = conn.prepareStatement(updSql);
					
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp( 2 ,java.sql.Timestamp.valueOf(eventDate) );
					updCnt = pstmt.executeUpdate();
				}
			}
			
			System.out.println("updCnt =["+updCnt+"]");
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
				returnString = "FAILED:" + getMessageDescr(conn,"DSRNOTCONF");
			}
			catch(Exception e1)
			{}
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					if(updCnt > 0)
					{
						if("PR".equalsIgnoreCase(reportType))
						{
							returnString = "SUCCESS:" + getMessageDescr(conn,"PRCONFMD");
						}
						else
						{
							returnString = "SUCCESS:" + getMessageDescr(conn,"DCRCONFMD");
						}
						conn.commit();
					}
					else if(updCnt == 0)
					{
						returnString = "FAILED:" + getMessageDescr(conn,"DSRNOTCONF");
					}
					conn.close();
					conn = null;
					
				}
			}
			catch(Exception expRsc)
			{
				expRsc.printStackTrace();
			}
		}
		
		return returnString;
	}
	private String deleteReport(String eventDate, String salesPers, String reportType)throws ITMException
	{
		String returnString = "";
		Connection conn = null;
		ConnDriver connDriver =  new ConnDriver();
		
		PreparedStatement pstmtSel = null;
		PreparedStatement pstmtDel = null;
		PreparedStatement pstmtComp = null;
		ResultSet rs = null;
		
		int actTranDelCnt = -1;
		int travelDelCnt = -1;
		int meetDelCnt = -1;
		int itemDelCnt = -1;
		int orderDelCnt = -1;
		int invoicedelCnt =-1;
		int teamDelCnt = -1;
		int pendCnt = 0;
		
		
		
		try
		{
			
			conn = connDriver.getConnectDB("DriverITM");
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			//GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			String evenDate = eventDate;
			Date evDate = null;
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			evDate = sdf.parse(evenDate);
			System.out.println("evDate: -"+evDate+":evenDate :"+evenDate);
			eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			String deleteSql = "";
			String dcrIdSql = "";
			String dcrId = "";
			Object maxDate = "";
			String checkSql = "SELECT MAX(EVENT_DATE) AS MAXDATE FROM SPRS_ACT_TRAN WHERE  SALES_PERS = ? ";
			System.out.println("checkSql:- "+checkSql);
			 pstmtComp = conn.prepareStatement(checkSql);
			 pstmtComp.setString(1, salesPers);
			 rs = pstmtComp.executeQuery();
			 if(rs.next())
			 {
				 maxDate = rs.getDate("MAXDATE");
			 }
			 System.out.println("maxDate"+maxDate);
			 Date mdate = (Date) maxDate;
			 String date1 = sdf.format(mdate);
			 Date date2 = (Date)sdf.parse(date1);
			 
			 System.out.println("Event Date: { "+evDate+"]Max  Date["+date2);
			 if(evDate.before(date2))
			 {
				 System.out.println("Value inside Event DAte ");
				 returnString = "PENDING :" + getMessageDescr(conn,"PENDDCRDEL");
			 }
			 else
			 {
				if("PR".equalsIgnoreCase(reportType))
				{
					dcrIdSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? "+
								"AND ACTIVITY_CODE IN(SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE='PR')";
					
				}
				else
				{
					dcrIdSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? "+
								"AND ACTIVITY_CODE IN(SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')";
			
				}
				pstmtSel = conn.prepareStatement(dcrIdSql);
				
				pstmtSel.setString(1, salesPers);
				pstmtSel.setTimestamp( 2 ,java.sql.Timestamp.valueOf(eventDate) );
				
				rs = pstmtSel.executeQuery();
				if(rs.next())
				{
					dcrId = rs.getString("DCR_ID");
				}
				rs.close(); rs = null;
				pstmtSel.close(); pstmtSel = null;
				
				deleteSql = "DELETE FROM SPRS_ACT_TRAN WHERE DCR_ID = ? ";
				pstmtDel = conn.prepareStatement(deleteSql);
				pstmtDel.setString(1, dcrId);
				actTranDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;
	
				System.out.println("Deleted from SPRS_ACT_TRAN =["+actTranDelCnt+"]");
	
				deleteSql = "DELETE FROM SPRS_TRAVEL WHERE DCR_ID = ? ";
				pstmtDel = conn.prepareStatement(deleteSql);
				pstmtDel.setString(1, dcrId);
				travelDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;
	
				System.out.println("Deleted from SPRS_TRAVEL =["+travelDelCnt+"]");
	
				deleteSql = "DELETE FROM STRG_MEET WHERE DCR_ID = ? ";
				pstmtDel = conn.prepareStatement(deleteSql);
				pstmtDel.setString(1, dcrId);
				meetDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;
				
				System.out.println("Deleted from STRG_MEET =["+meetDelCnt+"]");
	
				deleteSql = "DELETE FROM STRG_MEET_ITEMS WHERE DCR_ID = ? ";
				pstmtDel = conn.prepareStatement(deleteSql);
				pstmtDel.setString(1, dcrId);
				itemDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;
				
				System.out.println("Deleted from STRG_MEET_ITEMS =["+itemDelCnt+"]");
				deleteSql = "DELETE FROM STRG_MEET_ORDER WHERE DCR_ID = ? ";
				pstmtDel = conn.prepareStatement(deleteSql);
				pstmtDel.setString(1, dcrId);
				orderDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;
				
				deleteSql = "DELETE FROM STRG_MEET_TEAM WHERE DCR_ID = ? ";
				pstmtDel = conn.prepareStatement(deleteSql);
				pstmtDel.setString(1, dcrId);
				teamDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;
				
				System.out.println("Deleted from STRG_MEET_TEAM =["+teamDelCnt+"]");
				//ADDED BY BHAGYASHRI T FOR DELETE DATA FROM INVOICE TABLE[04/08/2022]
				deleteSql = "DELETE FROM STRG_MEET_INVOICE WHERE DCR_ID = ? ";
				pstmtDel = conn.prepareStatement(deleteSql);
				pstmtDel.setString(1, dcrId);
				invoicedelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;
				System.out.println("Deleted from STRG_MEET_INVOICE =["+itemDelCnt+"]");
				//ADDED BY BHAGYASHRI T FOR DELETE DATA FROM INVOICE TABLE[04/08/2022]
				
				//ADDED BY PRACHI K [W22EBAS005] ON 08-AUG-2022
				deleteSql = "DELETE FROM STRG_MEET_COLLECT WHERE DCR_ID = ? ";
				pstmtDel = conn.prepareStatement(deleteSql);
				pstmtDel.setString(1, dcrId);
				teamDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;
				
				System.out.println("Deleted from STRG_MEET_COLLECT =["+teamDelCnt+"]");
			 }
			System.out.println("Deleted from STRG_MEET_TEAM =["+teamDelCnt+"]");
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
				returnString = "FAILED:" + getMessageDescr(conn,"RPTNOTDEL");
			}
			catch(Exception e1)
			{}
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmtSel != null )
				{
					pstmtSel.close();
					pstmtSel = null;
				}
				if( pstmtDel != null )
				{
					pstmtDel.close();
					pstmtDel = null;
				}
				if( conn != null )
				{
					if(actTranDelCnt > 0 || travelDelCnt > 0 || meetDelCnt > 0 || itemDelCnt > 0 || teamDelCnt > 0 )
					{
						if("PR".equalsIgnoreCase(reportType))
						{
							returnString = "SUCCESS:" + getMessageDescr(conn,"PRDELETED");
						}
						else
						{
							returnString = "SUCCESS:" + getMessageDescr(conn,"DCRDELETED");
						}
						conn.commit();
					}
					else if(actTranDelCnt == 0 && travelDelCnt == 0 && meetDelCnt == 0 && itemDelCnt == 0 && teamDelCnt == 0)
					{
						returnString = "FAILED:" + getMessageDescr(conn,"RPTNOTDEL");
					}
					conn.close();
					conn = null;
					
				}
			}
			catch(Exception expRsc)
			{
				expRsc.printStackTrace();
			}
		}
		
		return returnString;
	}
	
	private String getMessageDescr(Connection conn, String messageNo) throws Exception
	{
		PreparedStatement pstmtSel = null;
		ResultSet rs = null;
		String messageString = "";
		try
		{
			String selectSql = "SELECT MSG_STR, MSG_DESCR FROM MESSAGES WHERE MSG_NO = ? ";

			pstmtSel = conn.prepareStatement(selectSql);
			pstmtSel.setString(1, messageNo);
			
			rs = pstmtSel.executeQuery();
			if(rs.next())
			{
				messageString = rs.getString("MSG_DESCR");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			try
			{
				if( pstmtSel != null )
				{
					pstmtSel.close();
					pstmtSel = null;
				}
			}
			catch(Exception expRsc)
			{
				expRsc.printStackTrace();
			}
		}
		System.out.println("messageString ::"+messageString);
		return messageString;
	}
	
	public String getdcrID(String eventDate, String salesPers, Connection conn) throws ITMException
	{
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		//Connection conn = null;
		ConnDriver connDriver =  new ConnDriver();
		PreparedStatement pstmtSel = null;
		ResultSet rs = null;
		String dcrId = "";
		System.out.println("Inside getDCR");
		boolean isConnLocal = false;
		String loadNo = "";
		try
		{
			eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			if( userInfo != null && conn == null)
			{
				//Modified by kailash on 21-feb-18 for multitenancy changes[Start].
				//conn = connDriver.getConnectDB("DriverITM");
				System.out.println("userInfo.getTransDB()["+userInfo.getTransDB());
				conn = connDriver.getConnectDB(userInfo.getTransDB());
				System.out.println("connection["+conn+"]");
				//Modified by kailash on 21-feb-18 for multitenancy changes[End].
				isConnLocal = true;
			}
			String dcrIdSql = "";
			
			loadNo = wsfaCommon.getLoadNo(salesPers, conn);
			
			if(loadNo != null && loadNo.length() > 0)
			{
				dcrIdSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND LOAD_NO = ? ORDER BY EVENT_DATE ";
				pstmtSel = conn.prepareStatement(dcrIdSql);
				pstmtSel.setString(1, salesPers);
				pstmtSel.setString(2, loadNo);
				rs = pstmtSel.executeQuery();
				if(rs.next())
				{
					dcrId = rs.getString("DCR_ID");
				}
			}
			else
			{
				dcrIdSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? "+
								"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')";
				//System.out.println("dcrIdSql val is :- "+dcrIdSql);
				pstmtSel = conn.prepareStatement(dcrIdSql);
				pstmtSel.setString(1, salesPers);
				pstmtSel.setTimestamp( 2 ,java.sql.Timestamp.valueOf(eventDate) );
				rs = pstmtSel.executeQuery();
				if(rs.next())
				{
					dcrId = rs.getString("DCR_ID");
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmtSel != null )
				{
					pstmtSel.close();
					pstmtSel = null;
				}
				if(conn!=null && isConnLocal)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		System.out.println("Dcrid +++ "+dcrId);
		return dcrId;
	}
	//Added by Sagar B. for photo capture report on[02-Apr-2018]START
	public String getPhotoCapturedData(String teamSelection, String fromDate, String toDate, String photoAttch, String custType, UserInfoBean userInfo ) throws ITMException
	{
		String retAllReportXML = ""; //$NON-NLS-1$
		try
		{
			if(this.ctx == null)
			{
				this.ctx = getInitialContext();
			}
			if(userInfo != null)
			{
				String loginCode = userInfo.getLoginCode();
				String transDB = userInfo.getTransDB();
				E12GenericUtility e12genericUtil = new E12GenericUtility();
				SimpleDateFormat dateFormat = new SimpleDateFormat(e12genericUtil.getApplDateFormat());
				Date date = new Date();
				if( "".equals( E12GenericUtility.checkNull(fromDate) ) )
				{
					fromDate = dateFormat.format(date);
				    System.out.println("fromDate:::["+fromDate+"]");
				}
				else
				{
					fromDate = e12genericUtil.getValidDateString(fromDate, "yyyy-MM-dd", e12genericUtil.getApplDateFormat());
				}
				if( "".equals( E12GenericUtility.checkNull(toDate) ) )
				{
					toDate = dateFormat.format(date);
					System.out.println("toDateStr:::["+toDate+"]");
				}
				else
				{
					toDate = e12genericUtil.getValidDateString(toDate, "yyyy-MM-dd", e12genericUtil.getApplDateFormat());
				}
				//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
				//PhotoCaptureReportEJBLocal photoCapturedDataObj = (PhotoCaptureReportEJBLocal)this.ctx.lookup("ibase/PhotoCaptureReportEJB/local"); //$NON-NLS-1$
				PhotoCaptureReportEJB photoCapturedDataObj = new PhotoCaptureReportEJB();
				//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
				retAllReportXML = photoCapturedDataObj.getPhotoCaptureDetails(loginCode, transDB, teamSelection, fromDate, toDate, photoAttch, custType);
				java.io.FileWriter fw = new java.io.FileWriter(CommonConstants.RIA_HDR_DATA_XMLFILE + File.separator  + loginCode+"_photo-captured.xml");
				fw.flush();
			    fw.write(retAllReportXML);
			    fw.close();
			}
			else
			{
				retAllReportXML = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}

		}
		catch (ITMException itme)
		{
			System.out.println("ITMException :DSRReportServlet :getPhotoCapturedData :==>"+itme.getMessage()); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.out.println("Exception :DSRReportServlet :getPhotoCapturedData :==>"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retAllReportXML;
	}
	//Added by Sagar B. for photo capture report on[02-Apr-2018]END
	//Added by sunny soni for getting NPC data from database according to datewise[Start]
	public String getNPCDetailsData(String fromDate, String toDate, UserInfoBean userInfo, String dispType, String teamSelection ) throws ITMException
	{
		String retAllReportXML = ""; //$NON-NLS-1$
		try
		{
			if(this.ctx == null)
			{
				this.ctx = getInitialContext();
			}
			if(userInfo != null)
			{
				String loginCode = userInfo.getLoginCode();
				String transDB = userInfo.getTransDB();
				E12GenericUtility e12genericUtil = new E12GenericUtility();
				SimpleDateFormat dateFormat = new SimpleDateFormat(e12genericUtil.getApplDateFormat());
				Date date = new Date();
				if( "".equals( E12GenericUtility.checkNull(fromDate) ) )
				{
					fromDate = dateFormat.format(date);
				    System.out.println("fromDate:::["+fromDate+"]");
				}
				else
				{
					fromDate = e12genericUtil.getValidDateString(fromDate, "yyyy-MM-dd", e12genericUtil.getApplDateFormat());
				}
				if( "".equals( E12GenericUtility.checkNull(toDate) ) )
				{
					toDate = dateFormat.format(date);
					System.out.println("toDateStr:::["+toDate+"]");
				}
				else
				{
					toDate = e12genericUtil.getValidDateString(toDate, "yyyy-MM-dd", e12genericUtil.getApplDateFormat());
				}
				PhotoCaptureReportEJB photoCapturedDataObj = new PhotoCaptureReportEJB();
				retAllReportXML = photoCapturedDataObj.getNPCDetailsData(loginCode, transDB, fromDate, toDate, dispType, teamSelection);
				java.io.FileWriter fw = new java.io.FileWriter(CommonConstants.RIA_HDR_DATA_XMLFILE + File.separator  + loginCode+"_npcData.xml");
				fw.flush();
			    fw.write(retAllReportXML);
			    fw.close();
			}
			else
			{
				retAllReportXML = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}

		}
		catch (ITMException itme)
		{
			System.out.println("ITMException :DSRReportServlet :getNPCDetailsData :==>"+itme.getMessage()); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.out.println("Exception :DSRReportServlet :getNPCDetailsData :==>"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retAllReportXML;
	}
	//Added by sunny soni for getting NPC data from database according to datewise[End]
	//Added by Mrunalini Sinkar on 08-01-2019 for calling servicehandler2(start)
	private String getUrl(String dcrId, Connection conn)
	{
		String url="";
		//Connection conn = null;
		ConnDriver connDriver =  new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql ="";
		boolean isConnLocal = false;
		try
		{
			if( userInfo != null && conn == null)
			{
				System.out.println("userInfo.getTransDB()["+userInfo.getTransDB());
				conn = connDriver.getConnectDB(userInfo.getTransDB());
				System.out.println("connection["+conn+"]");
				isConnLocal = true;
			}
			//changes by Nilesh G [25/05/2020]
			String eventCode="pre_confirm",objName="",title="",serviceUrl="",methodName="",compName="",compType="";
			String pkfieldName ="dcr_id",actionChar="C";		
			 sql ="SELECT OBJ_NAME,TITLE FROM OBJ_ACTIONS WHERE OBJ_NAME = 'strg_meet_dcr_wiz' AND RIGHTS_CHAR = 'C' ";
			pstmt = conn.prepareStatement(sql);
			rs= pstmt.executeQuery();
			if(rs.next())
			{
				objName= rs.getString("OBJ_NAME");
				title= rs.getString("TITLE");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			// added by rupali on 08/05/19 for solving issue while confirming the call [start]
			int count = 0;
			sql="SELECT COUNT(*) AS COUNT FROM SYSTEM_EVENTS A,SYSTEM_EVENT_SERVICES B WHERE A.SERVICE_CODE=B.SERVICE_CODE AND A.OBJ_NAME = ? AND EVENT_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, objName);
			pstmt.setString(2, eventCode);
			rs= pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt("COUNT");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if(count == 0)
			{
				eventCode = "pre_confirm";
			}
			// added by rupali on 08/05/19 for solving issue while confirming the call [end]
			sql="SELECT B.SERVICE_URI,B.METHOD_NAME,A.COMP_NAME,A.COMP_TYPE FROM SYSTEM_EVENTS A,SYSTEM_EVENT_SERVICES B " + 
					"WHERE A.SERVICE_CODE=B.SERVICE_CODE " + 
					"AND A.OBJ_NAME  =? AND EVENT_CODE=? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, objName);
			pstmt.setString(2, eventCode);
			rs= pstmt.executeQuery();
			if(rs.next())
			{
				serviceUrl= rs.getString("SERVICE_URI");
				methodName= rs.getString("METHOD_NAME");
				compName= rs.getString("COMP_NAME");
				compType= rs.getString("COMP_TYPE");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			 url="OBJ_NAME="+objName+"&SERVICE_CODE ="+serviceUrl+"&METHOD_NAME="+methodName+"&COMP_TYPE="+compType+"&COMP_NAME="+compName+"&REF_ID="+dcrId+"&TITLE="+title+"&PK_FLD_NAMES="+pkfieldName+"&ACTION_CHAR="+actionChar;

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null && isConnLocal)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		System.out.println("url is["+url+"]");
		return url;
	}
	//Added by Mrunalini Sinkar on 08-01-2019 for calling servicehandler2(end)
	private void addFollowUpAction( String userId, String editorId, String tranId, String objName, UserInfoBean userInfo )
	{
		try
		{
			String pendingWrkflwMapKey = userId + "~" + editorId;
			String pendingWrkflwMapValue = objName + "~" + tranId;
			BaseLogger.log("3",userInfo,null,"ServiceHandlerServlet2 pendingWrkflwMapKey::"+pendingWrkflwMapKey);
			BaseLogger.log("3",userInfo,null,"ServiceHandlerServlet2 pendingWrkflwMapValue::"+pendingWrkflwMapValue);
			Map<String, String> pendingWrkflwMap = new HashMap<String, String>();
			if ( servletContext.getAttribute( "pendingWrkflwMap" ) != null )
			{
				pendingWrkflwMap = (Map<String, String>) servletContext.getAttribute( "pendingWrkflwMap" );
				BaseLogger.log("3",userInfo,null,"ServiceHandlerServlet2 pendingWrkflwMap::"+pendingWrkflwMap);
				if ( pendingWrkflwMap != null )
				{
					pendingWrkflwMap.put( pendingWrkflwMapKey, pendingWrkflwMapValue );
				}
				AppConnectParm appConnect = new AppConnectParm();
				InitialContext ctx = new InitialContext( appConnect.getProperty() );
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
				//E12FollowUpActionLocal followUpActionLocal = (E12FollowUpActionLocal) ctx.lookup( "ibase/E12FollowUpActionEJB/local" );
				E12FollowUpActionEJB followUpActionLocal = new E12FollowUpActionEJB();
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
				//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
				BaseLogger.log("3",userInfo,null,"ServiceHandlerServlet2 pendingWrkflwMapKey::"+pendingWrkflwMapKey);

				followUpActionLocal.followUpAction( pendingWrkflwMapKey, servletContext, userInfo );

			}
			BaseLogger.log("3",userInfo,null,"ServiceHandlerServlet2 pendingWrkflwMap - "+ servletContext.getAttribute( "pendingWrkflwMap" ));
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception - "+ e.getMessage() );
			e.printStackTrace();
		}
	}
	private int generateRandomNo()
	{
		int randNo = -1;
		randNo = (int)( Math.random() * 1000000000 ) + 1;
		return randNo;
	}
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
			input = "";
		}
		return input.trim();
	}

}
