package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class WsfaStanLocalityRoute extends ValidatorEJB 
{
	E12GenericUtility genericUtility=new E12GenericUtility();
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		System.out.println("xmlString["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: WsfaStanLocalityRoute: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from WsfaStanLocalityRoute wfValData");
		return (errString);
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag,
			String xtraParams) throws ITMException
	{
		System.out.println("Inside WsfaStanLocalityRoute validation");
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String childNodeName = null;
		String errorString="";
		String userId="",sql = "";
		int ctr=0;
		int currentFormNo=0;
		int childNodeListLength=0;
		int count=0;
		try 
		{
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			if(objContext!=null && objContext.trim().length()>0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
						
			for(ctr = 0; ctr < childNodeListLength; ctr++)
			{
				childNode = childNodeList.item(ctr);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
				case 1:
					if(childNodeName.equalsIgnoreCase("trv_mode"))
					{
						if(childNode.getFirstChild()==null)
						{
							errorString= getErrorString("trv_mode","NULLTRVMOD",userId);
							break;
						}
						else
						{
							String travelMode = checkNull(genericUtility.getColumnValue("trv_mode", dom));
							sql = "SELECT COUNT(*) AS COUNT FROM TRAVEL_MODE_MASTER WHERE UPPER(TRAVEL_MODE_DESCR) = UPPER(?)";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,travelMode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								count = rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							
							if(count == 0)
							{
								errorString= getErrorString("trv_mode","TRVMODNOTE",userId);
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						String salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom));
						sql = "SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,salesPers);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							count = rs.getInt("COUNT");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						
						if(count == 0)
						{
							errorString= getErrorString("sales_pers","VTSALPER",userId);
							break;
						}
					}
					else if(childNodeName.equalsIgnoreCase("route_type__from"))
					{
						String routeTypeFrom = genericUtility.getColumnValue("route_type__from",dom);
						sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME = 'W_SPRS_ROUTE' AND FLD_NAME = 'ROUTE_TYPE' AND UPPER(FLD_VALUE) = UPPER(?) ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, routeTypeFrom);
						rs = pstmt.executeQuery();
						if ( rs.next() )
						{
							count = rs.getInt("COUNT");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
						}
						
						if(count == 0)
						{
							errorString = getErrorString( "route_type__from", "RTFRMEXIT" ,userId );
							break;
						}
					}
					else if(childNodeName.equalsIgnoreCase("route_type__to"))
					{
						String routeTypeTo = genericUtility.getColumnValue("route_type__to",dom);
						sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME = 'W_SPRS_ROUTE' AND FLD_NAME = 'ROUTE_TYPE' AND UPPER(FLD_VALUE) = UPPER(?) ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, routeTypeTo);
						rs = pstmt.executeQuery();
						if ( rs.next() )
						{
							count = rs.getInt("COUNT");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
						}
						
						if(count == 0)
						{
							errorString = getErrorString( "route_type__to", "RTTOEXIT" ,userId );
							break;
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception: WsfaStanLocalityRoute: wfValData: " + e.getMessage() + ":");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception: WsfaStanLocalityRoute: Finally Exception in wfValData:" + e.getMessage() + ":");
				e.printStackTrace();
			}

		}
		return errorString;
	}
	
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :WsfaStanLocalityRoute :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from WsfaStanLocalityRoute itemChanged");
		return errString;
	}
	
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws ITMException
	{
		System.out.println("Inside itemchange");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = null;
		String itemSeries = "",salesPers = "",spName = "",userId = "",sql = "",empCodeMGR = "",empCodeHO = "";;
		String stanCodeFrom = "",stanCodeTo = "",stanCodeFromDescr = "",stanCodeToDescr = "",trvMode = "",stanTypeFrom = "",stanTypeTo = "",routeTypeFrom = "",routeTypeTo = "";
		SimpleDateFormat sdf = null,sdf2 = null;
		int currentFormNo = 0;
		
		try
		{
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			sdf = new SimpleDateFormat("dd/MM/yyyy");
			sdf2 = new SimpleDateFormat("dd-MMM-yyyy");
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch(currentFormNo)
			{
			case 1:
				valueXmlString.append("<Detail1>");
				if ("itm_default".equalsIgnoreCase(currentColumn.trim()))
				{
					String effFrom = checkNull(getSfaParmValue(checkNull(getEmpCode(userId,conn)),"DISTANCE_EFF_FROM",conn));
					String validUpto = checkNull(getSfaParmValue(checkNull(getEmpCode(userId,conn)),"DISTANCE_VALID_UPTO",conn));
					System.out.println("Effective From is::"+effFrom);
					System.out.println("Valid Upto is::"+validUpto);
					Date effectiveFrom = sdf2.parse(effFrom);
					Date valUpto = sdf2.parse(validUpto);
					valueXmlString.append("<eff_from>").append(checkNull(sdf.format(effectiveFrom))).append("</eff_from>\r\n");
					valueXmlString.append("<valid_upto>").append(checkNull(sdf.format(valUpto))).append("</valid_upto>\r\n");
					valueXmlString.append("<trv_mode>").append("<![CDATA[ROAD]]>").append("</trv_mode>\r\n");
					valueXmlString.append("<route_type__from>").append("<![CDATA[X]]>").append("</route_type__from>\r\n");
					valueXmlString.append("<route_type__to>").append("<![CDATA[X]]>").append("</route_type__to>\r\n");
					valueXmlString.append("<distance>").append("0").append("</distance>\r\n");
				}
				else if("itm_defaultedit".equalsIgnoreCase(currentColumn.trim()))
				{
					salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom));
					stanCodeFromDescr = checkNull(genericUtility.getColumnValue("stan_descr__from", dom));
					stanCodeToDescr = checkNull(genericUtility.getColumnValue("stan_descr__to", dom));
					trvMode = checkNull(genericUtility.getColumnValue("trv_mode", dom));
					routeTypeFrom = checkNull(genericUtility.getColumnValue("route_type__from", dom));
					routeTypeTo = checkNull(genericUtility.getColumnValue("route_type__to", dom));
					valueXmlString.append("<sales_pers protect = '1'>").append(salesPers).append("</sales_pers>\r\n");
					valueXmlString.append("<stan_descr__from protect = '1'>").append(stanCodeFromDescr).append("</stan_descr__from>\r\n");
					valueXmlString.append("<stan_descr__to protect = '1'>").append(stanCodeToDescr).append("</stan_descr__to>\r\n");
					valueXmlString.append("<trv_mode protect = '1'>").append(trvMode).append("</trv_mode>\r\n");
					valueXmlString.append("<route_type__from protect = '1'>").append(routeTypeFrom).append("</route_type__from>\r\n");
					valueXmlString.append("<route_type__to protect = '1'>").append(routeTypeTo).append("</route_type__to>\r\n");
				}
				else if("sales_pers".equalsIgnoreCase(currentColumn.trim()))
				{
					salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom));
					sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,salesPers);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						spName = checkNull(rs.getString("SP_NAME"));
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					if(spName != null && spName.trim().length() > 0)
					{
						valueXmlString.append("<sp_name>").append("<![CDATA["+spName+"]]>").append("</sp_name>\r\n");
					}
					else
					{
						valueXmlString.append("<sp_name>").append("").append("</sp_name>\r\n");
					}
					itemSeries = checkNull(getItemSer(salesPers,conn));
					valueXmlString.append("<item_ser>").append("<![CDATA["+itemSeries+"]]>").append("</item_ser>\r\n");
					empCodeMGR = getMGREmployee( getEmpCode(salesPers,conn), conn );
					empCodeHO = getHOEmployee( getEmpCode(salesPers,conn), conn );
					if ( empCodeMGR != null && empCodeMGR.trim().length() > 0 )
					{
						valueXmlString.append("<user_type__login><![CDATA[").append("M").append("]]></user_type__login>\r\n");
					}
					else if ( empCodeHO != null && empCodeHO.trim().length() > 0 )
					{
						valueXmlString.append("<user_type__login><![CDATA[").append("H").append("]]></user_type__login>\r\n");
					}
					else
					{
						valueXmlString.append("<user_type__login><![CDATA[").append("SO").append("]]></user_type__login>\r\n");
					}
				}
				else if("stan_descr__from".equalsIgnoreCase(currentColumn.trim()))
				{
					salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom));
					stanCodeFromDescr = checkNull(genericUtility.getColumnValue("stan_descr__from", dom));
					routeTypeFrom = checkNull(genericUtility.getColumnValue("route_type__from", dom));
					System.out.println("stanCodeFromDescr::"+stanCodeFromDescr);
					
					if(checkStationExist(stanCodeFromDescr,conn))
					{
						stanCodeFrom = checkNull(getStationCode(stanCodeFromDescr,conn));
						stanTypeFrom = checkNull(getExistingStationType(stanCodeFrom,salesPers,conn));
						routeTypeFrom = checkNull(getExistingRouteType(stanCodeFrom,salesPers,conn));
						
						valueXmlString.append("<stan_code__from>").append("<![CDATA["+stanCodeFrom+"]]>").append("</stan_code__from>\r\n");
						valueXmlString.append("<stan_type__from>").append("<![CDATA["+stanTypeFrom+"]]>").append("</stan_type__from>\r\n");
						if(routeTypeFrom != null && routeTypeFrom.trim().length() > 0)
						{
							valueXmlString.append("<route_type__from protect = '1'>").append("<![CDATA["+routeTypeFrom+"]]>").append("</route_type__from>\r\n");
						}
						else
						{
							valueXmlString.append("<route_type__from protect = '0'>").append("<![CDATA[X]]>").append("</route_type__from>\r\n");
						}
					}
					else
					{
						valueXmlString.append("<stan_code__from>").append("").append("</stan_code__from>\r\n");
						valueXmlString.append("<stan_type__from>").append("").append("</stan_type__from>\r\n");
						valueXmlString.append("<route_type__to protect = '0'>").append("<![CDATA[X]]>").append("</route_type__to>\r\n");
					}
				}
				else if("stan_descr__to".equalsIgnoreCase(currentColumn.trim()))
				{
					salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom));
					stanCodeToDescr = checkNull(genericUtility.getColumnValue("stan_descr__to", dom));
					routeTypeTo = checkNull(genericUtility.getColumnValue("route_type__to", dom));
					if(checkStationExist(stanCodeToDescr,conn))
					{
						stanCodeTo = checkNull(getStationCode(stanCodeToDescr,conn));
						stanTypeTo = checkNull(getExistingStationType(stanCodeTo,salesPers,conn));
						routeTypeTo = checkNull(getExistingRouteType(stanCodeTo,salesPers,conn));
						
						valueXmlString.append("<stan_code__to>").append("<![CDATA["+stanCodeTo+"]]>").append("</stan_code__to>\r\n");
						valueXmlString.append("<stan_type__to>").append("<![CDATA["+stanTypeTo+"]]>").append("</stan_type__to>\r\n");
						if(routeTypeTo != null && routeTypeTo.trim().length() > 0)
						{
							valueXmlString.append("<route_type__to protect = '1'>").append("<![CDATA["+routeTypeTo+"]]>").append("</route_type__to>\r\n");
						}
						else
						{
							valueXmlString.append("<route_type__to protect = '0'>").append("<![CDATA[X]]>").append("</route_type__to>\r\n");
						}
					}
					else
					{
						valueXmlString.append("<stan_code__to>").append("").append("</stan_code__to>\r\n");
						valueXmlString.append("<stan_type__to>").append("").append("</stan_type__to>\r\n");
						valueXmlString.append("<route_type__to protect = '0'>").append("<![CDATA[X]]>").append("</route_type__to>\r\n");
					}
				}
				valueXmlString.append ("</Detail1>\r\n");
				break;
			}
			valueXmlString.append("</Root>\r\n");
		}
		catch(Exception e)
		{
			System.out.println("Exception :WsfaStanLocalityRoute :itemChanged(Document,String):" + e.getMessage() + ":");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :WsfaStanLocalityRoute :Exception in SQL" + e.getMessage() + ":");
				e.printStackTrace();
			}
		}
		return valueXmlString.toString();
	}
	
	private String checkNull(String input) 
	{
		if (input == null) 
		{
			input = "";
		}
		else 
		{
			input = input.trim();
		}
		return input;
	}
	
	public String getItemSer(String salesPers, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String itemSer = "";
		try
		{
			sql = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemSer = checkNull(rs.getString("ITEM_SER"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(itemSer.trim().length() == 0)
			{
				sql = "SELECT D.ITEM_SER AS ITEM_SER FROM DEPARTMENT D,EMPLOYEE E WHERE E.DEPT_CODE = D.DEPT_CODE AND E.EMP_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					itemSer = checkNull(rs.getString("ITEM_SER"));
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :WsfaStanLocalityRoute :itemChanged(Document,String):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :WsfaStanLocalityRoute :Exception in SQL" + e.getMessage() + ":");
				e.printStackTrace();
			}
		}
		return itemSer;
	}	
	
	public String getStationCode(String stanCodeDescr, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String stanCode = "";
		try
		{
			sql = "SELECT STAN_CODE FROM STATION WHERE UPPER(DESCR) = UPPER(?)";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,stanCodeDescr);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				stanCode = checkNull(rs.getString("STAN_CODE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :WsfaStanLocalityRoute :getStationCode():" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		return stanCode;
	}
	
    public String getExistingStationType(String stanCode,String salesPers, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",stanType = "";
		try
		{
			sql = "SELECT STATION_TYPE FROM SPRS_ROUTE WHERE STAN_CODE = ? AND SPRS_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,stanCode);
			pstmt.setString(2,salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				stanType = checkNull(rs.getString("STATION_TYPE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :WsfaStanLocalityRoute :getStationType():" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		return stanType;
	}
    
    public String getExistingRouteType(String stanCode,String salesPers, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",routeType = "";
		try
		{
			sql = "SELECT ROUTE_TYPE FROM SPRS_ROUTE WHERE STAN_CODE = ? AND SPRS_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,stanCode);
			pstmt.setString(2,salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				routeType = checkNull(rs.getString("ROUTE_TYPE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :WsfaStanLocalityRoute :getStationType():" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		return routeType;
	}
	
	public boolean checkStationExist(String stanCodeDescr,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isStationExist = false;
		String sql = "";
		int multipleStationCnt = 0, singleStationCnt = 0;
		try
		{
			sql = "SELECT COUNT(*) AS COUNT FROM STATION WHERE UPPER(DESCR) LIKE UPPER('%"+stanCodeDescr+"%')";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				multipleStationCnt = rs.getInt("COUNT");
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(multipleStationCnt > 0)
			{
				sql = "SELECT COUNT(*) AS COUNT FROM STATION WHERE UPPER(DESCR) = UPPER(?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,stanCodeDescr);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					singleStationCnt = rs.getInt("COUNT");
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				if(singleStationCnt == 0)
				{
					isStationExist = false;
				}
				else
				{
					isStationExist = true;
				}
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		return isStationExist;
	}
	
	private String getEmpCode(String userId,Connection connectionObject) throws ITMException
	{
		String empCode="";
		String entityCode="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		try
		{
			sql = "SELECT EMP_CODE,ENTITY_CODE FROM USERS WHERE CODE= ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				empCode = checkNull(rs.getString("EMP_CODE"));
				entityCode = checkNull(rs.getString("ENTITY_CODE"));
			}
			if(empCode == null || empCode.trim().length() == 0)
			{
				empCode = entityCode;
			}

		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaStanLocalityRoute:getEmpCode():==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				e.getMessage();
			}
		}
		return empCode;
	}
	
	public String getStateCode(String salesPers,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",stateCode = "",countCode = "", pin = "";
		StringBuffer stateCountPinbuff = null;
		try
		{
			stateCountPinbuff = new StringBuffer();
			sql = "SELECT STATE_CODE,COUNT_CODE,PIN FROM SALES_PERS WHERE SALES_PERS = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1,salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				stateCode = checkNull(rs.getString("STATE_CODE"));
				countCode = checkNull(rs.getString("COUNT_CODE"));
				pin = checkNull(rs.getString("PIN"));
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(pin == null || pin.trim().length() == 0)
			{
				sql = "SELECT CUR_PIN FROM EMPLOYEE WHERE EMP_CODE = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					pin = checkNull(rs.getString("CUR_PIN"));
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			
			if (stateCode != null && stateCode.trim().length() > 0) 
			{
	            stateCountPinbuff.append(stateCode);
	            if (countCode != null && countCode.trim().length() > 0) 
	            {
	                stateCountPinbuff.append(",");
	            }
	        }
	        if (countCode != null && countCode.trim().length() > 0) 
	        {
	            stateCountPinbuff.append(countCode);
	            if (pin != null && pin.trim().length() > 0) 
	            {
	                stateCountPinbuff.append(",");
	            }
	        }
	        if (pin != null && pin.trim().length() > 0) 
	        {
	            stateCountPinbuff.append(pin);
	        }
			
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		
		return stateCountPinbuff.toString();
	}
	
	public String getSfaParmValue(String userId,String paramName,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;

		PreparedStatement allPstmt = null;
		ResultSet allRs = null;
		String empSite="";
		String itemSer="";
		String paramValue="";
		boolean isLocalConn =false;
		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME= ? ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empSite+"_"+itemSer);
			pstmt.setString(2, paramName);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				paramValue  = checkNull(rs.getString(1));
			}
			else
			{
				pstmt1 = connectionObject.prepareStatement(sql);
				pstmt1.setString(1, itemSer);
				pstmt1.setString(2, paramName);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					paramValue  = checkNull(rs1.getString(1));
				}
				else
				{
					allPstmt = connectionObject.prepareStatement(sql);
					allPstmt.setString(1, "ALL");
					allPstmt.setString(2, paramName);
					allRs = allPstmt.executeQuery();
					if(allRs.next())
					{
						paramValue  = checkNull(allRs.getString(1));
					}
				}
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of isPlan is::........."+paramValue);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return paramValue;
	}
	
	public boolean checkTravelDistanceEntry(String stanCodeFrom,String stanCodeTo,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isEntryExist = false;
		String sql = "";
		int dupEntryCnt = 0;
		try
		{
			sql = "SELECT COUNT(*) AS COUNT FROM TRV_DISTANCE WHERE STAN_CODE__FROM = ? AND STAN_CODE__TO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,stanCodeFrom);
			pstmt.setString(2,stanCodeTo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				dupEntryCnt = rs.getInt("COUNT");
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(dupEntryCnt == 0)
			{
				isEntryExist = false;
			}
			else
			{
				isEntryExist = true;
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		return isEntryExist;
	}
	
	private String getHOEmployee( String empCode, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeHO = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " +
					"WHERE A.EMP_CODE = ? " +
					"AND A.PROFILE_ID = B.PROFILE_ID " +
					"AND B.APPLICATION = 'MRO' " +
					"AND B.MENU_ROW = 1 " +
					"AND B.MENU_COL = 1 " +
					"AND B.MENU_SUBCOL = 1 " +
					"AND B.LEVEL_4 = 1 " +
					"AND B.LEVEL_5 = 1 " +
					"AND B.MENU_NAME = 'MR Online Application' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				empCodeHO = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		System.out.println("empCodeHO::"+empCodeHO);
		return empCodeHO;
	}
	private String getMGREmployee( String empCode, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " +
					"WHERE A.EMP_CODE = ? " +
					"AND A.GRADE = B.GRADE_CODE " +
					"AND B.GRADE_TYPE = 'M' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		System.out.println("empCodeMGR::"+empCodeMGR);
		return empCodeMGR;
	}
	
}