/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw.schedule;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.WorkflowEngineEJB;
import ibase.wrkflw.schedule.WorkflowSheduleLocal;
import ibase.wrkflw.schedule.WorkflowSheduleRemote;
import ibase.wrkflw.utility.WorkflowLogger;
import ibase.wrkflw.utility.WorkflowProcessIdGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class WorkflowShedule
implements Schedule,
WorkflowSheduleLocal,
WorkflowSheduleRemote {
    static boolean IS_SCHEDLUER_ON = false;
    public static int SCHEDULER_INVOCATION_CTR = 0;

    @Override
    public String schedulePriority(String wrkflwPriority) throws Exception {
        block15: {
            WorkflowLogger.info("schedulePriority: wrkflwPriority [" + wrkflwPriority + "]");
            Connection conn = null;
            boolean isRecordsAvailable = false;
            try {
                try {
                    WorkflowLogger.info("Invoked Scheduler curr status IS_SCHEDLUER_ON :[" + SCHEDULER_INVOCATION_CTR + "] :[" + IS_SCHEDLUER_ON + "]");
                    WorkflowLogger.info("IS_SCHEDLUER_ON [" + SCHEDULER_INVOCATION_CTR + "] :[" + IS_SCHEDLUER_ON + "]");
                    if (!IS_SCHEDLUER_ON) {
                        IS_SCHEDLUER_ON = true;
                        WorkflowLogger.info("Successful Invocation curr status IS_SCHEDLUER_ON :[" + ++SCHEDULER_INVOCATION_CTR + "] :[" + IS_SCHEDLUER_ON + "]");
                        conn = new ConnDriver().getConnectDB(CommonConstants.WRKFLW_DB);
                        String sql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, PROCESS_STATUS, SEQ_ID FROM WF_PRC_STATUS,  TRANSETUP WHERE PROCESS_STATUS=1 AND CASE WHEN WRKFLW_PRIORITY IS NULL THEN '9' ELSE WRKFLW_PRIORITY END = '" + wrkflwPriority + "' AND UPPER( TRIM( TRANSETUP.TRAN_WINDOW ) ) = UPPER( TRIM( 'W_' || WF_PRC_STATUS.OBJ_NAME ) ) ORDER BY STATUS_DATE ";
                        WorkflowLogger.info("sql [" + sql + "] ");
                        WorkflowLogger.info("Checking for activity status=1 for Escalation :[" + SCHEDULER_INVOCATION_CTR + "]");
                        this.processRecords(conn, sql);
                        WorkflowLogger.info("Completed processing for Escalation :[" + SCHEDULER_INVOCATION_CTR + "]");
                        do {
                            sql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, PROCESS_STATUS, SEQ_ID FROM WF_PRC_STATUS,  TRANSETUP WHERE PROCESS_STATUS=0  AND CASE WHEN ERR_STATUS IS NULL THEN '0' ELSE ERR_STATUS END != '1' AND CASE WHEN WRKFLW_PRIORITY IS NULL THEN '9' ELSE WRKFLW_PRIORITY END =  '" + wrkflwPriority + "'  AND UPPER( TRIM( TRANSETUP.TRAN_WINDOW ) ) = UPPER( TRIM( 'W_' || WF_PRC_STATUS.OBJ_NAME ) ) ORDER BY STATUS_DATE ";
                            WorkflowLogger.info("Checking for activity status=0 for starting workflow :[" + SCHEDULER_INVOCATION_CTR + "]");
                            WorkflowLogger.info("sql [" + sql + "] ");
                            isRecordsAvailable = this.processRecords(conn, sql);
                            WorkflowLogger.info("Completed processing of starting activities :[" + SCHEDULER_INVOCATION_CTR + "]");
                            WorkflowLogger.info("Current iteration isRecordsAvailable status [" + SCHEDULER_INVOCATION_CTR + "] :[" + isRecordsAvailable + "]");
                        } while (isRecordsAvailable);
                        WorkflowLogger.info("--------------Exiting current schedule as no more activities to be processed [" + SCHEDULER_INVOCATION_CTR + "]------------------------");
                        IS_SCHEDLUER_ON = false;
                        break block15;
                    }
                    WorkflowLogger.info("Unable to Invoke scheduler curr status IS_SCHEDLUER_ON :[" + SCHEDULER_INVOCATION_CTR + "] :[" + IS_SCHEDLUER_ON + "]");
                }
                catch (Exception e) {
                    conn.rollback();
                    WorkflowLogger.info("Exception :WorkflowShedule :schedule :<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                    e.printStackTrace();
                    WorkflowLogger.info("Exception :WorkflowShedule :schedule :>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                    try {
                        IS_SCHEDLUER_ON = false;
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (Exception e2) {
                        WorkflowLogger.info("Exception :WorkflowShedule :schedule from finally :<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                        e2.printStackTrace();
                        WorkflowLogger.info("Exception :WorkflowShedule :schedule from finally :>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                    }
                }
            }
            finally {
                try {
                    IS_SCHEDLUER_ON = false;
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    WorkflowLogger.info("Exception :WorkflowShedule :schedule from finally :<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                    e.printStackTrace();
                    WorkflowLogger.info("Exception :WorkflowShedule :schedule from finally :>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                }
            }
        }
        return "";
    }

    @Override
    public String schedule(String name) throws Exception {
        block19: {
            E12GenericUtility genericUtility = new E12GenericUtility();
            BaseLogger.log("2", null, null, "schedule name::" + name);
            HashMap<String, String> getParamMap = this.getScheduleParamlMap(name);
            String transDb = E12GenericUtility.checkNull(getParamMap.get("TRANS_DB"));
            BaseLogger.log("2", null, null, "transDb :::::" + transDb);
            String userInfoXML = "";
            try {
                Document document = genericUtility.parseString(name);
                Node userInfoNode = document.getElementsByTagName("UserInfo").item(0);
                if (userInfoNode != null) {
                    userInfoXML = genericUtility.serializeDom(userInfoNode);
                    userInfoXML = E12GenericUtility.checkNull(userInfoXML);
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", null, null, "Exception in WorkflowShedule :: schedule() : " + ex);
            }
            System.out.printf("WorkflowShedule :: schedule() : userInfoXML [%s]\n", userInfoXML);
            Connection conn = null;
            boolean isRecordsAvailable = false;
            try {
                try {
                    WorkflowLogger.info("Invoked Scheduler curr status IS_SCHEDLUER_ON :[" + SCHEDULER_INVOCATION_CTR + "] :[" + IS_SCHEDLUER_ON + "]");
                    WorkflowLogger.info("IS_SCHEDLUER_ON [" + SCHEDULER_INVOCATION_CTR + "] :[" + IS_SCHEDLUER_ON + "]");
                    if (!IS_SCHEDLUER_ON) {
                        IS_SCHEDLUER_ON = true;
                        WorkflowLogger.info("Successful Invocation curr status IS_SCHEDLUER_ON :[" + ++SCHEDULER_INVOCATION_CTR + "] :[" + IS_SCHEDLUER_ON + "]");
                        if (transDb.length() == 0 || transDb.equalsIgnoreCase("0")) {
                            BaseLogger.log("3", null, null, "trans db is blank :::::");
                            throw new ITMException(new Exception("TransDB is NULL "));
                        }
                        BaseLogger.log("3", null, null, "trans db is NOT  blank :::::");
                        conn = new ConnDriver().getConnectDB(transDb);
                        String sql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, PROCESS_STATUS, SEQ_ID FROM WF_PRC_STATUS WHERE PROCESS_STATUS=1 AND (CASE WHEN ERR_STATUS IS NULL THEN '0' ELSE ERR_STATUS END) != '1' AND WF_ABORT IS NULL ORDER BY STATUS_DATE ";
                        WorkflowLogger.info("Checking for activity status=1 for Escalation :[" + SCHEDULER_INVOCATION_CTR + "]");
                        this.processRecords(conn, sql, userInfoXML);
                        WorkflowLogger.info("Completed processing for Escalation :[" + SCHEDULER_INVOCATION_CTR + "]");
                        do {
                            sql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, PROCESS_STATUS, SEQ_ID FROM WF_PRC_STATUS WHERE PROCESS_STATUS=0  AND (CASE WHEN ERR_STATUS IS NULL THEN '0' ELSE ERR_STATUS END) != '1' AND WF_ABORT IS NULL ORDER BY STATUS_DATE ";
                            WorkflowLogger.info("Checking for activity status=0 for starting workflow :[" + SCHEDULER_INVOCATION_CTR + "]");
                            isRecordsAvailable = this.processRecords(conn, sql, userInfoXML);
                            WorkflowLogger.info("Completed processing of starting activities :[" + SCHEDULER_INVOCATION_CTR + "]");
                            WorkflowLogger.info("Current iteration isRecordsAvailable status [" + SCHEDULER_INVOCATION_CTR + "] :[" + isRecordsAvailable + "]");
                        } while (isRecordsAvailable);
                        WorkflowLogger.info("--------------Exiting current schedule as no more activities to be processed [" + SCHEDULER_INVOCATION_CTR + "]------------------------");
                        IS_SCHEDLUER_ON = false;
                        break block19;
                    }
                    WorkflowLogger.info("Unable to Invoke scheduler curr status IS_SCHEDLUER_ON :[" + SCHEDULER_INVOCATION_CTR + "] :[" + IS_SCHEDLUER_ON + "]");
                }
                catch (Exception e) {
                    conn.rollback();
                    WorkflowLogger.info("Exception :WorkflowShedule :schedule :<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                    e.printStackTrace();
                    WorkflowLogger.info("Exception :WorkflowShedule :schedule :>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                    try {
                        IS_SCHEDLUER_ON = false;
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (Exception e2) {
                        WorkflowLogger.info("Exception :WorkflowShedule :schedule from finally :<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                        e2.printStackTrace();
                        WorkflowLogger.info("Exception :WorkflowShedule :schedule from finally :>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                    }
                }
            }
            finally {
                try {
                    IS_SCHEDLUER_ON = false;
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    WorkflowLogger.info("Exception :WorkflowShedule :schedule from finally :<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                    e.printStackTrace();
                    WorkflowLogger.info("Exception :WorkflowShedule :schedule from finally :>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                }
            }
        }
        return "";
    }

    @Override
    public String schedule(HashMap map) throws Exception {
        return this.schedule((String)map.get("PROCESS_NAME"));
    }

    private boolean processRecords(Connection conn, String sql) throws BaseException {
        return this.processRecords(conn, sql, "");
    }

    private boolean processRecords(Connection conn, String sql, String userInfoXML) throws BaseException {
        WorkflowLogger.info("Querying db for processing any schedulable activities [" + SCHEDULER_INVOCATION_CTR + "]");
        boolean isRecordsAvailable = false;
        Statement stmt = null;
        boolean isException = false;
        try {
            try {
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                AppConnectParm appConnect = new AppConnectParm();
                Properties p = appConnect.getProperty();
                InitialContext ctx = new InitialContext(p);
                WorkflowEngineEJB workflowEngine = new WorkflowEngineEJB();
                while (rs.next()) {
                    String processInstanceId;
                    block56: {
                        int procStatus;
                        block62: {
                            block58: {
                                block61: {
                                    block57: {
                                        BaseLogger.log("3", null, null, "@@@@ Row :[" + rs.getRow() + "]");
                                        WorkflowLogger.info("Found records in WF_PRC_STATUS :[" + SCHEDULER_INVOCATION_CTR + "]");
                                        isRecordsAvailable = true;
                                        isException = false;
                                        processInstanceId = WorkflowProcessIdGenerator.getInstance().createProcessInstanceId(rs.getString("PROCESS_ID"), rs.getString("INSTANCE_ID"), rs.getString("ACTIVITY_ID"), rs.getString("SEQ_ID"));
                                        try {
                                            this.updateWFActivityStartEndDate(processInstanceId, "ACT_START_DATE", conn);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        procStatus = rs.getInt("PROCESS_STATUS");
                                        if (procStatus != 0) break block61;
                                        WorkflowLogger.info("Performing new activity with status=0 processInstanceId [" + SCHEDULER_INVOCATION_CTR + "] :[" + processInstanceId + "]");
                                        try {
                                            workflowEngine.performActivity(processInstanceId, conn, userInfoXML);
                                        }
                                        catch (BaseException be) {
                                            isException = true;
                                            be.printStackTrace();
                                            this.writeWrkflwScheduleException("\n\n Exception occured at WorkflowSchedule : processRecords : procStatus == 0 for processInstanceId [" + processInstanceId + "] Exception [" + be.getMessage() + "]", processInstanceId);
                                            if (conn != null) {
                                                if (isException) {
                                                    BaseLogger.log("3", null, null, "Connection Rollback for the processInstanceId : [ " + processInstanceId + " ]");
                                                    conn.rollback();
                                                } else {
                                                    BaseLogger.log("3", null, null, "Connection Commit for the processInstanceId : [ " + processInstanceId + " ]");
                                                    conn.commit();
                                                }
                                            }
                                            break block56;
                                        }
                                        catch (Exception e) {
                                            try {
                                                isException = true;
                                                e.printStackTrace();
                                                this.writeWrkflwScheduleException("\n\n Exception occured at WorkflowSchedule : processRecords : procStatus == 0 for processInstanceId [" + processInstanceId + "] Exception [" + e.getMessage() + "]", processInstanceId);
                                                break block56;
                                            }
                                            catch (Throwable throwable) {
                                                throw throwable;
                                            }
                                            finally {
                                                if (conn != null) {
                                                    if (isException) {
                                                        BaseLogger.log("3", null, null, "Connection Rollback for the processInstanceId : [ " + processInstanceId + " ]");
                                                        conn.rollback();
                                                    } else {
                                                        BaseLogger.log("3", null, null, "Connection Commit for the processInstanceId : [ " + processInstanceId + " ]");
                                                        conn.commit();
                                                    }
                                                }
                                            }
                                        }
                                        if (conn == null) break block56;
                                        if (!isException) break block57;
                                        BaseLogger.log("3", null, null, "Connection Rollback for the processInstanceId : [ " + processInstanceId + " ]");
                                        conn.rollback();
                                        break block56;
                                    }
                                    BaseLogger.log("3", null, null, "Connection Commit for the processInstanceId : [ " + processInstanceId + " ]");
                                    conn.commit();
                                    break block56;
                                }
                                if (procStatus != 1) break block62;
                                WorkflowLogger.info("Escalation checking for activity with status=1 processInstanceId [" + SCHEDULER_INVOCATION_CTR + "] :[" + processInstanceId + "]");
                                try {
                                    workflowEngine.checkForEscalation(processInstanceId, conn);
                                }
                                catch (BaseException be) {
                                    isException = true;
                                    be.printStackTrace();
                                    this.writeWrkflwScheduleException("\n\n Exception occured at WorkflowSchedule : processRecords : procStatus == 1 for processInstanceId [" + processInstanceId + "] Exception  [" + be.getMessage() + "]", processInstanceId);
                                    if (conn != null) {
                                        if (isException) {
                                            BaseLogger.log("3", null, null, "Connection Rollback for the processInstanceId : [ " + processInstanceId + " ]");
                                            conn.rollback();
                                        } else {
                                            BaseLogger.log("3", null, null, "Connection Commit for the processInstanceId : [ " + processInstanceId + " ]");
                                            conn.commit();
                                        }
                                    }
                                    break block56;
                                }
                                catch (Exception e) {
                                    try {
                                        isException = true;
                                        e.printStackTrace();
                                        this.writeWrkflwScheduleException("\n\n Exception occured at WorkflowSchedule : processRecords : procStatus == 1 for processInstanceId [" + processInstanceId + "] Exception  [" + e.getMessage() + "]", processInstanceId);
                                        break block56;
                                    }
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                    finally {
                                        if (conn != null) {
                                            if (isException) {
                                                BaseLogger.log("3", null, null, "Connection Rollback for the processInstanceId : [ " + processInstanceId + " ]");
                                                conn.rollback();
                                            } else {
                                                BaseLogger.log("3", null, null, "Connection Commit for the processInstanceId : [ " + processInstanceId + " ]");
                                                conn.commit();
                                            }
                                        }
                                    }
                                }
                                if (conn == null) break block56;
                                if (!isException) break block58;
                                BaseLogger.log("3", null, null, "Connection Rollback for the processInstanceId : [ " + processInstanceId + " ]");
                                conn.rollback();
                                break block56;
                            }
                            BaseLogger.log("3", null, null, "Connection Commit for the processInstanceId : [ " + processInstanceId + " ]");
                            conn.commit();
                            break block56;
                        }
                        if (procStatus == 2) {
                            block59: {
                                WorkflowLogger.info("Calling activity to be completed if found at status '2' ");
                                try {
                                    workflowEngine.completeActivity(processInstanceId, "", conn);
                                }
                                catch (BaseException be) {
                                    isException = true;
                                    be.printStackTrace();
                                    this.writeWrkflwScheduleException("\n\n Exception occured at WorkflowSchedule : processRecords : procStatus == 2 for processInstanceId [" + processInstanceId + "] Exception [" + be.getMessage() + "]", processInstanceId);
                                    if (conn != null) {
                                        if (isException) {
                                            BaseLogger.log("3", null, null, "Connection Rollback for the processInstanceId : [ " + processInstanceId + " ]");
                                            conn.rollback();
                                        } else {
                                            BaseLogger.log("3", null, null, "Connection Commit for the processInstanceId : [ " + processInstanceId + " ]");
                                            conn.commit();
                                        }
                                    }
                                    break block56;
                                }
                                catch (Exception e) {
                                    try {
                                        isException = true;
                                        e.printStackTrace();
                                        this.writeWrkflwScheduleException("\n\n Exception occured at WorkflowSchedule : processRecords : procStatus == 2 for processInstanceId [" + processInstanceId + "] Exception [" + e.getMessage() + "]", processInstanceId);
                                        break block56;
                                    }
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                    finally {
                                        if (conn != null) {
                                            if (isException) {
                                                BaseLogger.log("3", null, null, "Connection Rollback for the processInstanceId : [ " + processInstanceId + " ]");
                                                conn.rollback();
                                            } else {
                                                BaseLogger.log("3", null, null, "Connection Commit for the processInstanceId : [ " + processInstanceId + " ]");
                                                conn.commit();
                                            }
                                        }
                                    }
                                }
                                if (conn == null) break block56;
                                if (!isException) break block59;
                                BaseLogger.log("3", null, null, "Connection Rollback for the processInstanceId : [ " + processInstanceId + " ]");
                                conn.rollback();
                                break block56;
                            }
                            BaseLogger.log("3", null, null, "Connection Commit for the processInstanceId : [ " + processInstanceId + " ]");
                            conn.commit();
                        }
                    }
                    try {
                        this.updateWFActivityStartEndDate(processInstanceId, "ACT_END_DATE", conn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("Finished curr session processing any schedulable activities [" + SCHEDULER_INVOCATION_CTR + "]");
        return isRecordsAvailable;
    }

    private boolean writeWrkflwScheduleException(String errorMsg, String processInstanceId) throws BaseException {
        BufferedWriter excpFileWriter = null;
        try {
            try {
                if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + processInstanceId + "workflwScheduleException.txt").exists()) {
                    new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + processInstanceId + "workflwScheduleException.txt").createNewFile();
                }
                String exceptionFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + processInstanceId + "workflwScheduleException.txt";
                excpFileWriter = new BufferedWriter(new FileWriter(exceptionFileName));
                excpFileWriter.newLine();
                excpFileWriter.append("\n" + errorMsg);
                excpFileWriter.flush();
                excpFileWriter.close();
                excpFileWriter = null;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (excpFileWriter != null) {
                    excpFileWriter.flush();
                    excpFileWriter.close();
                    excpFileWriter = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                excpFileWriter = null;
            }
        }
        return true;
    }

    private void updateWFActivityStartEndDate(String processInstanceId, String columnName, Connection conn) throws BaseException {
        WorkflowLogger.info("WorkflowSchedule.updateActivityStartDate ::::::::::::: columnName ::: [" + columnName + "]");
        Statement pstmtUpd = null;
        int updateCnt = 0;
        String updateSql = "";
        String DB_NAME = CommonConstants.DB_NAME;
        boolean isError = false;
        try {
            try {
                String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                String activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
                BaseLogger.log("3", null, null, "processId :: [" + processId + "] instanceId :: [" + instanceId + "] activityId :: [" + activityId + "] seqId :: [" + seqId + "]");
                BaseLogger.log("3", null, null, " updateWFActivityStartEndDate :: DB_NAME :: [" + DB_NAME + "]");
                E12GenericUtility genericUtility = new E12GenericUtility();
                SimpleDateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
                String currDate = dtFormat.format(Calendar.getInstance().getTime());
                currDate = genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                BaseLogger.log("3", null, null, " updateWFActivityStartEndDate :: currDate :: [" + currDate + "]");
                updateSql = " UPDATE WF_PRC_STATUS SET " + columnName + " = ? " + " WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ? ";
                pstmtUpd = conn.prepareStatement(updateSql);
                pstmtUpd.setTimestamp(1, Timestamp.valueOf(currDate));
                pstmtUpd.setString(2, processId);
                pstmtUpd.setString(3, instanceId);
                pstmtUpd.setString(4, activityId);
                pstmtUpd.setString(5, seqId);
                updateCnt = pstmtUpd.executeUpdate();
                BaseLogger.log("3", null, null, "updateActivityStartEndDate >> WF_PRC_STATUS >> updateCnt =[" + updateCnt + "]");
            }
            catch (Exception e) {
                isError = true;
                try {
                    conn.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmtUpd != null) {
                    pstmtUpd.close();
                    pstmtUpd = null;
                }
                if (conn != null && !isError) {
                    conn.commit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
    }

    private HashMap<String, String> getScheduleParamlMap(String scheduleParamXML) throws ITMException {
        Document dom = null;
        NodeList nodeList = null;
        String nodeName = "";
        String nodeValue = "";
        HashMap<String, String> getParamMap = new HashMap<String, String>();
        E12GenericUtility genericUtility = new E12GenericUtility();
        BaseLogger.log("2", null, null, "scheduleParamXML ::" + scheduleParamXML);
        dom = genericUtility.parseString(scheduleParamXML);
        nodeList = dom.getElementsByTagName("ACTUALPARAMETER");
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            BaseLogger.log("3", null, null, "test123::" + genericUtility.serializeDom(childNode).contains("name"));
            if (childNode.getNodeType() == 1 && childNode != null) {
                if (genericUtility.serializeDom(childNode).contains("name")) {
                    nodeName = this.getAttributeVal(childNode);
                }
                BaseLogger.log("3", null, null, "nodeName" + nodeName);
                if (childNode.getFirstChild() != null && nodeName != null) {
                    nodeValue = childNode.getFirstChild().getNodeValue();
                    BaseLogger.log("3", null, null, "nodeValue" + nodeValue);
                    getParamMap.put(nodeName, nodeValue);
                }
            }
            ++i;
        }
        BaseLogger.log("2", null, null, "getParamMap ::" + getParamMap);
        return getParamMap;
    }

    private String getAttributeVal(Node childNode) throws ITMException {
        String attribFound = "";
        try {
            if (childNode != null && childNode.getAttributes() != null && childNode.getAttributes().getNamedItem("name").getNodeValue() != null) {
                attribFound = childNode.getAttributes().getNamedItem("name").getNodeValue();
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "attribFound = [" + attribFound + "]");
        return attribFound;
    }
}

