package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import ibase.utility.EMail;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.*;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
@Stateless
public  class StrgCustAmdWFComp extends ValidatorEJB  
{
	E12GenericUtility genericUtility = new E12GenericUtility();
   
    public String strgCustAmdApprove(String tranId, String xmlString, String refSer, String empCode, String processID,String userInfoStr) throws RemoteException, ITMException 
	{
		Document dom = null;
		System.out.println("Strategic Customer Amendment Approval "+xmlString+" and ref ser is["+refSer+"]");
		Connection conn = null;
		PreparedStatement pStmt = null;
		PreparedStatement pstmtAttachment = null;
		PreparedStatement pstmtSelAttach = null;
		PreparedStatement pstmtCountAttach = null;
		ResultSet rsCountAttach=null;
		int attchmentCount=0;
		ResultSet rsSelAttach=null;
		ConnDriver connDriver = null;
		boolean isError = false;
		String retString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ Customer Approved successfully ]]></RESULT></ROOT>";
		try
		{
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			String scCode = genericUtility.getColumnValue("sc_code",dom);

			connDriver = new ConnDriver();
			//Added By Nilesh For instance workflow changes Start :: 13-04-18
			String transDB="";
			System.out.println("Inside expenseConfirm confirm section: "+userInfoStr);
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if(userInfo!=null)
			{
				transDB = userInfo.getTransDB();
			}
	    	System.out.println("get TransDB connection in expenseConfirm : "+transDB);

		    if (transDB != null && transDB.trim().length() > 0)
		    {
		    	conn = connDriver.getConnectDB(transDB);
		    }
		    else
		    {
		    	conn = connDriver.getConnectDB("DriverITM");
		    }
		    //Added By Nilesh For instance workflow changes End :: 13-04-18

			
			System.out.println("StrgCustAmdApprove tranId=[" + tranId + "]" +"StrgCustAmdApprove scCode is=["+scCode+"]");
			tranId = checkNull(tranId);
			int updCnt = 0;
			//added b Mrunalini sinkar for update confirm,wf_status column of STRG_CUSTOMER_AMD when transaction is aprrove(start)[Request Id:W16Dsun004]
			String sql = "UPDATE STRG_CUSTOMER_AMD SET CONFIRM = 'Y',WF_STATUS = 'A' WHERE TRAN_ID = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, tranId);
			updCnt = pStmt.executeUpdate();
			pStmt.clearParameters();
			System.out.println("in rejection records updated count is >>> "+updCnt);
			
			if(updCnt == 0)
			{
				retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[ Customer Approval Update failed for tran_id "+tranId+"  ]]></RESULT></ROOT>";
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			//added b Mrunalini sinkar for update confirm column of STRG_CUSTOMER_AMD when transaction is aprrove(end)[Request Id:W16Dsun004]
			//added b Mrunalini sinkar for show the attchemnt in strategic customer menu that attach in amendement menu (start)[Request Id:W16Dsun004]
			int updAttachment=0;
			String selAttach="SELECT DOC_ID FROM DOC_TRANSACTION_LINK WHERE REF_SER=? AND REF_ID=? ";
			pstmtSelAttach = conn.prepareStatement(selAttach);
			pstmtSelAttach.setString(1, refSer);
			pstmtSelAttach.setString(2, tranId);
			rsSelAttach=pstmtSelAttach.executeQuery();
			while(rsSelAttach.next())
			{
				String docId=checkNull(rsSelAttach.getString("DOC_ID"));
				String countSql="SELECT COUNT(*) AS COUNT FROM DOC_TRANSACTION_LINK WHERE REF_SER='STRGC' AND REF_ID='"+scCode+"' AND DOC_ID='"+docId+"'";
				pstmtCountAttach=conn.prepareStatement(countSql);
				rsCountAttach=pstmtCountAttach.executeQuery();
				if(rsCountAttach.next())
				{
					attchmentCount=rsCountAttach.getInt("COUNT");
				}
				if(rsCountAttach != null)
				{
					rsCountAttach.close();
					rsCountAttach = null;
				}
				if(pstmtCountAttach != null)
				{
					pstmtCountAttach.close();
					pstmtCountAttach = null;
				}
				
				if(attchmentCount==0)
				{
					String attachmentSql="UPDATE DOC_TRANSACTION_LINK SET REF_SER='STRGC',REF_ID=? WHERE REF_SER=? AND REF_ID=? AND DOC_ID='"+docId+"'"; 
					pstmtAttachment = conn.prepareStatement(attachmentSql);
					pstmtAttachment.setString(1, scCode);
					pstmtAttachment.setString(2, refSer);
					pstmtAttachment.setString(3, tranId);

					updAttachment = pstmtAttachment.executeUpdate();
					pstmtAttachment.clearParameters();
					System.out.println("in rejection records updated count is >>> "+updAttachment);
					if(pstmtAttachment != null)
					{
						pstmtAttachment.close();
						pstmtAttachment = null;
					}
				}

			}
			if(rsSelAttach != null)
			{
				rsSelAttach.close();
				rsSelAttach = null;
			}
			if(pstmtSelAttach != null)
			{
				pstmtSelAttach.close();
				pstmtSelAttach = null;
			}
			//added b Mrunalini sinkar for show the attchemnt in strategic customer menu that attach in amendement menu (end)[Request Id:W16Dsun004]
			
			updateStrgCustomer(tranId, dom, empCode,xmlString,refSer, conn); //calling method by mrunalini sinkar to update strategic customer (strat)[Request Id:W16Dsun004]

		} 
		catch (Exception e) 
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			if (conn != null) 
			{
				try 
				{
					if (isError) 
					{
						conn.rollback();
						System.out.println("StrgCustAmdApprove Connection Rollback");
					} 
					else 
					{
						conn.commit();
						System.out.println("StrgCustAmdApprove Connection Commit");
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}													
					
				}
				catch (Exception e) 
				{
					e.printStackTrace();
				}
			}
		}
		return retString;
	}
    public String strgCustAmdReject(String tranId, String refSer, String processID,String userInfoStr) throws RemoteException, ITMException
   	{

		System.out.println("Strategic Customer Amendment Rejection");
		Connection conn = null;
		PreparedStatement pStmt = null;
		ConnDriver connDriver = null;
		boolean isError = false;
		String rejRemark = "";
		String retString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ Customer Rejected successfully ]]></RESULT></ROOT>";
		try
		{
			connDriver = new ConnDriver();
			//Added By Nilesh For instance workflow changes Start :: 13-04-18
			String transDB="";
			System.out.println("Inside expenseConfirm confirm section: "+userInfoStr);
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if(userInfo!=null)
			{
				transDB = userInfo.getTransDB();
			}
	    	System.out.println("get TransDB connection in expenseConfirm : "+transDB);

		    if (transDB != null && transDB.trim().length() > 0)
		    {
		    	conn = connDriver.getConnectDB(transDB);
		    }
		    else
		    {
		    	conn = connDriver.getConnectDB("DriverITM");
		    }
		    //Added By Nilesh For instance workflow changes End :: 13-04-18

			//added by mrunalini sinkar to update confirm,wf_status,reject remark into startegic customer amendment master after rejection(start)[Request Id:W16DSUN004]
			System.out.println("StrgCustAmdReject tranId=[" + tranId + "]"+"StrgCustAmdReject refser=["+refSer+"]" +"StrgCustAmdReject processId=["+processID+"]");
			tranId = checkNull(tranId);
			int updCnt = 0;
			
			String rejRemarkSql = "SELECT SIGN_REMARKS FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID =?"
					+" AND LINE_NO = (SELECT MAX(LINE_NO) FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? "
					+" AND SIGN_STATUS = 'R')";
			
			PreparedStatement pstmtRemark = conn.prepareStatement(rejRemarkSql);
			pstmtRemark.setString(1, refSer);
			pstmtRemark.setString(2, tranId);
			pstmtRemark.setString(3, refSer);
			pstmtRemark.setString(4, tranId);

			ResultSet rsRemark = pstmtRemark.executeQuery();
			if(rsRemark.next())
			{
				rejRemark = rsRemark.getString("SIGN_REMARKS");
				System.out.println("rejRemark is:"+rejRemark);
			}
			//added by prachi for dirty connection issue
			if(rsRemark != null)
			{
				rsRemark.close();
				rsRemark = null;
			}
			if(pstmtRemark != null)
			{
				pstmtRemark.close();
				pstmtRemark = null;
			}
            //end
			String sql = "UPDATE STRG_CUSTOMER_AMD SET CONFIRM = 'N',WF_STATUS = 'R',WF_REJ__REMARK = ?  WHERE TRAN_ID = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, rejRemark);
			pStmt.setString(2, tranId);
			updCnt = pStmt.executeUpdate();
			pStmt.clearParameters();
			System.out.println("in rejection records updated count is >>> "+updCnt);
			
			if(updCnt == 0)
			{
				retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[ Customer Rejection Update failed for tran_id "+tranId+"  ]]></RESULT></ROOT>";
			}
			//added by mrunalini sinkar to update confirm,wf_status,reject remark into startegic customer amendment master after rejection(end)[Request Id:W16DSUN004]

		} 
		catch (Exception e) 
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			if (conn != null) 
			{
				try 
				{
					if (isError) 
					{
						conn.rollback();
						System.out.println("StrgCustAmdReject Connection Rollback");
					} 
					else 
					{
						conn.commit();
						System.out.println("StrgCustAmdReject Connection Commit");
					}
					
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}													
					
				}
				catch (Exception e) 
				{
					e.printStackTrace();
				}
			}
		}
		return retString;
	}
    //added by mrunalini sinkar to update the approve value into strategic customer master (start) [Request Id:W16DSUN004]
    public String updateStrgCustomer(String tranId,Document dom,String empCode,String xmlString,String refSer,Connection conn) throws ITMException
    {
		System.out.println("inside the updateStrgCustomer method"+empCode);
    	String sql = "";
		PreparedStatement pstmtStrgCustAmd = null;
		PreparedStatement pstmtStrgCustUpd = null;
		ResultSet rsStrgCustAmd = null;
		ResultSet rsStrgCustUpd  = null;

		String retString = "";
		int updCnt=0;
		try
		{
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			

			//String cityCheck = genericUtility.getColumnValue("city_check",dom);
			//String localityCheck = genericUtility.getColumnValue("locality_check",dom);
			String addr1Check = genericUtility.getColumnValue("addr1_check",dom);
			String addr2Check = genericUtility.getColumnValue("addr2_check",dom);
			String addr3Check = genericUtility.getColumnValue("addr3_check",dom);
			String fNameCheck = genericUtility.getColumnValue("first_name_check",dom);
			String mNameCheck = genericUtility.getColumnValue("middle_name_check",dom);
			String lNameCheck = genericUtility.getColumnValue("last_name_check",dom);
			String qualCheck = genericUtility.getColumnValue("qual_check",dom);
			String pinCheck = genericUtility.getColumnValue("pin_check",dom);
			String mobileCheck = genericUtility.getColumnValue("mobile_check",dom);
			String emailCheck = genericUtility.getColumnValue("email_check",dom);


			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			sql="SELECT SC_CODE,ADDR1_CA,ADDR2_CA,ADDR3_CA,PIN_CA,QUALIFICATION_CA,FIRST_NAME_CA,MIDDLE_NAME_CA,LAST_NAME_CA,MOBILE_NO_CA,EMAIL_ADDR_CA, "
					+" ADDR1,ADDR2,ADDR3,PIN,QUALIFICATION,FIRST_NAME,MIDDLE_NAME,LAST_NAME,MOBILE_NO,EMAIL_ADDR "
					+" FROM STRG_CUSTOMER_AMD WHERE TRAN_ID='"+tranId+"'";
			pstmtStrgCustAmd=conn.prepareStatement(sql);
			rsStrgCustAmd=pstmtStrgCustAmd.executeQuery();
			if(rsStrgCustAmd.next())
			{
				String scCode=checkNull(rsStrgCustAmd.getString("SC_CODE"));
				String addr1=checkNull(rsStrgCustAmd.getString("ADDR1"));
				String addr1Ca=checkNull(rsStrgCustAmd.getString("ADDR1_CA"));
				String addr2=checkNull(rsStrgCustAmd.getString("ADDR2"));
				String addr2Ca=checkNull(rsStrgCustAmd.getString("ADDR2_CA"));
				String addr3=checkNull(rsStrgCustAmd.getString("ADDR3"));
				String addr3Ca=checkNull(rsStrgCustAmd.getString("ADDR3_CA"));
				String pin=checkNull(rsStrgCustAmd.getString("PIN"));
				String pinCa=checkNull(rsStrgCustAmd.getString("PIN_CA"));
				String qualifiCa=checkNull(rsStrgCustAmd.getString("QUALIFICATION_CA"));
				String qualification=checkNull(rsStrgCustAmd.getString("QUALIFICATION"));
				String firstName=checkNull(rsStrgCustAmd.getString("FIRST_NAME"));
				String firstNameCa=checkNull(rsStrgCustAmd.getString("FIRST_NAME_CA"));
				String middleName=checkNull(rsStrgCustAmd.getString("MIDDLE_NAME"));
				String middleNameCa=checkNull(rsStrgCustAmd.getString("MIDDLE_NAME_CA"));
				String lastName=checkNull(rsStrgCustAmd.getString("LAST_NAME"));
				String lastNameCa=checkNull(rsStrgCustAmd.getString("LAST_NAME_CA"));
				String mobileNo=checkNull(rsStrgCustAmd.getString("MOBILE_NO"));
				String mobileNoCa=checkNull(rsStrgCustAmd.getString("MOBILE_NO_CA"));
				String emailAddrCa=checkNull(rsStrgCustAmd.getString("EMAIL_ADDR_CA"));
				String emailAddr=checkNull(rsStrgCustAmd.getString("EMAIL_ADDR"));
				
				String updStrgCustSql = "UPDATE STRG_CUSTOMER SET ADDR1=?,ADDR2=?,ADDR3=?,PIN=?,QUALIFICATION=?,FIRST_NAME=?,MIDDLE_NAME=?,LAST_NAME=?,MOBILE_NO=?,EMAIL_ADDR=?,CHG_DATE=?,CHG_USER=?,CHG_TERM=? WHERE SC_CODE = ? ";
				pstmtStrgCustUpd = conn.prepareStatement(updStrgCustSql);
				
				if(addr1Check=="true" || addr1Check.equalsIgnoreCase("true"))
				{
					pstmtStrgCustUpd.setString(1, addr1Ca);
				}
				else
				{
					pstmtStrgCustUpd.setString(1, addr1);
				}
				if(addr2Check=="true" || addr2Check.equalsIgnoreCase("true"))
				{
					pstmtStrgCustUpd.setString(2, addr2Ca);
				}
				else
				{
					pstmtStrgCustUpd.setString(2, addr2);
				}
				if(addr3Check=="true" || addr3Check.equalsIgnoreCase("true"))
				{
					pstmtStrgCustUpd.setString(3, addr3Ca);
				}
				else
				{
					pstmtStrgCustUpd.setString(3, addr3);
				}

				if(pinCheck=="true" || pinCheck.equalsIgnoreCase("true"))
				{
					pstmtStrgCustUpd.setString(4, pinCa);
				}
				else
				{
					pstmtStrgCustUpd.setString(4, pin);
				}

				if(qualCheck=="true" || qualCheck.equalsIgnoreCase("true"))
				{
					pstmtStrgCustUpd.setString(5, qualifiCa);
				}
				else
				{
					pstmtStrgCustUpd.setString(5, qualification);
				}
				if(fNameCheck=="true" || fNameCheck.equalsIgnoreCase("true"))
				{
					pstmtStrgCustUpd.setString(6, firstNameCa);
				}
				else
				{
					pstmtStrgCustUpd.setString(6, firstName);
				}
				
				if(mNameCheck=="true" || mNameCheck.equalsIgnoreCase("true"))
				{
					pstmtStrgCustUpd.setString(7, middleNameCa);
				}
				else
				{
					pstmtStrgCustUpd.setString(7, middleName);
				}
				
				if(lNameCheck=="true" || lNameCheck.equalsIgnoreCase("true"))
				{
					pstmtStrgCustUpd.setString(8, lastNameCa);
				}
				else
				{
					pstmtStrgCustUpd.setString(8, lastName);
				}
				
				if(mobileCheck=="true" || mobileCheck.equalsIgnoreCase("true"))
				{
					pstmtStrgCustUpd.setString(9, mobileNoCa);
				}
				else
				{
					pstmtStrgCustUpd.setString(9, mobileNo);
				}
				if(emailCheck=="true" || emailCheck.equalsIgnoreCase("true"))
				{
					pstmtStrgCustUpd.setString(10, emailAddrCa);
				}
				else
				{
					pstmtStrgCustUpd.setString(10, emailAddr);
				}
				
				//commented by mrunalini sinkar to remove the locality changes [Request Id:W16DSUN004]
				/*if(localityCheck=="true" || localityCheck.equalsIgnoreCase("true"))
				{
					pstmtStrgCustUpd.setString(11, districtOffCa);
					pstmtStrgCustUpd.setString(12, stanCodeCa);
					pstmtStrgCustUpd.setString(13, stateCodeCa);
					pstmtStrgCustUpd.setString(14, countCodeCa);
					pstmtStrgCustUpd.setString(15, cityCa);
					pstmtStrgCustUpd.setString(16, locCodeCa);
				}
				else
				{
					pstmtStrgCustUpd.setString(11, districtOff);
					pstmtStrgCustUpd.setString(12, stanCode);
					pstmtStrgCustUpd.setString(13, stateCode);
					pstmtStrgCustUpd.setString(14, countCode);
					pstmtStrgCustUpd.setString(15, city);
					pstmtStrgCustUpd.setString(16, locCode);

				}*/
				pstmtStrgCustUpd.setTimestamp(11, java.sql.Timestamp.valueOf(currDate));
				pstmtStrgCustUpd.setString(12, "SYSTEM");
				pstmtStrgCustUpd.setString(13, "SYSTEM");

				pstmtStrgCustUpd.setString(14, scCode);

				updCnt = pstmtStrgCustUpd.executeUpdate();
				pstmtStrgCustUpd.clearParameters();

				if(updCnt==0)
				{
					System.out.println("update of strg customer table for ["+scCode+"] this sc code is faild");
				}
				
				if(pstmtStrgCustUpd != null)
				{
					pstmtStrgCustUpd.close();
					pstmtStrgCustUpd = null;
				}
				

			}
			if( rsStrgCustAmd != null )
			{
				rsStrgCustAmd.close();
				rsStrgCustAmd = null;
			}
			if(pstmtStrgCustAmd != null)
			{
				pstmtStrgCustAmd.close();
				pstmtStrgCustAmd = null;
			}
			
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
			
		}
		finally
		{
			try
			{
				if( rsStrgCustUpd != null )
				{
					rsStrgCustUpd.close();
					rsStrgCustUpd = null;
				}
				if( rsStrgCustAmd != null )
				{
					rsStrgCustAmd.close();
					rsStrgCustAmd = null;
				}
				
				if(pstmtStrgCustUpd != null)
				{
					pstmtStrgCustUpd.close();
					pstmtStrgCustUpd = null;
				}
				if(pstmtStrgCustAmd != null)
				{
					pstmtStrgCustAmd.close();
					pstmtStrgCustAmd = null;
				}
			}
			catch(Exception e)
			{
			}
		}
		
		return retString;
	}
    //added by mrunalini sinkar to update the approve value into strategic customer master (end) [Request Id:W16DSUN004]

	private String checkNull(String input)
	{
		if (input==null || input.trim().length() == 0)
		{
			input="";
		}
		return input.trim();
	}
    //added by mrunalini sinkar to get obj name from dom (start) [Request Id:W16DSUN004]
	public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		System.out.println("inside the obj name method");
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null;			
			int	detailListLength = 0;
			
			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				System.out.println("objName is:"+objName);
				break;
						
			}
			if(objName == null || objName.trim().length() == 0)
			{
				NodeList objNameList = dom.getElementsByTagName("objName");
				if(objNameList != null && objNameList.getLength() > 0)
				{
					Node objNameNode = objNameList.item(0);
					if(objNameNode != null && objNameNode.getFirstChild() != null)
					{
						objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}
    //added by mrunalini sinkar to get obj name from dom (start) [Request Id:W16DSUN004]
	
    //added by mrunalini sinkar to send mail to sales person when customer locality is change  (start) [Request Id:W16DSUN004]
	public String sendMailStatus(String salesPers, String xmlString,String formatCode,String objName,String refSer) throws RemoteException ,ITMException
	{
		System.out.println("Inside sendMailStatus method:");
		String mailHeader = "";
		String infoType = "ITM";
		String returnstrFromSendMailMethod="";
		try
		{
			EMail em = new EMail();
			mailHeader = 	"<ROOT>"+
			"<TRANS_INFO>"+
			"<OBJ_NAME>"+objName+"</OBJ_NAME>"+
			"<REF_SER>"+refSer+"</REF_SER>"+
			"<LINE_NO>"+""+"</LINE_NO>"+
			"<XSL_FILE_NAME></XSL_FILE_NAME>"+
			"</TRANS_INFO>"+
			"<MAIL>"+
			"<SUBJECT></SUBJECT>"+
			"<ENTITY_CODE>"+salesPers.trim()+"</ENTITY_CODE>"+
			"<BODY_TEXT></BODY_TEXT>"+
			"<TO_ADD></TO_ADD>"+
			"<CC_ADD></CC_ADD>"+
			"<FORMAT_CODE>"+formatCode+"</FORMAT_CODE>"+
			"<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>"+
			"</MAIL>"+
			"<XML_DATA>"+xmlString+"</XML_DATA>"+
			"</ROOT>";
		
			returnstrFromSendMailMethod = em.sendMail(mailHeader, infoType);
			System.out.println("@@@@ mail function called successfully : "+returnstrFromSendMailMethod);
			
		} 
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		
		return returnstrFromSendMailMethod;
	}
    //added by mrunalini sinkar to send mail to sales person when customer locality is change  (start) [Request Id:W16DSUN004]
	
	//commentd by mrunalini sinkar to remove the locality changes bcoz requirement is change(start) [Request Id:W16DSUN004]
	//In futre if it requierd then call this method through system entries wfAprValData this method 
	/*public String wfAprValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		PreparedStatement pstmtStrgCustAmd = null;
		PreparedStatement pstmtStrgCustUpd = null;
		PreparedStatement pstmtOldLocality = null;
		PreparedStatement pstmtNewLocality = null;
		PreparedStatement pstmtAllScSql = null;
		PreparedStatement pstmtCountSql = null;
		ResultSet rsCountSql = null;
		ResultSet rsStrgCustAmd = null;
		ResultSet rsOldLocality = null;
		ResultSet rsNewLocality = null;
		ResultSet rsAllScSql = null;
		boolean isError = false;
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		ConnDriver connDriver = null;
		Connection conn = null;
		String sql="";

		try
		{
			
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			System.out.println("Inside in wfAprValData:");

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			StrgCustomerAmdEJBRemote strgCustomerAmdejbremote = (StrgCustomerAmdEJBRemote)ctx.lookup("ibase/StrgCustomerAmdEJB/remote");

			System.out.println("xmlString in wfAprValData:"+xmlString);
			System.out.println("xmlString1 in wfAprValData:"+xmlString1);
			System.out.println("xmlString2 in wfAprValData:"+xmlString2);

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = strgCustomerAmdejbremote.wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("errString in wfValData:"+errString);

			if(errString==null || errString.equals(""))
			{

				String localityCheck = genericUtility.getColumnValue("locality_check",dom);
				String localityCodeCa=genericUtility.getColumnValue("locality_code_ca",dom);
				String localityCode=genericUtility.getColumnValue("locality_code",dom);
				String doctorCode=genericUtility.getColumnValue("sc_code",dom);

				System.out.println("localityCheck  is:["+localityCheck+"] localityCodeCa is:["+localityCodeCa+"] localitycode is:["+localityCode+"]doctoCode is:["+doctorCode+"]");				
				
				if(localityCheck=="true" || localityCheck.equalsIgnoreCase("true"))
				{
					ArrayList <String> activeMail=new ArrayList<String>();
					ArrayList <String> deActiveMail=new ArrayList<String>();

					String oldLocRoute="";
					String newLocRoute="";
					int count=0,resCount=0,updStatus=0,updOldStatus=0;
					String countSql="",updateSql="";
					sql=" SELECT SALES_PERS,ROUTE_ID FROM STRG_SERIES WHERE STATUS='Y' AND SC_CODE=? ";
					pstmtStrgCustAmd=conn.prepareStatement(sql);
					pstmtStrgCustAmd.setString(1,doctorCode);
					rsStrgCustAmd=pstmtStrgCustAmd.executeQuery();
					while(rsStrgCustAmd.next())
					{
						String routeIdActive=checkNull(rsStrgCustAmd.getString("ROUTE_ID"));
						routeIdActive=routeIdActive.trim();
						String salesPersActive=checkNull(rsStrgCustAmd.getString("SALES_PERS"));
						countSql="SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE SPRS_CODE=? AND LOCALITY_CODE=? AND STATUS='Y'";
						pstmtCountSql=conn.prepareStatement(countSql);
						pstmtCountSql.setString(1,salesPersActive );
						pstmtCountSql.setString(2,localityCodeCa );
						rsCountSql=pstmtCountSql.executeQuery();
						if(rsCountSql.next())
						{
							count=rsCountSql.getInt("COUNT");
						}
						if( rsCountSql != null )
						{
							rsCountSql.close();
							rsCountSql = null;
						}
						if(pstmtCountSql != null)
						{
							pstmtCountSql.close();
							pstmtCountSql = null;
						}
						if(count==0)
						{
							countSql="SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE SPRS_CODE=? AND LOCALITY_CODE=? AND STATUS='Y' AND ROUTE_ID=?";
							pstmtCountSql=conn.prepareStatement(countSql);
							pstmtCountSql.setString(1,salesPersActive );
							pstmtCountSql.setString(2,localityCode );
							pstmtCountSql.setString(3,routeIdActive);
							rsCountSql=pstmtCountSql.executeQuery();
							if(rsCountSql.next())
							{
								resCount=rsCountSql.getInt("COUNT");
							}
							if( rsCountSql != null )
							{
								rsCountSql.close();
								rsCountSql = null;
							}
							if(pstmtCountSql != null)
							{
								pstmtCountSql.close();
								pstmtCountSql = null;
							}
							if(resCount>0)
							{
								//errString =  itmDBAccessLocal.getErrorString("locality_code_ca","INVALQUAN",userId);
								System.out.println("Locality is not in From locality or To locality.......");
								errString = getErrorString( "locality_code_ca", "NOTPRESENT", salesPersActive );
								System.out.println("errString>>>"+errString);
				                String errorId = "NOTPRESENT";
				                String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
				                String messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]")) +  ": Non Present salesPerson is : "+salesPersActive;       
				                String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
				                String message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));         
				                errString = getModErrorString(messageValue,message ,errorId);
								//errString = getModifiedErrorString ( errString , "for " ,salesPersActive );
								break;
							}

						}
						
						String oldLocality="SELECT ROUTE_ID FROM SPRS_ROUTE WHERE SPRS_CODE=? AND STATUS='Y' AND LOCALITY_CODE=? ";
						pstmtOldLocality=conn.prepareStatement(oldLocality);
						pstmtOldLocality.setString(1,salesPersActive );
						pstmtOldLocality.setString(2,localityCode );
						rsOldLocality=pstmtOldLocality.executeQuery();
						if(rsOldLocality.next())
						{
							oldLocRoute=checkNull(rsOldLocality.getString("ROUTE_ID"));
							oldLocRoute=oldLocRoute.trim();
						}
						if( rsOldLocality != null )
						{
							rsOldLocality.close();
							rsOldLocality = null;
						}
						if(pstmtOldLocality != null)
						{
							pstmtOldLocality.close();
							pstmtOldLocality = null;
						}
						if(oldLocRoute!=null && routeIdActive.equalsIgnoreCase(oldLocRoute))
						{
							
							
							String newLocality="SELECT ROUTE_ID FROM SPRS_ROUTE WHERE SPRS_CODE=? AND STATUS='Y' AND LOCALITY_CODE=? ";
							pstmtNewLocality=conn.prepareStatement(newLocality);
							pstmtNewLocality.setString(1,salesPersActive );
							pstmtNewLocality.setString(2,localityCodeCa );
							rsNewLocality=pstmtNewLocality.executeQuery();
							if(rsNewLocality.next())
							{
								newLocRoute =checkNull(rsNewLocality.getString("ROUTE_ID"));
								newLocRoute=newLocRoute.trim();
							}
							if( rsNewLocality != null )
							{
								rsNewLocality.close();
								rsNewLocality = null;
							}
							if(pstmtNewLocality != null)
							{
								pstmtNewLocality.close();
								pstmtNewLocality = null;
							}
							String allScSql="SELECT ROUTE_ID FROM STRG_SERIES WHERE SC_CODE=? AND SALES_PERS=? ";
							pstmtAllScSql=conn.prepareStatement(allScSql);
							pstmtAllScSql.setString(1,doctorCode );
							pstmtAllScSql.setString(2,salesPersActive );
							rsAllScSql=pstmtAllScSql.executeQuery();
							while(rsAllScSql.next())
							{
								String routeAllSc=checkNull(rsAllScSql.getString("ROUTE_ID"));
								routeAllSc=routeAllSc.trim();
								
								if(newLocRoute!=null && routeAllSc.equals(newLocRoute))
								{
									String updsql="";
									int countLoc=0;
									updsql="SELECT COUNT(*) AS COUNT FROM STRG_SERIES WHERE SC_CODE=? AND SALES_PERS=? AND ROUTE_ID=? AND STATUS='Y' ";
									pstmtCountSql=conn.prepareStatement(updsql);
									pstmtCountSql.setString(1, doctorCode);
									pstmtCountSql.setString(2, salesPersActive);
									pstmtCountSql.setString(3, newLocRoute);
									rsCountSql=pstmtCountSql.executeQuery();
									if(rsCountSql.next())
									{
										countLoc=rsCountSql.getInt("COUNT");
									}
									if( rsCountSql != null )
									{
										rsCountSql.close();
										rsCountSql = null;
									}
									if(pstmtCountSql != null)
									{
										pstmtCountSql.close();
										pstmtCountSql = null;
									}

									if(countLoc==0)
									{
										updateSql="UPDATE STRG_SERIES SET STATUS='Y' WHERE SC_CODE=? AND SALES_PERS=? AND ROUTE_ID=?";
										pstmtStrgCustUpd = conn.prepareStatement(updateSql);
										pstmtStrgCustUpd.setString(1, doctorCode);
										pstmtStrgCustUpd.setString(2, salesPersActive);
										pstmtStrgCustUpd.setString(3, newLocRoute);

										updStatus = pstmtStrgCustUpd.executeUpdate();
										pstmtStrgCustUpd.clearParameters();
										System.out.println("in updated status against new loclaity count is >>> "+updStatus);
										
										if(updStatus == 0)
										{
											System.out.println("in updated status against new loclaity is not updated");

										}
										if(pstmtStrgCustUpd != null)
										{
											pstmtStrgCustUpd.close();
											pstmtStrgCustUpd = null;
										}
										
									}
									int countOldLoc=0;
									updsql="SELECT COUNT(*) AS COUNT FROM STRG_SERIES WHERE SC_CODE=? AND SALES_PERS=? AND ROUTE_ID=? AND STATUS='N'";
									pstmtCountSql=conn.prepareStatement(updsql);
									pstmtCountSql.setString(1, doctorCode);
									pstmtCountSql.setString(2, salesPersActive);
									pstmtCountSql.setString(3, oldLocRoute);
									rsCountSql=pstmtCountSql.executeQuery();
									if(rsCountSql.next())
									{
										countOldLoc=rsCountSql.getInt("COUNT");
									}
									if( rsCountSql != null )
									{
										rsCountSql.close();
										rsCountSql = null;
									}
									if(pstmtCountSql != null)
									{
										pstmtCountSql.close();
										pstmtCountSql = null;
									}
									if(countOldLoc==0)
									{
										updateSql="UPDATE STRG_SERIES SET STATUS='N' WHERE SC_CODE=? AND SALES_PERS=? AND ROUTE_ID=? ";
										pstmtStrgCustUpd = conn.prepareStatement(updateSql);
										pstmtStrgCustUpd.setString(1, doctorCode);
										pstmtStrgCustUpd.setString(2, salesPersActive);
										pstmtStrgCustUpd.setString(3, oldLocRoute);

										updOldStatus = pstmtStrgCustUpd.executeUpdate();
										pstmtStrgCustUpd.clearParameters();
										System.out.println("in updated status against old loclaity count is >>> "+updOldStatus);
										
										if(updOldStatus == 0)
										{
											System.out.println("in updated status against old loclaity is not update");

										}
										if(pstmtStrgCustUpd != null)
										{
											pstmtStrgCustUpd.close();
											pstmtStrgCustUpd = null;
										}
										if(updOldStatus>0 && updStatus>0)
										{
											activeMail.add(salesPersActive);
										}
									}
									
								}
								else
								{
									
									int countOldLoc=0;
									String updsql="SELECT COUNT(*) AS COUNT FROM STRG_SERIES WHERE SC_CODE=? AND SALES_PERS=? AND ROUTE_ID=?";
									pstmtCountSql=conn.prepareStatement(updsql);
									pstmtCountSql.setString(1, doctorCode);
									pstmtCountSql.setString(2, salesPersActive);
									pstmtCountSql.setString(3, newLocRoute);
									rsCountSql=pstmtCountSql.executeQuery();
									if(rsCountSql.next())
									{
										countOldLoc=rsCountSql.getInt("COUNT");
									}
									if( rsCountSql != null )
									{
										rsCountSql.close();
										rsCountSql = null;
									}
									if(pstmtCountSql != null)
									{
										pstmtCountSql.close();
										pstmtCountSql = null;
									}
									
									if(countOldLoc==0)
									{
										updateSql="UPDATE STRG_SERIES SET ROUTE_ID=? WHERE SC_CODE=? AND SALES_PERS=? AND ROUTE_ID=?";
										pstmtStrgCustUpd = conn.prepareStatement(updateSql);
										pstmtStrgCustUpd.setString(1, newLocRoute);
										pstmtStrgCustUpd.setString(2, doctorCode);
										pstmtStrgCustUpd.setString(3, salesPersActive);
										pstmtStrgCustUpd.setString(4, oldLocRoute);

										updStatus = pstmtStrgCustUpd.executeUpdate();
										pstmtStrgCustUpd.clearParameters();
										System.out.println("in updated status against new loclaity count is >>> "+updStatus);
										
										if(updStatus > 0)
										{
											System.out.println("in updated status against new loclaity is  updated");
											activeMail.add(salesPersActive);

										}
										if(pstmtStrgCustUpd != null)
										{
											pstmtStrgCustUpd.close();
											pstmtStrgCustUpd = null;
										}
									}
									
								}
								
								
							}
							if( rsAllScSql != null )
							{
								rsAllScSql.close();
								rsAllScSql = null;
							}
							if(pstmtAllScSql != null)
							{
								pstmtAllScSql.close();
								pstmtAllScSql = null;
							}
							
							
						}


					}
					if( rsStrgCustAmd != null )
					{
						rsStrgCustAmd.close();
						rsStrgCustAmd = null;
					}
					if(pstmtStrgCustAmd != null)
					{
						pstmtStrgCustAmd.close();
						pstmtStrgCustAmd = null;
					}
					
					if(isError==false)
					{
						String objName = getObjNameFromDom( dom, "objName" , 1);
						System.out.println("objName mail is:"+objName);
						String refSer = getRefser(objName,conn);
						System.out.println("refSer mail is:"+refSer);

						System.out.println("active mail sent is"+activeMail);
						if(!activeMail.isEmpty())
						{
							for(int i=0;i<activeMail.size();i++)
							{
								String salesPers=activeMail.get(i);
								String formatCode = "ACTIVEDOC";
								String activeMailSent=sendMailStatus(salesPers, xmlString,formatCode,objName,refSer);
								System.out.println("activeMailSent:["+activeMailSent+"]");
							}
						}
						
						
					}
					
				}
			}

		}
		catch(Exception e)
		{
			isError=true;
			System.out.println("Exception: StrgCustomer: wfAprValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);

		}
		finally
		{

			if (conn != null) 
			{
				try 
				{
					if (isError) 
					{
						conn.rollback();
						System.out.println("StrgCustAmdApprove Connection Rollback");
					} 
					else 
					{
						conn.commit();
						System.out.println("StrgCustAmdApprove Connection Commit");
					}

					if(conn != null)
					{
						conn.close();
						conn = null;
					}													
					
				}
				catch (Exception e) 
				{
					e.printStackTrace();
				}
			}
		
		}
		return errString;

	}
	public String getModErrorString (String messageValue,String message ,String errorId )
	{
		System.out.println("getModErrorString..........");
		String errString = "";
		try
		{
			//genericUtility = new E12GenericUtility();
			
			errString = "";
			StringBuffer valueXmlErrorString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
		
			valueXmlErrorString.append("<error id=\"").append(errorId).append("\" type=\"E\"").append(" column_name=\"description\"").append(">");
			
			valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
			valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
			valueXmlErrorString.append("<type>E</type>\r\n");
			valueXmlErrorString.append("<option></option>\r\n");    
			valueXmlErrorString.append("<time></time>\r\n");
			valueXmlErrorString.append("<alarm></alarm>\r\n");
			valueXmlErrorString.append("<source></source>\r\n");       
			valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
			valueXmlErrorString.append("<redirect>1</redirect>\r\n");
			valueXmlErrorString.append("</error>\r\n");
			valueXmlErrorString.append("</Errors>\r\n");
			valueXmlErrorString.append("</Header>\r\n");
			valueXmlErrorString.append( "</Root>\r\n" );
			System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );  
			errString =valueXmlErrorString.toString();

			System.out.println("Modified error string"+errString);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		
		return errString;
	}*/
	//commentd by mrunalini sinkar to remove the locality changes bcoz requirement is change(end) [Request Id:W16DSUN004]

	//added by mrunalini sinkar to getrefser and use it in wfAprValData method(start) [Request Id:W16DSUN004]
	public String getRefser(String objName,Connection conn)
	{
		String refSer="",sql="";
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		try
		{
			sql="SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW=?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, "w_"+objName);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				refSer=checkNull(rs.getString("REF_SER"));
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		
		return refSer;
	}
	//added by mrunalini sinkar to getrefser and use it in wfAprValData method(end) [Request Id:W16DSUN004]

	
}