/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.analyticsDataAccess.ReportDataEJB.ReportDataServiceEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class MapViewJB
extends ReportDataServiceEJB {
    public String getReportData(HashMap reportArgMap) throws ITMException {
        String result = "";
        try {
            result = this.getMapData(reportArgMap, this.getUserInfo());
        }
        catch (Exception e) {
            System.out.println("MapViewJB.getReportData() Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        return result;
    }

    public String getMapData(HashMap reportArgMap, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", null, null, "MapViewJB : getData Called reportArgMap : [" + reportArgMap + "]");
        String returnMapData = "";
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String transDB = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            String objName = (String)reportArgMap.get("objName");
            String salesPers = (String)reportArgMap.get("sales_pers");
            String fromDate = (String)reportArgMap.get("from_date");
            String toDate = (String)reportArgMap.get("to_date");
            String mgrCode = (String)reportArgMap.get("report_to");
            String showRouteFlag = (String)reportArgMap.get("show_travel_path");
            String userId = (String)reportArgMap.get("user_id");
            String empCode = (String)reportArgMap.get("emp_code");
            String userType = (String)reportArgMap.get("user_type");
            salesPers = E12GenericUtility.checkNull(salesPers);
            fromDate = E12GenericUtility.checkNull(fromDate);
            toDate = E12GenericUtility.checkNull(toDate);
            mgrCode = E12GenericUtility.checkNull(mgrCode);
            userId = E12GenericUtility.checkNull(userId);
            empCode = E12GenericUtility.checkNull(empCode);
            showRouteFlag = E12GenericUtility.checkNull(showRouteFlag);
            userType = "admin_route_map".equalsIgnoreCase(objName) ? "ADMIN" : userType;
            BaseLogger.log("3", null, null, "B4 userType[" + userType + "]userId [" + userId + "]empCode [" + empCode + "] mgrCode [" + mgrCode + "]fromDate [" + fromDate + "] toDate [" + toDate + "] salesPers [" + salesPers + "] showRouteFlag[" + showRouteFlag + "]");
            if ("ADMIN".equalsIgnoreCase(userType)) {
                empCode = mgrCode;
            }
            if (empCode.length() == 0) {
                empCode = salesPers;
            }
            ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
            if ("ADMIN".equalsIgnoreCase(userType) && mgrCode.length() == 0) {
                String string = returnMapData = itmDBAccess.getErrorString("report_to", "INVMAPMGR", userId, userInfo);
                return string;
            }
            if (salesPers.length() == 0) {
                String string = returnMapData = itmDBAccess.getErrorString("sales_pers", "INVMAPUSER", userId, userInfo);
                return string;
            }
            if (fromDate.length() == 0) {
                String string = returnMapData = itmDBAccess.getErrorString("from_date", "INVMAPDATE", userId, userInfo);
                return string;
            }
            if (toDate.length() == 0) {
                String string = returnMapData = itmDBAccess.getErrorString("to_date", "INVMAPDATE", userId, userInfo);
                return string;
            }
            SimpleDateFormat sdfFormat = new SimpleDateFormat(new E12GenericUtility().getApplDateFormat());
            java.util.Date dateFrom = sdfFormat.parse(fromDate);
            java.util.Date dateTo = sdfFormat.parse(toDate);
            long difference = dateTo.getTime() - dateFrom.getTime() + 86400000L;
            float daysBetween = difference / 86400000L;
            BaseLogger.log("3", userInfo, null, "Number of Days between dates: " + daysBetween);
            if (daysBetween > 7.0f) {
                returnMapData = itmDBAccess.getErrorString("sales_pers", "INVMAPDAYS", userId);
                BaseLogger.log("3", userInfo, null, "Days are exceded[" + returnMapData + "]");
                String string = returnMapData;
                return string;
            }
            try {
                String salesPersCsv = this.getFormattedCSV(salesPers);
                fromDate = genericUtility.getValidDateString(fromDate, genericUtility.getDispDateFormat(), genericUtility.getApplDateFormat());
                toDate = genericUtility.getValidDateString(toDate, genericUtility.getDispDateFormat(), genericUtility.getApplDateFormat());
                BaseLogger.log("3", userInfo, null, "objName[" + objName + "]After fromDate [" + fromDate + "] toDate [" + toDate + "] salesPersCsv [" + salesPersCsv + "] ");
                String sql1 = " SELECT SC.FIRST_NAME ||' '|| SC.LAST_NAME  AS DOCTOR_NAME, SM.STRG_CODE AS DOCTOR_CODE, LOC.DESCR AS DOCTOR_LOCALITY, SM.LOCALITY_CODE AS LOCALITY_CODE, SM.EVENT_DATE AS VISIT_DATE, SM.EVENT_TIME_START AS VISIT_TIME, SM.EVENT_TIME_END AS VISIT_TIME_END, SM.SALES_PERS AS SALES_PERS, SP.SP_NAME AS SP_NAME, SM.ADD_GEOPOS AS ADD_GEOPOS, SM.CHG_GEOPOS AS CHG_GEOPOS, DENSE_RANK() OVER (ORDER BY SM.EVENT_DATE,SM.ADD_GEOPOS ASC) AS MARKER, ST.ORDER_OF_VISIT AS ORDER_OF_VISIT FROM STRG_MEET SM LEFT OUTER JOIN STRG_CUSTOMER SC ON SM.STRG_CODE = SC.SC_CODE, SALES_PERS SP LEFT OUTER JOIN EMPLOYEE EMP  ON SP.SALES_PERS = EMP.EMP_CODE, LOCALITY LOC ,SPRS_TRAVEL ST WHERE SM.SALES_PERS = SP.SALES_PERS AND SC.LOCALITY_CODE = LOC.LOCALITY_CODE  AND SM.SALES_PERS IN ( " + salesPersCsv + " ) AND SM.EVENT_DATE >= ? AND SM.EVENT_DATE <= ? " + " AND SM.ADD_GEOPOS IS NOT NULL AND( ( EMP.EMP_CODE = SM.SALES_PERS AND EMP.REPORT_TO = ? ) OR ( SM.SALES_PERS = ? ) ) " + " AND SM.SALES_PERS =  ST.SALES_PERS AND SM.EVENT_DATE = ST.TRAVEL_DATE AND SM.LOCALITY_CODE = ST.LOCALITY_CODE" + " ORDER BY SM.SALES_PERS, SM.EVENT_DATE, TO_CHAR(TO_DATE (SM.EVENT_TIME_START, 'HH:MI AM'),'HH24:MI:SS'), TO_CHAR(TO_DATE (SM.EVENT_TIME_END, 'HH:MI AM'),'HH24:MI:SS'),ST.ORDER_OF_VISIT";
                ConnDriver connDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                BaseLogger.log("3", userInfo, null, "getData..sql[" + sql1 + "]transDB..." + transDB);
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(sql1);
                fromDate = genericUtility.getValidDateString(fromDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                pstmt.setDate(1, Date.valueOf(fromDate));
                toDate = genericUtility.getValidDateString(toDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                pstmt.setDate(2, Date.valueOf(toDate));
                pstmt.setString(3, empCode);
                pstmt.setString(4, empCode);
                LinkedHashMap teamMap = new LinkedHashMap();
                LinkedHashMap geoPosGrpMap = new LinkedHashMap();
                LinkedHashMap geoPosDetailMap = new LinkedHashMap();
                LinkedHashMap geoPosRouteMap = new LinkedHashMap();
                LinkedHashMap salesPersonMap = new LinkedHashMap();
                LinkedHashMap localityMap = new LinkedHashMap();
                LinkedHashMap orderOfVisitMap = new LinkedHashMap();
                JSONArray visitObjArray = new JSONArray();
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String markerID = E12GenericUtility.checkNull(rs.getString("MARKER"));
                    String addGeoPos = E12GenericUtility.checkNull(rs.getString("ADD_GEOPOS"));
                    String chgGeoPos = E12GenericUtility.checkNull(rs.getString("CHG_GEOPOS"));
                    String scName = E12GenericUtility.checkNull(rs.getString("DOCTOR_NAME"));
                    String scCode = E12GenericUtility.checkNull(rs.getString("DOCTOR_CODE"));
                    String localityDesc = E12GenericUtility.checkNull(rs.getString("DOCTOR_LOCALITY"));
                    String localityCode = E12GenericUtility.checkNull(rs.getString("LOCALITY_CODE"));
                    String spName = E12GenericUtility.checkNull(rs.getString("SP_NAME"));
                    String spCode = E12GenericUtility.checkNull(rs.getString("SALES_PERS"));
                    String orderOfVisit = E12GenericUtility.checkNull(rs.getString("ORDER_OF_VISIT"));
                    Date visitDate = rs.getDate("VISIT_DATE");
                    String eventDate = genericUtility.getValidDateString(visitDate, genericUtility.getApplDateFormat());
                    String visitTime = E12GenericUtility.checkNull(rs.getString("VISIT_TIME"));
                    String visitTimeEnd = E12GenericUtility.checkNull(rs.getString("VISIT_TIME_END"));
                    String geo_position = chgGeoPos.trim().length() > 0 ? chgGeoPos : addGeoPos;
                    String mapKey = String.valueOf(eventDate) + ":" + localityCode + ":" + geo_position;
                    String latitude = "";
                    String longitude = "";
                    if (geo_position != null && geo_position.length() > 0 && geo_position.indexOf(",") != -1) {
                        latitude = E12GenericUtility.checkNull(geo_position.substring(0, geo_position.indexOf(",")));
                        longitude = E12GenericUtility.checkNull(geo_position.substring(geo_position.indexOf(",") + 1));
                    }
                    JSONObject respJSONObj = E12GenericUtility.getOrderedJSONObject();
                    respJSONObj.put("disp_locality", (Object)"yes");
                    respJSONObj.put("marker_color", (Object)("pinColor" + markerID));
                    respJSONObj.put("latitude", (Object)latitude);
                    respJSONObj.put("longitude", (Object)longitude);
                    respJSONObj.put("geo_position", (Object)geo_position);
                    respJSONObj.put("add_geopos", (Object)addGeoPos);
                    respJSONObj.put("chg_geopos", (Object)chgGeoPos);
                    respJSONObj.put("sales_person", (Object)spCode);
                    respJSONObj.put("sp_name", (Object)spName);
                    respJSONObj.put("sc_code", (Object)scCode);
                    respJSONObj.put("sc_name", (Object)scName);
                    respJSONObj.put("locality_code", (Object)localityCode);
                    respJSONObj.put("locality_descr", (Object)localityDesc);
                    respJSONObj.put("order_of_visit", (Object)orderOfVisit);
                    respJSONObj.put("visit_date", (Object)visitDate);
                    respJSONObj.put("visit_time", (Object)visitTime);
                    respJSONObj.put("visit_time_end", (Object)visitTimeEnd);
                    visitObjArray.put((Object)respJSONObj);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                returnMapData = visitObjArray.toString();
            }
            catch (Exception e) {
                System.out.println("MapViewJB.getMapData() Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception MapViewJB getData:" + e.getMessage());
                e.printStackTrace();
            }
        }
        return returnMapData;
    }

    private String getFormattedCSV(String commaSepString) {
        StringBuffer formattedString = new StringBuffer();
        if (!"".equalsIgnoreCase(commaSepString)) {
            String[] attachmentArr = commaSepString.split(",");
            int len = attachmentArr.length;
            int cntr = 0;
            while (cntr < len) {
                formattedString.append("'").append(E12GenericUtility.checkNull(attachmentArr[cntr])).append("'");
                if (cntr < len - 1) {
                    formattedString.append(",");
                }
                ++cntr;
            }
        }
        if ("".equalsIgnoreCase(formattedString.toString())) {
            formattedString.append("''");
        }
        BaseLogger.log("2", null, null, "getFormattedCSV :[" + formattedString.toString() + "]");
        return formattedString.toString();
    }

    private String getAttribValue(String formDetailXml, String formNo, String attribStr) {
        String attribValue = "";
        try {
            Document detailDom = new E12GenericUtility().parseString(formDetailXml);
            NodeList detailDomList = detailDom.getElementsByTagName("Detail" + formNo);
            Node detailNode = detailDomList.item(0);
            attribValue = this.getAttribValue(detailNode, attribStr);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getAttribValue :" + e.getMessage());
        }
        return attribValue;
    }

    private String getAttribValue(Node detailNode, String attribStr) {
        String attribValue = "";
        try {
            Node attribNode;
            if (detailNode != null && detailNode.getAttributes() != null && (attribNode = detailNode.getAttributes().getNamedItem(attribStr)) != null) {
                attribValue = this.checkNull(attribNode.getNodeValue());
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getAttribValue :" + e.getMessage());
        }
        return attribValue;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    public String valMapData(String mapXmlData, String xtraParams) throws ITMException {
        return "";
    }
}

