/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMUploadFileEJB;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ITMUploadFileServlet
extends ITMAuthenticateServlet {
    public static File DUMP_DIR;
    private static File LOG_DUMP_DIR;
    private static int MAX_UPLOAD_SIZE;
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;

    static {
        MAX_UPLOAD_SIZE = 0xA00000;
    }

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            this.servletConfig = servletConfig;
            this.servletContext = servletConfig.getServletContext();
            if (CommonConstants.UPLOAD_LOC == null && CommonConstants.J2EE_VERSION.equals("1")) {
                BaseLogger.log("3", null, null, "UPLOAD_LOC is null");
                DUMP_DIR = new File(String.valueOf(new File(CommonConstants.APPLICATION_CONTEXT).getParentFile().getParent()) + File.separator + "dump");
                LOG_DUMP_DIR = new File(String.valueOf(DUMP_DIR.getParent()) + File.separator + "logs");
            } else {
                DUMP_DIR = new File(new File(CommonConstants.UPLOAD_LOC) + File.separator + "dump");
                if (!DUMP_DIR.exists()) {
                    DUMP_DIR.mkdir();
                }
                if (!(LOG_DUMP_DIR = new File(new File(CommonConstants.UPLOAD_LOC) + File.separator + "logs")).exists()) {
                    LOG_DUMP_DIR.mkdir();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        String loginCode = null;
        Object xmlStringBuff = null;
        boolean isExcelDriver = false;
        boolean isRetainPkValue = false;
        String menuObjName = null;
        try {
            BaseLogger.log("3", null, null, "request.getParameter(filefield)[" + request.getParameter("filefield") + "]");
            BaseLogger.log("3", null, null, "request.getParameter(filefieldXSL)[" + request.getParameter("filefieldXSL") + "]");
            menuObjName = request.getParameter("menuObjName");
            BaseLogger.log("3", null, null, "menuObjNameFromRequest :[" + menuObjName + "]");
            if (Boolean.valueOf(this.authenticate(request)).booleanValue()) {
                UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                loginCode = userInfo.getLoginCode();
                String[] propArray = this.loadFile(request, loginCode);
                String fileName = propArray[1];
                BaseLogger.log("3", userInfo, null, "fileName :[" + fileName + "]");
                isExcelDriver = Boolean.valueOf(propArray[5]);
                isRetainPkValue = Boolean.valueOf(propArray[6]);
                BaseLogger.log("3", userInfo, null, "isRetainPkValue in ITMUploadFileServelet:[" + isRetainPkValue + "]");
                menuObjName = propArray[4];
                BaseLogger.log("3", userInfo, null, "After loadFile menuObjName :[" + menuObjName + "]");
                Object xmlStringArr = null;
                Object objName = null;
                boolean isModeInteractive = propArray[0] == null ? false : Boolean.valueOf(propArray[0]);
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                ITMUploadFileEJB uploadfile = new ITMUploadFileEJB();
                String responseStr = uploadfile.insertFileData(propArray, userInfo, DUMP_DIR, CommonConstants.APPLICATION_CONTEXT, menuObjName, isExcelDriver, isRetainPkValue);
                uploadfile = null;
                request.getSession().setAttribute("responseString", (Object)responseStr);
                RequestDispatcher reqDis = this.servletContext.getRequestDispatcher("/webitm/jsp/DownloadFile.jsp");
                reqDis.forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (ITMException itme) {
            itme.printStackTrace();
            this.parseException(itme, out);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            BaseLogger.log("0", null, null, "Error reading or saving file");
            this.parseException(ioe, out);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.parseException(e, out);
        }
    }

    private String[] loadFile(HttpServletRequest request, String loginCode) throws Exception {
        String newFileName = null;
        String[] retArray = new String[7];
        try {
            Part part;
            this.servletContext.log("[" + loginCode + "]Uploading file......");
            MultipartParser mp = new MultipartParser(request, MAX_UPLOAD_SIZE);
            while ((part = mp.readNextPart()) != null) {
                String name = part.getName();
                if (part.isParam()) {
                    ParamPart paramPart = (ParamPart)part;
                    String value = paramPart.getStringValue();
                    if (part.getName().trim().equals("IS_INTERACTIVE")) {
                        retArray[0] = value;
                        continue;
                    }
                    if (part.getName().trim().equals("OBJ_NAME")) {
                        retArray[2] = value;
                        continue;
                    }
                    if (part.getName().trim().equals("is_ExcelDriver")) {
                        retArray[5] = value;
                        continue;
                    }
                    if (part.getName().trim().equals("menuObjName")) {
                        BaseLogger.log("3", null, null, "ITMUploadFileServletpart.getName().trim()).equals( menuObjName ).value[" + value + "]");
                        retArray[4] = value;
                        continue;
                    }
                    if (!part.getName().trim().equals("is_retainPkValue")) continue;
                    retArray[6] = value;
                    continue;
                }
                if (!part.isFile()) continue;
                FilePart filePart = (FilePart)part;
                String oriFileName = filePart.getFileName();
                newFileName = String.valueOf(System.currentTimeMillis()) + "_" + loginCode + "_" + oriFileName;
                if ("filefieldXSL".equals(part.getName())) {
                    retArray[3] = oriFileName;
                } else {
                    retArray[1] = newFileName;
                }
                long size = filePart.writeTo(DUMP_DIR);
                File oriFileObj = new File(DUMP_DIR + File.separator + oriFileName);
                if (!oriFileObj.exists()) continue;
                oriFileObj.renameTo(new File(DUMP_DIR + File.separator + newFileName));
            }
            this.servletContext.log("[" + loginCode + "]File uploaded");
        }
        catch (IOException lEx) {
            this.servletContext.log("[" + loginCode + "]Exception :ITMUploadFileServlet :loadFile :==>IOException");
            throw lEx;
        }
        catch (Exception e) {
            this.servletContext.log("[" + loginCode + "]Exception :ITMUploadFileServlet :loadFile :==>Exception");
            throw e;
        }
        return retArray;
    }

    private void parseException(Exception exception, PrintWriter out) {
        String redirect;
        String trace;
        String descr;
        String msg;
        block6: {
            msg = "";
            descr = "";
            trace = "";
            redirect = "";
            String xmlStr = "";
            try {
                xmlStr = exception.getMessage();
                BaseLogger.log("3", null, null, "[ITMUploadFileServlet]Exception Message :==>\n" + xmlStr);
                if (xmlStr.equals("")) break block6;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                ByteArrayInputStream baos = new ByteArrayInputStream(xmlStr.getBytes());
                Document doc = db.parse(baos);
                NodeList nlApp = doc.getElementsByTagName("Error");
                int appCnt = 0;
                while (appCnt < nlApp.getLength()) {
                    NodeList nlLveNL1 = nlApp.item(appCnt).getChildNodes();
                    msg = nlLveNL1.item(0).getFirstChild().getNodeValue();
                    try {
                        FileWriter fos = new FileWriter("four.prn");
                        fos.write(msg);
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Error in IMException-getMessage");
                    }
                    descr = nlLveNL1.item(1).getFirstChild().getNodeValue();
                    trace = nlLveNL1.item(2).getFirstChild().getNodeValue();
                    int ctr = 0;
                    while (trace.indexOf(10) != -1) {
                        StringBuffer strBuffer = new StringBuffer(trace);
                        int index = strBuffer.toString().indexOf(10);
                        strBuffer.replace(index, index + 1, "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        trace = strBuffer.toString();
                        strBuffer = null;
                        ++ctr;
                    }
                    redirect = nlLveNL1.item(3).getFirstChild().getNodeValue();
                    ++appCnt;
                }
            }
            catch (Exception ex) {
                descr = xmlStr;
                ex.printStackTrace();
            }
        }
        out.println("<HTML><BODY BGCOLOR='#EEEEEE'>");
        out.println("<b>Message :</b>" + msg);
        out.println("<br>");
        out.println("<b>Description : </b>" + descr);
        out.println("<br>");
        out.println("<b>Trace : </b>" + trace);
        out.println("<br>");
        out.println("<b>Redirect : </b>" + redirect);
        out.println("</BODY></HTML>");
    }
}

