/********************************************************
	Title : StrgCustDeactive
	Date  : 28/JUN/12
	Developer:Rakesh kumar
 ********************************************************/

package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.ejb.ValidatorEJB;
import ibase.system.config.ConnDriver;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class StrgCustDeactive extends ValidatorEJB implements StrgCustDeactiveLocal,StrgCustDeactiveRemote
{
	//changed by Rahul Barve on 3-sep-2014
	//GenericUtility genericUtility = GenericUtility.getInstance();
	 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	String winName = null;
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("xmlString ::"+xmlString);
			System.out.println("xmlString1 ::"+xmlString1);
			System.out.println("xmlString2 ::"+xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "";
		String sql="";
		String empCode="";
		String errCode="";
		String deactDate="";
		String profileId="";
		String rePortTo="";
		String errorType = "";
		String errString = "";
		String salesPers="";
		String custType = "";
		int ctr=0;
		int childNodeListLength;
		int currentFormNo = 0;
		long cnt = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			//conn = connDriver.getConnectDB("DriverITM");//Commented by kailash on 29-nov-18.
			conn = getConnection(); //Added by kailash on 29-nov-18.
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			String objName = checkNullAndTrim(getObjNameFromDom(dom, "objName", objContext ));
			if("doctor_deact".equalsIgnoreCase(objName))
			{
				custType = "D";
			}
			else if("chemist_deact".equalsIgnoreCase(objName))
			{
				custType = "C";
			}

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLSALPER";
							System.out.println("this is for null error code==================>"+errCode);
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}

						salesPers = genericUtility.getColumnValue("sales_pers", dom);
						sql="select count(*) from sales_pers where sales_pers= ?";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,salesPers);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							cnt =  rs.getInt(1);
						}
						if(cnt == 0)
						{
							errCode = "INVSLSPERS";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						rs.close();rs = null;
                        pstmt.close(); pstmt = null;

                        sql="select b.profile_id from sales_pers a,users b where a.sales_pers=b.code and b.code= ? ";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1,userId);
                        rs = pstmt.executeQuery();
                        if(rs.next())
                        {
                        	profileId=checkNull(rs.getString("profile_id"));
                        }
                        //added by prachi on 7th-feb-22 for dirty connection start
                        if(rs!=null)
                        {
                        	rs.close();
                        	rs= null;
                        }
                        if(pstmt!=null)
                        {
                        	pstmt.close();
                        	pstmt=null;
                        }
                        //end
                        if("FLM".equalsIgnoreCase(profileId.trim()))
                        {
                            sql="select count(*) from sales_pers a,employee b where a.sales_pers=b.emp_code and b.emp_code= ? and b.report_to= ?";
                            pstmt =  conn.prepareStatement(sql);
                            pstmt.setString(1,salesPers);
                            pstmt.setString(2,userId);
                            rs = pstmt.executeQuery();
                            if(rs.next())
                            {
                            	cnt =  rs.getInt(1);
                            }
                            if(cnt == 0)
                            {
                                errCode = "VMREPORTTO";
                                System.out.println("this errorcode for report to manager==========>"+errCode);
                                errList.add(errCode);
                                errFields.add(childNodeName.toLowerCase());
                            }
                            rs.close();rs = null;
                            pstmt.close(); pstmt = null;
                        }
                        int count = 0;
                        sql = "select count(*) as count "+
            					"from  strg_series strg_series, sales_pers sales_pers, speciality speciality,itemser itemser, "+
            					"strg_customer  strg_customer,locality  locality, strg_cust_subclass  strg_cust_subclass "+
            					"where  ( strg_series.item_ser      = itemser.item_ser   ) "+
            					"and ( strg_customer.locality_code      = locality.locality_code ) "+
            					"and ( strg_series.sales_pers=sales_pers.sales_pers(+)) "+
            					"and ( strg_series.spl_code=speciality.spl_code(+)) "+
            					"and ( strg_customer.sc_code=strg_series.sc_code(+)) "+
            					"and ( strg_series.subclass_code=strg_cust_subclass.subclass_code(+)) "+
            					"and strg_series.status='Y' "+
            					"and strg_series.item_ser in (select item_ser from itemser ) " +
            					" and strg_customer.status='Y'" +
            					"and strg_series.sales_pers = ? "+
            					"and strg_series.cust_type = ? " +
            					"and (strg_series.sales_pers, strg_series.sc_code) not in"+
            					"(select sales_pers,sc_code from strgcust_deactive  where status <> 'Y' OR  load_status not in('N','Y')) "+
            					"order by strg_series.short_id ";

            			pstmt = conn.prepareStatement(sql);
            			pstmt.setString(1,salesPers);
            			pstmt.setString(2,custType);
            			rs = pstmt.executeQuery();
            			if(rs.next())
            			{
            				count = rs.getInt("COUNT");
            			}
            			if (count == 0)
            			{
            				errCode = "NODACTDATA";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
            			}
            			rs.close();rs = null;
                        pstmt.close(); pstmt = null;
					}
					else if(childNodeName.equalsIgnoreCase("deact_date"))
                    {
						salesPers = genericUtility.getColumnValue("sales_pers", dom);
						deactDate = genericUtility.getColumnValue("deact_date", dom);
						Timestamp timestamp = new Timestamp(System.currentTimeMillis());
						if(childNode.getFirstChild() == null)
						{
							errCode = "NULLDACTDT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							/*
							java.util.Date sDate = simpleDateFormat.parse(deactDate);
							java.util.Date currDate = simpleDateFormat.parse(simpleDateFormat.format(timestamp).toString());

							if(  sDate.before(currDate))
							{
								errCode = "VDEACTDT1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

							sql="select count(*) from strg_meet where event_date= ? and sales_pers=?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(deactDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.setString(2,salesPers);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							if(cnt > 0)
							{
								errCode = "VDEACTDT2";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							*/
						}
                    }
				}
				break;
			case 2 :
				String customerName = "";
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("sc_code"))
					{
						java.sql.Date lastMeetDate = null;
						salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom1));
						String scCode = checkNull(genericUtility.getColumnValue("sc_code", dom));
						customerName = checkNull(genericUtility.getColumnValue("customer_name", dom));

						java.util.Date deactivateDate = simpleDateFormat.parse(genericUtility.getColumnValue("deact_date", dom1));

						SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());

						String selectStrgMeetSql = "SELECT MAX(EVENT_DATE) AS EVENT_DATE FROM STRG_MEET WHERE STRG_CODE= ? AND SALES_PERS = ?";
						PreparedStatement pstmtStrgMeet = conn.prepareStatement(selectStrgMeetSql);
						pstmtStrgMeet.setString(1, scCode);
						pstmtStrgMeet.setString(2, salesPers);
						ResultSet rsStrgMeet = pstmtStrgMeet.executeQuery();
						if (rsStrgMeet.next())
						{
							lastMeetDate = rsStrgMeet.getDate("EVENT_DATE");
						}
						//added by prachi on 7th-feb-22 for dirty connection start
						if(rsStrgMeet!=null)
                        {
							rsStrgMeet.close();
							rsStrgMeet= null;
                        }
                        if(pstmtStrgMeet!=null)
                        {
                        	pstmtStrgMeet.close();
                        	pstmtStrgMeet=null;
                        }
                        //end
						if ( lastMeetDate != null && deactivateDate != null && deactivateDate.compareTo(lastMeetDate) <= 0 )
						{
							errString = getErrorString( "EVENT_DATE","MEETEXIST",userId );
						}

					}
				}
				if( errString.indexOf("<Errors>")!=-1 )
				{
					if( errString.length() > 0 )
					{
						String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for customer " + customerName ;

						errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
						return errString;
					}

				}
			}

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}// End of try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//added by prachi on 7th-feb-22 for dirty connection start
				//connDriver = null;
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;

				}
				if(conn != null)
				{
					conn.close();
					conn=null;
					
				}
				//end
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			System.out.println("xmlString:::::::::::"+xmlString);
			System.out.println("xmlString:::::::::::"+xmlString1);
			System.out.println("xmlString:::::::::::"+xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);

			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [sales][itemChanged( String, String )] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String sql = "";
		String spName="";
		String profileId="";
		String userId="";
		String salesPers="";
		int currentFormNo = 0;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		StringBuffer valueXmlString = new StringBuffer();
		ConnDriver connDriver = new ConnDriver();
		try
		{
			//conn = connDriver.getConnectDB("DriverITM");//Commented by kailash on 29-nov-18.
			conn = getConnection(); //Added by kailash on 29-nov-18.
			System.out.println("user id is equal to===============>"+userId);
			conn.setAutoCommit(false);
			connDriver = null;
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());


			switch ( currentFormNo )
			{
				case 1:
				{
					valueXmlString.append("<Detail1>");
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
						String chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
						System.out.println("***********sales person name inside itmdefault************");
						sql="select a.sp_name,b.profile_id from sales_pers a, users b where a.sales_pers=b.code and b.code= ? ";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,userId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							profileId=checkNull(rs.getString("profile_id"));
							System.out.println("profile id is equal to ===============>"+profileId);
							spName =checkNull(rs.getString("sp_name"));
							System.out.println("sales Person name is equal to==============>"+spName);
						}
						if("MR".equalsIgnoreCase(profileId.trim()))
						{
							valueXmlString.append("<sales_pers protect=\"1\">").append("<![CDATA["+ userId +"]]>").append("</sales_pers>");
							valueXmlString.append("<sp_name protect=\"1\">").append("<![CDATA["+ spName +"]]>").append("</sp_name>");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						valueXmlString.append("<login_code>").append("<![CDATA["+ userId +"]]>").append("</login_code>");
						valueXmlString.append("<chg_date>").append("<![CDATA["+ currDate +"]]>").append("</chg_date>");
						valueXmlString.append("<chg_user>").append("<![CDATA["+ userId +"]]>").append("</chg_user>");
						valueXmlString.append("<chg_term>").append("<![CDATA["+ chgTerm +"]]>").append("</chg_term>");
					}
					else if(currentColumn.trim().equalsIgnoreCase("sales_pers"))
					{
						salesPers = genericUtility.getColumnValue("sales_pers", dom);
						System.out.println("sales person is equal to===============>"+salesPers);
						sql = "select sp_name from sales_pers where sales_pers = ?";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,salesPers);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							spName = checkNull(rs.getString("sp_name"));
							System.out.println("sales person name inside item cahenged=========>"+spName);
						}
						valueXmlString.append("<sp_name>").append("<![CDATA[" + spName +"]]>").append("</sp_name>");
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("</Detail1>");
				}
				break;
				case 2 :
				{
					//valueXmlString.append("<Detail2>");
					if(currentColumn.equalsIgnoreCase("itm_default"))
					{
						System.out.println("in detail 2");
						String customerDetail = getCustomerData( dom, dom1, dom2, currentFormNo, editFlag, xtraParams );
						valueXmlString.append( customerDetail );
					}
					//valueXmlString.append("</Detail2>");

				}
				break;
			}
			/*
			else if(currentColumn.trim().equalsIgnoreCase("sales_pers"))
			{
				salesPers = genericUtility.getColumnValue("sales_pers", dom);
				System.out.println("sales person is equal to===============>"+salesPers);
				sql = "select sp_name from sales_pers where sales_pers = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					spName = checkNull(rs.getString("sp_name"));
					System.out.println("sales person name inside item cahenged=========>"+spName);
				}
				valueXmlString.append("<sp_name>").append("<![CDATA[" + spName +"]]>").append("</sp_name>");
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
			*/


		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				connDriver = null;
				if(conn != null)
				{
					if(rs != null)
						rs.close();
					if(pstmt != null)
						pstmt.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		valueXmlString.append("</Root>");
		System.out.println("valueXmlString ::"+valueXmlString.toString());
		return valueXmlString.toString();
	}
	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		try
		{
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,errorCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}
	private String checkNull(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value;
	}
	public String getCustomerData(Document currentDom, Document headerDom, Document allDom, int currentForm, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		String resultString = "";
		String salesPers = "";
		String objName = "";
		String custType = "";
		String sql= null ;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();
		try
		{

			ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");//Commented by kailash on 29-nov-18.
			conn = getConnection(); //Added by kailash on 29-nov-18.
			connDriver = null;
			conn.setAutoCommit(false);
			salesPers = genericUtility.getColumnValue("sales_pers",headerDom);
			String deactDateStr = genericUtility.getColumnValue("deact_date",headerDom);

			objName = checkNullAndTrim(getObjNameFromDom(currentDom, "objName", ""+currentForm ));
			if("doctor_deact".equalsIgnoreCase(objName))
			{
				custType = "D";
			}
			else if("chemist_deact".equalsIgnoreCase(objName))
			{
				custType = "C";
			}
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date deactDate = sdf.parse(deactDateStr);

			String currDate = sdf.format(new java.util.Date());
			//valueXmlString = new StringBuffer("<?xml version = \"1.0\"?><Root><header><editFlag>");
			//valueXmlString.append(editFlag).append("</editFlag></header>");

			sql = "select strg_series.sc_code, strg_series.short_id, strg_series.sales_pers, "+
					"(upper (strg_customer.first_name )|| '  ' || upper(strg_customer.middle_name) || '  ' || upper(strg_customer.last_name) )as customer_name, "+
					"strg_series.no_visit, strg_series.class_code_descr, speciality.descr as speciality_descr, strg_cust_subclass.subclass_descr, "+
					"locality.descr as locality_descr, strg_series.business_to_us, strg_series.total_business,  strg_series.no_patient_day, "+
					"strg_series.route_id, strg_series.item_ser, itemser.descr as itemser_descr , strg_series.status, strg_customer.practicing_since, "+
					"strg_customer.visit_time_fr,strg_customer.visit_time_to, strg_customer.locality_code " +
					"from  strg_series strg_series, sales_pers sales_pers, speciality speciality,itemser itemser, "+
					"strg_customer  strg_customer,locality  locality, strg_cust_subclass  strg_cust_subclass "+
					"where  ( strg_series.item_ser      = itemser.item_ser   ) "+
					"and ( strg_customer.locality_code      = locality.locality_code ) "+
					"and ( strg_series.sales_pers=sales_pers.sales_pers(+)) "+
					"and ( strg_series.spl_code=speciality.spl_code(+)) "+
					"and ( strg_customer.sc_code=strg_series.sc_code(+)) "+
					"and ( strg_series.subclass_code=strg_cust_subclass.subclass_code(+)) "+
					"and strg_series.status='Y' "+
					"and strg_series.item_ser <> 'OTC' and strg_customer.status='Y'" +
					"and strg_series.sales_pers = ? "+
					"and strg_series.cust_type = ? " +
					"and (strg_series.sales_pers, strg_series.sc_code) not in"+
					"(select sales_pers,sc_code from strgcust_deactive  where status <> 'X' ) "+
					"order by strg_series.short_id ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,salesPers);
			pstmt.setString(2,custType);
			rs = pstmt.executeQuery();
			int domID = 1;
			while(rs.next())
			{
				String lastMeetDateStr = "";
				String isGreater = "";
				java.util.Date lastMeetDate = null;
				String scCode = checkNull(rs.getString("SC_CODE"));
				String selectStrgMeetSql = "SELECT MAX(EVENT_DATE) AS EVENT_DATE FROM STRG_MEET WHERE STRG_CODE= ? AND SALES_PERS = ?";
				PreparedStatement pstmtStrgMeet = conn.prepareStatement(selectStrgMeetSql);
				pstmtStrgMeet.setString(1, scCode);
				pstmtStrgMeet.setString(2, salesPers);
				ResultSet rsStrgMeet = pstmtStrgMeet.executeQuery();
				if (rsStrgMeet.next())
				{
					lastMeetDate = rsStrgMeet.getDate("EVENT_DATE") ;//(rsStrgMeet.getDate("EVENT_DATE") == null) ?"":sdf.format(rsStrgMeet.getDate("EVENT_DATE"));
				}
				lastMeetDateStr = (lastMeetDate == null) ?"":sdf.format(lastMeetDate);
				rsStrgMeet.close(); rsStrgMeet = null;
				pstmtStrgMeet.close(); pstmtStrgMeet = null;

				if( lastMeetDate != null && lastMeetDate.compareTo(deactDate) >= 0 )
				{
					isGreater = "Y";
				}
				else
				{
					isGreater = "N";
				}

				valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'N'>\r\n" );
				valueXmlString.append("<sc_code><![CDATA[").append(checkNullAndTrim(rs.getString("SC_CODE"))).append("]]></sc_code>\r\n");
				valueXmlString.append("<short_id><![CDATA[").append(rs.getInt("short_id")).append("]]></short_id>\r\n");
				valueXmlString.append("<customer_name><![CDATA[").append(checkNullAndTrim(rs.getString("customer_name"))).append("]]></customer_name>\r\n");
				valueXmlString.append("<no_visit><![CDATA[").append(checkNullAndTrim(rs.getString("no_visit"))).append("]]></no_visit>\r\n");
				valueXmlString.append("<class_code_descr><![CDATA[").append(checkNullAndTrim(rs.getString("class_code_descr"))).append("]]></class_code_descr>\r\n");
				valueXmlString.append("<subclass_descr><![CDATA[").append(checkNullAndTrim(rs.getString("subclass_descr"))).append("]]></subclass_descr>\r\n");
				valueXmlString.append("<speciality_descr><![CDATA[").append(checkNullAndTrim(rs.getString("speciality_descr"))).append("]]></speciality_descr>\r\n");
				valueXmlString.append("<locality_descr><![CDATA[").append(checkNullAndTrim(rs.getString("locality_descr"))).append("]]></locality_descr>\r\n");
				valueXmlString.append("<business_to_us><![CDATA[").append(rs.getDouble("business_to_us")).append("]]></business_to_us>\r\n");
				valueXmlString.append("<total_business><![CDATA[").append(rs.getDouble("total_business")).append("]]></total_business>\r\n");
				valueXmlString.append("<no_patient_day><![CDATA[").append(checkNullAndTrim(rs.getString("no_patient_day"))).append("]]></no_patient_day>\r\n");
				valueXmlString.append("<route_id><![CDATA[").append(rs.getString("route_id")).append("]]></route_id>\r\n");
				valueXmlString.append("<item_ser><![CDATA[").append(checkNullAndTrim(rs.getString("item_ser"))).append("]]></item_ser>\r\n");
				valueXmlString.append("<itemser_descr><![CDATA[").append(checkNullAndTrim(rs.getString("itemser_descr"))).append("]]></itemser_descr>\r\n");
				valueXmlString.append("<status><![CDATA[").append(checkNullAndTrim(rs.getString("status"))).append("]]></status>\r\n");
				valueXmlString.append("<practicing_since><![CDATA[").append(checkNullAndTrim(rs.getString("practicing_since"))).append("]]></practicing_since>\r\n");
				valueXmlString.append("<visit_time_fr><![CDATA[").append(checkNullAndTrim(rs.getString("visit_time_fr"))).append("]]></visit_time_fr>\r\n");
				valueXmlString.append("<visit_time_to><![CDATA[").append(checkNullAndTrim(rs.getString("visit_time_to"))).append("]]></visit_time_to>\r\n");
				valueXmlString.append("<locality_code><![CDATA[").append(checkNullAndTrim(rs.getString("locality_code"))).append("]]></locality_code>\r\n");
				valueXmlString.append("<sales_pers><![CDATA[").append(checkNullAndTrim(rs.getString("sales_pers"))).append("]]></sales_pers>\r\n");
				valueXmlString.append("<tran_id><![CDATA[").append("").append("]]></tran_id>\r\n");
				valueXmlString.append("<tran_date><![CDATA[").append(currDate).append("]]></tran_date>\r\n");
				valueXmlString.append("<deact_date><![CDATA[").append(currDate).append("]]></deact_date>\r\n");
				valueXmlString.append("<cust_type><![CDATA[").append(custType).append("]]></cust_type>\r\n");
				valueXmlString.append("<last_meet_date><![CDATA[").append(lastMeetDateStr).append("]]></last_meet_date>\r\n");
				valueXmlString.append("<isGreater><![CDATA[").append(isGreater).append("]]></isGreater>\r\n");
				valueXmlString.append("<chg_date>").append("<![CDATA[ "+ currDate +"]]>").append("</chg_date>");

				//valueXmlString.append("<chg_user>").append("<![CDATA[ "+ userId +"]]>").append("</chg_user>");
				//valueXmlString.append("<chg_term>").append("<![CDATA[ "+ chgTerm +"]]>").append("</chg_term>");

				valueXmlString.append( "</Detail"+currentForm+">\r\n" );
				domID ++;
			}
			String spName = genericUtility.getColumnValue("sp_name",headerDom);
			valueXmlString.append( "<Detail1>\r\n" );
			valueXmlString.append("<sp_name><![CDATA[").append(spName).append("]]></sp_name>\r\n");
			valueXmlString.append("<deact_date><![CDATA[").append(deactDateStr).append("]]></deact_date>\r\n");
			valueXmlString.append( "</Detail1>\r\n" );
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				System.out.println(e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
		    for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		System.out.println("objName =["+objName+"]");
		return objName;
	}
	public String getSalesPersonList( String loginCode ) throws RemoteException,ITMException
	{
		System.out.println("Inside StrgCustDeactive == > getSalesPersonList");
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");//Commented by kailash on 29-nov-18.
			conn = getConnection(); //Added by kailash on 29-nov-18.;

			int userLevel = 0;
			String profileID = "";
			sql = "SELECT PROFILE_ID,USR_LEV FROM USERS WHERE CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, loginCode );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				profileID = checkNullAndTrim(rs.getString("PROFILE_ID"));
				userLevel = rs.getInt("USR_LEV");
			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;

			if ("FLM".equalsIgnoreCase(profileID))
			{
				sql = "SELECT A.SALES_PERS, A.SP_NAME FROM SALES_PERS A, EMPLOYEE B WHERE A.SALES_PERS = B. EMP_CODE AND B.REPORT_TO = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString( 1, loginCode );
				rs = pstmt.executeQuery();
				int num = 1;
				while (rs.next())
				{
					String salesPers = checkNullAndTrim(rs.getString("SALES_PERS"));
					String spName = checkNullAndTrim(rs.getString("SP_NAME"));

					valueXmlString.append("<SALESPERS domID='" + num	+ "' selected = 'N'>\r\n");

					valueXmlString.append("<SALES_PERS><![CDATA[").append(salesPers).append("]]></SALES_PERS>\r\n");
					valueXmlString.append("<SP_NAME><![CDATA[").append(spName).append("]]></SP_NAME>\r\n");
					valueXmlString.append("</SALESPERS>\r\n");
					num++;
				}
			}
			//Commented and changes made by Gaurav Singh on 04-12-14
			//else if ( !"MR".equalsIgnoreCase(profileID) && userLevel == 0 )
			else if ( !"MR".equalsIgnoreCase(profileID) )
			{
				sql = "SELECT SALES_PERS, SP_NAME FROM SALES_PERS ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				int num = 1;
				while (rs.next())
				{
					String salesPers = checkNullAndTrim(rs.getString("SALES_PERS"));
					String spName = checkNullAndTrim(rs.getString("SP_NAME"));

					valueXmlString.append("<SALESPERS domID='" + num	+ "' selected = 'N'>\r\n");

					valueXmlString.append("<SALES_PERS><![CDATA[").append(salesPers).append("]]></SALES_PERS>\r\n");
					valueXmlString.append("<SP_NAME><![CDATA[").append(spName).append("]]></SP_NAME>\r\n");
					valueXmlString.append("</SALESPERS>\r\n");
					num++;
				}
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String):"	+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()	+ ":********");
		return valueXmlString.toString();
	}
	private String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	//Added by kailash on 06-12-18 for doctor deactivation changes [start]
	public String getSalesPersonList( String loginCode, Connection conn ) throws RemoteException,ITMException
	{
		System.out.println("Inside StrgCustDeactive == 935> getSalesPersonList");
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			String profileID = "";
			sql = "SELECT PROFILE_ID,USR_LEV FROM USERS WHERE CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, loginCode );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				profileID = checkNullAndTrim(rs.getString("PROFILE_ID"));
				System.out.println("profileID["+profileID+"]");
			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;

			if ("FLM".equalsIgnoreCase(profileID))
			{
				sql = "SELECT A.SALES_PERS, A.SP_NAME FROM SALES_PERS A, EMPLOYEE B WHERE A.SALES_PERS = B. EMP_CODE AND B.REPORT_TO = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString( 1, loginCode );
				rs = pstmt.executeQuery();
				int num = 1;
				while (rs.next())
				{
					String salesPers = checkNullAndTrim(rs.getString("SALES_PERS"));
					String spName = checkNullAndTrim(rs.getString("SP_NAME"));

					valueXmlString.append("<SALESPERS domID='" + num	+ "' selected = 'N'>\r\n");

					valueXmlString.append("<SALES_PERS><![CDATA[").append(salesPers).append("]]></SALES_PERS>\r\n");
					valueXmlString.append("<SP_NAME><![CDATA[").append(spName).append("]]></SP_NAME>\r\n");
					valueXmlString.append("</SALESPERS>\r\n");
					num++;
				}
			}
			else if ( !"MR".equalsIgnoreCase(profileID) )
			{
				System.out.println("inside else977["+profileID+"]");
				sql = "SELECT SALES_PERS, SP_NAME FROM SALES_PERS ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				int num = 1;
				while (rs.next())
				{
					String salesPers = checkNullAndTrim(rs.getString("SALES_PERS"));
					String spName = checkNullAndTrim(rs.getString("SP_NAME"));

					valueXmlString.append("<SALESPERS domID='" + num	+ "' selected = 'N'>\r\n");

					valueXmlString.append("<SALES_PERS><![CDATA[").append(salesPers).append("]]></SALES_PERS>\r\n");
					valueXmlString.append("<SP_NAME><![CDATA[").append(spName).append("]]></SP_NAME>\r\n");
					valueXmlString.append("</SALESPERS>\r\n");
					num++;
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String)1001:"	+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String) 1021:==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()	+ ":********");
		return valueXmlString.toString();
	}
	//Added by kailash on 06-12-18 for doctor deactivation changes [end]

}


