package ibase.utility;

import java.rmi.RemoteException;

import org.json.JSONObject;



/*
<%
ibase.ejb.CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
userInfo = commonDBAccessEJB.createUserInfo(userCode);
%>
*/		

import ibase.ejb.CommonDBAccessEJB;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.E12ExternalAPICall;
import ibase.webitm.utility.ITMException;

/*
 * Author : Gagan B.
 * Date: 25-JAN-24
 * Purpose: A generic Utility Class which will take transaction ID and object name and generate Vision specific XML.
 * After that if required convert in client specific format.
 * Then push that data to external API.
 * This API details will be configured in Table: ENT_EXT_API_KEY
 * 
 * */

public class APIPushTransData extends ValidatorEJB {
	CommonMethods commonMethods = null;
	
	E12GenericUtility genericUtility = new E12GenericUtility();
	DBAccessEJB dbAccess = new DBAccessEJB();
	CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();

	
	public String extAPICallFUA(String tranID, String xtraParam, String extAppId, String serviceClass)
			throws RemoteException, ITMException {
		String retValue = "";
		BaseLogger.log("3", null, null, "Inside ConfirmTransaction extAPICallFUA tranID:> [" + tranID + "]");
		BaseLogger.log("3", null, null, "Inside ConfirmTransaction extAPICallFUA extAppId : [" + extAppId + "]");
		BaseLogger.log("3", null, null, "Inside ConfirmTransaction extAPICallFUA xtraParam [" + xtraParam + "]");
		BaseLogger.log("3", null, null, "Inside ConfirmTransaction extAPICallFUA serviceClass [" + serviceClass + "]");
		
		UserInfoBean userInfos = null;
		String scCode = "VR00457819";
		
		StrgCustUserInfo strgCustUserInfo = new StrgCustUserInfo();
		userInfos = strgCustUserInfo.createStrgCustUserInfo(scCode);
		BaseLogger.log("3", null, null,
				"[TelegarmBotUtility] : handleTelegramRequest gsb userInfo[" + userInfos +"]");
		
		
		try {
			String userCode = genericUtility.getValueFromXTRA_PARAMS(xtraParam,"loginCode");
			BaseLogger.log( "3", null, null, "Inside extAPICallFUA userCode:: ["+ userCode +"]" );
			UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userCode);
			
			String objName = genericUtility.getValueFromXTRA_PARAMS(xtraParam,"objName");
			BaseLogger.log( "3", null, null, "Inside extAPICallFUA objName ["+ objName +"]" );
			
			String dataFormat = dbAccess.getDBColumnValue( "AUTH_APPS_API", "REQ_DATA_FORMAT", (" OBJ_NAME = '"+ objName +"' AND APP_ID = '"+ extAppId +"' "), userInfo.getTransDB() );
			BaseLogger.log( "3", null, null, "Inside extAPICallFUA dataFormat ["+ dataFormat +"]" );
			
			if (dataFormat.equalsIgnoreCase("0")) 
			{
				dataFormat = "JSON";
			} 
			else if (dataFormat.equalsIgnoreCase("1")) 
			{
				dataFormat = "XML";
			}
			else 
			{
				retValue = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[" + "Invalid Data Format" + "]]></RESULT></ROOT>";
				return retValue;
			}
			/*
			String appId = dbAccess.getDBColumnValue( "AUTH_APPS_API", "APP_ID", (" OBJ_NAME = '"+ objName +"' "), userInfo.getTransDB() );
			BaseLogger.log( "3", null, null, "Inside extAPICallFUA appId ["+ appId +"]" );
			
			String serviceClass = dbAccess.getDBColumnValue( "AUTH_APPS_API", "SERVICE_CLASS", (" OBJ_NAME = '"+ objName +"' AND APP_ID = '"+ extAppId +"' "), userInfo.getTransDB() );
			BaseLogger.log( "3", null, null, "Inside extAPICallFUA serviceClass ["+ serviceClass +"]" );
			*/
			String serviceSetting = dbAccess.getDBColumnValue( "AUTH_APPS_API", "SERVICE_SETTING", (" OBJ_NAME = '"+ objName +"' AND APP_ID = '"+ extAppId +"' "), userInfo.getTransDB() );
			BaseLogger.log( "3", null, null, "Inside extAPICallFUA serviceSetting >> ["+ serviceSetting +"]" );
			JSONObject serviceSettingJSON = new JSONObject(serviceSetting);
			
			if (serviceSettingJSON.has("isExternal") && serviceSettingJSON.getString("isExternal").equals("true"))
			{
				//BaseLogger.log( "3", null, null, "Inside if block to get isExternal: ["+ serviceSetting +"]" );

				String apiCallResult = sendDataToExtAPI(extAppId, objName, tranID, dataFormat, serviceClass, userInfo);
				retValue = apiCallResult;
				BaseLogger.log( "3", null, null, "Inside extAPICallFUA apiCallResult ["+ apiCallResult +"]" );
			}
			else
			{
				// error string --> For the given APP Id external calling is not configured.
				retValue = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[" + "External API not configured" + "]]></RESULT></ROOT>";
				return retValue;
			}
			
			/*
			if (serviceSettingJSON != null) {
				if (serviceSettingJSON.has("extAppId") ) {
					String extAppId = serviceSettingJSON.getString("extAppId");
					BaseLogger.log( "3", null, null, "Inside extAPICallFUA extAppId ["+ extAppId +"]" );
				}
			}
			*/
			
			
		} catch (Exception e) {
			// TODO: handle exception
		}
		retValue = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[" + "result:" + retValue + "]]></RESULT></ROOT>";
		return retValue;
	}
	
	/*
	 * 1. extAppID = Application ID of the client whose API is to be called. This will be defined in 2 tables: AUTH_APPS_API , ENT_EXT_API_KEY
	 * 2. objName = Object name for which the transaction data needs to be sent.
	 * 3. tranID = Transaction ID for which the transaction data needs to be sent.
	 * 4. dataFormat = Data format (JSON/XML) in which the vision data needs to be sent to cleint.
	 * 5. serviceClass = Handy while defining multiple outbound endpoints for a client. Configured in AUTH_APPS_API.SERVICE_CLASS 
	 * */
	
	public String sendDataToExtAPI(String extAppID, String objName, String tranID, String dataFormat, String serviceClass,
			UserInfoBean userInfo) {
		commonMethods = new CommonMethods(userInfo.getLoginCode());
		String apiResult = "";
		String visionData = "";

		try {
			// 1. Generate the vision transaction XML/JSON
			String transXMLString = getTransXMLStr(tranID, objName, userInfo);
			System.out.println("Inside APIPushTransData sendDataToExtAPI transXMLString gsb [" + transXMLString + "]");
			visionData = transXMLString;

			if (dataFormat.equalsIgnoreCase("JSON")) {
				String jsonData = commonMethods.getSortedJson(transXMLString, objName);
				BaseLogger.log("3", null, null, "Inside sendDataToExtAPI jsonData gsb [" + jsonData + "]");
				visionData = jsonData;
			}
			
			/* 2. Create the object of E12ExternalAPICall
			 * ENT_EXT_API_KEY.API_NAME = AUTH_APPS_API.APP_ID
			 */
			
			BaseLogger.log("3", null, null, "below the if block ");

			E12ExternalAPICall e12ExternalAPICall = new E12ExternalAPICall(extAppID, userInfo);
			
			BaseLogger.log("3", null, null, " below the E12ExternalAPICall constructor ");

			
			
			String apiURL = commonMethods.getExternalAPIURL(extAppID,serviceClass);
			BaseLogger.log("3", null, null, "Inside APIPushTransData sendDataToExtAPI apiURL [" + apiURL + "]");
			
			apiResult = e12ExternalAPICall.apiCallToPostData(extAppID, apiURL, "A", "E", "", "", null, visionData, userInfo, "");
			BaseLogger.log("3", null, null, "Inside sendDataToExtAPI apiResult [" + apiResult + "]");


		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return apiResult;
	}

	public String getTransXMLStr(String tranID, String objName, UserInfoBean userInfo) {
		BaseLogger.log("3", null, null, "Inside getTransXMLStr tranID[" + tranID + "]");
		BaseLogger.log("3", null, null, "Inside getTransXMLStr objName[" + objName + "]");
		String xmlString = "";
		try {
			xmlString = commonMethods.getDetailXMLDomString(objName, "1", "V", tranID, null);
			BaseLogger.log("3", null, null, "Inside getTransXMLStr before formatting[" + xmlString + "]");
			
			xmlString = commonMethods.getFormattedXML(xmlString, objName);
			BaseLogger.log("3", null, null, "Inside getTransXMLStr[" + xmlString + "]");

		} catch (RemoteException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ITMException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return xmlString;
	}

}
