/*
 *	Author: Satya
 *	Date: 10/08/10
 *	Reason : Unconfirm a confirmed Report
 *	request: WS90N0V048
 */
package ibase.webitm.ejb.wsfa.transactions;


import java.util.*;
import java.util.Date;
import java.sql.*;
import java.io.*;
import java.net.InetAddress;
import java.rmi.RemoteException;
import javax.ejb.*;
import javax.naming.InitialContext;
import java.text.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.ejb.*;
import ibase.system.config.*;
import ibase.utility.*;
import ibase.webitm.ejb.adm_SAG.SampleStockInvtraceUpd ;



@javax.ejb.Stateless
public class  UnconfirmDARPrc extends ProcessEJB implements UnconfirmDARPrcRemote,UnconfirmDARPrcLocal
{
	SessionContext cSessionContext;
	protected static String database = CommonConstants.DB_NAME;
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	E12GenericUtility genericUtility = new E12GenericUtility();//Added by vinayak on [12/07/2016] to create genericUtility instance

	public void setSessionContext(SessionContext mSessionContext) 
	{
		try
		{
			CommonConstants.setIBASEHOME();
			ProcessEJB.DB_NAME = CommonConstants.DB_NAME;
			this.cSessionContext = mSessionContext;
		}
		catch (Exception e)
		{
			System.out.println("Exception :UnconfirmDARPrc :setSessionContext :==>"+e);
		}
	}

	public String process() throws RemoteException,ITMException
	{
		return "";
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String retStr = "";
		Document detailDom = null;
		Document headerDom = null;
		//GenericUtility genericUtility = GenericUtility.getInstance();//Commented by Vinayak on [13/07/2016]];
		try
		{
			System.out.println("xmlString   ["+xmlString+"]");
			System.out.println("xmlString2  ["+xmlString2+"]");
			System.out.println("windowName   ["+windowName+"]");
			System.out.println("xtraParams   ["+xtraParams+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString);
			}
			if(xmlString2 != null && xmlString2.length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2);
			}
			retStr = process(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :UnconfirmDARPrc :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retStr;
	}


	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String columnValue ="";
		String childNodeName = "";
		String insertSQL = "";
		String workDate = "" ;
		String salesPers = "";
		String isSelected = "";
		String errString = "";
		String loginCode = "";
		String database = CommonConstants.DB_NAME;
		String parentName = "" ;
		boolean status = false;


		Connection conn = null;


		//GenericUtility genericUtility = GenericUtility.getInstance();//Commented by Vinayak on [13/07/2016]];
		loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");


		try
		{
			System.out.println("[UnconfirmDARPrc:process()]");
			//Commented by vinayak on [11/07/2016] [start]
			/*	ConnDriver connDriver = new ConnDriver();			
			conn = connDriver.getConnectDB("DriverITM");*/
			//Commented by vinayak on [11/07/2016] [end]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.	
			conn.setAutoCommit(false);
			NodeList parentNodeList = detailDom.getElementsByTagName("Detail2");
			int parentNodeListLength = parentNodeList.getLength();
			if ( parentNodeListLength == 0 )
			{
				errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"E\" column_name=\"\"><message>Process Not Done</message><description>No Data Found For Process</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";		
				return errString;
			}
			for (int parentNo = 0; parentNo < parentNodeListLength; parentNo++ )
			{
				Node parentNode = parentNodeList.item(parentNo);
				NodeList childNodeList = parentNode.getChildNodes(); 
				int chlidNodeListLength = childNodeList.getLength();
				isSelected = "";
				for (int childNo = 0;childNo < chlidNodeListLength ; childNo++ )
				{					
					Node childNode = childNodeList.item(childNo);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals("sales_pers"))
					{
						if(childNode.getFirstChild()!=null)
						{
							salesPers = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("work_date"))
					{
						if(childNode.getFirstChild()!=null)
						{
							workDate = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("is_selected")) 
					{
						if (childNode.getFirstChild()!=null)
						{
							isSelected = childNode.getFirstChild().getNodeValue();
						}
					}


				}


				//Commented by kailash for solving checkbox selection issue as per sachin[START].
				/*if (isSelected != null && isSelected.trim().equalsIgnoreCase("true"))
				{*/
				String wrkDtNew = workDate;
				workDate = genericUtility.getValidDateString(workDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
				System.out.println("workDate:a:dsd["+workDate+"]::wrkDtNew:New one:["+wrkDtNew+"]");
				errString =  unConfirm(salesPers,workDate,xtraParams,conn);
				System.out.println("errString:::["+errString+"]");
				if (errString != null && errString.trim().length() > 0)
				{
					break;
				}
				//}//Commented by kailash for solving checkbox selection issue as per sachin[END].
				//Added by Sachin Satre on [09-MAR-21] for the check uncofirm date expense is in draft mode then it should be delete from expense table [Start]
				PreparedStatement pstmtExp = null;
				ResultSet rsetExp = null;
				//int tourIdCnt = 0 ;
				String tourId ="";
				String dailyTourId ="";
				String dateFromExp="";
				String expDeleteSql ="";
				int deleteCnt = 0 ;
				String expDrftSql = "SELECT  TD.DATE_FROM AS DAILY_DATE ,T.TOUR_ID AS MAIN_TOUR_ID , TD.TOUR_ID AS DAILY_TOUR_ID "
						+ " FROM TOUR T ,TOURDET TD "
						+ " WHERE T.EMP_CODE = ? "
						+ " AND T.DATE_FROM <= ? "
						+ " AND T.date_to >= ? "
						+ " AND T.TOUR_ID = TD.TOUR_ID  "
						+ " AND TD.date_from = ? "
						+ " AND T.CONFIRMED NOT IN ('A','Y') "; // Added by Sachin Satre on 30-mar-21 if expense submit then system should allow to delete the expense of that day/Date.
				
				pstmtExp = conn.prepareStatement( expDrftSql );
				pstmtExp.setString(1,salesPers);
				pstmtExp.setDate(2,java.sql.Date.valueOf(workDate));
				pstmtExp.setDate(3,java.sql.Date.valueOf(workDate));
				pstmtExp.setDate(4,java.sql.Date.valueOf(workDate));
				
				/*pstmtExp.setTimestamp(2,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( wrkDtNew, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )) );
				pstmtExp.setTimestamp(3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( wrkDtNew, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )) );
				pstmtExp.setTimestamp(4, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( wrkDtNew, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )) );
				*/
				rsetExp = pstmtExp.executeQuery();
				if ( rsetExp.next() )
				{
					tourId = checkNull(rsetExp.getString("MAIN_TOUR_ID"));
					dateFromExp = rsetExp.getString("DAILY_DATE");
					dailyTourId = checkNull(rsetExp.getString("DAILY_TOUR_ID"));
				}
				if ( rsetExp !=null )
				{
					rsetExp.close();
					rsetExp = null;
				}
				if( pstmtExp != null)
				{
					pstmtExp.close();
					pstmtExp = null;
				}
				System.out.println("tourIdCnt:Exp draft mdoe::["+tourId+"]::dateFromExp::["+dateFromExp+"]");
				if (tourId != null && tourId.trim().length() > 0)
				{
					expDeleteSql="DELETE FROM TOURDET WHERE TOUR_ID = ? AND DATE_FROM = ? ";
					pstmtExp = conn.prepareStatement(expDeleteSql);
					pstmtExp.setString(1,tourId);
					pstmtExp.setDate(2,java.sql.Date.valueOf(workDate));
					deleteCnt = pstmtExp.executeUpdate();
					System.out.println("Delete expense count is >>> "+deleteCnt);
					if(pstmtExp != null)
					{
						pstmtExp.close();
						pstmtExp = null;
					}
					//errString = getErrorString("work_date","EXPDARUNCO",userId,errString);
					//errString = getModifiedErrorString(errString, workDate);
					//break;
				}
				//Added by Sachin Satre on [09-MAR-21] for the check uncofirm date expense is in draft mode then it should be delete from expense table [Start]
				
			}
			if (errString == null || errString.trim().length() == 0)
			{
				conn.commit();
				//errString = "";
				errString = itmDBAccessEJB.getErrorString("", "VTPRC1", "", "",	conn);//Added By Nilesh Start :: 26-03-19
			}
			else
			{
				conn.rollback();
				errString = itmDBAccessEJB.getErrorString("", "VTPRNT", "", "",	conn);//Added By Nilesh Start :: 26-03-19
			}

		}
		catch (Exception e)
		{

			try
			{
				if (conn != null)
				{
					conn.rollback();
				}
			}
			catch (Exception exe)
			{
				exe.printStackTrace();
			}

			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn!= null)
				{
					conn.close();
					conn = null ;
				}
			}
			catch (Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		System.out.println( "Return From Process Logic::::::::::::::"+errString);

		return errString;
	}





	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;

		//GenericUtility genericUtility = GenericUtility.getInstance();//Commented by Vinayak on [13/07/2016]];
		try
		{

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString); 				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2); 				
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :UnconfirmDARPrc :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			rtrStr = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		return rtrStr; 
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;
		StringBuffer sqlString = new StringBuffer();


		ConnDriver connDriver = new ConnDriver();
		//GenericUtility genericUtility = GenericUtility.getInstance();//Commented by Vinayak on [13/07/2016]];

		StringBuffer valueXmlString  = null;
		int cnt = 0;
		try
		{			
			//conn = connDriver.getConnectDB( "DriverITM" );//Commented by vinayak on [11/07/16	]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.

			int i =2;

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");

			String empCode = genericUtility.getColumnValue( "emp_code", headerDom );
			String fromDate = genericUtility.getColumnValue( "from_date", headerDom );
			String toDate = genericUtility.getColumnValue( "to_date", headerDom );

			/*sql =	" SELECT   SALES_PERS ,  WORK_DATE , SUBMISSION_DATE , LAST_UPDATE ,  UPDATED_BY , CONFIRMATION_FLAG , GENERAL_REMARK , CHG_DATE ,"+
					" CHG_USER , CHG_TERM , MODE_REPO   FROM  DR_MAIN "+
					" WHERE  SALES_PERS = ?  AND WORK_DATE >= ?  AND  (WORK_DATE <= ? ) AND ( CONFIRMATION_FLAG = 'Y' ) ";*/
			//sqlString.append("SELECT SALES_PERS,EVENT_DATE,CONFIRMED,REMARK,CHG_DATE , CHG_USER , CHG_TERM FROM SPRS_ACT_TRAN where SALES_PERS = ? ");
			//sqlString.append(" AND EVENT_DATE >= ?  AND  (EVENT_DATE <= ? ) AND ( CONFIRMED = 'Y' ) ORDER BY EVENT_DATE ");

			
			sqlString.append("SELECT S.SALES_PERS,S.EVENT_DATE,S.CONFIRMED,S.REMARK,S.CHG_DATE , S.CHG_USER , S.CHG_TERM,S.ACTIVITY_CODE FROM SPRS_ACT_TRAN S JOIN FIELDACTIVITY F ON S.ACTIVITY_CODE=F.ACTIVITY_CODE where (F.ACTIVITY_SEL not in ('S') OR F.ACTIVITY_SEL IS NULL) AND S.SALES_PERS = ? ");
			sqlString.append(" AND S.EVENT_DATE >= ?  AND  (S.EVENT_DATE <= ? ) AND ( S.CONFIRMED = 'Y' ) ORDER BY S.EVENT_DATE ");

			pstmt = conn.prepareStatement( sqlString.toString() );
			pstmt.setString(1,empCode);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(fromDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
			pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(toDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
			rSet = pstmt.executeQuery();
			while( rSet.next() )
			{
				/*String lastUpdate = genericUtility.getValidDateString(rSet.getString("LAST_UPDATE"), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
				String submissionDate = genericUtility.getValidDateString(rSet.getString("SUBMISSION_DATE"), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());*/
				String workDate = genericUtility.getValidDateString(rSet.getString("EVENT_DATE"), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());


				valueXmlString.append("<Detail2 domID='"+i+"' >\r\n");
				valueXmlString.append("<attribute updateFlag='N' selected='N' />\r\n");
				/*valueXmlString.append("<is_selected><![CDATA[").append("").append("]]></is_selected>\r\n");*/
				valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(rSet.getString("SALES_PERS"))).append("]]></sales_pers>\r\n");
				valueXmlString.append("<work_date><![CDATA[").append(checkNull(workDate)).append("]]></work_date>\r\n");
				/*valueXmlString.append("<submission_date><![CDATA[").append(checkNull(submissionDate)).append("]]></submission_date>\r\n");*/
				/*valueXmlString.append("<last_update><![CDATA[").append(checkNull(lastUpdate)).append("]]></last_update>\r\n");*/
				/*valueXmlString.append("<updated_by><![CDATA[").append(checkNull(rSet.getString("UPDATED_BY"))).append("]]></updated_by>\r\n")*/;
				valueXmlString.append("<confirmation_flag><![CDATA[").append(rSet.getString("CONFIRMED")).append("]]></confirmation_flag>\r\n");
				valueXmlString.append("<general_remark><![CDATA[").append(checkNull(rSet.getString("REMARK"))).append("]]></general_remark>\r\n");
				valueXmlString.append("<chg_date><![CDATA[").append(checkNull(rSet.getString("CHG_DATE"))).append("]]></chg_date>\r\n");
				valueXmlString.append("<chg_user><![CDATA[").append(checkNull(rSet.getString("CHG_USER"))).append("]]></chg_user>\r\n");
				valueXmlString.append("<chg_term><![CDATA[").append(checkNull(rSet.getString("CHG_TERM"))).append("]]></chg_term>\r\n");
				/*valueXmlString.append("<mode_repo><![CDATA[").append(checkNull(rSet.getString("MODE_REPO"))).append("]]></mode_repo>\r\n");*/
				valueXmlString.append("</Detail2>\r\n");
				i++;
			}
			if( rSet != null )
			{
				rSet.close();
				rSet=null;
			}
			if( pstmt != null )
			{
				pstmt.close();	
				pstmt=null;
			}

			valueXmlString.append("</Header0>\r\n");
			valueXmlString.append("</group0>\r\n");	
			valueXmlString.append("</DocumentRoot>\r\n");
		}
		catch( Exception e)
		{
			e.printStackTrace();	
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();				
				}
				if( rSet != null )
				{
					rSet.close();				
				}
				if( conn != null )
				{
					conn.close();				
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		//Changed by deepak on 19/08/09 for closing connection for [WS89NOV433] .End
		return valueXmlString.toString();
	}

	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}

	//private String unConfirm( String salesPers, String workDate, String xtraParams, Connection conn ) throws ITMException,Exception
	public String unConfirm( String salesPers, String workDate, String xtraParams, Connection conn ) throws ITMException,Exception // Changed by Sachin Satre on [10-Dec-18] for define method for public because same method call from submission when MGR fill feedback for UNCONFIRM_DAR request.
	{
		System.out.println("unConfirm:: called SSS");
		int itemQtyTot = 0;
		int result = 0;

		String itemCode = "";
		String scCode = "";
		String unit = "" ;
		String siteCode= "";
		String updQuery = "";
		String errString = "" ;
		ArrayList mapList = new ArrayList();
		HashMap parentMap[] = null;

		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmtSiteCode = null;
		ResultSet rs = null;
		ResultSet rsSiteCode = null;
		PreparedStatement meetPstmt=null;
		ResultSet meetRs=null;
		String sql="";
		int count=0;
		int updateAllwsDelayPrd=0;
		SampleStockInvtraceUpd updateStockEntry = new SampleStockInvtraceUpd();
		// added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value [start]
		ResultSet rSet = null;
		PreparedStatement pstmtDrMain = null;
		PreparedStatement pstmtSampleDrCnt = null;
		PreparedStatement pstmtSampleDr = null;
		PreparedStatement pstmtSampleItem = null;
		PreparedStatement pstmtSampleItemUpd = null;
		PreparedStatement pstmtInvTrace = null;
		PreparedStatement pstmtActTran = null;
		// and added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value [end]
		
		String eventDate = null;
		String unconfBy = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
//		DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
//		java.util.Date date = Calendar.getInstance().getTime();
//		String unconf_date = dtFormat.format(date);


		try
		{ 
			String sampleAllow = getSfaParmValue(salesPers,"SAMPLE_ALLOW",conn); // added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value
			String darVersion = getSfaParmValue(salesPers,"DAR_VERSION",conn);
			if(darVersion.equalsIgnoreCase("WSFA"))
			{
				// commentted and added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value [start]
				/*sql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, salesPers);
				pstmt.setDate(2,java.sql.Date.valueOf(workDate));
				rs=pstmt.executeQuery();
				if(rs.next())
				{
					count=rs.getInt("COUNT");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( count > 0 )
				{

					sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE >= ?";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					updateAllwsDelayPrd = pstmt.executeUpdate();
					pstmt.clearParameters();
					System.out.println("updated count is >>> "+updateAllwsDelayPrd);
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}

				String countSql="SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ";
				meetPstmt=conn.prepareStatement(countSql);
				meetPstmt.setString(1, salesPers);
				meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
				meetRs=meetPstmt.executeQuery();
				if(meetRs.next())
				{
					count = meetRs.getInt("COUNT");
				}
				if(meetRs != null)
				{
					meetRs.close();
					meetRs = null;
				}
				if(meetPstmt != null)
				{
					meetPstmt.close();
					meetPstmt = null;
				}
				if(count > 0)
				{
					//String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS IN("+empCode+") AND EVENT_DATE >= ?";
					String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE >= ?";
					meetPstmt = conn.prepareStatement(updateSql);
					meetPstmt.setString(1, salesPers);
					meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
					updateAllwsDelayPrd = meetPstmt.executeUpdate();
					meetPstmt.clearParameters();
					System.out.println("updated count is >>> "+updateAllwsDelayPrd);
					if(meetPstmt != null)
					{
						meetPstmt.close();
						meetPstmt = null;
					}
				}*/

				if(sampleAllow.equalsIgnoreCase("E") || sampleAllow.equalsIgnoreCase("C"))
				{
					//sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE = ?";
					sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N',DAR_UNCONF_CNT = ? WHERE SALES_PERS = ?  AND EVENT_DATE = ?";
					pstmtActTran = conn.prepareStatement(sql);

					String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE = ?";
					meetPstmt = conn.prepareStatement(updateSql);

					//sql = "SELECT SALES_PERS,EVENT_DATE FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ORDER BY EVENT_DATE";
					//sql = "SELECT SALES_PERS,EVENT_DATE,DAR_UNCONF_CNT,DCR_ID FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ORDER BY EVENT_DATE";
					sql = "SELECT SALES_PERS,EVENT_DATE,DAR_UNCONF_CNT,DCR_ID FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE = ? ORDER BY EVENT_DATE";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					rs=pstmt.executeQuery();
					while(rs.next())
					{
						eventDate = rs.getString("EVENT_DATE");
						int darunconfcount = rs.getInt("DAR_UNCONF_CNT");
						darunconfcount = darunconfcount+1;
						String dcrId = checkNull(rs.getString("DCR_ID"));
						eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
						workDate = genericUtility.getValidDateString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
						System.out.println("Before dr_main called");

						pstmtActTran.setInt(1, darunconfcount);
						pstmtActTran.setString(2, salesPers);
						pstmtActTran.setDate(3,java.sql.Date.valueOf(workDate));
						updateAllwsDelayPrd = pstmtActTran.executeUpdate();
						pstmtActTran.clearParameters();
						System.out.println("updated count is >>> "+updateAllwsDelayPrd);

						meetPstmt.setString(1, salesPers);
						meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
						updateAllwsDelayPrd = meetPstmt.executeUpdate();
						meetPstmt.clearParameters();
						System.out.println("updated count is >>> "+updateAllwsDelayPrd);
						
						////Added By Haseeb on [29-10-2021] START
						insertDCRUnconfLog( salesPers, eventDate, dcrId, unconfBy,"Unconfirm DAR", conn);
						//Added By Haseeb Khan on [29/10/2021] [END]
						//Added by Bhagyashri T on[26/11/21][START][W21HSUN028]
						deleteDCRPlanConf( salesPers, eventDate, dcrId,conn);
						//Added by Bhagyashri T on[26/11/21][END]
						
					}
					//Added by mrunalini Sinkar to close connection on11-Feb-2022(Start)
					if(pstmtActTran != null)
					{
						pstmtActTran.close();
						pstmtActTran = null;
					}
					if(meetPstmt != null)
					{
						meetPstmt.close();
						meetPstmt = null;
					}
					//Added by mrunalini Sinkar to close connection on11-Feb-2022(End)
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				else
				{
					//Added By Haseeb Khan on [29/10/2021] [START]
					String dcrId="";
					sql = "SELECT SALES_PERS,EVENT_DATE,DAR_UNCONF_CNT,DCR_ID FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE = ?";
					int darunconfcount = 0;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					rs=pstmt.executeQuery();
					if(rs.next()) {
						darunconfcount = rs.getInt("DAR_UNCONF_CNT");
						darunconfcount = darunconfcount+1;
						dcrId = checkNull(rs.getString("DCR_ID"));
						eventDate = rs.getString("EVENT_DATE");
						eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
					}
					
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					//sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE = ?";
					sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N',DAR_UNCONF_CNT = ? WHERE SALES_PERS = ?  AND EVENT_DATE = ?";

					//Added By Haseeb Khan on [29/10/2021] [END];
					pstmt = conn.prepareStatement(sql);
					pstmt.setInt(1, darunconfcount);
					pstmt.setString(2, salesPers);
					pstmt.setDate(3,java.sql.Date.valueOf(workDate));
					updateAllwsDelayPrd = pstmt.executeUpdate();
					pstmt.clearParameters();
					System.out.println("updated count is >>> "+updateAllwsDelayPrd);
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE = ?";
					meetPstmt = conn.prepareStatement(updateSql);
					meetPstmt.setString(1, salesPers);
					meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
					updateAllwsDelayPrd = meetPstmt.executeUpdate();
					meetPstmt.clearParameters();
					System.out.println("updated count is >>> "+updateAllwsDelayPrd);
					if(meetPstmt != null)
					{
						meetPstmt.close();
						meetPstmt = null;
					}
					
					////Added By Haseeb Khan on [29/10/2021] [START]
					insertDCRUnconfLog(salesPers, eventDate, dcrId, unconfBy,"Unconfirm DAR", conn);
					//Added By Haseeb Khan on [29/10/2021] [END]
					//Added by Bhagyashri T on[26/11/21][START][W21HSUN028]
					deleteDCRPlanConf( salesPers, eventDate, dcrId,conn);
					//Added by Bhagyashri T on[26/11/21][END]
					
				}
				
				// commentted and added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value [end]
			}
			else if( !darVersion.equalsIgnoreCase("WSFA") || darVersion.equalsIgnoreCase("BOTH"))
			{	
				// commentted and added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value [start]
				/*System.out.println("Before dr_main called");
				//step 1: set confim flag to 'N' in DR_MAIN	
				updQuery = "UPDATE DR_MAIN SET CONFIRMATION_FLAG = 'N' WHERE SALES_PERS = ? AND WORK_DATE = ? ";
				pstmt = conn.prepareStatement(updQuery);
				pstmt.setString(1,salesPers);
				pstmt.setDate(2,java.sql.Date.valueOf(workDate));

				int noOfRows = pstmt.executeUpdate();

				System.out.println(noOfRows+" number  of rows updated succesfully in DR_MAIN");
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null ;
				}
				//step 2: get sitecode from employee master..
				String siteCodeQuery = "SELECT EMPLOYEE.EMP_SITE SITE_CODE FROM  EMPLOYEE WHERE EMPLOYEE.EMP_CODE =?";
				pstmtSiteCode = conn.prepareStatement(siteCodeQuery);
				pstmtSiteCode.setString(1,salesPers);
				rsSiteCode = pstmtSiteCode.executeQuery();

				if (rsSiteCode.next())
				{
					siteCode = rsSiteCode.getString("site_code");
				}
				if (rsSiteCode != null)
				{
					rsSiteCode.close();
					rsSiteCode = null ;
				}
				if (pstmtSiteCode != null)
				{
					pstmtSiteCode.close();
					pstmtSiteCode = null ;
				}
				//step 3:get hashmap array object
				String cntSql =  "SELECT COUNT(*) CNT FROM  "+
								"(SELECT SC_CODE , ITEM_CODE, ITEM_QTY AS QUANTITY FROM DR_SAMPLE_DISTRIBUTED "+
								" WHERE SALES_PERS =?  AND WORK_DATE = ? ) SAMP_DIST , ITEM  "+
								" WHERE ITEM.ITEM_CODE = SAMP_DIST.ITEM_CODE";
				pstmt = conn.prepareStatement(cntSql);
				pstmt.setString(1,salesPers);
				pstmt.setDate(2,java.sql.Date.valueOf(workDate));
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					int size = rs.getInt("CNT");
					parentMap = new HashMap[size];
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null ;
				}

				//step 4: update the issue quantity from sprs_item and stock
				String selSql = "SELECT SAMP_DIST.ITEM_CODE, ITEM.UNIT,SAMP_DIST.SC_CODE,SAMP_DIST.QUANTITY FROM  "+
								"(SELECT SC_CODE , ITEM_CODE, ITEM_QTY AS QUANTITY FROM DR_SAMPLE_DISTRIBUTED "+
								" WHERE SALES_PERS =?  AND WORK_DATE = ? ) SAMP_DIST , ITEM  "+
								" WHERE ITEM.ITEM_CODE = SAMP_DIST.ITEM_CODE";



				pstmt = conn.prepareStatement(selSql);

				pstmt.setString(1,salesPers);
				pstmt.setDate(2,java.sql.Date.valueOf(workDate));
				rs = pstmt.executeQuery();
				int index = 0 ;
				while (rs.next())
				{
					itemCode= rs.getString( "ITEM_CODE" );
					scCode= rs.getString( "SC_CODE" );
					itemQtyTot = rs.getInt( "QUANTITY" );
					unit = rs.getString( "UNIT" );
					System.out.println("[item code :"+itemCode+"]--[scCode:"+scCode+"][total:"+itemQtyTot+"][unit:"+unit+"]");
					//Changed by Pawan on 17/12/10 [WS90SUN048] to fix the bug of status update.start
					updQuery= "UPDATE SPRS_ITEM SET QUANTITY = QUANTITY + ?  , STATUS = (CASE WHEN ((CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) - (CASE WHEN ISSUE_QTY IS NULL THEN 0 ELSE ISSUE_QTY END)) > 0 THEN 'Y' ELSE 'N' END) , REPLY_STATUS = '0'  WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
					pstmt1 = conn.prepareStatement(updQuery);
					pstmt1.setInt(1,itemQtyTot);
					pstmt1.setString(2,salesPers);
					pstmt1.setString(3,itemCode);
					result = pstmt1.executeUpdate();
					updQuery= "UPDATE SPRS_ITEM SET QUANTITY = QUANTITY + ?, REPLY_STATUS = '0'  WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
					pstmt1 = conn.prepareStatement(updQuery);
					pstmt1.setInt(1,itemQtyTot);
					pstmt1.setString(2,salesPers);
					pstmt1.setString(3,itemCode);
					result = pstmt1.executeUpdate();
					System.out.println(itemCode+"["+result+" rows updated in SPRS_ITEM]");

					updQuery= "UPDATE SPRS_ITEM SET STATUS = (CASE WHEN ((CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) - (CASE WHEN ISSUE_QTY IS NULL THEN 0 ELSE ISSUE_QTY END)) > 0 THEN 'Y' ELSE 'N' END) WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
					pstmt1 = conn.prepareStatement(updQuery);
					pstmt1.setString(1,salesPers);
					pstmt1.setString(2,itemCode);
					result = pstmt1.executeUpdate();
					//Changed by Pawan on 17/12/10 [WS90SUN048] to fix the bug of status update.end

					System.out.println(itemCode+"["+result+" rows updated in SPRS_ITEM]");

					// Modified by Abhishek on [06/12/2011][To put work date as ref_date into HashMap and the same will get updated in sample_invtrace]
					//parentMap[index] = getDetailHashMap( itemCode, scCode, itemQtyTot, unit ); 
					parentMap[index] = getDetailHashMap( itemCode, scCode, itemQtyTot, unit, java.sql.Date.valueOf(workDate));

					index++;
			    }
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}

				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(pstmt1!=null)
				{
					pstmt1.close();
					pstmt1=null;
				}

				if (parentMap.length > 0)
				{

					errString = updateStockEntry.updateSampleStock("w_unconfirm_dar","S-DRCP",xtraParams , salesPers,salesPers,siteCode,siteCode,"","FRSH",parentMap,conn);
					//Modified by Abhishek on [26/04/2012][To update unconfirm count so that the report can be re-confirmed without error of duplicate records][Start]
					if (errString == null || errString.trim().length() == 0)
					{

						String sundryCode = salesPers;
						System.out.println("Sundry Code from Hashmap@@@"+sundryCode);

						String UpdateSql = "UPDATE SAMPLE_INVTRACE SET DAR_UNCONF_CNT=(CASE WHEN DAR_UNCONF_CNT IS NULL THEN 0 ELSE DAR_UNCONF_CNT END +1) WHERE SUNDRY_CODE = ? AND REF_SER IN ('S-DRCP','S-DISS') AND REF_DATE = ?";				

						System.out.println("sql is "+UpdateSql);
						pstmt = conn.prepareStatement(UpdateSql);

						pstmt.setString(1,sundryCode);
						pstmt.setDate(2,java.sql.Date.valueOf(workDate));
						pstmt.executeUpdate();
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}

					}
					//Modified by Abhishek on [26/04/2012][To update unconfirm count so that the report can be re-confirmed without error of duplicate records][End]
				}
				//Added By Nilesh Start :: 26-03-19
					String parmValue = getSfaParmValue(salesPers,"SEQUENTIAL_DAR",conn); // added by mrunalini sinkar on 21-Feb-2018(start)
					if(parmValue.equalsIgnoreCase("Y"))
					{
						int seqCount = checkSequentialReporting(conn, salesPers );

						if( seqCount == 0)
						{
							sql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, salesPers);
							pstmt.setDate(2,java.sql.Date.valueOf(workDate));
							rs=pstmt.executeQuery();
							if(rs.next())
							{
								count=rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}

							if( count > 0 )
							{

								sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE >= ?";

								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, salesPers);
								pstmt.setDate(2,java.sql.Date.valueOf(workDate));
								updateAllwsDelayPrd = pstmt.executeUpdate();
								pstmt.clearParameters();
								System.out.println("updated count is >>> "+updateAllwsDelayPrd);
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							}

							String countSql="SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ";
							meetPstmt=conn.prepareStatement(countSql);
							meetPstmt.setString(1, salesPers);
							meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
							meetRs=meetPstmt.executeQuery();
							if(meetRs.next())
							{
								count = meetRs.getInt("COUNT");
							}
							if(meetRs != null)
							{
								meetRs.close();
								meetRs = null;
							}
							if(meetPstmt != null)
							{
								meetPstmt.close();
								meetPstmt = null;
							}
							if(count > 0)
							{
								//String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS IN("+empCode+") AND EVENT_DATE >= ?";
								String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE >= ?";
								meetPstmt = conn.prepareStatement(updateSql);
								meetPstmt.setString(1, salesPers);
								meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
								updateAllwsDelayPrd = meetPstmt.executeUpdate();
								meetPstmt.clearParameters();
								System.out.println("updated count is >>> "+updateAllwsDelayPrd);
								if(meetPstmt != null)
								{
									meetPstmt.close();
									meetPstmt = null;
								}
							}
						}
						else
						{

							System.out.println("Not Sequnetional ****");
							sql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, salesPers);
							pstmt.setDate(2,java.sql.Date.valueOf(workDate));
							rs=pstmt.executeQuery();
							if(rs.next())
							{
								count=rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}

							if( count > 0 )
							{

								sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE = ?";

								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, salesPers);
								pstmt.setDate(2,java.sql.Date.valueOf(workDate));
								updateAllwsDelayPrd = pstmt.executeUpdate();
								pstmt.clearParameters();
								System.out.println("updated count is >>> "+updateAllwsDelayPrd);
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							}

							String countSql="SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE = ? ";
							meetPstmt=conn.prepareStatement(countSql);
							meetPstmt.setString(1, salesPers);
							meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
							meetRs=meetPstmt.executeQuery();
							if(meetRs.next())
							{
								count = meetRs.getInt("COUNT");
							}
							if(meetRs != null)
							{
								meetRs.close();
								meetRs = null;
							}
							if(meetPstmt != null)
							{
								meetPstmt.close();
								meetPstmt = null;
							}
							if(count > 0)
							{
								//String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS IN("+empCode+") AND EVENT_DATE >= ?";
								String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE = ?";
								meetPstmt = conn.prepareStatement(updateSql);
								meetPstmt.setString(1, salesPers);
								meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
								updateAllwsDelayPrd = meetPstmt.executeUpdate();
								meetPstmt.clearParameters();
								System.out.println("updated count is >>> "+updateAllwsDelayPrd);
								if(meetPstmt != null)
								{
									meetPstmt.close();
									meetPstmt = null;
								}
							}

						}
					}*/

				//Added By Nilesh End :: 26-03-19

				if(sampleAllow.equalsIgnoreCase("E") || sampleAllow.equalsIgnoreCase("C"))
				{
					updQuery = "UPDATE DR_MAIN SET CONFIRMATION_FLAG = 'N' WHERE SALES_PERS = ? AND WORK_DATE = ? ";
					pstmtDrMain = conn.prepareStatement(updQuery);

					String siteCodeQuery = "SELECT EMPLOYEE.EMP_SITE SITE_CODE FROM  EMPLOYEE WHERE EMPLOYEE.EMP_CODE =?";
					pstmtSiteCode = conn.prepareStatement(siteCodeQuery);

					String cntSql =  "SELECT COUNT(*) CNT FROM  "+
							"(SELECT SC_CODE , ITEM_CODE, ITEM_QTY AS QUANTITY FROM DR_SAMPLE_DISTRIBUTED "+
							" WHERE SALES_PERS =?  AND WORK_DATE = ? ) SAMP_DIST , ITEM  "+
							" WHERE ITEM.ITEM_CODE = SAMP_DIST.ITEM_CODE";
					pstmtSampleDrCnt = conn.prepareStatement(cntSql);

					String selSql = "SELECT SAMP_DIST.ITEM_CODE, ITEM.UNIT,SAMP_DIST.SC_CODE,SAMP_DIST.QUANTITY FROM  "+
							"(SELECT SC_CODE , ITEM_CODE, ITEM_QTY AS QUANTITY FROM DR_SAMPLE_DISTRIBUTED "+
							" WHERE SALES_PERS =?  AND WORK_DATE = ? ) SAMP_DIST , ITEM  "+
							" WHERE ITEM.ITEM_CODE = SAMP_DIST.ITEM_CODE";
					pstmtSampleDr = conn.prepareStatement(selSql);

					updQuery= "UPDATE SPRS_ITEM SET QUANTITY = QUANTITY + ?, REPLY_STATUS = '0'  WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
					pstmtSampleItem = conn.prepareStatement(updQuery);

					updQuery= "UPDATE SPRS_ITEM SET STATUS = (CASE WHEN ((CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) - (CASE WHEN ISSUE_QTY IS NULL THEN 0 ELSE ISSUE_QTY END)) > 0 THEN 'Y' ELSE 'N' END) WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
					pstmtSampleItemUpd = conn.prepareStatement(updQuery);

					String UpdateSql = "UPDATE SAMPLE_INVTRACE SET DAR_UNCONF_CNT=(CASE WHEN DAR_UNCONF_CNT IS NULL THEN 0 ELSE DAR_UNCONF_CNT END +1) WHERE SUNDRY_CODE = ? AND REF_SER IN ('S-DRCP','S-DISS') AND REF_DATE = ?";				
					pstmtInvTrace = conn.prepareStatement(UpdateSql);

					//sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE = ?";
					sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N',DAR_UNCONF_CNT = ? WHERE SALES_PERS = ?  AND EVENT_DATE = ?";
					pstmtActTran = conn.prepareStatement(sql);

					String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE = ?";
					meetPstmt = conn.prepareStatement(updateSql);

					//sql = "SELECT SALES_PERS,EVENT_DATE,DAR_UNCONF_CNT,DCR_ID FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ORDER BY EVENT_DATE";
					sql = "SELECT SALES_PERS,EVENT_DATE,DAR_UNCONF_CNT,DCR_ID FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE = ? ORDER BY EVENT_DATE";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					rs=pstmt.executeQuery();
					if(rs.next())
					{
						//String eventDate
						eventDate = rs.getString("EVENT_DATE");
						int darunconfcount = rs.getInt("DAR_UNCONF_CNT");
						darunconfcount = darunconfcount+1;
						System.out.println("UNCONF-COUNT >>>> "+darunconfcount);
						String dcrId = checkNull(rs.getString("DCR_ID"));
						eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
						workDate = genericUtility.getValidDateString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
						System.out.println("Before dr_main called");

						pstmtDrMain.setString(1,salesPers);
						pstmtDrMain.setDate(2,java.sql.Date.valueOf(workDate));

						int noOfRows = pstmtDrMain.executeUpdate();
						pstmtDrMain.clearParameters();

						System.out.println(noOfRows+" number  of rows updated succesfully in DR_MAIN");

						pstmtSiteCode.setString(1,salesPers);
						rsSiteCode = pstmtSiteCode.executeQuery();

						if (rsSiteCode.next())
						{
							siteCode = rsSiteCode.getString("site_code");
						}
						pstmtSiteCode.clearParameters();
						if (rsSiteCode != null)
						{
							rsSiteCode.close();
							rsSiteCode = null ;
						}
						//added by prachi
						if (pstmtSiteCode != null)
						{
							pstmtSiteCode.close();
							pstmtSiteCode = null ;
						}//end

						pstmtSampleDrCnt.setString(1,salesPers);
						pstmtSampleDrCnt.setDate(2,java.sql.Date.valueOf(workDate));
						rSet = pstmtSampleDrCnt.executeQuery();
						if (rSet.next())
						{
							int size = rSet.getInt("CNT");
							parentMap = new HashMap[size];
						}
						pstmtSampleDrCnt.clearParameters();
						if (rSet != null)
						{
							rSet.close();
							rSet = null ;
						}
					

						pstmtSampleDr.setString(1,salesPers);
						pstmtSampleDr.setDate(2,java.sql.Date.valueOf(workDate));
						rSet = pstmtSampleDr.executeQuery();
						int index = 0 ;
						while (rSet.next())
						{
							itemCode= rSet.getString( "ITEM_CODE" );
							scCode= rSet.getString( "SC_CODE" );
							itemQtyTot = rSet.getInt( "QUANTITY" );
							unit = rSet.getString( "UNIT" );
							System.out.println("[item code :"+itemCode+"]--[scCode:"+scCode+"][total:"+itemQtyTot+"][unit:"+unit+"]");
							pstmtSampleDrCnt.clearParameters();

							pstmtSampleItem.setInt(1,itemQtyTot);
							pstmtSampleItem.setString(2,salesPers);
							pstmtSampleItem.setString(3,itemCode);
							result = pstmtSampleItem.executeUpdate();
							System.out.println(itemCode+"["+result+" rows updated in SPRS_ITEM]");
							pstmtSampleItem.clearParameters();

							pstmtSampleItemUpd.setString(1,salesPers);
							pstmtSampleItemUpd.setString(2,itemCode);
							result = pstmtSampleItemUpd.executeUpdate();
							System.out.println(itemCode+"["+result+" rows updated in SPRS_ITEM]");
							pstmtSampleItemUpd.clearParameters();
							parentMap[index] = getDetailHashMap( itemCode, scCode, itemQtyTot, unit, java.sql.Date.valueOf(workDate));

							index++;
						}
						if(rSet!=null)
						{
							rSet.close();
							rSet=null;
						}
						//added by prachi start
						if(pstmtSampleDr!=null)
						{
							pstmtSampleDr.close();
							pstmtSampleDr=null;
						}
						if(pstmtSampleItemUpd!=null)
						{
							pstmtSampleItemUpd.close();
							pstmtSampleItemUpd=null;
						}
						if(pstmtSampleItem!=null)
						{
							pstmtSampleItem.close();
							pstmtSampleItem=null;
						}
                        //end
						if (parentMap.length > 0)
						{
							errString = updateStockEntry.updateSampleStock("w_unconfirm_dar","S-DRCP",xtraParams , salesPers,salesPers,siteCode,siteCode,"","FRSH",parentMap,conn);
							if (errString == null || errString.trim().length() == 0)
							{
								String sundryCode = salesPers;
								System.out.println("Sundry Code from Hashmap@@@"+sundryCode);

								pstmtInvTrace.setString(1,sundryCode);
								pstmtInvTrace.setDate(2,java.sql.Date.valueOf(workDate));
								pstmtInvTrace.executeUpdate();
								pstmtInvTrace.clearParameters();
							}
						}
						//added by prachi
						if(pstmtInvTrace != null)
						{
							pstmtInvTrace.close();
							pstmtInvTrace = null;
						}//end
						pstmtActTran.setInt(1, darunconfcount);
						pstmtActTran.setString(2, salesPers);
						pstmtActTran.setDate(3,java.sql.Date.valueOf(workDate));
						updateAllwsDelayPrd = pstmtActTran.executeUpdate();
						pstmtActTran.clearParameters();
						System.out.println("updated count is >>> "+updateAllwsDelayPrd);
						//Added by mrunalini Sinkar to close connection on11-Feb-2022(Start)
						if(pstmtActTran != null)
						{
							pstmtActTran.close();
							pstmtActTran = null;
						}
						//Added by mrunalini Sinkar to close connection on11-Feb-2022(End)
						meetPstmt.setString(1, salesPers);
						meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
						updateAllwsDelayPrd = meetPstmt.executeUpdate();
						meetPstmt.clearParameters();
						//Added by mrunalini Sinkar to close connection on11-Feb-2022(Start)
						if(meetPstmt != null)
						{
							meetPstmt.close();
							meetPstmt = null;
						}
						//Added by mrunalini Sinkar to close connection on11-Feb-2022(End)

						System.out.println("updated count is >>> "+updateAllwsDelayPrd);
						
						//Added By Haseeb Khan on [29/10/2021] [START]
						insertDCRUnconfLog( salesPers, eventDate, dcrId, unconfBy,"Unconfirm DAR", conn);
						//Added By Haseeb Khan on [29/10/2021] [END]
						//Added by Bhagyashri T on[26/11/21][START][W21HSUN028]
						deleteDCRPlanConf( salesPers, eventDate, dcrId,conn);
						//Added by Bhagyashri T on[26/11/21][END]
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}					
				}
				else
				{
					System.out.println("Before dr_main called");
					updQuery = "UPDATE DR_MAIN SET CONFIRMATION_FLAG = 'N' WHERE SALES_PERS = ? AND WORK_DATE = ? ";
					pstmt = conn.prepareStatement(updQuery);
					pstmt.setString(1,salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));

					int noOfRows = pstmt.executeUpdate();

					System.out.println(noOfRows+" number  of rows updated succesfully in DR_MAIN");
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null ;
					}
					//step 2: get sitecode from employee master..
					String siteCodeQuery = "SELECT EMPLOYEE.EMP_SITE SITE_CODE FROM  EMPLOYEE WHERE EMPLOYEE.EMP_CODE =?";
					pstmtSiteCode = conn.prepareStatement(siteCodeQuery);
					pstmtSiteCode.setString(1,salesPers);
					rsSiteCode = pstmtSiteCode.executeQuery();

					if (rsSiteCode.next())
					{
						siteCode = rsSiteCode.getString("site_code");
					}
					if (rsSiteCode != null)
					{
						rsSiteCode.close();
						rsSiteCode = null ;
					}
					if (pstmtSiteCode != null)
					{
						pstmtSiteCode.close();
						pstmtSiteCode = null ;
					}
					//step 3:get hashmap array object
					String cntSql =  "SELECT COUNT(*) CNT FROM  "+
							"(SELECT SC_CODE , ITEM_CODE, ITEM_QTY AS QUANTITY FROM DR_SAMPLE_DISTRIBUTED "+
							" WHERE SALES_PERS =?  AND WORK_DATE = ? ) SAMP_DIST , ITEM  "+
							" WHERE ITEM.ITEM_CODE = SAMP_DIST.ITEM_CODE";
					pstmt = conn.prepareStatement(cntSql);
					pstmt.setString(1,salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						int size = rs.getInt("CNT");
						parentMap = new HashMap[size];
					}
					//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
					if (rs != null)
					{
						rs.close();
						rs = null ;
					}
					//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null ;
					}

					//step 4: update the issue quantity from sprs_item and stock
					String selSql = "SELECT SAMP_DIST.ITEM_CODE, ITEM.UNIT,SAMP_DIST.SC_CODE,SAMP_DIST.QUANTITY FROM  "+
							"(SELECT SC_CODE , ITEM_CODE, ITEM_QTY AS QUANTITY FROM DR_SAMPLE_DISTRIBUTED "+
							" WHERE SALES_PERS =?  AND WORK_DATE = ? ) SAMP_DIST , ITEM  "+
							" WHERE ITEM.ITEM_CODE = SAMP_DIST.ITEM_CODE";

					pstmt = conn.prepareStatement(selSql);

					pstmt.setString(1,salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					rs = pstmt.executeQuery();
					int index = 0 ;
					while (rs.next())
					{
						itemCode= rs.getString( "ITEM_CODE" );
						scCode= rs.getString( "SC_CODE" );
						itemQtyTot = rs.getInt( "QUANTITY" );
						unit = rs.getString( "UNIT" );
						System.out.println("[item code :"+itemCode+"]--[scCode:"+scCode+"][total:"+itemQtyTot+"][unit:"+unit+"]");
						updQuery= "UPDATE SPRS_ITEM SET QUANTITY = QUANTITY + ?, REPLY_STATUS = '0'  WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
						pstmt1 = conn.prepareStatement(updQuery);
						pstmt1.setInt(1,itemQtyTot);
						pstmt1.setString(2,salesPers);
						pstmt1.setString(3,itemCode);
						result = pstmt1.executeUpdate();
						//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
						if (pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null ;
						}
						//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
						System.out.println(itemCode+"["+result+" rows updated in SPRS_ITEM]");

						updQuery= "UPDATE SPRS_ITEM SET STATUS = (CASE WHEN ((CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) - (CASE WHEN ISSUE_QTY IS NULL THEN 0 ELSE ISSUE_QTY END)) > 0 THEN 'Y' ELSE 'N' END) WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
						pstmt1 = conn.prepareStatement(updQuery);
						pstmt1.setString(1,salesPers);
						pstmt1.setString(2,itemCode);
						result = pstmt1.executeUpdate();
						//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
						if (pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null ;
						}
						//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
						System.out.println(itemCode+"["+result+" rows updated in SPRS_ITEM]");

						parentMap[index] = getDetailHashMap( itemCode, scCode, itemQtyTot, unit, java.sql.Date.valueOf(workDate));

						index++;
					}
					if(rs!=null)
					{
						rs.close();
						rs=null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt=null;
					}
					/*if(pstmt1!=null)
					{
						pstmt1.close();
						pstmt1=null;
					}*/

					if (parentMap.length > 0)
					{
						errString = updateStockEntry.updateSampleStock("w_unconfirm_dar","S-DRCP",xtraParams , salesPers,salesPers,siteCode,siteCode,"","FRSH",parentMap,conn);
						if (errString == null || errString.trim().length() == 0)
						{
							String sundryCode = salesPers;
							System.out.println("Sundry Code from Hashmap@@@"+sundryCode);

							String UpdateSql = "UPDATE SAMPLE_INVTRACE SET DAR_UNCONF_CNT=(CASE WHEN DAR_UNCONF_CNT IS NULL THEN 0 ELSE DAR_UNCONF_CNT END +1) WHERE SUNDRY_CODE = ? AND REF_SER IN ('S-DRCP','S-DISS') AND REF_DATE = ?";				

							System.out.println("sql is "+UpdateSql);
							pstmt = conn.prepareStatement(UpdateSql);

							pstmt.setString(1,sundryCode);
							pstmt.setDate(2,java.sql.Date.valueOf(workDate));
							pstmt.executeUpdate();
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
					}
					
					//Added By Haseeb Khan on [29/10/2021] [START]
					String dcrId="";
					sql = "SELECT SALES_PERS,EVENT_DATE,DAR_UNCONF_CNT,DCR_ID FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE = ?";
					int darunconfcount = 0;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					rs=pstmt.executeQuery();
					if(rs.next()) {
						darunconfcount = rs.getInt("DAR_UNCONF_CNT");
						darunconfcount = darunconfcount+1;
						dcrId = checkNull(rs.getString("DCR_ID"));
						eventDate = rs.getString("EVENT_DATE");
						eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
					}
					
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					//sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE = ?";
					sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N',DAR_UNCONF_CNT = ? WHERE SALES_PERS = ?  AND EVENT_DATE = ?";

					//Added By Haseeb Khan on [29/10/2021] [END];
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setInt(1,darunconfcount);
					pstmt.setString(2, salesPers);
					pstmt.setDate(3,java.sql.Date.valueOf(workDate));
					updateAllwsDelayPrd = pstmt.executeUpdate();
					pstmt.clearParameters();
					System.out.println("updated count is >>> "+updateAllwsDelayPrd);
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE = ?";
					meetPstmt = conn.prepareStatement(updateSql);
					meetPstmt.setString(1, salesPers);
					meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
					updateAllwsDelayPrd = meetPstmt.executeUpdate();
					meetPstmt.clearParameters();
					System.out.println("updated count is >>> "+updateAllwsDelayPrd);
					if(meetPstmt != null)
					{
						meetPstmt.close();
						meetPstmt = null;
					}
					
					//Added By Haseeb Khan on [29/10/2021] [START]
					insertDCRUnconfLog( salesPers, eventDate, dcrId, unconfBy,"Unconfirm DAR" ,conn);
					//Added By Haseeb Khan on [29/10/2021] [END]
					//Added by Bhagyashri T on[26/11/21][START][W21HSUN028]
					deleteDCRPlanConf( salesPers, eventDate, dcrId,conn);
					//Added by Bhagyashri T on[26/11/21][END][W21HSUN028]
				}
				
				// commentted and added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value [end]
			}
		}		
		catch (Exception e)
		{
			e.printStackTrace();
			throw e ;
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(pstmt1!=null)
				{
					pstmt1.close();
					pstmt1=null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				//Added By Bhagyashri T For Closed connection of Live[07/01/22][START]
				if(pstmtDrMain != null)
				{
					pstmtDrMain.close();
					pstmtDrMain = null;
				}
				if(pstmtSiteCode != null)
				{
					pstmtSiteCode.close();
					pstmtSiteCode = null;
				}
				if(pstmtSampleDrCnt != null)
				{
					pstmtSampleDrCnt.close();
					pstmtSampleDrCnt = null;
				}
				if(pstmtSampleDr != null)
				{
					pstmtSampleDr.close();
					pstmtSampleDr = null;
				}
				if(pstmtSampleItem != null)
				{
					pstmtSampleItem.close();
					pstmtSampleItem = null;
				}
				if(pstmtSampleItemUpd != null)
				{
					pstmtSampleItemUpd.close();
					pstmtSampleItemUpd = null;
				}
				if(pstmtInvTrace != null)
				{
					pstmtInvTrace.close();
					pstmtInvTrace = null;
				}
				if(pstmtActTran != null)
				{
					pstmtActTran.close();
					pstmtActTran = null;
				}
				if(meetPstmt != null)
				{
					meetPstmt.close();
					meetPstmt = null;
				}
				
				//Added By Bhagyashri T For Closed connection of Live[07/01/22][END]
			}
			catch (Exception ex)
			{	
				ex.printStackTrace();
			}

		}
		return errString ;
	}
	
	////Added By Haseeb for INSERT LOG on [09-11-2021] START
	public void insertDCRUnconfLog(String salesPers,String eventDate, String dcrId, String unconfBy, String unConfSrc,Connection conn) throws ITMException, Exception 
	{
		PreparedStatement pstmt = null;
		eventDate = genericUtility.getValidDateString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
		//String xtraParams = null;
//		DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
//		java.util.Date date = Calendar.getInstance().getTime();
		//unconf_date = dtFormat.format(date);
		
		SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
		String CurrentDate = sdf.format(new java.util.Date());
		CurrentDate = genericUtility.getValidDateString(CurrentDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());

		try 
		{
			String tranId = generateTranid(conn);

			
			String query = "INSERT INTO DCR_UNCONF_LOG(TRAN_ID,SALES_PERS,TRAN_DATE,EVENT_DATE,DCR_ID,UNCONF_DATE,UNCONF_BY,UNCONF_SOURCE) "
					+ "VALUES(?,?,?,?,?,?,?,?)";
			pstmt = conn.prepareStatement(query);
			pstmt.setString(1, tranId);
			pstmt.setString(2, salesPers);
			pstmt.setDate(3, java.sql.Date.valueOf(CurrentDate)); //tran date
			pstmt.setDate(4, java.sql.Date.valueOf(eventDate));
			pstmt.setString(5, dcrId); //dcr id
			pstmt.setDate(6, java.sql.Date.valueOf(CurrentDate));
			pstmt.setString(7, unconfBy);
			pstmt.setString(8, unConfSrc);
			pstmt.executeUpdate();
			
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
		} 
		catch (Exception e) 
		{
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		}
		finally 
		{
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
		}
	}
	//Added By Haseeb for INSERT LOG on [09-11-2021] END
	
	private String generateTranid( Connection conn ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			//System.out.println("RealTimeReportPos : Generating Primary Key ...........");

			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_dcr_unconf_log' ";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +        "<tran_id></tran_id>";
				xmlValues = xmlValues + "</Detail1></Root>";
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			}
			rs.close();	rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception exp)
		{
			System.out.println("Exception : RealTimeReportPos :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : RealTimeReportPos :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}

	// Modified by Abhishek on [06/12/2011][To put work date as ref_date into HashMap and the same will get updated in sample_invtrace]
	//private HashMap getDetailHashMap( String itemCode, String scCode, int issQty, String unit )
	private HashMap getDetailHashMap( String itemCode, String scCode, int issQty, String unit, java.sql.Date refDate)
			throws Exception
			{
		HashMap hMap = new HashMap();
		try
		{
			hMap.put("tran_id","");
			hMap.put("line_no"," ");
			hMap.put("item_code",itemCode);
			hMap.put("loc_code","FRSH");
			hMap.put("lot_no"," ");
			hMap.put("lot_sl"," ");
			hMap.put("unit",unit);
			hMap.put("qty_iss",(new Integer(issQty).doubleValue()));
			hMap.put("rate",new Double(0.00));
			hMap.put("sundry_code__ref",scCode);
			// Modified by Abhishek on [06/12/2011][to put work date into hash map][Start]
			hMap.put("ref_date",refDate);			

		}
		catch (Exception ex)
		{
			throw ex;
		}			
		return hMap;
			}

	//added by mrunalini sinkar to get sfaparam value on 14-08-2018 as per site code,dividion and all sequence(start)
	public String getSfaParmValue(String userId,String paramName,Connection connectionObject) throws ITMException//Chnaged by sachin satre on 11-nov-16
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String empSite="";
		String itemSer="";
		String paramValue="";
		PreparedStatement allPstmt = null;
		ResultSet allRs = null;
		boolean isLocalConn =false;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of empSite is::........."+empSite);

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(new java.util.Date());
			sysDate  = genericUtility.getValidDateString(sysDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat());

			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME= ? AND ?  BETWEEN EFF_FROM AND VALID_UPTO ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empSite+"_"+itemSer);
			pstmt.setString(2, paramName);
			pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(sysDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				paramValue  = checkNull(rs.getString(1));
			}
			else
			{
				pstmt1 = connectionObject.prepareStatement(sql);
				//pstmt1.setString(1, itemSer);
				pstmt1.setString(1, "X"+"_"+itemSer);// Changed by Sachin Satre on [23-Jan-19]
				pstmt1.setString(2, paramName);
				pstmt1.setTimestamp(3,java.sql.Timestamp.valueOf(sysDate));

				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					paramValue  = checkNull(rs1.getString(1));
				}
				else
				{
					allPstmt = connectionObject.prepareStatement(sql);
					allPstmt.setString(1, "ALL");
					allPstmt.setString(2, paramName);
					allPstmt.setTimestamp(3,java.sql.Timestamp.valueOf(sysDate));
					allRs = allPstmt.executeQuery();
					if(allRs.next())
					{
						paramValue  = checkNull(allRs.getString(1));
					}
				}
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of isPlan is::........."+paramValue);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return paramValue;
	}
	//added by mrunalini sinkar to get sfaparam value as per site code,dividion and all sequence(end)

	//Added By Nilesh Start for check sequentail reporting only when salesperson REP_CONT_CHK_DAYS value is 0 :: 23-04-19
	public int checkSequentialReporting(Connection connectionObject, String salesPers)throws  ITMException
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ;
		int repContChkDays = 0;
		try
		{
			String checkSQL = " SELECT REP_CONT_CHK_DAYS FROM SALES_PERS WHERE SALES_PERS = ? ";
			pstmt = connectionObject.prepareStatement(checkSQL);
			pstmt.setString(1, salesPers);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				repContChkDays = rs.getInt("REP_CONT_CHK_DAYS");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			//System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e);
		}

		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return repContChkDays;
	}
	//Added By Nilesh End for check sequentail reporting only when salesperson REP_CONT_CHK_DAYS value is 0 :: 23-04-19
	
	//Added By Haseeb for unconfirm on [09-11-2021] START
	public String unConfirm( String salesPers, String workDate, String xtraParams, String unConfSrc, Connection conn ) throws ITMException,Exception // Changed by Sachin Satre on [10-Dec-18] for define method for public because same method call from submission when MGR fill feedback for UNCONFIRM_DAR request.
	{
		System.out.println("unConfirm:: called SSS");
		int itemQtyTot = 0;
		int result = 0;

		String itemCode = "";
		String scCode = "";
		String unit = "" ;
		String siteCode= "";
		String updQuery = "";
		String errString = "" ;
		ArrayList mapList = new ArrayList();
		HashMap parentMap[] = null;

		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmtSiteCode = null;
		ResultSet rs = null;
		ResultSet rsSiteCode = null;
		PreparedStatement meetPstmt=null;
		ResultSet meetRs=null;
		String sql="";
		int count=0;
		int updateAllwsDelayPrd=0;
		SampleStockInvtraceUpd updateStockEntry = new SampleStockInvtraceUpd();
		// added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value [start]
		ResultSet rSet = null;
		PreparedStatement pstmtDrMain = null;
		PreparedStatement pstmtSampleDrCnt = null;
		PreparedStatement pstmtSampleDr = null;
		PreparedStatement pstmtSampleItem = null;
		PreparedStatement pstmtSampleItemUpd = null;
		PreparedStatement pstmtInvTrace = null;
		PreparedStatement pstmtActTran = null;
		// and added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value [end]
		
		String eventDate = null;
		String unconfBy = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
//		DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
//		java.util.Date date = Calendar.getInstance().getTime();
//		String unconf_date = dtFormat.format(date);


		try
		{ 
			String sampleAllow = getSfaParmValue(salesPers,"SAMPLE_ALLOW",conn); // added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value
			String darVersion = getSfaParmValue(salesPers,"DAR_VERSION",conn);
			if(darVersion.equalsIgnoreCase("WSFA"))
			{
				// commentted and added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value [start]
				/*sql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, salesPers);
				pstmt.setDate(2,java.sql.Date.valueOf(workDate));
				rs=pstmt.executeQuery();
				if(rs.next())
				{
					count=rs.getInt("COUNT");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( count > 0 )
				{

					sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE >= ?";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					updateAllwsDelayPrd = pstmt.executeUpdate();
					pstmt.clearParameters();
					System.out.println("updated count is >>> "+updateAllwsDelayPrd);
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}

				String countSql="SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ";
				meetPstmt=conn.prepareStatement(countSql);
				meetPstmt.setString(1, salesPers);
				meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
				meetRs=meetPstmt.executeQuery();
				if(meetRs.next())
				{
					count = meetRs.getInt("COUNT");
				}
				if(meetRs != null)
				{
					meetRs.close();
					meetRs = null;
				}
				if(meetPstmt != null)
				{
					meetPstmt.close();
					meetPstmt = null;
				}
				if(count > 0)
				{
					//String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS IN("+empCode+") AND EVENT_DATE >= ?";
					String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE >= ?";
					meetPstmt = conn.prepareStatement(updateSql);
					meetPstmt.setString(1, salesPers);
					meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
					updateAllwsDelayPrd = meetPstmt.executeUpdate();
					meetPstmt.clearParameters();
					System.out.println("updated count is >>> "+updateAllwsDelayPrd);
					if(meetPstmt != null)
					{
						meetPstmt.close();
						meetPstmt = null;
					}
				}*/

				if(sampleAllow.equalsIgnoreCase("E") || sampleAllow.equalsIgnoreCase("C"))
				{
					//sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE = ?";
					sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N',DAR_UNCONF_CNT = ? WHERE SALES_PERS = ?  AND EVENT_DATE = ?";
					pstmtActTran = conn.prepareStatement(sql);

					String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE = ?";
					meetPstmt = conn.prepareStatement(updateSql);

					//sql = "SELECT SALES_PERS,EVENT_DATE FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ORDER BY EVENT_DATE";
					sql = "SELECT SALES_PERS,EVENT_DATE,DAR_UNCONF_CNT,DCR_ID FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ORDER BY EVENT_DATE";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					rs=pstmt.executeQuery();
					while(rs.next())
					{
						eventDate = rs.getString("EVENT_DATE");
						int darunconfcount = rs.getInt("DAR_UNCONF_CNT");
						darunconfcount = darunconfcount+1;
						System.out.println("UNCONF-COUNT >>>> "+darunconfcount);
						String dcrId = checkNull(rs.getString("DCR_ID"));
						eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
						workDate = genericUtility.getValidDateString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
						System.out.println("Before dr_main called");

						pstmtActTran.setInt(1, darunconfcount);
						pstmtActTran.setString(2, salesPers);
						pstmtActTran.setDate(3,java.sql.Date.valueOf(workDate));
						updateAllwsDelayPrd = pstmtActTran.executeUpdate();
						pstmtActTran.clearParameters();
						System.out.println("updated count is >>> "+updateAllwsDelayPrd);

						meetPstmt.setString(1, salesPers);
						meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
						updateAllwsDelayPrd = meetPstmt.executeUpdate();
						meetPstmt.clearParameters();
						System.out.println("updated count is >>> "+updateAllwsDelayPrd);
						
						//TODO: Insert Method
						insertDCRUnconfLog( salesPers, eventDate, dcrId, unconfBy,unConfSrc, conn);
						//Added by Bhagyashri T on[26/11/21][START][W21HSUN028]
						deleteDCRPlanConf( salesPers, eventDate, dcrId,conn);
						//Added by Bhagyashri T on[26/11/21][END]
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					//TODO: Insert Method
					//insertDCRUnconfLog(tran_id, salesPers, eventDate, eventDate, dcr_id, unconf_date, unconf_by, "Unconfirmed DAR", "Test", xtraParams, conn);
				}
				else
				{
					//Added By Haseeb Khan on [29/10/2021] [START]
					String dcrId="";
					sql = "SELECT SALES_PERS,EVENT_DATE,DAR_UNCONF_CNT,DCR_ID FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE = ?";
					int darunconfcount = 0;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					rs=pstmt.executeQuery();
					if(rs.next()) {
						darunconfcount = rs.getInt("DAR_UNCONF_CNT");
						darunconfcount = darunconfcount+1;
						dcrId = checkNull(rs.getString("DCR_ID"));
						eventDate = rs.getString("EVENT_DATE");
						eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
					}
					
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					//sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE = ?";
					sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N',DAR_UNCONF_CNT = ? WHERE SALES_PERS = ?  AND EVENT_DATE = ?";

					//Added By Haseeb Khan on [29/10/2021] [END];
					pstmt = conn.prepareStatement(sql);
					pstmt.setInt(1, darunconfcount);
					pstmt.setString(2, salesPers);
					pstmt.setDate(3,java.sql.Date.valueOf(workDate));
					updateAllwsDelayPrd = pstmt.executeUpdate();
					pstmt.clearParameters();
					System.out.println("updated count is >>> "+updateAllwsDelayPrd);
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE = ?";
					meetPstmt = conn.prepareStatement(updateSql);
					meetPstmt.setString(1, salesPers);
					meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
					updateAllwsDelayPrd = meetPstmt.executeUpdate();
					meetPstmt.clearParameters();
					System.out.println("updated count is >>> "+updateAllwsDelayPrd);
					if(meetPstmt != null)
					{
						meetPstmt.close();
						meetPstmt = null;
					}
					
					//TODO: Insert Method
					insertDCRUnconfLog(salesPers, eventDate, dcrId, unconfBy,unConfSrc, conn);
					//Added by Bhagyashri T on[26/11/21][START][W21HSUN028]
					deleteDCRPlanConf( salesPers, eventDate, dcrId,conn);
					//Added by Bhagyashri T on[26/11/21][END]
					
				}
				
				// commentted and added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value [end]
			}
			else if( !darVersion.equalsIgnoreCase("WSFA") || darVersion.equalsIgnoreCase("BOTH"))
			{	
				// commentted and added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value [start]
				/*System.out.println("Before dr_main called");
				//step 1: set confim flag to 'N' in DR_MAIN	
				updQuery = "UPDATE DR_MAIN SET CONFIRMATION_FLAG = 'N' WHERE SALES_PERS = ? AND WORK_DATE = ? ";
				pstmt = conn.prepareStatement(updQuery);
				pstmt.setString(1,salesPers);
				pstmt.setDate(2,java.sql.Date.valueOf(workDate));

				int noOfRows = pstmt.executeUpdate();

				System.out.println(noOfRows+" number  of rows updated succesfully in DR_MAIN");
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null ;
				}
				//step 2: get sitecode from employee master..
				String siteCodeQuery = "SELECT EMPLOYEE.EMP_SITE SITE_CODE FROM  EMPLOYEE WHERE EMPLOYEE.EMP_CODE =?";
				pstmtSiteCode = conn.prepareStatement(siteCodeQuery);
				pstmtSiteCode.setString(1,salesPers);
				rsSiteCode = pstmtSiteCode.executeQuery();

				if (rsSiteCode.next())
				{
					siteCode = rsSiteCode.getString("site_code");
				}
				if (rsSiteCode != null)
				{
					rsSiteCode.close();
					rsSiteCode = null ;
				}
				if (pstmtSiteCode != null)
				{
					pstmtSiteCode.close();
					pstmtSiteCode = null ;
				}
				//step 3:get hashmap array object
				String cntSql =  "SELECT COUNT(*) CNT FROM  "+
								"(SELECT SC_CODE , ITEM_CODE, ITEM_QTY AS QUANTITY FROM DR_SAMPLE_DISTRIBUTED "+
								" WHERE SALES_PERS =?  AND WORK_DATE = ? ) SAMP_DIST , ITEM  "+
								" WHERE ITEM.ITEM_CODE = SAMP_DIST.ITEM_CODE";
				pstmt = conn.prepareStatement(cntSql);
				pstmt.setString(1,salesPers);
				pstmt.setDate(2,java.sql.Date.valueOf(workDate));
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					int size = rs.getInt("CNT");
					parentMap = new HashMap[size];
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null ;
				}

				//step 4: update the issue quantity from sprs_item and stock
				String selSql = "SELECT SAMP_DIST.ITEM_CODE, ITEM.UNIT,SAMP_DIST.SC_CODE,SAMP_DIST.QUANTITY FROM  "+
								"(SELECT SC_CODE , ITEM_CODE, ITEM_QTY AS QUANTITY FROM DR_SAMPLE_DISTRIBUTED "+
								" WHERE SALES_PERS =?  AND WORK_DATE = ? ) SAMP_DIST , ITEM  "+
								" WHERE ITEM.ITEM_CODE = SAMP_DIST.ITEM_CODE";



				pstmt = conn.prepareStatement(selSql);

				pstmt.setString(1,salesPers);
				pstmt.setDate(2,java.sql.Date.valueOf(workDate));
				rs = pstmt.executeQuery();
				int index = 0 ;
				while (rs.next())
				{
					itemCode= rs.getString( "ITEM_CODE" );
					scCode= rs.getString( "SC_CODE" );
					itemQtyTot = rs.getInt( "QUANTITY" );
					unit = rs.getString( "UNIT" );
					System.out.println("[item code :"+itemCode+"]--[scCode:"+scCode+"][total:"+itemQtyTot+"][unit:"+unit+"]");
					//Changed by Pawan on 17/12/10 [WS90SUN048] to fix the bug of status update.start
					updQuery= "UPDATE SPRS_ITEM SET QUANTITY = QUANTITY + ?  , STATUS = (CASE WHEN ((CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) - (CASE WHEN ISSUE_QTY IS NULL THEN 0 ELSE ISSUE_QTY END)) > 0 THEN 'Y' ELSE 'N' END) , REPLY_STATUS = '0'  WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
					pstmt1 = conn.prepareStatement(updQuery);
					pstmt1.setInt(1,itemQtyTot);
					pstmt1.setString(2,salesPers);
					pstmt1.setString(3,itemCode);
					result = pstmt1.executeUpdate();
					updQuery= "UPDATE SPRS_ITEM SET QUANTITY = QUANTITY + ?, REPLY_STATUS = '0'  WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
					pstmt1 = conn.prepareStatement(updQuery);
					pstmt1.setInt(1,itemQtyTot);
					pstmt1.setString(2,salesPers);
					pstmt1.setString(3,itemCode);
					result = pstmt1.executeUpdate();
					System.out.println(itemCode+"["+result+" rows updated in SPRS_ITEM]");

					updQuery= "UPDATE SPRS_ITEM SET STATUS = (CASE WHEN ((CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) - (CASE WHEN ISSUE_QTY IS NULL THEN 0 ELSE ISSUE_QTY END)) > 0 THEN 'Y' ELSE 'N' END) WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
					pstmt1 = conn.prepareStatement(updQuery);
					pstmt1.setString(1,salesPers);
					pstmt1.setString(2,itemCode);
					result = pstmt1.executeUpdate();
					//Changed by Pawan on 17/12/10 [WS90SUN048] to fix the bug of status update.end

					System.out.println(itemCode+"["+result+" rows updated in SPRS_ITEM]");

					// Modified by Abhishek on [06/12/2011][To put work date as ref_date into HashMap and the same will get updated in sample_invtrace]
					//parentMap[index] = getDetailHashMap( itemCode, scCode, itemQtyTot, unit ); 
					parentMap[index] = getDetailHashMap( itemCode, scCode, itemQtyTot, unit, java.sql.Date.valueOf(workDate));

					index++;
			    }
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}

				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(pstmt1!=null)
				{
					pstmt1.close();
					pstmt1=null;
				}

				if (parentMap.length > 0)
				{

					errString = updateStockEntry.updateSampleStock("w_unconfirm_dar","S-DRCP",xtraParams , salesPers,salesPers,siteCode,siteCode,"","FRSH",parentMap,conn);
					//Modified by Abhishek on [26/04/2012][To update unconfirm count so that the report can be re-confirmed without error of duplicate records][Start]
					if (errString == null || errString.trim().length() == 0)
					{

						String sundryCode = salesPers;
						System.out.println("Sundry Code from Hashmap@@@"+sundryCode);

						String UpdateSql = "UPDATE SAMPLE_INVTRACE SET DAR_UNCONF_CNT=(CASE WHEN DAR_UNCONF_CNT IS NULL THEN 0 ELSE DAR_UNCONF_CNT END +1) WHERE SUNDRY_CODE = ? AND REF_SER IN ('S-DRCP','S-DISS') AND REF_DATE = ?";				

						System.out.println("sql is "+UpdateSql);
						pstmt = conn.prepareStatement(UpdateSql);

						pstmt.setString(1,sundryCode);
						pstmt.setDate(2,java.sql.Date.valueOf(workDate));
						pstmt.executeUpdate();
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}

					}
					//Modified by Abhishek on [26/04/2012][To update unconfirm count so that the report can be re-confirmed without error of duplicate records][End]
				}
				//Added By Nilesh Start :: 26-03-19
					String parmValue = getSfaParmValue(salesPers,"SEQUENTIAL_DAR",conn); // added by mrunalini sinkar on 21-Feb-2018(start)
					if(parmValue.equalsIgnoreCase("Y"))
					{
						int seqCount = checkSequentialReporting(conn, salesPers );

						if( seqCount == 0)
						{
							sql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, salesPers);
							pstmt.setDate(2,java.sql.Date.valueOf(workDate));
							rs=pstmt.executeQuery();
							if(rs.next())
							{
								count=rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}

							if( count > 0 )
							{

								sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE >= ?";

								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, salesPers);
								pstmt.setDate(2,java.sql.Date.valueOf(workDate));
								updateAllwsDelayPrd = pstmt.executeUpdate();
								pstmt.clearParameters();
								System.out.println("updated count is >>> "+updateAllwsDelayPrd);
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							}

							String countSql="SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ";
							meetPstmt=conn.prepareStatement(countSql);
							meetPstmt.setString(1, salesPers);
							meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
							meetRs=meetPstmt.executeQuery();
							if(meetRs.next())
							{
								count = meetRs.getInt("COUNT");
							}
							if(meetRs != null)
							{
								meetRs.close();
								meetRs = null;
							}
							if(meetPstmt != null)
							{
								meetPstmt.close();
								meetPstmt = null;
							}
							if(count > 0)
							{
								//String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS IN("+empCode+") AND EVENT_DATE >= ?";
								String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE >= ?";
								meetPstmt = conn.prepareStatement(updateSql);
								meetPstmt.setString(1, salesPers);
								meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
								updateAllwsDelayPrd = meetPstmt.executeUpdate();
								meetPstmt.clearParameters();
								System.out.println("updated count is >>> "+updateAllwsDelayPrd);
								if(meetPstmt != null)
								{
									meetPstmt.close();
									meetPstmt = null;
								}
							}
						}
						else
						{

							System.out.println("Not Sequnetional ****");
							sql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, salesPers);
							pstmt.setDate(2,java.sql.Date.valueOf(workDate));
							rs=pstmt.executeQuery();
							if(rs.next())
							{
								count=rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}

							if( count > 0 )
							{

								sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE = ?";

								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, salesPers);
								pstmt.setDate(2,java.sql.Date.valueOf(workDate));
								updateAllwsDelayPrd = pstmt.executeUpdate();
								pstmt.clearParameters();
								System.out.println("updated count is >>> "+updateAllwsDelayPrd);
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							}

							String countSql="SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE = ? ";
							meetPstmt=conn.prepareStatement(countSql);
							meetPstmt.setString(1, salesPers);
							meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
							meetRs=meetPstmt.executeQuery();
							if(meetRs.next())
							{
								count = meetRs.getInt("COUNT");
							}
							if(meetRs != null)
							{
								meetRs.close();
								meetRs = null;
							}
							if(meetPstmt != null)
							{
								meetPstmt.close();
								meetPstmt = null;
							}
							if(count > 0)
							{
								//String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS IN("+empCode+") AND EVENT_DATE >= ?";
								String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE = ?";
								meetPstmt = conn.prepareStatement(updateSql);
								meetPstmt.setString(1, salesPers);
								meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
								updateAllwsDelayPrd = meetPstmt.executeUpdate();
								meetPstmt.clearParameters();
								System.out.println("updated count is >>> "+updateAllwsDelayPrd);
								if(meetPstmt != null)
								{
									meetPstmt.close();
									meetPstmt = null;
								}
							}

						}
					}*/

				//Added By Nilesh End :: 26-03-19

				if(sampleAllow.equalsIgnoreCase("E") || sampleAllow.equalsIgnoreCase("C"))
				{
					updQuery = "UPDATE DR_MAIN SET CONFIRMATION_FLAG = 'N' WHERE SALES_PERS = ? AND WORK_DATE = ? ";
					pstmtDrMain = conn.prepareStatement(updQuery);

					String siteCodeQuery = "SELECT EMPLOYEE.EMP_SITE SITE_CODE FROM  EMPLOYEE WHERE EMPLOYEE.EMP_CODE =?";
					pstmtSiteCode = conn.prepareStatement(siteCodeQuery);

					String cntSql =  "SELECT COUNT(*) CNT FROM  "+
							"(SELECT SC_CODE , ITEM_CODE, ITEM_QTY AS QUANTITY FROM DR_SAMPLE_DISTRIBUTED "+
							" WHERE SALES_PERS =?  AND WORK_DATE = ? ) SAMP_DIST , ITEM  "+
							" WHERE ITEM.ITEM_CODE = SAMP_DIST.ITEM_CODE";
					pstmtSampleDrCnt = conn.prepareStatement(cntSql);

					String selSql = "SELECT SAMP_DIST.ITEM_CODE, ITEM.UNIT,SAMP_DIST.SC_CODE,SAMP_DIST.QUANTITY FROM  "+
							"(SELECT SC_CODE , ITEM_CODE, ITEM_QTY AS QUANTITY FROM DR_SAMPLE_DISTRIBUTED "+
							" WHERE SALES_PERS =?  AND WORK_DATE = ? ) SAMP_DIST , ITEM  "+
							" WHERE ITEM.ITEM_CODE = SAMP_DIST.ITEM_CODE";
					pstmtSampleDr = conn.prepareStatement(selSql);

					updQuery= "UPDATE SPRS_ITEM SET QUANTITY = QUANTITY + ?, REPLY_STATUS = '0'  WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
					pstmtSampleItem = conn.prepareStatement(updQuery);

					updQuery= "UPDATE SPRS_ITEM SET STATUS = (CASE WHEN ((CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) - (CASE WHEN ISSUE_QTY IS NULL THEN 0 ELSE ISSUE_QTY END)) > 0 THEN 'Y' ELSE 'N' END) WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
					pstmtSampleItemUpd = conn.prepareStatement(updQuery);

					String UpdateSql = "UPDATE SAMPLE_INVTRACE SET DAR_UNCONF_CNT=(CASE WHEN DAR_UNCONF_CNT IS NULL THEN 0 ELSE DAR_UNCONF_CNT END +1) WHERE SUNDRY_CODE = ? AND REF_SER IN ('S-DRCP','S-DISS') AND REF_DATE = ?";				
					pstmtInvTrace = conn.prepareStatement(UpdateSql);

					//sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE = ?";
					sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N',DAR_UNCONF_CNT = ? WHERE SALES_PERS = ?  AND EVENT_DATE = ?";
					pstmtActTran = conn.prepareStatement(sql);

					String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE = ?";
					meetPstmt = conn.prepareStatement(updateSql);

					//sql = "SELECT SALES_PERS,EVENT_DATE,DAR_UNCONF_CNT,DCR_ID FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ORDER BY EVENT_DATE";
					sql = "SELECT SALES_PERS,EVENT_DATE,DAR_UNCONF_CNT,DCR_ID FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE = ? ORDER BY EVENT_DATE";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					rs=pstmt.executeQuery();
					if(rs.next())
					{
						//String eventDate
						eventDate = rs.getString("EVENT_DATE");
						int darunconfcount = rs.getInt("DAR_UNCONF_CNT");
						darunconfcount = darunconfcount+1;
						System.out.println("UNCONF-COUNT >>>> "+darunconfcount);
						String dcrId = checkNull(rs.getString("DCR_ID"));
						eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
						workDate = genericUtility.getValidDateString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
						System.out.println("Before dr_main called");

						pstmtDrMain.setString(1,salesPers);
						pstmtDrMain.setDate(2,java.sql.Date.valueOf(workDate));

						int noOfRows = pstmtDrMain.executeUpdate();
						pstmtDrMain.clearParameters();

						System.out.println(noOfRows+" number  of rows updated succesfully in DR_MAIN");

						pstmtSiteCode.setString(1,salesPers);
						rsSiteCode = pstmtSiteCode.executeQuery();

						if (rsSiteCode.next())
						{
							siteCode = rsSiteCode.getString("site_code");
						}
						pstmtSiteCode.clearParameters();
						if (rsSiteCode != null)
						{
							rsSiteCode.close();
							rsSiteCode = null ;
						}

						pstmtSampleDrCnt.setString(1,salesPers);
						pstmtSampleDrCnt.setDate(2,java.sql.Date.valueOf(workDate));
						rSet = pstmtSampleDrCnt.executeQuery();
						if (rSet.next())
						{
							int size = rSet.getInt("CNT");
							parentMap = new HashMap[size];
						}
						pstmtSampleDrCnt.clearParameters();
						if (rSet != null)
						{
							rSet.close();
							rSet = null ;
						}

						pstmtSampleDr.setString(1,salesPers);
						pstmtSampleDr.setDate(2,java.sql.Date.valueOf(workDate));
						rSet = pstmtSampleDr.executeQuery();
						int index = 0 ;
						while (rSet.next())
						{
							itemCode= rSet.getString( "ITEM_CODE" );
							scCode= rSet.getString( "SC_CODE" );
							itemQtyTot = rSet.getInt( "QUANTITY" );
							unit = rSet.getString( "UNIT" );
							System.out.println("[item code :"+itemCode+"]--[scCode:"+scCode+"][total:"+itemQtyTot+"][unit:"+unit+"]");
							pstmtSampleDrCnt.clearParameters();

							pstmtSampleItem.setInt(1,itemQtyTot);
							pstmtSampleItem.setString(2,salesPers);
							pstmtSampleItem.setString(3,itemCode);
							result = pstmtSampleItem.executeUpdate();
							System.out.println(itemCode+"["+result+" rows updated in SPRS_ITEM]");
							pstmtSampleItem.clearParameters();

							pstmtSampleItemUpd.setString(1,salesPers);
							pstmtSampleItemUpd.setString(2,itemCode);
							result = pstmtSampleItemUpd.executeUpdate();
							System.out.println(itemCode+"["+result+" rows updated in SPRS_ITEM]");
							pstmtSampleItemUpd.clearParameters();
							parentMap[index] = getDetailHashMap( itemCode, scCode, itemQtyTot, unit, java.sql.Date.valueOf(workDate));

							index++;
						}
						if(rSet!=null)
						{
							rSet.close();
							rSet=null;
						}

						if (parentMap.length > 0)
						{
							errString = updateStockEntry.updateSampleStock("w_unconfirm_dar","S-DRCP",xtraParams , salesPers,salesPers,siteCode,siteCode,"","FRSH",parentMap,conn);
							if (errString == null || errString.trim().length() == 0)
							{
								String sundryCode = salesPers;
								System.out.println("Sundry Code from Hashmap@@@"+sundryCode);

								pstmtInvTrace.setString(1,sundryCode);
								pstmtInvTrace.setDate(2,java.sql.Date.valueOf(workDate));
								pstmtInvTrace.executeUpdate();
								pstmtInvTrace.clearParameters();
							}
						}

						pstmtActTran.setInt(1, darunconfcount);
						pstmtActTran.setString(2, salesPers);
						pstmtActTran.setDate(3,java.sql.Date.valueOf(workDate));
						updateAllwsDelayPrd = pstmtActTran.executeUpdate();
						pstmtActTran.clearParameters();
						if(pstmtActTran != null)
						{
							pstmtActTran.close();
							pstmtActTran = null;
						}
						System.out.println("updated count is >>> "+updateAllwsDelayPrd);

						meetPstmt.setString(1, salesPers);
						meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
						updateAllwsDelayPrd = meetPstmt.executeUpdate();
						meetPstmt.clearParameters();
						System.out.println("updated count is >>> "+updateAllwsDelayPrd);
						if(meetPstmt != null)
						{
							meetPstmt.close();
							meetPstmt = null;
						}
						//TODO: Insert Method
						insertDCRUnconfLog( salesPers, eventDate, dcrId, unconfBy,unConfSrc, conn);
						//Added by Bhagyashri T on[26/11/21][START][W21HSUN028]
						deleteDCRPlanConf( salesPers, eventDate, dcrId,conn);
						//Added by Bhagyashri T on[26/11/21][END]
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					//Added By Bhagyashri T For Closed connection of Live[07/01/22][START]
					if(pstmtDrMain != null)
					{
						pstmtDrMain.close();
						pstmtDrMain = null;
					}
					if(pstmtSiteCode != null)
					{
						pstmtSiteCode.close();
						pstmtSiteCode = null;
					}
					if(pstmtSampleDrCnt != null)
					{
						pstmtSampleDrCnt.close();
						pstmtSampleDrCnt = null;
					}
					if(pstmtSampleDr != null)
					{
						pstmtSampleDr.close();
						pstmtSampleDr = null;
					}
					if(pstmtSampleItem != null)
					{
						pstmtSampleItem.close();
						pstmtSampleItem = null;
					}
					if(pstmtSampleItemUpd != null)
					{
						pstmtSampleItemUpd.close();
						pstmtSampleItemUpd = null;
					}
					if(pstmtInvTrace != null)
					{
						pstmtInvTrace.close();
						pstmtInvTrace = null;
					}
					if(pstmtActTran != null)
					{
						pstmtActTran.close();
						pstmtActTran = null;
					}
					if(meetPstmt != null)
					{
						meetPstmt.close();
						meetPstmt = null;
					}
					
					//Added By Bhagyashri T For Closed connection of Live[07/01/22][END]
					
				}
				else
				{
					System.out.println("Before dr_main called");
					updQuery = "UPDATE DR_MAIN SET CONFIRMATION_FLAG = 'N' WHERE SALES_PERS = ? AND WORK_DATE = ? ";
					pstmt = conn.prepareStatement(updQuery);
					pstmt.setString(1,salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));

					int noOfRows = pstmt.executeUpdate();

					System.out.println(noOfRows+" number  of rows updated succesfully in DR_MAIN");
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null ;
					}
					//step 2: get sitecode from employee master..
					String siteCodeQuery = "SELECT EMPLOYEE.EMP_SITE SITE_CODE FROM  EMPLOYEE WHERE EMPLOYEE.EMP_CODE =?";
					pstmtSiteCode = conn.prepareStatement(siteCodeQuery);
					pstmtSiteCode.setString(1,salesPers);
					rsSiteCode = pstmtSiteCode.executeQuery();

					if (rsSiteCode.next())
					{
						siteCode = rsSiteCode.getString("site_code");
					}
					if (rsSiteCode != null)
					{
						rsSiteCode.close();
						rsSiteCode = null ;
					}
					if (pstmtSiteCode != null)
					{
						pstmtSiteCode.close();
						pstmtSiteCode = null ;
					}
					//step 3:get hashmap array object
					String cntSql =  "SELECT COUNT(*) CNT FROM  "+
							"(SELECT SC_CODE , ITEM_CODE, ITEM_QTY AS QUANTITY FROM DR_SAMPLE_DISTRIBUTED "+
							" WHERE SALES_PERS =?  AND WORK_DATE = ? ) SAMP_DIST , ITEM  "+
							" WHERE ITEM.ITEM_CODE = SAMP_DIST.ITEM_CODE";
					pstmt = conn.prepareStatement(cntSql);
					pstmt.setString(1,salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						int size = rs.getInt("CNT");
						parentMap = new HashMap[size];
					}
					//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
					if (rs != null)
					{
						rs.close();
						rs = null ;
					}
					//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null ;
					}

					//step 4: update the issue quantity from sprs_item and stock
					String selSql = "SELECT SAMP_DIST.ITEM_CODE, ITEM.UNIT,SAMP_DIST.SC_CODE,SAMP_DIST.QUANTITY FROM  "+
							"(SELECT SC_CODE , ITEM_CODE, ITEM_QTY AS QUANTITY FROM DR_SAMPLE_DISTRIBUTED "+
							" WHERE SALES_PERS =?  AND WORK_DATE = ? ) SAMP_DIST , ITEM  "+
							" WHERE ITEM.ITEM_CODE = SAMP_DIST.ITEM_CODE";

					pstmt = conn.prepareStatement(selSql);

					pstmt.setString(1,salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					rs = pstmt.executeQuery();
					int index = 0 ;
					while (rs.next())
					{
						itemCode= rs.getString( "ITEM_CODE" );
						scCode= rs.getString( "SC_CODE" );
						itemQtyTot = rs.getInt( "QUANTITY" );
						unit = rs.getString( "UNIT" );
						System.out.println("[item code :"+itemCode+"]--[scCode:"+scCode+"][total:"+itemQtyTot+"][unit:"+unit+"]");
						updQuery= "UPDATE SPRS_ITEM SET QUANTITY = QUANTITY + ?, REPLY_STATUS = '0'  WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
						pstmt1 = conn.prepareStatement(updQuery);
						pstmt1.setInt(1,itemQtyTot);
						pstmt1.setString(2,salesPers);
						pstmt1.setString(3,itemCode);
						result = pstmt1.executeUpdate();
						//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
						if (pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null ;
						}
						//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
						System.out.println(itemCode+"["+result+" rows updated in SPRS_ITEM]");

						updQuery= "UPDATE SPRS_ITEM SET STATUS = (CASE WHEN ((CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) - (CASE WHEN ISSUE_QTY IS NULL THEN 0 ELSE ISSUE_QTY END)) > 0 THEN 'Y' ELSE 'N' END) WHERE SALES_PERS = ?  AND ITEM_CODE = ?";
						pstmt1 = conn.prepareStatement(updQuery);
						pstmt1.setString(1,salesPers);
						pstmt1.setString(2,itemCode);
						result = pstmt1.executeUpdate();
						//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
						if (pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null ;
						}
						//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
						System.out.println(itemCode+"["+result+" rows updated in SPRS_ITEM]");

						parentMap[index] = getDetailHashMap( itemCode, scCode, itemQtyTot, unit, java.sql.Date.valueOf(workDate));

						index++;
					}
					if(rs!=null)
					{
						rs.close();
						rs=null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt=null;
					}
					/*if(pstmt1!=null)
					{
						pstmt1.close();
						pstmt1=null;
					}*/

					if (parentMap.length > 0)
					{
						errString = updateStockEntry.updateSampleStock("w_unconfirm_dar","S-DRCP",xtraParams , salesPers,salesPers,siteCode,siteCode,"","FRSH",parentMap,conn);
						if (errString == null || errString.trim().length() == 0)
						{
							String sundryCode = salesPers;
							System.out.println("Sundry Code from Hashmap@@@"+sundryCode);

							String UpdateSql = "UPDATE SAMPLE_INVTRACE SET DAR_UNCONF_CNT=(CASE WHEN DAR_UNCONF_CNT IS NULL THEN 0 ELSE DAR_UNCONF_CNT END +1) WHERE SUNDRY_CODE = ? AND REF_SER IN ('S-DRCP','S-DISS') AND REF_DATE = ?";				

							System.out.println("sql is "+UpdateSql);
							pstmt = conn.prepareStatement(UpdateSql);

							pstmt.setString(1,sundryCode);
							pstmt.setDate(2,java.sql.Date.valueOf(workDate));
							pstmt.executeUpdate();
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
					}
					
					//Added By Haseeb Khan on [29/10/2021] [START]
					String dcrId="";
					sql = "SELECT SALES_PERS,EVENT_DATE,DAR_UNCONF_CNT,DCR_ID FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE = ?";
					int darunconfcount = 0;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					pstmt.setDate(2,java.sql.Date.valueOf(workDate));
					rs=pstmt.executeQuery();
					if(rs.next()) {
						darunconfcount = rs.getInt("DAR_UNCONF_CNT");
						darunconfcount = darunconfcount+1;
						dcrId = checkNull(rs.getString("DCR_ID"));
						eventDate = rs.getString("EVENT_DATE");
						eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
					}
					
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					//sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N' WHERE SALES_PERS = ?  AND EVENT_DATE = ?";
					sql="UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'N',DAR_UNCONF_CNT = ? WHERE SALES_PERS = ?  AND EVENT_DATE = ?";

					//Added By Haseeb Khan on [29/10/2021] [END];
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setInt(1,darunconfcount);
					pstmt.setString(2, salesPers);
					pstmt.setDate(3,java.sql.Date.valueOf(workDate));
					updateAllwsDelayPrd = pstmt.executeUpdate();
					pstmt.clearParameters();
					System.out.println("updated count is >>> "+updateAllwsDelayPrd);
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					String updateSql="UPDATE STRG_MEET SET CONFIRMED='N' WHERE SALES_PERS = ? AND EVENT_DATE = ?";
					meetPstmt = conn.prepareStatement(updateSql);
					meetPstmt.setString(1, salesPers);
					meetPstmt.setDate(2,java.sql.Date.valueOf(workDate));
					updateAllwsDelayPrd = meetPstmt.executeUpdate();
					meetPstmt.clearParameters();
					System.out.println("updated count is >>> "+updateAllwsDelayPrd);
					if(meetPstmt != null)
					{
						meetPstmt.close();
						meetPstmt = null;
					}
					
					//TODO: Insert Method
					insertDCRUnconfLog( salesPers, eventDate, dcrId, unconfBy,unConfSrc, conn);
					//Added by Bhagyashri T on[26/11/21][START][W21HSUN028]
					deleteDCRPlanConf( salesPers, eventDate, dcrId,conn);
					//Added by Bhagyashri T on[26/11/21][END]
				}
				
				// commentted and added by rupali on 28/06/19 for updating dates on basis of sample allow sfa parm value [end]
			}
		}		
		catch (Exception e)
		{
			e.printStackTrace();
			throw e ;
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(pstmt1!=null)
				{
					pstmt1.close();
					pstmt1=null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				//Added By Bhagyashri T For Closed connection of Live[07/01/22][START]
				if(pstmtDrMain != null)
				{
					pstmtDrMain.close();
					pstmtDrMain = null;
				}
				if(pstmtSiteCode != null)
				{
					pstmtSiteCode.close();
					pstmtSiteCode = null;
				}
				if(pstmtSampleDrCnt != null)
				{
					pstmtSampleDrCnt.close();
					pstmtSampleDrCnt = null;
				}
				if(pstmtSampleDr != null)
				{
					pstmtSampleDr.close();
					pstmtSampleDr = null;
				}
				if(pstmtSampleItem != null)
				{
					pstmtSampleItem.close();
					pstmtSampleItem = null;
				}
				if(pstmtSampleItemUpd != null)
				{
					pstmtSampleItemUpd.close();
					pstmtSampleItemUpd = null;
				}
				if(pstmtInvTrace != null)
				{
					pstmtInvTrace.close();
					pstmtInvTrace = null;
				}
				if(pstmtActTran != null)
				{
					pstmtActTran.close();
					pstmtActTran = null;
				}
				if(meetPstmt != null)
				{
					meetPstmt.close();
					meetPstmt = null;
				}
				
				//Added By Bhagyashri T For Closed connection of Live[07/01/22][END]
			}
			catch (Exception ex)
			{	
				ex.printStackTrace();
			}

		}
		return errString ;
	}
	//Added By Haseeb for unconfirm on [09-11-2021] END
	//Added by Bhagyashri T on[26/11/21][START][W21HSUN028]
	public void deleteDCRPlanConf(String salesPers, String eventDate,String dcrId,Connection conn)throws RemoteException, Exception
	{
		//System.out.println("inside deleteDCRPlanConf");
		PreparedStatement pstmt = null;
		eventDate = genericUtility.getValidDateString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
		SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
		int recordsDeleted = 0;
		try 
		{
			String deleteconf = "DELETE FROM SPRS_PLAN_COMPL WHERE SALES_PERS=? AND WORK_DATE=? AND DCR_ID=? ";
			pstmt = conn.prepareStatement(deleteconf);
			pstmt.setString(1, salesPers);
			pstmt.setDate(2, java.sql.Date.valueOf(eventDate));
			pstmt.setString(3, dcrId);
			recordsDeleted = pstmt.executeUpdate();
			System.out.println("["+ recordsDeleted +"] Records deleted from [SPRS_PLAN_COMPL] against DCR ID ["+ dcrId+"]");
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw e;
		}
		finally 
		{
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
		}
		
	}
	//Added by Bhagyashri T for delete SPRS_PLAN_COMPL RECORDS when unconfirm on[26/11/21][END]
}