package ibase.webitm.ejb.wsfa.masters;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.*;
import java.util.*;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class StrgSerClassEJB extends ValidatorEJB implements StrgSerClassEJBLocal,StrgSerClassEJBRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();

	//method for validation
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("Val xmlString :: " + xmlString);
			System.out.println("Val xmlString1 :: " + xmlString1);
			System.out.println("Val xmlString2 :: " + xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			errString = wfValData(dom, dom1,dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}

	//method for validation
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String errorType = "";
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		String userId = "";
		String sql = "";
		String columnValue = "";
		String class_code = "";
		String cadreCode = "";
		String gradeCode = "";
		String SurveyTemplDescr = "";
		//String effDate = "";
		//String valUpToDate = "";
		String itemSer = "";
		String lineNo = "";
		String seqNo = "";
		String item_ser = "";
		String surveyContext = "";
		String effDateStr = "";
		String valUpToDateStr = "";


		int ctr=0;
		int cnt = 0,count=0;
		int currentFormNo = 0;
		int childNodeListLength;

		boolean active = false ;

		java.util.Date effDate = null;
		java.util.Date valUpToDate = null;

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();

		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		//ConnDriver connDriver = new ConnDriver();//Commented by vinayak on [11/07/2016]
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		SimpleDateFormat simpleDateFormat = null;

		try
		{
			//conn = connDriver.getConnectDB("DriverITM");//Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			String loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("******************** 2 ******************");
				System.out.println("********editFlag OutSide***********" + editFlag);

				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("class_code"))
					{
						//columnValue = childNode.getFirstChild().getNodeValue().trim();
						if(childNode.getFirstChild() == null)
						{
							errCode = "VTCLASSNUL";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							cnt =  isValueExist("STRG_CLASS","CLASS_CODE",columnValue, conn);
							if("A".equalsIgnoreCase(editFlag))
							{
								if(cnt == 0)
								{
									System.out.println("Class code not exist in class code master");
									errCode = "VTDLACCNE";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								if(cnt>0)
								{
									active = isClassCodeActive("STRG_CLASS","CLASS_CODE",columnValue, conn);
									if(active)
									{
										System.out.println("Class Code is Active");
									}
									else
									{
										System.out.println("Class Code is inActive");
										errCode = "VTINACLS";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("item_ser"))
					{
						System.out.println(" Validaion   for field "+childNodeName);

						if(childNode.getFirstChild() == null)
						{
							errCode = "NULISRCODE";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							item_ser = childNode.getFirstChild().getNodeValue().trim();
							class_code = checkNull(genericUtility.getColumnValue("class_code", dom));
							cnt =  isValueExist("ITEMSER","item_ser",item_ser, conn);
							if(cnt == 0)
							{
								errCode = "ITMNOTEXT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else if(cnt > 0)
							{
								// sql = " SELECT COUNT(*) AS COUNT FROM ITEMSER WHERE item_ser = ? AND site_code = ? " ;	 // COMMENTED BY VISHAKHA [16.06.2015]
								sql = " SELECT COUNT(*) AS COUNT FROM ITEMSER WHERE item_ser = ? AND SER_TYPE = 'F' " ;	// NEW CHANGES ADDED BY VISHAKHA [16.06.2015]

								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, item_ser);
								//pstmt.setString(2, loginSite);  // COMMENTED BY VISHAKHA [16.06.2015]
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									count  = rs.getInt("COUNT");
								}
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}


								if(count == 0)
								{
									errCode = "VMITMST";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								else if(count>0)
								{
									int recCnt = isRecordPresent(conn ,item_ser,class_code);
									System.out.println("recCnt =["+recCnt+"]");
									if( (recCnt == 1) && ("A".equalsIgnoreCase(editFlag)))
									{
										errCode = "VTDUPETY1";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}

								}
							}
						}
					}

					if(childNodeName.equalsIgnoreCase("descr"))
					{
						System.out.println(" Validaion   for field "+childNodeName);

						if(childNode.getFirstChild() == null)
						{
							errCode = "VMDESRNULL";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
				}
				break;
			}//end switch
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}//end try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation

	// method for item change
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			System.out.println("StrgClassEJB:wfValData value of xmlString ["+xmlString+"]");
			System.out.println("StrgClassEJB:wfValData value of xmlString1 ["+xmlString1+"]");
			System.out.println("StrgClassEJB:wfValData value of xmlString2 ["+xmlString2+"]");
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			valueXmlString = itemChanged(dom, dom1,dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [JvVal][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	// method for item change
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;

		String childNodeName = null;

		String class_code = "";
		String chgDate = "";
		String item_ser = "";
		String item_serDsc = "";
		String lineNo = "";
		String chgUser = "";
		String chgTerm = "";
		String active ="";
		String sqlEdit = "";

		String  itemSerDsc = "";
		String  descr = "";
		String mktFocus = "";
		int ctr = 0;
		int currentFormNo = 0;
		String columnValue = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		//ConnDriver connDriver = new ConnDriver();//Commented by vinayak on [11/07/2016]
		try
		{
			//conn = connDriver.getConnectDB("DriverITM");//Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			conn.setAutoCommit(false);
			//connDriver = null;
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			String userSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			chgDate = simpleDateFormat.format(new java.util.Date());
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");

			System.out.println("******************Inside ItemChange***********" );
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("******************Inside ItemChange dom***********"+dom );
			System.out.println("******************Inside ItemChange dom1***********"+dom1 );
			System.out.println("******************Inside ItemChange dom2***********"+dom2);
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				int childNodeListLength = childNodeList.getLength();
				System.out.println("******************Inside ItemChange Switch***********" );


				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn))
					{
						if(childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr ++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
				System.out.println("In detail1 Item Changed CASE 1 ");
				System.out.println("In detail1 Item Changed CASE 123 " + currentColumn);

				if (currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("value of chgDate"+chgDate);
					System.out.println("value of chgUser"+chgUser);
					System.out.println("value of chgterm"+chgTerm);

					valueXmlString.append("<class_code><![CDATA[").append("").append("]]></class_code>\r\n");
					valueXmlString.append("<item_ser><![CDATA[").append("").append("]]></item_ser>\r\n");
					valueXmlString.append("<itemser_descr protect=\"1\"><![CDATA[").append("").append("]]></itemser_descr>\r\n");
					valueXmlString.append("<mkt_focus>").append("<![CDATA[H]]>").append("</mkt_focus>\r\n");
					valueXmlString.append("<chg_date protect=\"1\"><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
					valueXmlString.append("<chg_user protect=\"1\"><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
					valueXmlString.append("<chg_term protect=\"1\"><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
					valueXmlString.append("<active><![CDATA[").append("Y").append("]]></active>\r\n"); // changes by Hariom for Active class show for division wise :: 29-04-2020
				}

				else if(currentColumn.equalsIgnoreCase("itm_defaultedit"))
				{
					System.out.println("In detail1 itm_defaultedit " + currentColumn);
					class_code = genericUtility.getColumnValue("class_code", dom);
					item_ser = genericUtility.getColumnValue("item_ser", dom);
					sqlEdit = "SELECT TRIM(ITEMSER.DESCR) AS ITEMSER_DESCR,"+
				         "STRG_SER_CLASS.DESCR,"+
				         "STRG_SER_CLASS.MKT_FOCUS,"+
				         "STRG_SER_CLASS.CHG_DATE,"+
				         "STRG_SER_CLASS.CHG_USER,"+
				         "STRG_SER_CLASS.CHG_TERM, "+
				         "STRG_SER_CLASS.ACTIVE "+
				         "FROM STRG_SER_CLASS  ,ITEMSER "+
				         "WHERE STRG_SER_CLASS.ITEM_SER = ITEMSER.ITEM_SER"+
					     "STRG_SER_CLASS.CLASS_CODE = ? AND  STRG_SER_CLASS.ITEM_SER = ? AND ITEMSER.SITE_CODE = ?";

					System.out.println("StrgSerClassEJB itemChanged in itm_defaultedit" + sqlEdit);
					pstmt = conn.prepareStatement(sqlEdit);
					pstmt.setString(1,class_code);
					pstmt.setString(2,item_ser);
					pstmt.setString(3,userSite);

					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						itemSerDsc = checkNull(rs.getString("ITEMSER_DESCR"));
						descr = checkNull(rs.getString("DESCR"));
						mktFocus = checkNull(rs.getString("MKT_FOCUS"));
						chgDate = checkNull(rs.getString("CHG_DATE"));
						chgUser = checkNull(rs.getString("CHG_USER"));
						chgTerm = checkNull(rs.getString("CHG_TERM"));
						active = checkNull(rs.getString("ACTIVE")); // changes by Hariom for Active class show for division wise :: 29-04-2020
					}
					valueXmlString.append("<class_code protect=\"1\"><![CDATA[").append(checkNull(class_code)).append("]]></class_code>\r\n");
					valueXmlString.append("<item_ser protect=\"1\"><![CDATA[").append(checkNull(item_ser)).append("]]></item_ser>\r\n");
					valueXmlString.append("<itemser_descr protect=\"1\"><![CDATA[").append(checkNull(itemSerDsc)).append("]]></itemser_descr>\r\n");
					valueXmlString.append("<descr><![CDATA[").append(checkNull(descr)).append("]]></descr>\r\n");
					valueXmlString.append("<active><![CDATA[").append(checkNull(active)).append("]]></active>\r\n"); // changes by Hariom for Active class show for division wise :: 29-04-2020
					valueXmlString.append("<mkt_focus><![CDATA[").append(checkNull(mktFocus)).append("]]></mkt_focus>\r\n");
					valueXmlString.append("<chg_date protect=\"1\"><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
					valueXmlString.append("<chg_user protect=\"1\"><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
					valueXmlString.append("<chg_term protect=\"1\"><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
				}
				else if(currentColumn.trim().equalsIgnoreCase("item_ser"))
				  {
					item_ser = genericUtility.getColumnValue("item_ser", dom);
					System.out.println("item_ser ITEMCHANGE...."+item_ser);
					//String sql = " SELECT DESCR FROM ITEMSER WHERE item_ser = ? AND site_code = ? " ;   // COMMENTED BY VISHAKHA [16.06.2015]
					String sql = " SELECT DESCR FROM ITEMSER WHERE item_ser = ? AND SER_TYPE = 'F' " ;	// NEW CHANGES ADDED BY VISHAKHA [16.06.2015]
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, item_ser);
					//pstmt.setString(2, userSite); // COMMENTED BY VISHAKHA [16.06.2015]
					rs = pstmt.executeQuery();
					if(rs.next())
					{
					  valueXmlString.append("<itemser_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</itemser_descr>");
					}
					else
					{
					 valueXmlString.append("<itemser_descr>").append("<![CDATA[]]>").append("</itemser_descr>");
					 }
					if( rs != null )
					{
						rs.close();
						rs=null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt=null;
					}

				  }


				valueXmlString.append("</Detail1>");
				break;


			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(pstmt != null)
						pstmt.close();
					if(rs != null)
						rs.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
		}
		return valueXmlString.toString();
	}



	private String errorType(Connection conn , String errorCode) throws ITMException // throws added by kailash on 11-04-18.
	{
		String msgType = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		try
		{
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,errorCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}

	private String getFieldValue(String column,String tableName, String columnName, String columnValue,Connection conn) throws ITMException // throws added by kailash on 11-04-18.
	{
		PreparedStatement pstmt = null;
	    ResultSet rs = null;
	    String value = null;
	    String sql = null;

	    sql = " select "+column+" from "+tableName+" where "+columnName+" = '" + columnValue + "' ";
	    try
	    {
	        pstmt = conn.prepareStatement(sql);
	        rs = pstmt.executeQuery();
	        System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
	        if(rs.next())
	        {
	        	value = rs.getString(1) != null ? rs.getString(1) : " ";
	        }
	        else
	        {
	        	value = " ";
	        }
	        rs.close();
	        pstmt.close();
	    }
	    catch(Exception exception)
	    {
	        exception.printStackTrace();
	        System.out.println("Exception ::" + exception.getMessage());
	        throw new ITMException(exception); //added by Kailash on 11-04-2018.
	    }
	    return value;
	}


	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}


	private int isValueExist(String tableName, String columnName, String columnValue,Connection conn) throws ITMException // throws added by kailash on 11-04-18.
	{
		PreparedStatement pstmt = null;
	    ResultSet rs = null;
	    String sql = null;
	    int cnt = 0 ;
	    sql = " select count(1) as count from "+tableName+" where "+columnName+" = '" + columnValue + "' ";
	    try
	    {
	        pstmt = conn.prepareStatement(sql);
	        rs = pstmt.executeQuery();
	        System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");

	        if(rs.next())
	        {
	        	cnt = rs.getInt("count");
	        }
	        if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
	        System.out.println("cnt--------------"+cnt);
	    }
	    catch(Exception exception)
	    {
	        exception.printStackTrace();
	        System.out.println("Exception ::" + exception.getMessage());
	        throw new ITMException(exception); //added by Kailash on 11-04-2018.
	    }
	    return cnt;
	}

	private boolean isClassCodeActive(String tableName, String columnName, String columnValue,Connection conn) throws ITMException // throws added by kailash on 11-04-18.
	{
		PreparedStatement pstmt = null;
	    ResultSet rs = null;
	    String sql = null;
	    String active = "";
	    boolean flag = false ;
	    sql = " select ACTIVE_YN as ACTIVE_YN from "+tableName+" where "+columnName+" = '" + columnValue + "' ";
	    try
	    {
	        pstmt = conn.prepareStatement(sql);
	        rs = pstmt.executeQuery();
	        System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
	        if(rs.next())
	        {
	        	active = rs.getString("ACTIVE_YN");
	        }

	        if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
	        System.out.println("active--------------"+active);

	        if(active.equalsIgnoreCase("Y"))
	        {
	        	flag = true;
	        }
	        else
	        {
	        	flag = false ;
	        }
	    }
	    catch(Exception exception)
	    {
	        exception.printStackTrace();
	        System.out.println("Exception ::" + exception.getMessage());
	        throw new ITMException(exception); //added by Kailash on 11-04-2018.
	    }

	    return flag;
	}
	private int isRecordPresent(Connection conn,String itemSer,String classCode) throws ITMException // throws added by kailash on 11-04-18.
	{
		PreparedStatement pstmt = null;
	    ResultSet rs = null;
	    String sql = null;
	    String active = "";
	    int cnt = 0;
	    sql = " SELECT COUNT(*) AS COUNT FROM STRG_SER_CLASS WHERE CLASS_CODE = '"+classCode+"' AND ITEM_SER = '"+itemSer+"'";
	    try
	    {
	        pstmt = conn.prepareStatement(sql);
	        rs = pstmt.executeQuery();
	        System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
	        if( rs.next())
	        {
	        	cnt = rs.getInt("COUNT");
	        }

	        if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
	        System.out.println("cnt--------------"+cnt);


	    }
	    catch(Exception exception)
	    {
	        exception.printStackTrace();
	        System.out.println("Exception ::" + exception.getMessage());
	        throw new ITMException(exception); //added by Kailash on 11-04-2018.
	    }

	    return cnt;
	}

}