package ibase.webitm.ejb.wsfa.masters;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.*;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


import javax.ejb.*;
import org.w3c.dom.*;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class StrgCustType extends ValidatorEJB implements StrgCustTypeLocal,StrgCustTypeRemote
{
	// Code for Validation
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("StrgCustType:wfValData value of xmlString ["+xmlString+"]");
			System.out.println("StrgCustType:wfValData value of xmlString ["+xmlString1+"]");
			System.out.println("StrgCustType:wfValData value of xmlString ["+xmlString2+"]");
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println ("ErrString: " + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception: StrgCustType: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ("Returning from StrgCustType wfValData");
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println ("StrgCustType wfValData called...........");
		String userId = "";
		String sql="";
		String errString = "";

		String type="";
		String descr="";
		String minAge="";
		Connection connection = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int count = 0 , cntType = 0, cntDescr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;

		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			SimpleDateFormat DOB = new SimpleDateFormat(getApplDateFormat());
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");*/
			connection = getConnection();//chnged by sachin satre on [9-nov-16] to get connection

			System.out.println("editFlag::::::["+editFlag+"]");
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("userId::::::["+userId+"]");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch ( currentFormNo )
			{
				case 1:
				{
					parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
					int parentNodeListLength = parentList.getLength();
					System.out.println("parentNodeListLength["+parentNodeListLength+"]");

					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						parentNode = parentList.item(prntCtr);
						//System.out.println("value of parentNode"+parentNode);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("value of noOfChilds"+noOfChilds);

						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							//System.out.println("childNode"+childNode);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							System.out.println("value of childNodeName"+childNodeName);

							if (childNodeName.equalsIgnoreCase("type"))
							{
								type= checkNull(getColumnValue("type",dom,"1"));
								descr= checkNull(getColumnValue("descr",dom,"1"));

								if((type == null) ||  ((type.trim()).length()) <= 0)
								{
									System.out.println("type is null");
									errString = getErrorString("type","NULCUSTTYP",userId);
									break;
								}
								else
								{
									if(editFlag != null && "A".equalsIgnoreCase(editFlag))
									{
										System.out.println("type:::["+ type+"]");
										sql="SELECT COUNT(*) CNT FROM STRG_CUST_TYPE WHERE TYPE = ? ";
										pstmt=connection.prepareStatement(sql);
										pstmt.setString(1,type);
										rs = pstmt.executeQuery();
										if( rs.next() )
										{
											cntType= rs.getInt(1);
											System.out.println("cntType:["+ cntType+"]");
										}
										if(cntType > 0)
										{
											errString = getErrorString("type","CUSTEXIST",userId);
											break;
										}
									}
								}
							}
							else if (childNodeName.equalsIgnoreCase("descr"))
							{
								type= checkNull(getColumnValue("type",dom,"1"));
								descr= checkNull(getColumnValue("descr",dom,"1"));
								if((descr == null) ||  ((descr.trim()).length()) <= 0)
								{
									System.out.println("descr is null"+descr);
									errString = getErrorString("descr","NULCUSTDES",userId);
									break;
								}
								else
								{
									if(editFlag != null && "A".equalsIgnoreCase(editFlag))
									{
										System.out.println("descr:::["+ descr+"]");
										sql="SELECT COUNT(*) CNT FROM STRG_CUST_TYPE WHERE DESCR =? ";
										pstmt=connection.prepareStatement(sql);
										pstmt.setString(1,descr);
										rs = pstmt.executeQuery();
										if( rs.next() )
										{
											cntDescr= rs.getInt(1);
											System.out.println("cntDescr:["+ cntDescr+"]");
										}
										if(cntDescr > 0)
										{
											errString = getErrorString("descr","CUSTDEXIST",userId);
											break;
										}
									}
								}
							}
							else if (childNodeName.equalsIgnoreCase("min_age"))
							{
								minAge= checkNull(getColumnValue("min_age",dom,"1"));
								if((minAge == null) ||  ((minAge.trim()).length()) <= 0)
								{
									System.out.println("min_age is null"+minAge);
									errString = getErrorString("min_age","NULLMINAGE",userId);
									break;
								}
								else
								{
									/*Pattern p = Pattern.compile("[0-9]+");
									Matcher m = p.matcher(minAge);
								     boolean b = m.find();
								     if (b == true)
								     {
										String errCode = "SFAVALSPCL";
										errString =  getErrorString("min_age",errCode,userId);
										break ;
								     }*/
								}
							}
						}
					}
					break;
				}//case1
			}//switch
		}//try
		catch (Exception e)
		{
			System.out.println ("Exception: StrgCustType: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(connection != null)
				{
					connection.close();
					connection = null;
				}
            }
			catch(Exception e)
			{
				errString = genericUtility.createErrorString(e);
			}
		}
		return (errString);
	}
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("StrgCustType value of xmlString ["+xmlString+"]");
			System.out.println("StrgCustType value of xmlString ["+xmlString1+"]");
			System.out.println("StrgCustType value of xmlString ["+xmlString2+"]");
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :StrgCustType :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("Returning from StrgCustType itemChanged");
		return errString;
	 }

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{

		int currentFormNo = 0;
		StringBuffer valueXmlString =null;
		GenericUtility genericUtility = GenericUtility.getInstance();

		String chgDate = "";
		String chgUser = "";
		String chgTerm = "";
		String active="";

		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection connection = null;
		//ConnDriver connDriver = null;
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			chgDate = sdf.format(new java.util.Date());
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			active =  genericUtility.getValueFromXTRA_PARAMS(xtraParams,"active");

			if (objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			/*connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");*/
			connection = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n<Detail1>\r\n");
			switch (currentFormNo)
			{
				case 1:
					if (currentColumn.equalsIgnoreCase("itm_default"))
					{
						System.out.println("value of chgDate:"+chgDate);
						System.out.println("value of chgUser:"+chgUser);
						System.out.println("value of chgterm:"+chgTerm);
						System.out.println("value of active:"+active);

						valueXmlString.append("<chg_date><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
						valueXmlString.append("<chg_user><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
						valueXmlString.append("<chg_term><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
					}

				break;
			}
		}
		catch (Exception e)
		{
			System.out.println ("Exception :StrgCustType :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(connection != null)
				{
					connection.close();
					connection = null;
				}
            }
			catch(Exception e)
			{
				System.out.println(e.getMessage());
			}
		}
		valueXmlString.append ("</Detail1>\r\n");
		valueXmlString.append("</Root>\r\n");
		//System.out.println("StrgCustType :itemChanged(Document,String):return valueXmlString"+valueXmlString);
		return valueXmlString.toString();

	}
	private String checkNull(String input)
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input =input.trim();
		}
		return input;
	}
}