/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.LinkControllerLocal;
import ibase.webitm.ejb.LinkControllerRemote;
import ibase.webitm.utility.DB2XMLGenerator;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class LinkControllerEJB
implements LinkControllerRemote,
LinkControllerLocal {
    String objName = null;
    String pageContext = null;
    String tableToUpdate = null;
    String database = "oracle";
    String loginCode = null;
    Document dataDom = null;
    String currPKNames = null;
    String currPKValues = null;
    String updateQuery = null;
    Hashtable dbNames = null;
    Hashtable dbValues = null;
    Hashtable dbTypes = null;
    LinkedList colToRemove = null;
    @Resource
    private SessionContext cSessionContext;

    public void ejbCreate() {
        BaseLogger.log("2", null, null, "LinkControllerEJB Created...");
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    @Override
    public String viewTransactionDetails(String objName, String objContext, String pageContext, String qryParamType, String qryParam, String userInfoStr) throws RemoteException, ITMException {
        BaseLogger.log("2", null, null, "LinkControllerEJB: viewTransactionDetails==>");
        String xmlString = null;
        String mainDomFileName = "";
        String filePath = "";
        try {
            UserInfoBean userInfo = null;
            if (userInfoStr != null && userInfoStr.length() > 0) {
                userInfo = new UserInfoBean(userInfoStr);
            }
            DB2XMLGenerator db2xmlgen = new DB2XMLGenerator(objName);
            mainDomFileName = db2xmlgen.createXML(objName, objContext, pageContext, qryParam, qryParamType, null, userInfo != null ? userInfo.toString() : null);
            filePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "xmldatafiles" + File.separator + mainDomFileName;
            BaseLogger.log("3", null, null, "filePath : [" + filePath + "]");
            xmlString = new E12GenericUtility().readFile(filePath);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException : LinkControllerEJB: viewTransactionDetails : Generic Exception==>\n");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "LinkControllerEJB: viewTransactionDetails: Generic Exception==>\n" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        return xmlString;
    }

    @Override
    public String save2DB(String xmlDataStr, String objName, String pageContext, String loginCode, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "Save2DBEJB: save2DB==>");
        Object xmlString = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dataDom = db.parse(new ByteArrayInputStream(xmlDataStr.getBytes()));
            this.objName = objName;
            this.pageContext = pageContext;
            this.loginCode = loginCode;
            return this.saveValuesInDB(userInfo);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException : LinkControllerEJB: save2DB : Generic Exception==>\n");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Save2DBEJB: save2DB: Generic Exception==>\n" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    private String saveValuesInDB(UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "Calling saveValuesInDB .....");
        String statusStr = "";
        Connection con = null;
        String transDB = "";
        try {
            try {
                ConnDriver conDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                con = conDriver.getConnectDB(transDB);
                con.setAutoCommit(false);
                int rec = -1;
                int formCtr = 1;
                this.setFormMetaInfo(this.objName, formCtr, userInfo);
                NodeList formDetList = this.dataDom.getElementsByTagName("Detail" + formCtr);
                int formDetListLen = formDetList.getLength();
                int detCtr = 0;
                while (detCtr < formDetListLen) {
                    Node currDet = formDetList.item(detCtr);
                    this.currPKValues = this.getPKValues(formCtr, currDet);
                    NodeList currDetChildList = currDet.getChildNodes();
                    this.collectValues(currDetChildList, formCtr);
                    rec = this.update(formCtr, userInfo.toString());
                    ++detCtr;
                }
                if (rec != -1) {
                    con.commit();
                    statusStr = this.currPKValues;
                }
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "Exception : LinkControllerEJB:saveValuesInDB :==>\n" + itme);
                throw itme;
            }
            catch (SQLException SQLex) {
                try {
                    SQLex.printStackTrace();
                    BaseLogger.log("0", userInfo, null, "Operation rolling back.........");
                    con.rollback();
                }
                catch (Exception sqe) {
                    BaseLogger.log("0", userInfo, null, "Exception : LinkControllerEJB:saveValuesInDB :==>\n" + sqe);
                    throw new ITMException(sqe);
                }
                BaseLogger.log("0", userInfo, null, "Exception : LinkControllerEJB: saveValuesInDB :==>\n" + SQLex);
                throw new ITMException(SQLex);
            }
            catch (Exception ex) {
                try {
                    con.rollback();
                }
                catch (Exception e) {
                    BaseLogger.log("0", userInfo, null, "Exception :LinkControllerEJB  saveValuesInDB :==>\n" + e);
                    throw new ITMException(e);
                }
                throw new ITMException(ex);
            }
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :Save2DBEJB  saveValuesInDB :==>\n" + e);
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", userInfo, null, "saveValuesInDB Completed..............\n");
        return statusStr;
    }

    private void setFormMetaInfo(String objName, int formCtr, UserInfoBean userInfo) throws ITMException {
        try {
            BaseLogger.log("3", null, null, "Calling setFormMetaInfo for objName :" + objName);
            DWObject dwObject = null;
            String metaDataFileName = String.valueOf(objName) + this.pageContext + formCtr;
            DWFactory dws = new DWFactory(userInfo);
            dwObject = dws.getDataWindow(metaDataFileName);
            this.database = CommonConstants.DB_NAME;
            this.tableToUpdate = dwObject.getTableToBeUpdated();
            this.dbNames = dwObject.getUpdateableLogPhyColNames();
            BaseLogger.log("3", null, null, "ddddddddddddddddddddddddd this.dbNames:" + this.dbNames);
            this.dbTypes = dwObject.getUpdateableLogNameColType();
            this.colToRemove = dwObject.getNoUpdateBandLinkList();
            ArrayList pkNamesList = dwObject.getPrimaryKeyLogNameList();
            BaseLogger.log("3", null, null, "\nDanish :setFormMetaInfo pkNamesList :" + pkNamesList + ": this.tableToUpdate :" + this.tableToUpdate);
            StringBuffer pkFieldBuff = new StringBuffer();
            int i = 0;
            while (i < pkNamesList.size()) {
                pkFieldBuff.append((String)pkNamesList.get(i)).append(":");
                ++i;
            }
            if (pkFieldBuff.length() > 0) {
                pkFieldBuff.deleteCharAt(pkFieldBuff.length() - 1);
                this.currPKNames = pkFieldBuff.toString();
            }
            this.updateQuery = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "Exception : LinkControllerEJB:setFormMetaInfo :==>\n" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :setFormMetaInfo :setFormMetaInfo :==>\n" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "setFormMetaInfo for objName :" + objName + ": Completed.......\n");
    }

    private void collectValues(NodeList currDetChildList, int formCtr) throws RemoteException, ITMException {
        BaseLogger.log("2", null, null, "Calling.......collectValues for formNo :" + formCtr + ": \n");
        try {
            boolean dbOperReqd = true;
            this.dbValues = new Hashtable();
            int currDetChildListLen = currDetChildList.getLength();
            int detChildCtr = 0;
            while (detChildCtr < currDetChildListLen) {
                Node curDetChild = currDetChildList.item(detChildCtr);
                String currNodeName = curDetChild.getNodeName();
                if (currNodeName.equalsIgnoreCase("attribute") && curDetChild.getAttributes().getNamedItem("status").getNodeValue() != null) {
                    String string = curDetChild.getAttributes().getNamedItem("status").getNodeValue();
                }
                if (dbOperReqd && !currNodeName.equals("#text") && !this.colToRemove.contains(currNodeName)) {
                    String colValue = "";
                    String fieldName = currNodeName;
                    if (fieldName.equalsIgnoreCase("CHG_TERM") || fieldName.equalsIgnoreCase("ADD_TERM")) {
                        colValue = "SYSTEM";
                    } else if (fieldName.equalsIgnoreCase("CHG_USER") || fieldName.equalsIgnoreCase("ADD_USER")) {
                        colValue = this.loginCode;
                    } else if (curDetChild.getFirstChild() != null) {
                        colValue = curDetChild.getFirstChild().getNodeValue();
                    }
                    if (colValue != null) {
                        this.dbValues.put(fieldName, colValue);
                    }
                }
                ++detChildCtr;
            }
            BaseLogger.log("3", null, null, "\nSave2DBEJB : collectValues :" + this.dbValues);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception:Save2DBEJB: collectValues :" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "collectValues for formNo :" + formCtr + ": completed .....\n");
    }

    private String getPKValues(int formNo, Node currRecNode) throws ITMException {
        BaseLogger.log("2", null, null, "Getting Primary Key Values from dom .......");
        BaseLogger.log("2", null, null, "Current Primary Key Field Names :" + this.currPKNames);
        boolean ctr = false;
        String retValue = "";
        try {
            StringTokenizer pkNameTokens = new StringTokenizer(this.currPKNames, ":");
            while (pkNameTokens.hasMoreTokens()) {
                String currPKName = pkNameTokens.nextToken();
                NodeList currRecChildList = currRecNode.getChildNodes();
                int noOfCols = currRecChildList.getLength();
                int colCtr = 0;
                while (colCtr < noOfCols) {
                    String currNodeName = currRecChildList.item(colCtr).getNodeName();
                    if (currNodeName.equalsIgnoreCase(currPKName)) {
                        retValue = String.valueOf(retValue) + currRecChildList.item(colCtr).getFirstChild().getNodeValue() + ":";
                    }
                    ++colCtr;
                }
            }
            if (retValue.endsWith(":")) {
                retValue = retValue.substring(0, retValue.length() - 1);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : LinkControllerEJB:getPKValues :==>\n" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "Primary Key Values from dom :" + retValue);
        return retValue;
    }

    private int update(int formCtr, String userInfoStr) throws RemoteException, ITMException {
        BaseLogger.log("2", null, null, "Updating record for : formNo :" + formCtr + "\n");
        Enumeration logicalNames = null;
        int result = 0;
        Statement pstmt = null;
        Connection con = null;
        String transDB = null;
        E12GenericUtility genUtility = new E12GenericUtility();
        try {
            try {
                String dbDateStr;
                String dataType;
                String val;
                StringTokenizer pkNameTokens = null;
                StringTokenizer pkValueTokens = null;
                UserInfoBean userInfo = new UserInfoBean(userInfoStr);
                transDB = userInfo.getTransDB();
                ConnDriver conDriver = new ConnDriver();
                con = conDriver.getConnectDB(transDB);
                if (this.updateQuery == null) {
                    StringBuffer sqlBuff = new StringBuffer("UPDATE ");
                    sqlBuff.append(this.tableToUpdate).append(" SET ");
                    logicalNames = this.dbNames.keys();
                    while (logicalNames.hasMoreElements()) {
                        String currElement = (String)logicalNames.nextElement();
                        sqlBuff.append(this.dbNames.get(currElement)).append("=?,");
                    }
                    sqlBuff.deleteCharAt(sqlBuff.length() - 1);
                    sqlBuff.append(" WHERE ");
                    pkNameTokens = new StringTokenizer(this.currPKNames, ":");
                    pkValueTokens = new StringTokenizer(this.currPKValues, ":");
                    while (pkNameTokens.hasMoreTokens()) {
                        String currPKName = pkNameTokens.nextToken();
                        String phyName = (String)this.dbNames.get(currPKName);
                        if (this.database.equalsIgnoreCase("DB2") && phyName.indexOf(".") != -1) {
                            phyName = phyName.substring(phyName.indexOf(".") + 1);
                        }
                        sqlBuff.append(phyName).append("= ? ").append(" AND ");
                    }
                    this.updateQuery = sqlBuff.toString();
                    if (this.updateQuery.endsWith(" AND ")) {
                        this.updateQuery = this.updateQuery.substring(0, this.updateQuery.length() + 1 - " AND ".length());
                    }
                }
                BaseLogger.log("3", userInfo, null, "THE UPDATE QUERY IS :--->" + this.updateQuery);
                pstmt = con.prepareStatement(this.updateQuery);
                int prepCount = 0;
                logicalNames = this.dbNames.keys();
                String valueString = "";
                while (logicalNames.hasMoreElements()) {
                    ++prepCount;
                    String currElement = (String)logicalNames.nextElement();
                    val = null;
                    if (this.dbValues.get(currElement) != null) {
                        val = (String)this.dbValues.get(currElement);
                    }
                    dataType = (String)this.dbTypes.get(currElement);
                    if (val == null || val.length() <= 0) {
                        if (dataType.toUpperCase().indexOf("STRING") != -1 || dataType.toUpperCase().indexOf("VARCHAR") != -1 || dataType.toUpperCase().indexOf("CHAR") != -1) {
                            pstmt.setNull(prepCount, 12);
                            valueString = String.valueOf(valueString) + currElement + "=  '" + val + "', ";
                            continue;
                        }
                        if (dataType.toUpperCase().indexOf("DECIMAL") != -1 || dataType.toUpperCase().indexOf("DOUBLE") != -1 || dataType.toUpperCase().indexOf("NUMBER") != -1 || dataType.toUpperCase().indexOf("LONG") != -1) {
                            pstmt.setNull(prepCount, 8);
                            valueString = String.valueOf(valueString) + currElement + "=  '" + val + "', ";
                            continue;
                        }
                        if (dataType.toUpperCase().indexOf("DATETIME") != -1 || dataType.toUpperCase().indexOf("TIMESTAMP") != -1) {
                            Object dt = null;
                            pstmt.setNull(prepCount, 93);
                            valueString = String.valueOf(valueString) + currElement + "=  '" + val + "', ";
                            continue;
                        }
                        if (dataType.toUpperCase().indexOf("DATE") != -1) {
                            pstmt.setNull(prepCount, 91);
                            valueString = String.valueOf(valueString) + currElement + "=  '" + val + "', ";
                            continue;
                        }
                        if (dataType.toUpperCase().indexOf("TIME") == -1) continue;
                        pstmt.setNull(prepCount, 93);
                        valueString = String.valueOf(valueString) + currElement + "=  '" + val + "', ";
                        continue;
                    }
                    System.out.print("Setting ==>" + currElement + "<====>" + dataType + "<====>" + val + "<==");
                    if (dataType.toUpperCase().indexOf("STRING") != -1 || dataType.toUpperCase().indexOf("CHAR") != -1 || dataType.toUpperCase().indexOf("VARCHAR") != -1) {
                        System.out.print(String.valueOf(val) + "<==");
                        pstmt.setString(prepCount, String.valueOf(val));
                        valueString = String.valueOf(valueString) + currElement + "=  '" + val + "', ";
                        continue;
                    }
                    if (dataType.toUpperCase().indexOf("DECIMAL") != -1 || dataType.toUpperCase().indexOf("DOUBLE") != -1 || dataType.toUpperCase().indexOf("NUMBER") != -1 || dataType.toUpperCase().indexOf("LONG") != -1) {
                        System.out.print(Double.valueOf(val) + "<==");
                        pstmt.setDouble(prepCount, Double.valueOf(val));
                        valueString = String.valueOf(valueString) + currElement + "=  '" + val + "', ";
                        continue;
                    }
                    if (dataType.toUpperCase().indexOf("DATETIME") != -1 || dataType.toUpperCase().indexOf("TIMESTAMP") != -1) {
                        dbDateStr = val;
                        if (!currElement.equalsIgnoreCase("CHG_DATE") && !currElement.equalsIgnoreCase("ADD_DATE")) {
                            dbDateStr = genUtility.getValidDateTimeString(val, genUtility.getApplDateFormat(), genUtility.getDBDateFormat());
                            System.out.print("Setting DateTime :[" + dbDateStr + "]");
                            pstmt.setTimestamp(prepCount, Timestamp.valueOf(dbDateStr));
                        } else {
                            System.out.print("Setting current DateTime in CHG_DATE");
                            pstmt.setTimestamp(prepCount, new Timestamp(System.currentTimeMillis()));
                        }
                        valueString = String.valueOf(valueString) + currElement + "=  '" + val + "', ";
                        continue;
                    }
                    if (dataType.toUpperCase().indexOf("DATE") != -1) {
                        dbDateStr = val;
                        if (!currElement.equalsIgnoreCase("CHG_DATE") && !currElement.equalsIgnoreCase("ADD_DATE")) {
                            dbDateStr = genUtility.getValidDateString(val, genUtility.getApplDateFormat(), genUtility.getDBDateFormat());
                            System.out.print("Setting Date :[" + dbDateStr + "]");
                            pstmt.setDate(prepCount, Date.valueOf(dbDateStr));
                        } else {
                            System.out.print("Setting current Date in CHG_DATE");
                            pstmt.setDate(prepCount, new Date(System.currentTimeMillis()));
                        }
                        valueString = String.valueOf(valueString) + currElement + "=  '" + val + "', ";
                        continue;
                    }
                    if (dataType.toUpperCase().indexOf("TIME") == -1) continue;
                    Calendar dateCreated = Calendar.getInstance();
                    SimpleDateFormat df = new SimpleDateFormat(genUtility.getDBDateFormat());
                    String sysDate = df.format(dateCreated.getTime());
                    pstmt.setTimestamp(prepCount, Timestamp.valueOf(String.valueOf(sysDate) + " " + String.valueOf(val)));
                }
                BaseLogger.log("3", userInfo, null, "Danish :  prepCount :" + prepCount + " Value String :" + valueString);
                pkNameTokens = new StringTokenizer(this.currPKNames, ":");
                pkValueTokens = new StringTokenizer(this.currPKValues, ":");
                while (pkNameTokens.hasMoreTokens()) {
                    String currPKName = pkNameTokens.nextToken();
                    ++prepCount;
                    val = (String)this.dbValues.get(currPKName);
                    dataType = (String)this.dbTypes.get(currPKName);
                    System.out.print("Setting ==>" + currPKName + "<====>" + dataType + "<====>" + val + "<==");
                    if (dataType.toUpperCase().indexOf("STRING") != -1 || dataType.toUpperCase().indexOf("CHAR") != -1 || dataType.toUpperCase().indexOf("VARCHAR") != -1) {
                        System.out.print(String.valueOf(val) + "<==");
                        pstmt.setString(prepCount, String.valueOf(val));
                        continue;
                    }
                    if (dataType.toUpperCase().indexOf("DECIMAL") != -1 || dataType.toUpperCase().indexOf("DOUBLE") != -1 || dataType.toUpperCase().indexOf("NUMBER") != -1 || dataType.toUpperCase().indexOf("LONG") != -1) {
                        System.out.print(Double.valueOf(val) + "<==");
                        pstmt.setDouble(prepCount, Double.valueOf(val));
                        continue;
                    }
                    if (dataType.toUpperCase().indexOf("DATETIME") != -1 || dataType.toUpperCase().indexOf("TIMESTAMP") != -1) {
                        dbDateStr = genUtility.getValidDateTimeString(val, genUtility.getApplDateFormat(), genUtility.getDBDateFormat());
                        System.out.print("Setting DateTime :[" + dbDateStr + "]");
                        pstmt.setTimestamp(prepCount, Timestamp.valueOf(dbDateStr));
                        continue;
                    }
                    if (dataType.toUpperCase().indexOf("DATE") == -1) continue;
                    dbDateStr = genUtility.getValidDateString(val, genUtility.getApplDateFormat(), genUtility.getDBDateFormat());
                    System.out.print("Setting Date :[" + dbDateStr + "]");
                    pstmt.setDate(prepCount, Date.valueOf(dbDateStr));
                }
                BaseLogger.log("3", userInfo, null, "<====EXECUTING UPDATE QUERY ====>");
                result = pstmt.executeUpdate();
                con.commit();
                pstmt.close();
                pstmt = null;
                BaseLogger.log("3", userInfo, null, "Save2DBEJB : UPDATE : result :" + result + ":");
                BaseLogger.log("3", userInfo, null, "<====UPDATE QUERY EXECUTED====>");
            }
            catch (ITMException itme) {
                try {
                    if (con != null) {
                        con.rollback();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                BaseLogger.log("0", null, null, "Exception : LinkControllerEJB:update :==>\n" + itme);
                throw itme;
            }
            catch (Exception e) {
                try {
                    if (con != null) {
                        con.rollback();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                BaseLogger.log("0", null, null, "Exception : LinkControllerEJB: update :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : LinkControllerEJB:update :finally==>");
                throw new ITMException(e);
            }
        }
        return result;
    }

    @Override
    public String getLinkInfo(String objName, String formNo, UserInfoBean userInfo) throws RemoteException, ITMException {
        StringBuffer linkInfoXMLBuff = null;
        try {
            linkInfoXMLBuff = new StringBuffer();
            ArrayList objFormsLinkDetailList = this.getLinkInfoList(objName, formNo, userInfo);
            BaseLogger.log("3", userInfo, null, "linkInfoList :" + objFormsLinkDetailList);
            if (objFormsLinkDetailList != null && objFormsLinkDetailList.size() > 0) {
                linkInfoXMLBuff.append("<Links>");
                int noOfForms = objFormsLinkDetailList.size();
                int i = 0;
                while (i < noOfForms) {
                    ArrayList currFormLinkDetailList = (ArrayList)objFormsLinkDetailList.get(i);
                    linkInfoXMLBuff.append("\n<Link formNo='" + currFormLinkDetailList.get(0) + "' fieldName='" + currFormLinkDetailList.get(1) + "'>");
                    linkInfoXMLBuff.append("<TargetObject><![CDATA[" + currFormLinkDetailList.get(2) + "]]></TargetObject>\n");
                    linkInfoXMLBuff.append("<LinkForm><![CDATA[" + currFormLinkDetailList.get(3) + "]]></LinkForm>\n");
                    linkInfoXMLBuff.append("<LinkTitle><![CDATA[" + currFormLinkDetailList.get(4) + "]]></LinkTitle>\n");
                    linkInfoXMLBuff.append("<LinkUri><![CDATA[" + currFormLinkDetailList.get(5) + "]]></LinkUri>\n");
                    linkInfoXMLBuff.append("<LinkType><![CDATA[" + currFormLinkDetailList.get(6) + "]]></LinkType>\n");
                    linkInfoXMLBuff.append("<LinkArg><![CDATA[" + currFormLinkDetailList.get(7) + "]]></LinkArg>\n");
                    linkInfoXMLBuff.append("<UpdateFlag><![CDATA[" + currFormLinkDetailList.get(8) + "]]></UpdateFlag>\n");
                    linkInfoXMLBuff.append("<RightsChar><![CDATA[" + currFormLinkDetailList.get(9) + "]]></RightsChar>\n");
                    linkInfoXMLBuff.append("<Image><![CDATA[" + currFormLinkDetailList.get(10) + "]]></Image>\n");
                    linkInfoXMLBuff.append("<ShowInPanel><![CDATA[" + currFormLinkDetailList.get(11) + "]]></ShowInPanel>\n");
                    linkInfoXMLBuff.append("<ShortcutChar><![CDATA[" + currFormLinkDetailList.get(12) + "]]></ShortcutChar>\n");
                    linkInfoXMLBuff.append("<AutoInvoke><![CDATA[" + currFormLinkDetailList.get(13) + "]]></AutoInvoke>\n");
                    linkInfoXMLBuff.append("<ShowConfirm><![CDATA[" + currFormLinkDetailList.get(14) + "]]></ShowConfirm>\n");
                    linkInfoXMLBuff.append("<DisplayMode><![CDATA[" + currFormLinkDetailList.get(15) + "]]></DisplayMode>\n");
                    linkInfoXMLBuff.append("<LineNo><![CDATA[" + currFormLinkDetailList.get(16) + "]]></LineNo>\n");
                    linkInfoXMLBuff.append("<linkId><![CDATA[" + currFormLinkDetailList.get(17) + "]]></linkId>\n");
                    linkInfoXMLBuff.append("<RecordSpecific><![CDATA[" + currFormLinkDetailList.get(18) + "]]></RecordSpecific>\n");
                    linkInfoXMLBuff.append("</Link>");
                    ++i;
                }
                linkInfoXMLBuff.append("\n</Links>");
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException :RequestHandlerServlet : getLinkInfo:==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :RequestHandlerServlet :getLinkInfo :==>");
            throw new ITMException(e);
        }
        return linkInfoXMLBuff.toString();
    }

    private ArrayList getLinkInfoList(String objName, String formNo, UserInfoBean userInfo) throws RemoteException, ITMException {
        ArrayList objFormsLinkDetailList = null;
        Object mQuery = null;
        try {
            String loginUserCode = "";
            String transDB = "";
            if (userInfo != null) {
                transDB = userInfo.getTransDB();
                loginUserCode = userInfo.getLoginCode();
            }
            BaseLogger.log("3", userInfo, null, "transDB =[" + transDB + "], loginUserCode =[" + loginUserCode + "]");
            objFormsLinkDetailList = this.getLinkInfoList(objName, formNo, loginUserCode, userInfo);
        }
        catch (ITMException itme) {
            System.err.println("ITMException: DBAccess: getElemItemChangeList:");
            throw itme;
        }
        catch (Exception e) {
            System.err.println("Exception: DBAccess: getElemItemChangeList:" + e);
            throw new ITMException(e);
        }
        return objFormsLinkDetailList;
    }

    @Override
    public String getLinkInfo(String objName, String formNo, String loginCode, UserInfoBean userInfo) throws RemoteException, ITMException {
        StringBuffer linkInfoXMLBuff = null;
        try {
            linkInfoXMLBuff = new StringBuffer();
            ArrayList objFormsLinkDetailList = this.getLinkInfoList(objName, formNo, loginCode, userInfo);
            BaseLogger.log("3", userInfo, null, "linkInfoList :" + objFormsLinkDetailList);
            if (objFormsLinkDetailList != null && objFormsLinkDetailList.size() > 0) {
                linkInfoXMLBuff.append("<Links>");
                int noOfForms = objFormsLinkDetailList.size();
                int i = 0;
                while (i < noOfForms) {
                    ArrayList currFormLinkDetailList = (ArrayList)objFormsLinkDetailList.get(i);
                    linkInfoXMLBuff.append("\n<Link formNo='" + currFormLinkDetailList.get(0) + "' fieldName='" + currFormLinkDetailList.get(1) + "'>");
                    linkInfoXMLBuff.append("<TargetObject><![CDATA[" + currFormLinkDetailList.get(2) + "]]></TargetObject>\n");
                    linkInfoXMLBuff.append("<LinkForm><![CDATA[" + currFormLinkDetailList.get(3) + "]]></LinkForm>\n");
                    linkInfoXMLBuff.append("<LinkTitle><![CDATA[" + currFormLinkDetailList.get(4) + "]]></LinkTitle>\n");
                    linkInfoXMLBuff.append("<LinkUri><![CDATA[" + currFormLinkDetailList.get(5) + "]]></LinkUri>\n");
                    linkInfoXMLBuff.append("<LinkType><![CDATA[" + currFormLinkDetailList.get(6) + "]]></LinkType>\n");
                    linkInfoXMLBuff.append("<LinkArg><![CDATA[" + currFormLinkDetailList.get(7) + "]]></LinkArg>\n");
                    linkInfoXMLBuff.append("<UpdateFlag><![CDATA[" + currFormLinkDetailList.get(8) + "]]></UpdateFlag>\n");
                    linkInfoXMLBuff.append("<RightsChar><![CDATA[" + currFormLinkDetailList.get(9) + "]]></RightsChar>\n");
                    linkInfoXMLBuff.append("<Image><![CDATA[" + currFormLinkDetailList.get(10) + "]]></Image>\n");
                    linkInfoXMLBuff.append("<ShowInPanel><![CDATA[" + currFormLinkDetailList.get(11) + "]]></ShowInPanel>\n");
                    linkInfoXMLBuff.append("<ShortcutChar><![CDATA[" + currFormLinkDetailList.get(12) + "]]></ShortcutChar>\n");
                    linkInfoXMLBuff.append("<AutoInvoke><![CDATA[" + currFormLinkDetailList.get(13) + "]]></AutoInvoke>\n");
                    linkInfoXMLBuff.append("<ShowConfirm><![CDATA[" + currFormLinkDetailList.get(14) + "]]></ShowConfirm>\n");
                    linkInfoXMLBuff.append("<DisplayMode><![CDATA[" + currFormLinkDetailList.get(15) + "]]></DisplayMode>\n");
                    linkInfoXMLBuff.append("<lineNo><![CDATA[" + currFormLinkDetailList.get(16) + "]]></lineNo>\n");
                    linkInfoXMLBuff.append("<linkId><![CDATA[" + currFormLinkDetailList.get(17) + "]]></linkId>\n");
                    linkInfoXMLBuff.append("<recordSpecific><![CDATA[" + currFormLinkDetailList.get(18) + "]]></recordSpecific>\n");
                    linkInfoXMLBuff.append("</Link>");
                    ++i;
                }
                linkInfoXMLBuff.append("\n</Links>");
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException :RequestHandlerServlet : getLinkInfo:==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :RequestHandlerServlet :getLinkInfo :==>");
            throw new ITMException(e);
        }
        return linkInfoXMLBuff.toString();
    }

    private ArrayList getLinkInfoList(String objName, String formNo, String loginCode, UserInfoBean userInfo) throws RemoteException, ITMException {
        ConnDriver mConnDriver = null;
        Connection mConnection = null;
        Connection commConn = null;
        Statement mStmt = null;
        ResultSet mRs = null;
        ArrayList objFormsLinkDetailList = null;
        String mQuery = null;
        int usrLevel = 0;
        String profileId = null;
        String strRights = null;
        String transDB = null;
        PreparedStatement pStmt = null;
        String userAdhocRights = "";
        String userAdhocRightSql = "";
        String userRightType = " ";
        String userID = userInfo.getLoginCode();
        String currSiteCode = userInfo.getSiteCode();
        String siteCodeLogin = "";
        Timestamp effFromUserAdhoc = null;
        Timestamp validUptoAdhoc = null;
        Timestamp currDateTs = null;
        java.util.Date curr = new java.util.Date();
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            try {
                transDB = userInfo.getTransDB();
                profileId = E12GenericUtility.checkNull(userInfo.getProfileId());
                mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(transDB);
                commConn = mConnDriver.getConnectDB(userInfo.getTransDB());
                mQuery = "SELECT USR_LEV FROM USERS WHERE CODE='" + loginCode + "'";
                mStmt = commConn.createStatement();
                mRs = mStmt.executeQuery(mQuery);
                if (mRs.next()) {
                    usrLevel = mRs.getInt("USR_LEV");
                }
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
                if (mRs != null) {
                    mRs.close();
                    mRs = null;
                }
                if (usrLevel == 0) {
                    strRights = "*";
                } else {
                    strRights = "";
                    mQuery = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId) + " AND OBJ_NAME ='" + objName + "'";
                    mStmt = mConnection.createStatement();
                    mRs = mStmt.executeQuery(mQuery);
                    while (mRs.next()) {
                        strRights = String.valueOf(strRights) + E12GenericUtility.checkNull(mRs.getString("RIGHTS"));
                    }
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                    if (mRs != null) {
                        mRs.close();
                        mRs = null;
                    }
                    SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
                    String currDateStr = sdfAppl.format(curr);
                    userAdhocRightSql = "SELECT RIGHTS,RIGHTS_TYPE,SITE_CODE__LOGIN, EFF_FROM,VALID_UPTO FROM USER_RIGHTS_ADHOC WHERE OBJ_NAME =? AND USER_ID =?";
                    pStmt = mConnection.prepareStatement(userAdhocRightSql);
                    pStmt.setString(1, objName);
                    pStmt.setString(2, userID);
                    mRs = pStmt.executeQuery();
                    while (mRs.next()) {
                        userRightType = mRs.getString("RIGHTS_TYPE");
                        userAdhocRights = mRs.getString("RIGHTS");
                        siteCodeLogin = E12GenericUtility.checkNull(mRs.getString("SITE_CODE__LOGIN"));
                        effFromUserAdhoc = mRs.getTimestamp("EFF_FROM");
                        validUptoAdhoc = mRs.getTimestamp("VALID_UPTO");
                    }
                    currDateTs = Timestamp.valueOf(String.valueOf(genericUtility.getValidDateString(currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())) + " 00:00:00.0");
                    if (userRightType.equalsIgnoreCase("O")) {
                        BaseLogger.log("3", null, null, "[LinkController]UserAdhocRights gets from the override[" + userAdhocRights + "]");
                        if (!(currDateTs.before(effFromUserAdhoc) || currDateTs.after(validUptoAdhoc) || !currSiteCode.equalsIgnoreCase(siteCodeLogin) && siteCodeLogin.length() != 0)) {
                            strRights = userAdhocRights;
                            BaseLogger.log("3", null, null, "[LinkController]RightStr gets from the overridd[" + strRights + "]");
                        }
                    }
                    if (mRs != null) {
                        mRs.close();
                        mRs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                }
                mQuery = "SELECT FORM_NO,FIELD_NAME,TARGET_OBJ_NAME,LINK_FORM_NAME,LINK_TITLE,LINK_URI,LINK_TYPE,LINK_ARG,UPDATE_FLAG,RIGHTS_CHAR,IMAGE,SHOW_IN_PANEL,SHORTCUT_CHAR,AUTO_INVOKE, SHOW_CONFIRM, DISPLAY_MODE, LINE_NO, LINK_ID,REC_SPECIFIC FROM OBJ_LINKS WHERE OBJ_NAME='" + objName + "' ";
                if (E12GenericUtility.checkNull(formNo).length() > 0) {
                    mQuery = String.valueOf(mQuery) + "AND FORM_NO = '" + formNo + "'";
                }
                mQuery = String.valueOf(mQuery) + " ORDER BY LINE_NO ";
                BaseLogger.log("3", userInfo, null, "Query for link data[" + mQuery + "]");
                mStmt = mConnection.createStatement();
                mRs = mStmt.executeQuery(mQuery);
                objFormsLinkDetailList = new ArrayList();
                while (mRs.next()) {
                    formNo = mRs.getString("FORM_NO");
                    String colName = mRs.getString("FIELD_NAME");
                    String targtObj = mRs.getString("TARGET_OBJ_NAME");
                    String name = E12GenericUtility.checkNull(mRs.getString("LINK_FORM_NAME"));
                    String title = mRs.getString("LINK_TITLE");
                    String uri = mRs.getString("LINK_URI");
                    String type = mRs.getString("LINK_TYPE");
                    String arg = mRs.getString("LINK_ARG");
                    String flag = mRs.getString("UPDATE_FLAG");
                    String rightsChar = mRs.getString("RIGHTS_CHAR");
                    String image = mRs.getString("IMAGE");
                    String showInPanel = mRs.getString("SHOW_IN_PANEL");
                    String shortcutChar = mRs.getString("SHORTCUT_CHAR");
                    String autoInvoke = mRs.getString("AUTO_INVOKE");
                    String showConfirm = mRs.getString("SHOW_CONFIRM");
                    String displayMode = mRs.getString("DISPLAY_MODE");
                    String lineNo = mRs.getString("LINE_NO");
                    String linkid = mRs.getString("LINK_ID");
                    String recordSpecific = mRs.getString("REC_SPECIFIC");
                    if (formNo == null || formNo.equalsIgnoreCase("null") || formNo.length() == 0) {
                        formNo = null;
                    }
                    if (colName == null || colName.equalsIgnoreCase("null") || colName.length() == 0) {
                        colName = null;
                    }
                    if (targtObj == null || targtObj.equalsIgnoreCase("null") || targtObj.length() == 0) {
                        targtObj = null;
                    }
                    if (name == null || name.equalsIgnoreCase("null") || name.length() == 0) {
                        name = null;
                    }
                    if (title == null || title.equalsIgnoreCase("null") || title.length() == 0) {
                        title = null;
                    }
                    if (uri == null || uri.equalsIgnoreCase("null") || uri.length() == 0) {
                        uri = null;
                    }
                    if (type == null || type.equalsIgnoreCase("null") || type.length() == 0) {
                        arg = null;
                    }
                    if (arg == null || arg.equalsIgnoreCase("null") || arg.length() == 0) {
                        flag = null;
                    }
                    if (rightsChar == null || rightsChar.equalsIgnoreCase("null") || rightsChar.length() == 0) {
                        rightsChar = null;
                    }
                    if (image == null || image.equalsIgnoreCase("null") || image.length() == 0) {
                        image = null;
                    }
                    if (showInPanel == null || showInPanel.equalsIgnoreCase("null") || showInPanel.length() == 0) {
                        showInPanel = null;
                    }
                    if (shortcutChar == null || shortcutChar.equalsIgnoreCase("null") || shortcutChar.length() == 0) {
                        shortcutChar = null;
                    }
                    if (autoInvoke == null || autoInvoke.equalsIgnoreCase("null") || autoInvoke.length() == 0) {
                        autoInvoke = null;
                    }
                    if (showConfirm == null || showConfirm.equalsIgnoreCase("null") || showConfirm.length() == 0) {
                        showConfirm = null;
                    }
                    if (displayMode == null || displayMode.equalsIgnoreCase("null") || displayMode.length() == 0) {
                        displayMode = null;
                    }
                    if (lineNo == null || lineNo.equalsIgnoreCase("null") || lineNo.length() == 0) {
                        lineNo = null;
                    }
                    if (strRights.indexOf(rightsChar) == -1 && strRights.indexOf("*") == -1) continue;
                    ArrayList<String> linkInfoFieldList = new ArrayList<String>();
                    linkInfoFieldList.add(formNo);
                    linkInfoFieldList.add(colName);
                    linkInfoFieldList.add(targtObj);
                    linkInfoFieldList.add(name);
                    linkInfoFieldList.add(title);
                    linkInfoFieldList.add(uri);
                    linkInfoFieldList.add(type);
                    linkInfoFieldList.add(arg);
                    linkInfoFieldList.add(flag);
                    linkInfoFieldList.add(rightsChar);
                    linkInfoFieldList.add(image);
                    linkInfoFieldList.add(showInPanel);
                    linkInfoFieldList.add(shortcutChar);
                    linkInfoFieldList.add(autoInvoke);
                    linkInfoFieldList.add(showConfirm);
                    linkInfoFieldList.add(displayMode);
                    linkInfoFieldList.add(lineNo);
                    linkInfoFieldList.add(linkid);
                    linkInfoFieldList.add(recordSpecific);
                    objFormsLinkDetailList.add(linkInfoFieldList);
                    BaseLogger.log("3", userInfo, null, "linkInfoFieldList [" + linkInfoFieldList + "]");
                    BaseLogger.log("3", userInfo, null, "objFormsLinkDetailList [" + objFormsLinkDetailList + "]");
                }
            }
            catch (ITMException itme) {
                System.err.println("ITMException: DBAccess: getElemItemChangeList:");
                throw itme;
            }
            catch (Exception e) {
                System.err.println("Exception: DBAccess: getElemItemChangeList:" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mRs != null) {
                    mRs.close();
                    mRs = null;
                }
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
                if (commConn != null) {
                    commConn.close();
                    commConn = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception: DBAccess: getElemItemChangeList \n" + e);
                throw new ITMException(e);
            }
        }
        return objFormsLinkDetailList;
    }

    private String saveValuesInDB(String userInfoStr) throws RemoteException, ITMException {
        BaseLogger.log("2", null, null, "Calling saveValuesInDB .....");
        String statusStr = "";
        Connection con = null;
        String transDB = null;
        try {
            try {
                UserInfoBean userInfo = new UserInfoBean(userInfoStr);
                transDB = userInfo.getTransDB();
                ConnDriver conDriver = new ConnDriver();
                con = conDriver.getConnectDB(transDB);
                con.setAutoCommit(false);
                int rec = -1;
                int formCtr = 1;
                this.setFormMetaInfo(this.objName, formCtr, userInfo);
                NodeList formDetList = this.dataDom.getElementsByTagName("Detail" + formCtr);
                int formDetListLen = formDetList.getLength();
                int detCtr = 0;
                while (detCtr < formDetListLen) {
                    Node currDet = formDetList.item(detCtr);
                    this.currPKValues = this.getPKValues(formCtr, currDet);
                    NodeList currDetChildList = currDet.getChildNodes();
                    this.collectValues(currDetChildList, formCtr);
                    rec = this.update(formCtr, userInfoStr);
                    ++detCtr;
                }
                if (rec != -1) {
                    con.commit();
                    statusStr = this.currPKValues;
                }
            }
            catch (ITMException itme) {
                BaseLogger.log("0", null, null, "Exception : LinkControllerEJB:saveValuesInDB :==>\n" + itme);
                throw itme;
            }
            catch (SQLException SQLex) {
                try {
                    SQLex.printStackTrace();
                    BaseLogger.log("0", null, null, "Operation rolling back.........");
                    con.rollback();
                }
                catch (Exception sqe) {
                    BaseLogger.log("0", null, null, "Exception : LinkControllerEJB:saveValuesInDB :==>\n" + sqe);
                    throw new ITMException(sqe);
                }
                BaseLogger.log("0", null, null, "Exception : LinkControllerEJB: saveValuesInDB :==>\n" + SQLex);
                throw new ITMException(SQLex);
            }
            catch (Exception ex) {
                try {
                    con.rollback();
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception :LinkControllerEJB  saveValuesInDB :==>\n" + e);
                    throw new ITMException(e);
                }
                throw new ITMException(ex);
            }
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :Save2DBEJB  saveValuesInDB :==>\n" + e);
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "saveValuesInDB Completed..............\n");
        return statusStr;
    }

    private boolean isPKField(String currElement) {
        boolean isPresent = false;
        try {
            StringTokenizer st = new StringTokenizer(this.currPKNames, ":");
            while (st.hasMoreTokens()) {
                String compareString = st.nextToken();
                if (!compareString.equalsIgnoreCase(currElement)) continue;
                isPresent = true;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :XML2DBEJB:isPKField Method:" + e);
        }
        return isPresent;
    }
}

