/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.sys;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.JMSFollowupActions;
import ibase.webitm.utility.JMSLogger;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class E12APIReInitialize
extends ActionHandlerEJB {
    public String reInitialize(String tranID, String xtraParam, String forcedFlag, String transXmlString, String xmlString1, String xmlString2, String objContext) throws ITMException {
        E12GenericUtility genericUtility = new E12GenericUtility();
        ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
        Connection conn = null;
        BaseLogger.log((String)"3", null, null, (Object)"Inside E12APIReInitialize =>reInitialize  ...");
        BaseLogger.log((String)"3", null, null, (Object)("Inside reInitialize tranId [" + tranID + "]"));
        BaseLogger.log((String)"3", null, null, (Object)("Inside reInitialize xtraParam [" + xtraParam + "]"));
        BaseLogger.log((String)"3", null, null, (Object)("Inside reInitialize forcedFlag [" + forcedFlag + "]"));
        BaseLogger.log((String)"3", null, null, (Object)("Inside reInitialize transXmlString [" + transXmlString + "]"));
        BaseLogger.log((String)"3", null, null, (Object)("Inside reInitialize objContext [" + objContext + "]"));
        Statement pStmt = null;
        ResultSet resultSet = null;
        String objectName = "";
        String refId = "";
        Document detailDom = null;
        boolean isValid = false;
        String responseStr = "";
        boolean isEventFound = false;
        StringBuffer xmlString = new StringBuffer();
        StringBuffer responseStrBuff = new StringBuffer("<?xml version=\"1.0\"?><Root>");
        String transDB = "";
        String errorType = "";
        try {
            try {
                String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParam, "loginCode");
                JMSFollowupActions jmsFollowupActions = new JMSFollowupActions();
                CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userId);
                BaseLogger.log((String)"3", null, null, (Object)("userInfo => [" + userInfo + "]"));
                transDB = userInfo.getTransDB();
                if (transDB == null || transDB.trim().length() == 0) {
                    throw new ITMException(new Exception("Trans DB is null"));
                }
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                BaseLogger.log((String)"3", null, null, (Object)("conn => [" + conn + "]"));
                String query = "SELECT OBJ_NAME,REF_ID,  FROM FOLLOW_UP_ACTIONS_LOGS WHERE TRAN_ID=?";
                pStmt = conn.prepareStatement(query);
                pStmt.setString(1, tranID);
                resultSet = pStmt.executeQuery();
                if (resultSet.next()) {
                    objectName = this.checkNull(resultSet.getString("OBJ_NAME"));
                    refId = this.checkNull(resultSet.getString("REF_ID"));
                }
                BaseLogger.log((String)"3", null, null, (Object)("OBJ NAME [" + objectName + "], refId=[" + refId + "]"));
                xmlString.append("<DocumentRoot>");
                xmlString.append("<description>Datawindow Root</description>");
                xmlString.append("<group0>");
                xmlString.append("<description>Group0 description</description>");
                xmlString.append("<Header0>");
                xmlString.append("genericUtility<description>Header0 members</description>");
                xmlString.append("<detail1>");
                xmlString.append("<obj_name><![CDATA[").append(objectName).append("]]></obj_name>");
                xmlString.append("<tran_id><![CDATA[").append(tranID).append("]]></tran_id>");
                xmlString.append("<ref_id><![CDATA[").append(refId).append("]]></ref_id>");
                xmlString.append("</detail1>");
                xmlString.append("</Header0>");
                xmlString.append("</group0>");
                xmlString.append("</DocumentRoot>");
                String xmlData = xmlString.toString();
                BaseLogger.log((String)"3", null, null, (Object)("xmldata => [" + xmlData + "]"));
                EventManagerEJB eventManager = new EventManagerEJB();
                eventManager.setUserInfo(userInfo);
                isEventFound = eventManager.isEventExist(objectName, "reInitialize_api", userInfo);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("isEventFound[reInitialize_api] gsb =[" + isEventFound + "]"));
                String reInitCtr = null;
                String reInitRemarks = null;
                DBAccessEJB dbAccess = new DBAccessEJB();
                try {
                    reInitCtr = dbAccess.getDBColumnValue("FOLLOW_UP_ACTIONS_LOGS", "RE_INIT_CTR", " TRAN_ID = '" + tranID + "' ", userInfo.getTransDB());
                    reInitRemarks = dbAccess.getDBColumnValue("FOLLOW_UP_ACTIONS_LOGS", "RE_INIT_REMARKS", " TRAN_ID = '" + tranID + "' ", userInfo.getTransDB());
                    reInitCtr = E12GenericUtility.checkNull((String)reInitCtr).equalsIgnoreCase("") ? "1" : String.valueOf(Integer.parseInt(reInitCtr) + 1);
                    LocalDateTime now = LocalDateTime.now();
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yy HH:mm:ss");
                    String formattedDateTime = now.format(formatter);
                    if (E12GenericUtility.checkNull((String)reInitRemarks).equalsIgnoreCase("")) {
                        reInitRemarks = "";
                    }
                    reInitRemarks = reInitRemarks.equalsIgnoreCase("") ? "1. Reinitialized at: " + formattedDateTime + " by: " + userId : String.valueOf(reInitRemarks) + "\n" + reInitCtr + ". Reinitialized at: " + formattedDateTime + " by: " + userId;
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    String exceptionDetails = sw.toString();
                    BaseLogger.log((String)"0", null, null, (Object)("Exception in actionSendJSONData2UNS[" + e.getMessage() + "]\n" + exceptionDetails));
                }
                String action = dbAccess.getDBColumnValue("FOLLOW_UP_ACTIONS_LOGS", "ACTION_NAME", " TRAN_ID = '" + tranID + "' ", userInfo.getTransDB());
                String sql = "SELECT  CONDITIONAL_EXPRESSION, CONDITIONAL_INPUT FROM OBJ_FOLLOWUP_ACT WHERE OBJ_NAME = ? AND ACTION_ID = ?";
                pStmt = conn.prepareStatement(sql);
                pStmt.setString(1, objectName);
                pStmt.setString(2, action);
                resultSet = pStmt.executeQuery();
                JMSLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"JMSFollowupActions.executeFollowupactions() sql executed");
                E12GenericUtility e12GenericUtility = new E12GenericUtility();
                detailDom = e12GenericUtility.parseString(transXmlString);
                JMSLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)(" detailDom:: [" + detailDom + "]"));
                while (resultSet.next()) {
                    JMSLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"JMSFollowupActions.executeFollowupactions() in while");
                    String condnalInput = E12GenericUtility.checkNull((String)resultSet.getString("CONDITIONAL_INPUT"));
                    String condnalExprn = E12GenericUtility.checkNull((String)resultSet.getString("CONDITIONAL_EXPRESSION"));
                    JMSLogger.log((String)"2", (UserInfoBean)userInfo, (String)"", (Object)("In FollowupActions condnalInput:[" + condnalInput + "]"));
                    JMSLogger.log((String)"2", (UserInfoBean)userInfo, (String)"", (Object)("In FollowupActions condnalExprn:[" + condnalExprn + "]"));
                    if (!"".equals(condnalExprn) && !"".equals(condnalInput)) {
                        isValid = this.evaluateExpression(detailDom, objContext, condnalExprn, condnalInput, userInfo);
                        BaseLogger.log((String)"3", null, null, (Object)("isValid value " + isValid));
                    }
                    if (isEventFound && isValid) {
                        BaseLogger.log((String)"3", null, null, (Object)"Inside the isEventFound..");
                        responseStr = eventManager.executeSystemEvent(objectName, "reInitialize_api", null, xmlData, xmlData, xtraParam, null, userInfo);
                        BaseLogger.log((String)"3", null, null, (Object)(" ExecuteSystem response gsb BEFORE adding ctr and remarks tags[" + responseStr + "]"));
                        try {
                            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder builder = factory.newDocumentBuilder();
                            Document document = builder.parse(new ByteArrayInputStream(responseStr.getBytes("UTF-8")));
                            Element reinitializeCtr = document.createElement("RE_INIT_CTR");
                            reinitializeCtr.appendChild(document.createTextNode(reInitCtr));
                            Element reinitializeRemarks = document.createElement("RE_INIT_REMARKS");
                            reinitializeRemarks.appendChild(document.createTextNode(reInitRemarks));
                            document.getDocumentElement().appendChild(reinitializeCtr);
                            document.getDocumentElement().appendChild(reinitializeRemarks);
                            TransformerFactory transformerFactory = TransformerFactory.newInstance();
                            Transformer transformer = transformerFactory.newTransformer();
                            transformer.setOutputProperty("indent", "yes");
                            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            DOMSource source = new DOMSource(document);
                            StringWriter writer = new StringWriter();
                            StreamResult result = new StreamResult(writer);
                            transformer.transform(source, result);
                            responseStr = writer.toString();
                        }
                        catch (Exception e) {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            e.printStackTrace(pw);
                            String exceptionDetails = sw.toString();
                            BaseLogger.log((String)"0", null, null, (Object)("Exception in reinitialize adding ctr and remarks tags......[" + e.getMessage() + "]\n" + exceptionDetails));
                        }
                        BaseLogger.log((String)"3", null, null, (Object)(" ExecuteSystem response gsb AFTER adding ctr and remarks tags[" + responseStr + "]"));
                        if (responseStr == null || responseStr.length() <= 0) continue;
                        if (responseStr.indexOf("<?xml") != -1) {
                            responseStrBuff.append(responseStr.substring(responseStr.indexOf("?>") + 2));
                        } else {
                            responseStrBuff.append(responseStr);
                        }
                        Document doc = genericUtility.getDocument(responseStr);
                        NodeList errorList = doc.getElementsByTagName("error");
                        int errorListLen = errorList.getLength();
                        int errorCtr = 0;
                        while (errorCtr < errorListLen) {
                            errorType = "";
                            errorType = errorList.item(errorCtr).getAttributes().getNamedItem("type").getNodeValue();
                            BaseLogger.log((String)"3", null, null, (Object)(" errorType [" + errorType + "]"));
                            if (errorType != null && "E".equalsIgnoreCase(errorType)) break;
                            ++errorCtr;
                        }
                        if (errorType != null && "E".equalsIgnoreCase(errorType)) {
                            jmsFollowupActions.updateFollwUpActionData(tranID, transDB, "1", "X", responseStr);
                            BaseLogger.log((String)"3", null, null, (Object)(" error updated in database [" + responseStr + "]"));
                            continue;
                        }
                        jmsFollowupActions.updateFollwUpActionData(tranID, transDB, "1", "S", responseStr);
                        BaseLogger.log((String)"3", null, null, (Object)("ApiReinitialize sucessfully updated in database[" + tranID + "]"));
                        responseStr = itmDBAccessEJB.getErrorString("", "REINTLZ", userId, "", conn);
                        continue;
                    }
                    responseStr = itmDBAccessEJB.getErrorString("", "EVNTNOTFND", userId, "", conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException ex) {
                BaseLogger.log((String)"3", null, null, (Object)ex.getMessage());
            }
        }
        BaseLogger.log((String)"3", null, null, (Object)(" responseStr => [" + responseStr + "]"));
        return responseStr;
    }

    public String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private boolean evaluateExpression(Document detailDom, String objContext, String condnalExprn, String condnalInput, UserInfoBean userInfo) throws ITMException {
        boolean result = false;
        E12GenericUtility e12GenericUtility = new E12GenericUtility();
        try {
            JMSLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In evaluateExpression Conditional Expression : [" + condnalExprn + "]"));
            if (condnalExprn != null && condnalExprn.length() > 0) {
                ScriptEngineManager manager = new ScriptEngineManager();
                ScriptEngine scriptEngine = manager.getEngineByName("js");
                if (condnalInput != null && condnalInput.length() > 0) {
                    JMSLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In evaluateExpression Conditional Input : [" + condnalInput + "]"));
                    String[] condnalInputArr = condnalInput.split(",");
                    int i = 0;
                    while (i < condnalInputArr.length) {
                        String formNo = "";
                        String fieldName = "";
                        String inputStr = E12GenericUtility.checkNull((String)condnalInputArr[i]);
                        JMSLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In evaluateExpression inputStr : [" + inputStr + "]"));
                        if (inputStr.indexOf(":") != -1) {
                            formNo = inputStr.substring(0, inputStr.indexOf(":"));
                            fieldName = inputStr.substring(inputStr.indexOf(":") + 1);
                        } else {
                            formNo = "1";
                            fieldName = inputStr;
                        }
                        JMSLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In evaluateExpression formNo : [" + formNo + "]"));
                        JMSLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In evaluateExpression objContext : [" + objContext + "]"));
                        JMSLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In evaluateExpression fieldName : [" + fieldName + "]"));
                        String fieldValue = "";
                        fieldValue = formNo.equals(objContext) ? e12GenericUtility.getColumnValue(fieldName, detailDom, formNo) : e12GenericUtility.getColumnValue(fieldName, detailDom, formNo);
                        JMSLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In evaluateExpression fieldValue : [" + fieldValue + "]"));
                        scriptEngine.put(fieldName, fieldValue);
                        ++i;
                    }
                    result = (Boolean)scriptEngine.eval(condnalExprn);
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        JMSLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In evaluateExpression Conditional Expression result : [" + result + "]"));
        return result;
    }
}

