/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.WriteFldMapping;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XLSWriter {
    String objName = null;
    E12GenericUtility genericUtility = new E12GenericUtility();

    public String writeXML2XLS(String xlsFile, String xmlDataFile, String metaDataXML, ServletOutputStream outputStream) throws Exception {
        WriteFldMapping fldMapping = new WriteFldMapping();
        String errStr = null;
        String xmlData = null;
        FileInputStream inStream = null;
        inStream = new FileInputStream(metaDataXML);
        WriteFldMapping fldMap = null;
        fldMap = new WriteFldMapping();
        fldMap.readXML(inStream);
        ArrayList sheetList = fldMap.getSheetList();
        FileOutputStream fileOutputStream = new FileOutputStream(xlsFile);
        HSSFWorkbook workbook = new HSSFWorkbook();
        int noOfSheets = 0;
        noOfSheets = sheetList.size();
        int index = 0;
        while (index < noOfSheets) {
            WriteFldMapping.Sheet xlsSheet = null;
            xlsSheet = (WriteFldMapping.Sheet)sheetList.get(index);
            if (workbook.getSheet(xlsSheet.name) == null) {
                HSSFSheet hSSFSheet = workbook.createSheet(xlsSheet.name);
            }
            ++index;
        }
        Document dom = null;
        Object dom2 = null;
        String errString = "";
        try {
            xmlData = xmlDataFile;
            if (xmlData != null && xmlData.trim().length() > 0) {
                dom = this.genericUtility.parseString(xmlData);
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (sheetList.size() > 0) {
            this.writeHeader(dom, workbook, (WriteFldMapping.Sheet)sheetList.get(0));
        }
        ArrayList labels = null;
        labels = fldMap.getHeadingLabels();
        this.writeDetail(dom, workbook, (WriteFldMapping.Sheet)sheetList.get(1));
        workbook.write((OutputStream)outputStream);
        ((OutputStream)fileOutputStream).close();
        fileOutputStream = null;
        return errStr;
    }

    private String writeHeader(Document dom, HSSFWorkbook workbook, WriteFldMapping.Sheet sheet) throws Exception {
        String errStr = null;
        ArrayList mappingList = null;
        String objContext = null;
        String sheetName = null;
        String vOffset = null;
        String hOffset = null;
        Object fldSrc = null;
        String destLocation = null;
        String destLabel = null;
        String locx = null;
        String locy = null;
        String labelLocX = null;
        String labelLocY = null;
        mappingList = sheet.mappingList;
        objContext = sheet.objCtx;
        sheetName = sheet.name;
        vOffset = sheet.vOffset;
        hOffset = sheet.hOffset;
        HSSFSheet xlsSheet = null;
        xlsSheet = workbook.getSheet(sheetName);
        if (xlsSheet == null) {
            errStr = "VTNOSHEET";
            return errStr;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        int mappingListLen = mappingList.size();
        WriteFldMapping.MappingRec rec = null;
        String fldName = null;
        String fldValue = null;
        NodeList nLst = dom.getElementsByTagName("Detail1");
        Node hdrNode = nLst.item(0);
        int index = 0;
        while (index < mappingListLen) {
            rec = (WriteFldMapping.MappingRec)mappingList.get(index);
            fldName = rec.fldSrc;
            fldValue = this.genericUtility.getColumnValueFromNode(fldName, hdrNode);
            dataMap.put(fldName, fldValue);
            ++index;
        }
        index = 0;
        while (index < mappingListLen) {
            rec = (WriteFldMapping.MappingRec)mappingList.get(index);
            fldName = rec.fldSrc;
            fldValue = (String)dataMap.get(fldName);
            destLocation = rec.destLocation;
            destLabel = rec.destLabel;
            locx = rec.locx;
            locy = rec.locy;
            labelLocX = rec.labelLocX;
            labelLocY = rec.labelLocY;
            int locX = 0;
            int locY = 0;
            int lblLocX = 0;
            int lblLocY = 0;
            locx = destLocation.substring(destLocation.indexOf(46) + 1);
            locy = destLocation.substring(0, 1);
            locX = XLSWriter.getColumnIndex(locx);
            locY = Integer.parseInt(locy) - 1;
            lblLocX = XLSWriter.getColumnIndex(labelLocX);
            lblLocY = Integer.parseInt(labelLocY) - 1;
            HSSFRow row = null;
            row = xlsSheet.getRow(locY);
            if (row == null) {
                row = xlsSheet.createRow(locY);
            }
            HSSFCell cell = null;
            cell = row.getCell(locX);
            if (cell == null) {
                cell = row.createCell((int)((short)locX));
            }
            cell.setCellValue(fldValue);
            row = xlsSheet.getRow(lblLocY);
            if (row == null) {
                row = xlsSheet.createRow(lblLocY);
            }
            if ((cell = row.getCell(lblLocX)) == null) {
                cell = row.createCell((int)((short)lblLocX));
            }
            cell.setCellValue(destLabel);
            ++index;
        }
        dataMap.clear();
        dataMap = null;
        errStr = null;
        return null;
    }

    private String writeDetailHdr(ArrayList labels, HSSFSheet xlsSheet) {
        String errStr = null;
        int labelLen = 0;
        String labelStr = null;
        int locx = 0;
        int locy = 0;
        labelLen = labels.size();
        int index = 0;
        while (index < labelLen) {
            WriteFldMapping.HearderLabel rec = null;
            rec = (WriteFldMapping.HearderLabel)labels.get(index);
            labelStr = rec.label;
            locx = XLSWriter.getColumnIndex(rec.locx);
            locy = Integer.parseInt(rec.locy) - 1;
            this.writeCell(labelStr, xlsSheet, locx, locy);
            ++index;
        }
        errStr = null;
        return null;
    }

    private String writeDetail(Document dom, HSSFWorkbook workbook, WriteFldMapping.Sheet sheet) throws Exception {
        String errStr = null;
        ArrayList mappingList = null;
        String objContext = null;
        String sheetName = null;
        String vOffset = null;
        String hOffset = null;
        Object fldSrc = null;
        Object destLocation = null;
        Object destLabel = null;
        String locx = null;
        Object locy = null;
        Object labelLocX = null;
        Object labelLocY = null;
        mappingList = sheet.mappingList;
        objContext = sheet.objCtx;
        sheetName = sheet.name;
        vOffset = sheet.vOffset;
        hOffset = sheet.hOffset;
        HSSFSheet xlsSheet = null;
        xlsSheet = workbook.getSheet(sheetName);
        if (xlsSheet == null) {
            errStr = "VTNOSHEET";
            return errStr;
        }
        this.writeDetailHdr(sheet.headingLabels, xlsSheet);
        HashMap dataMap = new HashMap();
        int mappingListLen = mappingList.size();
        WriteFldMapping.MappingRec rec = null;
        String fldName = null;
        String fldValue = null;
        NodeList nLst = dom.getElementsByTagName("Detail" + objContext);
        Node node = null;
        int nodeListLen = nLst.getLength();
        int index = 0;
        while (index < nodeListLen) {
            node = nLst.item(index);
            int mapIndex = 0;
            while (mapIndex < mappingListLen) {
                rec = (WriteFldMapping.MappingRec)mappingList.get(mapIndex);
                fldName = rec.fldSrc;
                fldValue = this.genericUtility.getColumnValueFromNode(fldName, node);
                locx = rec.destLocation;
                int y = Integer.parseInt(hOffset) + index;
                this.writeCell(fldValue, xlsSheet, XLSWriter.getColumnIndex(locx), y);
                ++mapIndex;
            }
            ++index;
        }
        errStr = null;
        return null;
    }

    private String writeXML2XLS(String xlsFile, String metaDataXML) throws Exception {
        StringBuffer masterXmlString = null;
        FileInputStream inStream = null;
        inStream = new FileInputStream(metaDataXML);
        WriteFldMapping fldMap = null;
        fldMap = new WriteFldMapping();
        fldMap.readXML(inStream);
        ArrayList detailList = new ArrayList();
        detailList = fldMap.getSheetList();
        int detLen = detailList.size();
        String xmlDataStr = new String("");
        this.objName = fldMap.getObjName();
        FileInputStream fileToBeRead = null;
        File excelFile = new File(xlsFile);
        fileToBeRead = new FileInputStream(excelFile);
        HSSFWorkbook workbook = null;
        workbook = new HSSFWorkbook((InputStream)fileToBeRead);
        int detIndex = 0;
        while (detIndex < detLen) {
            ArrayList mappingList = null;
            String objContext = null;
            String sheetName = null;
            String vOffset = null;
            String hOffset = null;
            WriteFldMapping.Sheet sheet = (WriteFldMapping.Sheet)detailList.get(detIndex);
            mappingList = sheet.mappingList;
            objContext = sheet.objCtx;
            sheetName = sheet.name;
            vOffset = sheet.vOffset;
            hOffset = sheet.hOffset;
            xmlDataStr = String.valueOf(xmlDataStr) + this.getXMLData(workbook, sheet);
            ++detIndex;
        }
        masterXmlString = new StringBuffer();
        masterXmlString.append("<DocumentRoot>");
        masterXmlString.append("<description>").append("Datawindow Root").append("</description>");
        masterXmlString.append("<group0>");
        masterXmlString.append("<description>").append("Group0 description").append("</description>");
        masterXmlString.append("<Header0>");
        masterXmlString.append("<objName><![CDATA[").append(this.objName).append("]]></objName>");
        masterXmlString.append("<pageContext><![CDATA[").append("2").append("]]></pageContext>");
        masterXmlString.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
        masterXmlString.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
        masterXmlString.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
        masterXmlString.append("<action><![CDATA[").append("SAVE").append("]]></action>");
        masterXmlString.append("<elementName><![CDATA[").append("").append("]]></elementName>");
        masterXmlString.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
        masterXmlString.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
        masterXmlString.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
        masterXmlString.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
        masterXmlString.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
        masterXmlString.append("<description>").append("Header0 members").append("</description>");
        masterXmlString.append(xmlDataStr);
        masterXmlString.append("\n\t\t</Header0>");
        masterXmlString.append("\n\t</group0>");
        masterXmlString.append("\n</DocumentRoot>");
        Object rec = null;
        ((InputStream)inStream).close();
        inStream = null;
        return masterXmlString.toString();
    }

    private String getXMLData(HSSFWorkbook workbook, WriteFldMapping.Sheet sheet) throws Exception {
        ArrayList mappingList = null;
        String objContext = null;
        String sheetName = null;
        int vOffset = 0;
        int hOffset = 0;
        String tagStr = null;
        Object fldName = null;
        String value = null;
        Object xmlDataStr = null;
        StringBuffer rowStrBuff = new StringBuffer();
        boolean colCount = false;
        boolean rowCount = false;
        Object cellValueStr = null;
        mappingList = sheet.mappingList;
        objContext = sheet.objCtx;
        sheetName = sheet.name;
        vOffset = Integer.parseInt(sheet.vOffset);
        hOffset = Integer.parseInt(sheet.hOffset);
        HSSFSheet xlsSheet = null;
        xlsSheet = workbook.getSheet(sheetName);
        int colIndex = 0;
        int lastRowNo = xlsSheet.getLastRowNum();
        int objCtx = Integer.parseInt(objContext);
        int startRow = hOffset - 1;
        while (startRow < lastRowNo) {
            int mappingLen = mappingList.size();
            StringBuffer contextBuff = new StringBuffer();
            contextBuff.append("\n\t\t<Detail" + objContext + " dbID=\"\" domID=\"" + (startRow - hOffset + 2) + "\" objName=\"" + this.objName + "\" objContext=\"1\">");
            contextBuff.append("<attribute pkNames=\"\" status=\"N\" updateFlag=\"A\" selected=\"N\"/>");
            contextBuff.append("<tran_id/>");
            rowStrBuff.append(contextBuff.toString());
            int mappingIndex = 0;
            while (mappingIndex < mappingLen) {
                WriteFldMapping.MappingRec rec = null;
                rec = (WriteFldMapping.MappingRec)mappingList.get(mappingIndex);
                int rowNo = 0;
                String colName = null;
                String fldDestination = null;
                if (rec.fldSrc.indexOf(46) == -1) {
                    colName = rec.fldSrc;
                } else {
                    rowNo = Integer.parseInt(rec.fldSrc.substring(0, rec.fldSrc.indexOf(46)));
                    colName = rec.fldSrc.substring(rec.fldSrc.indexOf(46) + 1);
                }
                fldDestination = rec.destLocation;
                colIndex = XLSWriter.getColumnIndex(colName);
                HSSFRow row = null;
                row = xlsSheet.getRow(objCtx == 1 ? rowNo : startRow);
                HSSFCell cell = null;
                cell = row.getCell(colIndex);
                value = null;
                if (colIndex != -1 && (cell = row.getCell(colIndex)) != null) {
                    switch (cell.getCellType()) {
                        case NUMERIC: {
                            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                value = XLSWriter.getDateInFormat(cell.getDateCellValue(), "dd/MM/yy");
                                break;
                            }
                            value = Double.toString(cell.getNumericCellValue());
                            break;
                        }
                        case STRING: {
                            value = cell.getStringCellValue();
                            break;
                        }
                        case BLANK: {
                            value = cell.getStringCellValue();
                            break;
                        }
                        case BOOLEAN: {
                            break;
                        }
                        case ERROR: {
                            break;
                        }
                        case FORMULA: {
                            value = cell.getCellFormula();
                            break;
                        }
                        default: {
                            if (!HSSFDateUtil.isCellDateFormatted((Cell)cell)) break;
                            value = cell.getDateCellValue().toString();
                        }
                    }
                }
                Object vStr = null;
                tagStr = "\n\t\t\t<" + fldDestination.toLowerCase() + ">" + (value == null ? "" : value.trim()) + "</" + fldDestination.toLowerCase() + ">";
                rowStrBuff.append(tagStr);
                ++mappingIndex;
            }
            rowStrBuff.append("\n\t\t</Detail" + objContext + ">");
            if (objCtx == 1) break;
            ++startRow;
        }
        return rowStrBuff.toString();
    }

    public static int getColumnIndex(String colName) {
        int colNo = 0;
        if (colName == null || colName.trim().length() == 0) {
            return -1;
        }
        colName = colName.toUpperCase();
        int len = 0;
        len = colName.trim().length();
        if (len == 1) {
            colNo = colName.charAt(0) - 65;
        }
        if (len == 2) {
            char firstChar = colName.charAt(0);
            char secondChar = colName.charAt(1);
            colNo = 26 * (1 + (firstChar - 65)) + (secondChar - 65);
        }
        return colNo;
    }

    public String writeToFile(String xlsFile, String metaDataXML, String fileName) {
        String toBeWrittenStr = null;
        String errCode = null;
        try {
            this.nfFileOpen(fileName, toBeWrittenStr);
        }
        catch (Exception ex) {
            errCode = "VTFLEWERR";
            ex.printStackTrace();
        }
        return errCode == null || errCode.trim().length() == 0 ? "VTFLESUCC" : errCode;
    }

    private String nfFileOpen(String asFilepath, String asString) {
        String lsErrcode = null;
        File ediFile = null;
        OutputStreamWriter ediFileWtr = null;
        try {
            try {
                ediFile = new File(asFilepath);
                ediFileWtr = new FileWriter(ediFile, true);
                int liLen = asString.length();
                if (ediFile == null) {
                    lsErrcode = "VBFILEOPEN";
                }
                String lsWrite = asString;
                char[] writeCharArr = new char[lsWrite.length()];
                lsWrite.getChars(0, lsWrite.length(), writeCharArr, 0);
                ediFileWtr.write(writeCharArr);
            }
            catch (Exception ex) {
                lsErrcode = "VFLEIOERR";
                ex.printStackTrace();
                try {
                    ediFileWtr.close();
                    ediFileWtr = null;
                    ediFile = null;
                }
                catch (Exception e) {
                    lsErrcode = "VEFCLERR";
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                ediFileWtr.close();
                ediFileWtr = null;
                ediFile = null;
            }
            catch (Exception e) {
                lsErrcode = "VEFCLERR";
                e.printStackTrace();
            }
        }
        return lsErrcode;
    }

    private void writeCell(String data, HSSFSheet xlsSheet, int x, int y) {
        HSSFRow row = null;
        row = xlsSheet.getRow(y);
        if (row == null) {
            row = xlsSheet.createRow(y);
        }
        HSSFCell cell = null;
        cell = row.getCell(x);
        if (cell == null) {
            cell = row.createCell((int)((short)x));
        }
        cell.setCellValue(data);
    }

    public String getDataXmlStr(String fileName) throws Exception {
        StringBuffer sBuff = new StringBuffer();
        FileReader fro = new FileReader(fileName);
        BufferedReader bro = new BufferedReader(fro);
        String stringFromFile = null;
        stringFromFile = bro.readLine();
        sBuff.append(stringFromFile);
        while (stringFromFile != null) {
            stringFromFile = bro.readLine();
            sBuff.append("\n" + stringFromFile);
        }
        bro.close();
        return sBuff.toString();
    }

    private static String getDateInFormat(java.util.Date date, String format) {
        String currDate = null;
        java.util.Date dt = null;
        SimpleDateFormat sdf = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
            dt = date;
            sdf = new SimpleDateFormat(format);
            currDate = sdf.format(dt).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return currDate;
    }

    public HSSFWorkbook exportToExcel(String xmlFileName) {
        return this.exportToExcel(xmlFileName, false);
    }

    public HSSFWorkbook exportToExcel(String xmlFileName, boolean isRCP) {
        ArrayList outerList = new ArrayList();
        ArrayList<String> innerList = new ArrayList<String>();
        ArrayList<String> headerRow = new ArrayList<String>();
        ArrayList<String> listOfXmlFiles = XLSWriter.stringToArrayList(xmlFileName);
        try {
            int ctr = 0;
            while (ctr < listOfXmlFiles.size()) {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document doc = null;
                doc = isRCP ? docBuilder.parse(new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "xmldatafiles" + File.separator + listOfXmlFiles.get(ctr))) : docBuilder.parse(new File(String.valueOf(CommonConstants.RIA_HDR_DATA_XMLFILE) + File.separator + listOfXmlFiles.get(ctr)));
                doc.getDocumentElement().normalize();
                BaseLogger.log("3", null, null, "Root element of the doc is :\" " + doc.getDocumentElement().getNodeName() + "\"");
                NodeList listOfDetail = doc.getElementsByTagName("Detail1");
                int totalDetail = listOfDetail.getLength();
                BaseLogger.log("3", null, null, "Total no of Detail : " + totalDetail);
                int i = 0;
                while (i < totalDetail) {
                    Node firstDetailNode = listOfDetail.item(i);
                    if (firstDetailNode.getNodeType() == 1) {
                        Element firstDetailElement = (Element)firstDetailNode;
                        NodeList detailList = firstDetailElement.getChildNodes();
                        int detailListlength = detailList.getLength();
                        BaseLogger.log("3", null, null, "detailListlength == " + detailListlength);
                        innerList = null;
                        innerList = new ArrayList();
                        int j = 0;
                        while (j < detailListlength) {
                            String nodeName;
                            Node detailNodeElement = detailList.item(j);
                            if (detailNodeElement.getNodeType() == 1 && !(nodeName = detailNodeElement.getNodeName()).equals("attribute")) {
                                NodeList childNodeList;
                                Element nodeValueElement;
                                NodeList textList;
                                if (ctr == 0 && i == 0) {
                                    headerRow.add(nodeName);
                                }
                                if ((textList = (nodeValueElement = (Element)(childNodeList = firstDetailElement.getElementsByTagName(nodeName)).item(0)).getChildNodes()) != null && textList.item(0) != null && textList.item(0).getNodeValue() != null) {
                                    innerList.add(textList.item(0).getNodeValue().trim());
                                } else {
                                    innerList.add("");
                                }
                            }
                            ++j;
                        }
                        outerList.add(innerList);
                    }
                    ++i;
                }
                ++ctr;
            }
        }
        catch (FileNotFoundException fnf) {
            BaseLogger.log("0", null, null, "XML file is not available in the Header Data File.");
            fnf.printStackTrace();
            return null;
        }
        catch (SAXParseException err) {
            BaseLogger.log("0", null, null, "** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            BaseLogger.log("0", null, null, " " + err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        HSSFWorkbook workbook = null;
        HSSFSheet sheet = null;
        try {
            workbook = new HSSFWorkbook();
            sheet = workbook.createSheet("Sample sheet");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Unable to create workbook");
        }
        LinkedHashMap<String, String[]> data = new LinkedHashMap<String, String[]>();
        int i = 0;
        while (i < outerList.size()) {
            ArrayList temp = (ArrayList)outerList.get(i);
            String[] tempString = temp.toArray(new String[temp.size()]);
            data.put(String.valueOf(i), tempString);
            ++i;
        }
        HSSFCellStyle cellStyle = sheet.getWorkbook().createCellStyle();
        HSSFFont font = sheet.getWorkbook().createFont();
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFont((Font)font);
        int cellNumHeader = 0;
        HSSFRow rowHeader = sheet.createRow(0);
        int i2 = 0;
        while (i2 < headerRow.size()) {
            Cell cell = rowHeader.createCell(cellNumHeader++);
            cell.setCellStyle((CellStyle)cellStyle);
            cell.setCellValue((String)headerRow.get(i2));
            ++i2;
        }
        Set keyset = data.keySet();
        int rownum = 1;
        for (String key : keyset) {
            HSSFRow row = sheet.createRow(rownum++);
            String[] objArr = (String[])data.get(key);
            int cellnum = 0;
            String[] stringArray = objArr;
            int n = objArr.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                Cell cell = row.createCell(cellnum++);
                cell.setCellValue(obj.toString());
                ++n2;
            }
        }
        int i3 = 0;
        while (i3 < headerRow.size()) {
            sheet.autoSizeColumn(i3);
            ++i3;
        }
        return workbook;
    }

    public XSSFWorkbook exportToExcelXlsx(String xmlFileName, boolean isRCP, HashMap<String, String> visibleFieldsVlaueMap, String dispOnlyVisibleFlds, HashMap<String, String> displayVlaueMap, HashMap<String, Integer> columnAlignmentMap) {
        ArrayList outerList = new ArrayList();
        ArrayList<String> innerList = new ArrayList<String>();
        ArrayList<String> headerRow = new ArrayList<String>();
        HashMap<Integer, Integer> colAlignmentMap = new HashMap<Integer, Integer>();
        Integer alignValue = 1;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            doc = isRCP ? docBuilder.parse(new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "xmldatafiles" + File.separator + xmlFileName)) : docBuilder.parse(new File(String.valueOf(CommonConstants.RIA_HDR_DATA_XMLFILE) + File.separator + xmlFileName));
            doc.getDocumentElement().normalize();
            NodeList listOfDetail = doc.getElementsByTagName("Detail1");
            int totalDetail = listOfDetail.getLength();
            BaseLogger.log("3", null, null, "Total no of Detail : " + totalDetail);
            int i = 0;
            while (i < totalDetail) {
                Node firstDetailNode = listOfDetail.item(i);
                if (firstDetailNode.getNodeType() == 1) {
                    Element firstDetailElement = (Element)firstDetailNode;
                    NodeList detailList = firstDetailElement.getChildNodes();
                    int detailListlength = detailList.getLength();
                    BaseLogger.log("3", null, null, "detailListlength == " + detailListlength);
                    innerList = null;
                    innerList = new ArrayList();
                    int j = 0;
                    while (j < detailListlength) {
                        Node detailNodeElement = detailList.item(j);
                        if (detailNodeElement.getNodeType() == 1) {
                            String nodeName = detailNodeElement.getNodeName();
                            BaseLogger.log("3", null, null, "nodeName929>>" + nodeName + "dispOnlyVisibleFlds>>" + dispOnlyVisibleFlds);
                            if ("1".equals(dispOnlyVisibleFlds)) {
                                BaseLogger.log("3", null, null, "if dispOnlyVisibleFlds>>");
                                boolean visibleFlag = false;
                                if (visibleFieldsVlaueMap.get(nodeName) != null) {
                                    visibleFlag = true;
                                }
                                if (i == 0 && visibleFlag && !"attribute".equalsIgnoreCase(nodeName)) {
                                    alignValue = columnAlignmentMap.get(nodeName);
                                    alignValue = alignValue != null ? alignValue : 1;
                                    BaseLogger.log("3", null, null, "if alignValue2>>nodeName[" + nodeName + "][" + (j - 1) + "]aalignValue[" + alignValue + "]");
                                    colAlignmentMap.put(j - 1, alignValue);
                                    if (displayVlaueMap.get(nodeName) == null || displayVlaueMap.get(nodeName).equalsIgnoreCase("")) {
                                        headerRow.add(nodeName);
                                    } else {
                                        headerRow.add(displayVlaueMap.get(nodeName));
                                    }
                                }
                                if (visibleFlag && !"attribute".equalsIgnoreCase(nodeName)) {
                                    NodeList childNodeList = firstDetailElement.getElementsByTagName(nodeName);
                                    Element nodeValueElement = (Element)childNodeList.item(0);
                                    NodeList textList = nodeValueElement.getChildNodes();
                                    if (textList != null && textList.item(0) != null && textList.item(0).getNodeValue() != null) {
                                        innerList.add(textList.item(0).getNodeValue().trim());
                                    } else {
                                        innerList.add("");
                                    }
                                }
                            } else {
                                if (i == 0 && !"attribute".equalsIgnoreCase(nodeName)) {
                                    alignValue = columnAlignmentMap.get(nodeName);
                                    alignValue = alignValue != null ? alignValue : 1;
                                    BaseLogger.log("3", null, null, "if alignValue4>>nodeName[" + nodeName + "][" + (j - 1) + "]aalignValue[" + alignValue + "]");
                                    colAlignmentMap.put(j - 1, alignValue);
                                    if (displayVlaueMap.get(nodeName) == null || displayVlaueMap.get(nodeName).equalsIgnoreCase("")) {
                                        headerRow.add(nodeName);
                                    } else {
                                        headerRow.add(displayVlaueMap.get(nodeName));
                                    }
                                }
                                if (!"attribute".equalsIgnoreCase(nodeName)) {
                                    NodeList childNodeList = firstDetailElement.getElementsByTagName(nodeName);
                                    Element nodeValueElement = (Element)childNodeList.item(0);
                                    NodeList textList = nodeValueElement.getChildNodes();
                                    if (textList != null && textList.item(0) != null && textList.item(0).getNodeValue() != null) {
                                        innerList.add(textList.item(0).getNodeValue().trim());
                                    } else {
                                        innerList.add("");
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                    BaseLogger.log("3", null, null, "innerList961>>" + innerList);
                    outerList.add(innerList);
                }
                ++i;
            }
        }
        catch (FileNotFoundException fnf) {
            BaseLogger.log("0", null, null, "XML file is not available in the Header Data File.");
            fnf.printStackTrace();
            return null;
        }
        catch (SAXParseException err) {
            BaseLogger.log("0", null, null, "** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            BaseLogger.log("0", null, null, " " + err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        XSSFWorkbook workbook = null;
        XSSFSheet sheet = null;
        try {
            workbook = new XSSFWorkbook();
            sheet = workbook.createSheet("Sample sheet");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Unable to create workbook");
        }
        LinkedHashMap<String, String[]> data = new LinkedHashMap<String, String[]>();
        int i = 0;
        while (i < outerList.size()) {
            ArrayList temp = (ArrayList)outerList.get(i);
            String[] tempString = temp.toArray(new String[temp.size()]);
            data.put(String.valueOf(i), tempString);
            ++i;
        }
        XSSFCellStyle cellStyle = sheet.getWorkbook().createCellStyle();
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFont((Font)font);
        try {
            int cellNumHeader = 0;
            XSSFRow rowHeader = sheet.createRow(0);
            int i2 = 0;
            while (i2 < headerRow.size()) {
                Cell cell = rowHeader.createCell(cellNumHeader++);
                cell.setCellStyle((CellStyle)cellStyle);
                cell.setCellValue((String)headerRow.get(i2));
                ++i2;
            }
            Set keyset = data.keySet();
            XSSFCellStyle dataCellStyle = sheet.getWorkbook().createCellStyle();
            int rownum = 1;
            for (String key : keyset) {
                XSSFRow row = sheet.createRow(rownum++);
                String[] objArr = (String[])data.get(key);
                int cellnum = 0;
                String[] stringArray = objArr;
                int n = objArr.length;
                int n2 = 0;
                while (n2 < n) {
                    String obj = stringArray[n2];
                    int alignment = colAlignmentMap.get(cellnum) != null ? (Integer)colAlignmentMap.get(cellnum) : 1;
                    Cell cell = row.createCell(cellnum++);
                    if (alignment == 1) {
                        try {
                            double dummy = Double.parseDouble(obj.toString());
                            cell.setCellValue(dummy);
                        }
                        catch (Exception e) {
                            cell.setCellValue(obj);
                        }
                    } else {
                        dataCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                        XSSFCellStyle cellStyle1 = dataCellStyle;
                        cell.setCellStyle((CellStyle)cellStyle1);
                        cell.setCellValue(obj.toString());
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("3", null, null, "Ecxeption at 1083" + e.getMessage());
        }
        int i3 = 0;
        while (i3 < headerRow.size()) {
            sheet.autoSizeColumn(i3);
            ++i3;
        }
        return workbook;
    }

    public HSSFWorkbook downLoadTemplate(String objName, String userId, String objContext, String pageContext, String pkName, String pkValues, HSSFWorkbook workbook, UserInfoBean userInfo) throws Exception {
        BaseLogger.log("2", userInfo, null, "pkName--[" + pkName + "]--pkValues--[" + pkValues + "]--objName--[" + objName + "]--userId--[" + userId + "]--objContext--[" + objContext + "]--pageContext--[" + pageContext + "]");
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        String transDB = userInfo.getTransDB();
        conn = connDriver.getConnectDB(transDB);
        E12GenericUtility genericUtility = new E12GenericUtility();
        workbook = new HSSFWorkbook();
        ArrayList<String> totalFormsAl = this.getFormDetails(conn, objName);
        String defaultPathForMetadataXML = "";
        DWObject dw = null;
        String profileIdRes = "";
        String fileName = "";
        if (userInfo != null) {
            profileIdRes = userInfo.getProfileIdRes();
        }
        BaseLogger.log("3", userInfo, null, "Inside exportToExcel profileIdRes - [" + profileIdRes + "]");
        String editor = "WebEditor";
        BaseLogger.log("3", userInfo, null, "Inside exportToExcel editor - [" + editor + "]");
        BaseLogger.log("3", userInfo, null, "Inside exportToExcel pageContext - [" + pageContext + "]");
        profileIdRes = this.checkNull(profileIdRes);
        BaseLogger.log("3", userInfo, null, "profileIdRes - [" + profileIdRes + "]");
        try {
            DWFactory dws = new DWFactory(userInfo);
            int i = 0;
            while (i < totalFormsAl.size()) {
                String formNo = "" + (i + 1);
                dw = dws.getDataWindow(objName, "2", formNo);
                HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
                if (userInfo != null) {
                    propEditorInfoMap.put("PROFILE_ID_RES", userInfo.getProfileIdRes());
                    propEditorInfoMap.put("ENTERPRISE_ID_RES", userInfo.getEnterprise());
                    propEditorInfoMap.put("EDITOR", editor);
                    propEditorInfoMap.put("USER_ID", userInfo.getLoginCode());
                }
                defaultPathForMetadataXML = genericUtility.getMetaDataFilePath(objName, formNo, pageContext, "", propEditorInfoMap, userInfo.getTransDB());
                dw = new DWObject(defaultPathForMetadataXML, userInfo);
                dw.getColumnsList();
                String tableName = dw.getTableToBeUpdated();
                Hashtable updateColMap = dw.getNonEditableLogPhyColNames();
                BaseLogger.log("3", userInfo, null, "tableName----" + tableName);
                ArrayList<String> updatableColList = new ArrayList<String>();
                for (Object keyObject : updateColMap.keySet()) {
                    updatableColList.add(keyObject.toString().trim());
                }
                this.getAllColumnDtl(conn, tableName, pkName, pkValues, totalFormsAl.get(i), workbook, genericUtility, updatableColList);
                ++i;
            }
            BaseLogger.log("3", userInfo, null, "Success....................");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workbook;
    }

    private ArrayList<String> getFormDetails(Connection conn, String objName) {
        ArrayList<String> fromDtlArrayList = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT TITLE FROM OBJ_FORMS WHERE WIN_NAME = ? ORDER BY TO_NUMBER(FORM_NO)";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, "w_" + objName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                fromDtlArrayList.add(rs.getString(1));
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception in getFormCount " + e.getMessage());
        }
        BaseLogger.log("2", null, null, "fromDtlArrayList - [" + fromDtlArrayList + "]");
        return fromDtlArrayList;
    }

    private void getAllColumnDtl(Connection conn, String tableName, String pkName, String pkValues, String title, HSSFWorkbook workbook, E12GenericUtility genericUtility, ArrayList<String> updatableColList) {
        HSSFSheet sheet = workbook.createSheet(title);
        int rowNo = 0;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = " SELECT * FROM " + tableName;
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                int colCount = rsmd.getColumnCount();
                BaseLogger.log("3", null, null, "Non editable field list :::[" + updatableColList + "]");
                HSSFRow row = sheet.createRow(rowNo++);
                int counter = 0;
                int colNo = 1;
                while (colNo <= colCount) {
                    String colName = rsmd.getColumnName(colNo);
                    if (updatableColList.contains((colName = colName.toUpperCase()).toLowerCase())) {
                        Cell cell = row.createCell(counter);
                        cell.setCellValue(colName);
                        ++counter;
                    }
                    ++colNo;
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (this.checkNull(pkName).length() > 0 && this.checkNull(pkValues).length() > 0) {
                    PreparedStatement pStatment = null;
                    ResultSet rSet = null;
                    BaseLogger.log("3", null, null, "pkName--------------" + pkName);
                    String sqlQuery = " SELECT * FROM " + tableName + " WHERE ";
                    if (pkName.contains(":")) {
                        pkValues = pkValues.substring(0, pkValues.lastIndexOf(":,"));
                        pkValues = pkValues.replaceAll(":,", ":");
                        String[] pkNameArr = pkName.split(":");
                        String[] pkValuesArr = pkValues.split(":");
                        String wherePart = "";
                        int i = 0;
                        while (i < pkNameArr.length) {
                            String pkValues1 = "";
                            int j = i;
                            while (j < pkValuesArr.length) {
                                pkValues1 = String.valueOf(pkValues1) + "'" + pkValuesArr[j] + "',";
                                ++j;
                                ++j;
                            }
                            wherePart = String.valueOf(wherePart) + pkNameArr[i] + " IN ( " + pkValues1.substring(0, pkValues1.length() - 1) + ") AND ";
                            ++i;
                        }
                        wherePart = wherePart.substring(0, wherePart.length() - 4);
                        sqlQuery = sqlQuery.concat(wherePart);
                        BaseLogger.log("3", null, null, "sqlQuery---------------------" + sqlQuery);
                    } else {
                        pkValues = pkValues.replace(":,", "','");
                        pkValues = "'" + pkValues + "'";
                        pkValues = pkValues.substring(0, pkValues.lastIndexOf(",'"));
                        sqlQuery = " SELECT * FROM " + tableName + " WHERE " + pkName + " IN ( " + pkValues + ") ";
                    }
                    pStatment = conn.prepareStatement(sqlQuery);
                    rSet = pStatment.executeQuery();
                    ResultSetMetaData rsmdata = rSet.getMetaData();
                    int colCount1 = rsmdata.getColumnCount();
                    BaseLogger.log("3", null, null, "no of column : " + colCount1);
                    while (rSet.next()) {
                        row = sheet.createRow(rowNo++);
                        counter = 0;
                        int colNo2 = 1;
                        while (colNo2 <= colCount1) {
                            String colName = rsmdata.getColumnName(colNo2);
                            String values = rSet.getString(colNo2);
                            String dataTypes = rsmdata.getColumnTypeName(colNo2).toUpperCase();
                            if (this.checkNull(values).length() > 0 && this.checkNull(dataTypes).length() > 0) {
                                java.util.Date currDate;
                                if ("DATE".equalsIgnoreCase(dataTypes)) {
                                    currDate = rSet.getDate(colNo2);
                                    values = currDate != null ? genericUtility.getValidDateString(((Date)currDate).toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()) : null;
                                } else if ("DATETIME".equalsIgnoreCase(dataTypes)) {
                                    currDate = rSet.getTimestamp(colNo2);
                                    values = currDate != null ? genericUtility.getValidDateTimeString((Timestamp)currDate, genericUtility.getApplDateFormat()) : null;
                                } else if ("TIMESTAMP".equalsIgnoreCase(dataTypes)) {
                                    currDate = rSet.getTimestamp(colNo2);
                                    if (currDate != null) {
                                        values = currDate != null ? genericUtility.getValidDateTimeString(((Timestamp)currDate).toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()) : null;
                                    }
                                } else if ("TIME".equalsIgnoreCase(dataTypes) && (currDate = rSet.getTimestamp(colNo2)) != null) {
                                    String string = values = currDate != null ? genericUtility.getValidDateTimeString((Timestamp)currDate, genericUtility.getDisplayTimeFormat()) : null;
                                }
                            }
                            if (updatableColList.contains(colName.toLowerCase())) {
                                Cell cell = row.createCell(counter);
                                cell.setCellValue(values);
                                ++counter;
                            }
                            ++colNo2;
                        }
                    }
                    rSet.close();
                    rSet = null;
                    pStatment.close();
                    pStatment = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception :allColumnInfo " + e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :allColumnInfo " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private static ArrayList<String> stringToArrayList(String input) {
        BaseLogger.log("3", null, null, "stringToArrayList " + input);
        String[] elements = input.split(", ");
        BaseLogger.log("3", null, null, "stringToArrayList elements " + input.substring(1, input.length() - 1).split(", "));
        ArrayList<String> result = new ArrayList<String>(elements.length);
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            result.add(String.valueOf(item));
            ++n2;
        }
        return result;
    }

    public HSSFWorkbook exportToExcelFile(String xmlString) {
        ArrayList outerList = new ArrayList();
        ArrayList<String> innerList = new ArrayList<String>();
        ArrayList<String> headerRow = new ArrayList<String>();
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document doc = genericUtility.parseString(xmlString);
            doc.getDocumentElement().normalize();
            BaseLogger.log("3", null, null, "Root element of the doc is :\" " + doc.getDocumentElement().getNodeName() + "\"");
            NodeList listOfDetail = doc.getElementsByTagName("Detail1");
            int totalDetail = listOfDetail.getLength();
            BaseLogger.log("3", null, null, "Total no of Detail : " + totalDetail);
            int i = 0;
            while (i < totalDetail) {
                Node firstDetailNode = listOfDetail.item(i);
                if (firstDetailNode.getNodeType() == 1) {
                    Element firstDetailElement = (Element)firstDetailNode;
                    NodeList detailList = firstDetailElement.getChildNodes();
                    int detailListlength = detailList.getLength();
                    BaseLogger.log("3", null, null, "detailListlength == " + detailListlength);
                    innerList = null;
                    innerList = new ArrayList();
                    int j = 0;
                    while (j < detailListlength) {
                        String nodeName;
                        Node detailNodeElement = detailList.item(j);
                        if (detailNodeElement.getNodeType() == 1 && !(nodeName = detailNodeElement.getNodeName()).equals("attribute")) {
                            NodeList childNodeList;
                            Element nodeValueElement;
                            NodeList textList;
                            if (i == 0) {
                                headerRow.add(nodeName);
                            }
                            if ((textList = (nodeValueElement = (Element)(childNodeList = firstDetailElement.getElementsByTagName(nodeName)).item(0)).getChildNodes()) != null && textList.item(0) != null && textList.item(0).getNodeValue() != null) {
                                innerList.add(textList.item(0).getNodeValue().trim());
                            } else {
                                innerList.add("");
                            }
                        }
                        ++j;
                    }
                    outerList.add(innerList);
                }
                ++i;
            }
        }
        catch (Exception t) {
            BaseLogger.log("3", null, null, "Exception in exportToExcelFile::" + t.getMessage());
            t.printStackTrace();
        }
        HSSFWorkbook workbook = null;
        HSSFSheet sheet = null;
        try {
            workbook = new HSSFWorkbook();
            sheet = workbook.createSheet("Sample sheet");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Unable to create workbook");
        }
        LinkedHashMap<String, String[]> data = new LinkedHashMap<String, String[]>();
        int i = 0;
        while (i < outerList.size()) {
            ArrayList temp = (ArrayList)outerList.get(i);
            String[] tempString = temp.toArray(new String[temp.size()]);
            data.put(String.valueOf(i), tempString);
            ++i;
        }
        HSSFCellStyle cellStyle = sheet.getWorkbook().createCellStyle();
        HSSFFont font = sheet.getWorkbook().createFont();
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFont((Font)font);
        int cellNumHeader = 0;
        HSSFRow rowHeader = sheet.createRow(0);
        int i2 = 0;
        while (i2 < headerRow.size()) {
            Cell cell = rowHeader.createCell(cellNumHeader++);
            cell.setCellStyle((CellStyle)cellStyle);
            cell.setCellValue((String)headerRow.get(i2));
            ++i2;
        }
        Set keyset = data.keySet();
        int rownum = 1;
        for (String key : keyset) {
            HSSFRow row = sheet.createRow(rownum++);
            String[] objArr = (String[])data.get(key);
            int cellnum = 0;
            String[] stringArray = objArr;
            int n = objArr.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                Cell cell = row.createCell(cellnum++);
                cell.setCellValue(obj.toString());
                ++n2;
            }
        }
        int i3 = 0;
        while (i3 < headerRow.size()) {
            sheet.autoSizeColumn(i3);
            ++i3;
        }
        return workbook;
    }
}

