package ibase.webitm.utility;
import org.json.JSONObject;

import ibase.utility.BaseLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONException;

import ibase.webitm.ejb.DBAccessEJB;
import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;

import java.sql.Connection;
import ibase.utility.UserInfoBean;
import org.json.JSONObject;


public class PopHelpServiceUtility {
	
	private UserInfoBean userInfo = null;
	DBAccessEJB dbAccessEJB = new DBAccessEJB();


	//public String getPophelpData(String fieldName, String modName, String tokenIDfromHeader) 
//	{
//	    BaseLogger.log("3", null, null, "Inside the getUserCodeservice():");
//	    PreparedStatement pstmt = null;
//	    ResultSet resultSet = null;
//	    JSONArray jsonArray = new JSONArray();
//
//	    if (userInfo == null) {
//	        APIUtility apiUtility = new APIUtility();
//	        userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
//	        String transDB = userInfo.getTransDB();
//	        BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + transDB + "]");
//	    }
//
//	    Connection conn = null;
//	    ConnDriver connDriver = new ConnDriver();
//	    try {
//	        conn = connDriver.getConnectDB("Driver");
//
//	        String sqlStr = dbAccessEJB.getDBColumnValue("POPHELP", "SQL_STR", "FIELD_NAME = '" + fieldName + "' AND MOD_NAME = '" + modName + "'", userInfo.getTransDB());
//	        
//	        BaseLogger.log("3", null, null, "SQL QUERY IS [ " + sqlStr + "]");
//
//	        pstmt = conn.prepareStatement(sqlStr);
//	        resultSet = pstmt.executeQuery();
//
//	        ResultSetMetaData rsmd = resultSet.getMetaData();
//	        int columnCount = rsmd.getColumnCount();
//	        BaseLogger.log("3", null, null, "columnCount IS [ " + columnCount + "]");
//
//
//	        while (resultSet.next()) {
//	            JSONObject jsonObject = new JSONObject();
//	            for (int i = 1; i <= columnCount; i++) {
//	                String columnName = rsmd.getColumnName(i);
//	    	        BaseLogger.log("3", null, null, "columnName IS:: [ " + columnCount + "]");
//
//	                jsonObject.put(columnName, resultSet.getString(columnName));
//	            }
//	            jsonArray.put(jsonObject);
//	        }
//
//	        return jsonArray.toString();
//	    } catch (Exception e) {
//	        e.printStackTrace();
//	        BaseLogger.log("3", null, null, "Exception IS:: [ " + e + "]");
//
//	        return null;
//	    }  finally {
//	        try {
//	            if (resultSet != null) resultSet.close();
//	            if (pstmt != null) pstmt.close();
//	            if (conn != null) conn.close();
//	        } catch (SQLException e) {
//	            e.printStackTrace();
//	        }
//	    }
//	}
	
	public String getPophelpData(String fieldName, String modName, String tokenIDfromHeader) {
	    BaseLogger.log("3", null, null, "Inside the getPophelpData():");
	    PreparedStatement pstmt = null;
	    ResultSet resultSet = null;
	    JSONArray jsonArray = new JSONArray();

	    if (userInfo == null) {
	        APIUtility apiUtility = new APIUtility();
	        userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
	        String transDB = userInfo.getTransDB();
	        BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + transDB + "]");
	    }

	    Connection conn = null;
	    ConnDriver connDriver = new ConnDriver();
	    try {
	        conn = connDriver.getConnectDB("Driver");

	        String sqlStr = dbAccessEJB.getDBColumnValue("POPHELP", "SQL_STR", "FIELD_NAME = '" + fieldName + "' AND MOD_NAME = '" + modName + "'", userInfo.getTransDB());
	        BaseLogger.log("3", null, null, "SQL QUERY IS [ " + sqlStr + "]");

	        if (sqlStr.contains("?")) {
	            // SQL query contains placeholders, retrieve the corresponding input values
	            String sqlInputStr = dbAccessEJB.getDBColumnValue("POPHELP", "SQL_INPUT", "FIELD_NAME = '" + fieldName + "' AND MOD_NAME = '" + modName + "'", userInfo.getTransDB());
	            BaseLogger.log("3", null, null, "SQL INPUT VALUES IS [ " + sqlInputStr + "]");
           //sqlInputStr = this value is take from DOM  , sqlInputStr = Tag Name
	            pstmt = conn.prepareStatement(sqlStr);

	            // Set parameters using the values obtained from the POPHELP table
	            String[] sqlInputs = sqlInputStr.split(",");
	            for (int i = 0; i < sqlInputs.length; i++) {
	                pstmt.setString(i + 1, sqlInputs[i].trim());
	            }
	        } 
	        
	        else {
	            pstmt = conn.prepareStatement(sqlStr);
	        }

	        resultSet = pstmt.executeQuery();

	        ResultSetMetaData rsmd = resultSet.getMetaData();
	        int columnCount = rsmd.getColumnCount();
	        BaseLogger.log("3", null, null, "columnCount IS [ " + columnCount + "]");

	        while (resultSet.next()) {
	            JSONObject jsonObject = new JSONObject();
	            for (int i = 1; i <= columnCount; i++) {
	                String columnName = rsmd.getColumnName(i);
	                BaseLogger.log("3", null, null, "columnName IS:: [ " + columnName + "]");
	                jsonObject.put(columnName, resultSet.getString(columnName));
	            }
	            jsonArray.put(jsonObject);
	        }

	        return jsonArray.toString();
	    } catch (Exception e) {
	        e.printStackTrace();
	        BaseLogger.log("3", null, null, "Exception IS:: [ " + e.getMessage() + "]");
	        return null;
	    } finally {
	        try {
	            if (resultSet != null) resultSet.close();
	            if (pstmt != null) pstmt.close();
	            if (conn != null) conn.close();
	        } catch (SQLException e) {
	            e.printStackTrace();
	            BaseLogger.log("3", null, null, "SQLException in finally block IS:: [ " + e.getMessage() + "]");
	        }
	    }
	}

}
