/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.ai.entityid.AIEngine;
import ibase.ai.entityid.DocumentProcessTrail;
import ibase.ai.entityid.ItemLookUp;
import ibase.ai.entityid.RasaAIEngine;
import ibase.ai.entityid.WitAIEngine;
import ibase.bis.utility.BISDictionary;
import ibase.hibernate.dao.DocTypeProcDAO;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ItemChangeUtility;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class InvoiceReader {
    String templatePath;
    File invoiceFile;
    String docProcTrailData = "";
    private String procStatus = "I";
    private String ocrData = "";
    String viewData = "";

    public String getDocProcTrailData() {
        return this.docProcTrailData;
    }

    public void setDocProcTrailData(String docProcTrailData) {
        this.docProcTrailData = docProcTrailData;
    }

    public String getProcStatus() {
        return this.procStatus;
    }

    public void setProcStatus(String procStatus) {
        this.procStatus = procStatus;
    }

    public String getOcrData() {
        return this.ocrData;
    }

    public void setOcrData(String ocrData) {
        this.ocrData = ocrData;
    }

    public String getOverViewData() {
        return this.viewData;
    }

    public void setOverViewData(String viewData) {
        this.viewData = viewData;
    }

    public InvoiceReader() {
    }

    public InvoiceReader(File invoiceFile) {
        this.invoiceFile = invoiceFile;
        String fileSeperator = File.separator;
        this.templatePath = String.valueOf(CommonConstants.getBIHOME()) + fileSeperator + "server" + fileSeperator + "default" + fileSeperator + "deploy" + fileSeperator + "ibase.ear" + fileSeperator + "ibase.war" + fileSeperator + "webitm" + fileSeperator + "InvoiceTemplate";
    }

    public String readInvoice(UserInfoBean userInfo, String extractTempl) throws ITMException {
        return this.readInvoice(userInfo, extractTempl, true);
    }

    public String readInvoice(UserInfoBean userInfo, String extractTempl, boolean itemCodeRequired) throws ITMException {
        return this.readInvoice(userInfo, extractTempl, true, "", "", "", "");
    }

    public String readInvoice(UserInfoBean userInfo, String extractTempl, boolean itemCodeRequired, String docType, String entType, String entCode, String objName) throws ITMException {
        DocTypeProcDAO docTypeProcDAO;
        DBAccessEJB dbAccess;
        JSONObject overviewData;
        JSONObject extractedData;
        E12GenericUtility genericUtility;
        DocumentProcessTrail docProcTrail;
        String currentReqParamTrail;
        String currentProcessMtd;
        JSONObject procTrailObj;
        ArrayList<Object> apiKeyParams;
        JSONObject docTypeProcObj;
        String errMessage;
        String procApiName;
        String procApiScope;
        String extData;
        block47: {
            BaseLogger.log("3", null, null, "InvoiceReader readInvoice() extractTempl[" + extractTempl + "],itemCodeRequired[" + itemCodeRequired + "]");
            extData = "";
            String procApiKey = "";
            procApiScope = "";
            procApiName = "";
            errMessage = "";
            docTypeProcObj = new JSONObject();
            apiKeyParams = new ArrayList();
            procTrailObj = new JSONObject();
            currentProcessMtd = "";
            currentReqParamTrail = "";
            docProcTrail = new DocumentProcessTrail();
            genericUtility = new E12GenericUtility();
            extractedData = new JSONObject();
            overviewData = new JSONObject();
            String viewData = "";
            dbAccess = new DBAccessEJB();
            docTypeProcDAO = new DocTypeProcDAO();
            if (this.invoiceFile.exists()) break block47;
            BaseLogger.log("3", null, null, "InvoiceReader readInvoice() file not exist");
            return "";
        }
        try {
            String dataExtractorService;
            String fileName = this.invoiceFile.getName();
            String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
            APIUtility apiUtility = new APIUtility();
            docTypeProcObj = docTypeProcDAO.getDocTypeProcParams(userInfo, docType, entType, entCode, fileType.toUpperCase());
            apiKeyParams = apiUtility.getAPIKey(userInfo, docTypeProcObj.optString("proc_mtd"));
            docTypeProcObj.put("extract_templ", (Object)extractTempl);
            docTypeProcObj.put("objName", (Object)objName);
            docTypeProcObj.put("userId", (Object)userInfo.getLoginCode());
            docTypeProcObj.put("enterprise", (Object)userInfo.getEnterprise());
            docTypeProcObj.put("site_code", (Object)userInfo.getSiteCode());
            if (!apiKeyParams.isEmpty() && apiKeyParams.size() > 0) {
                docTypeProcObj.put("proc_api_key", apiKeyParams.get(0));
            }
            docTypeProcObj.put("IS_OCR_EXIST", (Object)"false");
            if (!apiKeyParams.isEmpty() && apiKeyParams.size() > 1) {
                procApiScope = (String)apiKeyParams.get(1);
            }
            procApiName = docTypeProcObj.optString("proc_mtd");
            String[] procMethods = procApiName.split("-");
            procTrailObj = docProcTrail.createDocTrailJSON(procMethods, procApiName);
            docTypeProcObj.put("file_type", (Object)fileType.toUpperCase());
            String condition = "DOC_TYPE = '" + docType.trim() + "'";
            String encParam = dbAccess.getDBColumnValue("DOC_TYPE", "IMG_ENC_PARAMS", condition, userInfo.getTransDB());
            if (!"".equalsIgnoreCase(E12GenericUtility.checkNull(encParam))) {
                docTypeProcObj.put("enhancement_parameters", (Object)encParam);
            }
            String apiUrl = dataExtractorService = this.getDataExtractorServiceURL();
            String reqParamsStr = docTypeProcObj.toString();
            reqParamsStr = URLEncoder.encode(reqParamsStr, "UTF-8");
            if (extractTempl.length() > 1) {
                dataExtractorService = String.valueOf(dataExtractorService) + "?jsonData=" + reqParamsStr;
            }
            BaseLogger.log("3", null, null, "InvoiceReader readInvoice() final dataExtractorService::" + dataExtractorService);
            currentProcessMtd = procMethods[0];
            JSONObject jsonObject = new JSONObject();
            currentReqParamTrail = "jsonData=" + reqParamsStr;
            String errorJson = E12GenericUtility.checkNull(genericUtility.isRequestLimitExceeded(userInfo.getEnterprise(), "JSON", userInfo));
            BaseLogger.log("3", null, "InvoiceReader.readInvoice()", "errorJson[" + errorJson + "]");
            String result = "";
            int status = 0;
            BaseLogger.log("3", null, null, "171 makeMultipartRequest START [" + System.currentTimeMillis() + "]");
            if ("".equalsIgnoreCase(errorJson)) {
                byte[] response = E12GenericUtility.makeMultipartRequest(dataExtractorService, this.invoiceFile);
                int noOfPages = 1;
                if ("pdf".equalsIgnoreCase(fileType) && this.invoiceFile != null) {
                    FileInputStream pdfFileStream = new FileInputStream(this.invoiceFile);
                    noOfPages = genericUtility.getPDFNumberOfPages(pdfFileStream);
                    ((InputStream)pdfFileStream).close();
                }
                genericUtility.createAIApiLog(userInfo, noOfPages, objName, "OpenAI");
                BaseLogger.log("3", null, null, "173 makeMultipartRequest END [" + System.currentTimeMillis() + "]");
                result = new String(response);
                jsonObject = new JSONObject(result);
                BaseLogger.log("3", null, "InvoiceReader.readInvoice()", "jsonObject[" + jsonObject + "]");
                status = result.indexOf("\"Errors\"") != -1 || result.indexOf("\"error\"") != -1 || result.indexOf("</Errors>") != -1 || result.indexOf("</error>") != -1 ? 0 : jsonObject.getInt("status");
            } else {
                jsonObject = new JSONObject(errorJson);
                BaseLogger.log("3", null, null, "InvoiceReader readInvoice() line no 297 jsonObject::" + jsonObject);
            }
            apiUtility.writeApiCallLog(userInfo, result, "" + status, "", "", reqParamsStr, procApiName, apiUrl, procApiScope, "A", "", "");
            if (status == 1) {
                extractedData = jsonObject.optJSONObject("result");
                String isMandatoryExtracted = extractedData.has("isMandatoryExtracted") ? extractedData.optString("isMandatoryExtracted") : "true";
                String ocrData = "";
                if (extractedData.has("OCR_DATA")) {
                    ocrData = extractedData.optString("OCR_DATA");
                    this.setOcrData(ocrData.toString());
                }
                procTrailObj.put(procMethods[0], (Object)docProcTrail.setProcTrailJSON(procApiName, ocrData, currentReqParamTrail, ""));
                String string = currentProcessMtd = procMethods.length > 1 ? procMethods[1] : currentProcessMtd;
                if ("true".equalsIgnoreCase(isMandatoryExtracted)) {
                    ItemLookUp itemLookup;
                    JSONObject jsonItemCodes;
                    AIEngine aiEngine;
                    String queryParamStr = "";
                    if (procMethods.length > 1 && procMethods[1].contains("AI")) {
                        JSONObject templateObj;
                        String isTempExtracted;
                        String templateData;
                        String csvData = extractedData.optString("EXTRACT_LAYOUT_DATA");
                        if (extractedData.has("EXTRACT_TEMPLATE_DATA") && !"false".equalsIgnoreCase(templateData = extractedData.optString("EXTRACT_TEMPLATE_DATA")) && !"".equalsIgnoreCase(templateData) && "true".equalsIgnoreCase(isTempExtracted = (templateObj = new JSONObject(templateData)).optString("isTemplateExtracted"))) {
                            String exEntCode = templateObj.optString("ent_code");
                            String exEntType = templateObj.optString("ent_type");
                            String exEntName = templateObj.optString("ent_name");
                            String keyword1 = E12GenericUtility.checkNull(templateObj.optString("keyword1"));
                            String keyword2 = E12GenericUtility.checkNull(templateObj.optString("keyword2"));
                            JSONObject exdocTypeProcObj = docTypeProcDAO.getDocTypeProcParams(userInfo, docType, exEntType, exEntCode, fileType.toUpperCase());
                            docTypeProcObj.put("ent_type", (Object)exEntType);
                            docTypeProcObj.put("ent_code", (Object)exEntCode);
                            docTypeProcObj.put("ent_name", (Object)exEntName);
                            docTypeProcObj.put("keyword1", (Object)exdocTypeProcObj.optString("keyword1"));
                            docTypeProcObj.put("keyword2", (Object)exdocTypeProcObj.optString("keyword2"));
                            docTypeProcObj.put("proc_mtd", (Object)exdocTypeProcObj.optString("proc_mtd"));
                            docTypeProcObj.put("ai_proc_templ", (Object)exdocTypeProcObj.optString("ai_proc_templ"));
                            if (exdocTypeProcObj.optString("ai_proc_variables") != null) {
                                String aiProcVariables = exdocTypeProcObj.optString("ai_proc_variables");
                                JSONObject aiProcVariablesObj = new JSONObject(aiProcVariables);
                                JSONArray aiProcVariableArr = aiProcVariablesObj.optJSONArray("Details");
                                int i = 0;
                                while (i < aiProcVariableArr.length()) {
                                    JSONObject object = aiProcVariableArr.optJSONObject(i);
                                    if (templateObj.has(object.optString("name"))) {
                                        String value = templateObj.optString(object.optString("name"));
                                        object.put("defaultValue", (Object)value);
                                    }
                                    ++i;
                                }
                                docTypeProcObj.put("ai_proc_variables", (Object)aiProcVariablesObj);
                            }
                            docTypeProcObj.put("IS_OCR_EXIST", (Object)"true");
                            if (!procApiName.equalsIgnoreCase(exdocTypeProcObj.optString("proc_mtd"))) {
                                return this.readInvoice(userInfo, extractTempl, itemCodeRequired, docType, exEntType, exEntCode, objName);
                            }
                            currentReqParamTrail = docTypeProcObj.toString();
                            docTypeProcObj.put("OCR_DATA", (Object)ocrData);
                            queryParamStr = docTypeProcObj.toString();
                            queryParamStr = URLEncoder.encode(queryParamStr, "UTF-8");
                            String dataExtractorServiceURL = String.valueOf(this.getDataExtractorServiceURL()) + "?jsonData=" + queryParamStr;
                            BaseLogger.log("3", null, null, "215 makeMultipartRequest START [" + System.currentTimeMillis() + "]");
                            byte[] byteResp = E12GenericUtility.makeMultipartRequest(dataExtractorServiceURL, this.invoiceFile);
                            BaseLogger.log("3", null, null, "217 makeMultipartRequest END [" + System.currentTimeMillis() + "]");
                            String pyResponse = new String(byteResp);
                            BaseLogger.log("3", null, null, "InvoiceReader.readInvoice() pyResponse [" + pyResponse + "]");
                            JSONObject exJSONObject = new JSONObject(pyResponse);
                            extractedData = exJSONObject.optJSONObject("result");
                            csvData = extractedData.optString("EXTRACT_LAYOUT_DATA");
                        }
                        procTrailObj.put(procMethods[1], (Object)docProcTrail.setProcTrailJSON(procApiName, csvData, currentReqParamTrail, ""));
                        currentProcessMtd = procMethods.length > 2 ? procMethods[2] : currentProcessMtd;
                        extractedData = genericUtility.convertCSVToJSON(csvData, userInfo);
                        if ("error".equals(extractedData.optString("status"))) {
                            throw new Exception(extractedData.optString("message"));
                        }
                        if (procMethods.length > 2 && (E12GenericUtility.checkNull(procMethods[2]).equalsIgnoreCase("VIL") || E12GenericUtility.checkNull(procMethods[2]).equalsIgnoreCase("AIL"))) {
                            JSONArray extJsonArray = extractedData.optJSONArray("lines");
                            String aiProcVariables = docTypeProcObj.optString("ai_proc_variables");
                            String queryString = this.pineConeVLookup(extJsonArray, currentProcessMtd, (String)apiKeyParams.get(0), encParam, aiProcVariables, userInfo);
                            BaseLogger.log("3", null, null, "queryString line no 421::::::" + queryString);
                            procTrailObj.put(currentProcessMtd, (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), queryString, ""));
                        }
                        if (procMethods.length > 2 && (E12GenericUtility.checkNull(procMethods[2]).equalsIgnoreCase("IL") || E12GenericUtility.checkNull(procMethods[2]).equalsIgnoreCase("AIL"))) {
                            ItemLookUp itemLookup2 = new ItemLookUp();
                            extractedData = itemLookup2.itemCodeLookUp(extractedData, procMethods, userInfo, docTypeProcObj);
                            procTrailObj.put(currentProcessMtd, (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                        }
                        BaseLogger.log("3", null, null, "InvoiceReader.readInvoice() procApiName : [" + procApiName + "]");
                        if (procApiName.contains("UC")) {
                            procTrailObj.put("UC", (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                        }
                        if (procApiName.contains("IC")) {
                            ItemChangeUtility itemChangeUtility = new ItemChangeUtility();
                            extractedData = itemChangeUtility.executeStateless(extractedData, userInfo, docType);
                            procTrailObj.put("IC", (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                        }
                    } else {
                        extractedData = jsonObject.getJSONObject("result");
                    }
                    BaseLogger.log("3", null, null, "InvoiceReader.readInvoice() extractedData[" + extractedData + "]");
                    String dataJsonStr = extractedData.toString();
                    if (!itemCodeRequired) {
                        BaseLogger.log("3", null, null, "InvoiceReader.readInvoice() hanse itemcode not required returning dataJsonStr:: " + dataJsonStr + "]");
                        return dataJsonStr;
                    }
                    String AIEngineStr = CommonConstants.AI_ENGINE;
                    BaseLogger.log("3", null, null, "postdata dataJsonStr[" + dataJsonStr + "]AIEngineStr[" + AIEngineStr + "]");
                    if (procMethods.length > 2 && "ADW".equalsIgnoreCase(procMethods[2])) {
                        aiEngine = new WitAIEngine();
                        currentProcessMtd = "ADW";
                        result = ((WitAIEngine)aiEngine).getItemCodeList(dataJsonStr, userInfo);
                        currentReqParamTrail = ((WitAIEngine)aiEngine).getProcTrailObj().optString("REQUEST_PARAM");
                        procTrailObj.put("ADW", (Object)((WitAIEngine)aiEngine).getProcTrailObj());
                        BaseLogger.log("3", null, null, "readInvoice GET_ITEM_CODE_LIST WitAIEngine result[" + result + "]");
                        jsonItemCodes = new JSONObject(result);
                        jsonItemCodes = jsonItemCodes.getJSONObject("result");
                        jsonItemCodes = jsonItemCodes.getJSONObject("itemCodeList");
                        BaseLogger.log("3", null, null, "result jsonItemCodes[" + jsonItemCodes + "]");
                        extractedData.put("itemCodeList", (Object)jsonItemCodes);
                        if (procMethods.length > 3 && "IL".equalsIgnoreCase(procMethods[3])) {
                            itemLookup = new ItemLookUp();
                            extractedData = itemLookup.itemCodeLookUp(extractedData, procMethods, userInfo, docTypeProcObj);
                            procTrailObj.put("IL", (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                            if ("UC".equalsIgnoreCase(procMethods[procMethods.length - 1])) {
                                procTrailObj.put("UC", (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                            }
                        }
                    } else if (procMethods.length > 2 && "ADR".equalsIgnoreCase(procMethods[2])) {
                        aiEngine = new RasaAIEngine();
                        currentProcessMtd = "ADR";
                        result = ((RasaAIEngine)aiEngine).getItemCodeList(dataJsonStr, userInfo);
                        currentReqParamTrail = ((RasaAIEngine)aiEngine).getProcTrailObj().optString("REQUEST_PARAM");
                        jsonItemCodes = new JSONObject(result);
                        procTrailObj.put("ADR", (Object)((RasaAIEngine)aiEngine).getProcTrailObj());
                        BaseLogger.log("3", null, null, " rasa result jsonItemCodes[" + jsonItemCodes + "]");
                        extractedData.put("itemCodeList", (Object)jsonItemCodes);
                        if (procMethods.length > 3 && "IL".equalsIgnoreCase(procMethods[3])) {
                            itemLookup = new ItemLookUp();
                            extractedData = itemLookup.itemCodeLookUp(extractedData, procMethods, userInfo, docTypeProcObj);
                            procTrailObj.put("IL", (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                            if ("UC".equalsIgnoreCase(procMethods[procMethods.length - 1])) {
                                procTrailObj.put("UC", (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                            }
                        }
                    }
                    this.setProcStatus("C");
                } else {
                    JSONObject templateObj;
                    String isTempExtracted;
                    String templateData;
                    if (extractedData.has("EXTRACT_TEMPLATE_DATA") && !"false".equalsIgnoreCase(templateData = extractedData.optString("EXTRACT_TEMPLATE_DATA")) && !"".equalsIgnoreCase(templateData) && "true".equalsIgnoreCase(isTempExtracted = (templateObj = new JSONObject(templateData)).optString("isTemplateExtracted"))) {
                        String exEntCode = templateObj.optString("ent_code");
                        String exEntType = templateObj.optString("ent_type");
                        String exEntName = templateObj.optString("ent_name");
                        String keyword1 = E12GenericUtility.checkNull(templateObj.optString("keyword1"));
                        String keyword2 = E12GenericUtility.checkNull(templateObj.optString("keyword2"));
                        JSONObject exdocTypeProcObj = docTypeProcDAO.getDocTypeProcParams(userInfo, docType, exEntType, exEntCode, fileType.toUpperCase());
                        docTypeProcObj.put("ent_type", (Object)exEntType);
                        docTypeProcObj.put("ent_code", (Object)exEntCode);
                        docTypeProcObj.put("ent_name", (Object)exEntName);
                        docTypeProcObj.put("keyword1", (Object)keyword1);
                        docTypeProcObj.put("keyword2", (Object)keyword2);
                    }
                    extractedData = null;
                }
            } else {
                JSONArray errorsArray;
                JSONObject rootObj;
                errMessage = E12GenericUtility.checkNull(jsonObject.optString("error"));
                if ("".equalsIgnoreCase(errMessage) && (rootObj = jsonObject.optJSONObject("Root")) != null && (errorsArray = rootObj.optJSONArray("Errors")) != null) {
                    JSONObject errorObj;
                    JSONObject jSONObject = errorObj = errorsArray.optJSONObject(0) != null ? errorsArray.optJSONObject(0).optJSONObject("error") : null;
                    if (errorObj != null) {
                        result = errorObj.optString("description");
                        currentProcessMtd = procMethods.length > 1 ? procMethods[1] : currentProcessMtd;
                    }
                }
                procTrailObj.put(currentProcessMtd, (Object)docProcTrail.setProcTrailJSON(procApiName, "", currentReqParamTrail, result));
                this.setProcStatus("E");
                BaseLogger.log("3", null, "InvoiceReader.readInvoice()", "Error occurred while extracting data [" + jsonObject.toString() + "]");
            }
        }
        catch (Exception ex) {
            try {
                if ("Invalid Extraction".equalsIgnoreCase(ex.getMessage())) {
                    procTrailObj.put(currentProcessMtd, (Object)docProcTrail.setProcTrailJSON(procApiName, "", currentReqParamTrail, genericUtility.getErrorJson("", "INVEXTRACT", userInfo.getLoginCode())));
                } else {
                    procTrailObj.put(currentProcessMtd, (Object)docProcTrail.setProcTrailJSON(procApiName, "", currentReqParamTrail, genericUtility.writePrintStacktrace(ex)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setProcStatus("E");
            BaseLogger.log("0", null, "InvoiceReader.readInvoice()", "Exception in readInvoice : " + ex);
        }
        try {
            if (extractedData == null) {
                extractedData = new JSONObject();
            }
            if (docTypeProcObj != null) {
                extractedData.put("ent_code", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("ent_code")));
                extractedData.put("ent_name", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("ent_name")));
                String ordType = "";
                if (!"".equalsIgnoreCase(E12GenericUtility.checkNull(docTypeProcObj.optString("ent_code")))) {
                    ordType = docTypeProcDAO.getDistChannel(E12GenericUtility.checkNull(docTypeProcObj.optString("ent_code")), userInfo);
                }
                docTypeProcObj.put("order_type", (Object)ordType);
                overviewData = new JSONObject();
                overviewData.put("doc_type", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("doc_type")));
                overviewData.put("ent_type", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("ent_type")));
                overviewData.put("ent_code", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("ent_code")));
                overviewData.put("ent_name", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("ent_name")));
                overviewData.put("keyword1", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("keyword1")));
                overviewData.put("keyword2", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("keyword2")));
                overviewData.put("order_type", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("order_type")));
                overviewData.put("file_type", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("file_type")));
                overviewData.put("proc_mtd", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("proc_mtd")));
                overviewData.put("ai_proc_templ", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("ai_proc_templ")));
                overviewData.put("ai_proc_variables", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("ai_proc_variables")));
            }
            extData = "".equalsIgnoreCase(E12GenericUtility.checkNull(errMessage)) ? String.valueOf(extractedData) : errMessage;
        }
        catch (Exception e) {
            extData = String.valueOf(new JSONObject());
            BaseLogger.log("0", null, "InvoiceReader.readInvoice()", "catch block : [" + e.getMessage() + "]");
        }
        this.setDocProcTrailData(procTrailObj.toString());
        BaseLogger.log("3", null, "InvoiceReader.readInvoice()", "Extracted data : [" + extData + "]");
        this.setOverViewData(overviewData.toString());
        return extData;
    }

    public String getDataExtractorServiceURL() {
        String dataExtractorServiceURL = null;
        Map<String, Map<String, String>> pythonServicesMap = CommonConstants.EXTRACTION_PYTHON_SERVICES;
        BaseLogger.log("3", null, null, "InvoiceReader readInvoice() getDataExtractorServiceURL pythonServicesMap::" + pythonServicesMap);
        if (pythonServicesMap != null) {
            Map<String, String> proteusSenseServiceDetails = pythonServicesMap.get("DATA_EXTRACTOR");
            String protocol = proteusSenseServiceDetails.get("PROTOCOL");
            String host = proteusSenseServiceDetails.get("HOST");
            String port = E12GenericUtility.checkNull(proteusSenseServiceDetails.get("PORT"));
            String path = proteusSenseServiceDetails.get("ENDPOINT");
            dataExtractorServiceURL = String.format("%s://%s%s/%s", protocol, host, port, path);
        }
        return dataExtractorServiceURL;
    }

    public String pineConeVLookup(JSONArray extJsonArray, String currentProcessMtd, String openAIAPIKey, String encParam, String aiProcVariables, UserInfoBean userInfo) {
        String queryString = "";
        ItemLookUp itemlookup = new ItemLookUp();
        String indexName = "import-orders";
        String lookupParameter = "{\"alpha\":\"0.54\"}";
        try {
            JSONObject prodIdentificationObj = new JSONObject();
            BISDictionary bis = new BISDictionary();
            prodIdentificationObj = bis.getProductIdentificationAlias(userInfo);
            APIUtility apiUtility = new APIUtility();
            if (aiProcVariables != null) {
                JSONObject aiProcVariablesObj = new JSONObject(aiProcVariables);
                JSONArray aiProcVariableArr = aiProcVariablesObj.optJSONArray("Details");
                int i = 0;
                while (i < aiProcVariableArr.length()) {
                    JSONObject object = aiProcVariableArr.optJSONObject(i);
                    if ("index_name".equalsIgnoreCase(object.optString("name"))) {
                        indexName = object.optString("defaultValue");
                    }
                    if ("lookup_parameter".equalsIgnoreCase(object.optString("name"))) {
                        lookupParameter = object.optString("defaultValue");
                    }
                    ++i;
                }
            }
            JSONObject descrObj = new JSONObject();
            int j = 1;
            Field arg = descrObj.getClass().getDeclaredField("map");
            arg.setAccessible(true);
            arg.set(descrObj, new LinkedHashMap());
            arg.setAccessible(false);
            int i = 0;
            while (i < extJsonArray.length()) {
                JSONObject lineObj = extJsonArray.optJSONObject(i);
                lineObj.put("line_no", j);
                String descr = "";
                String packing = "";
                String phyAttr2 = "";
                String phyAttr3 = "";
                String phyAttr4 = "";
                if (!"".equalsIgnoreCase(E12GenericUtility.checkNull(lineObj.optString("extract_descr")))) {
                    descr = E12GenericUtility.checkNull(lineObj.optString("extract_descr"));
                }
                if ("".equals(packing = itemlookup.getValueForAlias(prodIdentificationObj, lineObj.optString("packing"), "packing", lineObj.optString("extract_phy_attrib_1")))) {
                    packing = E12GenericUtility.checkNull(lineObj.optString("packing"));
                }
                if ("".equals(phyAttr2 = itemlookup.getValueForAlias(prodIdentificationObj, lineObj.optString("extract_phy_attrib_2"), "phy_attrib_2", lineObj.optString("extract_phy_attrib_1")))) {
                    phyAttr2 = E12GenericUtility.checkNull(lineObj.optString("extract_phy_attrib_2"));
                }
                if ("".equals(phyAttr3 = itemlookup.getValueForAlias(prodIdentificationObj, lineObj.optString("extract_phy_attrib_3"), "phy_attrib_3", lineObj.optString("extract_phy_attrib_1")))) {
                    phyAttr3 = E12GenericUtility.checkNull(lineObj.optString("extract_phy_attrib_3"));
                }
                if ("".equals(phyAttr4 = itemlookup.getValueForAlias(prodIdentificationObj, lineObj.optString("extract_phy_attrib_4"), "phy_attrib_4", lineObj.optString("extract_phy_attrib_1")))) {
                    phyAttr4 = E12GenericUtility.checkNull(lineObj.optString("extract_phy_attrib_4"));
                }
                String descrConcat = "";
                if (!("".equalsIgnoreCase(descr) || "-".equalsIgnoreCase(descr) || "N/A".equalsIgnoreCase(descr) || "NA".equalsIgnoreCase(descr))) {
                    descrConcat = packing != null && descr.indexOf(packing) == -1 ? String.valueOf(descr) + " " + packing : descr;
                }
                descrObj.put(Integer.toString(j), (Object)descrConcat);
                ++j;
                ++i;
            }
            String pineConeVectorURL = "";
            Map<String, Map<String, String>> pythonServicesMap = CommonConstants.EXTRACTION_PYTHON_SERVICES;
            String serverUrl = "";
            if (pythonServicesMap != null) {
                Map<String, String> proteusSenseServiceDetails = pythonServicesMap.get("DATA_EXTRACTOR");
                String protocol = proteusSenseServiceDetails.get("PROTOCOL");
                String host = proteusSenseServiceDetails.get("HOST");
                String port = E12GenericUtility.checkNull(proteusSenseServiceDetails.get("PORT"));
                String path = apiUtility.getAPIUrl(userInfo, "VectorLookup");
                if (path.contains("WeaviateVector")) {
                    serverUrl = apiUtility.getAPIUrl(userInfo, "WeaviateVector");
                }
                pineConeVectorURL = String.format("%s://%s%s/%s", protocol, host, port, path);
            }
            ArrayList<String> pineConeAPIParams = apiUtility.getAPIKey(userInfo, "PineCone");
            JSONObject configData = new JSONObject();
            configData.put("index_name", (Object)indexName);
            configData.put("lookup_parameter", (Object)lookupParameter);
            configData.put("entity_type", (Object)"item");
            configData.put("server_url", (Object)serverUrl);
            configData.put("openAI_apiKey", (Object)openAIAPIKey);
            configData.put("pineCone_apiKey", (Object)pineConeAPIParams.get(0));
            configData.put("queryJson", (Object)descrObj);
            configData.put("enterprise", (Object)(userInfo != null ? userInfo.getEnterprise() : ""));
            configData.put("site_code", (Object)(userInfo != null ? userInfo.getSiteCode() : ""));
            if (!"".equalsIgnoreCase(E12GenericUtility.checkNull(encParam))) {
                configData.put("enhancement_parameters", (Object)encParam);
            }
            String pineConeConfig = configData.toString();
            ByteArrayInputStream postDataInputStream = null;
            StringBuffer queryParam = new StringBuffer();
            queryParam.append("jsonData=").append(pineConeConfig);
            queryString = queryParam.toString();
            if (queryString != null) {
                postDataInputStream = new ByteArrayInputStream(queryString.getBytes(StandardCharsets.UTF_8));
            }
            BaseLogger.log("3", null, null, "369 makeRequest START [" + System.currentTimeMillis() + "]");
            byte[] responseData = E12GenericUtility.makeRequest(pineConeVectorURL, postDataInputStream, 0, null, "application/json");
            String vLookUpresult = new String(responseData);
            BaseLogger.log("3", null, null, "InvoiceReader.readInvoice() vLookUpresult [" + vLookUpresult + "]");
            JSONObject respObj = new JSONObject(vLookUpresult);
            int i2 = 0;
            while (i2 < extJsonArray.length()) {
                JSONObject tempObject = extJsonArray.optJSONObject(i2);
                String description = tempObject.optString("extract_descr");
                String lineNo = tempObject.optString("line_no");
                if (respObj.has(lineNo)) {
                    JSONObject lookUpDataObj = respObj.optJSONObject(lineNo);
                    String extrId = E12GenericUtility.checkNull(lookUpDataObj.optString("id"));
                    int index = extrId.indexOf("__");
                    if (index != -1) {
                        String exrtItemCode = extrId.substring(0, index);
                        tempObject.put("vector_item_code", (Object)exrtItemCode);
                    } else {
                        tempObject.put("vector_item_code", (Object)E12GenericUtility.checkNull(lookUpDataObj.optString("id")));
                    }
                    tempObject.put("vector_descr", (Object)E12GenericUtility.checkNull(lookUpDataObj.optString("material_description")));
                }
                ++i2;
            }
            BaseLogger.log("3", null, null, "372 makeRequest END [" + System.currentTimeMillis() + "]");
            BaseLogger.log("3", null, null, "InvoiceReader.pineConeVLookup() extJsonArray [" + extJsonArray + "]");
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "InvoiceReader.pineConeVLookup() Exception [" + E12GenericUtility.getStackTrace(e) + "]");
        }
        return queryString;
    }
}

