package ibase.webitm.bean.wsfa;

import ibase.utility.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;

import javax.servlet.http.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import java.io.*;

import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


import ibase.webitm.ejb.wsfa.transactions.WsfaDSRWizardEJB;
//import ibase.webitm.ejb.wsfa.transactions.WsfaPrWizardEJB;
//import ibase.webitm.ejb.wsfa.transactions.WsfaJnjFlmDsrWizardEJB;

public class WsfaDSRWizardBean 
{

	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	
	public WsfaDSRWizardBean( String objName, HttpSession sessionCtx ) throws ITMException
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}
	public WsfaDSRWizardBean( String objName) throws ITMException
	{
		try
		{
			this.objName = objName;
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	public WsfaDSRWizardBean() throws ITMException
	{
	}
	
	public String getSalesPersItemList( String salesPers, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		String itemData = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		try
		{
			/*
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			itmWizardRemoteTemp = (ibase.webitm.ejb.wsfa.transactions.StrgMeetWizardRemote)ctx.lookup("ibase/StrgMeetWizardEJB/remote");
			itemData = itmWizardRemoteTemp.getSalesPersItemList( salesPers, strgCode, selectedItem, eventDate );
			itmWizardRemoteTemp = null;
			*/
			itemData = new WsfaDSRWizardEJB().getSalesPersItemList( salesPers, strgCode, selectedItem, eventDate );
			String xslFileName = getXSLFileName( "wsfa_dsr_pob_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			itemData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			//itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			/*
			if ( itmWizardRemoteTemp != null )
			{
				itmWizardRemoteTemp = null;
			}
			*/
		}
		return itemData;
	
	}
	public String getSalesPersTeamList( String salesPers, String strgCode, String selectedTeam, String workWith ) throws ITMException
	{
		System.out.println("workWith in getSalesPersTeamList =["+workWith+"]");
		String teamData = "";
		try
		{
			teamData = new WsfaDSRWizardEJB().getSalesPersTeamList( salesPers, strgCode, selectedTeam, workWith );
			String xslFileName = getXSLFileName( "strg_meet_team_jnj_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			teamData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			//teamData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			/*
			if ( itmWizardRemoteTemp != null )
			{
				itmWizardRemoteTemp = null;
			}
			*/
		}
		System.out.println("teamData:::"+teamData);
		return teamData;
	}
	
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}

	public String getSalesPersDSRItemList( String salesPers, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		String itemData = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		try
		{
			itemData = new WsfaDSRWizardEJB().getSalesPersItemList( salesPers, strgCode, selectedItem, eventDate );
			String xslFileName = getXSLFileName( "wsfa_jnj_dsr_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			itemData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			//itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
		}
		return itemData;
	
	}
	/*public String getSalesPersDSRItemsPOBList( String salesPers, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		String itemData = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		try
		{
			itemData = new WsfaDSRWizardEJB().getSalesPersDSRItemsPOBList( salesPers, strgCode, selectedItem, eventDate );
			String xslFileName = getXSLFileName( "wsfa_jnj_dsr_itempob_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			itemData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			//itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
		}
		return itemData;
	
	}*/
	//Added by Gaurav Singh on 4-8-2014[START]
	/*public String getMerchDSRItemsPOBList( String salesPers, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		System.out.println(" @@@@@@@@ Inside [getMerchDSRItemsPOBList]@@@@@@@@ BEAN");
		String itemData = "";		
		try
		{
			itemData = new WsfaDSRWizardEJB().getMerchDSRItemsPOBList( salesPers, strgCode, selectedItem, eventDate ); 
			String xslFileName = getXSLFileName( "wsfa_jnj_dsr_merch_itempob_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			itemData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			//itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
		}
		return itemData;
	}*/
	//Added by Gaurav Singh on 4-8-2014[END]
	
	

	private String getErrorMsg(String xmlErrString) 
			throws ITMException,Exception
		{
			DocumentBuilderFactory docBuilderFactory = null;
			DocumentBuilder docBuilder = null;
			Document dom = null;
			NodeList parentNodeList = null;
			NodeList childNodeList = null;
			Node parentNode = null;
			Node childNode = null;
			String childNodeName = "";

			String message = "";
			String description = "";
			String type = "";
			String errString = "";
			InputStream inputStream = null ;
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			ibase.webitm.utility.GenericUtility genericUtility = null;
			//ibase.utility.E12GenericUtility genericUtility = null;
			try
			{
					docBuilderFactory = DocumentBuilderFactory.newInstance();
					docBuilder = docBuilderFactory.newDocumentBuilder();
					System.out.println("ConfirmDARBean :[getErrorMsg] :: xmlErrString :: "+xmlErrString);
					//Commented and Changes done by Gaurav Singh on 03-Sep-14
					genericUtility = ibase.webitm.utility.GenericUtility.getInstance();
					//genericUtility = new ibase.utility.E12GenericUtility();
					dom = genericUtility.parseString(xmlErrString);
					System.out.println("ConfirmDARBean :[getErrorMsg] :: xmlErrString after parsing :: "+dom.toString());
					
					System.out.println("Dom prepared...");
					parentNodeList = dom.getElementsByTagName("error");
					int parentListLength = parentNodeList.getLength();
					for(int prntNo = 0; prntNo < parentListLength ; prntNo++)
					{
						parentNode = parentNodeList.item(prntNo);
						if (parentNode!=null )
						{
							childNodeList = parentNode.getChildNodes();
							if (childNodeList != null && childNodeList.getLength() > 0 )
							{
								int childNodeListLength = childNodeList.getLength();
								for(int ctr = 0; ctr < childNodeListLength; ctr++)
								{
									childNode = childNodeList.item(ctr);
									childNodeName = childNode.getNodeName();
									if (childNode != null && childNode.getFirstChild() != null )
									{
										if (childNodeName.trim().equalsIgnoreCase("message"))
										{
											message = childNode.getFirstChild().getNodeValue();
										}
										if	(childNodeName.trim().equalsIgnoreCase("description")) 
										{
											description = childNode.getFirstChild().getNodeValue();
										}
										if	(childNodeName.trim().equalsIgnoreCase("type")) 
										{
											type = childNode.getFirstChild().getNodeValue();
										}
										errString = "<table border = '0'><tr><td> "+message+"</td></tr><tr><td>Descr :"+description;
										if (type!=null && type.trim().equalsIgnoreCase("E"))
										{
											errString = errString + "</td></tr><tr><td>type : Error</td></tr>" ;
										}
										else if (type!=null && type.trim().equalsIgnoreCase("W"))
										{
											errString = errString + "</td></tr><tr>type : warning</td></tr>";
										}
										errString = errString+"</table>" ;
									}
									
								}
							}					
						}
						
					}
				
			}
			catch (Exception ex)
			{
				ex.printStackTrace();
				throw ex;
			}
			System.out.println("returning errorMsg from getErrorMsg(String xmlErrString): "+errString);
			return errString ;
		}
	/*
	public String getSalesPersPrItemsPOBList( String salesPers, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		String itemData = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		try
		{
			itemData = new WsfaPrWizardEJB().getSalesPersPrItemsPOBList( salesPers, strgCode, selectedItem, eventDate );
			String xslFileName = getXSLFileName( "wsfa_jnj_pr_itempob_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			itemData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			//itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
		}
		return itemData;
	
	}
	//Added by Sneha  on 8-May-14 to get  Jnj Flm Pob and Item List
	public String getSalesPersDSRItemMgrList( String salesPers, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		System.out.println("getSalesPersDSRItemMgrList called...");
		String itemData = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		try
		{
			itemData = new WsfaJnjFlmDsrWizardEJB().getSalesPersItemMgrList( salesPers, strgCode, selectedItem, eventDate );
			String xslFileName = getXSLFileName( "wsfa_jnj_mgr_dsr_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			itemData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			//itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
		}
		return itemData;
	
	}
	
	public String getSalesPersDSRItemsMgrPOBList( String salesPers, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		System.out.println("getSalesPersDSRItemsMgrPOBList called...");
		String itemData = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		try
		{
			
			itemData = new WsfaJnjFlmDsrWizardEJB().getSalesPersDSRItemsPOBMgrList( salesPers, strgCode, selectedItem, eventDate );

			String xslFileName = getXSLFileName( "wsfa_jnj_mgr_dsr_itempob_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			itemData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			//itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
		}
		return itemData;
	
	}*/
	
	//Added by Sneha  on 8-May-14 to get  Jnj Flm Pob and Item List:End
	
	/*public String getSalesPersActivityCodeList( String salesPers, String selectedActCode )
	{
		String activityCodeData = "";
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			activityCodeData = new WsfaDSRWizardEJB().getSalesPersActivityCodeList( salesPers, selectedActCode );

			String xslFileName = getXSLFileName( "wsfa_dsr_act_code_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			activityCodeData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, activityCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			//activityCodeData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, activityCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch ( Exception e  )
		{
			e.printStackTrace();
		}
		finally
		{
		}
		return activityCodeData;
	}*/
	/*public String getMgrActivityCodeList( String salesPers, String selectedActCode )
	{
		String activityCodeData = "";
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			activityCodeData = new WsfaDSRWizardEJB().getMgrActivityCodeList( salesPers, selectedActCode );

			String xslFileName = getXSLFileName( "wsfa_dsr_act_code_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			activityCodeData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, activityCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			//activityCodeData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, activityCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch ( Exception e  )
		{
			e.printStackTrace();
		}
		finally
		{
		}
		return activityCodeData;
	}
	*/
}