/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.hibernate.bean.DocTransLink;
import ibase.hibernate.bean.UserDocContent;
import ibase.hibernate.dao.ContentLibraryDao;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/")
public class ContentLibraryService {
    @Context
    HttpServletRequest request;
    private ContentLibraryDao conLibraryDAO = new ContentLibraryDao();

    @GET
    @Path(value="/UserDocContents")
    @Produces(value={"application/json"})
    public Response getContents(@QueryParam(value="USER_INFO") String userInfoStr) {
        BaseLogger.log((String)"3", null, null, (Object)"Inside getContents of ContentLibraryService");
        JSONObject respJsonObject = new JSONObject();
        String tranDB = "DEFAULT";
        try {
            UserInfoBean userInfo = null;
            if (userInfoStr != null) {
                BaseLogger.log((String)"3", null, null, (Object)("userInfoStr :: " + userInfoStr));
                userInfo = new UserInfoBean(userInfoStr);
            } else {
                userInfo = this.getUserInfo();
            }
            if (userInfo != null) {
                String loginCode = userInfo.getLoginCode();
                tranDB = userInfo.getTransDB();
                List contentList = this.conLibraryDAO.getUserDocContent(loginCode, tranDB);
                BaseLogger.log((String)"3", null, null, (Object)("contentList :: " + contentList));
                if (contentList != null && !contentList.isEmpty()) {
                    HashMap<String, UserDocContent> userDocContentMap = new HashMap<String, UserDocContent>();
                    ArrayList<String> docIdList = new ArrayList<String>();
                    for (UserDocContent userDocContent : contentList) {
                        userDocContentMap.put(userDocContent.getDocId(), userDocContent);
                        docIdList.add(userDocContent.getDocId());
                    }
                    JSONObject jsonObject = this.conLibraryDAO.getUserDocContentsDetails(userDocContentMap, docIdList, tranDB);
                    respJsonObject.put("userDocContents", (Object)jsonObject.optJSONArray("userDocContents"));
                    respJsonObject.put("result", (Object)this.getResponseMessage("Data Loaded Successfully ! ", "Success"));
                    respJsonObject.put("refSerList", (Object)this.conLibraryDAO.getReferences());
                } else {
                    respJsonObject.put("result", (Object)this.getResponseMessage("No Data Found ! ", "Success"));
                    respJsonObject.put("userDocContents", (Collection)contentList);
                }
            } else {
                respJsonObject.put("result", (Object)this.getResponseMessage("Unauthorised Access Denied ! ", "Failure"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @POST
    @Path(value="/UserDocContents")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response getContentsPost(@FormParam(value="USER_INFO") String userInfoStr) {
        BaseLogger.log((String)"3", null, null, (Object)"Inside getContentsPost of ContentLibraryService");
        JSONObject respJsonObject = new JSONObject();
        String tranDB = "DEFAULT";
        try {
            UserInfoBean userInfo = null;
            if (userInfoStr != null) {
                BaseLogger.log((String)"3", null, null, (Object)("userInfoStr :: " + userInfoStr));
                userInfo = new UserInfoBean(userInfoStr);
            } else {
                userInfo = this.getUserInfo();
            }
            if (userInfo != null) {
                String loginCode = userInfo.getLoginCode();
                tranDB = userInfo.getTransDB();
                List contentList = this.conLibraryDAO.getUserDocContent(loginCode, tranDB);
                BaseLogger.log((String)"3", null, null, (Object)("contentList :: " + contentList));
                if (contentList != null && !contentList.isEmpty()) {
                    HashMap<String, UserDocContent> userDocContentMap = new HashMap<String, UserDocContent>();
                    ArrayList<String> docIdList = new ArrayList<String>();
                    for (UserDocContent userDocContent : contentList) {
                        userDocContentMap.put(userDocContent.getDocId(), userDocContent);
                        docIdList.add(userDocContent.getDocId());
                    }
                    JSONObject jsonObject = this.conLibraryDAO.getUserDocContentsDetails(userDocContentMap, docIdList, tranDB);
                    respJsonObject.put("userDocContents", (Object)jsonObject.optJSONArray("userDocContents"));
                    respJsonObject.put("result", (Object)this.getResponseMessage("Data Loaded Successfully ! ", "Success"));
                    respJsonObject.put("refSerList", (Object)this.conLibraryDAO.getReferences());
                } else {
                    respJsonObject.put("result", (Object)this.getResponseMessage("No Data Found ! ", "Success"));
                    respJsonObject.put("userDocContents", (Collection)contentList);
                }
            } else {
                respJsonObject.put("result", (Object)this.getResponseMessage("Unauthorised Access Denied ! ", "Failure"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @POST
    @Path(value="/UserDocContents/{DOC_ID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateContent(@PathParam(value="DOC_ID") String DOC_ID, String userDocData) throws JSONException {
        JSONObject data = new JSONObject(userDocData);
        BaseLogger.log((String)"2", null, null, (Object)("Inside updateUserDocContents/n" + data));
        return Response.status((int)200).entity((Object)this.getResponseMessage("Updated doc item succesfully Successfully", "Success").toString()).build();
    }

    @DELETE
    @Path(value="/UserDocContents/{DOC_ID}")
    @Produces(value={"application/json"})
    public Response deactivateDocContent(@PathParam(value="DOC_ID") String docId) throws JSONException {
        BaseLogger.log((String)"2", null, null, (Object)("Inside deleteContent for docId=" + docId));
        UserInfoBean userInfo = this.getUserInfo();
        JSONObject respJsonObject = new JSONObject();
        try {
            if (userInfo != null) {
                String tranDB = userInfo.getTransDB();
                String loginCode = userInfo.getLoginCode();
                UserDocContent docContent = this.conLibraryDAO.deactivateDocContent(docId, loginCode, tranDB);
                JSONObject docContentObj = new JSONObject((Object)docContent);
                BaseLogger.log((String)"3", null, null, (Object)("docContentObj ::" + docContentObj));
                respJsonObject.put("result", (Object)"success");
                respJsonObject.put("docContent", (Object)docContentObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            respJsonObject.put("result", (Object)"failure");
        }
        BaseLogger.log((String)"2", null, null, (Object)("Final respJsonObject ::" + respJsonObject));
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    private JSONObject getResponseMessage(String successResponse, String status) {
        JSONObject respMessage = new JSONObject();
        try {
            respMessage.put("message", (Object)successResponse);
            respMessage.put("status", (Object)status);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return respMessage;
    }

    private UserInfoBean getUserInfo() {
        UserInfoBean userInfo = null;
        HttpSession session = this.request.getSession();
        Object userObj = session.getAttribute("USER_INFO");
        BaseLogger.log((String)"2", null, null, (Object)(" ContentLibraryService getUserInfo  userObj >>[" + userObj + "]"));
        if (userObj != null) {
            try {
                userInfo = new UserInfoBean(userObj.toString());
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        return userInfo;
    }

    @POST
    @Path(value="/UserDocContents/updateStatus/{DOC_ID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updatePinned(@PathParam(value="DOC_ID") String docId, String data) throws JSONException {
        BaseLogger.log((String)"2", null, null, (Object)("Inside updateStatus Method /n[" + data + "][" + docId + "]"));
        UserInfoBean userInfo = this.getUserInfo();
        try {
            if (userInfo != null) {
                String loginCode = userInfo.getLoginCode();
                String tranDB = userInfo.getTransDB();
                this.conLibraryDAO.updatePinned(docId, data, loginCode, tranDB);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Response.status((int)200).entity((Object)this.getResponseMessage("Updated doc item succesfully Successfully", "Success").toString()).build();
    }

    @POST
    @Path(value="/UserDocContents/updateDates/{DOC_ID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateDates(@PathParam(value="DOC_ID") String docId) throws JSONException, ParseException {
        BaseLogger.log((String)"2", null, null, (Object)("Inside updateDate Method /n[" + docId + "]"));
        Date newUsrAccDate = new Date();
        Date newGenAccDate = new Date();
        BaseLogger.log((String)"2", null, null, (Object)(" newUsrAccDate ::newGenAccDate /n[" + newUsrAccDate + "][" + newGenAccDate + "]"));
        UserInfoBean userInfo = this.getUserInfo();
        try {
            if (userInfo != null) {
                String tranDB = userInfo.getTransDB();
                String loginCode = userInfo.getLoginCode();
                this.conLibraryDAO.updateUserAccDate(newUsrAccDate, docId, loginCode, tranDB);
                this.conLibraryDAO.updatGenAccDate(newGenAccDate, docId, tranDB);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Response.status((int)200).entity((Object)this.getResponseMessage("Updated doc item succesfully Successfully", "Success").toString()).build();
    }

    @GET
    @Path(value="/DocContent/{DOC_ID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getDocContent(@PathParam(value="DOC_ID") String DOC_ID) throws JSONException {
        UserDocContent docContent = null;
        ArrayList<String> docIdList = new ArrayList<String>();
        JSONObject contentData = null;
        docIdList.add(DOC_ID);
        UserInfoBean userInfo = this.getUserInfo();
        if (userInfo != null) {
            String loginCode = userInfo.getLoginCode();
            String tranDB = userInfo.getTransDB();
            docContent = this.conLibraryDAO.getUserDocContent(loginCode, DOC_ID, tranDB);
            HashMap<String, UserDocContent> userDocContentMap = new HashMap<String, UserDocContent>();
            userDocContentMap.put(docContent.getDocId(), docContent);
            JSONObject jsonObject = this.conLibraryDAO.getUserDocContentsDetails(userDocContentMap, docIdList, tranDB);
            contentData = (JSONObject)jsonObject.optJSONArray("userDocContents").get(0);
        }
        return Response.status((int)200).entity((Object)contentData.toString()).build();
    }

    @GET
    @Path(value="/AssocObjDetails/{DOC_TYPE}/{DOC_ID}")
    @Produces(value={"application/json"})
    public Response getAssocObjDetails(@PathParam(value="DOC_TYPE") String docType, @PathParam(value="DOC_ID") String docId) throws JSONException {
        JSONObject respJsonObject = new JSONObject();
        List assocObjList = null;
        String tranDB = "DEFAULT";
        UserInfoBean userInfo = this.getUserInfo();
        if (userInfo != null) {
            tranDB = userInfo.getTransDB();
            assocObjList = this.conLibraryDAO.getAssociateData(docType, docId, tranDB);
            BaseLogger.log((String)"3", null, null, (Object)("Final assocObjList ::: " + assocObjList));
            respJsonObject.put("result", (Object)"success");
            respJsonObject.put("assocObjList", (Collection)assocObjList);
        } else {
            respJsonObject.put("result", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @GET
    @Path(value="/AssocTransList/{DOC_TYPE}/{DOC_ID}/{REF_SER}/{OBJ_NAME}/{TABLE_NAME}/{TRAN_ID_COL}")
    @Produces(value={"application/json"})
    public Response getAssocTransDetails(@PathParam(value="DOC_TYPE") String docType, @PathParam(value="DOC_ID") String docId, @PathParam(value="REF_SER") String refSer, @PathParam(value="OBJ_NAME") String objName, @PathParam(value="TABLE_NAME") String tableName, @PathParam(value="TRAN_ID_COL") String tranIDCol) throws JSONException {
        JSONObject respJsonObject = new JSONObject();
        JSONObject assocTransList = null;
        BaseLogger.log((String)"2", null, null, (Object)("docId : " + docId + ", docType : " + docType + ", refSer : " + refSer + ", objName :" + objName + ", tranIDCol : " + tranIDCol));
        UserInfoBean userInfo = this.getUserInfo();
        String tranDB = "DEFAULT";
        if (userInfo != null) {
            tranDB = userInfo.getTransDB();
            BaseLogger.log((String)"3", null, null, (Object)("docId : " + docId + ", docType : " + docType + ", refSer : " + refSer + ", tranDB : " + tranDB + ", objName :" + objName + ", tranIDCol : " + tranIDCol));
            assocTransList = this.conLibraryDAO.getTransDetails(docId, docType, refSer, tranDB, objName, tableName, tranIDCol);
            BaseLogger.log((String)"3", null, null, (Object)("Final assocTransList ::: " + assocTransList));
            respJsonObject.put("result", (Object)"success");
            respJsonObject.put("assocTransList", (Object)assocTransList);
        } else {
            respJsonObject.put("result", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @POST
    @Path(value="/UpdateDocTransPageInfo")
    public Response updateDocTransPageInfo(@Context HttpServletRequest request) throws JSONException {
        JSONObject respJsonObject = new JSONObject();
        try {
            UserInfoBean userInfo = this.getUserInfo();
            String tranDB = "DEFAULT";
            if (userInfo != null) {
                tranDB = userInfo.getTransDB();
                ServletInputStream inputStream = request.getInputStream();
                String tranLingListStr = this.readStreamAsString((InputStream)inputStream);
                BaseLogger.log((String)"3", null, null, (Object)("tranLingListStr : " + tranLingListStr));
                JSONObject tranLingListJsn = new JSONObject(tranLingListStr);
                String docId = tranLingListJsn.getString("doc_id");
                String refSer = tranLingListJsn.getString("ref_ser");
                String docTypeAttach = tranLingListJsn.getString("doc_type_attach");
                JSONArray upateTransArr = tranLingListJsn.getJSONArray("update_data_arr");
                ArrayList<DocTransLink> docTranList = new ArrayList<DocTransLink>();
                int cn = 0;
                while (cn < upateTransArr.length()) {
                    JSONObject tranObjJson = (JSONObject)upateTransArr.get(cn);
                    DocTransLink docTransLink = new DocTransLink();
                    docTransLink.setDocId(docId);
                    docTransLink.setRefSer(refSer);
                    docTransLink.setDocTypeAttach(docTypeAttach);
                    docTransLink.setRefId(tranObjJson.getString("ref_id"));
                    Object pageInfoObj = tranObjJson.opt("@page_info");
                    BaseLogger.log((String)"3", null, null, (Object)("update updateDocTransPageInfo >>" + pageInfoObj));
                    if (pageInfoObj != null) {
                        docTransLink.setPageInfo(pageInfoObj.toString());
                    }
                    docTranList.add(docTransLink);
                    ++cn;
                }
                JSONArray insertTransArr = tranLingListJsn.getJSONArray("insert_data_arr");
                ArrayList<DocTransLink> insertDocTranList = new ArrayList<DocTransLink>();
                int cn2 = 0;
                while (cn2 < insertTransArr.length()) {
                    JSONObject tranObjJson = (JSONObject)insertTransArr.get(cn2);
                    DocTransLink docTransLink = new DocTransLink();
                    docTransLink.setDocId(docId);
                    docTransLink.setRefSer(refSer);
                    docTransLink.setDocTypeAttach(docTypeAttach);
                    docTransLink.setRefId(tranObjJson.getString("ref_id"));
                    Object pageInfoObj = tranObjJson.opt("@page_info");
                    BaseLogger.log((String)"3", null, null, (Object)("390 updateDocTransPageInfo >>" + pageInfoObj));
                    if (pageInfoObj != null) {
                        BaseLogger.log((String)"3", null, null, (Object)("393 updateDocTransPageInfo >>" + pageInfoObj.getClass()));
                        docTransLink.setPageInfo(pageInfoObj.toString());
                    }
                    insertDocTranList.add(docTransLink);
                    ++cn2;
                }
                this.conLibraryDAO.updateTransactionLink(insertDocTranList, docTranList, tranDB);
                respJsonObject.put("message", (Object)"successResponse");
                respJsonObject.put("status", (Object)"success");
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception in ContentLibraryService :: updateDocTransPageInfo() : " + e));
            e.printStackTrace();
            respJsonObject.put("message", (Object)"failedResponse");
            respJsonObject.put("status", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    private String readStreamAsString(InputStream is) throws IOException {
        byte[] total = new byte[is.available()];
        byte[] buffer = new byte[1024];
        int readed = -1;
        int curPos = 0;
        while ((readed = is.read(buffer)) != -1) {
            int buffPos = 0;
            int i = curPos;
            while (i < curPos + readed) {
                total[i] = buffer[buffPos++];
                ++i;
            }
        }
        return new String(total);
    }

    @GET
    @Path(value="/GetNewTransctionList/{DOC_ID}/{DOC_TYPE}/{REF_SER}/{OBJ_NAME}/{TABLE_NAME}/{TRAN_ID_COL}/{Q_LIKE}")
    public Response getNewTransctionList(@PathParam(value="DOC_ID") String docId, @PathParam(value="DOC_TYPE") String docType, @PathParam(value="REF_SER") String refSer, @PathParam(value="OBJ_NAME") String objName, @PathParam(value="TABLE_NAME") String tableName, @PathParam(value="TRAN_ID_COL") String tranIDCol, @PathParam(value="Q_LIKE") String qLike) throws JSONException {
        JSONObject respJsonObject = new JSONObject();
        try {
            UserInfoBean userInfo = this.getUserInfo();
            String tranDB = "DEFAULT";
            if (userInfo != null) {
                tranDB = userInfo.getTransDB();
                JSONObject assocTransList = null;
                assocTransList = this.conLibraryDAO.getNewTransctionList(docType, qLike, docId, refSer, tranDB, objName, tableName, tranIDCol);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Final assocTransList ::: " + assocTransList));
                if (assocTransList.length() > 0) {
                    String dispTemplet = (String)assocTransList.get("template");
                    String pattern = "</\\s*[^>]*>";
                    Pattern rex = Pattern.compile(pattern);
                    Matcher macher = rex.matcher(dispTemplet);
                    dispTemplet = macher.replaceAll(" ");
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)(" assocTransList ::: dispTemplet " + dispTemplet));
                    pattern = "<\\s*[^>]*>";
                    rex = Pattern.compile(pattern);
                    macher = rex.matcher(dispTemplet);
                    dispTemplet = macher.replaceAll(" - ");
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Final assocTransList ::: dispTemplet " + dispTemplet));
                    dispTemplet = dispTemplet.replace("{{", "<");
                    dispTemplet = dispTemplet.replace("}}", ">");
                    dispTemplet = dispTemplet.replace(" ", "");
                    dispTemplet = dispTemplet.replace("-", " - ");
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Final assocTransList ::: dispTemplet " + dispTemplet));
                    respJsonObject.put("result", (Object)"success");
                    respJsonObject.put("details", assocTransList.get("details"));
                    respJsonObject.put("imgUrl", (Object)"...");
                    respJsonObject.put("chipMetadata", (Object)dispTemplet);
                    respJsonObject.put("suggestMetadata", (Object)dispTemplet);
                    respJsonObject.put("valueFields", (Object)tranIDCol);
                }
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("respJsonObject" + respJsonObject));
            } else {
                respJsonObject.put("result", (Object)"failure");
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception in ContentLibraryService.getNewTransctionList :: " + e));
            respJsonObject.put("result", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @GET
    @Path(value="/objLinksDetails/{OBJ_NAME}/{TARGET_OBJ_NAME}")
    @Produces(value={"application/json"})
    public Response getObjLinksDetails(@PathParam(value="OBJ_NAME") String objName, @PathParam(value="TARGET_OBJ_NAME") String targetObjName) throws JSONException {
        JSONObject respJsonObject = new JSONObject();
        JSONObject linkDetails = null;
        String tranDB = "DEFAULT";
        UserInfoBean userInfo = this.getUserInfo();
        if (userInfo != null) {
            tranDB = userInfo.getTransDB();
            linkDetails = this.conLibraryDAO.getObjLinksDetails(objName, targetObjName, tranDB);
            if (linkDetails.length() > 0) {
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Final getObjLinksDetails ::: assocObjList : " + linkDetails));
                respJsonObject.put("result", (Object)"success");
                respJsonObject.put("link", (Object)linkDetails);
            } else {
                respJsonObject.put("result", (Object)"failure");
                respJsonObject.put("error", (Object)("No link find for objName '" + objName + "'"));
            }
        } else {
            respJsonObject.put("result", (Object)"failure");
            respJsonObject.put("error", (Object)"Invalid session.");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @GET
    @Path(value="/getTransctionDetails/{DOC_ID}/{DOC_TYPE}/{REF_SER}/{OBJ_NAME}/{TABLE_NAME}/{TRAN_ID_COL}/{Q_LIKE}")
    public Response getTransctionDetails(@PathParam(value="DOC_ID") String docId, @PathParam(value="DOC_TYPE") String docType, @PathParam(value="REF_SER") String refSer, @PathParam(value="OBJ_NAME") String objName, @PathParam(value="TABLE_NAME") String tableName, @PathParam(value="TRAN_ID_COL") String tranIDCol, @PathParam(value="Q_LIKE") String qLike) throws JSONException {
        JSONObject respJsonObject = new JSONObject();
        try {
            UserInfoBean userInfo = this.getUserInfo();
            String tranDB = "DEFAULT";
            if (userInfo != null) {
                tranDB = userInfo.getTransDB();
                JSONObject assocTransList = null;
                assocTransList = this.conLibraryDAO.getNewTransctionList(docType, qLike, docId, refSer, tranDB, objName, tableName, tranIDCol);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("getTransctionDetails ::: assocTransList :" + assocTransList));
                if (assocTransList.length() > 0) {
                    JSONArray detailsArr = (JSONArray)assocTransList.get("details");
                    respJsonObject.put("result", (Object)"success");
                    respJsonObject.put("detail", detailsArr.get(0));
                    respJsonObject.put("imgUrl", (Object)"");
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("respJsonObject" + respJsonObject));
                } else {
                    respJsonObject.put("result", (Object)"failure");
                    respJsonObject.put("error", (Object)("No details found for transaction id '" + qLike + "'"));
                }
            } else {
                respJsonObject.put("result", (Object)"failure");
                respJsonObject.put("error", (Object)"Invalid session.");
            }
        }
        catch (Exception ex) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception in ContentLibraryService.getTransctionDetails :: " + ex));
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @POST
    @Path(value="/UpdateSharedAccessUserDetails")
    public Response updateSharedAccessUserDetails(@Context HttpServletRequest request) throws JSONException {
        JSONObject respJsonObject = new JSONObject();
        try {
            UserInfoBean userInfo = this.getUserInfo();
            if (userInfo != null) {
                ServletInputStream inputStream = request.getInputStream();
                String sharedUsersListStr = this.readStreamAsString((InputStream)inputStream);
                JSONObject sharedUsrListJsn = new JSONObject(sharedUsersListStr);
                String docId = sharedUsrListJsn.getString("DOC_ID");
                String usersList = sharedUsrListJsn.getString("LIST_OF_USERS");
                String remarks = sharedUsrListJsn.getString("REMARKS");
                String response = this.conLibraryDAO.updateSharedUsersDetails(userInfo, docId, usersList, remarks);
                respJsonObject.put("message", (Object)response);
                respJsonObject.put("status", (Object)"success");
                BaseLogger.log((String)"2", null, null, (Object)("Print respJsonObject 712 :::::::" + respJsonObject));
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception in ContentLibraryService :: updateDocTransPageInfo() : " + e));
            e.printStackTrace();
            respJsonObject.put("message", (Object)"failedResponse");
            respJsonObject.put("status", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @POST
    @Path(value="/GetSharedAccessUserDetails")
    public Response getSharedAccessUserDetails(@Context HttpServletRequest request) throws JSONException {
        JSONObject respJsonObject = new JSONObject();
        try {
            UserInfoBean userInfo = this.getUserInfo();
            if (userInfo != null) {
                ServletInputStream inputStream = request.getInputStream();
                String sharedUsersListStr = this.readStreamAsString((InputStream)inputStream);
                JSONObject sharedUsrListJsn = new JSONObject(sharedUsersListStr);
                String docId = sharedUsrListJsn.getString("DOC_ID");
                String response = this.conLibraryDAO.getSharedUsersDetails(userInfo, docId);
                respJsonObject.put("message", (Object)response);
                respJsonObject.put("status", (Object)"success");
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception in ContentLibraryService :: updateDocTransPageInfo() : " + e));
            e.printStackTrace();
            respJsonObject.put("message", (Object)"failedResponse");
            respJsonObject.put("status", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }
}

