/*
 * Decompiled with CFR 0.152.
 */
package ibase.servlet;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WriteExceptionLogServlet
extends HttpServlet {
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        BaseLogger.log("2", null, null, "In WriteExceptionLogServlet.........");
        try {
            HttpSession sess = request.getSession();
            UserInfoBean userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
            BaseLogger.log("3", null, null, "WriteExceptionLogServlet.doPost() userInfo:[" + userInfo + "]");
            String ip = request.getRemoteAddr();
            String userID = WriteExceptionLogServlet.checkNull(request.getParameter("USER"));
            String action = WriteExceptionLogServlet.checkNull(request.getParameter("ACTION"));
            String errorMsg = WriteExceptionLogServlet.checkNull(request.getParameter("ERROR_MSG"));
            String errorDesc = WriteExceptionLogServlet.checkNull(request.getParameter("ERROR_DESC"));
            String errorTrace = WriteExceptionLogServlet.checkNull(request.getParameter("ERROR_TRACE"));
            BaseLogger.log("3", null, null, "In WriteExceptionLogServlet user :[" + userID + "]");
            BaseLogger.log("3", null, null, "In WriteExceptionLogServlet remote ip :[" + ip + "]");
            BaseLogger.log("3", null, null, "In WriteExceptionLogServlet exceptionType :[" + errorMsg + "]");
            BaseLogger.log("3", null, null, "In WriteExceptionLogServlet errorDesc :[" + errorDesc + "]");
            BaseLogger.log("3", null, null, "In WriteExceptionLogServlet action :[" + action + "]");
            if ("WRITE_TRACE_LOG".equalsIgnoreCase(action)) {
                String folderPath = String.valueOf(File.separator) + "home" + File.separator + "base" + File.separator + "ExceptionLog";
                String fileName = this.writeExceptionLog(errorTrace, folderPath, "", false, userID);
                String content = "\n\n" + fileName + " : " + userID + ", " + ip + ", " + errorMsg + ", " + errorDesc;
                BaseLogger.log("3", null, null, "In WriteExceptionLogServlet content of traceDetails :[" + content + "]");
                this.writeExpLogFileDetails(content, folderPath, "TraceDetails.txt", true, userID);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in WriteExceptionLogServlet doPost: " + this.getStackTrace(e));
        }
    }

    private String writeExceptionLog(String stacktrace, String folderPath, String fileName, boolean isContentAppend, String userID) {
        String exceptionLogFile = "";
        File logFile = null;
        try {
            BaseLogger.log("3", null, null, "iscontentAppend in writeExceptionLog :[" + isContentAppend + "]");
            BaseLogger.log("3", null, null, "FileName in writeExceptionLog :[" + fileName + "]");
            BaseLogger.log("3", null, null, "FilePath in writeExceptionLog :[" + folderPath + "]");
            String filePath = E12GenericUtility.checkNull(folderPath).length() > 0 ? folderPath : String.valueOf(File.separator) + "home" + File.separator + "base" + File.separator + "ExceptionLog";
            long timeInMS = System.currentTimeMillis();
            exceptionLogFile = E12GenericUtility.checkNull(fileName).length() > 0 ? fileName : String.valueOf(String.valueOf(timeInMS)) + ".txt";
            exceptionLogFile = String.valueOf(userID) + "_" + exceptionLogFile;
            File logDir = new File(filePath);
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            if (isContentAppend) {
                logFile = new File(filePath, exceptionLogFile);
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
            } else {
                logFile = this.createFile(filePath, exceptionLogFile, userID);
                exceptionLogFile = logFile.getName();
            }
            FileWriter writer = new FileWriter(logFile.getAbsoluteFile(), isContentAppend);
            writer.write(stacktrace);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            BaseLogger.log("0", null, null, "Exception in writeExceptionLog : " + this.getStackTrace(e));
        }
        BaseLogger.log("2", null, null, "exceptionLogFile in writeExceptionLog :[" + exceptionLogFile + "]");
        return exceptionLogFile;
    }

    private void writeExpLogFileDetails(String stacktrace, String folderPath, String fileName, boolean isContentAppend, String userID) {
        String exceptionLogFile = "";
        File logFile = null;
        try {
            BaseLogger.log("3", null, null, "iscontentAppend in writeExpLogFileDetails :[" + isContentAppend + "]");
            BaseLogger.log("3", null, null, "FileName in writeExpLogFileDetails :[" + fileName + "]");
            BaseLogger.log("3", null, null, "FilePath in writeExpLogFileDetails :[" + folderPath + "]");
            String filePath = E12GenericUtility.checkNull(folderPath).length() > 0 ? folderPath : String.valueOf(File.separator) + "home" + File.separator + "base" + File.separator + "ExceptionLog";
            long timeInMS = System.currentTimeMillis();
            exceptionLogFile = E12GenericUtility.checkNull(fileName).length() > 0 ? fileName : String.valueOf(String.valueOf(timeInMS)) + ".txt";
            exceptionLogFile = String.valueOf(userID) + "_" + exceptionLogFile;
            File logDir = new File(filePath);
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            if (!(logFile = new File(filePath, exceptionLogFile)).exists()) {
                logFile.createNewFile();
            }
            FileWriter writer = new FileWriter(logFile.getAbsoluteFile(), isContentAppend);
            writer.write(stacktrace);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            BaseLogger.log("0", null, null, "Exception in writeExpLogFileDetails : " + this.getStackTrace(e));
        }
    }

    private File createFile(String filePath, String fileName, String userID) {
        File logFile = null;
        try {
            logFile = new File(filePath, fileName);
            if (!logFile.exists()) {
                logFile.createNewFile();
            } else {
                long timeInMS = System.currentTimeMillis();
                fileName = String.valueOf(timeInMS);
                fileName = String.valueOf(userID) + "_" + fileName;
                BaseLogger.log("3", null, null, "File Name in else of createFile :[" + fileName + "]");
                this.createFile(filePath, fileName, userID);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in createFile : " + this.getStackTrace(e));
        }
        return logFile;
    }

    private String getStackTrace(Exception ex) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elements = ex.getStackTrace();
        sb.append(String.valueOf(ex.getClass().getSimpleName()) + " : " + ex.getMessage() + "\n");
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append("\nat " + element.toString());
            ++n2;
        }
        return sb.toString();
    }

    public static String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }
}

