package ibase.utility.training;

import java.io.*;
import java.nio.file.*;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class XmlReader {
	public static void main(String[] args) {
		String filePath = "/home/amol.sonawane/Documents/UNS-HSBC";
		String outputFileName = generateOutputFileName();
		String archiveFolderName = generateArchiveFolderName();

		try {
			concatenateXmlFiles(filePath, outputFileName);
			moveFilesToArchive(filePath, archiveFolderName);
			System.out.println("XML files concatenated successfully. Output file: " + outputFileName);
		} catch (IOException e) {
			System.err.println("Error concatenating XML files: " + e.getMessage());
		}
	}

	private static void concatenateXmlFiles(String filePath, String outputFileName) throws IOException {
	    File outputDir = new File("/home/amol.sonawane/Documents/UNS-HSBC/NewXml");
	    if (!outputDir.exists()) {
	        outputDir.mkdirs();
	    }

	    File[] xmlFiles = new File(filePath).listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"));

	    if (xmlFiles == null || xmlFiles.length == 0) {
	        System.err.println("No XML files found in the specified directory.");
	        return;
	    }

	    try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outputDir, outputFileName)))) {
	        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
	        writer.write("<Document xmlns=\"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03\">");

	        for (int i = 0; i < xmlFiles.length; i++) {

	            String content = new String(Files.readAllBytes(xmlFiles[i].toPath()));

	            int startIdxOfMsgId = content.indexOf("<MsgId>");
	            int endIdxOfMsgId = content.indexOf("</MsgId>") + "</MsgId>".length();
	            if (startIdxOfMsgId != -1 && endIdxOfMsgId != -1) {
	                String updatedMsgIdTag = "<MsgId>" + getFileNameWithoutExtension(generateOutputFileName()) + "</MsgId>";
	                content = content.substring(0, startIdxOfMsgId) + updatedMsgIdTag + content.substring(endIdxOfMsgId);
	            }

	            int startIdxOfPmtInfId = content.indexOf("<PmtInfId>");
	            int endIdxOfPmtInfId = content.indexOf("</PmtInfId>") + "</PmtInfId>".length();
	            if (startIdxOfPmtInfId != -1 && endIdxOfPmtInfId != -1) {
	                String updatedPmtInfIdTag = "<PmtInfId>" + getFileNameWithoutExtension(generateOutputFileName()) + "</PmtInfId>";
	                content = content.substring(0, startIdxOfPmtInfId) + updatedPmtInfIdTag + content.substring(endIdxOfPmtInfId);
	            }

	       
	         // CtrlSum
	            if (i == 0) {
	                int totalCtrlSum = 0;
	                Set<String> addedCtrlSums = new HashSet<>(); // Keep track of added CtrlSum values

	                for (File xmlFile : xmlFiles) {
	                    String fileContent = new String(Files.readAllBytes(xmlFile.toPath()));

	                    int startIdxOfCtrlSum = fileContent.indexOf("<CtrlSum>");
	                    int endIdxOfCtrlSum = fileContent.indexOf("</CtrlSum>", startIdxOfCtrlSum);

	                    while (startIdxOfCtrlSum != -1 && endIdxOfCtrlSum != -1) {
	                        String ctrlSumValueStr = fileContent.substring(startIdxOfCtrlSum + "<CtrlSum>".length(), endIdxOfCtrlSum);
	                        int ctrlSumValue = Integer.parseInt(ctrlSumValueStr.trim()); // Trim the string to remove leading/trailing spaces

	                        // Only add the CtrlSum value if it hasn't been added before
	                        if (!addedCtrlSums.contains(ctrlSumValueStr)) {
	                            totalCtrlSum += ctrlSumValue;
	                            System.out.println("totalCtrlSum : " + totalCtrlSum);
	                            addedCtrlSums.add(ctrlSumValueStr); // Add the value to the set to mark it as added
	                        }

	                        // Find the next occurrence of <CtrlSum> and </CtrlSum>
	                        startIdxOfCtrlSum = fileContent.indexOf("<CtrlSum>", endIdxOfCtrlSum);
	                        if (startIdxOfCtrlSum != -1) {
	                            endIdxOfCtrlSum = fileContent.indexOf("</CtrlSum>", startIdxOfCtrlSum);
	                        } else {
	                            // If no further occurrence is found, exit the loop
	                            break;
	                        }
	                    }
	                }
	                // Replace the total sum in the original content
	                int startIdxOfCtrlSum = content.indexOf("<CtrlSum>");
	                int endIdxOfCtrlSum = content.indexOf("</CtrlSum>", startIdxOfCtrlSum);
	                if (startIdxOfCtrlSum != -1 && endIdxOfCtrlSum != -1)
	                {
	                    content = content.substring(0, startIdxOfCtrlSum + "<CtrlSum>".length()) + totalCtrlSum
	                            + content.substring(endIdxOfCtrlSum);
	                }
	                System.out.println("First totalCtrlSum : " + totalCtrlSum);

                     // for NbOfTxs
	                int startIdxOfNbOfTxsTag = content.indexOf("<NbOfTxs>");
	                int endIdxOfNbOfTxsTag = content.indexOf("</NbOfTxs>", startIdxOfNbOfTxsTag);

	                System.out.println("startIdxOfNbOfTxsTag : " + startIdxOfNbOfTxsTag);
	                System.out.println("endIdxOfNbOfTxsTag : " + endIdxOfNbOfTxsTag);

	                if (startIdxOfNbOfTxsTag != -1 && endIdxOfNbOfTxsTag != -1) 
	                {
	                    content = content.substring(0, startIdxOfNbOfTxsTag + "<NbOfTxs>".length()) +
	                            xmlFiles.length + content.substring(endIdxOfNbOfTxsTag);
	                }
	                // Extract content starting from <CstmrCdtTrfInitn>
	                int startIdx = content.indexOf("<CstmrCdtTrfInitn>");
	                int endIdx = content.lastIndexOf("</CdtTrfTxInf>") + "</CdtTrfTxInf>".length();

	                if (startIdx != -1 && endIdx != -1) {
	                    content = content.substring(startIdx, endIdx);
	                }
	                //29 new added
	                
	                int startIdxOfPmtInf = content.indexOf("<PmtInf>");
	                int endIdxOfPmtInf = content.indexOf("</Dbtr>", startIdxOfPmtInf);
	                if (startIdxOfPmtInf != -1 && endIdxOfPmtInf != -1) {
	                    int startIdxOfCtrlSumPmtInf = content.indexOf("<CtrlSum>", startIdxOfPmtInf);
	                    int endIdxOfCtrlSumPmtInf = content.indexOf("</CtrlSum>", startIdxOfCtrlSumPmtInf);
	                    System.out.println("value startIdxOfCtrlSumPmtInf is : " + startIdxOfCtrlSumPmtInf);

	                    if (startIdxOfCtrlSumPmtInf != -1 && endIdxOfCtrlSumPmtInf != -1) {
	                        String updatedCtrlSumTag = "<CtrlSum>" + totalCtrlSum + "</CtrlSum>";
	                        content = content.substring(0, startIdxOfCtrlSumPmtInf) + updatedCtrlSumTag + content.substring(endIdxOfCtrlSumPmtInf + "</CtrlSum>".length());
	                        System.out.println("value of totalCtrlSum in pmtinf is : " + totalCtrlSum);
	                    }
	                }
		            
		         // Within the <PmtInf> tag, find the occurrence of <NbOfTxs>
		            int startIdxOfNbOfTxsPmtInf = content.indexOf("<NbOfTxs>", startIdxOfPmtInf);
	                int endIdxOfNbOfTxsPmtInf = content.indexOf("</NbOfTxs>", startIdxOfPmtInf);

	                if (startIdxOfNbOfTxsPmtInf != -1 && endIdxOfNbOfTxsPmtInf != -1) {
	                    // Update NbOfTxs in PmtInf tag
	                    content = content.substring(0, startIdxOfNbOfTxsPmtInf + "<NbOfTxs>".length()) +
	                            xmlFiles.length + content.substring(endIdxOfNbOfTxsPmtInf);
	                }
	            
	            } else {
	                int startIdx = content.indexOf("<CdtTrfTxInf>");
	                int endIdx = content.indexOf("</CdtTrfTxInf>") + "</CdtTrfTxInf>".length();
	                if (startIdx != -1 && endIdx != -1) {
	                    content = content.substring(startIdx, endIdx);
	                }
	            }

	            writer.write(content);
	        }

	        writer.write("</PmtInf>");
	        writer.write("</CstmrCdtTrfInitn>");
	        writer.write("</Document>");
	    }
	}

	private static void moveFilesToArchive(String filePath, String archiveFolderName) throws IOException
	{
		File archiveDir = new File(filePath + File.separator + archiveFolderName);
		if (!archiveDir.exists()) {
			archiveDir.mkdirs();
		}

		File[] xmlFiles = new File(filePath).listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"));

		if (xmlFiles != null) {
			for (File xmlFile : xmlFiles) {
				Path sourcePath = Paths.get(xmlFile.getAbsolutePath());
				Path destinationPath = Paths.get(archiveDir.getAbsolutePath() + File.separator + xmlFile.getName());
				Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
			}
		}
	}

	private static String generateOutputFileName() 
	{
		SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmm");
		String formattedDate = dateFormat.format(new Date());
		return formattedDate + ".xml";
	}

	private static String generateArchiveFolderName() 
	{
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH");
		return dateFormat.format(new Date());
	}
	private static String getFileNameWithoutExtension(String formattedDate) {
	    int lastDotIndex = formattedDate.lastIndexOf(".");
	    if (lastDotIndex != -1) {
	        return formattedDate.substring(0, lastDotIndex);
	    }
	    return formattedDate;
	}
}
