import org.json.JSONArray;
import org.json.JSONObject;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.CallbackQuery;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.updatesreceivers.DefaultBotSession;

import java.util.ArrayList;
import java.util.List;

public class MyTelegramBot extends TelegramLongPollingBot {

    private List<String> docTypesList = new ArrayList<>();

    @Override
    public void onUpdateReceived(Update update) {
        if (update.hasCallbackQuery()) {
            handleCallbackQuery(update.getCallbackQuery());
        } else if (update.hasMessage() && update.getMessage().hasText()) {
            handleMessage(update.getMessage());
        }
    }

    private void handleCallbackQuery(CallbackQuery callbackQuery) {
        String selectedOption = callbackQuery.getData();
        Long chatId = callbackQuery.getMessage().getChatId();

        SendMessage response = new SendMessage();
        response.setChatId(chatId.toString());
        response.setText("Option selected: " + selectedOption);

        try {
            execute(response);
        } catch (TelegramApiException e) {
            e.printStackTrace();
        }
    }


    private void handleMessage(Message message) {
        // Check if the message was sent by the bot itself
        if (message.getFrom().getUserName().equals(getBotUsername())) {
            return;
        }

        Long chatId = message.getChatId();
        System.out.println("New chatId --" + chatId);
        String text = message.getText();

        if ("give option".equalsIgnoreCase(text)) {
            sendInlineOptions(chatId);
        }
    }

    private void sendInlineOptions(Long chatId) {
        // Parse the JSON string and extract docType values
        String json = "{\"docTypes\":[{\"minAttachmentRequired\":0,\"docType\":\"Invoice\",\"attached\":0,\"contentType\":[\"PDF\",\"IMAGE\"],\"maxAttachmentAllowed\":0},{\"minAttachmentRequired\":0,\"docType\":\"UPLOAD FORMATS\",\"attached\":0,\"contentType\":[\"MS_EXCEL\",\"MS_WORD\"],\"maxAttachmentAllowed\":0},{\"minAttachmentRequired\":0,\"docType\":\"HR Policy\",\"attached\":1,\"contentType\":[\"PDF\",\"IMAGE\",\"VIDEO\",\"ZIP\",\"MS_EXCEL\",\"MS_WORD\"],\"maxAttachmentAllowed\":0},{\"minAttachmentRequired\":0,\"docType\":\"Presentation\",\"attached\":2,\"contentType\":[\"IMAGE\",\"VIDEO\",\"ZIP\",\"AR_OBJECT\"],\"maxAttachmentAllowed\":0},{\"minAttachmentRequired\":0,\"docType\":\"Literature\",\"attached\":0,\"contentType\":[\"PDF\"],\"maxAttachmentAllowed\":1},{\"minAttachmentRequired\":0,\"docType\":\"Product Demo\",\"attached\":0,\"contentType\":[\"VIDEO\",\"ZIP\"],\"maxAttachmentAllowed\":1},{\"minAttachmentRequired\":0,\"docType\":\"Product Manual\",\"attached\":0,\"contentType\":[\"PDF\"],\"maxAttachmentAllowed\":4}],\"objName\":\"content_library\"}";
        JSONObject jsonObject = new JSONObject(json);
        JSONArray docTypesArray = jsonObject.getJSONArray("docTypes");

        // Extract docType values and add to ArrayList
        for (int i = 0; i < docTypesArray.length(); i++) {
            JSONObject docTypeObject = docTypesArray.getJSONObject(i);
            String docType = docTypeObject.getString("docType");
            docTypesList.add(docType);
        }

        // Create inline keyboard with docType options
        SendMessage optionsMessage = new SendMessage();
        optionsMessage.setChatId(chatId.toString());
        optionsMessage.setText("Please select a document type:");

        List<List<InlineKeyboardButton>> rowsInline = new ArrayList<>();
        List<InlineKeyboardButton> currentRow = new ArrayList<>();
        for (String docType : docTypesList) {
            if (currentRow.size() == 2) {
                rowsInline.add(currentRow);
                currentRow = new ArrayList<>();
            }
            currentRow.add(createInlineButton(docType));
        }
        // Add the last row if it's not empty
        if (!currentRow.isEmpty()) {
            rowsInline.add(currentRow);
        }

        // Set the keyboard
        InlineKeyboardMarkup markupInline = new InlineKeyboardMarkup();
        markupInline.setKeyboard(rowsInline);
        optionsMessage.setReplyMarkup(markupInline); // Set inline keyboard markup

        // Send the message
        try {
            execute(optionsMessage);
        } catch (TelegramApiException e) {
            e.printStackTrace();
        }
    }

    private InlineKeyboardButton createInlineButton(String text) {
        InlineKeyboardButton button = new InlineKeyboardButton();
        button.setText(text);
        button.setCallbackData(text); // Set callback data to the option text
        return button;
    }

    @Override
    public String getBotUsername() {
        return "Telegmtestingbot";
    }

    @Override
    public String getBotToken() {
        return "7171570219:AAGkJ9wQEJyJ1f2f2y_eTPQWEaWrn-6fLf0";
    }

    public static void main(String[] args) {
        MyTelegramBot bot = new MyTelegramBot();

        try {
            TelegramBotsApi botsApi = new TelegramBotsApi(DefaultBotSession.class);
            botsApi.registerBot(bot);
        } catch (TelegramApiException e) {
            e.printStackTrace();
        }
    }
}
