package ibase.webitm.ejb.wsfa.masters;

import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.webitm.bean.wsfa.DCRSummaryBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.wsfa.transactions.StrgCustGeoPosAddUpdationPrcLocal;
import ibase.webitm.ejb.wsfa.transactions.StrgCustGeoPosAddUpdationPrcRemote;
import ibase.webitm.utility.ITMException;

public class StrgCustGeoPosAddUpdationPrc extends ProcessEJB implements StrgCustGeoPosAddUpdationPrcRemote,StrgCustGeoPosAddUpdationPrcLocal
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
			String retStr = "";
			Document detailDom = null;
			Document headerDom = null;
			try
			{	
				if(xmlString != null && xmlString.trim().length()!=0)
				{
					headerDom = genericUtility.parseString(xmlString); 
					System.out.println("prc1 headerDom" + headerDom);
				}
				if(xmlString2 != null && xmlString2.trim().length()!=0)
				{
					detailDom = genericUtility.parseString(xmlString2); 
					System.out.println("prc1 detailDom" + detailDom);
				}
										
			    retStr = process(headerDom, detailDom, windowName, xtraParams);
			}
			catch (Exception e)
			{
				System.out.println("Exception :StrgCustGeoPosAddUpdationPrc :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
				e.printStackTrace();
				retStr = e.getMessage();
			}
			return retStr;
		
	}
	
	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Inside StrgCustGeoPosAddUpdationPrc process method");
		String module_name = genericUtility.getColumnValue("module_name",headerDom);
		System.out.println("Inside StrgCustGeoPosAddUpdationPrc module_name method["+module_name+"]");

		String sqlQuery="";
		int count=0;
		int count1=0;
		Connection conn = null;
		PreparedStatement pstmt=null;
		ResultSet rs= null;	
		PreparedStatement placePstmt=null;
		ResultSet placeRs= null;	
		boolean isError=false;
		PreparedStatement pstmt1=null;
		StringBuffer errStringXml;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		String errString = "";
		String returnString="";
		String latLng="";

		errStringXml = new StringBuffer();
		errStringXml.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");
		try
		{
			if ( conn == null )
			{
				conn = getConnection();
				conn.setAutoCommit(false);
			}            
			String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();
			java.text.DateFormat df = new java.text.SimpleDateFormat(genericUtility.getDBDateTimeFormat());
			java.util.Calendar dateCreated = java.util.Calendar.getInstance();
			String sysDate = df.format(dateCreated.getTime());

			//DCRSummaryBean dcrSummaryBean=new DCRSummaryBean();
			//String googleAddrUpdat=dcrSummaryBean.getSfaParmValue(userId, "IS_GOOGLE_ADDR_UPD", conn);
			//System.out.println("Inside StrgCustGeoPosAddUpdationPrc googleAddrUpdat method["+googleAddrUpdat+"]");

			if(module_name.equals("S"))
			{
				//sqlQuery="select addr1 || ' ' || addr2 || ' ' || addr3 || ', ' || city as Address,sc_code from strg_customer where geo_pos is null";
                sqlQuery = "SELECT ADDR1 || ' ' || ADDR2 || ' ' || ADDR3 || ', ' || CITY AS ADDRESS,SC_CODE FROM STRG_CUSTOMER WHERE GEO_POS IS NULL "
                		+ "AND SC_CODE IN (SELECT SC_CODE FROM strg_series WHERE NVL(STATUS,'N')='Y') ";

				pstmt = conn.prepareStatement(sqlQuery);
				rs = pstmt.executeQuery();

				while (rs.next())
				{
					String address = rs.getString(1);
					String scCode = rs.getString(2);
					
					//if("Y".equalsIgnoreCase(googleAddrUpdat))
					//{
						String[] latLngArr = getLatLongPositions( address );
						System.out.println("latLngArr is "+latLngArr+" scCodeS is:: "+scCode);
						    if(latLngArr!=null)
						    {
							   latLng = latLngArr[0] + ", " + latLngArr[1];
							   System.out.println("latLngArr inside "+latLngArr);
						    }	
							if( E12GenericUtility.checkNull(latLng).length() > 0 )
							{
	                            String query = "update strg_customer set geo_pos = ?,CHG_USER=?,CHG_TERM=?,CHG_DATE=? where sc_code = ?";
								pstmt1 = conn.prepareStatement(query);
								pstmt1.setString(1, latLng);
								pstmt1.setString(2, userId);
								pstmt1.setString(3, chgTerm);
								pstmt1.setTimestamp(4, java.sql.Timestamp.valueOf( sysDate ));
								pstmt1.setString(5, scCode);

								count = pstmt1.executeUpdate();		
								if(pstmt1!=null)
								{
									pstmt1.close();
									pstmt1=null;
								}
								System.out.println("scCode: "+scCode+" count::"+count);
								if(count>0)
								{
									conn.commit();
								}
								else
								{
									String errorDescription="for SC Code "+scCode;
									errString = itmDBAccessEJB.getErrorString("","GEOPOSFLD",userId);
									errString = getModifiedErrorString(errString,errorDescription);
									if ( errString.length() > 0)
									{
										String bifurErrString = errString.substring( errString.indexOf("<Errors>")+8,errString.indexOf("</Errors>"));
										errStringXml.append(bifurErrString);
										//errString = "";
									}
								}
								

							}
							else
							{
								String errorDescription="for SC Code "+scCode;
								errString = itmDBAccessEJB.getErrorString("","GEOPOSFLD",userId);
								errString = getModifiedErrorString(errString,errorDescription);
								if ( errString.length() > 0)
								{
									String bifurErrString = errString.substring( errString.indexOf("<Errors>")+8,errString.indexOf("</Errors>"));
									errStringXml.append(bifurErrString);
									//errString = "";
								}
							}
					//}
					
					
				}
				
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}

			}
			if(module_name.equals("P"))
			{
                final String sql = "SELECT DISTINCT ENTITY_CODE,USER_ID FROM PLACE_TIME_ENT WHERE GEO_POS_ADDR IS NULL AND GEO_POS NOT IN('0,0') ";
				placePstmt = conn.prepareStatement(sql);
				placeRs = placePstmt.executeQuery();
				while (placeRs.next())
				{
					String entityCode = checkNull(placeRs.getString("ENTITY_CODE"));
					String entityUserId = checkNull(placeRs.getString("USER_ID"));
                    sqlQuery = "SELECT GEO_POS,PTE_ID  FROM PLACE_TIME_ENT WHERE ENTITY_CODE = ? "
                    		+ "and chg_date = (SELECT max(chg_date) FROM PLACE_TIME_ENT WHERE ENTITY_CODE = ? AND USER_ID=?) AND USER_ID=? "
                    		+ "AND ENTITY_CODE IN (SELECT SC_CODE FROM STRG_CUSTOMER WHERE SC_CODE IN (SELECT SC_CODE FROM strg_series "
                    		+ "WHERE NVL(STATUS,'N')='Y')) ";
					pstmt = conn.prepareStatement(sqlQuery);
					pstmt.setString(1,entityCode);
					pstmt.setString(2,entityCode);
					pstmt.setString(3,entityUserId);
					pstmt.setString(4,entityUserId);
					rs = pstmt.executeQuery();
					while (rs.next())
					{

						String geo_pos = rs.getString(1);
						String pte_id = rs.getString(2);
						//if("Y".equalsIgnoreCase(googleAddrUpdat))
						//{
							String geoAddress = getAddressFromLatLong(geo_pos);
							String placegeoAddres="";
							if( E12GenericUtility.checkNull(geoAddress).length() > 0 )
							{
								if(geoAddress.length()>120)
								{
									String s1 = geoAddress.substring(0, 120);
									int lastIndex = s1.lastIndexOf(' ');
									String s2 = s1.substring(0, lastIndex);
									placegeoAddres=s2;
								}
								else
								{
									placegeoAddres=geoAddress;	
								}
								
								String query = "UPDATE PLACE_TIME_ENT SET GEO_POS_ADDR = ?,CHG_USER=?,CHG_TERM=?,CHG_DATE=?  WHERE PTE_ID = ?";
								pstmt1 = conn.prepareStatement(query);
								pstmt1.setString(1, placegeoAddres);
								pstmt1.setString(2, userId);
								pstmt1.setString(3, chgTerm);
								pstmt1.setTimestamp(4, java.sql.Timestamp.valueOf( sysDate ));
								pstmt1.setString(5, pte_id);
								count = pstmt1.executeUpdate();
								if(pstmt1!=null)
								{
									pstmt1.close();
									pstmt1=null;
								}
								
								if(count>0)
								{
									conn.commit();								
								}
								else
								{
									String errorDescription="for Place Time Entity, ID is "+pte_id;
									errString = itmDBAccessEJB.getErrorString("","GEOPOSFLD",userId);
									errString = getModifiedErrorString(errString,errorDescription);
									
									if ( errString.length() > 0)
									{
										String bifurErrString = errString.substring( errString.indexOf("<Errors>")+8,errString.indexOf("</Errors>"));
										errStringXml.append(bifurErrString);
										
									}
								}
								System.out.println("pte_id: "+pte_id+" count::"+count);

							}
							else
							{
								String errorDescription="for Place Time Entity, ID is "+pte_id;
								errString = itmDBAccessEJB.getErrorString("","GEOPOSFLD",userId);
								errString = getModifiedErrorString(errString,errorDescription);
								
								if ( errString.length() > 0)
								{
									String bifurErrString = errString.substring( errString.indexOf("<Errors>")+8,errString.indexOf("</Errors>"));
									errStringXml.append(bifurErrString);
									
								}
							}
						//}

					
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt=null;
					}
					if(rs!=null)
					{
						rs.close();
						rs = null;
					}
				}
				if(placePstmt!=null)
				{
					placePstmt.close();
					placePstmt=null;
				}
				if(placeRs!=null)
				{
					placeRs.close();
					placeRs = null;
				}
				
			}
			System.out.println("module_name["+module_name+"] errostring is["+errString+"]");
			if (errString == null || errString.trim().length() == 0)
			{
				conn.commit();
				errString = itmDBAccessEJB.getErrorString("", "GEOPOSSUCC", "", "",	conn);
			}
			else
			{
			   errStringXml.append("</Errors></Root>\r\n");
			   //return errString;
			  errString = errStringXml.toString();
			  System.out.println("errString:::"+errString);
			  Document responseDom = genericUtility.parseString( errString );
		   	  Node errorsNode = responseDom.getElementsByTagName( "Errors" ).item( 0 );
			  System.out.println( "AddGeoPos:errorsNode[" + errorsNode + "]" );
			  if( errorsNode != null )
			  {
				NodeList errorChildNodeList = errorsNode.getChildNodes();
				for(int appCnt = 0; appCnt < errorChildNodeList.getLength(); appCnt++)
				{
					Node currChild = errorChildNodeList.item(appCnt);
					if (currChild.getNodeName().equalsIgnoreCase("error"))
					{
						errString = errStringXml.toString();
						break;
					}
					else
					{
						errString =  "";

					}
				}
			 }
		   }	
			
		}
		catch (Exception e)
		{
			isError=true;
			try {
				conn.rollback();
			}
			catch (SQLException e1) {
				e1.printStackTrace();
			}
			System.out.println("Exception in Process::"+e);
	    }
		finally
		{

			try
			{
				if(isError=false)
				{
					conn.commit();

				}
				
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(pstmt1!=null)
				{
					pstmt1.close();
					pstmt1=null;
				}
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(placePstmt!=null)
				{
					placePstmt.close();
					placePstmt=null;
				}
				if(placeRs!=null)
				{
					placeRs.close();
					placeRs = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
				
			}
			catch(Exception e1)
			{
				System.out.println("Exception in finally block of the process::"+e1);
			}
		
		}
		
		
		return errString;
	}
	
	public static String[] getLatLongPositions(String address) throws Exception
	{
	    int responseCode = 0;
	    System.out.println("getLatLongPositions of address:["+address+"]");
	    System.out.println("Prachi Changes Found");
	    String api = "https://maps.googleapis.com/maps/api/geocode/xml?address=" + URLEncoder.encode(address, "UTF-8") + "&sensor=false&key="+CommonConstants.MAP_API_KEY;
	    System.out.println("URL : "+api);
	    URL url = new URL(api);
	    HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
	    httpConnection.connect();
	    responseCode = httpConnection.getResponseCode();
	    System.out.println("responseCode::["+responseCode+"]");
	    if(responseCode == 200)
	    {
	      DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();;
	      Document document = builder.parse(httpConnection.getInputStream());
	      XPathFactory xPathfactory = XPathFactory.newInstance();
	      XPath xpath = xPathfactory.newXPath();
	      XPathExpression expr = xpath.compile("/GeocodeResponse/status");
	      String status = (String)expr.evaluate(document, XPathConstants.STRING);
	      System.out.println("status::["+status+"]");
	      if(status.equals("OK"))
	      {
	    	 System.out.println("xpath:::"+xpath);
	         expr = xpath.compile("//geometry/location/lat");
	         System.out.println("expr:::"+expr);
	         String latitude = (String)expr.evaluate(document, XPathConstants.STRING);
	         System.out.println("latitude:::"+latitude);
	         expr = xpath.compile("//geometry/location/lng");
	         System.out.println("expr:::"+expr);
	         String longitude = (String)expr.evaluate(document, XPathConstants.STRING);
	         System.out.println("longitude:::"+longitude);
	         return new String[] {latitude, longitude};
	      }
	      else if(status.equals("OVER_QUERY_LIMIT"))
	      {
	    	  Thread.sleep(1000);
	    	  return getLatLongPositions(address);
	      }
	      else
	      {
	         System.out.println("else of get latlong");
             return null;
	      }
	    }
	    return null;
	}
	
	public static String getAddressFromLatLong(String latlong) throws Exception
	{
	    int responseCode = 0;
	    System.out.println("getAddressFromLatLong of latlong:["+latlong+"]");
	    System.out.println("Prachi Changes Found Addressfromlatlong");
	    String api = "https://maps.googleapis.com/maps/api/geocode/xml?latlng="+latlong+"&key="+CommonConstants.MAP_API_KEY;
	    System.out.println("URL Add : "+api);
	    URL url = new URL(api);
	    HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
	    httpConnection.connect();
	    responseCode = httpConnection.getResponseCode();
	    System.out.println("responseCode::["+responseCode+"]");
	    if(responseCode == 200)
	    {
	      DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();;
	      Document document = builder.parse(httpConnection.getInputStream());
	      XPathFactory xPathfactory = XPathFactory.newInstance();
	      XPath xpath = xPathfactory.newXPath();
	      XPathExpression expr = xpath.compile("/GeocodeResponse/status");
	      String status = (String)expr.evaluate(document, XPathConstants.STRING);
	      System.out.println("status::["+status+"]");
	      if(status.equals("OK"))
	      {
	    	 System.out.println("xpath:::"+xpath);
	         expr = xpath.compile("//result/formatted_address");
	         System.out.println("expr:::"+expr);
	         String Address = (String)expr.evaluate(document, XPathConstants.STRING);
	         System.out.println("Address:::"+Address);
	         
	         return Address;
	      }
	      else if(status.equals("OVER_QUERY_LIMIT"))
	      {
	    	  Thread.sleep(1000);
	    	  return getAddressFromLatLong(latlong);
	      }
	      else
	      {
	         System.out.println("else of get address");
             return null;
	      }
	    }
	    return null;
	}
	
	private String getModifiedErrorString(String errString, String modifiedString)
	{
		String xmlStr1 = "";
		String xmlStr2 = "";
		//String xmlStr3 = "";
		try
		{
			if(errString.indexOf("<trace>") != -1)
			{
				xmlStr1 = errString.substring(0,errString.indexOf("<trace>"));
				//xmlStr3 = errString.substring(errString.indexOf("<description>")+"<description>".length(),errString.indexOf("</description>"));
				xmlStr2 = errString.substring(errString.indexOf("</trace>")+"</trace>".length());

				modifiedString = "<trace>" + modifiedString + "</trace>";

				errString = xmlStr1 + modifiedString + xmlStr2;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		//System.out.println("getModifiedErrorString >> errString ::"+errString);
		return errString;
	}
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

}