/********************************************************
	      Title : CustomerUpload
	      Date  : 06/DEC/2021
	      Developer:Bhagyashri Tikone
 ********************************************************/
package ibase.webitm.ejb.wsfa.masters;

import ibase.webitm.ejb.ValidatorEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CustomerUpload extends ValidatorEJB
{
	E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("xmlString CustUpload::::"+xmlString);
			System.out.println("xmlString CustUpload1::::"+xmlString1);
			System.out.println("xmlString CustUpload2::::"+xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		//System.out.println("Inside wfvaldata CustomerUpload");
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "";
		String sql="";
		boolean isNumber = true;
		String salesPers="";
		String errCode="";
		String scCode="";
		String effDate="";
		String valUpToDate="";
		String errorType = "";
		String errString = "";
		String custTypeDom="";
		String custTypeDes="";
		String noVisit="";
		String stateCode="";
		String gender="";
		String shortId="";
		String localityCode="";
		String classCode="";
		String speciality="";
		String specialStrg="";
		int ctr=0;
		String qualification="";
		String custType="";
		int childNodeListLength;
		int currentFormNo = 0;
		long cnt = 0;
		String qualStrg;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			//System.out.println("Login userid is:"+userId);
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					//System.out.println("childNodeName cust_upload is:"+childNodeName);
					if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULSLSPER ";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							salesPers = genericUtility.getColumnValue("sales_pers", dom);
							sql = "select count(1) from sales_pers where sales_pers = ?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,salesPers);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}

							if(cnt == 0)
							{
								errCode = "SLPNOTEXT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if(childNodeName.equalsIgnoreCase("cust_type"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "VCUSTTYPE";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							custTypeDom = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
							//System.out.println("print custypedom====>["+custTypeDom+"]");
							int seriesCount = 0;
							String countSerSql = "select COUNT(1) as COUNT from gencodes where fld_name='CUST_TYPE' and mod_name='W_WSFA_STRG_CUSTOMER' and fld_value= ?";
							PreparedStatement pstmtSeriesCnt = conn.prepareStatement(countSerSql);
							pstmtSeriesCnt.setString(1, custTypeDom);
							ResultSet rsCnt = pstmtSeriesCnt.executeQuery();
							//System.out.println("countSerSql custUpload"+countSerSql);
							if(rsCnt.next())
							{
								seriesCount = rsCnt.getInt("COUNT");
							}
							if(seriesCount == 0 )
							{
								errCode = "INVCUSTYPE";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}//cust_type val
					else if(childNodeName.equalsIgnoreCase("short_id"))
					{
						String custTypeMain = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
						if( childNode.getFirstChild() == null  && custTypeMain.equalsIgnoreCase("D"))
						{
							errCode = "NULLSHRID";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}

					}//short_id val
					else if(childNodeName.equalsIgnoreCase("sc_code"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLSCODE";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							scCode = checkNull(genericUtility.getColumnValue("sc_code", dom));
							shortId = checkNull(genericUtility.getColumnValue("short_id", dom));
							sql = "select count(1) from strg_customer where sc_code = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,scCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt >= 1)
							{
								errCode = "VSTRGCODE1";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
							custTypeDom = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
							if("D".equalsIgnoreCase(custTypeDom))
							{
								sql = "select count(1) from strg_series where sales_pers = ? and short_id=? and status='Y'";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,salesPers);
								pstmt.setString(2,shortId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;
								if(cnt >= 1)
								{
									errCode = "VSTRGCODE2";
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
								}
							}		
						}	
					}//sc_code val
					else if(childNodeName.equalsIgnoreCase("first_name"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLFNAME";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							if( editFlag.equalsIgnoreCase("A") )
							{
								String locCode =genericUtility.getColumnValue("locality_code",dom);
								String firstName =genericUtility.getColumnValue("first_name",dom);
								String middleName =genericUtility.getColumnValue("middle_name",dom);
								String lastName =genericUtility.getColumnValue("last_name",dom);
								String mobileNo =genericUtility.getColumnValue("mobile_no",dom);
								String regNo =genericUtility.getColumnValue("reg_no",dom);
								String sccCode =genericUtility.getColumnValue("sc_code",dom);
								String custmrType =genericUtility.getColumnValue("cust_type",dom);
								System.out.println("custmrType["+custmrType+"]locCode["+locCode+"]regNo["+regNo+"]");

								sql = "SELECT FN_CHK_DUP_STRGCUST(?,?,?,?,?,?,?,?) AS DUP_RECORD FROM DUAL";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString(1, locCode );
								pstmt.setString(2, firstName );
								pstmt.setString(3, middleName );
								pstmt.setString(4, lastName );
								pstmt.setString(5, mobileNo );
								pstmt.setString(6, regNo );
								pstmt.setString(7, sccCode );
								pstmt.setString(8, custmrType );

								rs = pstmt.executeQuery();
								if(rs.next())
								{
									if(rs.getInt("DUP_RECORD") > 0)
									{
										errCode = "DUPRECFOND";
										errList.add( errCode );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							}

						}
					}//first_name
					else if(childNodeName.equalsIgnoreCase("address_as"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLADDAS";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}//address_as
					else if (childNodeName.equalsIgnoreCase("eff_from"))
					{
						effDate = genericUtility.getColumnValue("eff_from",dom);
						Timestamp timestamp = new Timestamp(System.currentTimeMillis());
						if ( effDate == null || effDate.trim().length() == 0 )
						{
							errCode = "NULLEFFDT";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}//eff_from
					else if(childNodeName.equalsIgnoreCase("qualification"))
					{
						String custTypeMain = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
						if(custTypeMain.equalsIgnoreCase("D"))
						{
							if( childNode.getFirstChild() == null)
							{
								errCode = "NULLQUAL";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
							else
							{
								qualification = genericUtility.getColumnValue("qualification",dom);
								//System.out.println("currentColumn qualification =["+qualification+"]");
								String qualMulti[] = qualification.split(",");
		
								for(int i = 0; i < qualMulti.length; i++)
								{
									qualStrg = qualMulti[i].trim().toLowerCase();
									sql = "select count(1) from qualification where lower(trim(qlf_code))=?";
									pstmt =  conn.prepareStatement(sql);
									pstmt.setString(1,qualStrg);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt =  rs.getInt(1);
									}
									rs.close(); rs = null;
									pstmt.close(); pstmt = null;
									if(cnt == 0)
									{
										errCode = "INVQUALCD";
										errList.add( errCode );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
								
							}
						}

					}//qualification val
					else if(childNodeName.equalsIgnoreCase("speciality_descr"))
					{
						String custTypeMain = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
						if(custTypeMain.equalsIgnoreCase("D"))
						{
							if( childNode.getFirstChild() == null)
							{
								errCode = "VSPLDESC";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
							else
							{
								speciality = checkNull(genericUtility.getColumnValue("speciality_descr",dom));
	
								String splMulti[]= speciality.split(",");
	
								for(int i =0; i < splMulti.length ; i++)
								{
									specialStrg= splMulti[i].trim().toLowerCase();
									sql = "select count(1) from speciality where lower(trim(descr))=?";
									pstmt =  conn.prepareStatement(sql);
									pstmt.setString(1,specialStrg);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt =  rs.getInt(1);
									}
									rs.close(); rs = null;
									pstmt.close(); pstmt = null;
									if(cnt == 0)
									{
										errCode = "INVSPEDES";
										errList.add( errCode );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
							}
						}
					}//speciality_descr
					else if(childNodeName.equalsIgnoreCase("class_code"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULCLSCODE";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							classCode = checkNull(genericUtility.getColumnValue("class_code", dom));
							custTypeDom = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
							sql = "select count(1) from strg_cust_class where class_code = ? and cust_type=?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,classCode);
							pstmt.setString(2,custTypeDom);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "INVCLASSCD";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						
					}//class_code val
					else if(childNodeName.equalsIgnoreCase("no_visit"))
					{
						String custTypeMain = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
						if(custTypeMain.equalsIgnoreCase("D"))
						{
							if( childNode.getFirstChild() == null)
							{
								errCode = "NULLVISIT";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
							else
							{
								noVisit = checkNull(genericUtility.getColumnValue("no_visit", dom));
								isNumber = checkNumeric( noVisit );
								//System.out.println("isNumber =["+isNumber+"]");
								if ( !isNumber )
								{
									errCode = "INVAVISIT";
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
					}//no_visit
					else if(childNodeName.equalsIgnoreCase("sex"))
					{
						gender = checkNull(genericUtility.getColumnValue("sex", dom));
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULSEXSEL";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else if( gender.trim().length() > 0 && !("M".equalsIgnoreCase(gender) || "F".equalsIgnoreCase(gender)) ) 
						{
							errCode = "INVGENDER";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}//gender val
					else if(childNodeName.equalsIgnoreCase("locality_code"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLOCCODE";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							localityCode = checkNull(genericUtility.getColumnValue("locality_code", dom));
							sql = "select count(1) from locality where locality_code = ?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,localityCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "LOCNOTEXTS";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}//locality_code
					else if(childNodeName.equalsIgnoreCase("stan_type"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLSTNTYP";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							String stanType = checkNull(genericUtility.getColumnValue("stan_type", dom));
							stanType = stanType.trim().toLowerCase();
							sql = "select count(1) from stantype where lower(trim(stan_type)) = ?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,stanType);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "INVSTANTYP";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}//stan_type val
					else if(childNodeName.equalsIgnoreCase("reg_no"))
					{
						String regNo = checkNull(genericUtility.getColumnValue("reg_no", dom));
						String transactioId = checkNull(genericUtility.getColumnValue("tran_id", dom));
						//System.out.println("regNo659::["+regNo+"]transactioId["+transactioId+"]");
						if( childNode.getFirstChild() != null )
						{
							sql = "select count(1) from strg_customer where reg_no = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,regNo);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								//System.out.println("cntstrgcust["+cnt+"]");
							}
							if (cnt == 0)
							{
								sql = "select count(1) from strgcust_upload where reg_no = ? and tran_id <> ?";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,regNo);
								pstmt.setString(2,transactioId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
									//System.out.println("cnt>>>>["+cnt+"]");
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
							}
							if(cnt > 0)
							{
								errCode = "DUPPREGNO";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
							else if(cnt==0 && regNo.length() > 5) 							
							{
								//System.out.println("inside the condtion");
								String councilNo= regNo.substring(0, 5);
								int count =0;
								sql="SELECT COUNT(*) AS COUNT FROM GENCODES WHERE FLD_NAME='REG_NO' AND MOD_NAME='W_WSFA_STRG_CUSTOMER' AND FLD_VALUE =? ";
								
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,councilNo);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count =  rs.getInt("COUNT");
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
								if(count == 0)
								{
									errCode = "INVREGNO";
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
									
								}
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close(); 
								pstmt = null;
							}	
						}//if childnode not null
					}//reg_no val
					else if(childNodeName.equalsIgnoreCase("cust_type_descr"))
					{
						if( childNode.getFirstChild() == null)
						{
							errCode = "VCUSTDESC";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							custTypeDes = checkNull(genericUtility.getColumnValue("cust_type_descr",dom));
							custTypeDes = custTypeDes.trim().toLowerCase();
							//System.out.println("currentColumn custTypeDes =["+custTypeDes+"]");
							sql = "select count(1) from strg_cust_type where lower(trim(sh_descr))=?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,custTypeDes);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "INVCUSTDES";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}//cust_type_descr
					else if(childNodeName.equalsIgnoreCase("age"))
					{
						String age = checkNull(genericUtility.getColumnValue("age", dom));
						System.out.println("Age is::["+age+"]");
						//System.out.println("childNode.getFirstChild()::["+childNode.getFirstChild()+"]");
						if( childNode.getFirstChild() != null && age.trim().length()>3)
						{
							System.out.println("Inside age is not null");
							errCode = "INVSCAGE";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}//if childnode not null
					}//age val
				}//end of for
				break;
			}//end of switch
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);

					errString = getErrorString(errFldName, errCode, userId);

					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));

						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}//end of try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				connDriver = null;
				if(conn != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;	
	}//end of wfvaldata
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			System.out.println("xmlString custuploadic::"+xmlString);
			System.out.println("xmlString custuploadic1::"+xmlString1);
			System.out.println("xmlString custuoploadic2::"+xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [CustomerUpload][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		//System.out.println("Itemchange method in CustomerUpload");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String stateCode="";
		String sql = "",effDate = "",status = "",stanCodeDescr = "",stanCode = "";
		String salesPers="";
		String spName= "";
		String localityDes="";
		String stateName="";
		String localityCode="";
		String custTypeDes="";
		String custType="";
		String classCode="";
		String classCodeDes="";
		int currentFormNo = 0;
		SimpleDateFormat simpleDateFormat = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		StringBuffer valueXmlString = new StringBuffer();
		ConnDriver connDriver = new ConnDriver();
		try
		{
			conn = getConnection();
			conn.setAutoCommit(false);
			connDriver = null;
			String userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
						
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			//System.out.println("Itemchange method currentformno:"+currentFormNo);
			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?><Root><Header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></Header>");
			valueXmlString.append("<Detail1>");
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());
			String currDate = simpleDateFormat.format(timestamp);
			//System.out.println("currentColumn inCustomer upload =["+currentColumn+"]");
			if(currentColumn.trim().equalsIgnoreCase("itm_default"))
			{
				//Added effective Date and Status Itemchange on ItmDefault
				effDate = genericUtility.getColumnValue("eff_date", dom);
				
				if(effDate == null || effDate.trim().length() == 0)
				{
					valueXmlString.append("<eff_from>").append("<![CDATA[" + currDate +"]]>").append("</eff_from>");
				}
				
				status = genericUtility.getColumnValue("status", dom);
				
				if(status == null || status.trim().length() == 0)
				{
					status = "A";
					valueXmlString.append("<status>").append(status).append("</status>");
				}
				//Added effective Date and Status Itemchange on ItmDefault

				valueXmlString.append("<tran_date>").append("<![CDATA[" + currDate +"]]>").append("</tran_date>");
				valueXmlString.append("<load_status>").append("N").append("</load_status>");
				valueXmlString.append("<loaded_by>").append("<![CDATA[" + userId +"]]>").append("</loaded_by>");
				valueXmlString.append("<loaded_on>").append("<![CDATA[" + currDate +"]]>").append("</loaded_on>");
			}
			else if(currentColumn.trim().equalsIgnoreCase("sales_pers"))
			{
				salesPers = genericUtility.getColumnValue("sales_pers", dom);
				sql = "select sp_name from sales_pers where sales_pers = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					spName = checkNull(rs.getString("sp_name"));
				}
				valueXmlString.append("<sp_name>").append("<![CDATA[" + spName +"]]>").append("</sp_name>");
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
			else if(currentColumn.trim().equalsIgnoreCase("cust_type_descr"))
			{
				custTypeDes = checkNullAndTrim(genericUtility.getColumnValue("cust_type_descr", dom));
				if ( custTypeDes.length() > 0 )
				{
					custTypeDes = custTypeDes.toLowerCase();
				}
				sql = "select type from strg_cust_type where lower(trim(sh_descr)) = ? ";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,custTypeDes);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					custType = checkNull(rs.getString("type"));
				}
				//System.out.println("cust_type_descr is["+classCode+"]custType is ::["+custType+"]");
				valueXmlString.append("<cust_type>").append("<![CDATA["+custType+"]]>").append("</cust_type>");
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
			}
			else if(currentColumn.trim().equalsIgnoreCase("class_code_descr"))
			{
				custType = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
				classCodeDes = checkNullAndTrim(genericUtility.getColumnValue("class_code_descr", dom));
				if ( classCodeDes.length() > 0 )
				{
					classCodeDes = classCodeDes.toLowerCase();
				}
				sql = "select class_code from strg_cust_class where lower(trim(class_code_descr)) = ? and cust_type = ? ";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,classCodeDes);
				pstmt.setString(2,custType);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					classCode = checkNull(rs.getString("class_code"));
				}
				//System.out.println("class_code["+classCode+"]custType["+custType+"]");
				valueXmlString.append("<class_code>").append("<![CDATA["+classCode+"]]>").append("</class_code>");
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
			}
			else if(currentColumn.trim().equalsIgnoreCase("locality_descr"))
			{
				localityDes = checkNullAndTrim(genericUtility.getColumnValue("locality_descr", dom));
				stanCodeDescr = checkNullAndTrim(genericUtility.getColumnValue("stan_code_descr", dom));
				stateCode = checkNullAndTrim(genericUtility.getColumnValue("state_code", dom));
				
				if ( stanCodeDescr.length() > 0 )
				{
					stanCodeDescr = stanCodeDescr.toLowerCase();
				}
				
				sql = "select stan_code from station where lower(trim(descr)) = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,stanCodeDescr);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				if ( localityDes.length() > 0 )
				{
					localityDes = localityDes.toLowerCase();
				}
				sql = "select locality_code from locality where lower(trim(descr)) = ? and stan_code = ? and state_code = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,localityDes);
				pstmt.setString(2,stanCode);
				pstmt.setString(3, stateCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					localityCode = checkNull(rs.getString("locality_code"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				valueXmlString.append("<locality_code>").append("<![CDATA["+localityCode+"]]>").append("</locality_code>");
			}
			else if(currentColumn.trim().equalsIgnoreCase("sc_code"))
			{
				//Added by ManishK to generate SC_CODE from sequence [START]
				String scCode = "";
				scCode = checkNull(genericUtility.getColumnValue("sc_code", dom));
				//Added condition to only generate scCode if it is null
				if(scCode == null || scCode.trim().length() == 0)
				{
					String scCodeSql = "select 'SC' || substr( '0000000000' || gen_sc_code_seq.nextval , -8 ) AS SC_CODE_SEQ from dual";
					PreparedStatement pstmtScCode = conn.prepareStatement(scCodeSql);
					ResultSet rsScCode = pstmtScCode.executeQuery();
					if(rsScCode.next())
					{
						scCode = rsScCode.getString("SC_CODE_SEQ");
					}
					if(rsScCode != null)
					{
						rsScCode.close();
						rsScCode = null;
					}
					if(pstmtScCode != null)
					{
						pstmtScCode.close();
						pstmtScCode = null;
					}
				}
				//Added by ManishK to generate SC_CODE from sequence [END]
				valueXmlString.append("<sc_code>").append("<![CDATA[" + scCode +"]]>").append("</sc_code>");
			}
			else if(currentColumn.trim().equalsIgnoreCase("short_id"))
			{
				//Added by ManishK to generate shortId [START]
				String shortId = "";
				salesPers = genericUtility.getColumnValue("sales_pers", dom);
				String shortIdSql = "select max(case when short_id is null then 0 else short_id end) + 1 as MAX_SHORT_ID from strg_series where sales_pers= ?";
				PreparedStatement pstmtShortId = conn.prepareStatement(shortIdSql);
				pstmtShortId.setString(1, salesPers);
				ResultSet rsShortId = pstmtShortId.executeQuery();
				if(rsShortId.next())
				{
					shortId = rsShortId.getString("MAX_SHORT_ID");
				}
				if(rsShortId != null)
				{
					rsShortId.close();
					rsShortId = null;
				}
				if(pstmtShortId != null)
				{
					pstmtShortId.close();
					pstmtShortId = null;
				}
				
				//Added condition to start shortId from One if no series is present aganist the salespers
				if(shortId == null || shortId.trim().length() == 0)
				{
					shortId = "1";
				}
				//Added condition to start shortId from One if no series is present aganist the salespers
				
				//Added by ManishK to generate shortId [END]
				valueXmlString.append("<short_id>").append("<![CDATA[" + shortId +"]]>").append("</short_id>");
			}
			//Added FirstName itemchange[START]
			else if(currentColumn.trim().equalsIgnoreCase("first_name"))
			{
				
				String firstName = checkNullAndTrim(genericUtility.getColumnValue("first_name", dom));
				String addressAs = checkNull(genericUtility.getColumnValue("address_as", dom));
				
				if(addressAs == null || addressAs.trim().length() == 0) 
				{
					//Added by Rahul P. to substring firstname if length is > 15 as addressAs length is set to 15 in table [START]
					if (firstName.length() > 15) 
					{
						firstName = firstName.substring(0,15);
					}
					//Added by Rahul P. to substring firstname if length is > 15 as addressAs length is set to 15 in table [END]
					valueXmlString.append("<address_as>").append("<![CDATA[" + firstName +"]]>").append("</address_as>");
				}
			}
			//Added FirstName itemchange[END]
			//Added Address itemchange[START]
			else if(currentColumn.trim().equalsIgnoreCase("addr1"))
			{
				/*String address = checkNull(genericUtility.getColumnValue("addr1", dom));
				String address2 = checkNull(genericUtility.getColumnValue("addr2", dom));
				String address3 = checkNull(genericUtility.getColumnValue("addr3", dom));
								
				if((address.trim().length() > 40) && ((address2.trim().length() == 0 || address2 == null) && (address3.trim().length() == 0 || address3 == null)))
				{
					valueXmlString.append("<addr1>").append("<![CDATA[" + address.substring(0,40) +"]]>").append("</addr1>");
					valueXmlString.append("<addr2>").append("<![CDATA[" + address.substring(40,Math.min(address.length(), 80)) +"]]>").append("</addr2>");
					valueXmlString.append("<addr3>").append("<![CDATA[" + address.substring(Math.min(80, address.length())) +"]]>").append("</addr3>");
				}
				else if((address.trim().length() < 40) && ((address2.trim().length() == 0 || address2 == null) && (address3.trim().length() == 0 || address3 == null)))
				{
					valueXmlString.append("<addr1>").append("<![CDATA[" + address +"]]>").append("</addr1>");
					valueXmlString.append("<addr2>").append("<![CDATA[" + address +"]]>").append("</addr2>");
					valueXmlString.append("<addr3>").append("<![CDATA[" + address +"]]>").append("</addr3>");
				}*/
				
				//Changed by Rahul P. on 16-Feb-24  [START]
				BaseLogger.log("3",null,null,"Inside itemchange => currentColumn : addr1");
				
				String address = checkNullAndTrim(genericUtility.getColumnValue("addr1", dom));
				String address2 = checkNullAndTrim(genericUtility.getColumnValue("addr2", dom));
				String address3 = checkNullAndTrim(genericUtility.getColumnValue("addr3", dom));
				
				BaseLogger.log("3",null,null,"Inside itemchange => addressLength : ["+address.length()+"] & address : ["+address+"]");
				
				if ((address.length() <= 40) && (address2.isEmpty() && address3.isEmpty())) 
				{
					valueXmlString.append("<addr1>").append("<![CDATA[" + address + "]]>").append("</addr1>");
					valueXmlString.append("<addr2>").append("<![CDATA[" + address + "]]>").append("</addr2>");
					valueXmlString.append("<addr3>").append("<![CDATA[" + address + "]]>").append("</addr3>");
				} 
				else if ((address.length() > 40 && address.length() <= 80) && (address2.isEmpty() && address3.isEmpty())) 
				{
					int spaceIndex1 = address.lastIndexOf(' ', 40);												
					int spaceIndex2 = address.lastIndexOf(' ', 80);
					BaseLogger.log("3", null, null, "currentColumn : addr1[case1] => spaceIndex1 : [" + spaceIndex1 + "] & spaceIndex2 : [" + spaceIndex2 + "]");
					String tempAddress = address;
					if (spaceIndex1 != -1) 
					{
						address = address.substring(0, spaceIndex1);
					}
					if (spaceIndex2 != -1) 
					{
						address2 = tempAddress.substring(spaceIndex1 + 1, spaceIndex2);
						if(address2.trim().length() > 40)
						{
							address2 = address2.trim().substring(0,address2.lastIndexOf(' ', 40));
						}
					}
					BaseLogger.log("3",null,null,"address[case1] : ["+address+"]");
					BaseLogger.log("3",null,null,"address2[case1] : ["+address2+"]");

					valueXmlString.append("<addr1>").append("<![CDATA[" + address + "]]>").append("</addr1>");
					valueXmlString.append("<addr2>").append("<![CDATA[" + address2 + "]]>").append("</addr2>");
					valueXmlString.append("<addr3>").append("<![CDATA[]]>").append("</addr3>");
				} 
				else if ((address.length() > 80) && (address2.isEmpty() && address3.isEmpty())) 
				{
					int spaceIndex1 = address.lastIndexOf(' ', 40);
					int spaceIndex2 = address.lastIndexOf(' ', 80);
					int spaceIndex3 = address.lastIndexOf(' ', 120);
					BaseLogger.log("3", null, null, "currentColumn : addr1[case2] => spaceIndex1 : [" + spaceIndex1 + "] & spaceIndex2 : [" + spaceIndex2 + "] & spaceIndex3 : [" + spaceIndex3 + "]");
					String tempAddress = address;

					if (spaceIndex1 != -1) 
					{
						address = address.substring(0, spaceIndex1);
					}
					if (spaceIndex2 != -1) 
					{
						address2 = tempAddress.substring(spaceIndex1 + 1, spaceIndex2);
						if(address2.trim().length() > 40)
						{
							address2 = address2.trim().substring(0,address2.lastIndexOf(' ', 40));
						}
					}
					if (spaceIndex3 != -1) 
					{
						address3 = tempAddress.substring(spaceIndex2 + 1, spaceIndex3);
						if(address3.trim().length() > 40)
						{
							address3 = address3.trim().substring(0,address3.lastIndexOf(' ', 40));
						}
					}
					
					BaseLogger.log("3",null,null,"address[case2] : ["+address+"]");
					BaseLogger.log("3",null,null,"address2[case2] : ["+address2+"]");
					BaseLogger.log("3",null,null,"address3[case2] : ["+address3+"]");

					valueXmlString.append("<addr1>").append("<![CDATA[" + address + "]]>").append("</addr1>");
					valueXmlString.append("<addr2>").append("<![CDATA[" + address2 + "]]>").append("</addr2>");
					valueXmlString.append("<addr3>").append("<![CDATA[" + address3 + "]]>").append("</addr3>");
				}
				//Changed by Rahul P. on 16-Feb-24 [END]
			}
			//Added Address itemchange[END]
			//Added Station itemchange[START]
			else if(currentColumn.trim().equalsIgnoreCase("stan_code_descr"))
			{
				stanCodeDescr = checkNullAndTrim(genericUtility.getColumnValue("stan_code_descr", dom));
				
				if ( stanCodeDescr.length() > 0 )
				{
					stanCodeDescr = stanCodeDescr.toLowerCase();
				}
				sql = "select stan_code from station where lower(trim(descr)) = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,stanCodeDescr);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				valueXmlString.append("<stan_code>").append("<![CDATA["+stanCode+"]]>").append("</stan_code>");
			}
			//Added Station itemchange[END]
			valueXmlString.append("</Detail1>");
			valueXmlString.append("</Root>");
		}//end try
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				connDriver = null;
				if(conn != null)
				{
					if(rs != null)
						rs.close();
					if(pstmt != null)
						pstmt.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
		}
		System.out.println("valueXmlString custupload ic ::"+valueXmlString.toString());
		return valueXmlString.toString();	
	}//end itemchange
	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		try
		{
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,errorCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}
	private String checkNullAndTrim(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value.trim();
	}
	private String checkNull(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value;
	}
	private boolean checkNumeric( String noOfLabel ) throws Exception
	{
		char[] cArray = noOfLabel.toCharArray();
		boolean isNumber = true;
		for(int i = 0; i < cArray.length;i++)
		{
			if( !Character.isDigit(cArray[i]) )
			{
				isNumber = false;
			}
		}
		return isNumber;
	}
}