/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.E12GenericUtility;
import ibase.utility.XMLUtility;
import ibase.webitm.ejb.MasterStatefulRemote;
import ibase.wrkflw.TransSaveLocal;
import ibase.wrkflw.TransSaveRemote;
import ibase.wrkflw.WorkflowProcessDataMangerEJB;
import ibase.wrkflw.WorkflowProcessInstanceMonitorEJB;
import ibase.wrkflw.utility.WorkflowLogger;
import ibase.wrkflw.utility.WorkflowProcessIdGenerator;
import java.util.HashMap;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class TransSave
implements TransSaveLocal,
TransSaveRemote {
    @Override
    public String saveChangeInTrans(String entityId, String prcInstId, String performerCode, String editFlag) throws BaseException {
        WorkflowLogger.info("Saving Transaction in ITM prcInstId :[" + prcInstId + "] performerCode :[" + performerCode + "] editFlag :[" + editFlag + "] ");
        String retString = "";
        try {
            String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(prcInstId);
            String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(prcInstId);
            String activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(prcInstId);
            String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(prcInstId);
            WorkflowProcessDataMangerEJB workflowProcessDataManger = new WorkflowProcessDataMangerEJB();
            HashMap paramMap = workflowProcessDataManger.getProcessInputData(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId));
            workflowProcessDataManger = null;
            WorkflowLogger.info("paramMap " + paramMap);
            String objName = (String)paramMap.get("$OBJ_NAME");
            String refId = (String)paramMap.get("$REF_ID");
            String transInfo = (String)paramMap.get("$XML_DATA_ALL");
            this.saveChangeInTrans(objName, refId, entityId, prcInstId, transInfo, performerCode, editFlag);
        }
        catch (BaseException be) {
            be.printStackTrace();
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e);
        }
        return retString;
    }

    @Override
    public String saveChangeInTrans(String objName, String refId, String entityId, String prcInstId, String transInfo, String performerCode, String editFlag) throws BaseException {
        WorkflowLogger.info("Saving Transaction in ITM objName [" + objName + "] refId [" + refId + "] entityId [" + entityId + "] prcInstId :[" + prcInstId + "] performerCode :[" + performerCode + "] editFlag :[" + editFlag + "] \ntransInfo length :[" + transInfo.length() + "]");
        String retString = "";
        try {
            String siteCode = "";
            if ("A".equalsIgnoreCase(editFlag)) {
                retString = this.callProcessRequest(entityId, siteCode, objName, "A", prcInstId, transInfo, refId);
            } else {
                String chgDataStr = this.getChangedDataString(transInfo, refId);
                if (chgDataStr != null && chgDataStr.length() > 0) {
                    transInfo = chgDataStr;
                }
                retString = this.callProcessRequest(entityId, siteCode, objName, "E", prcInstId, transInfo, refId);
            }
            String resultStr = "";
            String statusStr = "";
            String activityStatus = "";
            WorkflowLogger.info("retString [" + retString + "]");
            if (retString.indexOf("<Errors>") == -1) {
                XMLUtility xmlUtility = new XMLUtility();
                Document transInfoDom = XMLUtility.parseString(retString);
                Node tranIdNode = transInfoDom.getElementsByTagName("TRAN_ID").item(0);
                if (tranIdNode == null) {
                    tranIdNode = transInfoDom.getElementsByTagName("TranID").item(0);
                }
                if (tranIdNode != null) {
                    resultStr = tranIdNode.getNodeValue();
                }
                activityStatus = "2";
                statusStr = "1";
            } else {
                E12GenericUtility genericUtility = new E12GenericUtility();
                Document retStringDom = genericUtility.parseString(retString);
                Node description = retStringDom.getElementsByTagName("description").item(0);
                resultStr = description != null && description.getFirstChild() != null ? "Error Description :<description>" + description.getFirstChild().getNodeValue() + "</description>" : "Error With No Description";
                activityStatus = "2";
                statusStr = "0";
            }
            WorkflowLogger.info("Result of Trans Save activity activityStatus :[" + activityStatus + "] resultStr :[" + resultStr + "] statusStr :[" + statusStr + "]");
            String resultXmlStr = "<ROOT><STATUS><![CDATA[" + statusStr + "]]></STATUS><RESULT><![CDATA[" + resultStr + "]]></RESULT></ROOT>";
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitor = new WorkflowProcessInstanceMonitorEJB();
            WorkflowLogger.info("Calling workflowProcessInstanceMonitor.updateActivityStatus with '2' from transSave");
            workflowProcessInstanceMonitor.updateActivityStatus(prcInstId, activityStatus, null, null, null, performerCode, "E", resultXmlStr);
        }
        catch (BaseException be) {
            be.printStackTrace();
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e);
        }
        return retString;
    }

    private String callProcessRequest(String userId, String siteCode, String objName, String editFlag, String prcInstId, String data, String refId) throws BaseException {
        WorkflowLogger.info("callProcessRequest for userId :[" + userId + "] siteCode :[" + siteCode + "] objName :[" + objName + "] editFlag :[" + editFlag + "] prcInstId :[" + prcInstId + "] refId :[" + refId + "] \n data.length() :[" + data.length() + "]");
        String retString = "";
        MasterStatefulRemote masterStateful = null;
        try {
            try {
                if (userId == null || userId != null && userId.length() == 0) {
                    userId = "SYSTEM";
                }
                WorkflowLogger.info("userId :[" + userId + "]");
                StringBuffer dataBuff = new StringBuffer("<Root>");
                dataBuff.append("<Header0>");
                dataBuff.append("<objName><![CDATA[" + objName + "]]></objName>");
                dataBuff.append("<pageContext><![CDATA[2]]></pageContext>");
                dataBuff.append("<editFlag><![CDATA[").append(editFlag).append("]]></editFlag>");
                dataBuff.append("<focusedColumn><![CDATA[]]></focusedColumn>");
                dataBuff.append("<action><![CDATA[").append(editFlag == "E" ? "EDIT" : "SAVE").append("]]></action>");
                dataBuff.append("<elementName><![CDATA[]]></elementName>");
                dataBuff.append("<taxKeyValue><![CDATA[]]></taxKeyValue>");
                dataBuff.append("<taxInFocus><![CDATA[false]]></taxInFocus>");
                dataBuff.append("<objContext><![CDATA[1]]></objContext>");
                dataBuff.append("<forcedSave><![CDATA[true]]></forcedSave>");
                dataBuff.append("<keyValue><![CDATA[1]]></keyValue>");
                dataBuff.append("<pkValues><![CDATA[").append(refId).append("]]></pkValues>");
                dataBuff.append("<saveLevel><![CDATA[1]]></saveLevel>");
                dataBuff.append("<wrkflwProcInstId><![CDATA[" + prcInstId + "]]></wrkflwProcInstId>");
                dataBuff.append("</Header0>");
                E12GenericUtility genericUtility = new E12GenericUtility();
                Node detailNode = genericUtility.parseString(data).getElementsByTagName("Detail1").item(0);
                if (detailNode != null) {
                    dataBuff.append(genericUtility.serializeDom(detailNode, true));
                    Object endDetail = null;
                    while ((detailNode = detailNode.getNextSibling()) != null && detailNode.getNodeType() == 1 && detailNode.getNodeName().startsWith("Detail")) {
                        dataBuff.append(genericUtility.serializeDom(detailNode, true));
                    }
                }
                dataBuff.append("</Root>");
                WorkflowLogger.info("DDDDDDDDDDDDDDDDDDDDd :\n[\n" + dataBuff.toString() + "\n]");
                AppConnectParm appConnect = new AppConnectParm();
                InitialContext ctx = new InitialContext(appConnect.getProperty());
                masterStateful = (MasterStatefulRemote)ctx.lookup("ibase/MasterStatefulEJB/remote");
                WorkflowLogger.info("Invoking MasterStateful processRequest.......");
                retString = masterStateful.processRequest(new String[]{userId, ""}, "", true, dataBuff.toString(), false, null);
                WorkflowLogger.info("Return string from MasterStateful processRequest :[" + retString + "]");
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (masterStateful != null) {
                    masterStateful.remove();
                    masterStateful = null;
                }
            }
            catch (Exception exception) {}
        }
        return retString;
    }

    private String getChangedDataString(String transInfo, String refId) throws BaseException {
        WorkflowLogger.info("transInfo [" + transInfo + "]");
        StringBuffer retString = null;
        StringBuffer chgBuffer = new StringBuffer();
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            XMLUtility xmlUtility = new XMLUtility();
            Document transInfoDom = XMLUtility.parseString(transInfo);
            NodeList headerNodeList = transInfoDom.getElementsByTagName("Header0");
            Node headerNode = headerNodeList.item(0);
            if (headerNode != null) {
                NodeList headerChlidList = headerNode.getChildNodes();
                int noOfHeaderChlid = headerChlidList.getLength();
                int recCtr = 0;
                while (recCtr < noOfHeaderChlid) {
                    Node detailNode = headerChlidList.item(recCtr);
                    String headerChlidName = detailNode.getNodeName();
                    if (headerChlidName.startsWith("Detail")) {
                        String recChg;
                        NamedNodeMap detAttrNodesMap = detailNode.getAttributes();
                        String string = recChg = detAttrNodesMap.getNamedItem("isChg") != null ? detAttrNodesMap.getNamedItem("isChg").getNodeValue() : null;
                        if (recChg != null && recChg.equals("1")) {
                            String domId = detAttrNodesMap.getNamedItem("domID") != null ? detAttrNodesMap.getNamedItem("domID").getNodeValue() : "";
                            String dbId = detAttrNodesMap.getNamedItem("dbID") != null ? detAttrNodesMap.getNamedItem("dbID").getNodeValue() : "";
                            String objCtx = detAttrNodesMap.getNamedItem("objContext") != null ? detAttrNodesMap.getNamedItem("objContext").getNodeValue() : "";
                            chgBuffer.append("<Detail").append(objCtx).append(" domID='" + domId + "'").append(" objContext='" + objCtx + "'").append(" dbID='" + dbId + "' >");
                            NodeList detailChlidList = detailNode.getChildNodes();
                            int noOfDeatilChlid = detailChlidList.getLength();
                            int colCtr = 0;
                            while (colCtr < noOfDeatilChlid) {
                                String colChg;
                                Node colNode = detailChlidList.item(colCtr);
                                NamedNodeMap colAttrNodesMap = colNode.getAttributes();
                                String string2 = colChg = colAttrNodesMap != null && colAttrNodesMap.getNamedItem("isChg") != null ? colAttrNodesMap.getNamedItem("isChg").getNodeValue() : null;
                                if (colChg != null && colChg.equals("1")) {
                                    chgBuffer.append(genericUtility.serializeDom(colNode, true));
                                }
                                ++colCtr;
                            }
                            chgBuffer.append("</Detail" + objCtx + ">");
                        }
                    }
                    ++recCtr;
                }
                retString = new StringBuffer("<Root>");
                if (chgBuffer.indexOf("<Detail1>") == -1) {
                    retString.append("<Detail1 dbID=\"" + refId + "\" domID='1' objContext='1'><tran_id><![CDATA[" + refId + "]]></tran_id></Detail1>" + chgBuffer.toString());
                } else {
                    retString.append(chgBuffer.toString());
                }
                retString.append("</Root>");
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        WorkflowLogger.info("chgBuffer [" + chgBuffer.toString() + "]");
        return retString.toString();
    }

    private InitialContext getInitialContext() throws BaseException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return ctx;
    }
}

