/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.utility.ValidateXMLInput;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DocumentHandlerEJB;
import ibase.webitm.ejb.DocumentHandlerRemote;
import ibase.webitm.ejb.DocumentHandlerWrapperEJB;
import ibase.webitm.utility.ExtractZipFiles;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.sql.BLOB;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentViewerServlet
extends HttpServlet {
    private static final long serialVersionUID = -3255358270532343126L;
    ServletConfig servletConfig = null;
    protected InitialContext ctx = null;
    private static String dirName = null;
    private static int MAX_UPLOAD_SIZE = 734003200;

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        if (CommonConstants.J2EE_VERSION.equals("1")) {
            CommonConstants.setAPPLICATION_CONTEXT(this.servletConfig.getServletContext().getRealPath("/"));
            dirName = String.valueOf(new File(CommonConstants.APPLICATION_CONTEXT).getParentFile().getParent()) + File.separator + "dump";
        } else if (CommonConstants.J2EE_VERSION.equals("2")) {
            dirName = new File(CommonConstants.JBOSSHOME) + File.separator + "dump";
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        BaseLogger.log("2", null, null, "\n\n****** DocumentViewerServlet called ******");
        HttpSession sess = null;
        try {
            sess = request.getSession();
            BaseLogger.log("3", null, null, "\nsess.getId()............... :" + sess.getId());
            if (this.ctx == null) {
                this.ctx = this.getInitialContext();
            }
            this.handleDocument(request, response);
        }
        catch (ITMException itme) {
            try {
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                String errMsg = "ERR_MSG :INVALID_DOCUMENT\n" + itme.getMessage();
                response.setContentLength(errMsg.length());
                writer.println(errMsg);
                writer.flush();
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DocumentViewerServlet :doPost :==>");
            e.printStackTrace();
            try {
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(baos));
                response.setContentLength(baos.toString().length());
                writer.println("ERR_MSG :INVALID_DOCUMENT\n" + baos.toString());
                writer.flush();
                writer.close();
                baos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void handleDocument(HttpServletRequest request, HttpServletResponse response) throws ITMException {
        ServletOutputStream outputStream = null;
        String retStr = "";
        byte[] byteArray = null;
        File fileToDownload = null;
        boolean isResponseWritten = false;
        InputStream inputStream = null;
        try {
            String docId;
            String action = request.getParameter("ACTION");
            String refId = request.getParameter("REF_ID");
            String noExtract = request.getParameter("NO_EXTRACT");
            String refSer = this.getRefSer(request);
            String client = request.getParameter("CLIENT");
            String viewer = request.getParameter("ISVIEWER");
            BaseLogger.log("3", null, null, " handleDocument :: action :[" + action + "] noExtract[" + noExtract + "]");
            DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
            DBAccessEJB dbAccess = new DBAccessEJB();
            String tranDBValue = null;
            UserInfoBean userInformation = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            tranDBValue = userInformation != null ? userInformation.getTransDB() : request.getParameter("ENTERPRISE");
            BaseLogger.log("3", null, null, "**** DNYANESHWAR **** docHandler[" + docHandler + "]");
            if (action.equals("DOCUMENT_GET_DATA")) {
                String refCol = request.getParameter("REF_COL");
                String refIds = refId;
                if (refIds != null && refIds.indexOf(",") != -1) {
                    try {
                        DocumentHandlerWrapperEJB docWrapperHandler = new DocumentHandlerWrapperEJB();
                        BaseLogger.log("3", null, null, "In DocumentViewerServlet docWrapperHandler[" + docWrapperHandler + "]");
                        retStr = docWrapperHandler.getMultiDocumentInfoList(refSer, refIds, refCol, tranDBValue);
                        docWrapperHandler = null;
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception In DocumentViewerServlet getMultiDocumentInfoList : " + e.getMessage());
                        e.printStackTrace();
                    }
                } else {
                    retStr = docHandler.getDocumentInfoList(refSer, refId, refCol, tranDBValue);
                }
                byteArray = retStr.getBytes();
                response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
            } else if (action.equalsIgnoreCase("GET_DOCUMENT")) {
                FileInputStream inputFileInputStream;
                BaseLogger.log("2", null, null, "**** DNYANESHWAR **** download contents ");
                docId = request.getParameter("DOC_ID");
                String docType = request.getParameter("DOC_TYPE");
                String module = request.getParameter("MODULE");
                try {
                    inputStream = this.getDocumentInputStream(docId, tranDBValue, userInformation, module);
                }
                catch (Throwable e) {
                    BaseLogger.log("0", null, null, "Trying to download Document using getDocumentFile ...");
                    e.printStackTrace();
                    if (!"true".equals(noExtract)) {
                        String fileName = docHandler.getDocumentFile(docId, tranDBValue);
                        fileToDownload = new File(fileName);
                    } else {
                        this.getDocument(docId, response, userInformation);
                        isResponseWritten = true;
                    }
                    byteArray = null;
                }
                BaseLogger.log("3", null, null, "docType [" + docType + "]");
                String fileName = docHandler.getDocumentName(docId, tranDBValue);
                BaseLogger.log("3", null, null, " fileName of Downloaded document[" + fileName + "]docId[" + docId + "]");
                response.setHeader("Content-disposition", "filename = \"" + fileName + "\"");
                if (this.checkNull(docType).length() == 0) {
                    docType = fileName.substring(fileName.lastIndexOf(".") + 1);
                }
                BaseLogger.log("3", null, null, "docType - [" + docType + "]");
                if (docType.equalsIgnoreCase("pdf")) {
                    response.setContentType("application/pdf; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("bmp")) {
                    response.setContentType("image/bmp");
                } else if (docType.equalsIgnoreCase("txt") || docType.equalsIgnoreCase("dtd") || docType.equalsIgnoreCase("java") || docType.equalsIgnoreCase("csv")) {
                    response.setContentType("text/plain; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("html") || docType.equalsIgnoreCase("htm")) {
                    response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("doc") || docType.equalsIgnoreCase("odt") || docType.equalsIgnoreCase("docx")) {
                    response.setContentType("application/msword; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("xls")) {
                    response.setContentType("application/msexcel; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("gif")) {
                    response.setContentType("image/gif");
                } else if (docType.equalsIgnoreCase("ai")) {
                    response.setContentType("application/postscript; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("abs")) {
                    response.setContentType("audio/x-mpeg");
                } else if (docType.equalsIgnoreCase("bin") || docType.equalsIgnoreCase("exe")) {
                    response.setContentType("application/octet-stream; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("class")) {
                    response.setContentType("application/java; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("jpe") || docType.equalsIgnoreCase("jpg") || docType.equalsIgnoreCase("jpeg")) {
                    response.setContentType("image/jpeg");
                } else if (docType.equalsIgnoreCase("mpg") || docType.equalsIgnoreCase("mpeg")) {
                    response.setContentType("video/mpeg");
                } else if (docType.equalsIgnoreCase("pic") || docType.equalsIgnoreCase("pict") || docType.equalsIgnoreCase("pict")) {
                    response.setContentType("image/pict");
                } else if (docType.equalsIgnoreCase("aif") || docType.equalsIgnoreCase("aifc") || docType.equalsIgnoreCase("aiff")) {
                    response.setContentType("audio/x-aiff");
                } else if (docType.equalsIgnoreCase("aim")) {
                    response.setContentType("application/x-aim");
                } else if (docType.equalsIgnoreCase("art")) {
                    response.setContentType("image/x-jg");
                } else if (docType.equalsIgnoreCase("asf") || docType.equalsIgnoreCase("asx")) {
                    response.setContentType("video/x-ms-asf");
                } else if (docType.equalsIgnoreCase("avi")) {
                    response.setContentType("video/x-msvideo");
                } else if (docType.equalsIgnoreCase("avx")) {
                    response.setContentType("video/x-rad-screenplay");
                } else if (docType.equalsIgnoreCase("body")) {
                    response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("css")) {
                    response.setContentType("text/css; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("dib")) {
                    response.setContentType("image/bmp");
                } else if (docType.equalsIgnoreCase("gz")) {
                    response.setContentType("application/x-gzip");
                } else if (docType.equalsIgnoreCase("jar")) {
                    response.setContentType("application/java-archive");
                } else if (docType.equalsIgnoreCase("js")) {
                    response.setContentType("text/javascript; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("midi")) {
                    response.setContentType("audio/x-midi");
                } else if (docType.equalsIgnoreCase("rtf")) {
                    response.setContentType("application/rtf");
                } else if (docType.equalsIgnoreCase("rtx")) {
                    response.setContentType("text/richtext; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("tif") || docType.equalsIgnoreCase("tiff")) {
                    response.setContentType("image/tiff");
                } else if (docType.equalsIgnoreCase("xml") || docType.equalsIgnoreCase("xsl")) {
                    response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                } else if (docType.equalsIgnoreCase("zip")) {
                    response.setContentType("application/zip");
                    if (!"true".equals(noExtract)) {
                        String destFilePath;
                        File destFolder;
                        String extractZipPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "extractedFiles";
                        BaseLogger.log("3", null, null, "downloading zip.. in " + extractZipPath);
                        File extractZipFld = new File(extractZipPath);
                        if (extractZipFld != null && !extractZipFld.exists()) {
                            extractZipFld.mkdir();
                            BaseLogger.log("3", null, null, "Folder created :" + extractZipFld.getName() + " at " + extractZipPath);
                        }
                        if ((destFolder = new File(destFilePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + extractZipFld.getName() + File.separator + docId + File.separator)) != null && !destFolder.exists()) {
                            destFolder.mkdir();
                            BaseLogger.log("3", null, null, "Folder created :" + destFolder.getName() + " at " + destFilePath);
                        }
                        String downloadedZipPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + extractZipFld.getName() + File.separator + docId + "." + docType;
                        BaseLogger.log("3", null, null, " downloadedZipPath [" + downloadedZipPath + "]");
                        FileOutputStream fos = new FileOutputStream(downloadedZipPath);
                        if (inputStream != null) {
                            E12GenericUtility.copy(inputStream, fos);
                        } else {
                            BaseLogger.log("3", null, null, "else if docType == zip :: downloadedFile :" + fileToDownload);
                            if (fileToDownload != null && fileToDownload.exists()) {
                                BaseLogger.log("3", null, null, "Writing file to :" + downloadedZipPath);
                                FileInputStream inputFileInputStream2 = new FileInputStream(fileToDownload);
                                IOUtils.copy((InputStream)inputFileInputStream2, (OutputStream)fos);
                                inputFileInputStream2.close();
                                fos.flush();
                                isResponseWritten = true;
                            }
                        }
                        fos.close();
                        if (destFolder != null && destFolder.isDirectory()) {
                            int noOfFiles = destFolder.listFiles() != null ? destFolder.listFiles().length : 0;
                            BaseLogger.log("3", null, null, "NoOFFiles in downloadedZipPath : " + noOfFiles + "]");
                            if (noOfFiles == 0) {
                                new ExtractZipFiles(downloadedZipPath, destFilePath);
                            }
                        }
                    }
                    BaseLogger.log("3", null, null, "*********** byteArray [" + byteArray + "]");
                    outputStream = response.getOutputStream();
                    if (inputStream != null) {
                        inputStream.close();
                        inputStream = this.getDocumentInputStream(docId, tranDBValue, userInformation, module);
                        response.setContentLength(inputStream.available());
                        E12GenericUtility.copy(inputStream, (OutputStream)response.getOutputStream());
                        inputStream.close();
                        isResponseWritten = true;
                    } else {
                        BaseLogger.log("3", null, null, "*********** byteArray is null :: downloadedFile :" + fileToDownload);
                        if (fileToDownload != null && fileToDownload.exists()) {
                            inputFileInputStream = new FileInputStream(fileToDownload);
                            E12GenericUtility.copy(inputFileInputStream, (OutputStream)outputStream);
                            inputFileInputStream.close();
                            outputStream.flush();
                            isResponseWritten = true;
                        }
                    }
                    outputStream.close();
                } else if (docType.equalsIgnoreCase("ppt")) {
                    response.setContentType("application/powerpoint");
                } else if (docType.equalsIgnoreCase("ppm")) {
                    response.setContentType("image/x-portable-pixmap");
                } else if (docType.equalsIgnoreCase("png")) {
                    response.setContentType("image/png");
                } else if (docType.equalsIgnoreCase("oda")) {
                    response.setContentType("application/oda");
                } else {
                    BaseLogger.log("3", null, null, "Setting ContentType application/octet-stream for " + docType);
                    response.setContentType("application/octet-stream; charset=" + CommonConstants.ENCODING);
                }
                BaseLogger.log("3", null, null, "598 :: downloadedFile :" + fileToDownload + " isResponseWritten : " + isResponseWritten);
                if (!"zip".equalsIgnoreCase(docType) && fileToDownload != null && fileToDownload.exists() && !isResponseWritten) {
                    BaseLogger.log("3", null, null, "Writing Large Size non-zip file on outputStream :" + !isResponseWritten);
                    inputFileInputStream = new FileInputStream(fileToDownload);
                    outputStream = response.getOutputStream();
                    IOUtils.copy((InputStream)inputFileInputStream, (OutputStream)outputStream);
                    inputFileInputStream.close();
                    outputStream.flush();
                    outputStream.close();
                    fileToDownload.delete();
                    isResponseWritten = true;
                } else if ("zip".equalsIgnoreCase(docType) && !"true".equals(noExtract) && !isResponseWritten) {
                    BaseLogger.log("3", null, null, "Writing Large Size zip file on outputStream :" + !isResponseWritten);
                    BaseLogger.log("3", null, null, "Setting response as true in case of Large Size zip file...");
                    outputStream = response.getOutputStream();
                    outputStream.write("true".getBytes());
                    outputStream.flush();
                    outputStream.close();
                    isResponseWritten = true;
                }
                if (!isResponseWritten) {
                    inputStream.close();
                    inputStream = this.getDocumentInputStream(docId, tranDBValue, userInformation, module);
                    if ("true".equalsIgnoreCase(viewer)) {
                        byteArray = IOUtils.toByteArray((InputStream)inputStream);
                    } else {
                        ServletOutputStream servletOutputStream = response.getOutputStream();
                        response.setHeader("Content-length", String.valueOf(inputStream.available()));
                        E12GenericUtility.copy(inputStream, (OutputStream)servletOutputStream);
                        isResponseWritten = true;
                    }
                    inputStream.close();
                    inputStream = null;
                }
            } else if ("GET_PREVIEW_IMAGE".equals(action)) {
                try {
                    docId = request.getParameter("DOC_ID");
                    BaseLogger.log("3", null, null, "DocumentViewerServlet :: handleDocument() : GET_VIDEO_FRAME : docID [" + docId + "]");
                    byteArray = docId == null || "".equals(docId.trim()) ? new byte[1] : ((byteArray = this.getVideoFrame(docId, userInformation)) == null ? new byte[1] : byteArray);
                    response.setContentType("image/png");
                }
                catch (Exception ex) {
                    BaseLogger.log("0", null, null, "Exception in DocumentViewerServlet :: handleDocument() : " + ex);
                    ex.printStackTrace();
                }
            }
            if ("WEB".equalsIgnoreCase(client)) {
                ValidateXMLInput vxi = new ValidateXMLInput();
                String outputFileName = vxi.validate(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "webitm" + File.separator + "xsl" + File.separator + "ITMAttachmentPage.xsl", retStr, String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp", "attach", ".html");
                FileInputStream fis = new FileInputStream(outputFileName);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int i = -1;
                while ((i = fis.read()) != -1) {
                    baos.write(i);
                }
                fis.close();
                byteArray = baos.toByteArray();
            }
            if ("TRUE".equalsIgnoreCase(viewer)) {
                String documentPath = "";
                String filePathTemp = "";
                String fileName = "";
                String docId2 = "";
                String sessionId = null;
                UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                String userId = "";
                if (userInfo != null) {
                    userId = userInfo.getLoginCode();
                }
                if (byteArray != null) {
                    try {
                        docId2 = request.getParameter("DOC_ID");
                        fileName = docHandler.getDocumentName(docId2, tranDBValue);
                        sessionId = request.getSession().getId();
                        filePathTemp = "temp" + File.separator + userId + sessionId;
                        documentPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + filePathTemp;
                        File outFile = new File(documentPath);
                        if (!outFile.exists()) {
                            outFile.mkdir();
                        }
                        if (!fileName.equals("")) {
                            String filePathStr = String.valueOf(documentPath) + File.separator + fileName;
                            BaseLogger.log("3", userInfo, null, "filePathStr = " + filePathStr);
                            outFile = new File(filePathStr);
                            FileOutputStream fout = new FileOutputStream(outFile);
                            IOUtils.write((byte[])byteArray, (OutputStream)fout);
                            fout.close();
                        } else {
                            BaseLogger.log("3", userInfo, null, "Document Name is empty.");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                filePathTemp = String.valueOf(filePathTemp) + File.separator + fileName;
                BaseLogger.log("3", userInfo, null, "filePathTemp Return = " + filePathTemp);
                request.setCharacterEncoding(CommonConstants.ENCODING);
                response.setContentType("text/plain");
                byteArray = filePathTemp.getBytes();
            }
            BaseLogger.log("3", null, null, "isResponseWritten :" + isResponseWritten);
            if (!isResponseWritten) {
                response.setBufferSize(byteArray.length);
                outputStream = response.getOutputStream();
                outputStream.write(byteArray);
                outputStream.flush();
                outputStream.close();
            }
            dbAccess = null;
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DocumentViewerServlet :handleDocument :==>");
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    private byte[] getVideoFrame(String docId, UserInfoBean userInfo) {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        InputStream inputStream = null;
        byte[] iconByteArray = new byte[1];
        try {
            try {
                String sql = "SELECT ICON FROM DOC_CONTENTS WHERE DOC_ID = " + docId;
                BaseLogger.log("3", userInfo, null, "DocumentViewerServlet :: getVideoFrame() : sql [" + sql + "]");
                String transDB = userInfo.getTransDB();
                conn = new ConnDriver().getConnectDB(transDB);
                st = conn.createStatement();
                rs = st.executeQuery(sql);
                if (rs.next() && (inputStream = rs.getBinaryStream(1)) != null) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int i = 0;
                    while ((i = inputStream.read()) != -1) {
                        byteArrayOutputStream.write(i);
                    }
                    iconByteArray = byteArrayOutputStream.toByteArray();
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", userInfo, null, "Exception in DocumentViewerServlet :: getVideoFrame() : " + ex);
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (st != null) {
                    st.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
        return iconByteArray;
    }

    private String getRefSer(HttpServletRequest request) throws Exception {
        String objName;
        String refSer = null;
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        refSer = request.getParameter("REF_SER");
        if ((refSer == null || "null".equals(refSer)) && (objName = request.getParameter("OBJ_NAME")) != null && !"null".equals(objName) && objName.length() > 0) {
            DBAccessEJB dbAccess = new DBAccessEJB();
            refSer = dbAccess.getRefSer(null, objName, userInfo);
            dbAccess = null;
        }
        return refSer;
    }

    private InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DocumentViewerServlet :getInitialContext :==>");
            throw new ITMException(e);
        }
        return ctx;
    }

    private void getDocument(String docId, HttpServletResponse response, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection conn = null;
        Statement mPstmt = null;
        try {
            try {
                conn = this.getConnection(userInfo);
                String selQry = "SELECT DOC_OBJECT FROM DOC_CONTENTS WHERE DOC_ID =?";
                BaseLogger.log("3", userInfo, null, "selectQry :" + selQry);
                mPstmt = conn.prepareStatement(selQry);
                mPstmt.setString(1, docId);
                ResultSet rs = mPstmt.executeQuery();
                if (rs.next()) {
                    Blob blobData = rs.getBlob("DOC_OBJECT");
                    InputStream is = blobData.getBinaryStream();
                    int chunkSize = ((BLOB)blobData).getChunkSize();
                    if (is != null) {
                        response.setBufferSize(chunkSize);
                        ServletOutputStream bos = response.getOutputStream();
                        IOUtils.copyLarge((InputStream)is, (OutputStream)bos);
                        bos.flush();
                        bos.close();
                    }
                    is.close();
                }
                rs.close();
                mPstmt.close();
                mPstmt = null;
            }
            catch (SQLException ie) {
                BaseLogger.log("0", userInfo, null, "SQLException :DocumentHandlerEJB :getDocument:==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerEJB :getDocument :==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
    }

    public Connection getConnection(UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection conn = null;
        try {
            BaseLogger.log("3", userInfo, null, "IN getConnection METHOD");
            ConnDriver connDriver = null;
            connDriver = new ConnDriver();
            conn = connDriver.getConnectDB(userInfo.getTransDB());
            conn.setAutoCommit(false);
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : [DocumentHandlerEJB][getConnection] :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return conn;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    public String getValueFromDocXml(String xmlStr, String fieldName) {
        String fieldValue = "";
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            if (xmlStr != null && xmlStr.length() > 0) {
                Document dom = genericUtility.parseString(xmlStr);
                NodeList groupNodeList = dom.getElementsByTagName(fieldName);
                int groupLen = groupNodeList.getLength();
                int groupCntr = 0;
                while (groupCntr < groupLen) {
                    Node groupNode = groupNodeList.item(groupCntr);
                    fieldValue = groupNode.hasAttributes() ? groupNode.getAttributes().getNamedItem("Document_Id").getNodeValue() : (groupNode.getFirstChild() != null ? groupNode.getFirstChild().getNodeValue() : groupNode.getNodeValue());
                    BaseLogger.log("3", null, null, String.valueOf(fieldName) + " response receive fieldValue : " + fieldValue);
                    ++groupCntr;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getValueFromDocXml : " + e.getMessage());
            e.printStackTrace();
        }
        return fieldValue;
    }

    private byte[] getDocument(String docId, String transDB, UserInfoBean userInfo, DocumentHandlerRemote docHandler) throws ITMException {
        byte[] resByte = new byte[1];
        try {
            if (CommonConstants.CONTENT_MGMT != null && CommonConstants.CONTENT_MGMT_HOME != null) {
                userInfo.setTransDB(transDB);
                String requestURL = String.valueOf(CommonConstants.CONTENT_MGMT_HOME) + "/ibase/rest/E12ExtService/getDocument";
                CloseableHttpClient client = HttpClients.createDefault();
                HttpPost httpPost = new HttpPost(requestURL);
                ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
                urlParameters.add(new BasicNameValuePair("DOC_ID", docId));
                urlParameters.add(new BasicNameValuePair("USER_INFO", userInfo.toString()));
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
                CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
                BaseLogger.log("3", userInfo, null, "StatusCode : [" + httpResponse.getStatusLine().getStatusCode() + "], ReasonPhrase : [" + httpResponse.getStatusLine().getReasonPhrase() + "]");
                HttpEntity responseEntity = httpResponse.getEntity();
                InputStream in = responseEntity.getContent();
                resByte = IOUtils.toByteArray((InputStream)in);
                in.close();
                client.close();
            } else {
                resByte = docHandler.getDocument(docId, userInfo);
            }
        }
        catch (UnsupportedEncodingException e) {
            BaseLogger.log("0", userInfo, null, "getDocument :: UnsupportedEncodingException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            BaseLogger.log("0", userInfo, null, "getDocument :: ClientProtocolException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (UnsupportedOperationException e) {
            BaseLogger.log("0", userInfo, null, "getDocument :: UnsupportedOperationException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (IOException e) {
            BaseLogger.log("0", userInfo, null, "getDocument :: IOException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return resByte;
    }

    public InputStream getDocumentInputStream(String docId, String transDB, UserInfoBean userInfo, String module) throws RemoteException, ITMException {
        InputStream documentInputStream = null;
        try {
            DocumentHandlerEJB documentHandlerEJB = new DocumentHandlerEJB();
            documentInputStream = documentHandlerEJB.getDocumentInputStream(docId, transDB, userInfo, module, "UDC");
        }
        catch (Exception ex) {
            BaseLogger.log("0", userInfo, null, "DocumentViewerServlet.getDocumentInputStream() :: Exception in getDocumentInputStream()");
            throw new ITMException(ex);
        }
        return documentInputStream;
    }
}

