package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;



import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;


public class CustomerSurveyPos extends ValidatorEJB implements RealTimeReportPosRemote, RealTimeReportPosLocal
{
	
	private E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

	public CustomerSurveyPos()
	{
		
	}
	protected static String database = CommonConstants.DB_NAME;

	public String postSave() throws RemoteException, ITMException
	{
		return "";
	}

	public String postSave(String tranId, String editFlag, String xtraParams, Connection conn, String domString) throws RemoteException, ITMException
	{
		String resString="";
		String retString = "";
		boolean isError = false;
		boolean isLocalConn = false;
		Document dom = null;
		String loginCode = "";
		try
		{
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println("xmlStringAll::"+domString);
			dom = genericUtility.parseString(domString);



			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();

			String actType = checkNull(genericUtility.getColumnValue("activity_type", dom, "1"));
			String salesPers = checkNull(genericUtility.getColumnValue( "sales_pers", dom, "1" ));
			String eventDate = checkNull(genericUtility.getColumnValue( "event_date", dom, "1" ));

			if ( "FW".equalsIgnoreCase( actType.trim() ) )
			{
				if(salesPers != null && eventDate != null)
				{
					String dcrid = getDCRId(conn, salesPers, eventDate);
					updateStrgSurveyRes( dom, dcrid.trim(), conn);

				}
			}

			//Added by Mrunalini SInkar to update old table data(end)
		}
		catch (Exception e)
		{
			System.out.println("Exception  :==>\n" + e.getMessage());
			throw new ITMException(e);
		} finally
		{
			try
			{
				System.out.println("isError [" + isError + "]");
				System.out.println("isLocalConn [" + isLocalConn + "]");
				if (conn != null)
				{
					if (isLocalConn)
					{
						/*if (!isError)
						{
							conn.commit();
						}*/
						conn.close();
						conn = null;
					}

				}
			}
			catch (Exception e)
			{
				System.out.println("Exception :==>\n" + e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return string :" + retString);
		return resString;
	}

	

	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}


	private String getDCRId(Connection conn, String salesPers, String dcrDate) throws Exception
	{
		String dcrID = "";
		PreparedStatement pstmtDCRID = null;
		ResultSet rsDCRID = null;
		try
		{
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String dcrSql = "SELECT DISTINCT DCR_ID FROM STRG_MEET A, FIELDACTIVITY B WHERE A.EVENT_TYPE = B.ACTIVITY_CODE AND A.EVENT_DATE = ? AND A.SALES_PERS = ? AND B.ACTIVITY_TYPE <>'PR'" ;

			pstmtDCRID = conn.prepareStatement( dcrSql );
			pstmtDCRID.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtDCRID.setString(2, salesPers);
			rsDCRID = pstmtDCRID.executeQuery();
			if( rsDCRID.next() )
			{
				dcrID = (rsDCRID.getString("DCR_ID") == null )?"":rsDCRID.getString("DCR_ID");
			}
			if (rsDCRID != null)
			{
				rsDCRID.close();
				rsDCRID = null;
			}
			if(pstmtDCRID !=null)
			{
				pstmtDCRID.close();
				pstmtDCRID = null;
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsDCRID != null)
				{
					rsDCRID.close();
					rsDCRID = null;
				}
				if(pstmtDCRID !=null)
				{
					pstmtDCRID.close();
					pstmtDCRID = null;
				}
			}
			catch(Exception e1){}
		}
		System.out.println("dcrID =["+dcrID+"]");
		return dcrID;
	}

	
	private void updateStrgSurveyRes( Document dom, String dcrId, Connection conn ) throws Exception
	{
		int updCnt = 0;
		PreparedStatement pstmt = null;
		String formNo = "";
		String updateFlag = "";
		try
		{
			String updSurveySql = " UPDATE STRG_SURV_RES SET RESULT = ? WHERE DCR_ID = ? AND STRG_CODE = ? AND SURVEY_CODE = ? ";
			pstmt = conn.prepareStatement( updSurveySql );

			String objName = getObjNameFromDom( dom, "objName" , 1);
			String winName = "w_"+objName;

			String objFormSql= "SELECT FORM_NAME, FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN('survey') ";
			PreparedStatement pstmtForm = conn.prepareStatement(objFormSql);
			pstmtForm.setString(1, winName);
			ResultSet rsForm = pstmtForm.executeQuery();
			while(rsForm.next())
			{
				formNo = checkNull(rsForm.getString("FORM_NO"));
			}
			if(rsForm != null)
			{
				rsForm.close();
				rsForm = null;
			}
			if(pstmtForm != null)
			{
				pstmtForm.close();
				pstmtForm = null;
			}
			//Getting the survey detail list and update the result value :START
			Node currDetail = null;
			NodeList detail8List = null;
			NodeList currDetailList = null;
			detail8List = dom.getElementsByTagName("Detail"+formNo);
			int detailListLength = detail8List.getLength();

			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				String surveyCode = "";
				String resultType = "";
				String result1 = "";
				String result2 = "";
				String result3 = "";
				String result4 = "";		//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
				String result5 = "";
				String strgCode = "";
				String resultFormat = "";	//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]

				currDetail = detail8List.item(ctr);
				currDetailList = currDetail.getChildNodes();
				int currDetailListLength = currDetailList.getLength();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					String childNodeName = childNode.getNodeName();
					System.out.println("childNodeName :: ["+childNodeName+"]");
					/*if(childNode.getAttributes().getNamedItem("selected") != null)
					{*/
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							//System.out.println("updateFlag :: ["+updateFlag+"]");
						}
					}
					/*if(!updateFlag.equalsIgnoreCase("D"))
					{
						childNode = childList.item(ctr);
						if(childNode.getFirstChild() != null)
						{
								flg=false;
								break;
						}
					}*/
					else if (childNodeName.equalsIgnoreCase("survey_code"))
					{
						if(childNode.getFirstChild() != null)
						{
							surveyCode = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("surveyCode::::===="+surveyCode);
						}
					}
					else if (childNodeName.equalsIgnoreCase("result_type"))
					{
						if(childNode.getFirstChild() != null)
						{
							resultType = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("resultType::::===="+resultType);
						}
					}
					//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]START
					else if (childNodeName.equalsIgnoreCase("result_format"))
					{
						if(childNode.getFirstChild() != null)
						{
							resultFormat = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]END
					else if (childNodeName.equalsIgnoreCase("result1"))
					{
						if(childNode.getFirstChild() != null)
						{
							result1 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result1::::===="+result1);
						}
					}
					else if (childNodeName.equalsIgnoreCase("result2"))
					{
						if(childNode.getFirstChild() != null)
						{
							result2 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result2::::===="+result2);
						}
					}
					else if (childNodeName.equalsIgnoreCase("result3"))
					{
						if(childNode.getFirstChild() != null)
						{
							result3 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result3::::===="+result3);
						}
					}
					//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]START
					else if (childNodeName.equalsIgnoreCase("result4"))
					{
						if(childNode.getFirstChild() != null)
						{
							result4 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result4::::===="+result4);
						}
					}
					//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]END
					//Added by Pooja S on 10/02/20 [Mini meethas related implementation] START
					else if (childNodeName.equalsIgnoreCase("result5"))
					{
						if(childNode.getFirstChild() != null)
						{
							result5 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result5::::===="+result5);
						}
					}
					//Added by Pooja S on 10/02/20 [Mini meethas related implementation] END
					else if (childNodeName.equalsIgnoreCase("strg_code"))
					{
						if(childNode.getFirstChild() != null)
						{

							strgCode = childNode.getFirstChild().getNodeValue().trim();
						}
					}
				}
				if(!updateFlag.equalsIgnoreCase("D") && !"A".equalsIgnoreCase(resultType))
				{
					if("N".equalsIgnoreCase(resultType))
					{
						if(result1 == null || result1.trim().length() == 0)
						{
							result1 = "NA";
						}
						pstmt.setString(1, result1);
					}
					else if("L".equalsIgnoreCase(resultType) && "D".equalsIgnoreCase(resultFormat))
					{
						if(result4 == null || result4.trim().length() == 0)
						{
							result4 = "NA";
						}
						pstmt.setString(1, result4);
					}
					else if("D".equalsIgnoreCase(resultType) || "L".equalsIgnoreCase(resultType))
					{
						if(result2 == null || result2.trim().length() == 0)
						{
							result2 = "NA";
						}
						pstmt.setString(1, result2);
					}
					else if("T".equalsIgnoreCase(resultType))
					{
						if(result3 == null || result3.trim().length() == 0)
						{
							result3 = "NA";
						}
						pstmt.setString(1, result3);
					}
					else
					{
						if(result3 == null || result3.trim().length() == 0)
						{
							result3 = "NA";
						}
						pstmt.setString(1, result3);
					}
					pstmt.setString(2, dcrId);
					pstmt.setString(3, strgCode);
					pstmt.setString(4, surveyCode);

					updCnt = pstmt.executeUpdate();
					pstmt.clearParameters();
				}
			}
			
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
	}
	
	public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				break;

			}
			if(objName == null || objName.trim().length() == 0)
			{
				NodeList objNameList = dom.getElementsByTagName("objName");
				if(objNameList != null && objNameList.getLength() > 0)
				{
					Node objNameNode = objNameList.item(0);
					if(objNameNode != null && objNameNode.getFirstChild() != null)
					{
						objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return objName;
	}
}